import { ChtmlFontData } from '@mathjax/src/mjs/output/chtml/FontData.js';
import { CommonMathJaxNewcmFontMixin } from './common.js';
import { normal } from './chtml/normal.js';
import { bold } from './chtml/bold.js';
import { italic } from './chtml/italic.js';
import { boldItalic } from './chtml/bold-italic.js';
import { doubleStruck } from './chtml/double-struck.js';
import { fraktur } from './chtml/fraktur.js';
import { frakturBold } from './chtml/fraktur-bold.js';
import { sansSerif } from './chtml/sans-serif.js';
import { sansSerifBold } from './chtml/sans-serif-bold.js';
import { sansSerifItalic } from './chtml/sans-serif-italic.js';
import { sansSerifBoldItalic } from './chtml/sans-serif-bold-italic.js';
import { monospace } from './chtml/monospace.js';
import { smallop } from './chtml/smallop.js';
import { largeop } from './chtml/largeop.js';
import { size3 } from './chtml/size3.js';
import { size4 } from './chtml/size4.js';
import { size5 } from './chtml/size5.js';
import { size6 } from './chtml/size6.js';
import { size7 } from './chtml/size7.js';
import { texMathit } from './chtml/tex-mathit.js';
import { texCalligraphic } from './chtml/tex-calligraphic.js';
import { texCalligraphicBold } from './chtml/tex-calligraphic-bold.js';
import { texOldstyle } from './chtml/tex-oldstyle.js';
import { texOldstyleBold } from './chtml/tex-oldstyle-bold.js';
import { texVariant } from './chtml/tex-variant.js';
import { lfTp } from './chtml/lf-tp.js';
import { rtBt } from './chtml/rt-bt.js';
import { exMd } from './chtml/ex-md.js';
import { bbold } from './chtml/bbold.js';
import { upsmall } from './chtml/upsmall.js';
import { uplarge } from './chtml/uplarge.js';
import { script } from './chtml/script.js';
import { scriptBold } from './chtml/script-bold.js';
import { delimiters } from './chtml/delimiters.js';
const Base = CommonMathJaxNewcmFontMixin(ChtmlFontData);
export class MathJaxNewcmFont extends Base {
    constructor() {
        super(...arguments);
        this.cssFontPrefix = 'NCM';
    }
}
MathJaxNewcmFont.NAME = 'MathJaxNewcm';
MathJaxNewcmFont.OPTIONS = Object.assign(Object.assign({}, Base.OPTIONS), { fontURL: '@mathjax/mathjax-newcm-font/js/chtml/woff2', dynamicPrefix: '@mathjax/mathjax-newcm-font/js/chtml/dynamic' });
MathJaxNewcmFont.defaultCssFamilyPrefix = 'MJX-NCM-ZERO';
MathJaxNewcmFont.defaultVariantLetters = {
    'normal': '',
    'bold': 'B',
    'italic': 'I',
    'bold-italic': 'BI',
    'double-struck': 'DS',
    'fraktur': 'F',
    'bold-fraktur': 'FB',
    'sans-serif': 'SS',
    'bold-sans-serif': 'SSB',
    'sans-serif-italic': 'SSI',
    'sans-serif-bold-italic': 'SSBI',
    'monospace': 'M',
    '-smallop': 'SO',
    '-largeop': 'LO',
    '-size3': 'S3',
    '-size4': 'S4',
    '-size5': 'S5',
    '-size6': 'S6',
    '-size7': 'S7',
    '-tex-mathit': 'MI',
    '-tex-calligraphic': 'C',
    '-tex-bold-calligraphic': 'CB',
    '-tex-oldstyle': 'OS',
    '-tex-bold-oldstyle': 'OB',
    '-tex-variant': 'V',
    '-lf-tp': 'LT',
    '-rt-bt': 'RB',
    '-ex-md': 'EM',
    '-bbold': 'Be',
    '-upsmall': 'U',
    '-uplarge': 'Ue',
    'script': 'S',
    'bold-script': 'SB'
};
MathJaxNewcmFont.defaultDelimiters = delimiters;
MathJaxNewcmFont.defaultChars = {
    'normal': normal,
    'bold': bold,
    'italic': italic,
    'bold-italic': boldItalic,
    'double-struck': doubleStruck,
    'fraktur': fraktur,
    'bold-fraktur': frakturBold,
    'sans-serif': sansSerif,
    'bold-sans-serif': sansSerifBold,
    'sans-serif-italic': sansSerifItalic,
    'sans-serif-bold-italic': sansSerifBoldItalic,
    'monospace': monospace,
    '-smallop': smallop,
    '-largeop': largeop,
    '-size3': size3,
    '-size4': size4,
    '-size5': size5,
    '-size6': size6,
    '-size7': size7,
    '-tex-mathit': texMathit,
    '-tex-calligraphic': texCalligraphic,
    '-tex-bold-calligraphic': texCalligraphicBold,
    '-tex-oldstyle': texOldstyle,
    '-tex-bold-oldstyle': texOldstyleBold,
    '-tex-variant': texVariant,
    '-lf-tp': lfTp,
    '-rt-bt': rtBt,
    '-ex-md': exMd,
    '-bbold': bbold,
    '-upsmall': upsmall,
    '-uplarge': uplarge,
    'script': script,
    'bold-script': scriptBold
};
MathJaxNewcmFont.defaultStyles = Object.assign(Object.assign({}, ChtmlFontData.defaultStyles), { 'mjx-container[jax="CHTML"] > mjx-math.NCM-N[breakable] > *': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-N'
    }, '.NCM-N': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-N'
    }, '.NCM-B': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-B'
    }, '.NCM-I': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-I'
    }, '.NCM-BI': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-BI'
    }, '.NCM-DS': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-DS'
    }, '.NCM-F': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-F'
    }, '.NCM-FB': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-FB'
    }, '.NCM-SS': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-SS'
    }, '.NCM-SSB': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-SSB'
    }, '.NCM-SSI': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-SSI'
    }, '.NCM-SSBI': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-SSBI'
    }, '.NCM-M': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-M'
    }, '.NCM-SO': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-SO'
    }, '.NCM-LO': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-LO'
    }, '.NCM-S3': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-S3'
    }, '.NCM-S4': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-S4'
    }, '.NCM-S5': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-S5'
    }, '.NCM-S6': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-S6'
    }, '.NCM-S7': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-S7'
    }, '.NCM-MI': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-MI'
    }, '.NCM-C': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-C'
    }, '.NCM-CB': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-CB'
    }, '.NCM-OS': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-OS'
    }, '.NCM-OB': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-OB'
    }, '.NCM-V': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-V'
    }, '.NCM-LT': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-LT'
    }, '.NCM-RB': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-RB'
    }, '.NCM-EM': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-EM'
    }, '.NCM-Be': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-Be'
    }, '.NCM-U': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-U'
    }, '.NCM-Ue': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-Ue'
    }, '.NCM-S': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-S'
    }, '.NCM-SB': {
        'font-family': 'MJX-NCM-ZERO, MJX-NCM-SB'
    } });
MathJaxNewcmFont.defaultFonts = Object.assign(Object.assign({}, ChtmlFontData.defaultFonts), { '@font-face /* MJX-NCM-ZERO */': {
        'font-family': 'MJX-NCM-ZERO',
        src: 'url("%%URL%%/mjx-ncm-zero.woff2") format("woff2")'
    }, '@font-face /* MJX-BRK */': {
        'font-family': 'MJX-BRK',
        src: 'url("%%URL%%/mjx-ncm-brk.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-N */': {
        'font-family': 'MJX-NCM-N',
        src: 'url("%%URL%%/mjx-ncm-n.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-B */': {
        'font-family': 'MJX-NCM-B',
        src: 'url("%%URL%%/mjx-ncm-b.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-I */': {
        'font-family': 'MJX-NCM-I',
        src: 'url("%%URL%%/mjx-ncm-i.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-BI */': {
        'font-family': 'MJX-NCM-BI',
        src: 'url("%%URL%%/mjx-ncm-bi.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-DS */': {
        'font-family': 'MJX-NCM-DS',
        src: 'url("%%URL%%/mjx-ncm-ds.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-F */': {
        'font-family': 'MJX-NCM-F',
        src: 'url("%%URL%%/mjx-ncm-f.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-FB */': {
        'font-family': 'MJX-NCM-FB',
        src: 'url("%%URL%%/mjx-ncm-fb.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-SS */': {
        'font-family': 'MJX-NCM-SS',
        src: 'url("%%URL%%/mjx-ncm-ss.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-SSB */': {
        'font-family': 'MJX-NCM-SSB',
        src: 'url("%%URL%%/mjx-ncm-ssb.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-SSI */': {
        'font-family': 'MJX-NCM-SSI',
        src: 'url("%%URL%%/mjx-ncm-ssi.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-SSBI */': {
        'font-family': 'MJX-NCM-SSBI',
        src: 'url("%%URL%%/mjx-ncm-ssbi.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-M */': {
        'font-family': 'MJX-NCM-M',
        src: 'url("%%URL%%/mjx-ncm-m.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-SO */': {
        'font-family': 'MJX-NCM-SO',
        src: 'url("%%URL%%/mjx-ncm-so.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-LO */': {
        'font-family': 'MJX-NCM-LO',
        src: 'url("%%URL%%/mjx-ncm-lo.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-S3 */': {
        'font-family': 'MJX-NCM-S3',
        src: 'url("%%URL%%/mjx-ncm-s3.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-S4 */': {
        'font-family': 'MJX-NCM-S4',
        src: 'url("%%URL%%/mjx-ncm-s4.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-S5 */': {
        'font-family': 'MJX-NCM-S5',
        src: 'url("%%URL%%/mjx-ncm-s5.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-S6 */': {
        'font-family': 'MJX-NCM-S6',
        src: 'url("%%URL%%/mjx-ncm-s6.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-S7 */': {
        'font-family': 'MJX-NCM-S7',
        src: 'url("%%URL%%/mjx-ncm-s7.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-MI */': {
        'font-family': 'MJX-NCM-MI',
        src: 'url("%%URL%%/mjx-ncm-mi.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-C */': {
        'font-family': 'MJX-NCM-C',
        src: 'url("%%URL%%/mjx-ncm-c.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-CB */': {
        'font-family': 'MJX-NCM-CB',
        src: 'url("%%URL%%/mjx-ncm-cb.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-OS */': {
        'font-family': 'MJX-NCM-OS',
        src: 'url("%%URL%%/mjx-ncm-os.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-OB */': {
        'font-family': 'MJX-NCM-OB',
        src: 'url("%%URL%%/mjx-ncm-ob.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-V */': {
        'font-family': 'MJX-NCM-V',
        src: 'url("%%URL%%/mjx-ncm-v.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-LT */': {
        'font-family': 'MJX-NCM-LT',
        src: 'url("%%URL%%/mjx-ncm-lt.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-RB */': {
        'font-family': 'MJX-NCM-RB',
        src: 'url("%%URL%%/mjx-ncm-rb.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-EM */': {
        'font-family': 'MJX-NCM-EM',
        src: 'url("%%URL%%/mjx-ncm-em.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-Be */': {
        'font-family': 'MJX-NCM-Be',
        src: 'url("%%URL%%/mjx-ncm-be.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-U */': {
        'font-family': 'MJX-NCM-U',
        src: 'url("%%URL%%/mjx-ncm-u.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-Ue */': {
        'font-family': 'MJX-NCM-Ue',
        src: 'url("%%URL%%/mjx-ncm-ue.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-S */': {
        'font-family': 'MJX-NCM-S',
        src: 'url("%%URL%%/mjx-ncm-s.woff2") format("woff2")'
    }, '@font-face /* MJX-NCM-SB */': {
        'font-family': 'MJX-NCM-SB',
        src: 'url("%%URL%%/mjx-ncm-sb.woff2") format("woff2")'
    } });
MathJaxNewcmFont.dynamicFiles = ChtmlFontData.defineDynamicFiles([
    ['latin', {
            'normal': [
                [0xC0, 0xD6], [0xD8, 0xEF], [0xF1, 0xF6], [0xF8, 0x130], [0x132, 0x236], [0x238, 0x24F], [0x1E00, 0x1E9B], 0x1E9E, [0x1EA0, 0x1EF9], 0x2C71
            ]
        }],
    ['latin-b', {
            'bold': [
                [0xC0, 0xD6], [0xD8, 0xEF], [0xF1, 0xF6], [0xF8, 0x130], [0x132, 0x236], [0x238, 0x24F], [0x1E00, 0x1E13], [0x1E18, 0x1E1B], [0x1E1E, 0x1E27], [0x1E2A, 0x1E4B], [0x1E54, 0x1E63], [0x1E68, 0x1E77], [0x1E7C, 0x1E99], 0x1E9B, 0x1E9E, [0x1EA0, 0x1EF9], 0x2C71
            ]
        }],
    ['latin-i', {
            'italic': [
                [0xC0, 0xD6], [0xD8, 0xEF], [0xF1, 0xF6], [0xF8, 0x130], [0x132, 0x236], [0x238, 0x24F], [0x1E00, 0x1E13], [0x1E18, 0x1E1B], [0x1E1E, 0x1E27], [0x1E2A, 0x1E4B], [0x1E54, 0x1E63], [0x1E68, 0x1E77], [0x1E7C, 0x1E99], 0x1E9B, 0x1E9E, [0x1EA0, 0x1EF9]
            ]
        }],
    ['latin-bi', {
            'bold-italic': [
                [0xC0, 0xD6], [0xD8, 0xEF], [0xF1, 0xF6], [0xF8, 0x130], [0x132, 0x236], [0x238, 0x24F], [0x1E00, 0x1E13], [0x1E18, 0x1E1B], [0x1E1E, 0x1E27], [0x1E2A, 0x1E4B], [0x1E54, 0x1E63], [0x1E68, 0x1E77], [0x1E7C, 0x1E99], 0x1E9B, 0x1E9E, [0x1EA0, 0x1EF9]
            ]
        }],
    ['double-struck', {
            'normal': [
                0x2102, 0x210D, 0x2115, 0x2119, 0x211A, 0x211D, 0x2124, [0x213C, 0x2140], [0x2145, 0x2149], 0x1D538, 0x1D539, [0x1D53B, 0x1D53E], [0x1D540, 0x1D544], 0x1D546, [0x1D54A, 0x1D550], [0x1D552, 0x1D56B], [0x1D7D8, 0x1D7E1]
            ],
            'double-struck': [
                0x131, 0x237
            ]
        }],
    ['fraktur', {
            'normal': [
                0x210C, 0x2111, 0x211C, 0x2128, 0x212D, 0x1D504, 0x1D505, [0x1D507, 0x1D50A], [0x1D50D, 0x1D514], [0x1D516, 0x1D51C], [0x1D51E, 0x1D537], [0x1D56C, 0x1D59F]
            ],
            'fraktur': [
                0x131, 0x237
            ],
            'bold-fraktur': [
                0x131, 0x237
            ]
        }],
    ['script', {
            'normal': [
                0x210A, 0x210B, 0x2110, 0x2112, 0x2113, 0x2118, 0x211B, 0x212C, [0x212F, 0x2131], 0x2133, 0x2134, 0x1D49C, 0x1D49E, 0x1D49F, 0x1D4A2, 0x1D4A5, 0x1D4A6, [0x1D4A9, 0x1D4AC], [0x1D4AE, 0x1D4B9], 0x1D4BB, [0x1D4BD, 0x1D4C3], [0x1D4C5, 0x1D503]
            ],
            'script': [],
            'bold-script': []
        }],
    ['sans-serif', {
            'normal': [
                [0x2141, 0x2144], [0x1D5A0, 0x1D66F], [0x1D756, 0x1D7C9], [0x1D7E2, 0x1D7F5]
            ],
            'sans-serif': [
                [0x20, 0x2F], [0x3A, 0x40], [0x5B, 0x60], [0x7B, 0x7E], 0xA0, 0xA3, 0xA5, 0xA7, 0xA8, 0xAC, [0xAF, 0xB1], [0xB4, 0xB7], 0xD7, 0xF0, 0xF7, 0x131, 0x237, 0x2C6, 0x2C7, [0x2C9, 0x2CB], [0x2D8, 0x2DA], 0x2DC, [0x300, 0x308], 0x30A, 0x30C, [0x391, 0x3A1], [0x3A3, 0x3A9], [0x3B1, 0x3C9], 0x3D1, 0x3D2, 0x3D5, 0x3D6, 0x3F0, 0x3F1, [0x3F4, 0x3F6], [0x2010, 0x2014], 0x2016, 0x2018, 0x2019, 0x201C, 0x201D, 0x2020, 0x2021, 0x2026, 0x2044, 0x20AC, 0x2126, 0x2127, [0x2190, 0x2193], 0x2212, 0x221E
            ],
            'bold-sans-serif': [
                0x20, 0x21, [0x23, 0x2F], 0x3A, 0x3B, 0x3D, 0x3F, 0x40, [0x5B, 0x60], [0x7B, 0x7E], 0xA0, 0xA3, 0xA5, 0xA7, 0xA8, 0xAC, [0xAF, 0xB1], [0xB4, 0xB7], 0xD7, 0xF0, 0xF7, 0x131, 0x237, 0x2C6, 0x2C7, [0x2C9, 0x2CB], [0x2D8, 0x2DA], 0x2DC, [0x300, 0x308], 0x30A, 0x30C, 0x3D2, 0x3F6, [0x2010, 0x2014], 0x2016, 0x2018, 0x2019, 0x201C, 0x201D, 0x2020, 0x2021, 0x2026, 0x2044, 0x20AC, 0x2126, 0x2127, [0x2190, 0x2193], 0x2212, 0x221E
            ],
            'sans-serif-italic': [
                [0x20, 0x40], [0x5B, 0x60], [0x7B, 0x7E], 0xA0, 0xA3, 0xA5, 0xA7, 0xA8, 0xAC, [0xAF, 0xB1], [0xB4, 0xB7], 0xD7, 0xF0, 0xF7, 0x131, 0x237, 0x2C6, 0x2C7, [0x2C9, 0x2CB], [0x2D8, 0x2DA], 0x2DC, [0x300, 0x308], 0x30A, 0x30C, [0x391, 0x3A1], [0x3A3, 0x3A9], [0x3B1, 0x3C9], 0x3D1, 0x3D2, 0x3D5, 0x3D6, 0x3F0, 0x3F1, [0x3F4, 0x3F6], [0x2010, 0x2014], 0x2016, 0x2018, 0x2019, 0x201C, 0x201D, 0x2020, 0x2021, 0x2026, 0x2044, 0x20AC, 0x2126, 0x2127, [0x2190, 0x2193], 0x2212, 0x221E
            ],
            'sans-serif-bold-italic': [
                0x20, 0x21, [0x23, 0x3B], 0x3D, 0x3F, 0x40, [0x5B, 0x60], [0x7B, 0x7E], 0xA0, 0xA3, 0xA5, 0xA7, 0xA8, 0xAC, [0xAF, 0xB1], [0xB4, 0xB7], 0xD7, 0xF0, 0xF7, 0x131, 0x237, 0x2C6, 0x2C7, [0x2C9, 0x2CB], [0x2D8, 0x2DA], 0x2DC, [0x300, 0x308], 0x30A, 0x30C, 0x3D2, 0x3F6, [0x2010, 0x2014], 0x2016, 0x2018, 0x2019, 0x201C, 0x201D, 0x2020, 0x2021, 0x2026, 0x2044, 0x20AC, 0x2126, 0x2127, [0x2190, 0x2193], 0x2212, 0x221E
            ]
        }],
    ['sans-serif-r', {
            'sans-serif': [
                [0xC0, 0xD6], [0xD8, 0xEF], [0xF1, 0xF6], [0xF8, 0x130], [0x132, 0x236], [0x238, 0x24F], [0x1E00, 0x1E13], [0x1E18, 0x1E1B], [0x1E1E, 0x1E27], [0x1E2A, 0x1E4B], [0x1E54, 0x1E63], [0x1E68, 0x1E77], [0x1E7C, 0x1E99], 0x1E9B, 0x1E9E, [0x1EA0, 0x1EF9], 0x2C71
            ]
        }],
    ['sans-serif-b', {
            'bold-sans-serif': [
                [0xC0, 0xD6], [0xD8, 0xEF], [0xF1, 0xF6], [0xF8, 0x130], [0x132, 0x236], [0x238, 0x24F], [0x1E00, 0x1E13], [0x1E18, 0x1E1B], [0x1E1E, 0x1E27], [0x1E2A, 0x1E4B], [0x1E54, 0x1E63], [0x1E68, 0x1E77], [0x1E7C, 0x1E99], 0x1E9B, 0x1E9E, [0x1EA0, 0x1EF9], 0x2C71
            ]
        }],
    ['sans-serif-i', {
            'sans-serif-italic': [
                [0xC0, 0xD6], [0xD8, 0xEF], [0xF1, 0xF6], [0xF8, 0x130], [0x132, 0x236], [0x238, 0x24F], [0x1E00, 0x1E13], [0x1E18, 0x1E1B], [0x1E1E, 0x1E27], [0x1E2A, 0x1E4B], [0x1E54, 0x1E63], [0x1E68, 0x1E77], [0x1E7C, 0x1E99], 0x1E9B, 0x1E9E, [0x1EA0, 0x1EF9], 0x2C71
            ]
        }],
    ['sans-serif-bi', {
            'sans-serif-bold-italic': [
                [0xC0, 0xD6], [0xD8, 0xEF], [0xF1, 0xF6], [0xF8, 0x130], [0x132, 0x236], [0x238, 0x24F], [0x1E00, 0x1E13], [0x1E18, 0x1E1B], [0x1E1E, 0x1E27], [0x1E2A, 0x1E4B], [0x1E54, 0x1E63], [0x1E68, 0x1E77], [0x1E7C, 0x1E99], 0x1E9B, 0x1E9E, [0x1EA0, 0x1EF9], 0x2C71
            ]
        }],
    ['sans-serif-ex', {
            'sans-serif': [
                0xA1, 0xA2, 0xA4, 0xA6, [0xA9, 0xAB], 0xAD, 0xAE, 0xB8, [0xBA, 0xBF], [0x2B0, 0x2C5], 0x2C8, 0x2CC, [0x2CE, 0x2D7], 0x2DB, [0x2DD, 0x2FE], 0x309, 0x30B, [0x30D, 0x337], [0x339, 0x34E], [0x350, 0x36F], 0xE3F, 0x1DC4, 0x1DC5, 0x1DC8, 0x1DC9, 0x200C, 0x200D, 0x201A, 0x201B, 0x201E, 0x201F, 0x2022, 0x2029, 0x2030, 0x2031, [0x2039, 0x203B], 0x203D, 0x203F, 0x2040, 0x2045, 0x2046, 0x2052, 0x2054, 0x207F, 0x2080, 0x20A1, 0x20A6, 0x20A9, 0x20AB, 0x20B1, 0x20B2, 0x2103, 0x2116, 0x2117, 0x211E, 0x2120, 0x2122, 0x212E, [0x2190, 0x2193], 0x221A, 0x2222, 0x2300, 0x2329, 0x232A, 0x2422, 0x2423, 0x2502, 0x2551, 0x25E6, 0x262D, 0x2640, 0x266A, 0x26AD, 0x26AE, 0x26B2, 0x271D, 0x27E6, 0x27E7, 0x2E18, 0xE803, [0xEA04, 0xEA06], 0xEA09, 0xEA0B, 0xEA0D, 0xEA10, 0xEA17, 0xEA1A, 0xEA1C, 0xEA1E, 0xEA1F, 0xEA26, 0xEA2A, 0xEA2C, 0xEA2F, 0xEA35, 0xEA37, 0xEA3A, 0xEA3E, 0xEA42, 0xEA45, 0xEB03, 0xEB04, 0xEB08, 0xEB0F, 0xEB11, 0xEB12, 0xEB16, 0xEB19, 0xEB1E, 0xEB1F, 0xEB28, 0xEB29, 0xEB2B, 0xEB31, 0xEB35, 0xEB36, 0xEB3A, 0xEB3B, 0xEB40, 0xEB48, 0xEB49, 0xEB4D, 0xEB61, 0xEB63, 0xEB65, 0xEB6E, 0xEB6F, [0xEC08, 0xEC0E], 0xEC10, 0xEC11, 0xF103, 0xF104, 0xF109, [0xF117, 0xF11E], [0xF121, 0xF123], [0xF126, 0xF12D], 0xF12F, [0xF133, 0xF138], 0xF13D, [0xF141, 0xF146], [0xF14B, 0xF15C], [0xF15F, 0xF165], 0xF168, [0xF16C, 0xF172], 0xF175, [0xF179, 0xF17B], [0xF17E, 0xF180], 0xF182, 0xF184, 0xF185, [0xF188, 0xF18F], 0xF192, 0xF19A, 0xF19E, 0xF19F, 0xF1A1, 0xF1A3, 0xF1A4, [0xF1A7, 0xF1B5], 0xF282, 0xF283, 0xF29E, 0xF2A1, 0xF2A4, [0xF2A7, 0xF2A9], 0xF2AC, 0xF2AE, 0xF2AF, [0xF460, 0xF468], [0xF46A, 0xF472], 0xF6BE, [0xF6D3, 0xF6D6], 0xF6DE, [0xFB00, 0xFB04], 0xFE66
            ],
            'bold-sans-serif': [
                0xA1, 0xA2, 0xA4, 0xA6, [0xA9, 0xAB], 0xAD, 0xAE, 0xB8, [0xBA, 0xBF], [0x2B0, 0x2C5], 0x2C8, 0x2CC, [0x2CE, 0x2D7], 0x2DB, [0x2DD, 0x2FE], 0x309, 0x30B, [0x30D, 0x337], [0x339, 0x34E], [0x350, 0x36F], 0xE3F, 0x1DC4, 0x1DC5, 0x1DC8, 0x1DC9, 0x200C, 0x200D, 0x201A, 0x201B, 0x201E, 0x201F, 0x2022, 0x2029, 0x2030, 0x2031, [0x2039, 0x203B], 0x203D, 0x203F, 0x2040, 0x2045, 0x2046, 0x2052, 0x2054, 0x207F, 0x2080, 0x20A1, 0x20A6, 0x20A9, 0x20AB, 0x20B1, 0x20B2, 0x2103, 0x2116, 0x2117, 0x211E, 0x2120, 0x2122, 0x212E, [0x2190, 0x2193], 0x221A, 0x2222, 0x2300, 0x2329, 0x232A, 0x2422, 0x2423, 0x2502, 0x2551, 0x25E6, 0x262D, 0x2640, 0x266A, 0x26AD, 0x26AE, 0x26B2, 0x271D, 0x27E6, 0x27E7, 0x2E18, 0xE803, [0xEA04, 0xEA06], 0xEA09, 0xEA0B, 0xEA0D, 0xEA10, 0xEA17, 0xEA1A, 0xEA1C, 0xEA1E, 0xEA1F, 0xEA26, 0xEA2A, 0xEA2C, 0xEA2F, 0xEA35, 0xEA3A, 0xEA3E, 0xEA42, 0xEA45, 0xEB03, 0xEB04, 0xEB08, [0xEB0F, 0xEB12], 0xEB16, 0xEB19, 0xEB1E, 0xEB1F, 0xEB28, 0xEB29, 0xEB2B, 0xEB31, 0xEB35, 0xEB36, 0xEB3A, 0xEB3B, 0xEB40, 0xEB48, 0xEB49, 0xEB4D, 0xEB61, 0xEB63, 0xEB65, 0xEB6E, 0xEB6F, [0xEC08, 0xEC0E], 0xEC10, 0xEC11, 0xF103, 0xF104, 0xF109, [0xF117, 0xF11E], [0xF121, 0xF123], [0xF126, 0xF12D], 0xF12F, [0xF133, 0xF138], 0xF13D, [0xF141, 0xF146], [0xF14B, 0xF15C], [0xF15F, 0xF165], 0xF168, [0xF16C, 0xF172], 0xF175, [0xF179, 0xF17B], [0xF17E, 0xF180], 0xF182, 0xF184, 0xF185, [0xF188, 0xF18F], 0xF192, 0xF19A, 0xF19E, 0xF19F, 0xF1A1, 0xF1A3, 0xF1A4, [0xF1A7, 0xF1B5], 0xF282, 0xF283, 0xF29E, 0xF2A1, 0xF2A4, [0xF2A7, 0xF2A9], 0xF2AC, 0xF2AE, 0xF2AF, [0xF460, 0xF468], [0xF46A, 0xF472], 0xF6BE, [0xF6D3, 0xF6D6], 0xF6DE, [0xFB00, 0xFB04], 0xFE66
            ],
            'sans-serif-italic': [
                0xA1, 0xA2, 0xA4, 0xA6, [0xA9, 0xAB], 0xAD, 0xAE, 0xB8, [0xBA, 0xBF], [0x2B0, 0x2C5], 0x2C8, 0x2CC, [0x2CE, 0x2D7], 0x2DB, [0x2DD, 0x2FE], 0x309, 0x30B, [0x30D, 0x337], [0x339, 0x34E], [0x350, 0x36F], 0xE3F, 0x1DC4, 0x1DC5, 0x1DC8, 0x1DC9, 0x200C, 0x200D, 0x201A, 0x201B, 0x201E, 0x201F, 0x2022, 0x2029, 0x2030, 0x2031, [0x2039, 0x203B], 0x203D, 0x203F, 0x2040, 0x2045, 0x2046, 0x2052, 0x2054, 0x207F, 0x2080, 0x20A1, 0x20A6, 0x20A9, 0x20AB, 0x20B1, 0x20B2, 0x2103, 0x2116, 0x2117, 0x211E, 0x2120, 0x2122, 0x212E, [0x2190, 0x2193], 0x221A, 0x2222, 0x2300, 0x2329, 0x232A, 0x2422, 0x2423, 0x2502, 0x2551, 0x25E6, 0x262D, 0x2640, 0x266A, 0x26AD, 0x26AE, 0x26B2, 0x271D, 0x27E6, 0x27E7, 0x2E18, 0xE803, [0xEA04, 0xEA06], 0xEA09, 0xEA0B, 0xEA0D, 0xEA10, 0xEA17, 0xEA1A, 0xEA1C, 0xEA1E, 0xEA1F, 0xEA26, 0xEA2A, 0xEA2C, 0xEA2F, 0xEA35, 0xEA3A, 0xEA3E, 0xEA42, 0xEA45, 0xEB03, 0xEB04, 0xEB08, [0xEB0F, 0xEB12], 0xEB16, 0xEB19, 0xEB1E, 0xEB1F, 0xEB28, 0xEB29, 0xEB2B, 0xEB31, 0xEB35, 0xEB36, 0xEB3A, 0xEB3B, 0xEB40, 0xEB48, 0xEB49, 0xEB4D, 0xEB61, 0xEB63, 0xEB65, 0xEB6E, 0xEB6F, [0xEC08, 0xEC0E], 0xEC10, 0xEC11, 0xF103, 0xF104, 0xF109, [0xF117, 0xF11E], [0xF121, 0xF123], [0xF126, 0xF12D], 0xF12F, [0xF133, 0xF138], 0xF13D, [0xF141, 0xF146], [0xF14B, 0xF15C], [0xF15F, 0xF165], 0xF168, [0xF16C, 0xF172], 0xF175, [0xF179, 0xF17B], [0xF17E, 0xF180], 0xF182, 0xF184, 0xF185, [0xF188, 0xF18F], 0xF192, 0xF19A, 0xF19E, 0xF19F, 0xF1A1, 0xF1A3, 0xF1A4, [0xF1A7, 0xF1B5], 0xF282, 0xF283, 0xF29E, 0xF2A1, 0xF2A4, [0xF2A7, 0xF2A9], 0xF2AC, 0xF2AE, 0xF2AF, [0xF460, 0xF468], [0xF46A, 0xF472], 0xF6BE, [0xF6D3, 0xF6D6], 0xF6DE, [0xFB00, 0xFB04], 0xFE66
            ],
            'sans-serif-bold-italic': [
                0xA1, 0xA2, 0xA4, 0xA6, [0xA9, 0xAB], 0xAD, 0xAE, 0xB8, [0xBA, 0xBF], [0x2B0, 0x2C5], 0x2C8, 0x2CC, [0x2CE, 0x2D7], 0x2DB, [0x2DD, 0x2FE], 0x309, 0x30B, [0x30D, 0x337], [0x339, 0x36F], 0xE3F, 0x1DC4, 0x1DC5, 0x1DC8, 0x1DC9, 0x200C, 0x200D, 0x201A, 0x201B, 0x201E, 0x201F, 0x2022, 0x2029, 0x2030, 0x2031, [0x2039, 0x203B], 0x203D, 0x203F, 0x2040, 0x2045, 0x2046, 0x2052, 0x2054, 0x207F, 0x2080, 0x20A1, 0x20A6, 0x20A9, 0x20AB, 0x20B1, 0x20B2, 0x2103, 0x2116, 0x2117, 0x211E, 0x2120, 0x2122, 0x212E, [0x2190, 0x2193], 0x221A, 0x2222, 0x2300, 0x2329, 0x232A, 0x2422, 0x2423, 0x2502, 0x2551, 0x25E6, 0x262D, 0x2640, 0x266A, 0x26AD, 0x26AE, 0x26B2, 0x271D, 0x27E6, 0x27E7, 0x2E18, 0xE803, [0xEA04, 0xEA06], 0xEA09, 0xEA0B, 0xEA0D, 0xEA10, 0xEA17, 0xEA1A, 0xEA1C, 0xEA1E, 0xEA1F, 0xEA26, 0xEA2A, 0xEA2C, 0xEA2F, 0xEA35, 0xEA3A, 0xEA3E, 0xEA42, 0xEA45, 0xEB03, 0xEB04, 0xEB08, [0xEB0F, 0xEB12], 0xEB16, 0xEB19, 0xEB1E, 0xEB1F, 0xEB28, 0xEB29, 0xEB2B, 0xEB31, 0xEB35, 0xEB36, 0xEB3A, 0xEB3B, 0xEB40, 0xEB48, 0xEB49, 0xEB4D, 0xEB61, 0xEB63, 0xEB65, 0xEB6E, 0xEB6F, [0xEC08, 0xEC0E], 0xEC10, 0xEC11, 0xF103, 0xF104, 0xF109, [0xF117, 0xF11E], [0xF121, 0xF123], [0xF126, 0xF12D], 0xF12F, [0xF133, 0xF138], 0xF13D, [0xF141, 0xF146], [0xF14B, 0xF15C], [0xF15F, 0xF165], 0xF168, [0xF16C, 0xF172], 0xF175, [0xF179, 0xF17B], [0xF17E, 0xF180], 0xF182, 0xF184, 0xF185, [0xF188, 0xF18F], 0xF192, 0xF19A, 0xF19E, 0xF19F, 0xF1A1, 0xF1A3, 0xF1A4, [0xF1A7, 0xF1B5], 0xF282, 0xF283, 0xF29E, 0xF2A1, 0xF2A4, [0xF2A7, 0xF2A9], 0xF2AC, 0xF2AE, 0xF2AF, [0xF460, 0xF468], [0xF46A, 0xF472], 0xF6BE, [0xF6D3, 0xF6D6], 0xF6DE, [0xFB00, 0xFB04], 0xFE66
            ]
        }],
    ['monospace', {
            'normal': [
                [0x1D670, 0x1D6A3], [0x1D7F6, 0x1D7FF]
            ],
            'monospace': [
                [0x20, 0x2F], [0x3A, 0x40], [0x5B, 0x60], [0x7B, 0x7E], 0xA0, 0xA3, 0xA5, 0xA7, 0xA8, 0xAC, [0xAF, 0xB1], [0xB4, 0xB7], 0xD7, 0xF0, 0xF7, 0x131, 0x237, 0x2C6, 0x2C7, [0x2D8, 0x2DA], 0x2DC, [0x300, 0x308], 0x30A, 0x30C, [0x391, 0x3A1], [0x3A3, 0x3A9], [0x3B1, 0x3C9], 0x3D1, 0x3D2, 0x3D5, 0x3D6, 0x3F0, 0x3F1, [0x3F4, 0x3F6], [0x2010, 0x2014], 0x2016, 0x2018, 0x2019, 0x201C, 0x201D, 0x2020, 0x2021, 0x2026, 0x2044, 0x20AC, 0x2126, 0x2127, [0x2190, 0x2193], 0x2212, 0x221E
            ]
        }],
    ['monospace-l', {
            'monospace': [
                [0xC0, 0xD6], [0xD8, 0xEF], [0xF1, 0xF6], [0xF8, 0x130], [0x132, 0x236], [0x238, 0x24F], [0x1E00, 0x1E13], [0x1E18, 0x1E1B], [0x1E1E, 0x1E27], [0x1E2A, 0x1E4B], [0x1E54, 0x1E63], [0x1E68, 0x1E77], [0x1E7C, 0x1E99], 0x1E9B, 0x1E9E, [0x1EA0, 0x1EF9], 0x2C71
            ]
        }],
    ['monospace-ex', {
            'monospace': [
                0xA1, 0xA2, 0xA4, 0xA6, [0xA9, 0xAB], 0xAD, 0xAE, 0xB8, [0xBA, 0xBF], [0x250, 0x2C5], 0x2C8, 0x2CC, [0x2CE, 0x2D7], 0x2DB, [0x2DD, 0x2FE], 0x309, 0x30B, [0x30D, 0x337], [0x339, 0x377], [0x37A, 0x37F], [0x384, 0x38A], 0x38C, [0x38E, 0x390], [0x3AA, 0x3B0], [0x3CA, 0x3D0], 0x3D3, 0x3D4, [0x3D7, 0x3E3], 0x3F2, 0x3F3, [0x3F7, 0x477], [0x47A, 0x486], [0x488, 0x4CE], [0x4D0, 0x4F9], [0x4FC, 0x4FF], 0x512, 0x513, [0x51A, 0x51D], 0xE3F, 0x1D00, 0x1D07, 0x1D0A, 0x1D0B, 0x1D0D, 0x1D18, 0x1D19, 0x1D1C, [0x1D43, 0x1D4B], 0x1D4D, [0x1D4F, 0x1D53], [0x1D56, 0x1D58], 0x1D5A, 0x1D5B, 0x1D5D, 0x1D5E, 0x1D60, 0x1D61, 0x1D78, [0x1D90, 0x1D93], 0x1D97, 0x1DC4, 0x1DC5, 0x1DC8, 0x1DC9, [0x1F00, 0x1F15], [0x1F18, 0x1F1D], [0x1F20, 0x1F45], [0x1F48, 0x1F4D], [0x1F50, 0x1F57], 0x1F59, 0x1F5B, 0x1F5D, [0x1F5F, 0x1F7D], [0x1F80, 0x1FB4], [0x1FB6, 0x1FC4], [0x1FC6, 0x1FD3], [0x1FD6, 0x1FDB], [0x1FDD, 0x1FEF], [0x1FF2, 0x1FF4], [0x1FF6, 0x1FFE], 0x201A, 0x201B, 0x201E, 0x201F, 0x2022, 0x2029, 0x2030, 0x2031, [0x2039, 0x203B], 0x203D, 0x203F, 0x2040, 0x2045, 0x2046, 0x2052, 0x2054, 0x207F, 0x2080, 0x20A1, 0x20A6, 0x20A9, 0x20AB, 0x20B1, 0x20B2, 0x2103, 0x2116, 0x2117, 0x211E, 0x2120, 0x2122, 0x212E, [0x2190, 0x2193], 0x221A, 0x2222, 0x2300, 0x2329, 0x232A, 0x2422, 0x2423, 0x2500, 0x2502, 0x250C, 0x2510, 0x2514, 0x2518, 0x251C, 0x2524, 0x252C, 0x2534, 0x253C, [0x2550, 0x256B], 0x25E6, 0x262D, 0x2640, 0x266A, 0x26AD, 0x26AE, 0x26B2, 0x271D, 0x27E6, 0x27E7, 0x2E18, [0xEA04, 0xEA06], 0xEA09, 0xEA0B, 0xEA0D, 0xEA10, 0xEA17, 0xEA1A, 0xEA1C, 0xEA1E, 0xEA1F, 0xEA26, 0xEA2A, 0xEA2C, 0xEA2F, 0xEA35, 0xEA3A, 0xEA3E, 0xEA42, 0xEA45, 0xEB03, 0xEB04, 0xEB08, [0xEB0F, 0xEB12], 0xEB16, 0xEB19, 0xEB1E, 0xEB1F, 0xEB29, 0xEB2B, 0xEB31, 0xEB35, 0xEB36, 0xEB3A, 0xEB3B, 0xEB40, 0xEB48, 0xEB49, 0xEB4D, 0xEB63, 0xEB65, 0xEB6E, 0xEB6F, [0xEC08, 0xEC0E], 0xEC10, 0xEC11, 0xF103, 0xF104, 0xF109, [0xF117, 0xF11E], [0xF121, 0xF123], [0xF126, 0xF12D], 0xF12F, [0xF133, 0xF138], 0xF13D, [0xF141, 0xF146], [0xF14B, 0xF15C], [0xF15F, 0xF165], 0xF168, [0xF16C, 0xF172], 0xF175, [0xF179, 0xF17B], [0xF17E, 0xF180], 0xF182, 0xF184, 0xF185, [0xF188, 0xF18F], 0xF192, 0xF19A, 0xF19E, 0xF19F, 0xF1A1, 0xF1A3, 0xF1A4, [0xF1A7, 0xF1B5], 0xF282, 0xF283, 0xF29E, 0xF2A1, 0xF2A4, [0xF2A7, 0xF2A9], 0xF2AC, 0xF2AE, 0xF2AF, [0xF460, 0xF468], [0xF46A, 0xF472], 0xF6BE, [0xF6D3, 0xF6D6], 0xF6DE, [0xFB00, 0xFB06], 0xFE66
            ]
        }],
    ['calligraphic', {
            '-tex-calligraphic': [
                [0x41, 0x5A]
            ],
            '-tex-bold-calligraphic': [
                [0x41, 0x5A]
            ]
        }],
    ['math', {
            'normal': [
                0x220A, 0x220D, 0x221B, 0x221C, 0x223A, 0x223B, 0x224E, 0x224F, [0x2251, 0x2253], [0x2256, 0x225C], 0x225E, 0x228C, [0x22B6, 0x22B9], [0x22BB, 0x22BF], 0x22C7, [0x22D0, 0x22E1], [0x22E4, 0x22E9], [0x22F2, 0x22FF], [0x27C0, 0x27D7], [0x27DA, 0x27DC], [0x27DF, 0x27E5], [0x2981, 0x2996], [0x2999, 0x29F4], 0x29F6, [0x29FA, 0x29FF], 0x2A0A, 0x2A0B, [0x2A1D, 0x2A2E], [0x2A30, 0x2A3E], [0x2A40, 0x2A7C], [0x2A7F, 0x2A84], [0x2A8D, 0x2A94], [0x2A97, 0x2AAE], [0x2ABB, 0x2AC4], [0x2AC7, 0x2ACA], [0x2ACD, 0x2ADD], [0x2AEC, 0x2AF1], [0x2AF6, 0x2AFB], [0x2AFD, 0x2AFF]
            ]
        }],
    ['symbols', {
            'normal': [
                0x7F, 0xA1, 0xA2, 0xA4, 0xA6, [0xA9, 0xAB], 0xAD, 0xAE, 0xB2, 0xB3, [0xB9, 0xBF], 0xE3F, 0x200C, 0x200D, 0x2017, 0x201A, 0x201B, 0x201E, 0x201F, [0x2022, 0x2025], 0x2029, 0x2030, 0x2031, [0x2038, 0x2043], [0x2045, 0x2056], [0x2058, 0x205E], 0x207F, 0x2080, 0x20A1, 0x20A6, [0x20A9, 0x20AB], 0x20B1, 0x20B2, 0x2100, 0x2101, [0x2103, 0x2106], 0x2108, 0x2109, 0x2114, 0x2116, 0x2117, [0x211E, 0x2123], 0x2125, 0x2129, 0x212E, [0x2139, 0x213B], [0x214A, 0x214F], [0x2300, 0x2306], [0x2311, 0x2318], 0x231A, 0x231B, [0x2324, 0x2328], [0x232B, 0x239A], 0x23B6, [0x23BA, 0x23CD], 0x23CF, [0x23D1, 0x23DB], [0x23E2, 0x23F3], [0x23F8, 0x23FF], 0x2422, 0x2423, 0x2B97, 0x2BB9, 0x2BC9, [0x2BD0, 0x2BE9], [0x2BF0, 0x2BFF], 0x2E18, 0x3012, 0x3016, 0x3017, 0x3030, [0xFB00, 0xFB06], 0xFE66, 0xFEFF
            ]
        }, [0x2017]],
    ['symbols-b-i', {
            'bold': [
                0xA1, 0xA2, 0xA4, 0xA6, [0xA9, 0xAB], 0xAD, 0xAE, [0xBA, 0xBF], 0xE3F, 0x200C, 0x200D, 0x201A, 0x201B, 0x201E, 0x201F, 0x2022, 0x2029, 0x2030, 0x2031, [0x2039, 0x203B], 0x203D, 0x203F, 0x2040, 0x2045, 0x2046, 0x2052, 0x2054, 0x207F, 0x2080, 0x20A1, 0x20A6, [0x20A9, 0x20AB], 0x20B1, 0x20B2, 0x2103, 0x2116, 0x2117, 0x211E, 0x2120, 0x2122, 0x212E, 0x2300, 0x2422, 0x2423, 0x2E18, [0xFB00, 0xFB06], 0xFE66
            ],
            'italic': [
                [0xA1, 0xA7], [0xA9, 0xAE], 0xB1, [0xB5, 0xB7], [0xBA, 0xBF], 0xD7, 0xF0, 0xF7, 0xE3F, 0x200C, 0x200D, 0x201A, 0x201B, [0x201E, 0x2022], 0x2029, 0x2030, 0x2031, [0x2039, 0x203B], 0x203D, 0x203F, 0x2040, 0x2045, 0x2046, 0x2052, 0x2054, 0x2080, 0x20A1, 0x20A6, 0x20A9, 0x20AB, 0x20B1, 0x20B2, 0x2103, 0x2116, 0x2117, 0x211E, 0x2120, 0x2122, 0x212E, 0x2300, 0x2422, 0x2423, 0x2E18, [0xFB00, 0xFB06], 0xFE66
            ],
            'bold-italic': [
                [0xA1, 0xA7], [0xA9, 0xAE], 0xB1, [0xB5, 0xB7], [0xBA, 0xBF], 0xD7, 0xF0, 0xF7, 0xE3F, 0x200C, 0x200D, 0x201A, 0x201B, [0x201E, 0x2022], 0x2029, 0x2030, 0x2031, [0x2039, 0x203B], 0x203D, 0x203F, 0x2040, 0x2045, 0x2046, 0x2052, 0x2054, 0x2080, 0x20A1, 0x20A6, [0x20A9, 0x20AB], 0x20B1, 0x20B2, 0x2103, 0x2116, 0x2117, 0x211E, 0x2120, 0x2122, 0x212E, 0x2300, 0x2422, 0x2423, 0x2E18, [0xFB00, 0xFB06], 0xFE66
            ]
        }],
    ['greek', {
            'normal': [
                [0x370, 0x377], [0x37A, 0x37F], [0x384, 0x38A], 0x38C, [0x38E, 0x390], [0x3AA, 0x3B0], [0x3CA, 0x3D0], 0x3D3, 0x3D4, [0x3D7, 0x3EF], 0x3F2, 0x3F3, [0x3F7, 0x3FF], [0x1F00, 0x1F15], [0x1F18, 0x1F1D], [0x1F20, 0x1F45], [0x1F48, 0x1F4D], [0x1F50, 0x1F57], 0x1F59, 0x1F5B, 0x1F5D, [0x1F5F, 0x1F7D], [0x1F80, 0x1FB4], [0x1FB6, 0x1FC4], [0x1FC6, 0x1FD3], [0x1FD6, 0x1FDB], [0x1FDD, 0x1FEF], [0x1FF2, 0x1FF4], [0x1FF6, 0x1FFE], [0x2C80, 0x2CF3], [0x2CF9, 0x2CFF]
            ],
            'bold': [
                [0x370, 0x377], [0x37A, 0x37F], [0x384, 0x38A], 0x38C, [0x38E, 0x390], [0x3AA, 0x3B0], [0x3CA, 0x3D0], 0x3D3, 0x3D4, [0x3D7, 0x3DB], [0x3DE, 0x3EF], 0x3F2, 0x3F3, [0x3F7, 0x3FF], [0x1F00, 0x1F15], [0x1F18, 0x1F1D], [0x1F20, 0x1F45], [0x1F48, 0x1F4D], [0x1F50, 0x1F57], 0x1F59, 0x1F5B, 0x1F5D, [0x1F5F, 0x1F7D], [0x1F80, 0x1FB4], [0x1FB6, 0x1FC4], [0x1FC6, 0x1FD3], [0x1FD6, 0x1FDB], [0x1FDD, 0x1FEF], [0x1FF2, 0x1FF4], [0x1FF6, 0x1FFE], [0x2C80, 0x2CF3], [0x2CF9, 0x2CFF]
            ],
            'italic': [
                [0x370, 0x377], [0x37A, 0x37F], [0x384, 0x38A], 0x38C, [0x38E, 0x390], [0x3AA, 0x3B0], [0x3CA, 0x3D0], 0x3D3, 0x3D4, [0x3D7, 0x3EF], 0x3F2, 0x3F3, [0x3F7, 0x3FF], [0x1F00, 0x1F15], [0x1F18, 0x1F1D], [0x1F20, 0x1F45], [0x1F48, 0x1F4D], [0x1F50, 0x1F57], 0x1F59, 0x1F5B, 0x1F5D, [0x1F5F, 0x1F7D], [0x1F80, 0x1FB4], [0x1FB6, 0x1FC4], [0x1FC6, 0x1FD3], [0x1FD6, 0x1FDB], [0x1FDD, 0x1FEF], [0x1FF2, 0x1FF4], [0x1FF6, 0x1FFE], [0x2C80, 0x2CF3], [0x2CF9, 0x2CFF]
            ],
            'bold-italic': [
                [0x370, 0x377], [0x37A, 0x37F], [0x384, 0x38A], 0x38C, [0x38E, 0x390], [0x3AA, 0x3B0], [0x3CA, 0x3D0], 0x3D3, 0x3D4, [0x3D7, 0x3EF], 0x3F2, 0x3F3, [0x3F7, 0x3FF], [0x1F00, 0x1F15], [0x1F18, 0x1F1D], [0x1F20, 0x1F45], [0x1F48, 0x1F4D], [0x1F50, 0x1F57], 0x1F59, 0x1F5B, 0x1F5D, [0x1F5F, 0x1F7D], [0x1F80, 0x1FB4], [0x1FB6, 0x1FC4], [0x1FC6, 0x1FD3], [0x1FD6, 0x1FDB], [0x1FDD, 0x1FEF], [0x1FF2, 0x1FF4], [0x1FF6, 0x1FFE], [0x2C80, 0x2CF3], [0x2CF9, 0x2CFF]
            ]
        }],
    ['greek-ss', {
            'sans-serif': [
                [0x370, 0x377], [0x37A, 0x37F], [0x384, 0x38A], 0x38C, [0x38E, 0x390], [0x3AA, 0x3B0], [0x3CA, 0x3D0], 0x3D3, 0x3D4, [0x3D7, 0x3EF], 0x3F2, 0x3F3, [0x3F7, 0x3FF], [0x1F00, 0x1F15], [0x1F18, 0x1F1D], [0x1F20, 0x1F45], [0x1F48, 0x1F4D], [0x1F50, 0x1F57], 0x1F59, 0x1F5B, 0x1F5D, [0x1F5F, 0x1F7D], [0x1F80, 0x1FB4], [0x1FB6, 0x1FC4], [0x1FC6, 0x1FD3], [0x1FD6, 0x1FDB], [0x1FDD, 0x1FEF], [0x1FF2, 0x1FF4], [0x1FF6, 0x1FFE]
            ],
            'bold-sans-serif': [
                [0x370, 0x377], [0x37A, 0x37F], [0x384, 0x38A], 0x38C, [0x38E, 0x390], [0x3AA, 0x3B0], [0x3CA, 0x3D0], 0x3D3, 0x3D4, [0x3D7, 0x3EF], 0x3F2, 0x3F3, [0x3F7, 0x3FF], [0x1F00, 0x1F15], [0x1F18, 0x1F1D], [0x1F20, 0x1F45], [0x1F48, 0x1F4D], [0x1F50, 0x1F57], 0x1F59, 0x1F5B, 0x1F5D, [0x1F5F, 0x1F7D], [0x1F80, 0x1FB4], [0x1FB6, 0x1FB9], [0x1FBB, 0x1FC4], [0x1FC6, 0x1FD3], [0x1FD6, 0x1FDB], [0x1FDD, 0x1FEF], [0x1FF2, 0x1FF4], [0x1FF6, 0x1FFE]
            ],
            'sans-serif-italic': [
                [0x370, 0x377], [0x37A, 0x37F], [0x384, 0x38A], 0x38C, [0x38E, 0x390], [0x3AA, 0x3B0], [0x3CA, 0x3D0], 0x3D3, 0x3D4, [0x3D7, 0x3EF], 0x3F2, 0x3F3, [0x3F7, 0x3FF], [0x1F00, 0x1F15], [0x1F18, 0x1F1D], [0x1F20, 0x1F45], [0x1F48, 0x1F4D], [0x1F50, 0x1F57], 0x1F59, 0x1F5B, 0x1F5D, [0x1F5F, 0x1F7D], [0x1F80, 0x1FB4], [0x1FB6, 0x1FC4], [0x1FC6, 0x1FD3], [0x1FD6, 0x1FDB], [0x1FDD, 0x1FEF], [0x1FF2, 0x1FF4], [0x1FF6, 0x1FFE]
            ],
            'sans-serif-bold-italic': [
                [0x370, 0x377], [0x37A, 0x37F], [0x384, 0x38A], 0x38C, [0x38E, 0x390], [0x3AA, 0x3B0], [0x3CA, 0x3D0], 0x3D3, 0x3D4, [0x3D7, 0x3EF], 0x3F2, 0x3F3, [0x3F7, 0x3FF], [0x1F00, 0x1F15], [0x1F18, 0x1F1D], [0x1F20, 0x1F45], [0x1F48, 0x1F4D], [0x1F50, 0x1F57], 0x1F59, 0x1F5B, 0x1F5D, [0x1F5F, 0x1F7D], [0x1F80, 0x1FB4], [0x1FB6, 0x1FB9], [0x1FBB, 0x1FC4], [0x1FC6, 0x1FD3], [0x1FD6, 0x1FDB], [0x1FDD, 0x1FEF], [0x1FF2, 0x1FF4], [0x1FF6, 0x1FFE]
            ]
        }],
    ['cyrillic', {
            'normal': [
                [0x400, 0x477], [0x47A, 0x486], [0x488, 0x4CE], [0x4D0, 0x4F9], [0x4FC, 0x4FF], 0x512, 0x513, [0x51A, 0x51D]
            ],
            'bold': [
                [0x400, 0x477], [0x47A, 0x486], [0x488, 0x4CE], [0x4D0, 0x4F9], [0x4FC, 0x4FF], 0x512, 0x513, [0x51A, 0x51D]
            ],
            'italic': [
                [0x400, 0x477], [0x47A, 0x486], [0x488, 0x4C9], [0x4CB, 0x4CE], [0x4D0, 0x4F9], [0x4FC, 0x4FF], 0x512, 0x513, [0x51A, 0x51D]
            ],
            'bold-italic': [
                [0x400, 0x477], [0x47A, 0x486], [0x488, 0x4C9], [0x4CB, 0x4CE], [0x4D0, 0x4F9], [0x4FC, 0x4FF], 0x512, 0x513, [0x51A, 0x51D]
            ]
        }],
    ['cyrillic-ss', {
            'sans-serif': [
                [0x400, 0x477], [0x47A, 0x486], [0x488, 0x4CE], [0x4D0, 0x4F9], [0x4FC, 0x4FF], 0x512, 0x513, [0x51A, 0x51D]
            ],
            'bold-sans-serif': [
                [0x400, 0x477], [0x47A, 0x486], [0x488, 0x4CE], [0x4D0, 0x4F9], [0x4FC, 0x4FF], 0x512, 0x513, [0x51A, 0x51D]
            ],
            'sans-serif-italic': [
                [0x400, 0x477], [0x47A, 0x486], [0x488, 0x4CE], [0x4D0, 0x4F9], [0x4FC, 0x4FF], 0x512, 0x513, [0x51A, 0x51D]
            ],
            'sans-serif-bold-italic': [
                [0x400, 0x477], [0x47A, 0x486], [0x488, 0x4CE], [0x4D0, 0x4F9], [0x4FC, 0x4FF], 0x512, 0x513, [0x51A, 0x51D]
            ]
        }],
    ['phonetics', {
            'normal': [
                [0x250, 0x2AF], 0x1D00, 0x1D07, 0x1D0A, 0x1D0B, 0x1D0D, 0x1D18, 0x1D19, 0x1D1C, [0x1D43, 0x1D4B], 0x1D4D, [0x1D4F, 0x1D53], [0x1D56, 0x1D58], 0x1D5A, 0x1D5B, 0x1D5D, 0x1D5E, 0x1D60, 0x1D61, 0x1D78, [0x1D90, 0x1D93], 0x1D97
            ],
            'bold': [
                [0x250, 0x2AF], 0x1D00, 0x1D07, 0x1D0A, 0x1D0B, 0x1D0D, 0x1D18, 0x1D19, 0x1D1C, [0x1D43, 0x1D4B], 0x1D4D, [0x1D4F, 0x1D53], [0x1D56, 0x1D58], 0x1D5A, 0x1D5B, 0x1D5D, 0x1D5E, 0x1D60, 0x1D61, 0x1D78, [0x1D90, 0x1D93], 0x1D97
            ],
            'italic': [
                [0x250, 0x2AD], 0x2AF
            ],
            'bold-italic': [
                [0x250, 0x2AF]
            ]
        }],
    ['phonetics-ss', {
            'sans-serif': [
                [0x250, 0x2AF], 0x1D00, 0x1D07, 0x1D0A, 0x1D0B, 0x1D0D, 0x1D18, 0x1D19, 0x1D1C, [0x1D43, 0x1D4B], 0x1D4D, [0x1D4F, 0x1D53], [0x1D56, 0x1D58], 0x1D5A, 0x1D5B, 0x1D5D, 0x1D5E, 0x1D60, 0x1D61, 0x1D78, [0x1D90, 0x1D93], 0x1D97
            ],
            'bold-sans-serif': [
                [0x250, 0x2AF], 0x1D00, 0x1D07, 0x1D0A, 0x1D0B, 0x1D0D, 0x1D18, 0x1D19, 0x1D1C, [0x1D43, 0x1D4B], 0x1D4D, [0x1D4F, 0x1D53], [0x1D56, 0x1D58], 0x1D5A, 0x1D5B, 0x1D5D, 0x1D5E, 0x1D60, 0x1D61, 0x1D78, [0x1D90, 0x1D93], 0x1D97
            ],
            'sans-serif-italic': [
                [0x250, 0x2AF], 0x1D00, 0x1D07, 0x1D0A, 0x1D0B, 0x1D0D, 0x1D18, 0x1D19, 0x1D1C, [0x1D43, 0x1D4B], 0x1D4D, [0x1D4F, 0x1D53], [0x1D56, 0x1D58], 0x1D5A, 0x1D5B, 0x1D5D, 0x1D5E, 0x1D60, 0x1D61, 0x1D78, [0x1D90, 0x1D93], 0x1D97
            ],
            'sans-serif-bold-italic': [
                [0x250, 0x2AF], 0x1D00, 0x1D07, 0x1D0A, 0x1D0B, 0x1D0D, 0x1D18, 0x1D19, 0x1D1C, [0x1D43, 0x1D4B], 0x1D4D, [0x1D4F, 0x1D53], [0x1D56, 0x1D58], 0x1D5A, 0x1D5B, 0x1D5D, 0x1D5E, 0x1D60, 0x1D61, 0x1D78, [0x1D90, 0x1D93], 0x1D97
            ]
        }],
    ['hebrew', {
            'normal': [
                [0x591, 0x5C7], [0x5D0, 0x5EA], [0x5EF, 0x5F5], 0x5F7, [0xFB1D, 0xFB4F]
            ],
            'bold': [
                [0x591, 0x5C7], [0x5D0, 0x5EB], [0x5EF, 0x5F5], 0x5F7, [0xFB1D, 0xFB4F]
            ],
            'italic': [
                [0x591, 0x5C7], [0x5D0, 0x5EA], [0x5EF, 0x5F5], 0x5F7, [0xFB1D, 0xFB4F]
            ],
            'bold-italic': [
                [0x591, 0x5C7], [0x5D0, 0x5EB], [0x5EF, 0x5F5], 0x5F7, [0xFB1D, 0xFB4F]
            ]
        }],
    ['devanagari', {
            'normal': [
                [0x900, 0x97F]
            ],
            'bold': [],
            'italic': [],
            'bold-italic': []
        }],
    ['cherokee', {
            'normal': [
                [0x13A0, 0x13F5], [0x13F8, 0x13FD]
            ],
            'bold': [
                [0x13A0, 0x13F5], [0x13F8, 0x13FD]
            ],
            'italic': [
                [0x13A0, 0x13FB]
            ],
            'bold-italic': [
                [0x13A0, 0x13FB]
            ]
        }],
    ['arabic', {
            'normal': [
                [0x1EE00, 0x1EE22], 0x1EE24, 0x1EE27, [0x1EE29, 0x1EE32], [0x1EE34, 0x1EE37], 0x1EE39, 0x1EE3B, 0x1EE42, 0x1EE47, 0x1EE49, 0x1EE4B, [0x1EE4D, 0x1EE4F], 0x1EE51, 0x1EE52, 0x1EE54, 0x1EE57, 0x1EE59, 0x1EE5B, 0x1EE5D, 0x1EE5F, 0x1EE61, 0x1EE62, 0x1EE64, [0x1EE67, 0x1EE6A], [0x1EE6C, 0x1EE72], [0x1EE74, 0x1EE77], [0x1EE79, 0x1EE7C], [0x1EE7E, 0x1EE89], [0x1EE8B, 0x1EE9B], [0x1EEA1, 0x1EEA3], [0x1EEA5, 0x1EEA9], [0x1EEAB, 0x1EEBB], 0x1EEF0, 0x1EEF1
            ],
            'bold': [],
            'italic': [],
            'bold-italic': []
        }],
    ['braille-d', {
            'normal': [
                [0x2800, 0x28FF]
            ]
        }],
    ['braille', {
            'sans-serif': [
                [0x2800, 0x28FF]
            ]
        }],
    ['arrows', {
            'normal': [
                0x219C, 0x219D, 0x219F, 0x21A1, 0x21A5, 0x21A7, 0x21A8, 0x21AD, [0x21AF, 0x21B5], 0x21B8, 0x21B9, [0x21D6, 0x21D9], [0x21DC, 0x21DF], [0x21E6, 0x21F4], [0x21F7, 0x21FF], 0x23CE, 0x27A1, [0x27F0, 0x27F4], 0x27FF, [0x2900, 0x2909], [0x290C, 0x2949], 0x294C, 0x294D, 0x294F, 0x2951, 0x2954, 0x2955, 0x2958, 0x2959, 0x295C, 0x295D, [0x2960, 0x2969], [0x2970, 0x297B], [0x2B00, 0x2B12], [0x2B30, 0x2B4F], [0x2B5A, 0x2B73], [0x2B76, 0x2B95], [0x2B98, 0x2BB8], [0x2BEC, 0x2BEF]
            ],
            '-largeop': [
                0x2191, 0x2193, [0x2195, 0x219B], [0x219E, 0x21A3], 0x21A5, 0x21A7, [0x21A9, 0x21AE], [0x21B0, 0x21B3], 0x21B6, 0x21B7, [0x21BC, 0x21CF], 0x21D1, 0x21D3, [0x21D5, 0x21DB], [0x21E6, 0x21E9], 0x21F3, 0x21F5, 0x21F6, [0x2B04, 0x2B07], 0x2B0C, 0x2B0D, 0x2B31
            ],
            '-lf-tp': [
                [0x21E6, 0x21E9], 0x2907, 0x2B05, 0x2B06
            ],
            '-rt-bt': [
                [0x21E6, 0x21E9], 0x2906, 0x2B07, 0x2B0C
            ],
            '-ex-md': [
                0x21E6, 0x21E7, 0x2B05, 0x2B06
            ]
        }, [0x219F, 0x21A1, 0x21A5, 0x21A7, 0x21AD, 0x21AE, [0x21B0, 0x21B3], [0x21D6, 0x21D9], 0x21DC, 0x21DD, [0x21E6, 0x21E9], 0x21F3, 0x27A1, 0x27FD, 0x27FE, 0x2906, 0x2907, 0x294C, 0x294D, 0x294F, 0x2951, 0x295C, 0x295D, 0x2960, 0x2961, [0x2B04, 0x2B07], 0x2B0C, 0x2B0D, 0x2B31]],
    ['marrows', {
            'normal': [
                [0x1F800, 0x1F80B], [0x1F810, 0x1F847], [0x1F850, 0x1F859], [0x1F860, 0x1F887], [0x1F890, 0x1F8AD], 0x1F8B0, 0x1F8B1
            ]
        }],
    ['accents', {
            'normal': [
                0xB8, [0x2B0, 0x2C5], 0x2C8, 0x2CC, [0x2CE, 0x2D7], 0x2DB, [0x2DD, 0x2FE], 0x309, 0x30B, [0x30D, 0x337], [0x339, 0x36F], 0x1DC4, 0x1DC5, 0x1DC8, 0x1DC9, [0x20D3, 0x20D5], 0x20D8, [0x20DD, 0x20DF], [0x20E4, 0x20EB], 0x20F0
            ],
            '-smallop': [
                0x311, [0x32C, 0x330], 0x332, 0x333, 0x33F, 0x34D
            ],
            '-largeop': [
                0x311, [0x32C, 0x330]
            ],
            '-size3': [
                0x311, [0x32C, 0x330]
            ],
            '-size4': [
                0x311, [0x32C, 0x330]
            ],
            '-size5': [
                0x311, [0x32C, 0x330]
            ],
            '-size6': [
                0x311, [0x32C, 0x330]
            ],
            '-size7': [
                0x311, [0x32C, 0x330]
            ],
            '-ex-md': [
                0x332, 0x333, 0x33F, 0x34D
            ]
        }, [0x311, [0x32C, 0x330], 0x332, 0x333, 0x33F, 0x34D, 0x20E9]],
    ['accents-b-i', {
            'bold': [
                0xB8, [0x2B0, 0x2C5], 0x2C8, 0x2CC, [0x2CE, 0x2D7], 0x2DB, [0x2DD, 0x2FE], 0x309, 0x30B, [0x30D, 0x337], [0x339, 0x34E], [0x350, 0x36F], 0x1DC4, 0x1DC5, 0x1DC8, 0x1DC9
            ],
            'italic': [
                0xB8, [0x2B0, 0x2BC], [0x2BE, 0x2C5], 0x2C8, 0x2CC, [0x2CE, 0x2D7], 0x2DB, [0x2DD, 0x2FE], 0x309, 0x30B, [0x30D, 0x337], [0x339, 0x34E], [0x350, 0x36F]
            ],
            'bold-italic': [
                0xB8, [0x2B0, 0x2C5], 0x2C8, 0x2CC, [0x2CE, 0x2D7], 0x2DB, [0x2DD, 0x2FE], 0x309, 0x30B, [0x30D, 0x337], [0x339, 0x34E], [0x350, 0x36F]
            ]
        }],
    ['shapes', {
            'normal': [
                0x2302, [0x2326, 0x2328], 0x232B, [0x23FB, 0x23FE], [0x2500, 0x259F], [0x25A2, 0x25A9], [0x25AC, 0x25B1], 0x25C8, 0x25C9, [0x25CC, 0x25CE], [0x25D0, 0x25E5], [0x25E7, 0x25EE], [0x25F0, 0x25F7], 0x2600, 0x2605, 0x2606, 0x2609, 0x2621, 0x262D, [0x2639, 0x263E], 0x2640, 0x2642, [0x2660, 0x2667], [0x2669, 0x266B], [0x266D, 0x266F], 0x267E, [0x2680, 0x2689], 0x26A5, [0x26AA, 0x26AE], 0x26B2, 0x2713, 0x271D, 0x2720, 0x272A, 0x2736, 0x273D, 0x2772, 0x2773, 0x279B, 0x27A1, [0x2B12, 0x2B2F], [0x2B50, 0x2B59], [0x2BBA, 0x2BC8], [0x2BCA, 0x2BCF], 0x2BEA, 0x2BEB
            ],
            'bold': [
                0x2502, 0x2551, 0x262D, 0x2640, 0x266A, 0x26AD, 0x26AE, 0x26B2, 0x271D
            ],
            'italic': [
                0x262D, 0x266A, 0x26AD, 0x26AE, 0x271D
            ],
            'bold-italic': [
                0x262D, 0x266A, 0x26AD, 0x26AE, 0x271D
            ]
        }],
    ['mshapes', {
            'normal': [
                [0x1F780, 0x1F7D8], [0x1F7E0, 0x1F7EB]
            ]
        }],
    ['variants', {
            '-tex-variant': [
                0x22, 0x27, 0x2A, 0x60, 0x7E, 0xAA, 0xB0, 0xB2, 0xB3, 0xB9, 0xBA, 0x2014, 0x2061, 0x2070, 0x2071, [0x2074, 0x208E]
            ]
        }],
    ['PUA', {
            'normal': [
                [0xE000, 0xE033], [0xE041, 0xE072], [0xE780, 0xE78A], 0xE803, [0xEA04, 0xEA06], 0xEA09, 0xEA0B, 0xEA0D, 0xEA10, 0xEA17, 0xEA1A, 0xEA1C, 0xEA1E, 0xEA1F, 0xEA26, 0xEA2A, 0xEA2C, 0xEA2F, 0xEA35, 0xEA3A, 0xEA3E, 0xEA42, 0xEA45, 0xEB03, 0xEB04, 0xEB08, [0xEB0F, 0xEB12], 0xEB16, 0xEB19, 0xEB1E, 0xEB1F, 0xEB28, 0xEB29, 0xEB2B, 0xEB31, 0xEB35, 0xEB36, 0xEB3A, 0xEB3B, 0xEB40, 0xEB48, 0xEB49, 0xEB4D, 0xEB61, 0xEB63, 0xEB65, 0xEB6E, 0xEB6F, [0xEC08, 0xEC0E], 0xEC10, 0xEC11, 0xF103, 0xF104, 0xF109, [0xF117, 0xF11E], [0xF121, 0xF123], [0xF126, 0xF12D], 0xF12F, [0xF133, 0xF138], 0xF13D, [0xF141, 0xF146], [0xF14B, 0xF15C], [0xF15F, 0xF165], 0xF168, [0xF16C, 0xF172], 0xF175, [0xF179, 0xF17B], [0xF17E, 0xF180], 0xF182, 0xF184, 0xF185, [0xF188, 0xF18F], 0xF192, 0xF19A, 0xF19E, 0xF19F, 0xF1A1, 0xF1A3, 0xF1A4, [0xF1A7, 0xF1B5], 0xF282, 0xF283, 0xF29E, 0xF2A1, 0xF2A4, [0xF2A7, 0xF2A9], 0xF2AC, 0xF2AE, 0xF2AF, [0xF460, 0xF468], [0xF46A, 0xF472], 0xF6BE, [0xF6D3, 0xF6D6], 0xF6DE
            ],
            'bold': [
                0xE803, [0xEA04, 0xEA06], 0xEA09, 0xEA0B, 0xEA0D, 0xEA10, 0xEA17, 0xEA1A, 0xEA1C, 0xEA1E, 0xEA1F, 0xEA26, 0xEA2A, 0xEA2C, 0xEA2F, 0xEA35, 0xEA3A, 0xEA3E, 0xEA42, 0xEA45, 0xEB03, 0xEB04, 0xEB08, [0xEB0F, 0xEB12], 0xEB16, 0xEB19, 0xEB1E, 0xEB1F, 0xEB28, 0xEB29, 0xEB2B, 0xEB31, 0xEB35, 0xEB36, 0xEB3A, 0xEB3B, 0xEB40, 0xEB48, 0xEB49, 0xEB4D, 0xEB61, 0xEB63, 0xEB65, 0xEB6E, 0xEB6F, [0xEC08, 0xEC0E], 0xEC10, 0xEC11, 0xF103, 0xF104, 0xF109, [0xF117, 0xF11E], [0xF121, 0xF123], [0xF126, 0xF12D], 0xF12F, [0xF133, 0xF138], 0xF13D, [0xF141, 0xF146], [0xF14B, 0xF15C], [0xF15F, 0xF165], 0xF168, [0xF16C, 0xF172], 0xF175, [0xF179, 0xF17B], [0xF17E, 0xF180], 0xF182, 0xF184, 0xF185, [0xF188, 0xF18F], 0xF192, 0xF19A, 0xF19E, 0xF19F, 0xF1A1, 0xF1A3, 0xF1A4, [0xF1A7, 0xF1B5], 0xF282, 0xF283, 0xF29E, 0xF2A1, 0xF2A4, [0xF2A7, 0xF2A9], 0xF2AC, 0xF2AE, 0xF2AF, [0xF460, 0xF468], [0xF46A, 0xF472], 0xF6BE, [0xF6D3, 0xF6D6], 0xF6DE
            ],
            'italic': [
                0xE803, [0xEA04, 0xEA06], 0xEA09, 0xEA0B, 0xEA0D, 0xEA10, 0xEA17, 0xEA1A, 0xEA1C, 0xEA1E, 0xEA1F, 0xEA26, 0xEA2A, 0xEA2C, 0xEA2F, 0xEA35, 0xEA3A, 0xEA3E, 0xEA42, 0xEA45, 0xEB03, 0xEB04, 0xEB08, [0xEB0F, 0xEB12], 0xEB16, 0xEB19, 0xEB1E, 0xEB1F, 0xEB28, 0xEB29, 0xEB2B, 0xEB31, 0xEB35, 0xEB36, 0xEB3A, 0xEB3B, 0xEB40, 0xEB48, 0xEB49, 0xEB4D, 0xEB61, 0xEB63, 0xEB65, 0xEB6E, 0xEB6F, [0xEC08, 0xEC0E], 0xEC10, 0xEC11, 0xF103, 0xF104, 0xF109, [0xF117, 0xF11E], [0xF121, 0xF123], [0xF126, 0xF12D], 0xF12F, [0xF133, 0xF138], 0xF13D, 0xF1AB, 0xF1AC, [0xF1B1, 0xF1B5], 0xF282, 0xF283, 0xF29E, 0xF2A1, 0xF2A4, 0xF2A7, 0xF2A8, [0xF460, 0xF468], [0xF46A, 0xF472], 0xF6BE, 0xF6C4, [0xF6C6, 0xF6C8], [0xF6D3, 0xF6D6], 0xF6DE
            ],
            'bold-italic': [
                0xE803, [0xEA04, 0xEA06], 0xEA09, 0xEA0B, 0xEA0D, 0xEA10, 0xEA17, 0xEA1A, 0xEA1C, 0xEA1E, 0xEA1F, 0xEA26, 0xEA2A, 0xEA2C, 0xEA2F, 0xEA35, 0xEA3A, 0xEA3E, 0xEA42, 0xEA45, 0xEB03, 0xEB04, 0xEB08, [0xEB0F, 0xEB12], 0xEB16, 0xEB19, 0xEB1E, 0xEB1F, 0xEB28, 0xEB29, 0xEB2B, 0xEB31, 0xEB35, 0xEB36, 0xEB3A, 0xEB3B, 0xEB40, 0xEB48, 0xEB49, 0xEB4D, 0xEB61, 0xEB63, 0xEB65, 0xEB6E, 0xEB6F, [0xEC08, 0xEC0E], 0xEC10, 0xEC11, 0xF103, 0xF104, 0xF109, [0xF117, 0xF11E], [0xF121, 0xF123], [0xF126, 0xF12D], 0xF12F, [0xF133, 0xF138], 0xF13D, 0xF1AB, 0xF1AC, [0xF1B1, 0xF1B5], 0xF282, 0xF283, 0xF29E, 0xF2A1, 0xF2A4, 0xF2A7, 0xF2A8, [0xF460, 0xF468], [0xF46A, 0xF472], 0xF6BE, 0xF6C4, [0xF6C6, 0xF6C8], [0xF6D3, 0xF6D6], 0xF6DE
            ]
        }]
]);
//# sourceMappingURL=chtml.js.map