(function() {
  "use strict";
  var _a2, _b, _c2;
  class ErrorHandler {
    constructor() {
      this.listeners = [];
      this.unexpectedErrorHandler = function(e) {
        setTimeout(() => {
          if (e.stack) {
            if (ErrorNoTelemetry.isErrorNoTelemetry(e)) {
              throw new ErrorNoTelemetry(e.message + "\n\n" + e.stack);
            }
            throw new Error(e.message + "\n\n" + e.stack);
          }
          throw e;
        }, 0);
      };
    }
    emit(e) {
      this.listeners.forEach((listener) => {
        listener(e);
      });
    }
    onUnexpectedError(e) {
      this.unexpectedErrorHandler(e);
      this.emit(e);
    }
    // For external errors, we don't want the listeners to be called
    onUnexpectedExternalError(e) {
      this.unexpectedErrorHandler(e);
    }
  }
  const errorHandler = new ErrorHandler();
  function onUnexpectedError(e) {
    if (!isCancellationError(e)) {
      errorHandler.onUnexpectedError(e);
    }
    return void 0;
  }
  function transformErrorForSerialization(error) {
    if (error instanceof Error) {
      const { name, message, cause } = error;
      const stack = error.stacktrace || error.stack;
      return {
        $isError: true,
        name,
        message,
        stack,
        noTelemetry: ErrorNoTelemetry.isErrorNoTelemetry(error),
        cause: cause ? transformErrorForSerialization(cause) : void 0,
        code: error.code
      };
    }
    return error;
  }
  const canceledName = "Canceled";
  function isCancellationError(error) {
    if (error instanceof CancellationError) {
      return true;
    }
    return error instanceof Error && error.name === canceledName && error.message === canceledName;
  }
  class CancellationError extends Error {
    constructor() {
      super(canceledName);
      this.name = this.message;
    }
  }
  class ErrorNoTelemetry extends Error {
    constructor(msg) {
      super(msg);
      this.name = "CodeExpectedError";
    }
    static fromError(err) {
      if (err instanceof ErrorNoTelemetry) {
        return err;
      }
      const result = new ErrorNoTelemetry();
      result.message = err.message;
      result.stack = err.stack;
      return result;
    }
    static isErrorNoTelemetry(err) {
      return err.name === "CodeExpectedError";
    }
  }
  class BugIndicatingError extends Error {
    constructor(message) {
      super(message || "An unexpected bug occurred.");
      Object.setPrototypeOf(this, BugIndicatingError.prototype);
    }
  }
  function assertNever(value, message = "Unreachable") {
    throw new Error(message);
  }
  function assert(condition, messageOrError = "unexpected state") {
    if (!condition) {
      const errorToThrow = typeof messageOrError === "string" ? new BugIndicatingError(`Assertion Failed: ${messageOrError}`) : messageOrError;
      throw errorToThrow;
    }
  }
  function assertFn(condition) {
    if (!condition()) {
      debugger;
      condition();
      onUnexpectedError(new BugIndicatingError("Assertion Failed"));
    }
  }
  function checkAdjacentItems(items, predicate) {
    let i = 0;
    while (i < items.length - 1) {
      const a = items[i];
      const b = items[i + 1];
      if (!predicate(a, b)) {
        return false;
      }
      i++;
    }
    return true;
  }
  function isString(str) {
    return typeof str === "string";
  }
  function isIterable(obj) {
    return !!obj && typeof obj[Symbol.iterator] === "function";
  }
  var Iterable;
  (function(Iterable2) {
    function is(thing) {
      return !!thing && typeof thing === "object" && typeof thing[Symbol.iterator] === "function";
    }
    Iterable2.is = is;
    const _empty2 = Object.freeze([]);
    function empty() {
      return _empty2;
    }
    Iterable2.empty = empty;
    function* single(element) {
      yield element;
    }
    Iterable2.single = single;
    function wrap(iterableOrElement) {
      if (is(iterableOrElement)) {
        return iterableOrElement;
      } else {
        return single(iterableOrElement);
      }
    }
    Iterable2.wrap = wrap;
    function from(iterable) {
      return iterable || _empty2;
    }
    Iterable2.from = from;
    function* reverse(array) {
      for (let i = array.length - 1; i >= 0; i--) {
        yield array[i];
      }
    }
    Iterable2.reverse = reverse;
    function isEmpty(iterable) {
      return !iterable || iterable[Symbol.iterator]().next().done === true;
    }
    Iterable2.isEmpty = isEmpty;
    function first(iterable) {
      return iterable[Symbol.iterator]().next().value;
    }
    Iterable2.first = first;
    function some(iterable, predicate) {
      let i = 0;
      for (const element of iterable) {
        if (predicate(element, i++)) {
          return true;
        }
      }
      return false;
    }
    Iterable2.some = some;
    function every(iterable, predicate) {
      let i = 0;
      for (const element of iterable) {
        if (!predicate(element, i++)) {
          return false;
        }
      }
      return true;
    }
    Iterable2.every = every;
    function find(iterable, predicate) {
      for (const element of iterable) {
        if (predicate(element)) {
          return element;
        }
      }
      return void 0;
    }
    Iterable2.find = find;
    function* filter(iterable, predicate) {
      for (const element of iterable) {
        if (predicate(element)) {
          yield element;
        }
      }
    }
    Iterable2.filter = filter;
    function* map(iterable, fn) {
      let index = 0;
      for (const element of iterable) {
        yield fn(element, index++);
      }
    }
    Iterable2.map = map;
    function* flatMap(iterable, fn) {
      let index = 0;
      for (const element of iterable) {
        yield* fn(element, index++);
      }
    }
    Iterable2.flatMap = flatMap;
    function* concat(...iterables) {
      for (const item of iterables) {
        if (isIterable(item)) {
          yield* item;
        } else {
          yield item;
        }
      }
    }
    Iterable2.concat = concat;
    function reduce(iterable, reducer, initialValue) {
      let value = initialValue;
      for (const element of iterable) {
        value = reducer(value, element);
      }
      return value;
    }
    Iterable2.reduce = reduce;
    function length(iterable) {
      let count = 0;
      for (const _ of iterable) {
        count++;
      }
      return count;
    }
    Iterable2.length = length;
    function* slice(arr, from2, to = arr.length) {
      if (from2 < -arr.length) {
        from2 = 0;
      }
      if (from2 < 0) {
        from2 += arr.length;
      }
      if (to < 0) {
        to += arr.length;
      } else if (to > arr.length) {
        to = arr.length;
      }
      for (; from2 < to; from2++) {
        yield arr[from2];
      }
    }
    Iterable2.slice = slice;
    function consume(iterable, atMost = Number.POSITIVE_INFINITY) {
      const consumed = [];
      if (atMost === 0) {
        return [consumed, iterable];
      }
      const iterator = iterable[Symbol.iterator]();
      for (let i = 0; i < atMost; i++) {
        const next = iterator.next();
        if (next.done) {
          return [consumed, Iterable2.empty()];
        }
        consumed.push(next.value);
      }
      return [consumed, { [Symbol.iterator]() {
        return iterator;
      } }];
    }
    Iterable2.consume = consume;
    async function asyncToArray(iterable) {
      const result = [];
      for await (const item of iterable) {
        result.push(item);
      }
      return result;
    }
    Iterable2.asyncToArray = asyncToArray;
    async function asyncToArrayFlat(iterable) {
      let result = [];
      for await (const item of iterable) {
        result = result.concat(item);
      }
      return result;
    }
    Iterable2.asyncToArrayFlat = asyncToArrayFlat;
  })(Iterable || (Iterable = {}));
  function setParentOfDisposable(child, parent) {
  }
  function dispose(arg) {
    if (Iterable.is(arg)) {
      const errors = [];
      for (const d of arg) {
        if (d) {
          try {
            d.dispose();
          } catch (e) {
            errors.push(e);
          }
        }
      }
      if (errors.length === 1) {
        throw errors[0];
      } else if (errors.length > 1) {
        throw new AggregateError(errors, "Encountered errors while disposing of store");
      }
      return Array.isArray(arg) ? [] : arg;
    } else if (arg) {
      arg.dispose();
      return arg;
    }
  }
  function combinedDisposable(...disposables) {
    const parent = toDisposable(() => dispose(disposables));
    return parent;
  }
  class FunctionDisposable {
    constructor(fn) {
      this._isDisposed = false;
      this._fn = fn;
    }
    dispose() {
      if (this._isDisposed) {
        return;
      }
      if (!this._fn) {
        throw new Error(`Unbound disposable context: Need to use an arrow function to preserve the value of this`);
      }
      this._isDisposed = true;
      this._fn();
    }
  }
  function toDisposable(fn) {
    return new FunctionDisposable(fn);
  }
  const _DisposableStore = class _DisposableStore {
    constructor() {
      this._toDispose = /* @__PURE__ */ new Set();
      this._isDisposed = false;
    }
    /**
     * Dispose of all registered disposables and mark this object as disposed.
     *
     * Any future disposables added to this object will be disposed of on `add`.
     */
    dispose() {
      if (this._isDisposed) {
        return;
      }
      this._isDisposed = true;
      this.clear();
    }
    /**
     * @return `true` if this object has been disposed of.
     */
    get isDisposed() {
      return this._isDisposed;
    }
    /**
     * Dispose of all registered disposables but do not mark this object as disposed.
     */
    clear() {
      if (this._toDispose.size === 0) {
        return;
      }
      try {
        dispose(this._toDispose);
      } finally {
        this._toDispose.clear();
      }
    }
    /**
     * Add a new {@link IDisposable disposable} to the collection.
     */
    add(o) {
      if (!o || o === Disposable.None) {
        return o;
      }
      if (o === this) {
        throw new Error("Cannot register a disposable on itself!");
      }
      if (this._isDisposed) {
        if (!_DisposableStore.DISABLE_DISPOSED_WARNING) {
          console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack);
        }
      } else {
        this._toDispose.add(o);
      }
      return o;
    }
    /**
     * Deletes a disposable from store and disposes of it. This will not throw or warn and proceed to dispose the
     * disposable even when the disposable is not part in the store.
     */
    delete(o) {
      if (!o) {
        return;
      }
      if (o === this) {
        throw new Error("Cannot dispose a disposable on itself!");
      }
      this._toDispose.delete(o);
      o.dispose();
    }
  };
  _DisposableStore.DISABLE_DISPOSED_WARNING = false;
  let DisposableStore = _DisposableStore;
  const _Disposable = class _Disposable {
    constructor() {
      this._store = new DisposableStore();
      setParentOfDisposable(this._store);
    }
    dispose() {
      this._store.dispose();
    }
    /**
     * Adds `o` to the collection of disposables managed by this object.
     */
    _register(o) {
      if (o === this) {
        throw new Error("Cannot register a disposable on itself!");
      }
      return this._store.add(o);
    }
  };
  _Disposable.None = Object.freeze({ dispose() {
  } });
  let Disposable = _Disposable;
  let Node$1 = (_a2 = class {
    constructor(element) {
      this.element = element;
      this.next = _a2.Undefined;
      this.prev = _a2.Undefined;
    }
  }, _a2.Undefined = new _a2(void 0), _a2);
  class LinkedList {
    constructor() {
      this._first = Node$1.Undefined;
      this._last = Node$1.Undefined;
      this._size = 0;
    }
    get size() {
      return this._size;
    }
    isEmpty() {
      return this._first === Node$1.Undefined;
    }
    clear() {
      let node = this._first;
      while (node !== Node$1.Undefined) {
        const next = node.next;
        node.prev = Node$1.Undefined;
        node.next = Node$1.Undefined;
        node = next;
      }
      this._first = Node$1.Undefined;
      this._last = Node$1.Undefined;
      this._size = 0;
    }
    unshift(element) {
      return this._insert(element, false);
    }
    push(element) {
      return this._insert(element, true);
    }
    _insert(element, atTheEnd) {
      const newNode = new Node$1(element);
      if (this._first === Node$1.Undefined) {
        this._first = newNode;
        this._last = newNode;
      } else if (atTheEnd) {
        const oldLast = this._last;
        this._last = newNode;
        newNode.prev = oldLast;
        oldLast.next = newNode;
      } else {
        const oldFirst = this._first;
        this._first = newNode;
        newNode.next = oldFirst;
        oldFirst.prev = newNode;
      }
      this._size += 1;
      let didRemove = false;
      return () => {
        if (!didRemove) {
          didRemove = true;
          this._remove(newNode);
        }
      };
    }
    shift() {
      if (this._first === Node$1.Undefined) {
        return void 0;
      } else {
        const res = this._first.element;
        this._remove(this._first);
        return res;
      }
    }
    pop() {
      if (this._last === Node$1.Undefined) {
        return void 0;
      } else {
        const res = this._last.element;
        this._remove(this._last);
        return res;
      }
    }
    _remove(node) {
      if (node.prev !== Node$1.Undefined && node.next !== Node$1.Undefined) {
        const anchor = node.prev;
        anchor.next = node.next;
        node.next.prev = anchor;
      } else if (node.prev === Node$1.Undefined && node.next === Node$1.Undefined) {
        this._first = Node$1.Undefined;
        this._last = Node$1.Undefined;
      } else if (node.next === Node$1.Undefined) {
        this._last = this._last.prev;
        this._last.next = Node$1.Undefined;
      } else if (node.prev === Node$1.Undefined) {
        this._first = this._first.next;
        this._first.prev = Node$1.Undefined;
      }
      this._size -= 1;
    }
    *[Symbol.iterator]() {
      let node = this._first;
      while (node !== Node$1.Undefined) {
        yield node.element;
        node = node.next;
      }
    }
  }
  const performanceNow = globalThis.performance.now.bind(globalThis.performance);
  class StopWatch {
    static create(highResolution) {
      return new StopWatch(highResolution);
    }
    constructor(highResolution) {
      this._now = highResolution === false ? Date.now : performanceNow;
      this._startTime = this._now();
      this._stopTime = -1;
    }
    stop() {
      this._stopTime = this._now();
    }
    reset() {
      this._startTime = this._now();
      this._stopTime = -1;
    }
    elapsed() {
      if (this._stopTime !== -1) {
        return this._stopTime - this._startTime;
      }
      return this._now() - this._startTime;
    }
  }
  var Event;
  (function(Event2) {
    Event2.None = () => Disposable.None;
    function defer(event, disposable) {
      return debounce(event, () => void 0, 0, void 0, true, void 0, disposable);
    }
    Event2.defer = defer;
    function once(event) {
      return (listener, thisArgs = null, disposables) => {
        let didFire = false;
        let result = void 0;
        result = event((e) => {
          if (didFire) {
            return;
          } else if (result) {
            result.dispose();
          } else {
            didFire = true;
          }
          return listener.call(thisArgs, e);
        }, null, disposables);
        if (didFire) {
          result.dispose();
        }
        return result;
      };
    }
    Event2.once = once;
    function onceIf(event, condition) {
      return Event2.once(Event2.filter(event, condition));
    }
    Event2.onceIf = onceIf;
    function map(event, map2, disposable) {
      return snapshot((listener, thisArgs = null, disposables) => event((i) => listener.call(thisArgs, map2(i)), null, disposables), disposable);
    }
    Event2.map = map;
    function forEach(event, each, disposable) {
      return snapshot((listener, thisArgs = null, disposables) => event((i) => {
        each(i);
        listener.call(thisArgs, i);
      }, null, disposables), disposable);
    }
    Event2.forEach = forEach;
    function filter(event, filter2, disposable) {
      return snapshot((listener, thisArgs = null, disposables) => event((e) => filter2(e) && listener.call(thisArgs, e), null, disposables), disposable);
    }
    Event2.filter = filter;
    function signal(event) {
      return event;
    }
    Event2.signal = signal;
    function any(...events) {
      return (listener, thisArgs = null, disposables) => {
        const disposable = combinedDisposable(...events.map((event) => event((e) => listener.call(thisArgs, e))));
        return addAndReturnDisposable(disposable, disposables);
      };
    }
    Event2.any = any;
    function reduce(event, merge, initial, disposable) {
      let output = initial;
      return map(event, (e) => {
        output = merge(output, e);
        return output;
      }, disposable);
    }
    Event2.reduce = reduce;
    function snapshot(event, disposable) {
      let listener;
      const options = {
        onWillAddFirstListener() {
          listener = event(emitter.fire, emitter);
        },
        onDidRemoveLastListener() {
          listener?.dispose();
        }
      };
      const emitter = new Emitter(options);
      disposable?.add(emitter);
      return emitter.event;
    }
    function addAndReturnDisposable(d, store) {
      if (store instanceof Array) {
        store.push(d);
      } else if (store) {
        store.add(d);
      }
      return d;
    }
    function debounce(event, merge, delay = 100, leading = false, flushOnListenerRemove = false, leakWarningThreshold, disposable) {
      let subscription;
      let output = void 0;
      let handle = void 0;
      let numDebouncedCalls = 0;
      let doFire;
      const options = {
        leakWarningThreshold,
        onWillAddFirstListener() {
          subscription = event((cur) => {
            numDebouncedCalls++;
            output = merge(output, cur);
            if (leading && !handle) {
              emitter.fire(output);
              output = void 0;
            }
            doFire = () => {
              const _output = output;
              output = void 0;
              handle = void 0;
              if (!leading || numDebouncedCalls > 1) {
                emitter.fire(_output);
              }
              numDebouncedCalls = 0;
            };
            if (typeof delay === "number") {
              if (handle) {
                clearTimeout(handle);
              }
              handle = setTimeout(doFire, delay);
            } else {
              if (handle === void 0) {
                handle = null;
                queueMicrotask(doFire);
              }
            }
          });
        },
        onWillRemoveListener() {
          if (flushOnListenerRemove && numDebouncedCalls > 0) {
            doFire?.();
          }
        },
        onDidRemoveLastListener() {
          doFire = void 0;
          subscription.dispose();
        }
      };
      const emitter = new Emitter(options);
      disposable?.add(emitter);
      return emitter.event;
    }
    Event2.debounce = debounce;
    function accumulate(event, delay = 0, disposable) {
      return Event2.debounce(event, (last, e) => {
        if (!last) {
          return [e];
        }
        last.push(e);
        return last;
      }, delay, void 0, true, void 0, disposable);
    }
    Event2.accumulate = accumulate;
    function latch(event, equals2 = (a, b) => a === b, disposable) {
      let firstCall = true;
      let cache;
      return filter(event, (value) => {
        const shouldEmit = firstCall || !equals2(value, cache);
        firstCall = false;
        cache = value;
        return shouldEmit;
      }, disposable);
    }
    Event2.latch = latch;
    function split(event, isT, disposable) {
      return [
        Event2.filter(event, isT, disposable),
        Event2.filter(event, (e) => !isT(e), disposable)
      ];
    }
    Event2.split = split;
    function buffer(event, flushAfterTimeout = false, _buffer = [], disposable) {
      let buffer2 = _buffer.slice();
      let listener = event((e) => {
        if (buffer2) {
          buffer2.push(e);
        } else {
          emitter.fire(e);
        }
      });
      if (disposable) {
        disposable.add(listener);
      }
      const flush = () => {
        buffer2?.forEach((e) => emitter.fire(e));
        buffer2 = null;
      };
      const emitter = new Emitter({
        onWillAddFirstListener() {
          if (!listener) {
            listener = event((e) => emitter.fire(e));
            if (disposable) {
              disposable.add(listener);
            }
          }
        },
        onDidAddFirstListener() {
          if (buffer2) {
            if (flushAfterTimeout) {
              setTimeout(flush);
            } else {
              flush();
            }
          }
        },
        onDidRemoveLastListener() {
          if (listener) {
            listener.dispose();
          }
          listener = null;
        }
      });
      if (disposable) {
        disposable.add(emitter);
      }
      return emitter.event;
    }
    Event2.buffer = buffer;
    function chain(event, sythensize) {
      const fn = (listener, thisArgs, disposables) => {
        const cs = sythensize(new ChainableSynthesis());
        return event(function(value) {
          const result = cs.evaluate(value);
          if (result !== HaltChainable) {
            listener.call(thisArgs, result);
          }
        }, void 0, disposables);
      };
      return fn;
    }
    Event2.chain = chain;
    const HaltChainable = Symbol("HaltChainable");
    class ChainableSynthesis {
      constructor() {
        this.steps = [];
      }
      map(fn) {
        this.steps.push(fn);
        return this;
      }
      forEach(fn) {
        this.steps.push((v) => {
          fn(v);
          return v;
        });
        return this;
      }
      filter(fn) {
        this.steps.push((v) => fn(v) ? v : HaltChainable);
        return this;
      }
      reduce(merge, initial) {
        let last = initial;
        this.steps.push((v) => {
          last = merge(last, v);
          return last;
        });
        return this;
      }
      latch(equals2 = (a, b) => a === b) {
        let firstCall = true;
        let cache;
        this.steps.push((value) => {
          const shouldEmit = firstCall || !equals2(value, cache);
          firstCall = false;
          cache = value;
          return shouldEmit ? value : HaltChainable;
        });
        return this;
      }
      evaluate(value) {
        for (const step of this.steps) {
          value = step(value);
          if (value === HaltChainable) {
            break;
          }
        }
        return value;
      }
    }
    function fromNodeEventEmitter(emitter, eventName, map2 = (id) => id) {
      const fn = (...args) => result.fire(map2(...args));
      const onFirstListenerAdd = () => emitter.on(eventName, fn);
      const onLastListenerRemove = () => emitter.removeListener(eventName, fn);
      const result = new Emitter({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
      return result.event;
    }
    Event2.fromNodeEventEmitter = fromNodeEventEmitter;
    function fromDOMEventEmitter(emitter, eventName, map2 = (id) => id) {
      const fn = (...args) => result.fire(map2(...args));
      const onFirstListenerAdd = () => emitter.addEventListener(eventName, fn);
      const onLastListenerRemove = () => emitter.removeEventListener(eventName, fn);
      const result = new Emitter({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
      return result.event;
    }
    Event2.fromDOMEventEmitter = fromDOMEventEmitter;
    function toPromise(event, disposables) {
      let cancelRef;
      const promise = new Promise((resolve, reject) => {
        const listener = once(event)(resolve, null, disposables);
        cancelRef = () => listener.dispose();
      });
      promise.cancel = cancelRef;
      return promise;
    }
    Event2.toPromise = toPromise;
    function forward(from, to) {
      return from((e) => to.fire(e));
    }
    Event2.forward = forward;
    function runAndSubscribe(event, handler, initial) {
      handler(initial);
      return event((e) => handler(e));
    }
    Event2.runAndSubscribe = runAndSubscribe;
    class EmitterObserver {
      constructor(_observable, store) {
        this._observable = _observable;
        this._counter = 0;
        this._hasChanged = false;
        const options = {
          onWillAddFirstListener: () => {
            _observable.addObserver(this);
            this._observable.reportChanges();
          },
          onDidRemoveLastListener: () => {
            _observable.removeObserver(this);
          }
        };
        this.emitter = new Emitter(options);
        if (store) {
          store.add(this.emitter);
        }
      }
      beginUpdate(_observable) {
        this._counter++;
      }
      handlePossibleChange(_observable) {
      }
      handleChange(_observable, _change) {
        this._hasChanged = true;
      }
      endUpdate(_observable) {
        this._counter--;
        if (this._counter === 0) {
          this._observable.reportChanges();
          if (this._hasChanged) {
            this._hasChanged = false;
            this.emitter.fire(this._observable.get());
          }
        }
      }
    }
    function fromObservable(obs, store) {
      const observer = new EmitterObserver(obs, store);
      return observer.emitter.event;
    }
    Event2.fromObservable = fromObservable;
    function fromObservableLight(observable) {
      return (listener, thisArgs, disposables) => {
        let count = 0;
        let didChange = false;
        const observer = {
          beginUpdate() {
            count++;
          },
          endUpdate() {
            count--;
            if (count === 0) {
              observable.reportChanges();
              if (didChange) {
                didChange = false;
                listener.call(thisArgs);
              }
            }
          },
          handlePossibleChange() {
          },
          handleChange() {
            didChange = true;
          }
        };
        observable.addObserver(observer);
        observable.reportChanges();
        const disposable = {
          dispose() {
            observable.removeObserver(observer);
          }
        };
        if (disposables instanceof DisposableStore) {
          disposables.add(disposable);
        } else if (Array.isArray(disposables)) {
          disposables.push(disposable);
        }
        return disposable;
      };
    }
    Event2.fromObservableLight = fromObservableLight;
  })(Event || (Event = {}));
  const _EventProfiling = class _EventProfiling {
    constructor(name) {
      this.listenerCount = 0;
      this.invocationCount = 0;
      this.elapsedOverall = 0;
      this.durations = [];
      this.name = `${name}_${_EventProfiling._idPool++}`;
      _EventProfiling.all.add(this);
    }
    start(listenerCount) {
      this._stopWatch = new StopWatch();
      this.listenerCount = listenerCount;
    }
    stop() {
      if (this._stopWatch) {
        const elapsed = this._stopWatch.elapsed();
        this.durations.push(elapsed);
        this.elapsedOverall += elapsed;
        this.invocationCount += 1;
        this._stopWatch = void 0;
      }
    }
  };
  _EventProfiling.all = /* @__PURE__ */ new Set();
  _EventProfiling._idPool = 0;
  let EventProfiling = _EventProfiling;
  let _globalLeakWarningThreshold = -1;
  const _LeakageMonitor = class _LeakageMonitor {
    constructor(_errorHandler, threshold, name = (_LeakageMonitor._idPool++).toString(16).padStart(3, "0")) {
      this._errorHandler = _errorHandler;
      this.threshold = threshold;
      this.name = name;
      this._warnCountdown = 0;
    }
    dispose() {
      this._stacks?.clear();
    }
    check(stack, listenerCount) {
      const threshold = this.threshold;
      if (threshold <= 0 || listenerCount < threshold) {
        return void 0;
      }
      if (!this._stacks) {
        this._stacks = /* @__PURE__ */ new Map();
      }
      const count = this._stacks.get(stack.value) || 0;
      this._stacks.set(stack.value, count + 1);
      this._warnCountdown -= 1;
      if (this._warnCountdown <= 0) {
        this._warnCountdown = threshold * 0.5;
        const [topStack, topCount] = this.getMostFrequentStack();
        const message = `[${this.name}] potential listener LEAK detected, having ${listenerCount} listeners already. MOST frequent listener (${topCount}):`;
        console.warn(message);
        console.warn(topStack);
        const error = new ListenerLeakError(message, topStack);
        this._errorHandler(error);
      }
      return () => {
        const count2 = this._stacks.get(stack.value) || 0;
        this._stacks.set(stack.value, count2 - 1);
      };
    }
    getMostFrequentStack() {
      if (!this._stacks) {
        return void 0;
      }
      let topStack;
      let topCount = 0;
      for (const [stack, count] of this._stacks) {
        if (!topStack || topCount < count) {
          topStack = [stack, count];
          topCount = count;
        }
      }
      return topStack;
    }
  };
  _LeakageMonitor._idPool = 1;
  let LeakageMonitor = _LeakageMonitor;
  class Stacktrace {
    static create() {
      const err = new Error();
      return new Stacktrace(err.stack ?? "");
    }
    constructor(value) {
      this.value = value;
    }
    print() {
      console.warn(this.value.split("\n").slice(2).join("\n"));
    }
  }
  class ListenerLeakError extends Error {
    constructor(message, stack) {
      super(message);
      this.name = "ListenerLeakError";
      this.stack = stack;
    }
  }
  class ListenerRefusalError extends Error {
    constructor(message, stack) {
      super(message);
      this.name = "ListenerRefusalError";
      this.stack = stack;
    }
  }
  class UniqueContainer {
    constructor(value) {
      this.value = value;
    }
  }
  const compactionThreshold = 2;
  class Emitter {
    constructor(options) {
      this._size = 0;
      this._options = options;
      this._leakageMon = this._options?.leakWarningThreshold ? new LeakageMonitor(options?.onListenerError ?? onUnexpectedError, this._options?.leakWarningThreshold ?? _globalLeakWarningThreshold) : void 0;
      this._perfMon = this._options?._profName ? new EventProfiling(this._options._profName) : void 0;
      this._deliveryQueue = this._options?.deliveryQueue;
    }
    dispose() {
      if (!this._disposed) {
        this._disposed = true;
        if (this._deliveryQueue?.current === this) {
          this._deliveryQueue.reset();
        }
        if (this._listeners) {
          this._listeners = void 0;
          this._size = 0;
        }
        this._options?.onDidRemoveLastListener?.();
        this._leakageMon?.dispose();
      }
    }
    /**
     * For the public to allow to subscribe
     * to events from this Emitter
     */
    get event() {
      this._event ??= (callback, thisArgs, disposables) => {
        if (this._leakageMon && this._size > this._leakageMon.threshold ** 2) {
          const message = `[${this._leakageMon.name}] REFUSES to accept new listeners because it exceeded its threshold by far (${this._size} vs ${this._leakageMon.threshold})`;
          console.warn(message);
          const tuple = this._leakageMon.getMostFrequentStack() ?? ["UNKNOWN stack", -1];
          const error = new ListenerRefusalError(`${message}. HINT: Stack shows most frequent listener (${tuple[1]}-times)`, tuple[0]);
          const errorHandler2 = this._options?.onListenerError || onUnexpectedError;
          errorHandler2(error);
          return Disposable.None;
        }
        if (this._disposed) {
          return Disposable.None;
        }
        if (thisArgs) {
          callback = callback.bind(thisArgs);
        }
        const contained = new UniqueContainer(callback);
        let removeMonitor;
        if (this._leakageMon && this._size >= Math.ceil(this._leakageMon.threshold * 0.2)) {
          contained.stack = Stacktrace.create();
          removeMonitor = this._leakageMon.check(contained.stack, this._size + 1);
        }
        if (!this._listeners) {
          this._options?.onWillAddFirstListener?.(this);
          this._listeners = contained;
          this._options?.onDidAddFirstListener?.(this);
        } else if (this._listeners instanceof UniqueContainer) {
          this._deliveryQueue ??= new EventDeliveryQueuePrivate();
          this._listeners = [this._listeners, contained];
        } else {
          this._listeners.push(contained);
        }
        this._options?.onDidAddListener?.(this);
        this._size++;
        const result = toDisposable(() => {
          removeMonitor?.();
          this._removeListener(contained);
        });
        if (disposables instanceof DisposableStore) {
          disposables.add(result);
        } else if (Array.isArray(disposables)) {
          disposables.push(result);
        }
        return result;
      };
      return this._event;
    }
    _removeListener(listener) {
      this._options?.onWillRemoveListener?.(this);
      if (!this._listeners) {
        return;
      }
      if (this._size === 1) {
        this._listeners = void 0;
        this._options?.onDidRemoveLastListener?.(this);
        this._size = 0;
        return;
      }
      const listeners = this._listeners;
      const index = listeners.indexOf(listener);
      if (index === -1) {
        console.log("disposed?", this._disposed);
        console.log("size?", this._size);
        console.log("arr?", JSON.stringify(this._listeners));
        throw new Error("Attempted to dispose unknown listener");
      }
      this._size--;
      listeners[index] = void 0;
      const adjustDeliveryQueue = this._deliveryQueue.current === this;
      if (this._size * compactionThreshold <= listeners.length) {
        let n = 0;
        for (let i = 0; i < listeners.length; i++) {
          if (listeners[i]) {
            listeners[n++] = listeners[i];
          } else if (adjustDeliveryQueue && n < this._deliveryQueue.end) {
            this._deliveryQueue.end--;
            if (n < this._deliveryQueue.i) {
              this._deliveryQueue.i--;
            }
          }
        }
        listeners.length = n;
      }
    }
    _deliver(listener, value) {
      if (!listener) {
        return;
      }
      const errorHandler2 = this._options?.onListenerError || onUnexpectedError;
      if (!errorHandler2) {
        listener.value(value);
        return;
      }
      try {
        listener.value(value);
      } catch (e) {
        errorHandler2(e);
      }
    }
    /** Delivers items in the queue. Assumes the queue is ready to go. */
    _deliverQueue(dq) {
      const listeners = dq.current._listeners;
      while (dq.i < dq.end) {
        this._deliver(listeners[dq.i++], dq.value);
      }
      dq.reset();
    }
    /**
     * To be kept private to fire an event to
     * subscribers
     */
    fire(event) {
      if (this._deliveryQueue?.current) {
        this._deliverQueue(this._deliveryQueue);
        this._perfMon?.stop();
      }
      this._perfMon?.start(this._size);
      if (!this._listeners) ;
      else if (this._listeners instanceof UniqueContainer) {
        this._deliver(this._listeners, event);
      } else {
        const dq = this._deliveryQueue;
        dq.enqueue(this, event, this._listeners.length);
        this._deliverQueue(dq);
      }
      this._perfMon?.stop();
    }
    hasListeners() {
      return this._size > 0;
    }
  }
  class EventDeliveryQueuePrivate {
    constructor() {
      this.i = -1;
      this.end = 0;
    }
    enqueue(emitter, value, end) {
      this.i = 0;
      this.end = end;
      this.current = emitter;
      this.value = value;
    }
    reset() {
      this.i = this.end;
      this.current = void 0;
      this.value = void 0;
    }
  }
  function getNLSMessages() {
    return globalThis._VSCODE_NLS_MESSAGES;
  }
  function getNLSLanguage() {
    return globalThis._VSCODE_NLS_LANGUAGE;
  }
  const isPseudo = getNLSLanguage() === "pseudo" || typeof document !== "undefined" && document.location && typeof document.location.hash === "string" && document.location.hash.indexOf("pseudo=true") >= 0;
  function _format$1(message, args) {
    let result;
    if (args.length === 0) {
      result = message;
    } else {
      result = message.replace(/\{(\d+)\}/g, (match, rest) => {
        const index = rest[0];
        const arg = args[index];
        let result2 = match;
        if (typeof arg === "string") {
          result2 = arg;
        } else if (typeof arg === "number" || typeof arg === "boolean" || arg === void 0 || arg === null) {
          result2 = String(arg);
        }
        return result2;
      });
    }
    if (isPseudo) {
      result = "［" + result.replace(/[aouei]/g, "$&$&") + "］";
    }
    return result;
  }
  function localize(data, message, ...args) {
    if (typeof data === "number") {
      return _format$1(lookupMessage(data, message), args);
    }
    return _format$1(message, args);
  }
  function lookupMessage(index, fallback) {
    const message = getNLSMessages()?.[index];
    if (typeof message !== "string") {
      if (typeof fallback === "string") {
        return fallback;
      }
      throw new Error(`!!! NLS MISSING: ${index} !!!`);
    }
    return message;
  }
  const LANGUAGE_DEFAULT = "en";
  let _isWindows = false;
  let _isMacintosh = false;
  let _isLinux = false;
  let _locale = void 0;
  let _language = LANGUAGE_DEFAULT;
  let _platformLocale = LANGUAGE_DEFAULT;
  let _translationsConfigFile = void 0;
  let _userAgent = void 0;
  const $globalThis = globalThis;
  let nodeProcess = void 0;
  if (typeof $globalThis.vscode !== "undefined" && typeof $globalThis.vscode.process !== "undefined") {
    nodeProcess = $globalThis.vscode.process;
  } else if (typeof process !== "undefined" && typeof process?.versions?.node === "string") {
    nodeProcess = process;
  }
  const isElectronProcess = typeof nodeProcess?.versions?.electron === "string";
  const isElectronRenderer = isElectronProcess && nodeProcess?.type === "renderer";
  if (typeof nodeProcess === "object") {
    _isWindows = nodeProcess.platform === "win32";
    _isMacintosh = nodeProcess.platform === "darwin";
    _isLinux = nodeProcess.platform === "linux";
    _isLinux && !!nodeProcess.env["SNAP"] && !!nodeProcess.env["SNAP_REVISION"];
    !!nodeProcess.env["CI"] || !!nodeProcess.env["BUILD_ARTIFACTSTAGINGDIRECTORY"] || !!nodeProcess.env["GITHUB_WORKSPACE"];
    _locale = LANGUAGE_DEFAULT;
    _language = LANGUAGE_DEFAULT;
    const rawNlsConfig = nodeProcess.env["VSCODE_NLS_CONFIG"];
    if (rawNlsConfig) {
      try {
        const nlsConfig = JSON.parse(rawNlsConfig);
        _locale = nlsConfig.userLocale;
        _platformLocale = nlsConfig.osLocale;
        _language = nlsConfig.resolvedLanguage || LANGUAGE_DEFAULT;
        _translationsConfigFile = nlsConfig.languagePack?.translationsConfigFile;
      } catch (e) {
      }
    }
  } else if (typeof navigator === "object" && !isElectronRenderer) {
    _userAgent = navigator.userAgent;
    _isWindows = _userAgent.indexOf("Windows") >= 0;
    _isMacintosh = _userAgent.indexOf("Macintosh") >= 0;
    (_userAgent.indexOf("Macintosh") >= 0 || _userAgent.indexOf("iPad") >= 0 || _userAgent.indexOf("iPhone") >= 0) && !!navigator.maxTouchPoints && navigator.maxTouchPoints > 0;
    _isLinux = _userAgent.indexOf("Linux") >= 0;
    _userAgent?.indexOf("Mobi") >= 0;
    _language = getNLSLanguage() || LANGUAGE_DEFAULT;
    _locale = navigator.language.toLowerCase();
    _platformLocale = _locale;
  } else {
    console.error("Unable to resolve platform.");
  }
  const isWindows = _isWindows;
  const isMacintosh = _isMacintosh;
  const userAgent = _userAgent;
  const setTimeout0IsFaster = typeof $globalThis.postMessage === "function" && !$globalThis.importScripts;
  (() => {
    if (setTimeout0IsFaster) {
      const pending = [];
      $globalThis.addEventListener("message", (e) => {
        if (e.data && e.data.vscodeScheduleAsyncWork) {
          for (let i = 0, len = pending.length; i < len; i++) {
            const candidate = pending[i];
            if (candidate.id === e.data.vscodeScheduleAsyncWork) {
              pending.splice(i, 1);
              candidate.callback();
              return;
            }
          }
        }
      });
      let lastId = 0;
      return (callback) => {
        const myId = ++lastId;
        pending.push({
          id: myId,
          callback
        });
        $globalThis.postMessage({ vscodeScheduleAsyncWork: myId }, "*");
      };
    }
    return (callback) => setTimeout(callback);
  })();
  const isChrome = !!(userAgent && userAgent.indexOf("Chrome") >= 0);
  !!(userAgent && userAgent.indexOf("Firefox") >= 0);
  !!(!isChrome && (userAgent && userAgent.indexOf("Safari") >= 0));
  !!(userAgent && userAgent.indexOf("Edg/") >= 0);
  !!(userAgent && userAgent.indexOf("Android") >= 0);
  function identity(t2) {
    return t2;
  }
  class LRUCachedFunction {
    constructor(arg1, arg2) {
      this.lastCache = void 0;
      this.lastArgKey = void 0;
      if (typeof arg1 === "function") {
        this._fn = arg1;
        this._computeKey = identity;
      } else {
        this._fn = arg2;
        this._computeKey = arg1.getCacheKey;
      }
    }
    get(arg) {
      const key = this._computeKey(arg);
      if (this.lastArgKey !== key) {
        this.lastArgKey = key;
        this.lastCache = this._fn(arg);
      }
      return this.lastCache;
    }
  }
  var LazyValueState;
  (function(LazyValueState2) {
    LazyValueState2[LazyValueState2["Uninitialized"] = 0] = "Uninitialized";
    LazyValueState2[LazyValueState2["Running"] = 1] = "Running";
    LazyValueState2[LazyValueState2["Completed"] = 2] = "Completed";
  })(LazyValueState || (LazyValueState = {}));
  class Lazy {
    constructor(executor) {
      this.executor = executor;
      this._state = LazyValueState.Uninitialized;
    }
    /**
     * Get the wrapped value.
     *
     * This will force evaluation of the lazy value if it has not been resolved yet. Lazy values are only
     * resolved once. `getValue` will re-throw exceptions that are hit while resolving the value
     */
    get value() {
      if (this._state === LazyValueState.Uninitialized) {
        this._state = LazyValueState.Running;
        try {
          this._value = this.executor();
        } catch (err) {
          this._error = err;
        } finally {
          this._state = LazyValueState.Completed;
        }
      } else if (this._state === LazyValueState.Running) {
        throw new Error("Cannot read the value of a lazy that is being initialized");
      }
      if (this._error) {
        throw this._error;
      }
      return this._value;
    }
    /**
     * Get the wrapped value without forcing evaluation.
     */
    get rawValue() {
      return this._value;
    }
  }
  function escapeRegExpCharacters(value) {
    return value.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g, "\\$&");
  }
  function regExpLeadsToEndlessLoop(regexp) {
    if (regexp.source === "^" || regexp.source === "^$" || regexp.source === "$" || regexp.source === "^\\s*$") {
      return false;
    }
    const match = regexp.exec("");
    return !!(match && regexp.lastIndex === 0);
  }
  function splitLines(str) {
    return str.split(/\r\n|\r|\n/);
  }
  function firstNonWhitespaceIndex(str) {
    for (let i = 0, len = str.length; i < len; i++) {
      const chCode = str.charCodeAt(i);
      if (chCode !== 32 && chCode !== 9) {
        return i;
      }
    }
    return -1;
  }
  function lastNonWhitespaceIndex(str, startIndex = str.length - 1) {
    for (let i = startIndex; i >= 0; i--) {
      const chCode = str.charCodeAt(i);
      if (chCode !== 32 && chCode !== 9) {
        return i;
      }
    }
    return -1;
  }
  function isUpperAsciiLetter(code) {
    return code >= 65 && code <= 90;
  }
  function commonPrefixLength(a, b) {
    const len = Math.min(a.length, b.length);
    let i;
    for (i = 0; i < len; i++) {
      if (a.charCodeAt(i) !== b.charCodeAt(i)) {
        return i;
      }
    }
    return len;
  }
  function commonSuffixLength(a, b) {
    const len = Math.min(a.length, b.length);
    let i;
    const aLastIndex = a.length - 1;
    const bLastIndex = b.length - 1;
    for (i = 0; i < len; i++) {
      if (a.charCodeAt(aLastIndex - i) !== b.charCodeAt(bLastIndex - i)) {
        return i;
      }
    }
    return len;
  }
  function isHighSurrogate(charCode) {
    return 55296 <= charCode && charCode <= 56319;
  }
  function isLowSurrogate(charCode) {
    return 56320 <= charCode && charCode <= 57343;
  }
  function computeCodePoint(highSurrogate, lowSurrogate) {
    return (highSurrogate - 55296 << 10) + (lowSurrogate - 56320) + 65536;
  }
  function getNextCodePoint(str, len, offset) {
    const charCode = str.charCodeAt(offset);
    if (isHighSurrogate(charCode) && offset + 1 < len) {
      const nextCharCode = str.charCodeAt(offset + 1);
      if (isLowSurrogate(nextCharCode)) {
        return computeCodePoint(charCode, nextCharCode);
      }
    }
    return charCode;
  }
  const IS_BASIC_ASCII = /^[\t\n\r\x20-\x7E]*$/;
  function isBasicASCII(str) {
    return IS_BASIC_ASCII.test(str);
  }
  const _AmbiguousCharacters = class _AmbiguousCharacters {
    static getInstance(locales) {
      return _AmbiguousCharacters.cache.get(Array.from(locales));
    }
    static getLocales() {
      return _AmbiguousCharacters._locales.value;
    }
    constructor(confusableDictionary) {
      this.confusableDictionary = confusableDictionary;
    }
    isAmbiguous(codePoint) {
      return this.confusableDictionary.has(codePoint);
    }
    /**
     * Returns the non basic ASCII code point that the given code point can be confused,
     * or undefined if such code point does note exist.
     */
    getPrimaryConfusable(codePoint) {
      return this.confusableDictionary.get(codePoint);
    }
    getConfusableCodePoints() {
      return new Set(this.confusableDictionary.keys());
    }
  };
  _AmbiguousCharacters.ambiguousCharacterData = new Lazy(() => {
    return JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,1523,96,8242,96,1370,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,118002,50,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,118003,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,118004,52,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,118005,53,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,118006,54,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,118007,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,118008,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,118009,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,117974,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,117975,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71913,67,71922,67,65315,67,8557,67,8450,67,8493,67,117976,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,117977,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,117978,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,117979,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,117980,71,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,117981,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,117983,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,117984,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,118001,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,117982,108,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,117985,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,117986,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,117987,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,118000,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,117988,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,117989,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,117990,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,117991,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,117992,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,117993,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,117994,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,117995,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71910,87,71919,87,117996,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,117997,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,117998,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,71909,90,66293,90,65338,90,8484,90,8488,90,117999,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65283,35,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125,119846,109],"_default":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"cs":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"es":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"fr":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"it":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ja":[8211,45,8218,44,65281,33,8216,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65292,44,65297,49,65307,59],"ko":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pt-BR":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ru":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"zh-hans":[160,32,65374,126,8218,44,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65297,49],"zh-hant":[8211,45,65374,126,8218,44,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89]}');
  });
  _AmbiguousCharacters.cache = new LRUCachedFunction({ getCacheKey: JSON.stringify }, (locales) => {
    function arrayToMap(arr) {
      const result = /* @__PURE__ */ new Map();
      for (let i = 0; i < arr.length; i += 2) {
        result.set(arr[i], arr[i + 1]);
      }
      return result;
    }
    function mergeMaps(map1, map2) {
      const result = new Map(map1);
      for (const [key, value] of map2) {
        result.set(key, value);
      }
      return result;
    }
    function intersectMaps(map1, map2) {
      if (!map1) {
        return map2;
      }
      const result = /* @__PURE__ */ new Map();
      for (const [key, value] of map1) {
        if (map2.has(key)) {
          result.set(key, value);
        }
      }
      return result;
    }
    const data = _AmbiguousCharacters.ambiguousCharacterData.value;
    let filteredLocales = locales.filter((l) => !l.startsWith("_") && l in data);
    if (filteredLocales.length === 0) {
      filteredLocales = ["_default"];
    }
    let languageSpecificMap = void 0;
    for (const locale of filteredLocales) {
      const map2 = arrayToMap(data[locale]);
      languageSpecificMap = intersectMaps(languageSpecificMap, map2);
    }
    const commonMap = arrayToMap(data["_common"]);
    const map = mergeMaps(commonMap, languageSpecificMap);
    return new _AmbiguousCharacters(map);
  });
  _AmbiguousCharacters._locales = new Lazy(() => Object.keys(_AmbiguousCharacters.ambiguousCharacterData.value).filter((k) => !k.startsWith("_")));
  let AmbiguousCharacters = _AmbiguousCharacters;
  const _InvisibleCharacters = class _InvisibleCharacters {
    static getRawData() {
      return JSON.parse('{"_common":[11,12,13,127,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999],"cs":[173,8203,12288],"de":[173,8203,12288],"es":[8203,12288],"fr":[173,8203,12288],"it":[160,173,12288],"ja":[173],"ko":[173,12288],"pl":[173,8203,12288],"pt-BR":[173,8203,12288],"qps-ploc":[160,173,8203,12288],"ru":[173,12288],"tr":[160,173,8203,12288],"zh-hans":[160,173,8203,12288],"zh-hant":[173,12288]}');
    }
    static getData() {
      if (!this._data) {
        this._data = new Set([...Object.values(_InvisibleCharacters.getRawData())].flat());
      }
      return this._data;
    }
    static isInvisibleCharacter(codePoint) {
      return _InvisibleCharacters.getData().has(codePoint);
    }
    static get codePoints() {
      return _InvisibleCharacters.getData();
    }
  };
  _InvisibleCharacters._data = void 0;
  let InvisibleCharacters = _InvisibleCharacters;
  const DEFAULT_CHANNEL = "default";
  const INITIALIZE = "$initialize";
  class RequestMessage {
    constructor(vsWorker, req, channel, method, args) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.channel = channel;
      this.method = method;
      this.args = args;
      this.type = 0;
    }
  }
  class ReplyMessage {
    constructor(vsWorker, seq, res, err) {
      this.vsWorker = vsWorker;
      this.seq = seq;
      this.res = res;
      this.err = err;
      this.type = 1;
    }
  }
  class SubscribeEventMessage {
    constructor(vsWorker, req, channel, eventName, arg) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.channel = channel;
      this.eventName = eventName;
      this.arg = arg;
      this.type = 2;
    }
  }
  class EventMessage {
    constructor(vsWorker, req, event) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.event = event;
      this.type = 3;
    }
  }
  class UnsubscribeEventMessage {
    constructor(vsWorker, req) {
      this.vsWorker = vsWorker;
      this.req = req;
      this.type = 4;
    }
  }
  class WebWorkerProtocol {
    constructor(handler) {
      this._workerId = -1;
      this._handler = handler;
      this._lastSentReq = 0;
      this._pendingReplies = /* @__PURE__ */ Object.create(null);
      this._pendingEmitters = /* @__PURE__ */ new Map();
      this._pendingEvents = /* @__PURE__ */ new Map();
    }
    setWorkerId(workerId) {
      this._workerId = workerId;
    }
    sendMessage(channel, method, args) {
      const req = String(++this._lastSentReq);
      return new Promise((resolve, reject) => {
        this._pendingReplies[req] = {
          resolve,
          reject
        };
        this._send(new RequestMessage(this._workerId, req, channel, method, args));
      });
    }
    listen(channel, eventName, arg) {
      let req = null;
      const emitter = new Emitter({
        onWillAddFirstListener: () => {
          req = String(++this._lastSentReq);
          this._pendingEmitters.set(req, emitter);
          this._send(new SubscribeEventMessage(this._workerId, req, channel, eventName, arg));
        },
        onDidRemoveLastListener: () => {
          this._pendingEmitters.delete(req);
          this._send(new UnsubscribeEventMessage(this._workerId, req));
          req = null;
        }
      });
      return emitter.event;
    }
    handleMessage(message) {
      if (!message || !message.vsWorker) {
        return;
      }
      if (this._workerId !== -1 && message.vsWorker !== this._workerId) {
        return;
      }
      this._handleMessage(message);
    }
    createProxyToRemoteChannel(channel, sendMessageBarrier) {
      const handler = {
        get: (target, name) => {
          if (typeof name === "string" && !target[name]) {
            if (propertyIsDynamicEvent(name)) {
              target[name] = (arg) => {
                return this.listen(channel, name, arg);
              };
            } else if (propertyIsEvent(name)) {
              target[name] = this.listen(channel, name, void 0);
            } else if (name.charCodeAt(0) === 36) {
              target[name] = async (...myArgs) => {
                await sendMessageBarrier?.();
                return this.sendMessage(channel, name, myArgs);
              };
            }
          }
          return target[name];
        }
      };
      return new Proxy(/* @__PURE__ */ Object.create(null), handler);
    }
    _handleMessage(msg) {
      switch (msg.type) {
        case 1:
          return this._handleReplyMessage(msg);
        case 0:
          return this._handleRequestMessage(msg);
        case 2:
          return this._handleSubscribeEventMessage(msg);
        case 3:
          return this._handleEventMessage(msg);
        case 4:
          return this._handleUnsubscribeEventMessage(msg);
      }
    }
    _handleReplyMessage(replyMessage) {
      if (!this._pendingReplies[replyMessage.seq]) {
        console.warn("Got reply to unknown seq");
        return;
      }
      const reply = this._pendingReplies[replyMessage.seq];
      delete this._pendingReplies[replyMessage.seq];
      if (replyMessage.err) {
        let err = replyMessage.err;
        if (replyMessage.err.$isError) {
          err = new Error();
          err.name = replyMessage.err.name;
          err.message = replyMessage.err.message;
          err.stack = replyMessage.err.stack;
        }
        reply.reject(err);
        return;
      }
      reply.resolve(replyMessage.res);
    }
    _handleRequestMessage(requestMessage) {
      const req = requestMessage.req;
      const result = this._handler.handleMessage(requestMessage.channel, requestMessage.method, requestMessage.args);
      result.then((r) => {
        this._send(new ReplyMessage(this._workerId, req, r, void 0));
      }, (e) => {
        if (e.detail instanceof Error) {
          e.detail = transformErrorForSerialization(e.detail);
        }
        this._send(new ReplyMessage(this._workerId, req, void 0, transformErrorForSerialization(e)));
      });
    }
    _handleSubscribeEventMessage(msg) {
      const req = msg.req;
      const disposable = this._handler.handleEvent(msg.channel, msg.eventName, msg.arg)((event) => {
        this._send(new EventMessage(this._workerId, req, event));
      });
      this._pendingEvents.set(req, disposable);
    }
    _handleEventMessage(msg) {
      if (!this._pendingEmitters.has(msg.req)) {
        console.warn("Got event for unknown req");
        return;
      }
      this._pendingEmitters.get(msg.req).fire(msg.event);
    }
    _handleUnsubscribeEventMessage(msg) {
      if (!this._pendingEvents.has(msg.req)) {
        console.warn("Got unsubscribe for unknown req");
        return;
      }
      this._pendingEvents.get(msg.req).dispose();
      this._pendingEvents.delete(msg.req);
    }
    _send(msg) {
      const transfer = [];
      if (msg.type === 0) {
        for (let i = 0; i < msg.args.length; i++) {
          if (msg.args[i] instanceof ArrayBuffer) {
            transfer.push(msg.args[i]);
          }
        }
      } else if (msg.type === 1) {
        if (msg.res instanceof ArrayBuffer) {
          transfer.push(msg.res);
        }
      }
      this._handler.sendMessage(msg, transfer);
    }
  }
  function propertyIsEvent(name) {
    return name[0] === "o" && name[1] === "n" && isUpperAsciiLetter(name.charCodeAt(2));
  }
  function propertyIsDynamicEvent(name) {
    return /^onDynamic/.test(name) && isUpperAsciiLetter(name.charCodeAt(9));
  }
  class WebWorkerServer {
    constructor(postMessage, requestHandlerFactory) {
      this._localChannels = /* @__PURE__ */ new Map();
      this._remoteChannels = /* @__PURE__ */ new Map();
      this._protocol = new WebWorkerProtocol({
        sendMessage: (msg, transfer) => {
          postMessage(msg, transfer);
        },
        handleMessage: (channel, method, args) => this._handleMessage(channel, method, args),
        handleEvent: (channel, eventName, arg) => this._handleEvent(channel, eventName, arg)
      });
      this.requestHandler = requestHandlerFactory(this);
    }
    onmessage(msg) {
      this._protocol.handleMessage(msg);
    }
    _handleMessage(channel, method, args) {
      if (channel === DEFAULT_CHANNEL && method === INITIALIZE) {
        return this.initialize(args[0]);
      }
      const requestHandler = channel === DEFAULT_CHANNEL ? this.requestHandler : this._localChannels.get(channel);
      if (!requestHandler) {
        return Promise.reject(new Error(`Missing channel ${channel} on worker thread`));
      }
      if (typeof requestHandler[method] !== "function") {
        return Promise.reject(new Error(`Missing method ${method} on worker thread channel ${channel}`));
      }
      try {
        return Promise.resolve(requestHandler[method].apply(requestHandler, args));
      } catch (e) {
        return Promise.reject(e);
      }
    }
    _handleEvent(channel, eventName, arg) {
      const requestHandler = channel === DEFAULT_CHANNEL ? this.requestHandler : this._localChannels.get(channel);
      if (!requestHandler) {
        throw new Error(`Missing channel ${channel} on worker thread`);
      }
      if (propertyIsDynamicEvent(eventName)) {
        const event = requestHandler[eventName].call(requestHandler, arg);
        if (typeof event !== "function") {
          throw new Error(`Missing dynamic event ${eventName} on request handler.`);
        }
        return event;
      }
      if (propertyIsEvent(eventName)) {
        const event = requestHandler[eventName];
        if (typeof event !== "function") {
          throw new Error(`Missing event ${eventName} on request handler.`);
        }
        return event;
      }
      throw new Error(`Malformed event name ${eventName}`);
    }
    getChannel(channel) {
      if (!this._remoteChannels.has(channel)) {
        const inst = this._protocol.createProxyToRemoteChannel(channel);
        this._remoteChannels.set(channel, inst);
      }
      return this._remoteChannels.get(channel);
    }
    async initialize(workerId) {
      this._protocol.setWorkerId(workerId);
    }
  }
  let initialized = false;
  function initialize$1(factory) {
    if (initialized) {
      throw new Error("WebWorker already initialized!");
    }
    initialized = true;
    const webWorkerServer = new WebWorkerServer((msg) => globalThis.postMessage(msg), (workerServer) => factory(workerServer));
    globalThis.onmessage = (e) => {
      webWorkerServer.onmessage(e.data);
    };
    return webWorkerServer;
  }
  class DiffChange {
    /**
     * Constructs a new DiffChange with the given sequence information
     * and content.
     */
    constructor(originalStart, originalLength, modifiedStart, modifiedLength) {
      this.originalStart = originalStart;
      this.originalLength = originalLength;
      this.modifiedStart = modifiedStart;
      this.modifiedLength = modifiedLength;
    }
    /**
     * The end point (exclusive) of the change in the original sequence.
     */
    getOriginalEnd() {
      return this.originalStart + this.originalLength;
    }
    /**
     * The end point (exclusive) of the change in the modified sequence.
     */
    getModifiedEnd() {
      return this.modifiedStart + this.modifiedLength;
    }
  }
  new Lazy(() => new Uint8Array(256));
  function numberHash(val, initialHashVal) {
    return (initialHashVal << 5) - initialHashVal + val | 0;
  }
  function stringHash(s, hashVal) {
    hashVal = numberHash(149417, hashVal);
    for (let i = 0, length = s.length; i < length; i++) {
      hashVal = numberHash(s.charCodeAt(i), hashVal);
    }
    return hashVal;
  }
  class StringDiffSequence {
    constructor(source) {
      this.source = source;
    }
    getElements() {
      const source = this.source;
      const characters = new Int32Array(source.length);
      for (let i = 0, len = source.length; i < len; i++) {
        characters[i] = source.charCodeAt(i);
      }
      return characters;
    }
  }
  function stringDiff(original, modified, pretty) {
    return new LcsDiff(new StringDiffSequence(original), new StringDiffSequence(modified)).ComputeDiff(pretty).changes;
  }
  class Debug {
    static Assert(condition, message) {
      if (!condition) {
        throw new Error(message);
      }
    }
  }
  class MyArray {
    /**
     * Copies a range of elements from an Array starting at the specified source index and pastes
     * them to another Array starting at the specified destination index. The length and the indexes
     * are specified as 64-bit integers.
     * sourceArray:
     *		The Array that contains the data to copy.
     * sourceIndex:
     *		A 64-bit integer that represents the index in the sourceArray at which copying begins.
     * destinationArray:
     *		The Array that receives the data.
     * destinationIndex:
     *		A 64-bit integer that represents the index in the destinationArray at which storing begins.
     * length:
     *		A 64-bit integer that represents the number of elements to copy.
     */
    static Copy(sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
      for (let i = 0; i < length; i++) {
        destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
      }
    }
    static Copy2(sourceArray, sourceIndex, destinationArray, destinationIndex, length) {
      for (let i = 0; i < length; i++) {
        destinationArray[destinationIndex + i] = sourceArray[sourceIndex + i];
      }
    }
  }
  class DiffChangeHelper {
    /**
     * Constructs a new DiffChangeHelper for the given DiffSequences.
     */
    constructor() {
      this.m_changes = [];
      this.m_originalStart = 1073741824;
      this.m_modifiedStart = 1073741824;
      this.m_originalCount = 0;
      this.m_modifiedCount = 0;
    }
    /**
     * Marks the beginning of the next change in the set of differences.
     */
    MarkNextChange() {
      if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
        this.m_changes.push(new DiffChange(this.m_originalStart, this.m_originalCount, this.m_modifiedStart, this.m_modifiedCount));
      }
      this.m_originalCount = 0;
      this.m_modifiedCount = 0;
      this.m_originalStart = 1073741824;
      this.m_modifiedStart = 1073741824;
    }
    /**
     * Adds the original element at the given position to the elements
     * affected by the current change. The modified index gives context
     * to the change position with respect to the original sequence.
     * @param originalIndex The index of the original element to add.
     * @param modifiedIndex The index of the modified element that provides corresponding position in the modified sequence.
     */
    AddOriginalElement(originalIndex, modifiedIndex) {
      this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
      this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
      this.m_originalCount++;
    }
    /**
     * Adds the modified element at the given position to the elements
     * affected by the current change. The original index gives context
     * to the change position with respect to the modified sequence.
     * @param originalIndex The index of the original element that provides corresponding position in the original sequence.
     * @param modifiedIndex The index of the modified element to add.
     */
    AddModifiedElement(originalIndex, modifiedIndex) {
      this.m_originalStart = Math.min(this.m_originalStart, originalIndex);
      this.m_modifiedStart = Math.min(this.m_modifiedStart, modifiedIndex);
      this.m_modifiedCount++;
    }
    /**
     * Retrieves all of the changes marked by the class.
     */
    getChanges() {
      if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
        this.MarkNextChange();
      }
      return this.m_changes;
    }
    /**
     * Retrieves all of the changes marked by the class in the reverse order
     */
    getReverseChanges() {
      if (this.m_originalCount > 0 || this.m_modifiedCount > 0) {
        this.MarkNextChange();
      }
      this.m_changes.reverse();
      return this.m_changes;
    }
  }
  class LcsDiff {
    /**
     * Constructs the DiffFinder
     */
    constructor(originalSequence, modifiedSequence, continueProcessingPredicate = null) {
      this.ContinueProcessingPredicate = continueProcessingPredicate;
      this._originalSequence = originalSequence;
      this._modifiedSequence = modifiedSequence;
      const [originalStringElements, originalElementsOrHash, originalHasStrings] = LcsDiff._getElements(originalSequence);
      const [modifiedStringElements, modifiedElementsOrHash, modifiedHasStrings] = LcsDiff._getElements(modifiedSequence);
      this._hasStrings = originalHasStrings && modifiedHasStrings;
      this._originalStringElements = originalStringElements;
      this._originalElementsOrHash = originalElementsOrHash;
      this._modifiedStringElements = modifiedStringElements;
      this._modifiedElementsOrHash = modifiedElementsOrHash;
      this.m_forwardHistory = [];
      this.m_reverseHistory = [];
    }
    static _isStringArray(arr) {
      return arr.length > 0 && typeof arr[0] === "string";
    }
    static _getElements(sequence) {
      const elements = sequence.getElements();
      if (LcsDiff._isStringArray(elements)) {
        const hashes = new Int32Array(elements.length);
        for (let i = 0, len = elements.length; i < len; i++) {
          hashes[i] = stringHash(elements[i], 0);
        }
        return [elements, hashes, true];
      }
      if (elements instanceof Int32Array) {
        return [[], elements, false];
      }
      return [[], new Int32Array(elements), false];
    }
    ElementsAreEqual(originalIndex, newIndex) {
      if (this._originalElementsOrHash[originalIndex] !== this._modifiedElementsOrHash[newIndex]) {
        return false;
      }
      return this._hasStrings ? this._originalStringElements[originalIndex] === this._modifiedStringElements[newIndex] : true;
    }
    ElementsAreStrictEqual(originalIndex, newIndex) {
      if (!this.ElementsAreEqual(originalIndex, newIndex)) {
        return false;
      }
      const originalElement = LcsDiff._getStrictElement(this._originalSequence, originalIndex);
      const modifiedElement = LcsDiff._getStrictElement(this._modifiedSequence, newIndex);
      return originalElement === modifiedElement;
    }
    static _getStrictElement(sequence, index) {
      if (typeof sequence.getStrictElement === "function") {
        return sequence.getStrictElement(index);
      }
      return null;
    }
    OriginalElementsAreEqual(index1, index2) {
      if (this._originalElementsOrHash[index1] !== this._originalElementsOrHash[index2]) {
        return false;
      }
      return this._hasStrings ? this._originalStringElements[index1] === this._originalStringElements[index2] : true;
    }
    ModifiedElementsAreEqual(index1, index2) {
      if (this._modifiedElementsOrHash[index1] !== this._modifiedElementsOrHash[index2]) {
        return false;
      }
      return this._hasStrings ? this._modifiedStringElements[index1] === this._modifiedStringElements[index2] : true;
    }
    ComputeDiff(pretty) {
      return this._ComputeDiff(0, this._originalElementsOrHash.length - 1, 0, this._modifiedElementsOrHash.length - 1, pretty);
    }
    /**
     * Computes the differences between the original and modified input
     * sequences on the bounded range.
     * @returns An array of the differences between the two input sequences.
     */
    _ComputeDiff(originalStart, originalEnd, modifiedStart, modifiedEnd, pretty) {
      const quitEarlyArr = [false];
      let changes = this.ComputeDiffRecursive(originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr);
      if (pretty) {
        changes = this.PrettifyChanges(changes);
      }
      return {
        quitEarly: quitEarlyArr[0],
        changes
      };
    }
    /**
     * Private helper method which computes the differences on the bounded range
     * recursively.
     * @returns An array of the differences between the two input sequences.
     */
    ComputeDiffRecursive(originalStart, originalEnd, modifiedStart, modifiedEnd, quitEarlyArr) {
      quitEarlyArr[0] = false;
      while (originalStart <= originalEnd && modifiedStart <= modifiedEnd && this.ElementsAreEqual(originalStart, modifiedStart)) {
        originalStart++;
        modifiedStart++;
      }
      while (originalEnd >= originalStart && modifiedEnd >= modifiedStart && this.ElementsAreEqual(originalEnd, modifiedEnd)) {
        originalEnd--;
        modifiedEnd--;
      }
      if (originalStart > originalEnd || modifiedStart > modifiedEnd) {
        let changes;
        if (modifiedStart <= modifiedEnd) {
          Debug.Assert(originalStart === originalEnd + 1, "originalStart should only be one more than originalEnd");
          changes = [
            new DiffChange(originalStart, 0, modifiedStart, modifiedEnd - modifiedStart + 1)
          ];
        } else if (originalStart <= originalEnd) {
          Debug.Assert(modifiedStart === modifiedEnd + 1, "modifiedStart should only be one more than modifiedEnd");
          changes = [
            new DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, 0)
          ];
        } else {
          Debug.Assert(originalStart === originalEnd + 1, "originalStart should only be one more than originalEnd");
          Debug.Assert(modifiedStart === modifiedEnd + 1, "modifiedStart should only be one more than modifiedEnd");
          changes = [];
        }
        return changes;
      }
      const midOriginalArr = [0];
      const midModifiedArr = [0];
      const result = this.ComputeRecursionPoint(originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr);
      const midOriginal = midOriginalArr[0];
      const midModified = midModifiedArr[0];
      if (result !== null) {
        return result;
      } else if (!quitEarlyArr[0]) {
        const leftChanges = this.ComputeDiffRecursive(originalStart, midOriginal, modifiedStart, midModified, quitEarlyArr);
        let rightChanges = [];
        if (!quitEarlyArr[0]) {
          rightChanges = this.ComputeDiffRecursive(midOriginal + 1, originalEnd, midModified + 1, modifiedEnd, quitEarlyArr);
        } else {
          rightChanges = [
            new DiffChange(midOriginal + 1, originalEnd - (midOriginal + 1) + 1, midModified + 1, modifiedEnd - (midModified + 1) + 1)
          ];
        }
        return this.ConcatenateChanges(leftChanges, rightChanges);
      }
      return [
        new DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, modifiedEnd - modifiedStart + 1)
      ];
    }
    WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr) {
      let forwardChanges = null;
      let reverseChanges = null;
      let changeHelper = new DiffChangeHelper();
      let diagonalMin = diagonalForwardStart;
      let diagonalMax = diagonalForwardEnd;
      let diagonalRelative = midOriginalArr[0] - midModifiedArr[0] - diagonalForwardOffset;
      let lastOriginalIndex = -1073741824;
      let historyIndex = this.m_forwardHistory.length - 1;
      do {
        const diagonal = diagonalRelative + diagonalForwardBase;
        if (diagonal === diagonalMin || diagonal < diagonalMax && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1]) {
          originalIndex = forwardPoints[diagonal + 1];
          modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
          if (originalIndex < lastOriginalIndex) {
            changeHelper.MarkNextChange();
          }
          lastOriginalIndex = originalIndex;
          changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex);
          diagonalRelative = diagonal + 1 - diagonalForwardBase;
        } else {
          originalIndex = forwardPoints[diagonal - 1] + 1;
          modifiedIndex = originalIndex - diagonalRelative - diagonalForwardOffset;
          if (originalIndex < lastOriginalIndex) {
            changeHelper.MarkNextChange();
          }
          lastOriginalIndex = originalIndex - 1;
          changeHelper.AddOriginalElement(originalIndex, modifiedIndex + 1);
          diagonalRelative = diagonal - 1 - diagonalForwardBase;
        }
        if (historyIndex >= 0) {
          forwardPoints = this.m_forwardHistory[historyIndex];
          diagonalForwardBase = forwardPoints[0];
          diagonalMin = 1;
          diagonalMax = forwardPoints.length - 1;
        }
      } while (--historyIndex >= -1);
      forwardChanges = changeHelper.getReverseChanges();
      if (quitEarlyArr[0]) {
        let originalStartPoint = midOriginalArr[0] + 1;
        let modifiedStartPoint = midModifiedArr[0] + 1;
        if (forwardChanges !== null && forwardChanges.length > 0) {
          const lastForwardChange = forwardChanges[forwardChanges.length - 1];
          originalStartPoint = Math.max(originalStartPoint, lastForwardChange.getOriginalEnd());
          modifiedStartPoint = Math.max(modifiedStartPoint, lastForwardChange.getModifiedEnd());
        }
        reverseChanges = [
          new DiffChange(originalStartPoint, originalEnd - originalStartPoint + 1, modifiedStartPoint, modifiedEnd - modifiedStartPoint + 1)
        ];
      } else {
        changeHelper = new DiffChangeHelper();
        diagonalMin = diagonalReverseStart;
        diagonalMax = diagonalReverseEnd;
        diagonalRelative = midOriginalArr[0] - midModifiedArr[0] - diagonalReverseOffset;
        lastOriginalIndex = 1073741824;
        historyIndex = deltaIsEven ? this.m_reverseHistory.length - 1 : this.m_reverseHistory.length - 2;
        do {
          const diagonal = diagonalRelative + diagonalReverseBase;
          if (diagonal === diagonalMin || diagonal < diagonalMax && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1]) {
            originalIndex = reversePoints[diagonal + 1] - 1;
            modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
            if (originalIndex > lastOriginalIndex) {
              changeHelper.MarkNextChange();
            }
            lastOriginalIndex = originalIndex + 1;
            changeHelper.AddOriginalElement(originalIndex + 1, modifiedIndex + 1);
            diagonalRelative = diagonal + 1 - diagonalReverseBase;
          } else {
            originalIndex = reversePoints[diagonal - 1];
            modifiedIndex = originalIndex - diagonalRelative - diagonalReverseOffset;
            if (originalIndex > lastOriginalIndex) {
              changeHelper.MarkNextChange();
            }
            lastOriginalIndex = originalIndex;
            changeHelper.AddModifiedElement(originalIndex + 1, modifiedIndex + 1);
            diagonalRelative = diagonal - 1 - diagonalReverseBase;
          }
          if (historyIndex >= 0) {
            reversePoints = this.m_reverseHistory[historyIndex];
            diagonalReverseBase = reversePoints[0];
            diagonalMin = 1;
            diagonalMax = reversePoints.length - 1;
          }
        } while (--historyIndex >= -1);
        reverseChanges = changeHelper.getChanges();
      }
      return this.ConcatenateChanges(forwardChanges, reverseChanges);
    }
    /**
     * Given the range to compute the diff on, this method finds the point:
     * (midOriginal, midModified)
     * that exists in the middle of the LCS of the two sequences and
     * is the point at which the LCS problem may be broken down recursively.
     * This method will try to keep the LCS trace in memory. If the LCS recursion
     * point is calculated and the full trace is available in memory, then this method
     * will return the change list.
     * @param originalStart The start bound of the original sequence range
     * @param originalEnd The end bound of the original sequence range
     * @param modifiedStart The start bound of the modified sequence range
     * @param modifiedEnd The end bound of the modified sequence range
     * @param midOriginal The middle point of the original sequence range
     * @param midModified The middle point of the modified sequence range
     * @returns The diff changes, if available, otherwise null
     */
    ComputeRecursionPoint(originalStart, originalEnd, modifiedStart, modifiedEnd, midOriginalArr, midModifiedArr, quitEarlyArr) {
      let originalIndex = 0, modifiedIndex = 0;
      let diagonalForwardStart = 0, diagonalForwardEnd = 0;
      let diagonalReverseStart = 0, diagonalReverseEnd = 0;
      originalStart--;
      modifiedStart--;
      midOriginalArr[0] = 0;
      midModifiedArr[0] = 0;
      this.m_forwardHistory = [];
      this.m_reverseHistory = [];
      const maxDifferences = originalEnd - originalStart + (modifiedEnd - modifiedStart);
      const numDiagonals = maxDifferences + 1;
      const forwardPoints = new Int32Array(numDiagonals);
      const reversePoints = new Int32Array(numDiagonals);
      const diagonalForwardBase = modifiedEnd - modifiedStart;
      const diagonalReverseBase = originalEnd - originalStart;
      const diagonalForwardOffset = originalStart - modifiedStart;
      const diagonalReverseOffset = originalEnd - modifiedEnd;
      const delta = diagonalReverseBase - diagonalForwardBase;
      const deltaIsEven = delta % 2 === 0;
      forwardPoints[diagonalForwardBase] = originalStart;
      reversePoints[diagonalReverseBase] = originalEnd;
      quitEarlyArr[0] = false;
      for (let numDifferences = 1; numDifferences <= maxDifferences / 2 + 1; numDifferences++) {
        let furthestOriginalIndex = 0;
        let furthestModifiedIndex = 0;
        diagonalForwardStart = this.ClipDiagonalBound(diagonalForwardBase - numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
        diagonalForwardEnd = this.ClipDiagonalBound(diagonalForwardBase + numDifferences, numDifferences, diagonalForwardBase, numDiagonals);
        for (let diagonal = diagonalForwardStart; diagonal <= diagonalForwardEnd; diagonal += 2) {
          if (diagonal === diagonalForwardStart || diagonal < diagonalForwardEnd && forwardPoints[diagonal - 1] < forwardPoints[diagonal + 1]) {
            originalIndex = forwardPoints[diagonal + 1];
          } else {
            originalIndex = forwardPoints[diagonal - 1] + 1;
          }
          modifiedIndex = originalIndex - (diagonal - diagonalForwardBase) - diagonalForwardOffset;
          const tempOriginalIndex = originalIndex;
          while (originalIndex < originalEnd && modifiedIndex < modifiedEnd && this.ElementsAreEqual(originalIndex + 1, modifiedIndex + 1)) {
            originalIndex++;
            modifiedIndex++;
          }
          forwardPoints[diagonal] = originalIndex;
          if (originalIndex + modifiedIndex > furthestOriginalIndex + furthestModifiedIndex) {
            furthestOriginalIndex = originalIndex;
            furthestModifiedIndex = modifiedIndex;
          }
          if (!deltaIsEven && Math.abs(diagonal - diagonalReverseBase) <= numDifferences - 1) {
            if (originalIndex >= reversePoints[diagonal]) {
              midOriginalArr[0] = originalIndex;
              midModifiedArr[0] = modifiedIndex;
              if (tempOriginalIndex <= reversePoints[diagonal] && 1447 > 0 && numDifferences <= 1447 + 1) {
                return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
              } else {
                return null;
              }
            }
          }
        }
        const matchLengthOfLongest = (furthestOriginalIndex - originalStart + (furthestModifiedIndex - modifiedStart) - numDifferences) / 2;
        if (this.ContinueProcessingPredicate !== null && !this.ContinueProcessingPredicate(furthestOriginalIndex, matchLengthOfLongest)) {
          quitEarlyArr[0] = true;
          midOriginalArr[0] = furthestOriginalIndex;
          midModifiedArr[0] = furthestModifiedIndex;
          if (matchLengthOfLongest > 0 && 1447 > 0 && numDifferences <= 1447 + 1) {
            return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
          } else {
            originalStart++;
            modifiedStart++;
            return [
              new DiffChange(originalStart, originalEnd - originalStart + 1, modifiedStart, modifiedEnd - modifiedStart + 1)
            ];
          }
        }
        diagonalReverseStart = this.ClipDiagonalBound(diagonalReverseBase - numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
        diagonalReverseEnd = this.ClipDiagonalBound(diagonalReverseBase + numDifferences, numDifferences, diagonalReverseBase, numDiagonals);
        for (let diagonal = diagonalReverseStart; diagonal <= diagonalReverseEnd; diagonal += 2) {
          if (diagonal === diagonalReverseStart || diagonal < diagonalReverseEnd && reversePoints[diagonal - 1] >= reversePoints[diagonal + 1]) {
            originalIndex = reversePoints[diagonal + 1] - 1;
          } else {
            originalIndex = reversePoints[diagonal - 1];
          }
          modifiedIndex = originalIndex - (diagonal - diagonalReverseBase) - diagonalReverseOffset;
          const tempOriginalIndex = originalIndex;
          while (originalIndex > originalStart && modifiedIndex > modifiedStart && this.ElementsAreEqual(originalIndex, modifiedIndex)) {
            originalIndex--;
            modifiedIndex--;
          }
          reversePoints[diagonal] = originalIndex;
          if (deltaIsEven && Math.abs(diagonal - diagonalForwardBase) <= numDifferences) {
            if (originalIndex <= forwardPoints[diagonal]) {
              midOriginalArr[0] = originalIndex;
              midModifiedArr[0] = modifiedIndex;
              if (tempOriginalIndex >= forwardPoints[diagonal] && 1447 > 0 && numDifferences <= 1447 + 1) {
                return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
              } else {
                return null;
              }
            }
          }
        }
        if (numDifferences <= 1447) {
          let temp = new Int32Array(diagonalForwardEnd - diagonalForwardStart + 2);
          temp[0] = diagonalForwardBase - diagonalForwardStart + 1;
          MyArray.Copy2(forwardPoints, diagonalForwardStart, temp, 1, diagonalForwardEnd - diagonalForwardStart + 1);
          this.m_forwardHistory.push(temp);
          temp = new Int32Array(diagonalReverseEnd - diagonalReverseStart + 2);
          temp[0] = diagonalReverseBase - diagonalReverseStart + 1;
          MyArray.Copy2(reversePoints, diagonalReverseStart, temp, 1, diagonalReverseEnd - diagonalReverseStart + 1);
          this.m_reverseHistory.push(temp);
        }
      }
      return this.WALKTRACE(diagonalForwardBase, diagonalForwardStart, diagonalForwardEnd, diagonalForwardOffset, diagonalReverseBase, diagonalReverseStart, diagonalReverseEnd, diagonalReverseOffset, forwardPoints, reversePoints, originalIndex, originalEnd, midOriginalArr, modifiedIndex, modifiedEnd, midModifiedArr, deltaIsEven, quitEarlyArr);
    }
    /**
     * Shifts the given changes to provide a more intuitive diff.
     * While the first element in a diff matches the first element after the diff,
     * we shift the diff down.
     *
     * @param changes The list of changes to shift
     * @returns The shifted changes
     */
    PrettifyChanges(changes) {
      for (let i = 0; i < changes.length; i++) {
        const change = changes[i];
        const originalStop = i < changes.length - 1 ? changes[i + 1].originalStart : this._originalElementsOrHash.length;
        const modifiedStop = i < changes.length - 1 ? changes[i + 1].modifiedStart : this._modifiedElementsOrHash.length;
        const checkOriginal = change.originalLength > 0;
        const checkModified = change.modifiedLength > 0;
        while (change.originalStart + change.originalLength < originalStop && change.modifiedStart + change.modifiedLength < modifiedStop && (!checkOriginal || this.OriginalElementsAreEqual(change.originalStart, change.originalStart + change.originalLength)) && (!checkModified || this.ModifiedElementsAreEqual(change.modifiedStart, change.modifiedStart + change.modifiedLength))) {
          const startStrictEqual = this.ElementsAreStrictEqual(change.originalStart, change.modifiedStart);
          const endStrictEqual = this.ElementsAreStrictEqual(change.originalStart + change.originalLength, change.modifiedStart + change.modifiedLength);
          if (endStrictEqual && !startStrictEqual) {
            break;
          }
          change.originalStart++;
          change.modifiedStart++;
        }
        const mergedChangeArr = [null];
        if (i < changes.length - 1 && this.ChangesOverlap(changes[i], changes[i + 1], mergedChangeArr)) {
          changes[i] = mergedChangeArr[0];
          changes.splice(i + 1, 1);
          i--;
          continue;
        }
      }
      for (let i = changes.length - 1; i >= 0; i--) {
        const change = changes[i];
        let originalStop = 0;
        let modifiedStop = 0;
        if (i > 0) {
          const prevChange = changes[i - 1];
          originalStop = prevChange.originalStart + prevChange.originalLength;
          modifiedStop = prevChange.modifiedStart + prevChange.modifiedLength;
        }
        const checkOriginal = change.originalLength > 0;
        const checkModified = change.modifiedLength > 0;
        let bestDelta = 0;
        let bestScore = this._boundaryScore(change.originalStart, change.originalLength, change.modifiedStart, change.modifiedLength);
        for (let delta = 1; ; delta++) {
          const originalStart = change.originalStart - delta;
          const modifiedStart = change.modifiedStart - delta;
          if (originalStart < originalStop || modifiedStart < modifiedStop) {
            break;
          }
          if (checkOriginal && !this.OriginalElementsAreEqual(originalStart, originalStart + change.originalLength)) {
            break;
          }
          if (checkModified && !this.ModifiedElementsAreEqual(modifiedStart, modifiedStart + change.modifiedLength)) {
            break;
          }
          const touchingPreviousChange = originalStart === originalStop && modifiedStart === modifiedStop;
          const score2 = (touchingPreviousChange ? 5 : 0) + this._boundaryScore(originalStart, change.originalLength, modifiedStart, change.modifiedLength);
          if (score2 > bestScore) {
            bestScore = score2;
            bestDelta = delta;
          }
        }
        change.originalStart -= bestDelta;
        change.modifiedStart -= bestDelta;
        const mergedChangeArr = [null];
        if (i > 0 && this.ChangesOverlap(changes[i - 1], changes[i], mergedChangeArr)) {
          changes[i - 1] = mergedChangeArr[0];
          changes.splice(i, 1);
          i++;
          continue;
        }
      }
      if (this._hasStrings) {
        for (let i = 1, len = changes.length; i < len; i++) {
          const aChange = changes[i - 1];
          const bChange = changes[i];
          const matchedLength = bChange.originalStart - aChange.originalStart - aChange.originalLength;
          const aOriginalStart = aChange.originalStart;
          const bOriginalEnd = bChange.originalStart + bChange.originalLength;
          const abOriginalLength = bOriginalEnd - aOriginalStart;
          const aModifiedStart = aChange.modifiedStart;
          const bModifiedEnd = bChange.modifiedStart + bChange.modifiedLength;
          const abModifiedLength = bModifiedEnd - aModifiedStart;
          if (matchedLength < 5 && abOriginalLength < 20 && abModifiedLength < 20) {
            const t2 = this._findBetterContiguousSequence(aOriginalStart, abOriginalLength, aModifiedStart, abModifiedLength, matchedLength);
            if (t2) {
              const [originalMatchStart, modifiedMatchStart] = t2;
              if (originalMatchStart !== aChange.originalStart + aChange.originalLength || modifiedMatchStart !== aChange.modifiedStart + aChange.modifiedLength) {
                aChange.originalLength = originalMatchStart - aChange.originalStart;
                aChange.modifiedLength = modifiedMatchStart - aChange.modifiedStart;
                bChange.originalStart = originalMatchStart + matchedLength;
                bChange.modifiedStart = modifiedMatchStart + matchedLength;
                bChange.originalLength = bOriginalEnd - bChange.originalStart;
                bChange.modifiedLength = bModifiedEnd - bChange.modifiedStart;
              }
            }
          }
        }
      }
      return changes;
    }
    _findBetterContiguousSequence(originalStart, originalLength, modifiedStart, modifiedLength, desiredLength) {
      if (originalLength < desiredLength || modifiedLength < desiredLength) {
        return null;
      }
      const originalMax = originalStart + originalLength - desiredLength + 1;
      const modifiedMax = modifiedStart + modifiedLength - desiredLength + 1;
      let bestScore = 0;
      let bestOriginalStart = 0;
      let bestModifiedStart = 0;
      for (let i = originalStart; i < originalMax; i++) {
        for (let j = modifiedStart; j < modifiedMax; j++) {
          const score2 = this._contiguousSequenceScore(i, j, desiredLength);
          if (score2 > 0 && score2 > bestScore) {
            bestScore = score2;
            bestOriginalStart = i;
            bestModifiedStart = j;
          }
        }
      }
      if (bestScore > 0) {
        return [bestOriginalStart, bestModifiedStart];
      }
      return null;
    }
    _contiguousSequenceScore(originalStart, modifiedStart, length) {
      let score2 = 0;
      for (let l = 0; l < length; l++) {
        if (!this.ElementsAreEqual(originalStart + l, modifiedStart + l)) {
          return 0;
        }
        score2 += this._originalStringElements[originalStart + l].length;
      }
      return score2;
    }
    _OriginalIsBoundary(index) {
      if (index <= 0 || index >= this._originalElementsOrHash.length - 1) {
        return true;
      }
      return this._hasStrings && /^\s*$/.test(this._originalStringElements[index]);
    }
    _OriginalRegionIsBoundary(originalStart, originalLength) {
      if (this._OriginalIsBoundary(originalStart) || this._OriginalIsBoundary(originalStart - 1)) {
        return true;
      }
      if (originalLength > 0) {
        const originalEnd = originalStart + originalLength;
        if (this._OriginalIsBoundary(originalEnd - 1) || this._OriginalIsBoundary(originalEnd)) {
          return true;
        }
      }
      return false;
    }
    _ModifiedIsBoundary(index) {
      if (index <= 0 || index >= this._modifiedElementsOrHash.length - 1) {
        return true;
      }
      return this._hasStrings && /^\s*$/.test(this._modifiedStringElements[index]);
    }
    _ModifiedRegionIsBoundary(modifiedStart, modifiedLength) {
      if (this._ModifiedIsBoundary(modifiedStart) || this._ModifiedIsBoundary(modifiedStart - 1)) {
        return true;
      }
      if (modifiedLength > 0) {
        const modifiedEnd = modifiedStart + modifiedLength;
        if (this._ModifiedIsBoundary(modifiedEnd - 1) || this._ModifiedIsBoundary(modifiedEnd)) {
          return true;
        }
      }
      return false;
    }
    _boundaryScore(originalStart, originalLength, modifiedStart, modifiedLength) {
      const originalScore = this._OriginalRegionIsBoundary(originalStart, originalLength) ? 1 : 0;
      const modifiedScore = this._ModifiedRegionIsBoundary(modifiedStart, modifiedLength) ? 1 : 0;
      return originalScore + modifiedScore;
    }
    /**
     * Concatenates the two input DiffChange lists and returns the resulting
     * list.
     * @param The left changes
     * @param The right changes
     * @returns The concatenated list
     */
    ConcatenateChanges(left, right) {
      const mergedChangeArr = [];
      if (left.length === 0 || right.length === 0) {
        return right.length > 0 ? right : left;
      } else if (this.ChangesOverlap(left[left.length - 1], right[0], mergedChangeArr)) {
        const result = new Array(left.length + right.length - 1);
        MyArray.Copy(left, 0, result, 0, left.length - 1);
        result[left.length - 1] = mergedChangeArr[0];
        MyArray.Copy(right, 1, result, left.length, right.length - 1);
        return result;
      } else {
        const result = new Array(left.length + right.length);
        MyArray.Copy(left, 0, result, 0, left.length);
        MyArray.Copy(right, 0, result, left.length, right.length);
        return result;
      }
    }
    /**
     * Returns true if the two changes overlap and can be merged into a single
     * change
     * @param left The left change
     * @param right The right change
     * @param mergedChange The merged change if the two overlap, null otherwise
     * @returns True if the two changes overlap
     */
    ChangesOverlap(left, right, mergedChangeArr) {
      Debug.Assert(left.originalStart <= right.originalStart, "Left change is not less than or equal to right change");
      Debug.Assert(left.modifiedStart <= right.modifiedStart, "Left change is not less than or equal to right change");
      if (left.originalStart + left.originalLength >= right.originalStart || left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
        const originalStart = left.originalStart;
        let originalLength = left.originalLength;
        const modifiedStart = left.modifiedStart;
        let modifiedLength = left.modifiedLength;
        if (left.originalStart + left.originalLength >= right.originalStart) {
          originalLength = right.originalStart + right.originalLength - left.originalStart;
        }
        if (left.modifiedStart + left.modifiedLength >= right.modifiedStart) {
          modifiedLength = right.modifiedStart + right.modifiedLength - left.modifiedStart;
        }
        mergedChangeArr[0] = new DiffChange(originalStart, originalLength, modifiedStart, modifiedLength);
        return true;
      } else {
        mergedChangeArr[0] = null;
        return false;
      }
    }
    /**
     * Helper method used to clip a diagonal index to the range of valid
     * diagonals. This also decides whether or not the diagonal index,
     * if it exceeds the boundary, should be clipped to the boundary or clipped
     * one inside the boundary depending on the Even/Odd status of the boundary
     * and numDifferences.
     * @param diagonal The index of the diagonal to clip.
     * @param numDifferences The current number of differences being iterated upon.
     * @param diagonalBaseIndex The base reference diagonal.
     * @param numDiagonals The total number of diagonals.
     * @returns The clipped diagonal index.
     */
    ClipDiagonalBound(diagonal, numDifferences, diagonalBaseIndex, numDiagonals) {
      if (diagonal >= 0 && diagonal < numDiagonals) {
        return diagonal;
      }
      const diagonalsBelow = diagonalBaseIndex;
      const diagonalsAbove = numDiagonals - diagonalBaseIndex - 1;
      const diffEven = numDifferences % 2 === 0;
      if (diagonal < 0) {
        const lowerBoundEven = diagonalsBelow % 2 === 0;
        return diffEven === lowerBoundEven ? 0 : 1;
      } else {
        const upperBoundEven = diagonalsAbove % 2 === 0;
        return diffEven === upperBoundEven ? numDiagonals - 1 : numDiagonals - 2;
      }
    }
  }
  let Position$1 = class Position2 {
    constructor(lineNumber, column) {
      this.lineNumber = lineNumber;
      this.column = column;
    }
    /**
     * Create a new position from this position.
     *
     * @param newLineNumber new line number
     * @param newColumn new column
     */
    with(newLineNumber = this.lineNumber, newColumn = this.column) {
      if (newLineNumber === this.lineNumber && newColumn === this.column) {
        return this;
      } else {
        return new Position2(newLineNumber, newColumn);
      }
    }
    /**
     * Derive a new position from this position.
     *
     * @param deltaLineNumber line number delta
     * @param deltaColumn column delta
     */
    delta(deltaLineNumber = 0, deltaColumn = 0) {
      return this.with(Math.max(1, this.lineNumber + deltaLineNumber), Math.max(1, this.column + deltaColumn));
    }
    /**
     * Test if this position equals other position
     */
    equals(other) {
      return Position2.equals(this, other);
    }
    /**
     * Test if position `a` equals position `b`
     */
    static equals(a, b) {
      if (!a && !b) {
        return true;
      }
      return !!a && !!b && a.lineNumber === b.lineNumber && a.column === b.column;
    }
    /**
     * Test if this position is before other position.
     * If the two positions are equal, the result will be false.
     */
    isBefore(other) {
      return Position2.isBefore(this, other);
    }
    /**
     * Test if position `a` is before position `b`.
     * If the two positions are equal, the result will be false.
     */
    static isBefore(a, b) {
      if (a.lineNumber < b.lineNumber) {
        return true;
      }
      if (b.lineNumber < a.lineNumber) {
        return false;
      }
      return a.column < b.column;
    }
    /**
     * Test if this position is before other position.
     * If the two positions are equal, the result will be true.
     */
    isBeforeOrEqual(other) {
      return Position2.isBeforeOrEqual(this, other);
    }
    /**
     * Test if position `a` is before position `b`.
     * If the two positions are equal, the result will be true.
     */
    static isBeforeOrEqual(a, b) {
      if (a.lineNumber < b.lineNumber) {
        return true;
      }
      if (b.lineNumber < a.lineNumber) {
        return false;
      }
      return a.column <= b.column;
    }
    /**
     * A function that compares positions, useful for sorting
     */
    static compare(a, b) {
      const aLineNumber = a.lineNumber | 0;
      const bLineNumber = b.lineNumber | 0;
      if (aLineNumber === bLineNumber) {
        const aColumn = a.column | 0;
        const bColumn = b.column | 0;
        return aColumn - bColumn;
      }
      return aLineNumber - bLineNumber;
    }
    /**
     * Clone this position.
     */
    clone() {
      return new Position2(this.lineNumber, this.column);
    }
    /**
     * Convert to a human-readable representation.
     */
    toString() {
      return "(" + this.lineNumber + "," + this.column + ")";
    }
    // ---
    /**
     * Create a `Position` from an `IPosition`.
     */
    static lift(pos) {
      return new Position2(pos.lineNumber, pos.column);
    }
    /**
     * Test if `obj` is an `IPosition`.
     */
    static isIPosition(obj) {
      return obj && typeof obj.lineNumber === "number" && typeof obj.column === "number";
    }
    toJSON() {
      return {
        lineNumber: this.lineNumber,
        column: this.column
      };
    }
  };
  let Range$1 = class Range2 {
    constructor(startLineNumber, startColumn, endLineNumber, endColumn) {
      if (startLineNumber > endLineNumber || startLineNumber === endLineNumber && startColumn > endColumn) {
        this.startLineNumber = endLineNumber;
        this.startColumn = endColumn;
        this.endLineNumber = startLineNumber;
        this.endColumn = startColumn;
      } else {
        this.startLineNumber = startLineNumber;
        this.startColumn = startColumn;
        this.endLineNumber = endLineNumber;
        this.endColumn = endColumn;
      }
    }
    /**
     * Test if this range is empty.
     */
    isEmpty() {
      return Range2.isEmpty(this);
    }
    /**
     * Test if `range` is empty.
     */
    static isEmpty(range) {
      return range.startLineNumber === range.endLineNumber && range.startColumn === range.endColumn;
    }
    /**
     * Test if position is in this range. If the position is at the edges, will return true.
     */
    containsPosition(position) {
      return Range2.containsPosition(this, position);
    }
    /**
     * Test if `position` is in `range`. If the position is at the edges, will return true.
     */
    static containsPosition(range, position) {
      if (position.lineNumber < range.startLineNumber || position.lineNumber > range.endLineNumber) {
        return false;
      }
      if (position.lineNumber === range.startLineNumber && position.column < range.startColumn) {
        return false;
      }
      if (position.lineNumber === range.endLineNumber && position.column > range.endColumn) {
        return false;
      }
      return true;
    }
    /**
     * Test if `position` is in `range`. If the position is at the edges, will return false.
     * @internal
     */
    static strictContainsPosition(range, position) {
      if (position.lineNumber < range.startLineNumber || position.lineNumber > range.endLineNumber) {
        return false;
      }
      if (position.lineNumber === range.startLineNumber && position.column <= range.startColumn) {
        return false;
      }
      if (position.lineNumber === range.endLineNumber && position.column >= range.endColumn) {
        return false;
      }
      return true;
    }
    /**
     * Test if range is in this range. If the range is equal to this range, will return true.
     */
    containsRange(range) {
      return Range2.containsRange(this, range);
    }
    /**
     * Test if `otherRange` is in `range`. If the ranges are equal, will return true.
     */
    static containsRange(range, otherRange) {
      if (otherRange.startLineNumber < range.startLineNumber || otherRange.endLineNumber < range.startLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber > range.endLineNumber || otherRange.endLineNumber > range.endLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber === range.startLineNumber && otherRange.startColumn < range.startColumn) {
        return false;
      }
      if (otherRange.endLineNumber === range.endLineNumber && otherRange.endColumn > range.endColumn) {
        return false;
      }
      return true;
    }
    /**
     * Test if `range` is strictly in this range. `range` must start after and end before this range for the result to be true.
     */
    strictContainsRange(range) {
      return Range2.strictContainsRange(this, range);
    }
    /**
     * Test if `otherRange` is strictly in `range` (must start after, and end before). If the ranges are equal, will return false.
     */
    static strictContainsRange(range, otherRange) {
      if (otherRange.startLineNumber < range.startLineNumber || otherRange.endLineNumber < range.startLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber > range.endLineNumber || otherRange.endLineNumber > range.endLineNumber) {
        return false;
      }
      if (otherRange.startLineNumber === range.startLineNumber && otherRange.startColumn <= range.startColumn) {
        return false;
      }
      if (otherRange.endLineNumber === range.endLineNumber && otherRange.endColumn >= range.endColumn) {
        return false;
      }
      return true;
    }
    /**
     * A reunion of the two ranges.
     * The smallest position will be used as the start point, and the largest one as the end point.
     */
    plusRange(range) {
      return Range2.plusRange(this, range);
    }
    /**
     * A reunion of the two ranges.
     * The smallest position will be used as the start point, and the largest one as the end point.
     */
    static plusRange(a, b) {
      let startLineNumber;
      let startColumn;
      let endLineNumber;
      let endColumn;
      if (b.startLineNumber < a.startLineNumber) {
        startLineNumber = b.startLineNumber;
        startColumn = b.startColumn;
      } else if (b.startLineNumber === a.startLineNumber) {
        startLineNumber = b.startLineNumber;
        startColumn = Math.min(b.startColumn, a.startColumn);
      } else {
        startLineNumber = a.startLineNumber;
        startColumn = a.startColumn;
      }
      if (b.endLineNumber > a.endLineNumber) {
        endLineNumber = b.endLineNumber;
        endColumn = b.endColumn;
      } else if (b.endLineNumber === a.endLineNumber) {
        endLineNumber = b.endLineNumber;
        endColumn = Math.max(b.endColumn, a.endColumn);
      } else {
        endLineNumber = a.endLineNumber;
        endColumn = a.endColumn;
      }
      return new Range2(startLineNumber, startColumn, endLineNumber, endColumn);
    }
    /**
     * A intersection of the two ranges.
     */
    intersectRanges(range) {
      return Range2.intersectRanges(this, range);
    }
    /**
     * A intersection of the two ranges.
     */
    static intersectRanges(a, b) {
      let resultStartLineNumber = a.startLineNumber;
      let resultStartColumn = a.startColumn;
      let resultEndLineNumber = a.endLineNumber;
      let resultEndColumn = a.endColumn;
      const otherStartLineNumber = b.startLineNumber;
      const otherStartColumn = b.startColumn;
      const otherEndLineNumber = b.endLineNumber;
      const otherEndColumn = b.endColumn;
      if (resultStartLineNumber < otherStartLineNumber) {
        resultStartLineNumber = otherStartLineNumber;
        resultStartColumn = otherStartColumn;
      } else if (resultStartLineNumber === otherStartLineNumber) {
        resultStartColumn = Math.max(resultStartColumn, otherStartColumn);
      }
      if (resultEndLineNumber > otherEndLineNumber) {
        resultEndLineNumber = otherEndLineNumber;
        resultEndColumn = otherEndColumn;
      } else if (resultEndLineNumber === otherEndLineNumber) {
        resultEndColumn = Math.min(resultEndColumn, otherEndColumn);
      }
      if (resultStartLineNumber > resultEndLineNumber) {
        return null;
      }
      if (resultStartLineNumber === resultEndLineNumber && resultStartColumn > resultEndColumn) {
        return null;
      }
      return new Range2(resultStartLineNumber, resultStartColumn, resultEndLineNumber, resultEndColumn);
    }
    /**
     * Test if this range equals other.
     */
    equalsRange(other) {
      return Range2.equalsRange(this, other);
    }
    /**
     * Test if range `a` equals `b`.
     */
    static equalsRange(a, b) {
      if (!a && !b) {
        return true;
      }
      return !!a && !!b && a.startLineNumber === b.startLineNumber && a.startColumn === b.startColumn && a.endLineNumber === b.endLineNumber && a.endColumn === b.endColumn;
    }
    /**
     * Return the end position (which will be after or equal to the start position)
     */
    getEndPosition() {
      return Range2.getEndPosition(this);
    }
    /**
     * Return the end position (which will be after or equal to the start position)
     */
    static getEndPosition(range) {
      return new Position$1(range.endLineNumber, range.endColumn);
    }
    /**
     * Return the start position (which will be before or equal to the end position)
     */
    getStartPosition() {
      return Range2.getStartPosition(this);
    }
    /**
     * Return the start position (which will be before or equal to the end position)
     */
    static getStartPosition(range) {
      return new Position$1(range.startLineNumber, range.startColumn);
    }
    /**
     * Transform to a user presentable string representation.
     */
    toString() {
      return "[" + this.startLineNumber + "," + this.startColumn + " -> " + this.endLineNumber + "," + this.endColumn + "]";
    }
    /**
     * Create a new range using this range's start position, and using endLineNumber and endColumn as the end position.
     */
    setEndPosition(endLineNumber, endColumn) {
      return new Range2(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
    }
    /**
     * Create a new range using this range's end position, and using startLineNumber and startColumn as the start position.
     */
    setStartPosition(startLineNumber, startColumn) {
      return new Range2(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
    }
    /**
     * Create a new empty range using this range's start position.
     */
    collapseToStart() {
      return Range2.collapseToStart(this);
    }
    /**
     * Create a new empty range using this range's start position.
     */
    static collapseToStart(range) {
      return new Range2(range.startLineNumber, range.startColumn, range.startLineNumber, range.startColumn);
    }
    /**
     * Create a new empty range using this range's end position.
     */
    collapseToEnd() {
      return Range2.collapseToEnd(this);
    }
    /**
     * Create a new empty range using this range's end position.
     */
    static collapseToEnd(range) {
      return new Range2(range.endLineNumber, range.endColumn, range.endLineNumber, range.endColumn);
    }
    /**
     * Moves the range by the given amount of lines.
     */
    delta(lineCount) {
      return new Range2(this.startLineNumber + lineCount, this.startColumn, this.endLineNumber + lineCount, this.endColumn);
    }
    isSingleLine() {
      return this.startLineNumber === this.endLineNumber;
    }
    // ---
    static fromPositions(start2, end = start2) {
      return new Range2(start2.lineNumber, start2.column, end.lineNumber, end.column);
    }
    static lift(range) {
      if (!range) {
        return null;
      }
      return new Range2(range.startLineNumber, range.startColumn, range.endLineNumber, range.endColumn);
    }
    /**
     * Test if `obj` is an `IRange`.
     */
    static isIRange(obj) {
      return obj && typeof obj.startLineNumber === "number" && typeof obj.startColumn === "number" && typeof obj.endLineNumber === "number" && typeof obj.endColumn === "number";
    }
    /**
     * Test if the two ranges are touching in any way.
     */
    static areIntersectingOrTouching(a, b) {
      if (a.endLineNumber < b.startLineNumber || a.endLineNumber === b.startLineNumber && a.endColumn < b.startColumn) {
        return false;
      }
      if (b.endLineNumber < a.startLineNumber || b.endLineNumber === a.startLineNumber && b.endColumn < a.startColumn) {
        return false;
      }
      return true;
    }
    /**
     * Test if the two ranges are intersecting. If the ranges are touching it returns true.
     */
    static areIntersecting(a, b) {
      if (a.endLineNumber < b.startLineNumber || a.endLineNumber === b.startLineNumber && a.endColumn <= b.startColumn) {
        return false;
      }
      if (b.endLineNumber < a.startLineNumber || b.endLineNumber === a.startLineNumber && b.endColumn <= a.startColumn) {
        return false;
      }
      return true;
    }
    /**
     * Test if the two ranges are intersecting, but not touching at all.
     */
    static areOnlyIntersecting(a, b) {
      if (a.endLineNumber < b.startLineNumber - 1 || a.endLineNumber === b.startLineNumber && a.endColumn < b.startColumn - 1) {
        return false;
      }
      if (b.endLineNumber < a.startLineNumber - 1 || b.endLineNumber === a.startLineNumber && b.endColumn < a.startColumn - 1) {
        return false;
      }
      return true;
    }
    /**
     * A function that compares ranges, useful for sorting ranges
     * It will first compare ranges on the startPosition and then on the endPosition
     */
    static compareRangesUsingStarts(a, b) {
      if (a && b) {
        const aStartLineNumber = a.startLineNumber | 0;
        const bStartLineNumber = b.startLineNumber | 0;
        if (aStartLineNumber === bStartLineNumber) {
          const aStartColumn = a.startColumn | 0;
          const bStartColumn = b.startColumn | 0;
          if (aStartColumn === bStartColumn) {
            const aEndLineNumber = a.endLineNumber | 0;
            const bEndLineNumber = b.endLineNumber | 0;
            if (aEndLineNumber === bEndLineNumber) {
              const aEndColumn = a.endColumn | 0;
              const bEndColumn = b.endColumn | 0;
              return aEndColumn - bEndColumn;
            }
            return aEndLineNumber - bEndLineNumber;
          }
          return aStartColumn - bStartColumn;
        }
        return aStartLineNumber - bStartLineNumber;
      }
      const aExists = a ? 1 : 0;
      const bExists = b ? 1 : 0;
      return aExists - bExists;
    }
    /**
     * A function that compares ranges, useful for sorting ranges
     * It will first compare ranges on the endPosition and then on the startPosition
     */
    static compareRangesUsingEnds(a, b) {
      if (a.endLineNumber === b.endLineNumber) {
        if (a.endColumn === b.endColumn) {
          if (a.startLineNumber === b.startLineNumber) {
            return a.startColumn - b.startColumn;
          }
          return a.startLineNumber - b.startLineNumber;
        }
        return a.endColumn - b.endColumn;
      }
      return a.endLineNumber - b.endLineNumber;
    }
    /**
     * Test if the range spans multiple lines.
     */
    static spansMultipleLines(range) {
      return range.endLineNumber > range.startLineNumber;
    }
    toJSON() {
      return this;
    }
  };
  function toUint8(v) {
    if (v < 0) {
      return 0;
    }
    if (v > 255) {
      return 255;
    }
    return v | 0;
  }
  function toUint32(v) {
    if (v < 0) {
      return 0;
    }
    if (v > 4294967295) {
      return 4294967295;
    }
    return v | 0;
  }
  class CharacterClassifier {
    constructor(_defaultValue) {
      const defaultValue = toUint8(_defaultValue);
      this._defaultValue = defaultValue;
      this._asciiMap = CharacterClassifier._createAsciiMap(defaultValue);
      this._map = /* @__PURE__ */ new Map();
    }
    static _createAsciiMap(defaultValue) {
      const asciiMap = new Uint8Array(256);
      asciiMap.fill(defaultValue);
      return asciiMap;
    }
    set(charCode, _value) {
      const value = toUint8(_value);
      if (charCode >= 0 && charCode < 256) {
        this._asciiMap[charCode] = value;
      } else {
        this._map.set(charCode, value);
      }
    }
    get(charCode) {
      if (charCode >= 0 && charCode < 256) {
        return this._asciiMap[charCode];
      } else {
        return this._map.get(charCode) || this._defaultValue;
      }
    }
    clear() {
      this._asciiMap.fill(this._defaultValue);
      this._map.clear();
    }
  }
  class Uint8Matrix {
    constructor(rows, cols, defaultValue) {
      const data = new Uint8Array(rows * cols);
      for (let i = 0, len = rows * cols; i < len; i++) {
        data[i] = defaultValue;
      }
      this._data = data;
      this.rows = rows;
      this.cols = cols;
    }
    get(row, col) {
      return this._data[row * this.cols + col];
    }
    set(row, col, value) {
      this._data[row * this.cols + col] = value;
    }
  }
  class StateMachine {
    constructor(edges) {
      let maxCharCode = 0;
      let maxState = 0;
      for (let i = 0, len = edges.length; i < len; i++) {
        const [from, chCode, to] = edges[i];
        if (chCode > maxCharCode) {
          maxCharCode = chCode;
        }
        if (from > maxState) {
          maxState = from;
        }
        if (to > maxState) {
          maxState = to;
        }
      }
      maxCharCode++;
      maxState++;
      const states = new Uint8Matrix(
        maxState,
        maxCharCode,
        0
        /* State.Invalid */
      );
      for (let i = 0, len = edges.length; i < len; i++) {
        const [from, chCode, to] = edges[i];
        states.set(from, chCode, to);
      }
      this._states = states;
      this._maxCharCode = maxCharCode;
    }
    nextState(currentState, chCode) {
      if (chCode < 0 || chCode >= this._maxCharCode) {
        return 0;
      }
      return this._states.get(currentState, chCode);
    }
  }
  let _stateMachine = null;
  function getStateMachine() {
    if (_stateMachine === null) {
      _stateMachine = new StateMachine([
        [
          1,
          104,
          2
          /* State.H */
        ],
        [
          1,
          72,
          2
          /* State.H */
        ],
        [
          1,
          102,
          6
          /* State.F */
        ],
        [
          1,
          70,
          6
          /* State.F */
        ],
        [
          2,
          116,
          3
          /* State.HT */
        ],
        [
          2,
          84,
          3
          /* State.HT */
        ],
        [
          3,
          116,
          4
          /* State.HTT */
        ],
        [
          3,
          84,
          4
          /* State.HTT */
        ],
        [
          4,
          112,
          5
          /* State.HTTP */
        ],
        [
          4,
          80,
          5
          /* State.HTTP */
        ],
        [
          5,
          115,
          9
          /* State.BeforeColon */
        ],
        [
          5,
          83,
          9
          /* State.BeforeColon */
        ],
        [
          5,
          58,
          10
          /* State.AfterColon */
        ],
        [
          6,
          105,
          7
          /* State.FI */
        ],
        [
          6,
          73,
          7
          /* State.FI */
        ],
        [
          7,
          108,
          8
          /* State.FIL */
        ],
        [
          7,
          76,
          8
          /* State.FIL */
        ],
        [
          8,
          101,
          9
          /* State.BeforeColon */
        ],
        [
          8,
          69,
          9
          /* State.BeforeColon */
        ],
        [
          9,
          58,
          10
          /* State.AfterColon */
        ],
        [
          10,
          47,
          11
          /* State.AlmostThere */
        ],
        [
          11,
          47,
          12
          /* State.End */
        ]
      ]);
    }
    return _stateMachine;
  }
  let _classifier = null;
  function getClassifier() {
    if (_classifier === null) {
      _classifier = new CharacterClassifier(
        0
        /* CharacterClass.None */
      );
      const FORCE_TERMINATION_CHARACTERS = ` 	<>'"、。｡､，．：；‘〈「『〔（［｛｢｣｝］）〕』」〉’｀～…|`;
      for (let i = 0; i < FORCE_TERMINATION_CHARACTERS.length; i++) {
        _classifier.set(
          FORCE_TERMINATION_CHARACTERS.charCodeAt(i),
          1
          /* CharacterClass.ForceTermination */
        );
      }
      const CANNOT_END_WITH_CHARACTERS = ".,;:";
      for (let i = 0; i < CANNOT_END_WITH_CHARACTERS.length; i++) {
        _classifier.set(
          CANNOT_END_WITH_CHARACTERS.charCodeAt(i),
          2
          /* CharacterClass.CannotEndIn */
        );
      }
    }
    return _classifier;
  }
  class LinkComputer {
    static _createLink(classifier, line, lineNumber, linkBeginIndex, linkEndIndex) {
      let lastIncludedCharIndex = linkEndIndex - 1;
      do {
        const chCode = line.charCodeAt(lastIncludedCharIndex);
        const chClass = classifier.get(chCode);
        if (chClass !== 2) {
          break;
        }
        lastIncludedCharIndex--;
      } while (lastIncludedCharIndex > linkBeginIndex);
      if (linkBeginIndex > 0) {
        const charCodeBeforeLink = line.charCodeAt(linkBeginIndex - 1);
        const lastCharCodeInLink = line.charCodeAt(lastIncludedCharIndex);
        if (charCodeBeforeLink === 40 && lastCharCodeInLink === 41 || charCodeBeforeLink === 91 && lastCharCodeInLink === 93 || charCodeBeforeLink === 123 && lastCharCodeInLink === 125) {
          lastIncludedCharIndex--;
        }
      }
      return {
        range: {
          startLineNumber: lineNumber,
          startColumn: linkBeginIndex + 1,
          endLineNumber: lineNumber,
          endColumn: lastIncludedCharIndex + 2
        },
        url: line.substring(linkBeginIndex, lastIncludedCharIndex + 1)
      };
    }
    static computeLinks(model, stateMachine = getStateMachine()) {
      const classifier = getClassifier();
      const result = [];
      for (let i = 1, lineCount = model.getLineCount(); i <= lineCount; i++) {
        const line = model.getLineContent(i);
        const len = line.length;
        let j = 0;
        let linkBeginIndex = 0;
        let linkBeginChCode = 0;
        let state = 1;
        let hasOpenParens = false;
        let hasOpenSquareBracket = false;
        let inSquareBrackets = false;
        let hasOpenCurlyBracket = false;
        while (j < len) {
          let resetStateMachine = false;
          const chCode = line.charCodeAt(j);
          if (state === 13) {
            let chClass;
            switch (chCode) {
              case 40:
                hasOpenParens = true;
                chClass = 0;
                break;
              case 41:
                chClass = hasOpenParens ? 0 : 1;
                break;
              case 91:
                inSquareBrackets = true;
                hasOpenSquareBracket = true;
                chClass = 0;
                break;
              case 93:
                inSquareBrackets = false;
                chClass = hasOpenSquareBracket ? 0 : 1;
                break;
              case 123:
                hasOpenCurlyBracket = true;
                chClass = 0;
                break;
              case 125:
                chClass = hasOpenCurlyBracket ? 0 : 1;
                break;
              // The following three rules make it that ' or " or ` are allowed inside links
              // only if the link is wrapped by some other quote character
              case 39:
              case 34:
              case 96:
                if (linkBeginChCode === chCode) {
                  chClass = 1;
                } else if (linkBeginChCode === 39 || linkBeginChCode === 34 || linkBeginChCode === 96) {
                  chClass = 0;
                } else {
                  chClass = 1;
                }
                break;
              case 42:
                chClass = linkBeginChCode === 42 ? 1 : 0;
                break;
              case 32:
                chClass = inSquareBrackets ? 0 : 1;
                break;
              default:
                chClass = classifier.get(chCode);
            }
            if (chClass === 1) {
              result.push(LinkComputer._createLink(classifier, line, i, linkBeginIndex, j));
              resetStateMachine = true;
            }
          } else if (state === 12) {
            let chClass;
            if (chCode === 91) {
              hasOpenSquareBracket = true;
              chClass = 0;
            } else {
              chClass = classifier.get(chCode);
            }
            if (chClass === 1) {
              resetStateMachine = true;
            } else {
              state = 13;
            }
          } else {
            state = stateMachine.nextState(state, chCode);
            if (state === 0) {
              resetStateMachine = true;
            }
          }
          if (resetStateMachine) {
            state = 1;
            hasOpenParens = false;
            hasOpenSquareBracket = false;
            hasOpenCurlyBracket = false;
            linkBeginIndex = j + 1;
            linkBeginChCode = chCode;
          }
          j++;
        }
        if (state === 13) {
          result.push(LinkComputer._createLink(classifier, line, i, linkBeginIndex, len));
        }
      }
      return result;
    }
  }
  function computeLinks(model) {
    if (!model || typeof model.getLineCount !== "function" || typeof model.getLineContent !== "function") {
      return [];
    }
    return LinkComputer.computeLinks(model);
  }
  const _BasicInplaceReplace = class _BasicInplaceReplace {
    constructor() {
      this._defaultValueSet = [
        ["true", "false"],
        ["True", "False"],
        ["Private", "Public", "Friend", "ReadOnly", "Partial", "Protected", "WriteOnly"],
        ["public", "protected", "private"]
      ];
    }
    navigateValueSet(range1, text1, range2, text2, up) {
      if (range1 && text1) {
        const result = this.doNavigateValueSet(text1, up);
        if (result) {
          return {
            range: range1,
            value: result
          };
        }
      }
      if (range2 && text2) {
        const result = this.doNavigateValueSet(text2, up);
        if (result) {
          return {
            range: range2,
            value: result
          };
        }
      }
      return null;
    }
    doNavigateValueSet(text, up) {
      const numberResult = this.numberReplace(text, up);
      if (numberResult !== null) {
        return numberResult;
      }
      return this.textReplace(text, up);
    }
    numberReplace(value, up) {
      const precision = Math.pow(10, value.length - (value.lastIndexOf(".") + 1));
      let n1 = Number(value);
      const n2 = parseFloat(value);
      if (!isNaN(n1) && !isNaN(n2) && n1 === n2) {
        if (n1 === 0 && !up) {
          return null;
        } else {
          n1 = Math.floor(n1 * precision);
          n1 += up ? precision : -precision;
          return String(n1 / precision);
        }
      }
      return null;
    }
    textReplace(value, up) {
      return this.valueSetsReplace(this._defaultValueSet, value, up);
    }
    valueSetsReplace(valueSets, value, up) {
      let result = null;
      for (let i = 0, len = valueSets.length; result === null && i < len; i++) {
        result = this.valueSetReplace(valueSets[i], value, up);
      }
      return result;
    }
    valueSetReplace(valueSet, value, up) {
      let idx = valueSet.indexOf(value);
      if (idx >= 0) {
        idx += up ? 1 : -1;
        if (idx < 0) {
          idx = valueSet.length - 1;
        } else {
          idx %= valueSet.length;
        }
        return valueSet[idx];
      }
      return null;
    }
  };
  _BasicInplaceReplace.INSTANCE = new _BasicInplaceReplace();
  let BasicInplaceReplace = _BasicInplaceReplace;
  const shortcutEvent = Object.freeze(function(callback, context) {
    const handle = setTimeout(callback.bind(context), 0);
    return { dispose() {
      clearTimeout(handle);
    } };
  });
  var CancellationToken;
  (function(CancellationToken2) {
    function isCancellationToken(thing) {
      if (thing === CancellationToken2.None || thing === CancellationToken2.Cancelled) {
        return true;
      }
      if (thing instanceof MutableToken) {
        return true;
      }
      if (!thing || typeof thing !== "object") {
        return false;
      }
      return typeof thing.isCancellationRequested === "boolean" && typeof thing.onCancellationRequested === "function";
    }
    CancellationToken2.isCancellationToken = isCancellationToken;
    CancellationToken2.None = Object.freeze({
      isCancellationRequested: false,
      onCancellationRequested: Event.None
    });
    CancellationToken2.Cancelled = Object.freeze({
      isCancellationRequested: true,
      onCancellationRequested: shortcutEvent
    });
  })(CancellationToken || (CancellationToken = {}));
  class MutableToken {
    constructor() {
      this._isCancelled = false;
      this._emitter = null;
    }
    cancel() {
      if (!this._isCancelled) {
        this._isCancelled = true;
        if (this._emitter) {
          this._emitter.fire(void 0);
          this.dispose();
        }
      }
    }
    get isCancellationRequested() {
      return this._isCancelled;
    }
    get onCancellationRequested() {
      if (this._isCancelled) {
        return shortcutEvent;
      }
      if (!this._emitter) {
        this._emitter = new Emitter();
      }
      return this._emitter.event;
    }
    dispose() {
      if (this._emitter) {
        this._emitter.dispose();
        this._emitter = null;
      }
    }
  }
  class CancellationTokenSource {
    constructor(parent) {
      this._token = void 0;
      this._parentListener = void 0;
      this._parentListener = parent && parent.onCancellationRequested(this.cancel, this);
    }
    get token() {
      if (!this._token) {
        this._token = new MutableToken();
      }
      return this._token;
    }
    cancel() {
      if (!this._token) {
        this._token = CancellationToken.Cancelled;
      } else if (this._token instanceof MutableToken) {
        this._token.cancel();
      }
    }
    dispose(cancel = false) {
      if (cancel) {
        this.cancel();
      }
      this._parentListener?.dispose();
      if (!this._token) {
        this._token = CancellationToken.None;
      } else if (this._token instanceof MutableToken) {
        this._token.dispose();
      }
    }
  }
  class KeyCodeStrMap {
    constructor() {
      this._keyCodeToStr = [];
      this._strToKeyCode = /* @__PURE__ */ Object.create(null);
    }
    define(keyCode, str) {
      this._keyCodeToStr[keyCode] = str;
      this._strToKeyCode[str.toLowerCase()] = keyCode;
    }
    keyCodeToStr(keyCode) {
      return this._keyCodeToStr[keyCode];
    }
    strToKeyCode(str) {
      return this._strToKeyCode[str.toLowerCase()] || 0;
    }
  }
  const uiMap = new KeyCodeStrMap();
  const userSettingsUSMap = new KeyCodeStrMap();
  const userSettingsGeneralMap = new KeyCodeStrMap();
  const EVENT_KEY_CODE_MAP = new Array(230);
  const scanCodeStrToInt = /* @__PURE__ */ Object.create(null);
  const scanCodeLowerCaseStrToInt = /* @__PURE__ */ Object.create(null);
  (function() {
    const empty = "";
    const mappings = [
      // immutable, scanCode, scanCodeStr, keyCode, keyCodeStr, eventKeyCode, vkey, usUserSettingsLabel, generalUserSettingsLabel
      [1, 0, "None", 0, "unknown", 0, "VK_UNKNOWN", empty, empty],
      [1, 1, "Hyper", 0, empty, 0, empty, empty, empty],
      [1, 2, "Super", 0, empty, 0, empty, empty, empty],
      [1, 3, "Fn", 0, empty, 0, empty, empty, empty],
      [1, 4, "FnLock", 0, empty, 0, empty, empty, empty],
      [1, 5, "Suspend", 0, empty, 0, empty, empty, empty],
      [1, 6, "Resume", 0, empty, 0, empty, empty, empty],
      [1, 7, "Turbo", 0, empty, 0, empty, empty, empty],
      [1, 8, "Sleep", 0, empty, 0, "VK_SLEEP", empty, empty],
      [1, 9, "WakeUp", 0, empty, 0, empty, empty, empty],
      [0, 10, "KeyA", 31, "A", 65, "VK_A", empty, empty],
      [0, 11, "KeyB", 32, "B", 66, "VK_B", empty, empty],
      [0, 12, "KeyC", 33, "C", 67, "VK_C", empty, empty],
      [0, 13, "KeyD", 34, "D", 68, "VK_D", empty, empty],
      [0, 14, "KeyE", 35, "E", 69, "VK_E", empty, empty],
      [0, 15, "KeyF", 36, "F", 70, "VK_F", empty, empty],
      [0, 16, "KeyG", 37, "G", 71, "VK_G", empty, empty],
      [0, 17, "KeyH", 38, "H", 72, "VK_H", empty, empty],
      [0, 18, "KeyI", 39, "I", 73, "VK_I", empty, empty],
      [0, 19, "KeyJ", 40, "J", 74, "VK_J", empty, empty],
      [0, 20, "KeyK", 41, "K", 75, "VK_K", empty, empty],
      [0, 21, "KeyL", 42, "L", 76, "VK_L", empty, empty],
      [0, 22, "KeyM", 43, "M", 77, "VK_M", empty, empty],
      [0, 23, "KeyN", 44, "N", 78, "VK_N", empty, empty],
      [0, 24, "KeyO", 45, "O", 79, "VK_O", empty, empty],
      [0, 25, "KeyP", 46, "P", 80, "VK_P", empty, empty],
      [0, 26, "KeyQ", 47, "Q", 81, "VK_Q", empty, empty],
      [0, 27, "KeyR", 48, "R", 82, "VK_R", empty, empty],
      [0, 28, "KeyS", 49, "S", 83, "VK_S", empty, empty],
      [0, 29, "KeyT", 50, "T", 84, "VK_T", empty, empty],
      [0, 30, "KeyU", 51, "U", 85, "VK_U", empty, empty],
      [0, 31, "KeyV", 52, "V", 86, "VK_V", empty, empty],
      [0, 32, "KeyW", 53, "W", 87, "VK_W", empty, empty],
      [0, 33, "KeyX", 54, "X", 88, "VK_X", empty, empty],
      [0, 34, "KeyY", 55, "Y", 89, "VK_Y", empty, empty],
      [0, 35, "KeyZ", 56, "Z", 90, "VK_Z", empty, empty],
      [0, 36, "Digit1", 22, "1", 49, "VK_1", empty, empty],
      [0, 37, "Digit2", 23, "2", 50, "VK_2", empty, empty],
      [0, 38, "Digit3", 24, "3", 51, "VK_3", empty, empty],
      [0, 39, "Digit4", 25, "4", 52, "VK_4", empty, empty],
      [0, 40, "Digit5", 26, "5", 53, "VK_5", empty, empty],
      [0, 41, "Digit6", 27, "6", 54, "VK_6", empty, empty],
      [0, 42, "Digit7", 28, "7", 55, "VK_7", empty, empty],
      [0, 43, "Digit8", 29, "8", 56, "VK_8", empty, empty],
      [0, 44, "Digit9", 30, "9", 57, "VK_9", empty, empty],
      [0, 45, "Digit0", 21, "0", 48, "VK_0", empty, empty],
      [1, 46, "Enter", 3, "Enter", 13, "VK_RETURN", empty, empty],
      [1, 47, "Escape", 9, "Escape", 27, "VK_ESCAPE", empty, empty],
      [1, 48, "Backspace", 1, "Backspace", 8, "VK_BACK", empty, empty],
      [1, 49, "Tab", 2, "Tab", 9, "VK_TAB", empty, empty],
      [1, 50, "Space", 10, "Space", 32, "VK_SPACE", empty, empty],
      [0, 51, "Minus", 88, "-", 189, "VK_OEM_MINUS", "-", "OEM_MINUS"],
      [0, 52, "Equal", 86, "=", 187, "VK_OEM_PLUS", "=", "OEM_PLUS"],
      [0, 53, "BracketLeft", 92, "[", 219, "VK_OEM_4", "[", "OEM_4"],
      [0, 54, "BracketRight", 94, "]", 221, "VK_OEM_6", "]", "OEM_6"],
      [0, 55, "Backslash", 93, "\\", 220, "VK_OEM_5", "\\", "OEM_5"],
      [0, 56, "IntlHash", 0, empty, 0, empty, empty, empty],
      // has been dropped from the w3c spec
      [0, 57, "Semicolon", 85, ";", 186, "VK_OEM_1", ";", "OEM_1"],
      [0, 58, "Quote", 95, "'", 222, "VK_OEM_7", "'", "OEM_7"],
      [0, 59, "Backquote", 91, "`", 192, "VK_OEM_3", "`", "OEM_3"],
      [0, 60, "Comma", 87, ",", 188, "VK_OEM_COMMA", ",", "OEM_COMMA"],
      [0, 61, "Period", 89, ".", 190, "VK_OEM_PERIOD", ".", "OEM_PERIOD"],
      [0, 62, "Slash", 90, "/", 191, "VK_OEM_2", "/", "OEM_2"],
      [1, 63, "CapsLock", 8, "CapsLock", 20, "VK_CAPITAL", empty, empty],
      [1, 64, "F1", 59, "F1", 112, "VK_F1", empty, empty],
      [1, 65, "F2", 60, "F2", 113, "VK_F2", empty, empty],
      [1, 66, "F3", 61, "F3", 114, "VK_F3", empty, empty],
      [1, 67, "F4", 62, "F4", 115, "VK_F4", empty, empty],
      [1, 68, "F5", 63, "F5", 116, "VK_F5", empty, empty],
      [1, 69, "F6", 64, "F6", 117, "VK_F6", empty, empty],
      [1, 70, "F7", 65, "F7", 118, "VK_F7", empty, empty],
      [1, 71, "F8", 66, "F8", 119, "VK_F8", empty, empty],
      [1, 72, "F9", 67, "F9", 120, "VK_F9", empty, empty],
      [1, 73, "F10", 68, "F10", 121, "VK_F10", empty, empty],
      [1, 74, "F11", 69, "F11", 122, "VK_F11", empty, empty],
      [1, 75, "F12", 70, "F12", 123, "VK_F12", empty, empty],
      [1, 76, "PrintScreen", 0, empty, 0, empty, empty, empty],
      [1, 77, "ScrollLock", 84, "ScrollLock", 145, "VK_SCROLL", empty, empty],
      [1, 78, "Pause", 7, "PauseBreak", 19, "VK_PAUSE", empty, empty],
      [1, 79, "Insert", 19, "Insert", 45, "VK_INSERT", empty, empty],
      [1, 80, "Home", 14, "Home", 36, "VK_HOME", empty, empty],
      [1, 81, "PageUp", 11, "PageUp", 33, "VK_PRIOR", empty, empty],
      [1, 82, "Delete", 20, "Delete", 46, "VK_DELETE", empty, empty],
      [1, 83, "End", 13, "End", 35, "VK_END", empty, empty],
      [1, 84, "PageDown", 12, "PageDown", 34, "VK_NEXT", empty, empty],
      [1, 85, "ArrowRight", 17, "RightArrow", 39, "VK_RIGHT", "Right", empty],
      [1, 86, "ArrowLeft", 15, "LeftArrow", 37, "VK_LEFT", "Left", empty],
      [1, 87, "ArrowDown", 18, "DownArrow", 40, "VK_DOWN", "Down", empty],
      [1, 88, "ArrowUp", 16, "UpArrow", 38, "VK_UP", "Up", empty],
      [1, 89, "NumLock", 83, "NumLock", 144, "VK_NUMLOCK", empty, empty],
      [1, 90, "NumpadDivide", 113, "NumPad_Divide", 111, "VK_DIVIDE", empty, empty],
      [1, 91, "NumpadMultiply", 108, "NumPad_Multiply", 106, "VK_MULTIPLY", empty, empty],
      [1, 92, "NumpadSubtract", 111, "NumPad_Subtract", 109, "VK_SUBTRACT", empty, empty],
      [1, 93, "NumpadAdd", 109, "NumPad_Add", 107, "VK_ADD", empty, empty],
      [1, 94, "NumpadEnter", 3, empty, 0, empty, empty, empty],
      [1, 95, "Numpad1", 99, "NumPad1", 97, "VK_NUMPAD1", empty, empty],
      [1, 96, "Numpad2", 100, "NumPad2", 98, "VK_NUMPAD2", empty, empty],
      [1, 97, "Numpad3", 101, "NumPad3", 99, "VK_NUMPAD3", empty, empty],
      [1, 98, "Numpad4", 102, "NumPad4", 100, "VK_NUMPAD4", empty, empty],
      [1, 99, "Numpad5", 103, "NumPad5", 101, "VK_NUMPAD5", empty, empty],
      [1, 100, "Numpad6", 104, "NumPad6", 102, "VK_NUMPAD6", empty, empty],
      [1, 101, "Numpad7", 105, "NumPad7", 103, "VK_NUMPAD7", empty, empty],
      [1, 102, "Numpad8", 106, "NumPad8", 104, "VK_NUMPAD8", empty, empty],
      [1, 103, "Numpad9", 107, "NumPad9", 105, "VK_NUMPAD9", empty, empty],
      [1, 104, "Numpad0", 98, "NumPad0", 96, "VK_NUMPAD0", empty, empty],
      [1, 105, "NumpadDecimal", 112, "NumPad_Decimal", 110, "VK_DECIMAL", empty, empty],
      [0, 106, "IntlBackslash", 97, "OEM_102", 226, "VK_OEM_102", empty, empty],
      [1, 107, "ContextMenu", 58, "ContextMenu", 93, empty, empty, empty],
      [1, 108, "Power", 0, empty, 0, empty, empty, empty],
      [1, 109, "NumpadEqual", 0, empty, 0, empty, empty, empty],
      [1, 110, "F13", 71, "F13", 124, "VK_F13", empty, empty],
      [1, 111, "F14", 72, "F14", 125, "VK_F14", empty, empty],
      [1, 112, "F15", 73, "F15", 126, "VK_F15", empty, empty],
      [1, 113, "F16", 74, "F16", 127, "VK_F16", empty, empty],
      [1, 114, "F17", 75, "F17", 128, "VK_F17", empty, empty],
      [1, 115, "F18", 76, "F18", 129, "VK_F18", empty, empty],
      [1, 116, "F19", 77, "F19", 130, "VK_F19", empty, empty],
      [1, 117, "F20", 78, "F20", 131, "VK_F20", empty, empty],
      [1, 118, "F21", 79, "F21", 132, "VK_F21", empty, empty],
      [1, 119, "F22", 80, "F22", 133, "VK_F22", empty, empty],
      [1, 120, "F23", 81, "F23", 134, "VK_F23", empty, empty],
      [1, 121, "F24", 82, "F24", 135, "VK_F24", empty, empty],
      [1, 122, "Open", 0, empty, 0, empty, empty, empty],
      [1, 123, "Help", 0, empty, 0, empty, empty, empty],
      [1, 124, "Select", 0, empty, 0, empty, empty, empty],
      [1, 125, "Again", 0, empty, 0, empty, empty, empty],
      [1, 126, "Undo", 0, empty, 0, empty, empty, empty],
      [1, 127, "Cut", 0, empty, 0, empty, empty, empty],
      [1, 128, "Copy", 0, empty, 0, empty, empty, empty],
      [1, 129, "Paste", 0, empty, 0, empty, empty, empty],
      [1, 130, "Find", 0, empty, 0, empty, empty, empty],
      [1, 131, "AudioVolumeMute", 117, "AudioVolumeMute", 173, "VK_VOLUME_MUTE", empty, empty],
      [1, 132, "AudioVolumeUp", 118, "AudioVolumeUp", 175, "VK_VOLUME_UP", empty, empty],
      [1, 133, "AudioVolumeDown", 119, "AudioVolumeDown", 174, "VK_VOLUME_DOWN", empty, empty],
      [1, 134, "NumpadComma", 110, "NumPad_Separator", 108, "VK_SEPARATOR", empty, empty],
      [0, 135, "IntlRo", 115, "ABNT_C1", 193, "VK_ABNT_C1", empty, empty],
      [1, 136, "KanaMode", 0, empty, 0, empty, empty, empty],
      [0, 137, "IntlYen", 0, empty, 0, empty, empty, empty],
      [1, 138, "Convert", 0, empty, 0, empty, empty, empty],
      [1, 139, "NonConvert", 0, empty, 0, empty, empty, empty],
      [1, 140, "Lang1", 0, empty, 0, empty, empty, empty],
      [1, 141, "Lang2", 0, empty, 0, empty, empty, empty],
      [1, 142, "Lang3", 0, empty, 0, empty, empty, empty],
      [1, 143, "Lang4", 0, empty, 0, empty, empty, empty],
      [1, 144, "Lang5", 0, empty, 0, empty, empty, empty],
      [1, 145, "Abort", 0, empty, 0, empty, empty, empty],
      [1, 146, "Props", 0, empty, 0, empty, empty, empty],
      [1, 147, "NumpadParenLeft", 0, empty, 0, empty, empty, empty],
      [1, 148, "NumpadParenRight", 0, empty, 0, empty, empty, empty],
      [1, 149, "NumpadBackspace", 0, empty, 0, empty, empty, empty],
      [1, 150, "NumpadMemoryStore", 0, empty, 0, empty, empty, empty],
      [1, 151, "NumpadMemoryRecall", 0, empty, 0, empty, empty, empty],
      [1, 152, "NumpadMemoryClear", 0, empty, 0, empty, empty, empty],
      [1, 153, "NumpadMemoryAdd", 0, empty, 0, empty, empty, empty],
      [1, 154, "NumpadMemorySubtract", 0, empty, 0, empty, empty, empty],
      [1, 155, "NumpadClear", 131, "Clear", 12, "VK_CLEAR", empty, empty],
      [1, 156, "NumpadClearEntry", 0, empty, 0, empty, empty, empty],
      [1, 0, empty, 5, "Ctrl", 17, "VK_CONTROL", empty, empty],
      [1, 0, empty, 4, "Shift", 16, "VK_SHIFT", empty, empty],
      [1, 0, empty, 6, "Alt", 18, "VK_MENU", empty, empty],
      [1, 0, empty, 57, "Meta", 91, "VK_COMMAND", empty, empty],
      [1, 157, "ControlLeft", 5, empty, 0, "VK_LCONTROL", empty, empty],
      [1, 158, "ShiftLeft", 4, empty, 0, "VK_LSHIFT", empty, empty],
      [1, 159, "AltLeft", 6, empty, 0, "VK_LMENU", empty, empty],
      [1, 160, "MetaLeft", 57, empty, 0, "VK_LWIN", empty, empty],
      [1, 161, "ControlRight", 5, empty, 0, "VK_RCONTROL", empty, empty],
      [1, 162, "ShiftRight", 4, empty, 0, "VK_RSHIFT", empty, empty],
      [1, 163, "AltRight", 6, empty, 0, "VK_RMENU", empty, empty],
      [1, 164, "MetaRight", 57, empty, 0, "VK_RWIN", empty, empty],
      [1, 165, "BrightnessUp", 0, empty, 0, empty, empty, empty],
      [1, 166, "BrightnessDown", 0, empty, 0, empty, empty, empty],
      [1, 167, "MediaPlay", 0, empty, 0, empty, empty, empty],
      [1, 168, "MediaRecord", 0, empty, 0, empty, empty, empty],
      [1, 169, "MediaFastForward", 0, empty, 0, empty, empty, empty],
      [1, 170, "MediaRewind", 0, empty, 0, empty, empty, empty],
      [1, 171, "MediaTrackNext", 124, "MediaTrackNext", 176, "VK_MEDIA_NEXT_TRACK", empty, empty],
      [1, 172, "MediaTrackPrevious", 125, "MediaTrackPrevious", 177, "VK_MEDIA_PREV_TRACK", empty, empty],
      [1, 173, "MediaStop", 126, "MediaStop", 178, "VK_MEDIA_STOP", empty, empty],
      [1, 174, "Eject", 0, empty, 0, empty, empty, empty],
      [1, 175, "MediaPlayPause", 127, "MediaPlayPause", 179, "VK_MEDIA_PLAY_PAUSE", empty, empty],
      [1, 176, "MediaSelect", 128, "LaunchMediaPlayer", 181, "VK_MEDIA_LAUNCH_MEDIA_SELECT", empty, empty],
      [1, 177, "LaunchMail", 129, "LaunchMail", 180, "VK_MEDIA_LAUNCH_MAIL", empty, empty],
      [1, 178, "LaunchApp2", 130, "LaunchApp2", 183, "VK_MEDIA_LAUNCH_APP2", empty, empty],
      [1, 179, "LaunchApp1", 0, empty, 0, "VK_MEDIA_LAUNCH_APP1", empty, empty],
      [1, 180, "SelectTask", 0, empty, 0, empty, empty, empty],
      [1, 181, "LaunchScreenSaver", 0, empty, 0, empty, empty, empty],
      [1, 182, "BrowserSearch", 120, "BrowserSearch", 170, "VK_BROWSER_SEARCH", empty, empty],
      [1, 183, "BrowserHome", 121, "BrowserHome", 172, "VK_BROWSER_HOME", empty, empty],
      [1, 184, "BrowserBack", 122, "BrowserBack", 166, "VK_BROWSER_BACK", empty, empty],
      [1, 185, "BrowserForward", 123, "BrowserForward", 167, "VK_BROWSER_FORWARD", empty, empty],
      [1, 186, "BrowserStop", 0, empty, 0, "VK_BROWSER_STOP", empty, empty],
      [1, 187, "BrowserRefresh", 0, empty, 0, "VK_BROWSER_REFRESH", empty, empty],
      [1, 188, "BrowserFavorites", 0, empty, 0, "VK_BROWSER_FAVORITES", empty, empty],
      [1, 189, "ZoomToggle", 0, empty, 0, empty, empty, empty],
      [1, 190, "MailReply", 0, empty, 0, empty, empty, empty],
      [1, 191, "MailForward", 0, empty, 0, empty, empty, empty],
      [1, 192, "MailSend", 0, empty, 0, empty, empty, empty],
      // See https://lists.w3.org/Archives/Public/www-dom/2010JulSep/att-0182/keyCode-spec.html
      // If an Input Method Editor is processing key input and the event is keydown, return 229.
      [1, 0, empty, 114, "KeyInComposition", 229, empty, empty, empty],
      [1, 0, empty, 116, "ABNT_C2", 194, "VK_ABNT_C2", empty, empty],
      [1, 0, empty, 96, "OEM_8", 223, "VK_OEM_8", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_KANA", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_HANGUL", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_JUNJA", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_FINAL", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_HANJA", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_KANJI", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_CONVERT", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_NONCONVERT", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_ACCEPT", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_MODECHANGE", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_SELECT", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_PRINT", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_EXECUTE", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_SNAPSHOT", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_HELP", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_APPS", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_PROCESSKEY", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_PACKET", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_DBE_SBCSCHAR", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_DBE_DBCSCHAR", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_ATTN", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_CRSEL", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_EXSEL", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_EREOF", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_PLAY", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_ZOOM", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_NONAME", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_PA1", empty, empty],
      [1, 0, empty, 0, empty, 0, "VK_OEM_CLEAR", empty, empty]
    ];
    const seenKeyCode = [];
    const seenScanCode = [];
    for (const mapping of mappings) {
      const [immutable, scanCode, scanCodeStr, keyCode, keyCodeStr, eventKeyCode, vkey, usUserSettingsLabel, generalUserSettingsLabel] = mapping;
      if (!seenScanCode[scanCode]) {
        seenScanCode[scanCode] = true;
        scanCodeStrToInt[scanCodeStr] = scanCode;
        scanCodeLowerCaseStrToInt[scanCodeStr.toLowerCase()] = scanCode;
      }
      if (!seenKeyCode[keyCode]) {
        seenKeyCode[keyCode] = true;
        if (!keyCodeStr) {
          throw new Error(`String representation missing for key code ${keyCode} around scan code ${scanCodeStr}`);
        }
        uiMap.define(keyCode, keyCodeStr);
        userSettingsUSMap.define(keyCode, usUserSettingsLabel || keyCodeStr);
        userSettingsGeneralMap.define(keyCode, generalUserSettingsLabel || usUserSettingsLabel || keyCodeStr);
      }
      if (eventKeyCode) {
        EVENT_KEY_CODE_MAP[eventKeyCode] = keyCode;
      }
    }
  })();
  var KeyCodeUtils;
  (function(KeyCodeUtils2) {
    function toString(keyCode) {
      return uiMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toString = toString;
    function fromString(key) {
      return uiMap.strToKeyCode(key);
    }
    KeyCodeUtils2.fromString = fromString;
    function toUserSettingsUS(keyCode) {
      return userSettingsUSMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toUserSettingsUS = toUserSettingsUS;
    function toUserSettingsGeneral(keyCode) {
      return userSettingsGeneralMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toUserSettingsGeneral = toUserSettingsGeneral;
    function fromUserSettings(key) {
      return userSettingsUSMap.strToKeyCode(key) || userSettingsGeneralMap.strToKeyCode(key);
    }
    KeyCodeUtils2.fromUserSettings = fromUserSettings;
    function toElectronAccelerator(keyCode) {
      if (keyCode >= 98 && keyCode <= 113) {
        return null;
      }
      switch (keyCode) {
        case 16:
          return "Up";
        case 18:
          return "Down";
        case 15:
          return "Left";
        case 17:
          return "Right";
      }
      return uiMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils2.toElectronAccelerator = toElectronAccelerator;
  })(KeyCodeUtils || (KeyCodeUtils = {}));
  function KeyChord(firstPart, secondPart) {
    const chordPart = (secondPart & 65535) << 16 >>> 0;
    return (firstPart | chordPart) >>> 0;
  }
  let safeProcess;
  const vscodeGlobal = globalThis.vscode;
  if (typeof vscodeGlobal !== "undefined" && typeof vscodeGlobal.process !== "undefined") {
    const sandboxProcess = vscodeGlobal.process;
    safeProcess = {
      get platform() {
        return sandboxProcess.platform;
      },
      get arch() {
        return sandboxProcess.arch;
      },
      get env() {
        return sandboxProcess.env;
      },
      cwd() {
        return sandboxProcess.cwd();
      }
    };
  } else if (typeof process !== "undefined" && typeof process?.versions?.node === "string") {
    safeProcess = {
      get platform() {
        return process.platform;
      },
      get arch() {
        return process.arch;
      },
      get env() {
        return process.env;
      },
      cwd() {
        return process.env["VSCODE_CWD"] || process.cwd();
      }
    };
  } else {
    safeProcess = {
      // Supported
      get platform() {
        return isWindows ? "win32" : isMacintosh ? "darwin" : "linux";
      },
      get arch() {
        return void 0;
      },
      // Unsupported
      get env() {
        return {};
      },
      cwd() {
        return "/";
      }
    };
  }
  const cwd = safeProcess.cwd;
  const env = safeProcess.env;
  const platform = safeProcess.platform;
  const CHAR_UPPERCASE_A = 65;
  const CHAR_LOWERCASE_A = 97;
  const CHAR_UPPERCASE_Z = 90;
  const CHAR_LOWERCASE_Z = 122;
  const CHAR_DOT = 46;
  const CHAR_FORWARD_SLASH = 47;
  const CHAR_BACKWARD_SLASH = 92;
  const CHAR_COLON = 58;
  const CHAR_QUESTION_MARK = 63;
  class ErrorInvalidArgType extends Error {
    constructor(name, expected, actual) {
      let determiner;
      if (typeof expected === "string" && expected.indexOf("not ") === 0) {
        determiner = "must not be";
        expected = expected.replace(/^not /, "");
      } else {
        determiner = "must be";
      }
      const type = name.indexOf(".") !== -1 ? "property" : "argument";
      let msg = `The "${name}" ${type} ${determiner} of type ${expected}`;
      msg += `. Received type ${typeof actual}`;
      super(msg);
      this.code = "ERR_INVALID_ARG_TYPE";
    }
  }
  function validateObject(pathObject, name) {
    if (pathObject === null || typeof pathObject !== "object") {
      throw new ErrorInvalidArgType(name, "Object", pathObject);
    }
  }
  function validateString(value, name) {
    if (typeof value !== "string") {
      throw new ErrorInvalidArgType(name, "string", value);
    }
  }
  const platformIsWin32 = platform === "win32";
  function isPathSeparator(code) {
    return code === CHAR_FORWARD_SLASH || code === CHAR_BACKWARD_SLASH;
  }
  function isPosixPathSeparator(code) {
    return code === CHAR_FORWARD_SLASH;
  }
  function isWindowsDeviceRoot(code) {
    return code >= CHAR_UPPERCASE_A && code <= CHAR_UPPERCASE_Z || code >= CHAR_LOWERCASE_A && code <= CHAR_LOWERCASE_Z;
  }
  function normalizeString(path, allowAboveRoot, separator, isPathSeparator2) {
    let res = "";
    let lastSegmentLength = 0;
    let lastSlash = -1;
    let dots = 0;
    let code = 0;
    for (let i = 0; i <= path.length; ++i) {
      if (i < path.length) {
        code = path.charCodeAt(i);
      } else if (isPathSeparator2(code)) {
        break;
      } else {
        code = CHAR_FORWARD_SLASH;
      }
      if (isPathSeparator2(code)) {
        if (lastSlash === i - 1 || dots === 1) ;
        else if (dots === 2) {
          if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== CHAR_DOT || res.charCodeAt(res.length - 2) !== CHAR_DOT) {
            if (res.length > 2) {
              const lastSlashIndex = res.lastIndexOf(separator);
              if (lastSlashIndex === -1) {
                res = "";
                lastSegmentLength = 0;
              } else {
                res = res.slice(0, lastSlashIndex);
                lastSegmentLength = res.length - 1 - res.lastIndexOf(separator);
              }
              lastSlash = i;
              dots = 0;
              continue;
            } else if (res.length !== 0) {
              res = "";
              lastSegmentLength = 0;
              lastSlash = i;
              dots = 0;
              continue;
            }
          }
          if (allowAboveRoot) {
            res += res.length > 0 ? `${separator}..` : "..";
            lastSegmentLength = 2;
          }
        } else {
          if (res.length > 0) {
            res += `${separator}${path.slice(lastSlash + 1, i)}`;
          } else {
            res = path.slice(lastSlash + 1, i);
          }
          lastSegmentLength = i - lastSlash - 1;
        }
        lastSlash = i;
        dots = 0;
      } else if (code === CHAR_DOT && dots !== -1) {
        ++dots;
      } else {
        dots = -1;
      }
    }
    return res;
  }
  function formatExt(ext) {
    return ext ? `${ext[0] === "." ? "" : "."}${ext}` : "";
  }
  function _format(sep, pathObject) {
    validateObject(pathObject, "pathObject");
    const dir = pathObject.dir || pathObject.root;
    const base = pathObject.base || `${pathObject.name || ""}${formatExt(pathObject.ext)}`;
    if (!dir) {
      return base;
    }
    return dir === pathObject.root ? `${dir}${base}` : `${dir}${sep}${base}`;
  }
  const win32 = {
    // path.resolve([from ...], to)
    resolve(...pathSegments) {
      let resolvedDevice = "";
      let resolvedTail = "";
      let resolvedAbsolute = false;
      for (let i = pathSegments.length - 1; i >= -1; i--) {
        let path;
        if (i >= 0) {
          path = pathSegments[i];
          validateString(path, `paths[${i}]`);
          if (path.length === 0) {
            continue;
          }
        } else if (resolvedDevice.length === 0) {
          path = cwd();
        } else {
          path = env[`=${resolvedDevice}`] || cwd();
          if (path === void 0 || path.slice(0, 2).toLowerCase() !== resolvedDevice.toLowerCase() && path.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
            path = `${resolvedDevice}\\`;
          }
        }
        const len = path.length;
        let rootEnd = 0;
        let device = "";
        let isAbsolute = false;
        const code = path.charCodeAt(0);
        if (len === 1) {
          if (isPathSeparator(code)) {
            rootEnd = 1;
            isAbsolute = true;
          }
        } else if (isPathSeparator(code)) {
          isAbsolute = true;
          if (isPathSeparator(path.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              const firstPart = path.slice(last, j);
              last = j;
              while (j < len && isPathSeparator(path.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator(path.charCodeAt(j))) {
                  j++;
                }
                if (j === len || j !== last) {
                  device = `\\\\${firstPart}\\${path.slice(last, j)}`;
                  rootEnd = j;
                }
              }
            }
          } else {
            rootEnd = 1;
          }
        } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
          device = path.slice(0, 2);
          rootEnd = 2;
          if (len > 2 && isPathSeparator(path.charCodeAt(2))) {
            isAbsolute = true;
            rootEnd = 3;
          }
        }
        if (device.length > 0) {
          if (resolvedDevice.length > 0) {
            if (device.toLowerCase() !== resolvedDevice.toLowerCase()) {
              continue;
            }
          } else {
            resolvedDevice = device;
          }
        }
        if (resolvedAbsolute) {
          if (resolvedDevice.length > 0) {
            break;
          }
        } else {
          resolvedTail = `${path.slice(rootEnd)}\\${resolvedTail}`;
          resolvedAbsolute = isAbsolute;
          if (isAbsolute && resolvedDevice.length > 0) {
            break;
          }
        }
      }
      resolvedTail = normalizeString(resolvedTail, !resolvedAbsolute, "\\", isPathSeparator);
      return resolvedAbsolute ? `${resolvedDevice}\\${resolvedTail}` : `${resolvedDevice}${resolvedTail}` || ".";
    },
    normalize(path) {
      validateString(path, "path");
      const len = path.length;
      if (len === 0) {
        return ".";
      }
      let rootEnd = 0;
      let device;
      let isAbsolute = false;
      const code = path.charCodeAt(0);
      if (len === 1) {
        return isPosixPathSeparator(code) ? "\\" : path;
      }
      if (isPathSeparator(code)) {
        isAbsolute = true;
        if (isPathSeparator(path.charCodeAt(1))) {
          let j = 2;
          let last = j;
          while (j < len && !isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            const firstPart = path.slice(last, j);
            last = j;
            while (j < len && isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && !isPathSeparator(path.charCodeAt(j))) {
                j++;
              }
              if (j === len) {
                return `\\\\${firstPart}\\${path.slice(last)}\\`;
              }
              if (j !== last) {
                device = `\\\\${firstPart}\\${path.slice(last, j)}`;
                rootEnd = j;
              }
            }
          }
        } else {
          rootEnd = 1;
        }
      } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
        device = path.slice(0, 2);
        rootEnd = 2;
        if (len > 2 && isPathSeparator(path.charCodeAt(2))) {
          isAbsolute = true;
          rootEnd = 3;
        }
      }
      let tail = rootEnd < len ? normalizeString(path.slice(rootEnd), !isAbsolute, "\\", isPathSeparator) : "";
      if (tail.length === 0 && !isAbsolute) {
        tail = ".";
      }
      if (tail.length > 0 && isPathSeparator(path.charCodeAt(len - 1))) {
        tail += "\\";
      }
      if (!isAbsolute && device === void 0 && path.includes(":")) {
        if (tail.length >= 2 && isWindowsDeviceRoot(tail.charCodeAt(0)) && tail.charCodeAt(1) === CHAR_COLON) {
          return `.\\${tail}`;
        }
        let index = path.indexOf(":");
        do {
          if (index === len - 1 || isPathSeparator(path.charCodeAt(index + 1))) {
            return `.\\${tail}`;
          }
        } while ((index = path.indexOf(":", index + 1)) !== -1);
      }
      if (device === void 0) {
        return isAbsolute ? `\\${tail}` : tail;
      }
      return isAbsolute ? `${device}\\${tail}` : `${device}${tail}`;
    },
    isAbsolute(path) {
      validateString(path, "path");
      const len = path.length;
      if (len === 0) {
        return false;
      }
      const code = path.charCodeAt(0);
      return isPathSeparator(code) || // Possible device root
      len > 2 && isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON && isPathSeparator(path.charCodeAt(2));
    },
    join(...paths) {
      if (paths.length === 0) {
        return ".";
      }
      let joined;
      let firstPart;
      for (let i = 0; i < paths.length; ++i) {
        const arg = paths[i];
        validateString(arg, "path");
        if (arg.length > 0) {
          if (joined === void 0) {
            joined = firstPart = arg;
          } else {
            joined += `\\${arg}`;
          }
        }
      }
      if (joined === void 0) {
        return ".";
      }
      let needsReplace = true;
      let slashCount = 0;
      if (typeof firstPart === "string" && isPathSeparator(firstPart.charCodeAt(0))) {
        ++slashCount;
        const firstLen = firstPart.length;
        if (firstLen > 1 && isPathSeparator(firstPart.charCodeAt(1))) {
          ++slashCount;
          if (firstLen > 2) {
            if (isPathSeparator(firstPart.charCodeAt(2))) {
              ++slashCount;
            } else {
              needsReplace = false;
            }
          }
        }
      }
      if (needsReplace) {
        while (slashCount < joined.length && isPathSeparator(joined.charCodeAt(slashCount))) {
          slashCount++;
        }
        if (slashCount >= 2) {
          joined = `\\${joined.slice(slashCount)}`;
        }
      }
      return win32.normalize(joined);
    },
    // It will solve the relative path from `from` to `to`, for instance:
    //  from = 'C:\\orandea\\test\\aaa'
    //  to = 'C:\\orandea\\impl\\bbb'
    // The output of the function should be: '..\\..\\impl\\bbb'
    relative(from, to) {
      validateString(from, "from");
      validateString(to, "to");
      if (from === to) {
        return "";
      }
      const fromOrig = win32.resolve(from);
      const toOrig = win32.resolve(to);
      if (fromOrig === toOrig) {
        return "";
      }
      from = fromOrig.toLowerCase();
      to = toOrig.toLowerCase();
      if (from === to) {
        return "";
      }
      if (fromOrig.length !== from.length || toOrig.length !== to.length) {
        const fromSplit = fromOrig.split("\\");
        const toSplit = toOrig.split("\\");
        if (fromSplit[fromSplit.length - 1] === "") {
          fromSplit.pop();
        }
        if (toSplit[toSplit.length - 1] === "") {
          toSplit.pop();
        }
        const fromLen2 = fromSplit.length;
        const toLen2 = toSplit.length;
        const length2 = fromLen2 < toLen2 ? fromLen2 : toLen2;
        let i2;
        for (i2 = 0; i2 < length2; i2++) {
          if (fromSplit[i2].toLowerCase() !== toSplit[i2].toLowerCase()) {
            break;
          }
        }
        if (i2 === 0) {
          return toOrig;
        } else if (i2 === length2) {
          if (toLen2 > length2) {
            return toSplit.slice(i2).join("\\");
          }
          if (fromLen2 > length2) {
            return "..\\".repeat(fromLen2 - 1 - i2) + "..";
          }
          return "";
        }
        return "..\\".repeat(fromLen2 - i2) + toSplit.slice(i2).join("\\");
      }
      let fromStart = 0;
      while (fromStart < from.length && from.charCodeAt(fromStart) === CHAR_BACKWARD_SLASH) {
        fromStart++;
      }
      let fromEnd = from.length;
      while (fromEnd - 1 > fromStart && from.charCodeAt(fromEnd - 1) === CHAR_BACKWARD_SLASH) {
        fromEnd--;
      }
      const fromLen = fromEnd - fromStart;
      let toStart = 0;
      while (toStart < to.length && to.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
        toStart++;
      }
      let toEnd = to.length;
      while (toEnd - 1 > toStart && to.charCodeAt(toEnd - 1) === CHAR_BACKWARD_SLASH) {
        toEnd--;
      }
      const toLen = toEnd - toStart;
      const length = fromLen < toLen ? fromLen : toLen;
      let lastCommonSep = -1;
      let i = 0;
      for (; i < length; i++) {
        const fromCode = from.charCodeAt(fromStart + i);
        if (fromCode !== to.charCodeAt(toStart + i)) {
          break;
        } else if (fromCode === CHAR_BACKWARD_SLASH) {
          lastCommonSep = i;
        }
      }
      if (i !== length) {
        if (lastCommonSep === -1) {
          return toOrig;
        }
      } else {
        if (toLen > length) {
          if (to.charCodeAt(toStart + i) === CHAR_BACKWARD_SLASH) {
            return toOrig.slice(toStart + i + 1);
          }
          if (i === 2) {
            return toOrig.slice(toStart + i);
          }
        }
        if (fromLen > length) {
          if (from.charCodeAt(fromStart + i) === CHAR_BACKWARD_SLASH) {
            lastCommonSep = i;
          } else if (i === 2) {
            lastCommonSep = 3;
          }
        }
        if (lastCommonSep === -1) {
          lastCommonSep = 0;
        }
      }
      let out = "";
      for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
        if (i === fromEnd || from.charCodeAt(i) === CHAR_BACKWARD_SLASH) {
          out += out.length === 0 ? ".." : "\\..";
        }
      }
      toStart += lastCommonSep;
      if (out.length > 0) {
        return `${out}${toOrig.slice(toStart, toEnd)}`;
      }
      if (toOrig.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
        ++toStart;
      }
      return toOrig.slice(toStart, toEnd);
    },
    toNamespacedPath(path) {
      if (typeof path !== "string" || path.length === 0) {
        return path;
      }
      const resolvedPath = win32.resolve(path);
      if (resolvedPath.length <= 2) {
        return path;
      }
      if (resolvedPath.charCodeAt(0) === CHAR_BACKWARD_SLASH) {
        if (resolvedPath.charCodeAt(1) === CHAR_BACKWARD_SLASH) {
          const code = resolvedPath.charCodeAt(2);
          if (code !== CHAR_QUESTION_MARK && code !== CHAR_DOT) {
            return `\\\\?\\UNC\\${resolvedPath.slice(2)}`;
          }
        }
      } else if (isWindowsDeviceRoot(resolvedPath.charCodeAt(0)) && resolvedPath.charCodeAt(1) === CHAR_COLON && resolvedPath.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
        return `\\\\?\\${resolvedPath}`;
      }
      return resolvedPath;
    },
    dirname(path) {
      validateString(path, "path");
      const len = path.length;
      if (len === 0) {
        return ".";
      }
      let rootEnd = -1;
      let offset = 0;
      const code = path.charCodeAt(0);
      if (len === 1) {
        return isPathSeparator(code) ? path : ".";
      }
      if (isPathSeparator(code)) {
        rootEnd = offset = 1;
        if (isPathSeparator(path.charCodeAt(1))) {
          let j = 2;
          let last = j;
          while (j < len && !isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            last = j;
            while (j < len && isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && !isPathSeparator(path.charCodeAt(j))) {
                j++;
              }
              if (j === len) {
                return path;
              }
              if (j !== last) {
                rootEnd = offset = j + 1;
              }
            }
          }
        }
      } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
        rootEnd = len > 2 && isPathSeparator(path.charCodeAt(2)) ? 3 : 2;
        offset = rootEnd;
      }
      let end = -1;
      let matchedSlash = true;
      for (let i = len - 1; i >= offset; --i) {
        if (isPathSeparator(path.charCodeAt(i))) {
          if (!matchedSlash) {
            end = i;
            break;
          }
        } else {
          matchedSlash = false;
        }
      }
      if (end === -1) {
        if (rootEnd === -1) {
          return ".";
        }
        end = rootEnd;
      }
      return path.slice(0, end);
    },
    basename(path, suffix) {
      if (suffix !== void 0) {
        validateString(suffix, "suffix");
      }
      validateString(path, "path");
      let start2 = 0;
      let end = -1;
      let matchedSlash = true;
      let i;
      if (path.length >= 2 && isWindowsDeviceRoot(path.charCodeAt(0)) && path.charCodeAt(1) === CHAR_COLON) {
        start2 = 2;
      }
      if (suffix !== void 0 && suffix.length > 0 && suffix.length <= path.length) {
        if (suffix === path) {
          return "";
        }
        let extIdx = suffix.length - 1;
        let firstNonSlashEnd = -1;
        for (i = path.length - 1; i >= start2; --i) {
          const code = path.charCodeAt(i);
          if (isPathSeparator(code)) {
            if (!matchedSlash) {
              start2 = i + 1;
              break;
            }
          } else {
            if (firstNonSlashEnd === -1) {
              matchedSlash = false;
              firstNonSlashEnd = i + 1;
            }
            if (extIdx >= 0) {
              if (code === suffix.charCodeAt(extIdx)) {
                if (--extIdx === -1) {
                  end = i;
                }
              } else {
                extIdx = -1;
                end = firstNonSlashEnd;
              }
            }
          }
        }
        if (start2 === end) {
          end = firstNonSlashEnd;
        } else if (end === -1) {
          end = path.length;
        }
        return path.slice(start2, end);
      }
      for (i = path.length - 1; i >= start2; --i) {
        if (isPathSeparator(path.charCodeAt(i))) {
          if (!matchedSlash) {
            start2 = i + 1;
            break;
          }
        } else if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
      }
      if (end === -1) {
        return "";
      }
      return path.slice(start2, end);
    },
    extname(path) {
      validateString(path, "path");
      let start2 = 0;
      let startDot = -1;
      let startPart = 0;
      let end = -1;
      let matchedSlash = true;
      let preDotState = 0;
      if (path.length >= 2 && path.charCodeAt(1) === CHAR_COLON && isWindowsDeviceRoot(path.charCodeAt(0))) {
        start2 = startPart = 2;
      }
      for (let i = path.length - 1; i >= start2; --i) {
        const code = path.charCodeAt(i);
        if (isPathSeparator(code)) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
      }
      return path.slice(startDot, end);
    },
    format: _format.bind(null, "\\"),
    parse(path) {
      validateString(path, "path");
      const ret = { root: "", dir: "", base: "", ext: "", name: "" };
      if (path.length === 0) {
        return ret;
      }
      const len = path.length;
      let rootEnd = 0;
      let code = path.charCodeAt(0);
      if (len === 1) {
        if (isPathSeparator(code)) {
          ret.root = ret.dir = path;
          return ret;
        }
        ret.base = ret.name = path;
        return ret;
      }
      if (isPathSeparator(code)) {
        rootEnd = 1;
        if (isPathSeparator(path.charCodeAt(1))) {
          let j = 2;
          let last = j;
          while (j < len && !isPathSeparator(path.charCodeAt(j))) {
            j++;
          }
          if (j < len && j !== last) {
            last = j;
            while (j < len && isPathSeparator(path.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && !isPathSeparator(path.charCodeAt(j))) {
                j++;
              }
              if (j === len) {
                rootEnd = j;
              } else if (j !== last) {
                rootEnd = j + 1;
              }
            }
          }
        }
      } else if (isWindowsDeviceRoot(code) && path.charCodeAt(1) === CHAR_COLON) {
        if (len <= 2) {
          ret.root = ret.dir = path;
          return ret;
        }
        rootEnd = 2;
        if (isPathSeparator(path.charCodeAt(2))) {
          if (len === 3) {
            ret.root = ret.dir = path;
            return ret;
          }
          rootEnd = 3;
        }
      }
      if (rootEnd > 0) {
        ret.root = path.slice(0, rootEnd);
      }
      let startDot = -1;
      let startPart = rootEnd;
      let end = -1;
      let matchedSlash = true;
      let i = path.length - 1;
      let preDotState = 0;
      for (; i >= rootEnd; --i) {
        code = path.charCodeAt(i);
        if (isPathSeparator(code)) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (end !== -1) {
        if (startDot === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          ret.base = ret.name = path.slice(startPart, end);
        } else {
          ret.name = path.slice(startPart, startDot);
          ret.base = path.slice(startPart, end);
          ret.ext = path.slice(startDot, end);
        }
      }
      if (startPart > 0 && startPart !== rootEnd) {
        ret.dir = path.slice(0, startPart - 1);
      } else {
        ret.dir = ret.root;
      }
      return ret;
    },
    sep: "\\",
    delimiter: ";",
    win32: null,
    posix: null
  };
  const posixCwd = (() => {
    if (platformIsWin32) {
      const regexp = /\\/g;
      return () => {
        const cwd$1 = cwd().replace(regexp, "/");
        return cwd$1.slice(cwd$1.indexOf("/"));
      };
    }
    return () => cwd();
  })();
  const posix = {
    // path.resolve([from ...], to)
    resolve(...pathSegments) {
      let resolvedPath = "";
      let resolvedAbsolute = false;
      for (let i = pathSegments.length - 1; i >= 0 && !resolvedAbsolute; i--) {
        const path = pathSegments[i];
        validateString(path, `paths[${i}]`);
        if (path.length === 0) {
          continue;
        }
        resolvedPath = `${path}/${resolvedPath}`;
        resolvedAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
      }
      if (!resolvedAbsolute) {
        const cwd2 = posixCwd();
        resolvedPath = `${cwd2}/${resolvedPath}`;
        resolvedAbsolute = cwd2.charCodeAt(0) === CHAR_FORWARD_SLASH;
      }
      resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, "/", isPosixPathSeparator);
      if (resolvedAbsolute) {
        return `/${resolvedPath}`;
      }
      return resolvedPath.length > 0 ? resolvedPath : ".";
    },
    normalize(path) {
      validateString(path, "path");
      if (path.length === 0) {
        return ".";
      }
      const isAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
      const trailingSeparator = path.charCodeAt(path.length - 1) === CHAR_FORWARD_SLASH;
      path = normalizeString(path, !isAbsolute, "/", isPosixPathSeparator);
      if (path.length === 0) {
        if (isAbsolute) {
          return "/";
        }
        return trailingSeparator ? "./" : ".";
      }
      if (trailingSeparator) {
        path += "/";
      }
      return isAbsolute ? `/${path}` : path;
    },
    isAbsolute(path) {
      validateString(path, "path");
      return path.length > 0 && path.charCodeAt(0) === CHAR_FORWARD_SLASH;
    },
    join(...paths) {
      if (paths.length === 0) {
        return ".";
      }
      const path = [];
      for (let i = 0; i < paths.length; ++i) {
        const arg = paths[i];
        validateString(arg, "path");
        if (arg.length > 0) {
          path.push(arg);
        }
      }
      if (path.length === 0) {
        return ".";
      }
      return posix.normalize(path.join("/"));
    },
    relative(from, to) {
      validateString(from, "from");
      validateString(to, "to");
      if (from === to) {
        return "";
      }
      from = posix.resolve(from);
      to = posix.resolve(to);
      if (from === to) {
        return "";
      }
      const fromStart = 1;
      const fromEnd = from.length;
      const fromLen = fromEnd - fromStart;
      const toStart = 1;
      const toLen = to.length - toStart;
      const length = fromLen < toLen ? fromLen : toLen;
      let lastCommonSep = -1;
      let i = 0;
      for (; i < length; i++) {
        const fromCode = from.charCodeAt(fromStart + i);
        if (fromCode !== to.charCodeAt(toStart + i)) {
          break;
        } else if (fromCode === CHAR_FORWARD_SLASH) {
          lastCommonSep = i;
        }
      }
      if (i === length) {
        if (toLen > length) {
          if (to.charCodeAt(toStart + i) === CHAR_FORWARD_SLASH) {
            return to.slice(toStart + i + 1);
          }
          if (i === 0) {
            return to.slice(toStart + i);
          }
        } else if (fromLen > length) {
          if (from.charCodeAt(fromStart + i) === CHAR_FORWARD_SLASH) {
            lastCommonSep = i;
          } else if (i === 0) {
            lastCommonSep = 0;
          }
        }
      }
      let out = "";
      for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
        if (i === fromEnd || from.charCodeAt(i) === CHAR_FORWARD_SLASH) {
          out += out.length === 0 ? ".." : "/..";
        }
      }
      return `${out}${to.slice(toStart + lastCommonSep)}`;
    },
    toNamespacedPath(path) {
      return path;
    },
    dirname(path) {
      validateString(path, "path");
      if (path.length === 0) {
        return ".";
      }
      const hasRoot = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
      let end = -1;
      let matchedSlash = true;
      for (let i = path.length - 1; i >= 1; --i) {
        if (path.charCodeAt(i) === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            end = i;
            break;
          }
        } else {
          matchedSlash = false;
        }
      }
      if (end === -1) {
        return hasRoot ? "/" : ".";
      }
      if (hasRoot && end === 1) {
        return "//";
      }
      return path.slice(0, end);
    },
    basename(path, suffix) {
      if (suffix !== void 0) {
        validateString(suffix, "suffix");
      }
      validateString(path, "path");
      let start2 = 0;
      let end = -1;
      let matchedSlash = true;
      let i;
      if (suffix !== void 0 && suffix.length > 0 && suffix.length <= path.length) {
        if (suffix === path) {
          return "";
        }
        let extIdx = suffix.length - 1;
        let firstNonSlashEnd = -1;
        for (i = path.length - 1; i >= 0; --i) {
          const code = path.charCodeAt(i);
          if (code === CHAR_FORWARD_SLASH) {
            if (!matchedSlash) {
              start2 = i + 1;
              break;
            }
          } else {
            if (firstNonSlashEnd === -1) {
              matchedSlash = false;
              firstNonSlashEnd = i + 1;
            }
            if (extIdx >= 0) {
              if (code === suffix.charCodeAt(extIdx)) {
                if (--extIdx === -1) {
                  end = i;
                }
              } else {
                extIdx = -1;
                end = firstNonSlashEnd;
              }
            }
          }
        }
        if (start2 === end) {
          end = firstNonSlashEnd;
        } else if (end === -1) {
          end = path.length;
        }
        return path.slice(start2, end);
      }
      for (i = path.length - 1; i >= 0; --i) {
        if (path.charCodeAt(i) === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            start2 = i + 1;
            break;
          }
        } else if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
      }
      if (end === -1) {
        return "";
      }
      return path.slice(start2, end);
    },
    extname(path) {
      validateString(path, "path");
      let startDot = -1;
      let startPart = 0;
      let end = -1;
      let matchedSlash = true;
      let preDotState = 0;
      for (let i = path.length - 1; i >= 0; --i) {
        const char = path[i];
        if (char === "/") {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (char === ".") {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
      preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
      preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
      }
      return path.slice(startDot, end);
    },
    format: _format.bind(null, "/"),
    parse(path) {
      validateString(path, "path");
      const ret = { root: "", dir: "", base: "", ext: "", name: "" };
      if (path.length === 0) {
        return ret;
      }
      const isAbsolute = path.charCodeAt(0) === CHAR_FORWARD_SLASH;
      let start2;
      if (isAbsolute) {
        ret.root = "/";
        start2 = 1;
      } else {
        start2 = 0;
      }
      let startDot = -1;
      let startPart = 0;
      let end = -1;
      let matchedSlash = true;
      let i = path.length - 1;
      let preDotState = 0;
      for (; i >= start2; --i) {
        const code = path.charCodeAt(i);
        if (code === CHAR_FORWARD_SLASH) {
          if (!matchedSlash) {
            startPart = i + 1;
            break;
          }
          continue;
        }
        if (end === -1) {
          matchedSlash = false;
          end = i + 1;
        }
        if (code === CHAR_DOT) {
          if (startDot === -1) {
            startDot = i;
          } else if (preDotState !== 1) {
            preDotState = 1;
          }
        } else if (startDot !== -1) {
          preDotState = -1;
        }
      }
      if (end !== -1) {
        const start3 = startPart === 0 && isAbsolute ? 1 : startPart;
        if (startDot === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          ret.base = ret.name = path.slice(start3, end);
        } else {
          ret.name = path.slice(start3, startDot);
          ret.base = path.slice(start3, end);
          ret.ext = path.slice(startDot, end);
        }
      }
      if (startPart > 0) {
        ret.dir = path.slice(0, startPart - 1);
      } else if (isAbsolute) {
        ret.dir = "/";
      }
      return ret;
    },
    sep: "/",
    delimiter: ":",
    win32: null,
    posix: null
  };
  posix.win32 = win32.win32 = win32;
  posix.posix = win32.posix = posix;
  platformIsWin32 ? win32.normalize : posix.normalize;
  platformIsWin32 ? win32.resolve : posix.resolve;
  platformIsWin32 ? win32.relative : posix.relative;
  platformIsWin32 ? win32.dirname : posix.dirname;
  platformIsWin32 ? win32.basename : posix.basename;
  platformIsWin32 ? win32.extname : posix.extname;
  platformIsWin32 ? win32.sep : posix.sep;
  const _schemePattern = /^\w[\w\d+.-]*$/;
  const _singleSlashStart = /^\//;
  const _doubleSlashStart = /^\/\//;
  function _validateUri(ret, _strict) {
    if (!ret.scheme && _strict) {
      throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${ret.authority}", path: "${ret.path}", query: "${ret.query}", fragment: "${ret.fragment}"}`);
    }
    if (ret.scheme && !_schemePattern.test(ret.scheme)) {
      throw new Error("[UriError]: Scheme contains illegal characters.");
    }
    if (ret.path) {
      if (ret.authority) {
        if (!_singleSlashStart.test(ret.path)) {
          throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
        }
      } else {
        if (_doubleSlashStart.test(ret.path)) {
          throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
        }
      }
    }
  }
  function _schemeFix(scheme, _strict) {
    if (!scheme && !_strict) {
      return "file";
    }
    return scheme;
  }
  function _referenceResolution(scheme, path) {
    switch (scheme) {
      case "https":
      case "http":
      case "file":
        if (!path) {
          path = _slash;
        } else if (path[0] !== _slash) {
          path = _slash + path;
        }
        break;
    }
    return path;
  }
  const _empty = "";
  const _slash = "/";
  const _regexp = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
  let URI$2 = class URI2 {
    static isUri(thing) {
      if (thing instanceof URI2) {
        return true;
      }
      if (!thing || typeof thing !== "object") {
        return false;
      }
      return typeof thing.authority === "string" && typeof thing.fragment === "string" && typeof thing.path === "string" && typeof thing.query === "string" && typeof thing.scheme === "string" && typeof thing.fsPath === "string" && typeof thing.with === "function" && typeof thing.toString === "function";
    }
    /**
     * @internal
     */
    constructor(schemeOrData, authority, path, query, fragment, _strict = false) {
      if (typeof schemeOrData === "object") {
        this.scheme = schemeOrData.scheme || _empty;
        this.authority = schemeOrData.authority || _empty;
        this.path = schemeOrData.path || _empty;
        this.query = schemeOrData.query || _empty;
        this.fragment = schemeOrData.fragment || _empty;
      } else {
        this.scheme = _schemeFix(schemeOrData, _strict);
        this.authority = authority || _empty;
        this.path = _referenceResolution(this.scheme, path || _empty);
        this.query = query || _empty;
        this.fragment = fragment || _empty;
        _validateUri(this, _strict);
      }
    }
    // ---- filesystem path -----------------------
    /**
     * Returns a string representing the corresponding file system path of this URI.
     * Will handle UNC paths, normalizes windows drive letters to lower-case, and uses the
     * platform specific path separator.
     *
     * * Will *not* validate the path for invalid characters and semantics.
     * * Will *not* look at the scheme of this URI.
     * * The result shall *not* be used for display purposes but for accessing a file on disk.
     *
     *
     * The *difference* to `URI#path` is the use of the platform specific separator and the handling
     * of UNC paths. See the below sample of a file-uri with an authority (UNC path).
     *
     * ```ts
        const u = URI.parse('file://server/c$/folder/file.txt')
        u.authority === 'server'
        u.path === '/shares/c$/file.txt'
        u.fsPath === '\\server\c$\folder\file.txt'
    ```
     *
     * Using `URI#path` to read a file (using fs-apis) would not be enough because parts of the path,
     * namely the server name, would be missing. Therefore `URI#fsPath` exists - it's sugar to ease working
     * with URIs that represent files on disk (`file` scheme).
     */
    get fsPath() {
      return uriToFsPath(this, false);
    }
    // ---- modify to new -------------------------
    with(change) {
      if (!change) {
        return this;
      }
      let { scheme, authority, path, query, fragment } = change;
      if (scheme === void 0) {
        scheme = this.scheme;
      } else if (scheme === null) {
        scheme = _empty;
      }
      if (authority === void 0) {
        authority = this.authority;
      } else if (authority === null) {
        authority = _empty;
      }
      if (path === void 0) {
        path = this.path;
      } else if (path === null) {
        path = _empty;
      }
      if (query === void 0) {
        query = this.query;
      } else if (query === null) {
        query = _empty;
      }
      if (fragment === void 0) {
        fragment = this.fragment;
      } else if (fragment === null) {
        fragment = _empty;
      }
      if (scheme === this.scheme && authority === this.authority && path === this.path && query === this.query && fragment === this.fragment) {
        return this;
      }
      return new Uri(scheme, authority, path, query, fragment);
    }
    // ---- parse & validate ------------------------
    /**
     * Creates a new URI from a string, e.g. `http://www.example.com/some/path`,
     * `file:///usr/home`, or `scheme:with/path`.
     *
     * @param value A string which represents an URI (see `URI#toString`).
     */
    static parse(value, _strict = false) {
      const match = _regexp.exec(value);
      if (!match) {
        return new Uri(_empty, _empty, _empty, _empty, _empty);
      }
      return new Uri(match[2] || _empty, percentDecode(match[4] || _empty), percentDecode(match[5] || _empty), percentDecode(match[7] || _empty), percentDecode(match[9] || _empty), _strict);
    }
    /**
     * Creates a new URI from a file system path, e.g. `c:\my\files`,
     * `/usr/home`, or `\\server\share\some\path`.
     *
     * The *difference* between `URI#parse` and `URI#file` is that the latter treats the argument
     * as path, not as stringified-uri. E.g. `URI.file(path)` is **not the same as**
     * `URI.parse('file://' + path)` because the path might contain characters that are
     * interpreted (# and ?). See the following sample:
     * ```ts
    const good = URI.file('/coding/c#/project1');
    good.scheme === 'file';
    good.path === '/coding/c#/project1';
    good.fragment === '';
    const bad = URI.parse('file://' + '/coding/c#/project1');
    bad.scheme === 'file';
    bad.path === '/coding/c'; // path is now broken
    bad.fragment === '/project1';
    ```
     *
     * @param path A file system path (see `URI#fsPath`)
     */
    static file(path) {
      let authority = _empty;
      if (isWindows) {
        path = path.replace(/\\/g, _slash);
      }
      if (path[0] === _slash && path[1] === _slash) {
        const idx = path.indexOf(_slash, 2);
        if (idx === -1) {
          authority = path.substring(2);
          path = _slash;
        } else {
          authority = path.substring(2, idx);
          path = path.substring(idx) || _slash;
        }
      }
      return new Uri("file", authority, path, _empty, _empty);
    }
    /**
     * Creates new URI from uri components.
     *
     * Unless `strict` is `true` the scheme is defaults to be `file`. This function performs
     * validation and should be used for untrusted uri components retrieved from storage,
     * user input, command arguments etc
     */
    static from(components, strict) {
      const result = new Uri(components.scheme, components.authority, components.path, components.query, components.fragment, strict);
      return result;
    }
    /**
     * Join a URI path with path fragments and normalizes the resulting path.
     *
     * @param uri The input URI.
     * @param pathFragment The path fragment to add to the URI path.
     * @returns The resulting URI.
     */
    static joinPath(uri, ...pathFragment) {
      if (!uri.path) {
        throw new Error(`[UriError]: cannot call joinPath on URI without path`);
      }
      let newPath;
      if (isWindows && uri.scheme === "file") {
        newPath = URI2.file(win32.join(uriToFsPath(uri, true), ...pathFragment)).path;
      } else {
        newPath = posix.join(uri.path, ...pathFragment);
      }
      return uri.with({ path: newPath });
    }
    // ---- printing/externalize ---------------------------
    /**
     * Creates a string representation for this URI. It's guaranteed that calling
     * `URI.parse` with the result of this function creates an URI which is equal
     * to this URI.
     *
     * * The result shall *not* be used for display purposes but for externalization or transport.
     * * The result will be encoded using the percentage encoding and encoding happens mostly
     * ignore the scheme-specific encoding rules.
     *
     * @param skipEncoding Do not encode the result, default is `false`
     */
    toString(skipEncoding = false) {
      return _asFormatted(this, skipEncoding);
    }
    toJSON() {
      return this;
    }
    static revive(data) {
      if (!data) {
        return data;
      } else if (data instanceof URI2) {
        return data;
      } else {
        const result = new Uri(data);
        result._formatted = data.external ?? null;
        result._fsPath = data._sep === _pathSepMarker ? data.fsPath ?? null : null;
        return result;
      }
    }
  };
  const _pathSepMarker = isWindows ? 1 : void 0;
  class Uri extends URI$2 {
    constructor() {
      super(...arguments);
      this._formatted = null;
      this._fsPath = null;
    }
    get fsPath() {
      if (!this._fsPath) {
        this._fsPath = uriToFsPath(this, false);
      }
      return this._fsPath;
    }
    toString(skipEncoding = false) {
      if (!skipEncoding) {
        if (!this._formatted) {
          this._formatted = _asFormatted(this, false);
        }
        return this._formatted;
      } else {
        return _asFormatted(this, true);
      }
    }
    toJSON() {
      const res = {
        $mid: 1
        /* MarshalledId.Uri */
      };
      if (this._fsPath) {
        res.fsPath = this._fsPath;
        res._sep = _pathSepMarker;
      }
      if (this._formatted) {
        res.external = this._formatted;
      }
      if (this.path) {
        res.path = this.path;
      }
      if (this.scheme) {
        res.scheme = this.scheme;
      }
      if (this.authority) {
        res.authority = this.authority;
      }
      if (this.query) {
        res.query = this.query;
      }
      if (this.fragment) {
        res.fragment = this.fragment;
      }
      return res;
    }
  }
  const encodeTable = {
    [
      58
      /* CharCode.Colon */
    ]: "%3A",
    // gen-delims
    [
      47
      /* CharCode.Slash */
    ]: "%2F",
    [
      63
      /* CharCode.QuestionMark */
    ]: "%3F",
    [
      35
      /* CharCode.Hash */
    ]: "%23",
    [
      91
      /* CharCode.OpenSquareBracket */
    ]: "%5B",
    [
      93
      /* CharCode.CloseSquareBracket */
    ]: "%5D",
    [
      64
      /* CharCode.AtSign */
    ]: "%40",
    [
      33
      /* CharCode.ExclamationMark */
    ]: "%21",
    // sub-delims
    [
      36
      /* CharCode.DollarSign */
    ]: "%24",
    [
      38
      /* CharCode.Ampersand */
    ]: "%26",
    [
      39
      /* CharCode.SingleQuote */
    ]: "%27",
    [
      40
      /* CharCode.OpenParen */
    ]: "%28",
    [
      41
      /* CharCode.CloseParen */
    ]: "%29",
    [
      42
      /* CharCode.Asterisk */
    ]: "%2A",
    [
      43
      /* CharCode.Plus */
    ]: "%2B",
    [
      44
      /* CharCode.Comma */
    ]: "%2C",
    [
      59
      /* CharCode.Semicolon */
    ]: "%3B",
    [
      61
      /* CharCode.Equals */
    ]: "%3D",
    [
      32
      /* CharCode.Space */
    ]: "%20"
  };
  function encodeURIComponentFast(uriComponent, isPath, isAuthority) {
    let res = void 0;
    let nativeEncodePos = -1;
    for (let pos = 0; pos < uriComponent.length; pos++) {
      const code = uriComponent.charCodeAt(pos);
      if (code >= 97 && code <= 122 || code >= 65 && code <= 90 || code >= 48 && code <= 57 || code === 45 || code === 46 || code === 95 || code === 126 || isPath && code === 47 || isAuthority && code === 91 || isAuthority && code === 93 || isAuthority && code === 58) {
        if (nativeEncodePos !== -1) {
          res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
          nativeEncodePos = -1;
        }
        if (res !== void 0) {
          res += uriComponent.charAt(pos);
        }
      } else {
        if (res === void 0) {
          res = uriComponent.substr(0, pos);
        }
        const escaped = encodeTable[code];
        if (escaped !== void 0) {
          if (nativeEncodePos !== -1) {
            res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
            nativeEncodePos = -1;
          }
          res += escaped;
        } else if (nativeEncodePos === -1) {
          nativeEncodePos = pos;
        }
      }
    }
    if (nativeEncodePos !== -1) {
      res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
    }
    return res !== void 0 ? res : uriComponent;
  }
  function encodeURIComponentMinimal(path) {
    let res = void 0;
    for (let pos = 0; pos < path.length; pos++) {
      const code = path.charCodeAt(pos);
      if (code === 35 || code === 63) {
        if (res === void 0) {
          res = path.substr(0, pos);
        }
        res += encodeTable[code];
      } else {
        if (res !== void 0) {
          res += path[pos];
        }
      }
    }
    return res !== void 0 ? res : path;
  }
  function uriToFsPath(uri, keepDriveLetterCasing) {
    let value;
    if (uri.authority && uri.path.length > 1 && uri.scheme === "file") {
      value = `//${uri.authority}${uri.path}`;
    } else if (uri.path.charCodeAt(0) === 47 && (uri.path.charCodeAt(1) >= 65 && uri.path.charCodeAt(1) <= 90 || uri.path.charCodeAt(1) >= 97 && uri.path.charCodeAt(1) <= 122) && uri.path.charCodeAt(2) === 58) {
      if (!keepDriveLetterCasing) {
        value = uri.path[1].toLowerCase() + uri.path.substr(2);
      } else {
        value = uri.path.substr(1);
      }
    } else {
      value = uri.path;
    }
    if (isWindows) {
      value = value.replace(/\//g, "\\");
    }
    return value;
  }
  function _asFormatted(uri, skipEncoding) {
    const encoder = !skipEncoding ? encodeURIComponentFast : encodeURIComponentMinimal;
    let res = "";
    let { scheme, authority, path, query, fragment } = uri;
    if (scheme) {
      res += scheme;
      res += ":";
    }
    if (authority || scheme === "file") {
      res += _slash;
      res += _slash;
    }
    if (authority) {
      let idx = authority.indexOf("@");
      if (idx !== -1) {
        const userinfo = authority.substr(0, idx);
        authority = authority.substr(idx + 1);
        idx = userinfo.lastIndexOf(":");
        if (idx === -1) {
          res += encoder(userinfo, false, false);
        } else {
          res += encoder(userinfo.substr(0, idx), false, false);
          res += ":";
          res += encoder(userinfo.substr(idx + 1), false, true);
        }
        res += "@";
      }
      authority = authority.toLowerCase();
      idx = authority.lastIndexOf(":");
      if (idx === -1) {
        res += encoder(authority, false, true);
      } else {
        res += encoder(authority.substr(0, idx), false, true);
        res += authority.substr(idx);
      }
    }
    if (path) {
      if (path.length >= 3 && path.charCodeAt(0) === 47 && path.charCodeAt(2) === 58) {
        const code = path.charCodeAt(1);
        if (code >= 65 && code <= 90) {
          path = `/${String.fromCharCode(code + 32)}:${path.substr(3)}`;
        }
      } else if (path.length >= 2 && path.charCodeAt(1) === 58) {
        const code = path.charCodeAt(0);
        if (code >= 65 && code <= 90) {
          path = `${String.fromCharCode(code + 32)}:${path.substr(2)}`;
        }
      }
      res += encoder(path, true, false);
    }
    if (query) {
      res += "?";
      res += encoder(query, false, false);
    }
    if (fragment) {
      res += "#";
      res += !skipEncoding ? encodeURIComponentFast(fragment, false, false) : fragment;
    }
    return res;
  }
  function decodeURIComponentGraceful(str) {
    try {
      return decodeURIComponent(str);
    } catch {
      if (str.length > 3) {
        return str.substr(0, 3) + decodeURIComponentGraceful(str.substr(3));
      } else {
        return str;
      }
    }
  }
  const _rEncodedAsHex = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
  function percentDecode(str) {
    if (!str.match(_rEncodedAsHex)) {
      return str;
    }
    return str.replace(_rEncodedAsHex, (match) => decodeURIComponentGraceful(match));
  }
  class Selection extends Range$1 {
    constructor(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn) {
      super(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn);
      this.selectionStartLineNumber = selectionStartLineNumber;
      this.selectionStartColumn = selectionStartColumn;
      this.positionLineNumber = positionLineNumber;
      this.positionColumn = positionColumn;
    }
    /**
     * Transform to a human-readable representation.
     */
    toString() {
      return "[" + this.selectionStartLineNumber + "," + this.selectionStartColumn + " -> " + this.positionLineNumber + "," + this.positionColumn + "]";
    }
    /**
     * Test if equals other selection.
     */
    equalsSelection(other) {
      return Selection.selectionsEqual(this, other);
    }
    /**
     * Test if the two selections are equal.
     */
    static selectionsEqual(a, b) {
      return a.selectionStartLineNumber === b.selectionStartLineNumber && a.selectionStartColumn === b.selectionStartColumn && a.positionLineNumber === b.positionLineNumber && a.positionColumn === b.positionColumn;
    }
    /**
     * Get directions (LTR or RTL).
     */
    getDirection() {
      if (this.selectionStartLineNumber === this.startLineNumber && this.selectionStartColumn === this.startColumn) {
        return 0;
      }
      return 1;
    }
    /**
     * Create a new selection with a different `positionLineNumber` and `positionColumn`.
     */
    setEndPosition(endLineNumber, endColumn) {
      if (this.getDirection() === 0) {
        return new Selection(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
      }
      return new Selection(endLineNumber, endColumn, this.startLineNumber, this.startColumn);
    }
    /**
     * Get the position at `positionLineNumber` and `positionColumn`.
     */
    getPosition() {
      return new Position$1(this.positionLineNumber, this.positionColumn);
    }
    /**
     * Get the position at the start of the selection.
    */
    getSelectionStart() {
      return new Position$1(this.selectionStartLineNumber, this.selectionStartColumn);
    }
    /**
     * Create a new selection with a different `selectionStartLineNumber` and `selectionStartColumn`.
     */
    setStartPosition(startLineNumber, startColumn) {
      if (this.getDirection() === 0) {
        return new Selection(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
      }
      return new Selection(this.endLineNumber, this.endColumn, startLineNumber, startColumn);
    }
    // ----
    /**
     * Create a `Selection` from one or two positions
     */
    static fromPositions(start2, end = start2) {
      return new Selection(start2.lineNumber, start2.column, end.lineNumber, end.column);
    }
    /**
     * Creates a `Selection` from a range, given a direction.
     */
    static fromRange(range, direction) {
      if (direction === 0) {
        return new Selection(range.startLineNumber, range.startColumn, range.endLineNumber, range.endColumn);
      } else {
        return new Selection(range.endLineNumber, range.endColumn, range.startLineNumber, range.startColumn);
      }
    }
    /**
     * Create a `Selection` from an `ISelection`.
     */
    static liftSelection(sel) {
      return new Selection(sel.selectionStartLineNumber, sel.selectionStartColumn, sel.positionLineNumber, sel.positionColumn);
    }
    /**
     * `a` equals `b`.
     */
    static selectionsArrEqual(a, b) {
      if (a && !b || !a && b) {
        return false;
      }
      if (!a && !b) {
        return true;
      }
      if (a.length !== b.length) {
        return false;
      }
      for (let i = 0, len = a.length; i < len; i++) {
        if (!this.selectionsEqual(a[i], b[i])) {
          return false;
        }
      }
      return true;
    }
    /**
     * Test if `obj` is an `ISelection`.
     */
    static isISelection(obj) {
      return obj && typeof obj.selectionStartLineNumber === "number" && typeof obj.selectionStartColumn === "number" && typeof obj.positionLineNumber === "number" && typeof obj.positionColumn === "number";
    }
    /**
     * Create with a direction.
     */
    static createWithDirection(startLineNumber, startColumn, endLineNumber, endColumn, direction) {
      if (direction === 0) {
        return new Selection(startLineNumber, startColumn, endLineNumber, endColumn);
      }
      return new Selection(endLineNumber, endColumn, startLineNumber, startColumn);
    }
  }
  const _codiconFontCharacters = /* @__PURE__ */ Object.create(null);
  function register(id, fontCharacter) {
    if (isString(fontCharacter)) {
      const val = _codiconFontCharacters[fontCharacter];
      if (val === void 0) {
        throw new Error(`${id} references an unknown codicon: ${fontCharacter}`);
      }
      fontCharacter = val;
    }
    _codiconFontCharacters[id] = fontCharacter;
    return { id };
  }
  const codiconsLibrary = {
    add: register("add", 6e4),
    plus: register("plus", 6e4),
    gistNew: register("gist-new", 6e4),
    repoCreate: register("repo-create", 6e4),
    lightbulb: register("lightbulb", 60001),
    lightBulb: register("light-bulb", 60001),
    repo: register("repo", 60002),
    repoDelete: register("repo-delete", 60002),
    gistFork: register("gist-fork", 60003),
    repoForked: register("repo-forked", 60003),
    gitPullRequest: register("git-pull-request", 60004),
    gitPullRequestAbandoned: register("git-pull-request-abandoned", 60004),
    recordKeys: register("record-keys", 60005),
    keyboard: register("keyboard", 60005),
    tag: register("tag", 60006),
    gitPullRequestLabel: register("git-pull-request-label", 60006),
    tagAdd: register("tag-add", 60006),
    tagRemove: register("tag-remove", 60006),
    person: register("person", 60007),
    personFollow: register("person-follow", 60007),
    personOutline: register("person-outline", 60007),
    personFilled: register("person-filled", 60007),
    gitBranch: register("git-branch", 60008),
    gitBranchCreate: register("git-branch-create", 60008),
    gitBranchDelete: register("git-branch-delete", 60008),
    sourceControl: register("source-control", 60008),
    mirror: register("mirror", 60009),
    mirrorPublic: register("mirror-public", 60009),
    star: register("star", 60010),
    starAdd: register("star-add", 60010),
    starDelete: register("star-delete", 60010),
    starEmpty: register("star-empty", 60010),
    comment: register("comment", 60011),
    commentAdd: register("comment-add", 60011),
    alert: register("alert", 60012),
    warning: register("warning", 60012),
    search: register("search", 60013),
    searchSave: register("search-save", 60013),
    logOut: register("log-out", 60014),
    signOut: register("sign-out", 60014),
    logIn: register("log-in", 60015),
    signIn: register("sign-in", 60015),
    eye: register("eye", 60016),
    eyeUnwatch: register("eye-unwatch", 60016),
    eyeWatch: register("eye-watch", 60016),
    circleFilled: register("circle-filled", 60017),
    primitiveDot: register("primitive-dot", 60017),
    closeDirty: register("close-dirty", 60017),
    debugBreakpoint: register("debug-breakpoint", 60017),
    debugBreakpointDisabled: register("debug-breakpoint-disabled", 60017),
    debugHint: register("debug-hint", 60017),
    terminalDecorationSuccess: register("terminal-decoration-success", 60017),
    primitiveSquare: register("primitive-square", 60018),
    edit: register("edit", 60019),
    pencil: register("pencil", 60019),
    info: register("info", 60020),
    issueOpened: register("issue-opened", 60020),
    gistPrivate: register("gist-private", 60021),
    gitForkPrivate: register("git-fork-private", 60021),
    lock: register("lock", 60021),
    mirrorPrivate: register("mirror-private", 60021),
    close: register("close", 60022),
    removeClose: register("remove-close", 60022),
    x: register("x", 60022),
    repoSync: register("repo-sync", 60023),
    sync: register("sync", 60023),
    clone: register("clone", 60024),
    desktopDownload: register("desktop-download", 60024),
    beaker: register("beaker", 60025),
    microscope: register("microscope", 60025),
    vm: register("vm", 60026),
    deviceDesktop: register("device-desktop", 60026),
    file: register("file", 60027),
    fileText: register("file-text", 60027),
    more: register("more", 60028),
    ellipsis: register("ellipsis", 60028),
    kebabHorizontal: register("kebab-horizontal", 60028),
    mailReply: register("mail-reply", 60029),
    reply: register("reply", 60029),
    organization: register("organization", 60030),
    organizationFilled: register("organization-filled", 60030),
    organizationOutline: register("organization-outline", 60030),
    newFile: register("new-file", 60031),
    fileAdd: register("file-add", 60031),
    newFolder: register("new-folder", 60032),
    fileDirectoryCreate: register("file-directory-create", 60032),
    trash: register("trash", 60033),
    trashcan: register("trashcan", 60033),
    history: register("history", 60034),
    clock: register("clock", 60034),
    folder: register("folder", 60035),
    fileDirectory: register("file-directory", 60035),
    symbolFolder: register("symbol-folder", 60035),
    logoGithub: register("logo-github", 60036),
    markGithub: register("mark-github", 60036),
    github: register("github", 60036),
    terminal: register("terminal", 60037),
    console: register("console", 60037),
    repl: register("repl", 60037),
    zap: register("zap", 60038),
    symbolEvent: register("symbol-event", 60038),
    error: register("error", 60039),
    stop: register("stop", 60039),
    variable: register("variable", 60040),
    symbolVariable: register("symbol-variable", 60040),
    array: register("array", 60042),
    symbolArray: register("symbol-array", 60042),
    symbolModule: register("symbol-module", 60043),
    symbolPackage: register("symbol-package", 60043),
    symbolNamespace: register("symbol-namespace", 60043),
    symbolObject: register("symbol-object", 60043),
    symbolMethod: register("symbol-method", 60044),
    symbolFunction: register("symbol-function", 60044),
    symbolConstructor: register("symbol-constructor", 60044),
    symbolBoolean: register("symbol-boolean", 60047),
    symbolNull: register("symbol-null", 60047),
    symbolNumeric: register("symbol-numeric", 60048),
    symbolNumber: register("symbol-number", 60048),
    symbolStructure: register("symbol-structure", 60049),
    symbolStruct: register("symbol-struct", 60049),
    symbolParameter: register("symbol-parameter", 60050),
    symbolTypeParameter: register("symbol-type-parameter", 60050),
    symbolKey: register("symbol-key", 60051),
    symbolText: register("symbol-text", 60051),
    symbolReference: register("symbol-reference", 60052),
    goToFile: register("go-to-file", 60052),
    symbolEnum: register("symbol-enum", 60053),
    symbolValue: register("symbol-value", 60053),
    symbolRuler: register("symbol-ruler", 60054),
    symbolUnit: register("symbol-unit", 60054),
    activateBreakpoints: register("activate-breakpoints", 60055),
    archive: register("archive", 60056),
    arrowBoth: register("arrow-both", 60057),
    arrowDown: register("arrow-down", 60058),
    arrowLeft: register("arrow-left", 60059),
    arrowRight: register("arrow-right", 60060),
    arrowSmallDown: register("arrow-small-down", 60061),
    arrowSmallLeft: register("arrow-small-left", 60062),
    arrowSmallRight: register("arrow-small-right", 60063),
    arrowSmallUp: register("arrow-small-up", 60064),
    arrowUp: register("arrow-up", 60065),
    bell: register("bell", 60066),
    bold: register("bold", 60067),
    book: register("book", 60068),
    bookmark: register("bookmark", 60069),
    debugBreakpointConditionalUnverified: register("debug-breakpoint-conditional-unverified", 60070),
    debugBreakpointConditional: register("debug-breakpoint-conditional", 60071),
    debugBreakpointConditionalDisabled: register("debug-breakpoint-conditional-disabled", 60071),
    debugBreakpointDataUnverified: register("debug-breakpoint-data-unverified", 60072),
    debugBreakpointData: register("debug-breakpoint-data", 60073),
    debugBreakpointDataDisabled: register("debug-breakpoint-data-disabled", 60073),
    debugBreakpointLogUnverified: register("debug-breakpoint-log-unverified", 60074),
    debugBreakpointLog: register("debug-breakpoint-log", 60075),
    debugBreakpointLogDisabled: register("debug-breakpoint-log-disabled", 60075),
    briefcase: register("briefcase", 60076),
    broadcast: register("broadcast", 60077),
    browser: register("browser", 60078),
    bug: register("bug", 60079),
    calendar: register("calendar", 60080),
    caseSensitive: register("case-sensitive", 60081),
    check: register("check", 60082),
    checklist: register("checklist", 60083),
    chevronDown: register("chevron-down", 60084),
    chevronLeft: register("chevron-left", 60085),
    chevronRight: register("chevron-right", 60086),
    chevronUp: register("chevron-up", 60087),
    chromeClose: register("chrome-close", 60088),
    chromeMaximize: register("chrome-maximize", 60089),
    chromeMinimize: register("chrome-minimize", 60090),
    chromeRestore: register("chrome-restore", 60091),
    circleOutline: register("circle-outline", 60092),
    circle: register("circle", 60092),
    debugBreakpointUnverified: register("debug-breakpoint-unverified", 60092),
    terminalDecorationIncomplete: register("terminal-decoration-incomplete", 60092),
    circleSlash: register("circle-slash", 60093),
    circuitBoard: register("circuit-board", 60094),
    clearAll: register("clear-all", 60095),
    clippy: register("clippy", 60096),
    closeAll: register("close-all", 60097),
    cloudDownload: register("cloud-download", 60098),
    cloudUpload: register("cloud-upload", 60099),
    code: register("code", 60100),
    collapseAll: register("collapse-all", 60101),
    colorMode: register("color-mode", 60102),
    commentDiscussion: register("comment-discussion", 60103),
    creditCard: register("credit-card", 60105),
    dash: register("dash", 60108),
    dashboard: register("dashboard", 60109),
    database: register("database", 60110),
    debugContinue: register("debug-continue", 60111),
    debugDisconnect: register("debug-disconnect", 60112),
    debugPause: register("debug-pause", 60113),
    debugRestart: register("debug-restart", 60114),
    debugStart: register("debug-start", 60115),
    debugStepInto: register("debug-step-into", 60116),
    debugStepOut: register("debug-step-out", 60117),
    debugStepOver: register("debug-step-over", 60118),
    debugStop: register("debug-stop", 60119),
    debug: register("debug", 60120),
    deviceCameraVideo: register("device-camera-video", 60121),
    deviceCamera: register("device-camera", 60122),
    deviceMobile: register("device-mobile", 60123),
    diffAdded: register("diff-added", 60124),
    diffIgnored: register("diff-ignored", 60125),
    diffModified: register("diff-modified", 60126),
    diffRemoved: register("diff-removed", 60127),
    diffRenamed: register("diff-renamed", 60128),
    diff: register("diff", 60129),
    diffSidebyside: register("diff-sidebyside", 60129),
    discard: register("discard", 60130),
    editorLayout: register("editor-layout", 60131),
    emptyWindow: register("empty-window", 60132),
    exclude: register("exclude", 60133),
    extensions: register("extensions", 60134),
    eyeClosed: register("eye-closed", 60135),
    fileBinary: register("file-binary", 60136),
    fileCode: register("file-code", 60137),
    fileMedia: register("file-media", 60138),
    filePdf: register("file-pdf", 60139),
    fileSubmodule: register("file-submodule", 60140),
    fileSymlinkDirectory: register("file-symlink-directory", 60141),
    fileSymlinkFile: register("file-symlink-file", 60142),
    fileZip: register("file-zip", 60143),
    files: register("files", 60144),
    filter: register("filter", 60145),
    flame: register("flame", 60146),
    foldDown: register("fold-down", 60147),
    foldUp: register("fold-up", 60148),
    fold: register("fold", 60149),
    folderActive: register("folder-active", 60150),
    folderOpened: register("folder-opened", 60151),
    gear: register("gear", 60152),
    gift: register("gift", 60153),
    gistSecret: register("gist-secret", 60154),
    gist: register("gist", 60155),
    gitCommit: register("git-commit", 60156),
    gitCompare: register("git-compare", 60157),
    compareChanges: register("compare-changes", 60157),
    gitMerge: register("git-merge", 60158),
    githubAction: register("github-action", 60159),
    githubAlt: register("github-alt", 60160),
    globe: register("globe", 60161),
    grabber: register("grabber", 60162),
    graph: register("graph", 60163),
    gripper: register("gripper", 60164),
    heart: register("heart", 60165),
    home: register("home", 60166),
    horizontalRule: register("horizontal-rule", 60167),
    hubot: register("hubot", 60168),
    inbox: register("inbox", 60169),
    issueReopened: register("issue-reopened", 60171),
    issues: register("issues", 60172),
    italic: register("italic", 60173),
    jersey: register("jersey", 60174),
    json: register("json", 60175),
    kebabVertical: register("kebab-vertical", 60176),
    key: register("key", 60177),
    law: register("law", 60178),
    lightbulbAutofix: register("lightbulb-autofix", 60179),
    linkExternal: register("link-external", 60180),
    link: register("link", 60181),
    listOrdered: register("list-ordered", 60182),
    listUnordered: register("list-unordered", 60183),
    liveShare: register("live-share", 60184),
    loading: register("loading", 60185),
    location: register("location", 60186),
    mailRead: register("mail-read", 60187),
    mail: register("mail", 60188),
    markdown: register("markdown", 60189),
    megaphone: register("megaphone", 60190),
    mention: register("mention", 60191),
    milestone: register("milestone", 60192),
    gitPullRequestMilestone: register("git-pull-request-milestone", 60192),
    mortarBoard: register("mortar-board", 60193),
    move: register("move", 60194),
    multipleWindows: register("multiple-windows", 60195),
    mute: register("mute", 60196),
    noNewline: register("no-newline", 60197),
    note: register("note", 60198),
    octoface: register("octoface", 60199),
    openPreview: register("open-preview", 60200),
    package: register("package", 60201),
    paintcan: register("paintcan", 60202),
    pin: register("pin", 60203),
    play: register("play", 60204),
    run: register("run", 60204),
    plug: register("plug", 60205),
    preserveCase: register("preserve-case", 60206),
    preview: register("preview", 60207),
    project: register("project", 60208),
    pulse: register("pulse", 60209),
    question: register("question", 60210),
    quote: register("quote", 60211),
    radioTower: register("radio-tower", 60212),
    reactions: register("reactions", 60213),
    references: register("references", 60214),
    refresh: register("refresh", 60215),
    regex: register("regex", 60216),
    remoteExplorer: register("remote-explorer", 60217),
    remote: register("remote", 60218),
    remove: register("remove", 60219),
    replaceAll: register("replace-all", 60220),
    replace: register("replace", 60221),
    repoClone: register("repo-clone", 60222),
    repoForcePush: register("repo-force-push", 60223),
    repoPull: register("repo-pull", 60224),
    repoPush: register("repo-push", 60225),
    report: register("report", 60226),
    requestChanges: register("request-changes", 60227),
    rocket: register("rocket", 60228),
    rootFolderOpened: register("root-folder-opened", 60229),
    rootFolder: register("root-folder", 60230),
    rss: register("rss", 60231),
    ruby: register("ruby", 60232),
    saveAll: register("save-all", 60233),
    saveAs: register("save-as", 60234),
    save: register("save", 60235),
    screenFull: register("screen-full", 60236),
    screenNormal: register("screen-normal", 60237),
    searchStop: register("search-stop", 60238),
    server: register("server", 60240),
    settingsGear: register("settings-gear", 60241),
    settings: register("settings", 60242),
    shield: register("shield", 60243),
    smiley: register("smiley", 60244),
    sortPrecedence: register("sort-precedence", 60245),
    splitHorizontal: register("split-horizontal", 60246),
    splitVertical: register("split-vertical", 60247),
    squirrel: register("squirrel", 60248),
    starFull: register("star-full", 60249),
    starHalf: register("star-half", 60250),
    symbolClass: register("symbol-class", 60251),
    symbolColor: register("symbol-color", 60252),
    symbolConstant: register("symbol-constant", 60253),
    symbolEnumMember: register("symbol-enum-member", 60254),
    symbolField: register("symbol-field", 60255),
    symbolFile: register("symbol-file", 60256),
    symbolInterface: register("symbol-interface", 60257),
    symbolKeyword: register("symbol-keyword", 60258),
    symbolMisc: register("symbol-misc", 60259),
    symbolOperator: register("symbol-operator", 60260),
    symbolProperty: register("symbol-property", 60261),
    wrench: register("wrench", 60261),
    wrenchSubaction: register("wrench-subaction", 60261),
    symbolSnippet: register("symbol-snippet", 60262),
    tasklist: register("tasklist", 60263),
    telescope: register("telescope", 60264),
    textSize: register("text-size", 60265),
    threeBars: register("three-bars", 60266),
    thumbsdown: register("thumbsdown", 60267),
    thumbsup: register("thumbsup", 60268),
    tools: register("tools", 60269),
    triangleDown: register("triangle-down", 60270),
    triangleLeft: register("triangle-left", 60271),
    triangleRight: register("triangle-right", 60272),
    triangleUp: register("triangle-up", 60273),
    twitter: register("twitter", 60274),
    unfold: register("unfold", 60275),
    unlock: register("unlock", 60276),
    unmute: register("unmute", 60277),
    unverified: register("unverified", 60278),
    verified: register("verified", 60279),
    versions: register("versions", 60280),
    vmActive: register("vm-active", 60281),
    vmOutline: register("vm-outline", 60282),
    vmRunning: register("vm-running", 60283),
    watch: register("watch", 60284),
    whitespace: register("whitespace", 60285),
    wholeWord: register("whole-word", 60286),
    window: register("window", 60287),
    wordWrap: register("word-wrap", 60288),
    zoomIn: register("zoom-in", 60289),
    zoomOut: register("zoom-out", 60290),
    listFilter: register("list-filter", 60291),
    listFlat: register("list-flat", 60292),
    listSelection: register("list-selection", 60293),
    selection: register("selection", 60293),
    listTree: register("list-tree", 60294),
    debugBreakpointFunctionUnverified: register("debug-breakpoint-function-unverified", 60295),
    debugBreakpointFunction: register("debug-breakpoint-function", 60296),
    debugBreakpointFunctionDisabled: register("debug-breakpoint-function-disabled", 60296),
    debugStackframeActive: register("debug-stackframe-active", 60297),
    circleSmallFilled: register("circle-small-filled", 60298),
    debugStackframeDot: register("debug-stackframe-dot", 60298),
    terminalDecorationMark: register("terminal-decoration-mark", 60298),
    debugStackframe: register("debug-stackframe", 60299),
    debugStackframeFocused: register("debug-stackframe-focused", 60299),
    debugBreakpointUnsupported: register("debug-breakpoint-unsupported", 60300),
    symbolString: register("symbol-string", 60301),
    debugReverseContinue: register("debug-reverse-continue", 60302),
    debugStepBack: register("debug-step-back", 60303),
    debugRestartFrame: register("debug-restart-frame", 60304),
    debugAlt: register("debug-alt", 60305),
    callIncoming: register("call-incoming", 60306),
    callOutgoing: register("call-outgoing", 60307),
    menu: register("menu", 60308),
    expandAll: register("expand-all", 60309),
    feedback: register("feedback", 60310),
    gitPullRequestReviewer: register("git-pull-request-reviewer", 60310),
    groupByRefType: register("group-by-ref-type", 60311),
    ungroupByRefType: register("ungroup-by-ref-type", 60312),
    account: register("account", 60313),
    gitPullRequestAssignee: register("git-pull-request-assignee", 60313),
    bellDot: register("bell-dot", 60314),
    debugConsole: register("debug-console", 60315),
    library: register("library", 60316),
    output: register("output", 60317),
    runAll: register("run-all", 60318),
    syncIgnored: register("sync-ignored", 60319),
    pinned: register("pinned", 60320),
    githubInverted: register("github-inverted", 60321),
    serverProcess: register("server-process", 60322),
    serverEnvironment: register("server-environment", 60323),
    pass: register("pass", 60324),
    issueClosed: register("issue-closed", 60324),
    stopCircle: register("stop-circle", 60325),
    playCircle: register("play-circle", 60326),
    record: register("record", 60327),
    debugAltSmall: register("debug-alt-small", 60328),
    vmConnect: register("vm-connect", 60329),
    cloud: register("cloud", 60330),
    merge: register("merge", 60331),
    export: register("export", 60332),
    graphLeft: register("graph-left", 60333),
    magnet: register("magnet", 60334),
    notebook: register("notebook", 60335),
    redo: register("redo", 60336),
    checkAll: register("check-all", 60337),
    pinnedDirty: register("pinned-dirty", 60338),
    passFilled: register("pass-filled", 60339),
    circleLargeFilled: register("circle-large-filled", 60340),
    circleLarge: register("circle-large", 60341),
    circleLargeOutline: register("circle-large-outline", 60341),
    combine: register("combine", 60342),
    gather: register("gather", 60342),
    table: register("table", 60343),
    variableGroup: register("variable-group", 60344),
    typeHierarchy: register("type-hierarchy", 60345),
    typeHierarchySub: register("type-hierarchy-sub", 60346),
    typeHierarchySuper: register("type-hierarchy-super", 60347),
    gitPullRequestCreate: register("git-pull-request-create", 60348),
    runAbove: register("run-above", 60349),
    runBelow: register("run-below", 60350),
    notebookTemplate: register("notebook-template", 60351),
    debugRerun: register("debug-rerun", 60352),
    workspaceTrusted: register("workspace-trusted", 60353),
    workspaceUntrusted: register("workspace-untrusted", 60354),
    workspaceUnknown: register("workspace-unknown", 60355),
    terminalCmd: register("terminal-cmd", 60356),
    terminalDebian: register("terminal-debian", 60357),
    terminalLinux: register("terminal-linux", 60358),
    terminalPowershell: register("terminal-powershell", 60359),
    terminalTmux: register("terminal-tmux", 60360),
    terminalUbuntu: register("terminal-ubuntu", 60361),
    terminalBash: register("terminal-bash", 60362),
    arrowSwap: register("arrow-swap", 60363),
    copy: register("copy", 60364),
    personAdd: register("person-add", 60365),
    filterFilled: register("filter-filled", 60366),
    wand: register("wand", 60367),
    debugLineByLine: register("debug-line-by-line", 60368),
    inspect: register("inspect", 60369),
    layers: register("layers", 60370),
    layersDot: register("layers-dot", 60371),
    layersActive: register("layers-active", 60372),
    compass: register("compass", 60373),
    compassDot: register("compass-dot", 60374),
    compassActive: register("compass-active", 60375),
    azure: register("azure", 60376),
    issueDraft: register("issue-draft", 60377),
    gitPullRequestClosed: register("git-pull-request-closed", 60378),
    gitPullRequestDraft: register("git-pull-request-draft", 60379),
    debugAll: register("debug-all", 60380),
    debugCoverage: register("debug-coverage", 60381),
    runErrors: register("run-errors", 60382),
    folderLibrary: register("folder-library", 60383),
    debugContinueSmall: register("debug-continue-small", 60384),
    beakerStop: register("beaker-stop", 60385),
    graphLine: register("graph-line", 60386),
    graphScatter: register("graph-scatter", 60387),
    pieChart: register("pie-chart", 60388),
    bracket: register("bracket", 60175),
    bracketDot: register("bracket-dot", 60389),
    bracketError: register("bracket-error", 60390),
    lockSmall: register("lock-small", 60391),
    azureDevops: register("azure-devops", 60392),
    verifiedFilled: register("verified-filled", 60393),
    newline: register("newline", 60394),
    layout: register("layout", 60395),
    layoutActivitybarLeft: register("layout-activitybar-left", 60396),
    layoutActivitybarRight: register("layout-activitybar-right", 60397),
    layoutPanelLeft: register("layout-panel-left", 60398),
    layoutPanelCenter: register("layout-panel-center", 60399),
    layoutPanelJustify: register("layout-panel-justify", 60400),
    layoutPanelRight: register("layout-panel-right", 60401),
    layoutPanel: register("layout-panel", 60402),
    layoutSidebarLeft: register("layout-sidebar-left", 60403),
    layoutSidebarRight: register("layout-sidebar-right", 60404),
    layoutStatusbar: register("layout-statusbar", 60405),
    layoutMenubar: register("layout-menubar", 60406),
    layoutCentered: register("layout-centered", 60407),
    target: register("target", 60408),
    indent: register("indent", 60409),
    recordSmall: register("record-small", 60410),
    errorSmall: register("error-small", 60411),
    terminalDecorationError: register("terminal-decoration-error", 60411),
    arrowCircleDown: register("arrow-circle-down", 60412),
    arrowCircleLeft: register("arrow-circle-left", 60413),
    arrowCircleRight: register("arrow-circle-right", 60414),
    arrowCircleUp: register("arrow-circle-up", 60415),
    layoutSidebarRightOff: register("layout-sidebar-right-off", 60416),
    layoutPanelOff: register("layout-panel-off", 60417),
    layoutSidebarLeftOff: register("layout-sidebar-left-off", 60418),
    blank: register("blank", 60419),
    heartFilled: register("heart-filled", 60420),
    map: register("map", 60421),
    mapHorizontal: register("map-horizontal", 60421),
    foldHorizontal: register("fold-horizontal", 60421),
    mapFilled: register("map-filled", 60422),
    mapHorizontalFilled: register("map-horizontal-filled", 60422),
    foldHorizontalFilled: register("fold-horizontal-filled", 60422),
    circleSmall: register("circle-small", 60423),
    bellSlash: register("bell-slash", 60424),
    bellSlashDot: register("bell-slash-dot", 60425),
    commentUnresolved: register("comment-unresolved", 60426),
    gitPullRequestGoToChanges: register("git-pull-request-go-to-changes", 60427),
    gitPullRequestNewChanges: register("git-pull-request-new-changes", 60428),
    searchFuzzy: register("search-fuzzy", 60429),
    commentDraft: register("comment-draft", 60430),
    send: register("send", 60431),
    sparkle: register("sparkle", 60432),
    insert: register("insert", 60433),
    mic: register("mic", 60434),
    thumbsdownFilled: register("thumbsdown-filled", 60435),
    thumbsupFilled: register("thumbsup-filled", 60436),
    coffee: register("coffee", 60437),
    snake: register("snake", 60438),
    game: register("game", 60439),
    vr: register("vr", 60440),
    chip: register("chip", 60441),
    piano: register("piano", 60442),
    music: register("music", 60443),
    micFilled: register("mic-filled", 60444),
    repoFetch: register("repo-fetch", 60445),
    copilot: register("copilot", 60446),
    lightbulbSparkle: register("lightbulb-sparkle", 60447),
    robot: register("robot", 60448),
    sparkleFilled: register("sparkle-filled", 60449),
    diffSingle: register("diff-single", 60450),
    diffMultiple: register("diff-multiple", 60451),
    surroundWith: register("surround-with", 60452),
    share: register("share", 60453),
    gitStash: register("git-stash", 60454),
    gitStashApply: register("git-stash-apply", 60455),
    gitStashPop: register("git-stash-pop", 60456),
    vscode: register("vscode", 60457),
    vscodeInsiders: register("vscode-insiders", 60458),
    codeOss: register("code-oss", 60459),
    runCoverage: register("run-coverage", 60460),
    runAllCoverage: register("run-all-coverage", 60461),
    coverage: register("coverage", 60462),
    githubProject: register("github-project", 60463),
    mapVertical: register("map-vertical", 60464),
    foldVertical: register("fold-vertical", 60464),
    mapVerticalFilled: register("map-vertical-filled", 60465),
    foldVerticalFilled: register("fold-vertical-filled", 60465),
    goToSearch: register("go-to-search", 60466),
    percentage: register("percentage", 60467),
    sortPercentage: register("sort-percentage", 60467),
    attach: register("attach", 60468),
    goToEditingSession: register("go-to-editing-session", 60469),
    editSession: register("edit-session", 60470),
    codeReview: register("code-review", 60471),
    copilotWarning: register("copilot-warning", 60472),
    python: register("python", 60473),
    copilotLarge: register("copilot-large", 60474),
    copilotWarningLarge: register("copilot-warning-large", 60475),
    keyboardTab: register("keyboard-tab", 60476),
    copilotBlocked: register("copilot-blocked", 60477),
    copilotNotConnected: register("copilot-not-connected", 60478),
    flag: register("flag", 60479),
    lightbulbEmpty: register("lightbulb-empty", 60480),
    symbolMethodArrow: register("symbol-method-arrow", 60481),
    copilotUnavailable: register("copilot-unavailable", 60482),
    repoPinned: register("repo-pinned", 60483),
    keyboardTabAbove: register("keyboard-tab-above", 60484),
    keyboardTabBelow: register("keyboard-tab-below", 60485),
    gitPullRequestDone: register("git-pull-request-done", 60486),
    mcp: register("mcp", 60487),
    extensionsLarge: register("extensions-large", 60488),
    layoutPanelDock: register("layout-panel-dock", 60489),
    layoutSidebarLeftDock: register("layout-sidebar-left-dock", 60490),
    layoutSidebarRightDock: register("layout-sidebar-right-dock", 60491),
    copilotInProgress: register("copilot-in-progress", 60492),
    copilotError: register("copilot-error", 60493),
    copilotSuccess: register("copilot-success", 60494),
    chatSparkle: register("chat-sparkle", 60495),
    searchSparkle: register("search-sparkle", 60496),
    editSparkle: register("edit-sparkle", 60497),
    copilotSnooze: register("copilot-snooze", 60498),
    sendToRemoteAgent: register("send-to-remote-agent", 60499),
    commentDiscussionSparkle: register("comment-discussion-sparkle", 60500),
    chatSparkleWarning: register("chat-sparkle-warning", 60501),
    chatSparkleError: register("chat-sparkle-error", 60502),
    collection: register("collection", 60503),
    newCollection: register("new-collection", 60504),
    thinking: register("thinking", 60505)
  };
  const codiconsDerived = {
    dialogError: register("dialog-error", "error"),
    dialogWarning: register("dialog-warning", "warning"),
    dialogInfo: register("dialog-info", "info"),
    dialogClose: register("dialog-close", "close"),
    treeItemExpanded: register("tree-item-expanded", "chevron-down"),
    // collapsed is done with rotation
    treeFilterOnTypeOn: register("tree-filter-on-type-on", "list-filter"),
    treeFilterOnTypeOff: register("tree-filter-on-type-off", "list-selection"),
    treeFilterClear: register("tree-filter-clear", "close"),
    treeItemLoading: register("tree-item-loading", "loading"),
    menuSelection: register("menu-selection", "check"),
    menuSubmenu: register("menu-submenu", "chevron-right"),
    menuBarMore: register("menubar-more", "more"),
    scrollbarButtonLeft: register("scrollbar-button-left", "triangle-left"),
    scrollbarButtonRight: register("scrollbar-button-right", "triangle-right"),
    scrollbarButtonUp: register("scrollbar-button-up", "triangle-up"),
    scrollbarButtonDown: register("scrollbar-button-down", "triangle-down"),
    toolBarMore: register("toolbar-more", "more"),
    quickInputBack: register("quick-input-back", "arrow-left"),
    dropDownButton: register("drop-down-button", 60084),
    symbolCustomColor: register("symbol-customcolor", 60252),
    exportIcon: register("export", 60332),
    workspaceUnspecified: register("workspace-unspecified", 60355),
    newLine: register("newline", 60394),
    thumbsDownFilled: register("thumbsdown-filled", 60435),
    thumbsUpFilled: register("thumbsup-filled", 60436),
    gitFetch: register("git-fetch", 60445),
    lightbulbSparkleAutofix: register("lightbulb-sparkle-autofix", 60447),
    debugBreakpointPending: register("debug-breakpoint-pending", 60377)
  };
  const Codicon = {
    ...codiconsLibrary,
    ...codiconsDerived
  };
  class TokenizationRegistry {
    constructor() {
      this._tokenizationSupports = /* @__PURE__ */ new Map();
      this._factories = /* @__PURE__ */ new Map();
      this._onDidChange = new Emitter();
      this.onDidChange = this._onDidChange.event;
      this._colorMap = null;
    }
    handleChange(languageIds) {
      this._onDidChange.fire({
        changedLanguages: languageIds,
        changedColorMap: false
      });
    }
    register(languageId, support) {
      this._tokenizationSupports.set(languageId, support);
      this.handleChange([languageId]);
      return toDisposable(() => {
        if (this._tokenizationSupports.get(languageId) !== support) {
          return;
        }
        this._tokenizationSupports.delete(languageId);
        this.handleChange([languageId]);
      });
    }
    get(languageId) {
      return this._tokenizationSupports.get(languageId) || null;
    }
    registerFactory(languageId, factory) {
      this._factories.get(languageId)?.dispose();
      const myData = new TokenizationSupportFactoryData(this, languageId, factory);
      this._factories.set(languageId, myData);
      return toDisposable(() => {
        const v = this._factories.get(languageId);
        if (!v || v !== myData) {
          return;
        }
        this._factories.delete(languageId);
        v.dispose();
      });
    }
    async getOrCreate(languageId) {
      const tokenizationSupport = this.get(languageId);
      if (tokenizationSupport) {
        return tokenizationSupport;
      }
      const factory = this._factories.get(languageId);
      if (!factory || factory.isResolved) {
        return null;
      }
      await factory.resolve();
      return this.get(languageId);
    }
    isResolved(languageId) {
      const tokenizationSupport = this.get(languageId);
      if (tokenizationSupport) {
        return true;
      }
      const factory = this._factories.get(languageId);
      if (!factory || factory.isResolved) {
        return true;
      }
      return false;
    }
    setColorMap(colorMap) {
      this._colorMap = colorMap;
      this._onDidChange.fire({
        changedLanguages: Array.from(this._tokenizationSupports.keys()),
        changedColorMap: true
      });
    }
    getColorMap() {
      return this._colorMap;
    }
    getDefaultBackground() {
      if (this._colorMap && this._colorMap.length > 2) {
        return this._colorMap[
          2
          /* ColorId.DefaultBackground */
        ];
      }
      return null;
    }
  }
  class TokenizationSupportFactoryData extends Disposable {
    get isResolved() {
      return this._isResolved;
    }
    constructor(_registry, _languageId, _factory) {
      super();
      this._registry = _registry;
      this._languageId = _languageId;
      this._factory = _factory;
      this._isDisposed = false;
      this._resolvePromise = null;
      this._isResolved = false;
    }
    dispose() {
      this._isDisposed = true;
      super.dispose();
    }
    async resolve() {
      if (!this._resolvePromise) {
        this._resolvePromise = this._create();
      }
      return this._resolvePromise;
    }
    async _create() {
      const value = await this._factory.tokenizationSupport;
      this._isResolved = true;
      if (value && !this._isDisposed) {
        this._register(this._registry.register(this._languageId, value));
      }
    }
  }
  class Token {
    constructor(offset, type, language) {
      this.offset = offset;
      this.type = type;
      this.language = language;
      this._tokenBrand = void 0;
    }
    toString() {
      return "(" + this.offset + ", " + this.type + ")";
    }
  }
  var HoverVerbosityAction$1;
  (function(HoverVerbosityAction2) {
    HoverVerbosityAction2[HoverVerbosityAction2["Increase"] = 0] = "Increase";
    HoverVerbosityAction2[HoverVerbosityAction2["Decrease"] = 1] = "Decrease";
  })(HoverVerbosityAction$1 || (HoverVerbosityAction$1 = {}));
  var CompletionItemKinds;
  (function(CompletionItemKinds2) {
    const byKind = /* @__PURE__ */ new Map();
    byKind.set(0, Codicon.symbolMethod);
    byKind.set(1, Codicon.symbolFunction);
    byKind.set(2, Codicon.symbolConstructor);
    byKind.set(3, Codicon.symbolField);
    byKind.set(4, Codicon.symbolVariable);
    byKind.set(5, Codicon.symbolClass);
    byKind.set(6, Codicon.symbolStruct);
    byKind.set(7, Codicon.symbolInterface);
    byKind.set(8, Codicon.symbolModule);
    byKind.set(9, Codicon.symbolProperty);
    byKind.set(10, Codicon.symbolEvent);
    byKind.set(11, Codicon.symbolOperator);
    byKind.set(12, Codicon.symbolUnit);
    byKind.set(13, Codicon.symbolValue);
    byKind.set(15, Codicon.symbolEnum);
    byKind.set(14, Codicon.symbolConstant);
    byKind.set(15, Codicon.symbolEnum);
    byKind.set(16, Codicon.symbolEnumMember);
    byKind.set(17, Codicon.symbolKeyword);
    byKind.set(28, Codicon.symbolSnippet);
    byKind.set(18, Codicon.symbolText);
    byKind.set(19, Codicon.symbolColor);
    byKind.set(20, Codicon.symbolFile);
    byKind.set(21, Codicon.symbolReference);
    byKind.set(22, Codicon.symbolCustomColor);
    byKind.set(23, Codicon.symbolFolder);
    byKind.set(24, Codicon.symbolTypeParameter);
    byKind.set(25, Codicon.account);
    byKind.set(26, Codicon.issues);
    byKind.set(27, Codicon.tools);
    function toIcon(kind) {
      let codicon = byKind.get(kind);
      if (!codicon) {
        console.info("No codicon found for CompletionItemKind " + kind);
        codicon = Codicon.symbolProperty;
      }
      return codicon;
    }
    CompletionItemKinds2.toIcon = toIcon;
    function toLabel(kind) {
      switch (kind) {
        case 0:
          return localize(724, "Method");
        case 1:
          return localize(725, "Function");
        case 2:
          return localize(726, "Constructor");
        case 3:
          return localize(727, "Field");
        case 4:
          return localize(728, "Variable");
        case 5:
          return localize(729, "Class");
        case 6:
          return localize(730, "Struct");
        case 7:
          return localize(731, "Interface");
        case 8:
          return localize(732, "Module");
        case 9:
          return localize(733, "Property");
        case 10:
          return localize(734, "Event");
        case 11:
          return localize(735, "Operator");
        case 12:
          return localize(736, "Unit");
        case 13:
          return localize(737, "Value");
        case 14:
          return localize(738, "Constant");
        case 15:
          return localize(739, "Enum");
        case 16:
          return localize(740, "Enum Member");
        case 17:
          return localize(741, "Keyword");
        case 18:
          return localize(742, "Text");
        case 19:
          return localize(743, "Color");
        case 20:
          return localize(744, "File");
        case 21:
          return localize(745, "Reference");
        case 22:
          return localize(746, "Custom Color");
        case 23:
          return localize(747, "Folder");
        case 24:
          return localize(748, "Type Parameter");
        case 25:
          return localize(749, "User");
        case 26:
          return localize(750, "Issue");
        case 27:
          return localize(751, "Tool");
        case 28:
          return localize(752, "Snippet");
        default:
          return "";
      }
    }
    CompletionItemKinds2.toLabel = toLabel;
    const data = /* @__PURE__ */ new Map();
    data.set(
      "method",
      0
      /* CompletionItemKind.Method */
    );
    data.set(
      "function",
      1
      /* CompletionItemKind.Function */
    );
    data.set(
      "constructor",
      2
      /* CompletionItemKind.Constructor */
    );
    data.set(
      "field",
      3
      /* CompletionItemKind.Field */
    );
    data.set(
      "variable",
      4
      /* CompletionItemKind.Variable */
    );
    data.set(
      "class",
      5
      /* CompletionItemKind.Class */
    );
    data.set(
      "struct",
      6
      /* CompletionItemKind.Struct */
    );
    data.set(
      "interface",
      7
      /* CompletionItemKind.Interface */
    );
    data.set(
      "module",
      8
      /* CompletionItemKind.Module */
    );
    data.set(
      "property",
      9
      /* CompletionItemKind.Property */
    );
    data.set(
      "event",
      10
      /* CompletionItemKind.Event */
    );
    data.set(
      "operator",
      11
      /* CompletionItemKind.Operator */
    );
    data.set(
      "unit",
      12
      /* CompletionItemKind.Unit */
    );
    data.set(
      "value",
      13
      /* CompletionItemKind.Value */
    );
    data.set(
      "constant",
      14
      /* CompletionItemKind.Constant */
    );
    data.set(
      "enum",
      15
      /* CompletionItemKind.Enum */
    );
    data.set(
      "enum-member",
      16
      /* CompletionItemKind.EnumMember */
    );
    data.set(
      "enumMember",
      16
      /* CompletionItemKind.EnumMember */
    );
    data.set(
      "keyword",
      17
      /* CompletionItemKind.Keyword */
    );
    data.set(
      "snippet",
      28
      /* CompletionItemKind.Snippet */
    );
    data.set(
      "text",
      18
      /* CompletionItemKind.Text */
    );
    data.set(
      "color",
      19
      /* CompletionItemKind.Color */
    );
    data.set(
      "file",
      20
      /* CompletionItemKind.File */
    );
    data.set(
      "reference",
      21
      /* CompletionItemKind.Reference */
    );
    data.set(
      "customcolor",
      22
      /* CompletionItemKind.Customcolor */
    );
    data.set(
      "folder",
      23
      /* CompletionItemKind.Folder */
    );
    data.set(
      "type-parameter",
      24
      /* CompletionItemKind.TypeParameter */
    );
    data.set(
      "typeParameter",
      24
      /* CompletionItemKind.TypeParameter */
    );
    data.set(
      "account",
      25
      /* CompletionItemKind.User */
    );
    data.set(
      "issue",
      26
      /* CompletionItemKind.Issue */
    );
    data.set(
      "tool",
      27
      /* CompletionItemKind.Tool */
    );
    function fromString(value, strict) {
      let res = data.get(value);
      if (typeof res === "undefined" && !strict) {
        res = 9;
      }
      return res;
    }
    CompletionItemKinds2.fromString = fromString;
  })(CompletionItemKinds || (CompletionItemKinds = {}));
  var InlineCompletionTriggerKind$2;
  (function(InlineCompletionTriggerKind2) {
    InlineCompletionTriggerKind2[InlineCompletionTriggerKind2["Automatic"] = 0] = "Automatic";
    InlineCompletionTriggerKind2[InlineCompletionTriggerKind2["Explicit"] = 1] = "Explicit";
  })(InlineCompletionTriggerKind$2 || (InlineCompletionTriggerKind$2 = {}));
  var InlineCompletionDisplayLocationKind$1;
  (function(InlineCompletionDisplayLocationKind2) {
    InlineCompletionDisplayLocationKind2[InlineCompletionDisplayLocationKind2["Code"] = 1] = "Code";
    InlineCompletionDisplayLocationKind2[InlineCompletionDisplayLocationKind2["Label"] = 2] = "Label";
  })(InlineCompletionDisplayLocationKind$1 || (InlineCompletionDisplayLocationKind$1 = {}));
  var InlineCompletionEndOfLifeReasonKind$1;
  (function(InlineCompletionEndOfLifeReasonKind2) {
    InlineCompletionEndOfLifeReasonKind2[InlineCompletionEndOfLifeReasonKind2["Accepted"] = 0] = "Accepted";
    InlineCompletionEndOfLifeReasonKind2[InlineCompletionEndOfLifeReasonKind2["Rejected"] = 1] = "Rejected";
    InlineCompletionEndOfLifeReasonKind2[InlineCompletionEndOfLifeReasonKind2["Ignored"] = 2] = "Ignored";
  })(InlineCompletionEndOfLifeReasonKind$1 || (InlineCompletionEndOfLifeReasonKind$1 = {}));
  var DocumentPasteTriggerKind;
  (function(DocumentPasteTriggerKind2) {
    DocumentPasteTriggerKind2[DocumentPasteTriggerKind2["Automatic"] = 0] = "Automatic";
    DocumentPasteTriggerKind2[DocumentPasteTriggerKind2["PasteAs"] = 1] = "PasteAs";
  })(DocumentPasteTriggerKind || (DocumentPasteTriggerKind = {}));
  var SignatureHelpTriggerKind$1;
  (function(SignatureHelpTriggerKind2) {
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["Invoke"] = 1] = "Invoke";
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["TriggerCharacter"] = 2] = "TriggerCharacter";
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["ContentChange"] = 3] = "ContentChange";
  })(SignatureHelpTriggerKind$1 || (SignatureHelpTriggerKind$1 = {}));
  var DocumentHighlightKind$2;
  (function(DocumentHighlightKind2) {
    DocumentHighlightKind2[DocumentHighlightKind2["Text"] = 0] = "Text";
    DocumentHighlightKind2[DocumentHighlightKind2["Read"] = 1] = "Read";
    DocumentHighlightKind2[DocumentHighlightKind2["Write"] = 2] = "Write";
  })(DocumentHighlightKind$2 || (DocumentHighlightKind$2 = {}));
  ({
    [
      17
      /* SymbolKind.Array */
    ]: localize(753, "array"),
    [
      16
      /* SymbolKind.Boolean */
    ]: localize(754, "boolean"),
    [
      4
      /* SymbolKind.Class */
    ]: localize(755, "class"),
    [
      13
      /* SymbolKind.Constant */
    ]: localize(756, "constant"),
    [
      8
      /* SymbolKind.Constructor */
    ]: localize(757, "constructor"),
    [
      9
      /* SymbolKind.Enum */
    ]: localize(758, "enumeration"),
    [
      21
      /* SymbolKind.EnumMember */
    ]: localize(759, "enumeration member"),
    [
      23
      /* SymbolKind.Event */
    ]: localize(760, "event"),
    [
      7
      /* SymbolKind.Field */
    ]: localize(761, "field"),
    [
      0
      /* SymbolKind.File */
    ]: localize(762, "file"),
    [
      11
      /* SymbolKind.Function */
    ]: localize(763, "function"),
    [
      10
      /* SymbolKind.Interface */
    ]: localize(764, "interface"),
    [
      19
      /* SymbolKind.Key */
    ]: localize(765, "key"),
    [
      5
      /* SymbolKind.Method */
    ]: localize(766, "method"),
    [
      1
      /* SymbolKind.Module */
    ]: localize(767, "module"),
    [
      2
      /* SymbolKind.Namespace */
    ]: localize(768, "namespace"),
    [
      20
      /* SymbolKind.Null */
    ]: localize(769, "null"),
    [
      15
      /* SymbolKind.Number */
    ]: localize(770, "number"),
    [
      18
      /* SymbolKind.Object */
    ]: localize(771, "object"),
    [
      24
      /* SymbolKind.Operator */
    ]: localize(772, "operator"),
    [
      3
      /* SymbolKind.Package */
    ]: localize(773, "package"),
    [
      6
      /* SymbolKind.Property */
    ]: localize(774, "property"),
    [
      14
      /* SymbolKind.String */
    ]: localize(775, "string"),
    [
      22
      /* SymbolKind.Struct */
    ]: localize(776, "struct"),
    [
      25
      /* SymbolKind.TypeParameter */
    ]: localize(777, "type parameter"),
    [
      12
      /* SymbolKind.Variable */
    ]: localize(778, "variable")
  });
  var SymbolKinds;
  (function(SymbolKinds2) {
    const byKind = /* @__PURE__ */ new Map();
    byKind.set(0, Codicon.symbolFile);
    byKind.set(1, Codicon.symbolModule);
    byKind.set(2, Codicon.symbolNamespace);
    byKind.set(3, Codicon.symbolPackage);
    byKind.set(4, Codicon.symbolClass);
    byKind.set(5, Codicon.symbolMethod);
    byKind.set(6, Codicon.symbolProperty);
    byKind.set(7, Codicon.symbolField);
    byKind.set(8, Codicon.symbolConstructor);
    byKind.set(9, Codicon.symbolEnum);
    byKind.set(10, Codicon.symbolInterface);
    byKind.set(11, Codicon.symbolFunction);
    byKind.set(12, Codicon.symbolVariable);
    byKind.set(13, Codicon.symbolConstant);
    byKind.set(14, Codicon.symbolString);
    byKind.set(15, Codicon.symbolNumber);
    byKind.set(16, Codicon.symbolBoolean);
    byKind.set(17, Codicon.symbolArray);
    byKind.set(18, Codicon.symbolObject);
    byKind.set(19, Codicon.symbolKey);
    byKind.set(20, Codicon.symbolNull);
    byKind.set(21, Codicon.symbolEnumMember);
    byKind.set(22, Codicon.symbolStruct);
    byKind.set(23, Codicon.symbolEvent);
    byKind.set(24, Codicon.symbolOperator);
    byKind.set(25, Codicon.symbolTypeParameter);
    function toIcon(kind) {
      let icon = byKind.get(kind);
      if (!icon) {
        console.info("No codicon found for SymbolKind " + kind);
        icon = Codicon.symbolProperty;
      }
      return icon;
    }
    SymbolKinds2.toIcon = toIcon;
    const byCompletionKind = /* @__PURE__ */ new Map();
    byCompletionKind.set(
      0,
      20
      /* CompletionItemKind.File */
    );
    byCompletionKind.set(
      1,
      8
      /* CompletionItemKind.Module */
    );
    byCompletionKind.set(
      2,
      8
      /* CompletionItemKind.Module */
    );
    byCompletionKind.set(
      3,
      8
      /* CompletionItemKind.Module */
    );
    byCompletionKind.set(
      4,
      5
      /* CompletionItemKind.Class */
    );
    byCompletionKind.set(
      5,
      0
      /* CompletionItemKind.Method */
    );
    byCompletionKind.set(
      6,
      9
      /* CompletionItemKind.Property */
    );
    byCompletionKind.set(
      7,
      3
      /* CompletionItemKind.Field */
    );
    byCompletionKind.set(
      8,
      2
      /* CompletionItemKind.Constructor */
    );
    byCompletionKind.set(
      9,
      15
      /* CompletionItemKind.Enum */
    );
    byCompletionKind.set(
      10,
      7
      /* CompletionItemKind.Interface */
    );
    byCompletionKind.set(
      11,
      1
      /* CompletionItemKind.Function */
    );
    byCompletionKind.set(
      12,
      4
      /* CompletionItemKind.Variable */
    );
    byCompletionKind.set(
      13,
      14
      /* CompletionItemKind.Constant */
    );
    byCompletionKind.set(
      14,
      18
      /* CompletionItemKind.Text */
    );
    byCompletionKind.set(
      15,
      13
      /* CompletionItemKind.Value */
    );
    byCompletionKind.set(
      16,
      13
      /* CompletionItemKind.Value */
    );
    byCompletionKind.set(
      17,
      13
      /* CompletionItemKind.Value */
    );
    byCompletionKind.set(
      18,
      13
      /* CompletionItemKind.Value */
    );
    byCompletionKind.set(
      19,
      17
      /* CompletionItemKind.Keyword */
    );
    byCompletionKind.set(
      20,
      13
      /* CompletionItemKind.Value */
    );
    byCompletionKind.set(
      21,
      16
      /* CompletionItemKind.EnumMember */
    );
    byCompletionKind.set(
      22,
      6
      /* CompletionItemKind.Struct */
    );
    byCompletionKind.set(
      23,
      10
      /* CompletionItemKind.Event */
    );
    byCompletionKind.set(
      24,
      11
      /* CompletionItemKind.Operator */
    );
    byCompletionKind.set(
      25,
      24
      /* CompletionItemKind.TypeParameter */
    );
    function toCompletionKind(kind) {
      let completionKind = byCompletionKind.get(kind);
      if (completionKind === void 0) {
        console.info("No completion kind found for SymbolKind " + kind);
        completionKind = 20;
      }
      return completionKind;
    }
    SymbolKinds2.toCompletionKind = toCompletionKind;
  })(SymbolKinds || (SymbolKinds = {}));
  let FoldingRangeKind$1 = (_b = class {
    /**
     * Returns a {@link FoldingRangeKind} for the given value.
     *
     * @param value of the kind.
     */
    static fromValue(value) {
      switch (value) {
        case "comment":
          return _b.Comment;
        case "imports":
          return _b.Imports;
        case "region":
          return _b.Region;
      }
      return new _b(value);
    }
    /**
     * Creates a new {@link FoldingRangeKind}.
     *
     * @param value of the kind.
     */
    constructor(value) {
      this.value = value;
    }
  }, _b.Comment = new _b("comment"), _b.Imports = new _b("imports"), _b.Region = new _b("region"), _b);
  var NewSymbolNameTag$1;
  (function(NewSymbolNameTag2) {
    NewSymbolNameTag2[NewSymbolNameTag2["AIGenerated"] = 1] = "AIGenerated";
  })(NewSymbolNameTag$1 || (NewSymbolNameTag$1 = {}));
  var NewSymbolNameTriggerKind$1;
  (function(NewSymbolNameTriggerKind2) {
    NewSymbolNameTriggerKind2[NewSymbolNameTriggerKind2["Invoke"] = 0] = "Invoke";
    NewSymbolNameTriggerKind2[NewSymbolNameTriggerKind2["Automatic"] = 1] = "Automatic";
  })(NewSymbolNameTriggerKind$1 || (NewSymbolNameTriggerKind$1 = {}));
  var Command$1;
  (function(Command2) {
    function is(obj) {
      if (!obj || typeof obj !== "object") {
        return false;
      }
      return typeof obj.id === "string" && typeof obj.title === "string";
    }
    Command2.is = is;
  })(Command$1 || (Command$1 = {}));
  var InlayHintKind$2;
  (function(InlayHintKind2) {
    InlayHintKind2[InlayHintKind2["Type"] = 1] = "Type";
    InlayHintKind2[InlayHintKind2["Parameter"] = 2] = "Parameter";
  })(InlayHintKind$2 || (InlayHintKind$2 = {}));
  new TokenizationRegistry();
  var AccessibilitySupport;
  (function(AccessibilitySupport2) {
    AccessibilitySupport2[AccessibilitySupport2["Unknown"] = 0] = "Unknown";
    AccessibilitySupport2[AccessibilitySupport2["Disabled"] = 1] = "Disabled";
    AccessibilitySupport2[AccessibilitySupport2["Enabled"] = 2] = "Enabled";
  })(AccessibilitySupport || (AccessibilitySupport = {}));
  var CodeActionTriggerType;
  (function(CodeActionTriggerType2) {
    CodeActionTriggerType2[CodeActionTriggerType2["Invoke"] = 1] = "Invoke";
    CodeActionTriggerType2[CodeActionTriggerType2["Auto"] = 2] = "Auto";
  })(CodeActionTriggerType || (CodeActionTriggerType = {}));
  var CompletionItemInsertTextRule;
  (function(CompletionItemInsertTextRule2) {
    CompletionItemInsertTextRule2[CompletionItemInsertTextRule2["None"] = 0] = "None";
    CompletionItemInsertTextRule2[CompletionItemInsertTextRule2["KeepWhitespace"] = 1] = "KeepWhitespace";
    CompletionItemInsertTextRule2[CompletionItemInsertTextRule2["InsertAsSnippet"] = 4] = "InsertAsSnippet";
  })(CompletionItemInsertTextRule || (CompletionItemInsertTextRule = {}));
  var CompletionItemKind$1;
  (function(CompletionItemKind2) {
    CompletionItemKind2[CompletionItemKind2["Method"] = 0] = "Method";
    CompletionItemKind2[CompletionItemKind2["Function"] = 1] = "Function";
    CompletionItemKind2[CompletionItemKind2["Constructor"] = 2] = "Constructor";
    CompletionItemKind2[CompletionItemKind2["Field"] = 3] = "Field";
    CompletionItemKind2[CompletionItemKind2["Variable"] = 4] = "Variable";
    CompletionItemKind2[CompletionItemKind2["Class"] = 5] = "Class";
    CompletionItemKind2[CompletionItemKind2["Struct"] = 6] = "Struct";
    CompletionItemKind2[CompletionItemKind2["Interface"] = 7] = "Interface";
    CompletionItemKind2[CompletionItemKind2["Module"] = 8] = "Module";
    CompletionItemKind2[CompletionItemKind2["Property"] = 9] = "Property";
    CompletionItemKind2[CompletionItemKind2["Event"] = 10] = "Event";
    CompletionItemKind2[CompletionItemKind2["Operator"] = 11] = "Operator";
    CompletionItemKind2[CompletionItemKind2["Unit"] = 12] = "Unit";
    CompletionItemKind2[CompletionItemKind2["Value"] = 13] = "Value";
    CompletionItemKind2[CompletionItemKind2["Constant"] = 14] = "Constant";
    CompletionItemKind2[CompletionItemKind2["Enum"] = 15] = "Enum";
    CompletionItemKind2[CompletionItemKind2["EnumMember"] = 16] = "EnumMember";
    CompletionItemKind2[CompletionItemKind2["Keyword"] = 17] = "Keyword";
    CompletionItemKind2[CompletionItemKind2["Text"] = 18] = "Text";
    CompletionItemKind2[CompletionItemKind2["Color"] = 19] = "Color";
    CompletionItemKind2[CompletionItemKind2["File"] = 20] = "File";
    CompletionItemKind2[CompletionItemKind2["Reference"] = 21] = "Reference";
    CompletionItemKind2[CompletionItemKind2["Customcolor"] = 22] = "Customcolor";
    CompletionItemKind2[CompletionItemKind2["Folder"] = 23] = "Folder";
    CompletionItemKind2[CompletionItemKind2["TypeParameter"] = 24] = "TypeParameter";
    CompletionItemKind2[CompletionItemKind2["User"] = 25] = "User";
    CompletionItemKind2[CompletionItemKind2["Issue"] = 26] = "Issue";
    CompletionItemKind2[CompletionItemKind2["Tool"] = 27] = "Tool";
    CompletionItemKind2[CompletionItemKind2["Snippet"] = 28] = "Snippet";
  })(CompletionItemKind$1 || (CompletionItemKind$1 = {}));
  var CompletionItemTag$1;
  (function(CompletionItemTag2) {
    CompletionItemTag2[CompletionItemTag2["Deprecated"] = 1] = "Deprecated";
  })(CompletionItemTag$1 || (CompletionItemTag$1 = {}));
  var CompletionTriggerKind;
  (function(CompletionTriggerKind2) {
    CompletionTriggerKind2[CompletionTriggerKind2["Invoke"] = 0] = "Invoke";
    CompletionTriggerKind2[CompletionTriggerKind2["TriggerCharacter"] = 1] = "TriggerCharacter";
    CompletionTriggerKind2[CompletionTriggerKind2["TriggerForIncompleteCompletions"] = 2] = "TriggerForIncompleteCompletions";
  })(CompletionTriggerKind || (CompletionTriggerKind = {}));
  var ContentWidgetPositionPreference;
  (function(ContentWidgetPositionPreference2) {
    ContentWidgetPositionPreference2[ContentWidgetPositionPreference2["EXACT"] = 0] = "EXACT";
    ContentWidgetPositionPreference2[ContentWidgetPositionPreference2["ABOVE"] = 1] = "ABOVE";
    ContentWidgetPositionPreference2[ContentWidgetPositionPreference2["BELOW"] = 2] = "BELOW";
  })(ContentWidgetPositionPreference || (ContentWidgetPositionPreference = {}));
  var CursorChangeReason;
  (function(CursorChangeReason2) {
    CursorChangeReason2[CursorChangeReason2["NotSet"] = 0] = "NotSet";
    CursorChangeReason2[CursorChangeReason2["ContentFlush"] = 1] = "ContentFlush";
    CursorChangeReason2[CursorChangeReason2["RecoverFromMarkers"] = 2] = "RecoverFromMarkers";
    CursorChangeReason2[CursorChangeReason2["Explicit"] = 3] = "Explicit";
    CursorChangeReason2[CursorChangeReason2["Paste"] = 4] = "Paste";
    CursorChangeReason2[CursorChangeReason2["Undo"] = 5] = "Undo";
    CursorChangeReason2[CursorChangeReason2["Redo"] = 6] = "Redo";
  })(CursorChangeReason || (CursorChangeReason = {}));
  var DefaultEndOfLine;
  (function(DefaultEndOfLine2) {
    DefaultEndOfLine2[DefaultEndOfLine2["LF"] = 1] = "LF";
    DefaultEndOfLine2[DefaultEndOfLine2["CRLF"] = 2] = "CRLF";
  })(DefaultEndOfLine || (DefaultEndOfLine = {}));
  var DocumentHighlightKind$1;
  (function(DocumentHighlightKind2) {
    DocumentHighlightKind2[DocumentHighlightKind2["Text"] = 0] = "Text";
    DocumentHighlightKind2[DocumentHighlightKind2["Read"] = 1] = "Read";
    DocumentHighlightKind2[DocumentHighlightKind2["Write"] = 2] = "Write";
  })(DocumentHighlightKind$1 || (DocumentHighlightKind$1 = {}));
  var EditorAutoIndentStrategy;
  (function(EditorAutoIndentStrategy2) {
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["None"] = 0] = "None";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Keep"] = 1] = "Keep";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Brackets"] = 2] = "Brackets";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Advanced"] = 3] = "Advanced";
    EditorAutoIndentStrategy2[EditorAutoIndentStrategy2["Full"] = 4] = "Full";
  })(EditorAutoIndentStrategy || (EditorAutoIndentStrategy = {}));
  var EditorOption;
  (function(EditorOption2) {
    EditorOption2[EditorOption2["acceptSuggestionOnCommitCharacter"] = 0] = "acceptSuggestionOnCommitCharacter";
    EditorOption2[EditorOption2["acceptSuggestionOnEnter"] = 1] = "acceptSuggestionOnEnter";
    EditorOption2[EditorOption2["accessibilitySupport"] = 2] = "accessibilitySupport";
    EditorOption2[EditorOption2["accessibilityPageSize"] = 3] = "accessibilityPageSize";
    EditorOption2[EditorOption2["allowOverflow"] = 4] = "allowOverflow";
    EditorOption2[EditorOption2["allowVariableLineHeights"] = 5] = "allowVariableLineHeights";
    EditorOption2[EditorOption2["allowVariableFonts"] = 6] = "allowVariableFonts";
    EditorOption2[EditorOption2["allowVariableFontsInAccessibilityMode"] = 7] = "allowVariableFontsInAccessibilityMode";
    EditorOption2[EditorOption2["ariaLabel"] = 8] = "ariaLabel";
    EditorOption2[EditorOption2["ariaRequired"] = 9] = "ariaRequired";
    EditorOption2[EditorOption2["autoClosingBrackets"] = 10] = "autoClosingBrackets";
    EditorOption2[EditorOption2["autoClosingComments"] = 11] = "autoClosingComments";
    EditorOption2[EditorOption2["screenReaderAnnounceInlineSuggestion"] = 12] = "screenReaderAnnounceInlineSuggestion";
    EditorOption2[EditorOption2["autoClosingDelete"] = 13] = "autoClosingDelete";
    EditorOption2[EditorOption2["autoClosingOvertype"] = 14] = "autoClosingOvertype";
    EditorOption2[EditorOption2["autoClosingQuotes"] = 15] = "autoClosingQuotes";
    EditorOption2[EditorOption2["autoIndent"] = 16] = "autoIndent";
    EditorOption2[EditorOption2["autoIndentOnPaste"] = 17] = "autoIndentOnPaste";
    EditorOption2[EditorOption2["autoIndentOnPasteWithinString"] = 18] = "autoIndentOnPasteWithinString";
    EditorOption2[EditorOption2["automaticLayout"] = 19] = "automaticLayout";
    EditorOption2[EditorOption2["autoSurround"] = 20] = "autoSurround";
    EditorOption2[EditorOption2["bracketPairColorization"] = 21] = "bracketPairColorization";
    EditorOption2[EditorOption2["guides"] = 22] = "guides";
    EditorOption2[EditorOption2["codeLens"] = 23] = "codeLens";
    EditorOption2[EditorOption2["codeLensFontFamily"] = 24] = "codeLensFontFamily";
    EditorOption2[EditorOption2["codeLensFontSize"] = 25] = "codeLensFontSize";
    EditorOption2[EditorOption2["colorDecorators"] = 26] = "colorDecorators";
    EditorOption2[EditorOption2["colorDecoratorsLimit"] = 27] = "colorDecoratorsLimit";
    EditorOption2[EditorOption2["columnSelection"] = 28] = "columnSelection";
    EditorOption2[EditorOption2["comments"] = 29] = "comments";
    EditorOption2[EditorOption2["contextmenu"] = 30] = "contextmenu";
    EditorOption2[EditorOption2["copyWithSyntaxHighlighting"] = 31] = "copyWithSyntaxHighlighting";
    EditorOption2[EditorOption2["cursorBlinking"] = 32] = "cursorBlinking";
    EditorOption2[EditorOption2["cursorSmoothCaretAnimation"] = 33] = "cursorSmoothCaretAnimation";
    EditorOption2[EditorOption2["cursorStyle"] = 34] = "cursorStyle";
    EditorOption2[EditorOption2["cursorSurroundingLines"] = 35] = "cursorSurroundingLines";
    EditorOption2[EditorOption2["cursorSurroundingLinesStyle"] = 36] = "cursorSurroundingLinesStyle";
    EditorOption2[EditorOption2["cursorWidth"] = 37] = "cursorWidth";
    EditorOption2[EditorOption2["cursorHeight"] = 38] = "cursorHeight";
    EditorOption2[EditorOption2["disableLayerHinting"] = 39] = "disableLayerHinting";
    EditorOption2[EditorOption2["disableMonospaceOptimizations"] = 40] = "disableMonospaceOptimizations";
    EditorOption2[EditorOption2["domReadOnly"] = 41] = "domReadOnly";
    EditorOption2[EditorOption2["dragAndDrop"] = 42] = "dragAndDrop";
    EditorOption2[EditorOption2["dropIntoEditor"] = 43] = "dropIntoEditor";
    EditorOption2[EditorOption2["editContext"] = 44] = "editContext";
    EditorOption2[EditorOption2["emptySelectionClipboard"] = 45] = "emptySelectionClipboard";
    EditorOption2[EditorOption2["experimentalGpuAcceleration"] = 46] = "experimentalGpuAcceleration";
    EditorOption2[EditorOption2["experimentalWhitespaceRendering"] = 47] = "experimentalWhitespaceRendering";
    EditorOption2[EditorOption2["extraEditorClassName"] = 48] = "extraEditorClassName";
    EditorOption2[EditorOption2["fastScrollSensitivity"] = 49] = "fastScrollSensitivity";
    EditorOption2[EditorOption2["find"] = 50] = "find";
    EditorOption2[EditorOption2["fixedOverflowWidgets"] = 51] = "fixedOverflowWidgets";
    EditorOption2[EditorOption2["folding"] = 52] = "folding";
    EditorOption2[EditorOption2["foldingStrategy"] = 53] = "foldingStrategy";
    EditorOption2[EditorOption2["foldingHighlight"] = 54] = "foldingHighlight";
    EditorOption2[EditorOption2["foldingImportsByDefault"] = 55] = "foldingImportsByDefault";
    EditorOption2[EditorOption2["foldingMaximumRegions"] = 56] = "foldingMaximumRegions";
    EditorOption2[EditorOption2["unfoldOnClickAfterEndOfLine"] = 57] = "unfoldOnClickAfterEndOfLine";
    EditorOption2[EditorOption2["fontFamily"] = 58] = "fontFamily";
    EditorOption2[EditorOption2["fontInfo"] = 59] = "fontInfo";
    EditorOption2[EditorOption2["fontLigatures"] = 60] = "fontLigatures";
    EditorOption2[EditorOption2["fontSize"] = 61] = "fontSize";
    EditorOption2[EditorOption2["fontWeight"] = 62] = "fontWeight";
    EditorOption2[EditorOption2["fontVariations"] = 63] = "fontVariations";
    EditorOption2[EditorOption2["formatOnPaste"] = 64] = "formatOnPaste";
    EditorOption2[EditorOption2["formatOnType"] = 65] = "formatOnType";
    EditorOption2[EditorOption2["glyphMargin"] = 66] = "glyphMargin";
    EditorOption2[EditorOption2["gotoLocation"] = 67] = "gotoLocation";
    EditorOption2[EditorOption2["hideCursorInOverviewRuler"] = 68] = "hideCursorInOverviewRuler";
    EditorOption2[EditorOption2["hover"] = 69] = "hover";
    EditorOption2[EditorOption2["inDiffEditor"] = 70] = "inDiffEditor";
    EditorOption2[EditorOption2["inlineSuggest"] = 71] = "inlineSuggest";
    EditorOption2[EditorOption2["letterSpacing"] = 72] = "letterSpacing";
    EditorOption2[EditorOption2["lightbulb"] = 73] = "lightbulb";
    EditorOption2[EditorOption2["lineDecorationsWidth"] = 74] = "lineDecorationsWidth";
    EditorOption2[EditorOption2["lineHeight"] = 75] = "lineHeight";
    EditorOption2[EditorOption2["lineNumbers"] = 76] = "lineNumbers";
    EditorOption2[EditorOption2["lineNumbersMinChars"] = 77] = "lineNumbersMinChars";
    EditorOption2[EditorOption2["linkedEditing"] = 78] = "linkedEditing";
    EditorOption2[EditorOption2["links"] = 79] = "links";
    EditorOption2[EditorOption2["matchBrackets"] = 80] = "matchBrackets";
    EditorOption2[EditorOption2["minimap"] = 81] = "minimap";
    EditorOption2[EditorOption2["mouseStyle"] = 82] = "mouseStyle";
    EditorOption2[EditorOption2["mouseWheelScrollSensitivity"] = 83] = "mouseWheelScrollSensitivity";
    EditorOption2[EditorOption2["mouseWheelZoom"] = 84] = "mouseWheelZoom";
    EditorOption2[EditorOption2["multiCursorMergeOverlapping"] = 85] = "multiCursorMergeOverlapping";
    EditorOption2[EditorOption2["multiCursorModifier"] = 86] = "multiCursorModifier";
    EditorOption2[EditorOption2["mouseMiddleClickAction"] = 87] = "mouseMiddleClickAction";
    EditorOption2[EditorOption2["multiCursorPaste"] = 88] = "multiCursorPaste";
    EditorOption2[EditorOption2["multiCursorLimit"] = 89] = "multiCursorLimit";
    EditorOption2[EditorOption2["occurrencesHighlight"] = 90] = "occurrencesHighlight";
    EditorOption2[EditorOption2["occurrencesHighlightDelay"] = 91] = "occurrencesHighlightDelay";
    EditorOption2[EditorOption2["overtypeCursorStyle"] = 92] = "overtypeCursorStyle";
    EditorOption2[EditorOption2["overtypeOnPaste"] = 93] = "overtypeOnPaste";
    EditorOption2[EditorOption2["overviewRulerBorder"] = 94] = "overviewRulerBorder";
    EditorOption2[EditorOption2["overviewRulerLanes"] = 95] = "overviewRulerLanes";
    EditorOption2[EditorOption2["padding"] = 96] = "padding";
    EditorOption2[EditorOption2["pasteAs"] = 97] = "pasteAs";
    EditorOption2[EditorOption2["parameterHints"] = 98] = "parameterHints";
    EditorOption2[EditorOption2["peekWidgetDefaultFocus"] = 99] = "peekWidgetDefaultFocus";
    EditorOption2[EditorOption2["placeholder"] = 100] = "placeholder";
    EditorOption2[EditorOption2["definitionLinkOpensInPeek"] = 101] = "definitionLinkOpensInPeek";
    EditorOption2[EditorOption2["quickSuggestions"] = 102] = "quickSuggestions";
    EditorOption2[EditorOption2["quickSuggestionsDelay"] = 103] = "quickSuggestionsDelay";
    EditorOption2[EditorOption2["readOnly"] = 104] = "readOnly";
    EditorOption2[EditorOption2["readOnlyMessage"] = 105] = "readOnlyMessage";
    EditorOption2[EditorOption2["renameOnType"] = 106] = "renameOnType";
    EditorOption2[EditorOption2["renderRichScreenReaderContent"] = 107] = "renderRichScreenReaderContent";
    EditorOption2[EditorOption2["renderControlCharacters"] = 108] = "renderControlCharacters";
    EditorOption2[EditorOption2["renderFinalNewline"] = 109] = "renderFinalNewline";
    EditorOption2[EditorOption2["renderLineHighlight"] = 110] = "renderLineHighlight";
    EditorOption2[EditorOption2["renderLineHighlightOnlyWhenFocus"] = 111] = "renderLineHighlightOnlyWhenFocus";
    EditorOption2[EditorOption2["renderValidationDecorations"] = 112] = "renderValidationDecorations";
    EditorOption2[EditorOption2["renderWhitespace"] = 113] = "renderWhitespace";
    EditorOption2[EditorOption2["revealHorizontalRightPadding"] = 114] = "revealHorizontalRightPadding";
    EditorOption2[EditorOption2["roundedSelection"] = 115] = "roundedSelection";
    EditorOption2[EditorOption2["rulers"] = 116] = "rulers";
    EditorOption2[EditorOption2["scrollbar"] = 117] = "scrollbar";
    EditorOption2[EditorOption2["scrollBeyondLastColumn"] = 118] = "scrollBeyondLastColumn";
    EditorOption2[EditorOption2["scrollBeyondLastLine"] = 119] = "scrollBeyondLastLine";
    EditorOption2[EditorOption2["scrollPredominantAxis"] = 120] = "scrollPredominantAxis";
    EditorOption2[EditorOption2["selectionClipboard"] = 121] = "selectionClipboard";
    EditorOption2[EditorOption2["selectionHighlight"] = 122] = "selectionHighlight";
    EditorOption2[EditorOption2["selectionHighlightMaxLength"] = 123] = "selectionHighlightMaxLength";
    EditorOption2[EditorOption2["selectionHighlightMultiline"] = 124] = "selectionHighlightMultiline";
    EditorOption2[EditorOption2["selectOnLineNumbers"] = 125] = "selectOnLineNumbers";
    EditorOption2[EditorOption2["showFoldingControls"] = 126] = "showFoldingControls";
    EditorOption2[EditorOption2["showUnused"] = 127] = "showUnused";
    EditorOption2[EditorOption2["snippetSuggestions"] = 128] = "snippetSuggestions";
    EditorOption2[EditorOption2["smartSelect"] = 129] = "smartSelect";
    EditorOption2[EditorOption2["smoothScrolling"] = 130] = "smoothScrolling";
    EditorOption2[EditorOption2["stickyScroll"] = 131] = "stickyScroll";
    EditorOption2[EditorOption2["stickyTabStops"] = 132] = "stickyTabStops";
    EditorOption2[EditorOption2["stopRenderingLineAfter"] = 133] = "stopRenderingLineAfter";
    EditorOption2[EditorOption2["suggest"] = 134] = "suggest";
    EditorOption2[EditorOption2["suggestFontSize"] = 135] = "suggestFontSize";
    EditorOption2[EditorOption2["suggestLineHeight"] = 136] = "suggestLineHeight";
    EditorOption2[EditorOption2["suggestOnTriggerCharacters"] = 137] = "suggestOnTriggerCharacters";
    EditorOption2[EditorOption2["suggestSelection"] = 138] = "suggestSelection";
    EditorOption2[EditorOption2["tabCompletion"] = 139] = "tabCompletion";
    EditorOption2[EditorOption2["tabIndex"] = 140] = "tabIndex";
    EditorOption2[EditorOption2["trimWhitespaceOnDelete"] = 141] = "trimWhitespaceOnDelete";
    EditorOption2[EditorOption2["unicodeHighlighting"] = 142] = "unicodeHighlighting";
    EditorOption2[EditorOption2["unusualLineTerminators"] = 143] = "unusualLineTerminators";
    EditorOption2[EditorOption2["useShadowDOM"] = 144] = "useShadowDOM";
    EditorOption2[EditorOption2["useTabStops"] = 145] = "useTabStops";
    EditorOption2[EditorOption2["wordBreak"] = 146] = "wordBreak";
    EditorOption2[EditorOption2["wordSegmenterLocales"] = 147] = "wordSegmenterLocales";
    EditorOption2[EditorOption2["wordSeparators"] = 148] = "wordSeparators";
    EditorOption2[EditorOption2["wordWrap"] = 149] = "wordWrap";
    EditorOption2[EditorOption2["wordWrapBreakAfterCharacters"] = 150] = "wordWrapBreakAfterCharacters";
    EditorOption2[EditorOption2["wordWrapBreakBeforeCharacters"] = 151] = "wordWrapBreakBeforeCharacters";
    EditorOption2[EditorOption2["wordWrapColumn"] = 152] = "wordWrapColumn";
    EditorOption2[EditorOption2["wordWrapOverride1"] = 153] = "wordWrapOverride1";
    EditorOption2[EditorOption2["wordWrapOverride2"] = 154] = "wordWrapOverride2";
    EditorOption2[EditorOption2["wrappingIndent"] = 155] = "wrappingIndent";
    EditorOption2[EditorOption2["wrappingStrategy"] = 156] = "wrappingStrategy";
    EditorOption2[EditorOption2["showDeprecated"] = 157] = "showDeprecated";
    EditorOption2[EditorOption2["inertialScroll"] = 158] = "inertialScroll";
    EditorOption2[EditorOption2["inlayHints"] = 159] = "inlayHints";
    EditorOption2[EditorOption2["wrapOnEscapedLineFeeds"] = 160] = "wrapOnEscapedLineFeeds";
    EditorOption2[EditorOption2["effectiveCursorStyle"] = 161] = "effectiveCursorStyle";
    EditorOption2[EditorOption2["editorClassName"] = 162] = "editorClassName";
    EditorOption2[EditorOption2["pixelRatio"] = 163] = "pixelRatio";
    EditorOption2[EditorOption2["tabFocusMode"] = 164] = "tabFocusMode";
    EditorOption2[EditorOption2["layoutInfo"] = 165] = "layoutInfo";
    EditorOption2[EditorOption2["wrappingInfo"] = 166] = "wrappingInfo";
    EditorOption2[EditorOption2["defaultColorDecorators"] = 167] = "defaultColorDecorators";
    EditorOption2[EditorOption2["colorDecoratorsActivatedOn"] = 168] = "colorDecoratorsActivatedOn";
    EditorOption2[EditorOption2["inlineCompletionsAccessibilityVerbose"] = 169] = "inlineCompletionsAccessibilityVerbose";
    EditorOption2[EditorOption2["effectiveEditContext"] = 170] = "effectiveEditContext";
    EditorOption2[EditorOption2["scrollOnMiddleClick"] = 171] = "scrollOnMiddleClick";
    EditorOption2[EditorOption2["effectiveAllowVariableFonts"] = 172] = "effectiveAllowVariableFonts";
  })(EditorOption || (EditorOption = {}));
  var EndOfLinePreference;
  (function(EndOfLinePreference2) {
    EndOfLinePreference2[EndOfLinePreference2["TextDefined"] = 0] = "TextDefined";
    EndOfLinePreference2[EndOfLinePreference2["LF"] = 1] = "LF";
    EndOfLinePreference2[EndOfLinePreference2["CRLF"] = 2] = "CRLF";
  })(EndOfLinePreference || (EndOfLinePreference = {}));
  var EndOfLineSequence;
  (function(EndOfLineSequence2) {
    EndOfLineSequence2[EndOfLineSequence2["LF"] = 0] = "LF";
    EndOfLineSequence2[EndOfLineSequence2["CRLF"] = 1] = "CRLF";
  })(EndOfLineSequence || (EndOfLineSequence = {}));
  var GlyphMarginLane$1;
  (function(GlyphMarginLane2) {
    GlyphMarginLane2[GlyphMarginLane2["Left"] = 1] = "Left";
    GlyphMarginLane2[GlyphMarginLane2["Center"] = 2] = "Center";
    GlyphMarginLane2[GlyphMarginLane2["Right"] = 3] = "Right";
  })(GlyphMarginLane$1 || (GlyphMarginLane$1 = {}));
  var HoverVerbosityAction;
  (function(HoverVerbosityAction2) {
    HoverVerbosityAction2[HoverVerbosityAction2["Increase"] = 0] = "Increase";
    HoverVerbosityAction2[HoverVerbosityAction2["Decrease"] = 1] = "Decrease";
  })(HoverVerbosityAction || (HoverVerbosityAction = {}));
  var IndentAction;
  (function(IndentAction2) {
    IndentAction2[IndentAction2["None"] = 0] = "None";
    IndentAction2[IndentAction2["Indent"] = 1] = "Indent";
    IndentAction2[IndentAction2["IndentOutdent"] = 2] = "IndentOutdent";
    IndentAction2[IndentAction2["Outdent"] = 3] = "Outdent";
  })(IndentAction || (IndentAction = {}));
  var InjectedTextCursorStops$1;
  (function(InjectedTextCursorStops2) {
    InjectedTextCursorStops2[InjectedTextCursorStops2["Both"] = 0] = "Both";
    InjectedTextCursorStops2[InjectedTextCursorStops2["Right"] = 1] = "Right";
    InjectedTextCursorStops2[InjectedTextCursorStops2["Left"] = 2] = "Left";
    InjectedTextCursorStops2[InjectedTextCursorStops2["None"] = 3] = "None";
  })(InjectedTextCursorStops$1 || (InjectedTextCursorStops$1 = {}));
  var InlayHintKind$1;
  (function(InlayHintKind2) {
    InlayHintKind2[InlayHintKind2["Type"] = 1] = "Type";
    InlayHintKind2[InlayHintKind2["Parameter"] = 2] = "Parameter";
  })(InlayHintKind$1 || (InlayHintKind$1 = {}));
  var InlineCompletionDisplayLocationKind;
  (function(InlineCompletionDisplayLocationKind2) {
    InlineCompletionDisplayLocationKind2[InlineCompletionDisplayLocationKind2["Code"] = 1] = "Code";
    InlineCompletionDisplayLocationKind2[InlineCompletionDisplayLocationKind2["Label"] = 2] = "Label";
  })(InlineCompletionDisplayLocationKind || (InlineCompletionDisplayLocationKind = {}));
  var InlineCompletionEndOfLifeReasonKind;
  (function(InlineCompletionEndOfLifeReasonKind2) {
    InlineCompletionEndOfLifeReasonKind2[InlineCompletionEndOfLifeReasonKind2["Accepted"] = 0] = "Accepted";
    InlineCompletionEndOfLifeReasonKind2[InlineCompletionEndOfLifeReasonKind2["Rejected"] = 1] = "Rejected";
    InlineCompletionEndOfLifeReasonKind2[InlineCompletionEndOfLifeReasonKind2["Ignored"] = 2] = "Ignored";
  })(InlineCompletionEndOfLifeReasonKind || (InlineCompletionEndOfLifeReasonKind = {}));
  var InlineCompletionTriggerKind$1;
  (function(InlineCompletionTriggerKind2) {
    InlineCompletionTriggerKind2[InlineCompletionTriggerKind2["Automatic"] = 0] = "Automatic";
    InlineCompletionTriggerKind2[InlineCompletionTriggerKind2["Explicit"] = 1] = "Explicit";
  })(InlineCompletionTriggerKind$1 || (InlineCompletionTriggerKind$1 = {}));
  var KeyCode;
  (function(KeyCode2) {
    KeyCode2[KeyCode2["DependsOnKbLayout"] = -1] = "DependsOnKbLayout";
    KeyCode2[KeyCode2["Unknown"] = 0] = "Unknown";
    KeyCode2[KeyCode2["Backspace"] = 1] = "Backspace";
    KeyCode2[KeyCode2["Tab"] = 2] = "Tab";
    KeyCode2[KeyCode2["Enter"] = 3] = "Enter";
    KeyCode2[KeyCode2["Shift"] = 4] = "Shift";
    KeyCode2[KeyCode2["Ctrl"] = 5] = "Ctrl";
    KeyCode2[KeyCode2["Alt"] = 6] = "Alt";
    KeyCode2[KeyCode2["PauseBreak"] = 7] = "PauseBreak";
    KeyCode2[KeyCode2["CapsLock"] = 8] = "CapsLock";
    KeyCode2[KeyCode2["Escape"] = 9] = "Escape";
    KeyCode2[KeyCode2["Space"] = 10] = "Space";
    KeyCode2[KeyCode2["PageUp"] = 11] = "PageUp";
    KeyCode2[KeyCode2["PageDown"] = 12] = "PageDown";
    KeyCode2[KeyCode2["End"] = 13] = "End";
    KeyCode2[KeyCode2["Home"] = 14] = "Home";
    KeyCode2[KeyCode2["LeftArrow"] = 15] = "LeftArrow";
    KeyCode2[KeyCode2["UpArrow"] = 16] = "UpArrow";
    KeyCode2[KeyCode2["RightArrow"] = 17] = "RightArrow";
    KeyCode2[KeyCode2["DownArrow"] = 18] = "DownArrow";
    KeyCode2[KeyCode2["Insert"] = 19] = "Insert";
    KeyCode2[KeyCode2["Delete"] = 20] = "Delete";
    KeyCode2[KeyCode2["Digit0"] = 21] = "Digit0";
    KeyCode2[KeyCode2["Digit1"] = 22] = "Digit1";
    KeyCode2[KeyCode2["Digit2"] = 23] = "Digit2";
    KeyCode2[KeyCode2["Digit3"] = 24] = "Digit3";
    KeyCode2[KeyCode2["Digit4"] = 25] = "Digit4";
    KeyCode2[KeyCode2["Digit5"] = 26] = "Digit5";
    KeyCode2[KeyCode2["Digit6"] = 27] = "Digit6";
    KeyCode2[KeyCode2["Digit7"] = 28] = "Digit7";
    KeyCode2[KeyCode2["Digit8"] = 29] = "Digit8";
    KeyCode2[KeyCode2["Digit9"] = 30] = "Digit9";
    KeyCode2[KeyCode2["KeyA"] = 31] = "KeyA";
    KeyCode2[KeyCode2["KeyB"] = 32] = "KeyB";
    KeyCode2[KeyCode2["KeyC"] = 33] = "KeyC";
    KeyCode2[KeyCode2["KeyD"] = 34] = "KeyD";
    KeyCode2[KeyCode2["KeyE"] = 35] = "KeyE";
    KeyCode2[KeyCode2["KeyF"] = 36] = "KeyF";
    KeyCode2[KeyCode2["KeyG"] = 37] = "KeyG";
    KeyCode2[KeyCode2["KeyH"] = 38] = "KeyH";
    KeyCode2[KeyCode2["KeyI"] = 39] = "KeyI";
    KeyCode2[KeyCode2["KeyJ"] = 40] = "KeyJ";
    KeyCode2[KeyCode2["KeyK"] = 41] = "KeyK";
    KeyCode2[KeyCode2["KeyL"] = 42] = "KeyL";
    KeyCode2[KeyCode2["KeyM"] = 43] = "KeyM";
    KeyCode2[KeyCode2["KeyN"] = 44] = "KeyN";
    KeyCode2[KeyCode2["KeyO"] = 45] = "KeyO";
    KeyCode2[KeyCode2["KeyP"] = 46] = "KeyP";
    KeyCode2[KeyCode2["KeyQ"] = 47] = "KeyQ";
    KeyCode2[KeyCode2["KeyR"] = 48] = "KeyR";
    KeyCode2[KeyCode2["KeyS"] = 49] = "KeyS";
    KeyCode2[KeyCode2["KeyT"] = 50] = "KeyT";
    KeyCode2[KeyCode2["KeyU"] = 51] = "KeyU";
    KeyCode2[KeyCode2["KeyV"] = 52] = "KeyV";
    KeyCode2[KeyCode2["KeyW"] = 53] = "KeyW";
    KeyCode2[KeyCode2["KeyX"] = 54] = "KeyX";
    KeyCode2[KeyCode2["KeyY"] = 55] = "KeyY";
    KeyCode2[KeyCode2["KeyZ"] = 56] = "KeyZ";
    KeyCode2[KeyCode2["Meta"] = 57] = "Meta";
    KeyCode2[KeyCode2["ContextMenu"] = 58] = "ContextMenu";
    KeyCode2[KeyCode2["F1"] = 59] = "F1";
    KeyCode2[KeyCode2["F2"] = 60] = "F2";
    KeyCode2[KeyCode2["F3"] = 61] = "F3";
    KeyCode2[KeyCode2["F4"] = 62] = "F4";
    KeyCode2[KeyCode2["F5"] = 63] = "F5";
    KeyCode2[KeyCode2["F6"] = 64] = "F6";
    KeyCode2[KeyCode2["F7"] = 65] = "F7";
    KeyCode2[KeyCode2["F8"] = 66] = "F8";
    KeyCode2[KeyCode2["F9"] = 67] = "F9";
    KeyCode2[KeyCode2["F10"] = 68] = "F10";
    KeyCode2[KeyCode2["F11"] = 69] = "F11";
    KeyCode2[KeyCode2["F12"] = 70] = "F12";
    KeyCode2[KeyCode2["F13"] = 71] = "F13";
    KeyCode2[KeyCode2["F14"] = 72] = "F14";
    KeyCode2[KeyCode2["F15"] = 73] = "F15";
    KeyCode2[KeyCode2["F16"] = 74] = "F16";
    KeyCode2[KeyCode2["F17"] = 75] = "F17";
    KeyCode2[KeyCode2["F18"] = 76] = "F18";
    KeyCode2[KeyCode2["F19"] = 77] = "F19";
    KeyCode2[KeyCode2["F20"] = 78] = "F20";
    KeyCode2[KeyCode2["F21"] = 79] = "F21";
    KeyCode2[KeyCode2["F22"] = 80] = "F22";
    KeyCode2[KeyCode2["F23"] = 81] = "F23";
    KeyCode2[KeyCode2["F24"] = 82] = "F24";
    KeyCode2[KeyCode2["NumLock"] = 83] = "NumLock";
    KeyCode2[KeyCode2["ScrollLock"] = 84] = "ScrollLock";
    KeyCode2[KeyCode2["Semicolon"] = 85] = "Semicolon";
    KeyCode2[KeyCode2["Equal"] = 86] = "Equal";
    KeyCode2[KeyCode2["Comma"] = 87] = "Comma";
    KeyCode2[KeyCode2["Minus"] = 88] = "Minus";
    KeyCode2[KeyCode2["Period"] = 89] = "Period";
    KeyCode2[KeyCode2["Slash"] = 90] = "Slash";
    KeyCode2[KeyCode2["Backquote"] = 91] = "Backquote";
    KeyCode2[KeyCode2["BracketLeft"] = 92] = "BracketLeft";
    KeyCode2[KeyCode2["Backslash"] = 93] = "Backslash";
    KeyCode2[KeyCode2["BracketRight"] = 94] = "BracketRight";
    KeyCode2[KeyCode2["Quote"] = 95] = "Quote";
    KeyCode2[KeyCode2["OEM_8"] = 96] = "OEM_8";
    KeyCode2[KeyCode2["IntlBackslash"] = 97] = "IntlBackslash";
    KeyCode2[KeyCode2["Numpad0"] = 98] = "Numpad0";
    KeyCode2[KeyCode2["Numpad1"] = 99] = "Numpad1";
    KeyCode2[KeyCode2["Numpad2"] = 100] = "Numpad2";
    KeyCode2[KeyCode2["Numpad3"] = 101] = "Numpad3";
    KeyCode2[KeyCode2["Numpad4"] = 102] = "Numpad4";
    KeyCode2[KeyCode2["Numpad5"] = 103] = "Numpad5";
    KeyCode2[KeyCode2["Numpad6"] = 104] = "Numpad6";
    KeyCode2[KeyCode2["Numpad7"] = 105] = "Numpad7";
    KeyCode2[KeyCode2["Numpad8"] = 106] = "Numpad8";
    KeyCode2[KeyCode2["Numpad9"] = 107] = "Numpad9";
    KeyCode2[KeyCode2["NumpadMultiply"] = 108] = "NumpadMultiply";
    KeyCode2[KeyCode2["NumpadAdd"] = 109] = "NumpadAdd";
    KeyCode2[KeyCode2["NUMPAD_SEPARATOR"] = 110] = "NUMPAD_SEPARATOR";
    KeyCode2[KeyCode2["NumpadSubtract"] = 111] = "NumpadSubtract";
    KeyCode2[KeyCode2["NumpadDecimal"] = 112] = "NumpadDecimal";
    KeyCode2[KeyCode2["NumpadDivide"] = 113] = "NumpadDivide";
    KeyCode2[KeyCode2["KEY_IN_COMPOSITION"] = 114] = "KEY_IN_COMPOSITION";
    KeyCode2[KeyCode2["ABNT_C1"] = 115] = "ABNT_C1";
    KeyCode2[KeyCode2["ABNT_C2"] = 116] = "ABNT_C2";
    KeyCode2[KeyCode2["AudioVolumeMute"] = 117] = "AudioVolumeMute";
    KeyCode2[KeyCode2["AudioVolumeUp"] = 118] = "AudioVolumeUp";
    KeyCode2[KeyCode2["AudioVolumeDown"] = 119] = "AudioVolumeDown";
    KeyCode2[KeyCode2["BrowserSearch"] = 120] = "BrowserSearch";
    KeyCode2[KeyCode2["BrowserHome"] = 121] = "BrowserHome";
    KeyCode2[KeyCode2["BrowserBack"] = 122] = "BrowserBack";
    KeyCode2[KeyCode2["BrowserForward"] = 123] = "BrowserForward";
    KeyCode2[KeyCode2["MediaTrackNext"] = 124] = "MediaTrackNext";
    KeyCode2[KeyCode2["MediaTrackPrevious"] = 125] = "MediaTrackPrevious";
    KeyCode2[KeyCode2["MediaStop"] = 126] = "MediaStop";
    KeyCode2[KeyCode2["MediaPlayPause"] = 127] = "MediaPlayPause";
    KeyCode2[KeyCode2["LaunchMediaPlayer"] = 128] = "LaunchMediaPlayer";
    KeyCode2[KeyCode2["LaunchMail"] = 129] = "LaunchMail";
    KeyCode2[KeyCode2["LaunchApp2"] = 130] = "LaunchApp2";
    KeyCode2[KeyCode2["Clear"] = 131] = "Clear";
    KeyCode2[KeyCode2["MAX_VALUE"] = 132] = "MAX_VALUE";
  })(KeyCode || (KeyCode = {}));
  var MarkerSeverity;
  (function(MarkerSeverity2) {
    MarkerSeverity2[MarkerSeverity2["Hint"] = 1] = "Hint";
    MarkerSeverity2[MarkerSeverity2["Info"] = 2] = "Info";
    MarkerSeverity2[MarkerSeverity2["Warning"] = 4] = "Warning";
    MarkerSeverity2[MarkerSeverity2["Error"] = 8] = "Error";
  })(MarkerSeverity || (MarkerSeverity = {}));
  var MarkerTag;
  (function(MarkerTag2) {
    MarkerTag2[MarkerTag2["Unnecessary"] = 1] = "Unnecessary";
    MarkerTag2[MarkerTag2["Deprecated"] = 2] = "Deprecated";
  })(MarkerTag || (MarkerTag = {}));
  var MinimapPosition;
  (function(MinimapPosition2) {
    MinimapPosition2[MinimapPosition2["Inline"] = 1] = "Inline";
    MinimapPosition2[MinimapPosition2["Gutter"] = 2] = "Gutter";
  })(MinimapPosition || (MinimapPosition = {}));
  var MinimapSectionHeaderStyle;
  (function(MinimapSectionHeaderStyle2) {
    MinimapSectionHeaderStyle2[MinimapSectionHeaderStyle2["Normal"] = 1] = "Normal";
    MinimapSectionHeaderStyle2[MinimapSectionHeaderStyle2["Underlined"] = 2] = "Underlined";
  })(MinimapSectionHeaderStyle || (MinimapSectionHeaderStyle = {}));
  var MouseTargetType;
  (function(MouseTargetType2) {
    MouseTargetType2[MouseTargetType2["UNKNOWN"] = 0] = "UNKNOWN";
    MouseTargetType2[MouseTargetType2["TEXTAREA"] = 1] = "TEXTAREA";
    MouseTargetType2[MouseTargetType2["GUTTER_GLYPH_MARGIN"] = 2] = "GUTTER_GLYPH_MARGIN";
    MouseTargetType2[MouseTargetType2["GUTTER_LINE_NUMBERS"] = 3] = "GUTTER_LINE_NUMBERS";
    MouseTargetType2[MouseTargetType2["GUTTER_LINE_DECORATIONS"] = 4] = "GUTTER_LINE_DECORATIONS";
    MouseTargetType2[MouseTargetType2["GUTTER_VIEW_ZONE"] = 5] = "GUTTER_VIEW_ZONE";
    MouseTargetType2[MouseTargetType2["CONTENT_TEXT"] = 6] = "CONTENT_TEXT";
    MouseTargetType2[MouseTargetType2["CONTENT_EMPTY"] = 7] = "CONTENT_EMPTY";
    MouseTargetType2[MouseTargetType2["CONTENT_VIEW_ZONE"] = 8] = "CONTENT_VIEW_ZONE";
    MouseTargetType2[MouseTargetType2["CONTENT_WIDGET"] = 9] = "CONTENT_WIDGET";
    MouseTargetType2[MouseTargetType2["OVERVIEW_RULER"] = 10] = "OVERVIEW_RULER";
    MouseTargetType2[MouseTargetType2["SCROLLBAR"] = 11] = "SCROLLBAR";
    MouseTargetType2[MouseTargetType2["OVERLAY_WIDGET"] = 12] = "OVERLAY_WIDGET";
    MouseTargetType2[MouseTargetType2["OUTSIDE_EDITOR"] = 13] = "OUTSIDE_EDITOR";
  })(MouseTargetType || (MouseTargetType = {}));
  var NewSymbolNameTag;
  (function(NewSymbolNameTag2) {
    NewSymbolNameTag2[NewSymbolNameTag2["AIGenerated"] = 1] = "AIGenerated";
  })(NewSymbolNameTag || (NewSymbolNameTag = {}));
  var NewSymbolNameTriggerKind;
  (function(NewSymbolNameTriggerKind2) {
    NewSymbolNameTriggerKind2[NewSymbolNameTriggerKind2["Invoke"] = 0] = "Invoke";
    NewSymbolNameTriggerKind2[NewSymbolNameTriggerKind2["Automatic"] = 1] = "Automatic";
  })(NewSymbolNameTriggerKind || (NewSymbolNameTriggerKind = {}));
  var OverlayWidgetPositionPreference;
  (function(OverlayWidgetPositionPreference2) {
    OverlayWidgetPositionPreference2[OverlayWidgetPositionPreference2["TOP_RIGHT_CORNER"] = 0] = "TOP_RIGHT_CORNER";
    OverlayWidgetPositionPreference2[OverlayWidgetPositionPreference2["BOTTOM_RIGHT_CORNER"] = 1] = "BOTTOM_RIGHT_CORNER";
    OverlayWidgetPositionPreference2[OverlayWidgetPositionPreference2["TOP_CENTER"] = 2] = "TOP_CENTER";
  })(OverlayWidgetPositionPreference || (OverlayWidgetPositionPreference = {}));
  var OverviewRulerLane$1;
  (function(OverviewRulerLane2) {
    OverviewRulerLane2[OverviewRulerLane2["Left"] = 1] = "Left";
    OverviewRulerLane2[OverviewRulerLane2["Center"] = 2] = "Center";
    OverviewRulerLane2[OverviewRulerLane2["Right"] = 4] = "Right";
    OverviewRulerLane2[OverviewRulerLane2["Full"] = 7] = "Full";
  })(OverviewRulerLane$1 || (OverviewRulerLane$1 = {}));
  var PartialAcceptTriggerKind;
  (function(PartialAcceptTriggerKind2) {
    PartialAcceptTriggerKind2[PartialAcceptTriggerKind2["Word"] = 0] = "Word";
    PartialAcceptTriggerKind2[PartialAcceptTriggerKind2["Line"] = 1] = "Line";
    PartialAcceptTriggerKind2[PartialAcceptTriggerKind2["Suggest"] = 2] = "Suggest";
  })(PartialAcceptTriggerKind || (PartialAcceptTriggerKind = {}));
  var PositionAffinity;
  (function(PositionAffinity2) {
    PositionAffinity2[PositionAffinity2["Left"] = 0] = "Left";
    PositionAffinity2[PositionAffinity2["Right"] = 1] = "Right";
    PositionAffinity2[PositionAffinity2["None"] = 2] = "None";
    PositionAffinity2[PositionAffinity2["LeftOfInjectedText"] = 3] = "LeftOfInjectedText";
    PositionAffinity2[PositionAffinity2["RightOfInjectedText"] = 4] = "RightOfInjectedText";
  })(PositionAffinity || (PositionAffinity = {}));
  var RenderLineNumbersType;
  (function(RenderLineNumbersType2) {
    RenderLineNumbersType2[RenderLineNumbersType2["Off"] = 0] = "Off";
    RenderLineNumbersType2[RenderLineNumbersType2["On"] = 1] = "On";
    RenderLineNumbersType2[RenderLineNumbersType2["Relative"] = 2] = "Relative";
    RenderLineNumbersType2[RenderLineNumbersType2["Interval"] = 3] = "Interval";
    RenderLineNumbersType2[RenderLineNumbersType2["Custom"] = 4] = "Custom";
  })(RenderLineNumbersType || (RenderLineNumbersType = {}));
  var RenderMinimap;
  (function(RenderMinimap2) {
    RenderMinimap2[RenderMinimap2["None"] = 0] = "None";
    RenderMinimap2[RenderMinimap2["Text"] = 1] = "Text";
    RenderMinimap2[RenderMinimap2["Blocks"] = 2] = "Blocks";
  })(RenderMinimap || (RenderMinimap = {}));
  var ScrollType;
  (function(ScrollType2) {
    ScrollType2[ScrollType2["Smooth"] = 0] = "Smooth";
    ScrollType2[ScrollType2["Immediate"] = 1] = "Immediate";
  })(ScrollType || (ScrollType = {}));
  var ScrollbarVisibility;
  (function(ScrollbarVisibility2) {
    ScrollbarVisibility2[ScrollbarVisibility2["Auto"] = 1] = "Auto";
    ScrollbarVisibility2[ScrollbarVisibility2["Hidden"] = 2] = "Hidden";
    ScrollbarVisibility2[ScrollbarVisibility2["Visible"] = 3] = "Visible";
  })(ScrollbarVisibility || (ScrollbarVisibility = {}));
  var SelectionDirection;
  (function(SelectionDirection2) {
    SelectionDirection2[SelectionDirection2["LTR"] = 0] = "LTR";
    SelectionDirection2[SelectionDirection2["RTL"] = 1] = "RTL";
  })(SelectionDirection || (SelectionDirection = {}));
  var ShowLightbulbIconMode;
  (function(ShowLightbulbIconMode2) {
    ShowLightbulbIconMode2["Off"] = "off";
    ShowLightbulbIconMode2["OnCode"] = "onCode";
    ShowLightbulbIconMode2["On"] = "on";
  })(ShowLightbulbIconMode || (ShowLightbulbIconMode = {}));
  var SignatureHelpTriggerKind;
  (function(SignatureHelpTriggerKind2) {
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["Invoke"] = 1] = "Invoke";
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["TriggerCharacter"] = 2] = "TriggerCharacter";
    SignatureHelpTriggerKind2[SignatureHelpTriggerKind2["ContentChange"] = 3] = "ContentChange";
  })(SignatureHelpTriggerKind || (SignatureHelpTriggerKind = {}));
  var SymbolKind$1;
  (function(SymbolKind2) {
    SymbolKind2[SymbolKind2["File"] = 0] = "File";
    SymbolKind2[SymbolKind2["Module"] = 1] = "Module";
    SymbolKind2[SymbolKind2["Namespace"] = 2] = "Namespace";
    SymbolKind2[SymbolKind2["Package"] = 3] = "Package";
    SymbolKind2[SymbolKind2["Class"] = 4] = "Class";
    SymbolKind2[SymbolKind2["Method"] = 5] = "Method";
    SymbolKind2[SymbolKind2["Property"] = 6] = "Property";
    SymbolKind2[SymbolKind2["Field"] = 7] = "Field";
    SymbolKind2[SymbolKind2["Constructor"] = 8] = "Constructor";
    SymbolKind2[SymbolKind2["Enum"] = 9] = "Enum";
    SymbolKind2[SymbolKind2["Interface"] = 10] = "Interface";
    SymbolKind2[SymbolKind2["Function"] = 11] = "Function";
    SymbolKind2[SymbolKind2["Variable"] = 12] = "Variable";
    SymbolKind2[SymbolKind2["Constant"] = 13] = "Constant";
    SymbolKind2[SymbolKind2["String"] = 14] = "String";
    SymbolKind2[SymbolKind2["Number"] = 15] = "Number";
    SymbolKind2[SymbolKind2["Boolean"] = 16] = "Boolean";
    SymbolKind2[SymbolKind2["Array"] = 17] = "Array";
    SymbolKind2[SymbolKind2["Object"] = 18] = "Object";
    SymbolKind2[SymbolKind2["Key"] = 19] = "Key";
    SymbolKind2[SymbolKind2["Null"] = 20] = "Null";
    SymbolKind2[SymbolKind2["EnumMember"] = 21] = "EnumMember";
    SymbolKind2[SymbolKind2["Struct"] = 22] = "Struct";
    SymbolKind2[SymbolKind2["Event"] = 23] = "Event";
    SymbolKind2[SymbolKind2["Operator"] = 24] = "Operator";
    SymbolKind2[SymbolKind2["TypeParameter"] = 25] = "TypeParameter";
  })(SymbolKind$1 || (SymbolKind$1 = {}));
  var SymbolTag$1;
  (function(SymbolTag2) {
    SymbolTag2[SymbolTag2["Deprecated"] = 1] = "Deprecated";
  })(SymbolTag$1 || (SymbolTag$1 = {}));
  var TextDirection$1;
  (function(TextDirection2) {
    TextDirection2[TextDirection2["LTR"] = 0] = "LTR";
    TextDirection2[TextDirection2["RTL"] = 1] = "RTL";
  })(TextDirection$1 || (TextDirection$1 = {}));
  var TextEditorCursorBlinkingStyle;
  (function(TextEditorCursorBlinkingStyle2) {
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Hidden"] = 0] = "Hidden";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Blink"] = 1] = "Blink";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Smooth"] = 2] = "Smooth";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Phase"] = 3] = "Phase";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Expand"] = 4] = "Expand";
    TextEditorCursorBlinkingStyle2[TextEditorCursorBlinkingStyle2["Solid"] = 5] = "Solid";
  })(TextEditorCursorBlinkingStyle || (TextEditorCursorBlinkingStyle = {}));
  var TextEditorCursorStyle;
  (function(TextEditorCursorStyle2) {
    TextEditorCursorStyle2[TextEditorCursorStyle2["Line"] = 1] = "Line";
    TextEditorCursorStyle2[TextEditorCursorStyle2["Block"] = 2] = "Block";
    TextEditorCursorStyle2[TextEditorCursorStyle2["Underline"] = 3] = "Underline";
    TextEditorCursorStyle2[TextEditorCursorStyle2["LineThin"] = 4] = "LineThin";
    TextEditorCursorStyle2[TextEditorCursorStyle2["BlockOutline"] = 5] = "BlockOutline";
    TextEditorCursorStyle2[TextEditorCursorStyle2["UnderlineThin"] = 6] = "UnderlineThin";
  })(TextEditorCursorStyle || (TextEditorCursorStyle = {}));
  var TrackedRangeStickiness;
  (function(TrackedRangeStickiness2) {
    TrackedRangeStickiness2[TrackedRangeStickiness2["AlwaysGrowsWhenTypingAtEdges"] = 0] = "AlwaysGrowsWhenTypingAtEdges";
    TrackedRangeStickiness2[TrackedRangeStickiness2["NeverGrowsWhenTypingAtEdges"] = 1] = "NeverGrowsWhenTypingAtEdges";
    TrackedRangeStickiness2[TrackedRangeStickiness2["GrowsOnlyWhenTypingBefore"] = 2] = "GrowsOnlyWhenTypingBefore";
    TrackedRangeStickiness2[TrackedRangeStickiness2["GrowsOnlyWhenTypingAfter"] = 3] = "GrowsOnlyWhenTypingAfter";
  })(TrackedRangeStickiness || (TrackedRangeStickiness = {}));
  var WrappingIndent;
  (function(WrappingIndent2) {
    WrappingIndent2[WrappingIndent2["None"] = 0] = "None";
    WrappingIndent2[WrappingIndent2["Same"] = 1] = "Same";
    WrappingIndent2[WrappingIndent2["Indent"] = 2] = "Indent";
    WrappingIndent2[WrappingIndent2["DeepIndent"] = 3] = "DeepIndent";
  })(WrappingIndent || (WrappingIndent = {}));
  const _KeyMod = class _KeyMod {
    static chord(firstPart, secondPart) {
      return KeyChord(firstPart, secondPart);
    }
  };
  _KeyMod.CtrlCmd = 2048;
  _KeyMod.Shift = 1024;
  _KeyMod.Alt = 512;
  _KeyMod.WinCtrl = 256;
  let KeyMod = _KeyMod;
  function createMonacoBaseAPI() {
    return {
      editor: void 0,
      // undefined override expected here
      languages: void 0,
      // undefined override expected here
      CancellationTokenSource,
      Emitter,
      KeyCode,
      KeyMod,
      Position: Position$1,
      Range: Range$1,
      Selection,
      SelectionDirection,
      MarkerSeverity,
      MarkerTag,
      Uri: URI$2,
      Token
    };
  }
  var _c;
  class LinkedMap {
    constructor() {
      this[_c] = "LinkedMap";
      this._map = /* @__PURE__ */ new Map();
      this._head = void 0;
      this._tail = void 0;
      this._size = 0;
      this._state = 0;
    }
    clear() {
      this._map.clear();
      this._head = void 0;
      this._tail = void 0;
      this._size = 0;
      this._state++;
    }
    isEmpty() {
      return !this._head && !this._tail;
    }
    get size() {
      return this._size;
    }
    get first() {
      return this._head?.value;
    }
    get last() {
      return this._tail?.value;
    }
    has(key) {
      return this._map.has(key);
    }
    get(key, touch = 0) {
      const item = this._map.get(key);
      if (!item) {
        return void 0;
      }
      if (touch !== 0) {
        this.touch(item, touch);
      }
      return item.value;
    }
    set(key, value, touch = 0) {
      let item = this._map.get(key);
      if (item) {
        item.value = value;
        if (touch !== 0) {
          this.touch(item, touch);
        }
      } else {
        item = { key, value, next: void 0, previous: void 0 };
        switch (touch) {
          case 0:
            this.addItemLast(item);
            break;
          case 1:
            this.addItemFirst(item);
            break;
          case 2:
            this.addItemLast(item);
            break;
          default:
            this.addItemLast(item);
            break;
        }
        this._map.set(key, item);
        this._size++;
      }
      return this;
    }
    delete(key) {
      return !!this.remove(key);
    }
    remove(key) {
      const item = this._map.get(key);
      if (!item) {
        return void 0;
      }
      this._map.delete(key);
      this.removeItem(item);
      this._size--;
      return item.value;
    }
    shift() {
      if (!this._head && !this._tail) {
        return void 0;
      }
      if (!this._head || !this._tail) {
        throw new Error("Invalid list");
      }
      const item = this._head;
      this._map.delete(item.key);
      this.removeItem(item);
      this._size--;
      return item.value;
    }
    forEach(callbackfn, thisArg) {
      const state = this._state;
      let current = this._head;
      while (current) {
        if (thisArg) {
          callbackfn.bind(thisArg)(current.value, current.key, this);
        } else {
          callbackfn(current.value, current.key, this);
        }
        if (this._state !== state) {
          throw new Error(`LinkedMap got modified during iteration.`);
        }
        current = current.next;
      }
    }
    keys() {
      const map = this;
      const state = this._state;
      let current = this._head;
      const iterator = {
        [Symbol.iterator]() {
          return iterator;
        },
        next() {
          if (map._state !== state) {
            throw new Error(`LinkedMap got modified during iteration.`);
          }
          if (current) {
            const result = { value: current.key, done: false };
            current = current.next;
            return result;
          } else {
            return { value: void 0, done: true };
          }
        }
      };
      return iterator;
    }
    values() {
      const map = this;
      const state = this._state;
      let current = this._head;
      const iterator = {
        [Symbol.iterator]() {
          return iterator;
        },
        next() {
          if (map._state !== state) {
            throw new Error(`LinkedMap got modified during iteration.`);
          }
          if (current) {
            const result = { value: current.value, done: false };
            current = current.next;
            return result;
          } else {
            return { value: void 0, done: true };
          }
        }
      };
      return iterator;
    }
    entries() {
      const map = this;
      const state = this._state;
      let current = this._head;
      const iterator = {
        [Symbol.iterator]() {
          return iterator;
        },
        next() {
          if (map._state !== state) {
            throw new Error(`LinkedMap got modified during iteration.`);
          }
          if (current) {
            const result = { value: [current.key, current.value], done: false };
            current = current.next;
            return result;
          } else {
            return { value: void 0, done: true };
          }
        }
      };
      return iterator;
    }
    [(_c = Symbol.toStringTag, Symbol.iterator)]() {
      return this.entries();
    }
    trimOld(newSize) {
      if (newSize >= this.size) {
        return;
      }
      if (newSize === 0) {
        this.clear();
        return;
      }
      let current = this._head;
      let currentSize = this.size;
      while (current && currentSize > newSize) {
        this._map.delete(current.key);
        current = current.next;
        currentSize--;
      }
      this._head = current;
      this._size = currentSize;
      if (current) {
        current.previous = void 0;
      }
      this._state++;
    }
    trimNew(newSize) {
      if (newSize >= this.size) {
        return;
      }
      if (newSize === 0) {
        this.clear();
        return;
      }
      let current = this._tail;
      let currentSize = this.size;
      while (current && currentSize > newSize) {
        this._map.delete(current.key);
        current = current.previous;
        currentSize--;
      }
      this._tail = current;
      this._size = currentSize;
      if (current) {
        current.next = void 0;
      }
      this._state++;
    }
    addItemFirst(item) {
      if (!this._head && !this._tail) {
        this._tail = item;
      } else if (!this._head) {
        throw new Error("Invalid list");
      } else {
        item.next = this._head;
        this._head.previous = item;
      }
      this._head = item;
      this._state++;
    }
    addItemLast(item) {
      if (!this._head && !this._tail) {
        this._head = item;
      } else if (!this._tail) {
        throw new Error("Invalid list");
      } else {
        item.previous = this._tail;
        this._tail.next = item;
      }
      this._tail = item;
      this._state++;
    }
    removeItem(item) {
      if (item === this._head && item === this._tail) {
        this._head = void 0;
        this._tail = void 0;
      } else if (item === this._head) {
        if (!item.next) {
          throw new Error("Invalid list");
        }
        item.next.previous = void 0;
        this._head = item.next;
      } else if (item === this._tail) {
        if (!item.previous) {
          throw new Error("Invalid list");
        }
        item.previous.next = void 0;
        this._tail = item.previous;
      } else {
        const next = item.next;
        const previous = item.previous;
        if (!next || !previous) {
          throw new Error("Invalid list");
        }
        next.previous = previous;
        previous.next = next;
      }
      item.next = void 0;
      item.previous = void 0;
      this._state++;
    }
    touch(item, touch) {
      if (!this._head || !this._tail) {
        throw new Error("Invalid list");
      }
      if (touch !== 1 && touch !== 2) {
        return;
      }
      if (touch === 1) {
        if (item === this._head) {
          return;
        }
        const next = item.next;
        const previous = item.previous;
        if (item === this._tail) {
          previous.next = void 0;
          this._tail = previous;
        } else {
          next.previous = previous;
          previous.next = next;
        }
        item.previous = void 0;
        item.next = this._head;
        this._head.previous = item;
        this._head = item;
        this._state++;
      } else if (touch === 2) {
        if (item === this._tail) {
          return;
        }
        const next = item.next;
        const previous = item.previous;
        if (item === this._head) {
          next.previous = void 0;
          this._head = next;
        } else {
          next.previous = previous;
          previous.next = next;
        }
        item.next = void 0;
        item.previous = this._tail;
        this._tail.next = item;
        this._tail = item;
        this._state++;
      }
    }
    toJSON() {
      const data = [];
      this.forEach((value, key) => {
        data.push([key, value]);
      });
      return data;
    }
    fromJSON(data) {
      this.clear();
      for (const [key, value] of data) {
        this.set(key, value);
      }
    }
  }
  class Cache extends LinkedMap {
    constructor(limit, ratio = 1) {
      super();
      this._limit = limit;
      this._ratio = Math.min(Math.max(0, ratio), 1);
    }
    get limit() {
      return this._limit;
    }
    set limit(limit) {
      this._limit = limit;
      this.checkTrim();
    }
    get(key, touch = 2) {
      return super.get(key, touch);
    }
    peek(key) {
      return super.get(
        key,
        0
        /* Touch.None */
      );
    }
    set(key, value) {
      super.set(
        key,
        value,
        2
        /* Touch.AsNew */
      );
      return this;
    }
    checkTrim() {
      if (this.size > this._limit) {
        this.trim(Math.round(this._limit * this._ratio));
      }
    }
  }
  class LRUCache extends Cache {
    constructor(limit, ratio = 1) {
      super(limit, ratio);
    }
    trim(newSize) {
      this.trimOld(newSize);
    }
    set(key, value) {
      super.set(key, value);
      this.checkTrim();
      return this;
    }
  }
  class SetMap {
    constructor() {
      this.map = /* @__PURE__ */ new Map();
    }
    add(key, value) {
      let values = this.map.get(key);
      if (!values) {
        values = /* @__PURE__ */ new Set();
        this.map.set(key, values);
      }
      values.add(value);
    }
    delete(key, value) {
      const values = this.map.get(key);
      if (!values) {
        return;
      }
      values.delete(value);
      if (values.size === 0) {
        this.map.delete(key);
      }
    }
    forEach(key, fn) {
      const values = this.map.get(key);
      if (!values) {
        return;
      }
      values.forEach(fn);
    }
  }
  new LRUCache(10);
  var OverviewRulerLane;
  (function(OverviewRulerLane2) {
    OverviewRulerLane2[OverviewRulerLane2["Left"] = 1] = "Left";
    OverviewRulerLane2[OverviewRulerLane2["Center"] = 2] = "Center";
    OverviewRulerLane2[OverviewRulerLane2["Right"] = 4] = "Right";
    OverviewRulerLane2[OverviewRulerLane2["Full"] = 7] = "Full";
  })(OverviewRulerLane || (OverviewRulerLane = {}));
  var GlyphMarginLane;
  (function(GlyphMarginLane2) {
    GlyphMarginLane2[GlyphMarginLane2["Left"] = 1] = "Left";
    GlyphMarginLane2[GlyphMarginLane2["Center"] = 2] = "Center";
    GlyphMarginLane2[GlyphMarginLane2["Right"] = 3] = "Right";
  })(GlyphMarginLane || (GlyphMarginLane = {}));
  var TextDirection;
  (function(TextDirection2) {
    TextDirection2[TextDirection2["LTR"] = 0] = "LTR";
    TextDirection2[TextDirection2["RTL"] = 1] = "RTL";
  })(TextDirection || (TextDirection = {}));
  var InjectedTextCursorStops;
  (function(InjectedTextCursorStops2) {
    InjectedTextCursorStops2[InjectedTextCursorStops2["Both"] = 0] = "Both";
    InjectedTextCursorStops2[InjectedTextCursorStops2["Right"] = 1] = "Right";
    InjectedTextCursorStops2[InjectedTextCursorStops2["Left"] = 2] = "Left";
    InjectedTextCursorStops2[InjectedTextCursorStops2["None"] = 3] = "None";
  })(InjectedTextCursorStops || (InjectedTextCursorStops = {}));
  function isMultilineRegexSource(searchString) {
    if (!searchString || searchString.length === 0) {
      return false;
    }
    for (let i = 0, len = searchString.length; i < len; i++) {
      const chCode = searchString.charCodeAt(i);
      if (chCode === 10) {
        return true;
      }
      if (chCode === 92) {
        i++;
        if (i >= len) {
          break;
        }
        const nextChCode = searchString.charCodeAt(i);
        if (nextChCode === 110 || nextChCode === 114 || nextChCode === 87) {
          return true;
        }
      }
    }
    return false;
  }
  function leftIsWordBounday(wordSeparators, text, textLength, matchStartIndex, matchLength) {
    if (matchStartIndex === 0) {
      return true;
    }
    const charBefore = text.charCodeAt(matchStartIndex - 1);
    if (wordSeparators.get(charBefore) !== 0) {
      return true;
    }
    if (charBefore === 13 || charBefore === 10) {
      return true;
    }
    if (matchLength > 0) {
      const firstCharInMatch = text.charCodeAt(matchStartIndex);
      if (wordSeparators.get(firstCharInMatch) !== 0) {
        return true;
      }
    }
    return false;
  }
  function rightIsWordBounday(wordSeparators, text, textLength, matchStartIndex, matchLength) {
    if (matchStartIndex + matchLength === textLength) {
      return true;
    }
    const charAfter = text.charCodeAt(matchStartIndex + matchLength);
    if (wordSeparators.get(charAfter) !== 0) {
      return true;
    }
    if (charAfter === 13 || charAfter === 10) {
      return true;
    }
    if (matchLength > 0) {
      const lastCharInMatch = text.charCodeAt(matchStartIndex + matchLength - 1);
      if (wordSeparators.get(lastCharInMatch) !== 0) {
        return true;
      }
    }
    return false;
  }
  function isValidMatch(wordSeparators, text, textLength, matchStartIndex, matchLength) {
    return leftIsWordBounday(wordSeparators, text, textLength, matchStartIndex, matchLength) && rightIsWordBounday(wordSeparators, text, textLength, matchStartIndex, matchLength);
  }
  class Searcher {
    constructor(wordSeparators, searchRegex) {
      this._wordSeparators = wordSeparators;
      this._searchRegex = searchRegex;
      this._prevMatchStartIndex = -1;
      this._prevMatchLength = 0;
    }
    reset(lastIndex) {
      this._searchRegex.lastIndex = lastIndex;
      this._prevMatchStartIndex = -1;
      this._prevMatchLength = 0;
    }
    next(text) {
      const textLength = text.length;
      let m;
      do {
        if (this._prevMatchStartIndex + this._prevMatchLength === textLength) {
          return null;
        }
        m = this._searchRegex.exec(text);
        if (!m) {
          return null;
        }
        const matchStartIndex = m.index;
        const matchLength = m[0].length;
        if (matchStartIndex === this._prevMatchStartIndex && matchLength === this._prevMatchLength) {
          if (matchLength === 0) {
            if (getNextCodePoint(text, textLength, this._searchRegex.lastIndex) > 65535) {
              this._searchRegex.lastIndex += 2;
            } else {
              this._searchRegex.lastIndex += 1;
            }
            continue;
          }
          return null;
        }
        this._prevMatchStartIndex = matchStartIndex;
        this._prevMatchLength = matchLength;
        if (!this._wordSeparators || isValidMatch(this._wordSeparators, text, textLength, matchStartIndex, matchLength)) {
          return m;
        }
      } while (m);
      return null;
    }
  }
  const USUAL_WORD_SEPARATORS = "`~!@#$%^&*()-=+[{]}\\|;:'\",.<>/?";
  function createWordRegExp(allowInWords = "") {
    let source = "(-?\\d*\\.\\d\\w*)|([^";
    for (const sep of USUAL_WORD_SEPARATORS) {
      if (allowInWords.indexOf(sep) >= 0) {
        continue;
      }
      source += "\\" + sep;
    }
    source += "\\s]+)";
    return new RegExp(source, "g");
  }
  const DEFAULT_WORD_REGEXP = createWordRegExp();
  function ensureValidWordDefinition(wordDefinition) {
    let result = DEFAULT_WORD_REGEXP;
    if (wordDefinition && wordDefinition instanceof RegExp) {
      if (!wordDefinition.global) {
        let flags = "g";
        if (wordDefinition.ignoreCase) {
          flags += "i";
        }
        if (wordDefinition.multiline) {
          flags += "m";
        }
        if (wordDefinition.unicode) {
          flags += "u";
        }
        result = new RegExp(wordDefinition.source, flags);
      } else {
        result = wordDefinition;
      }
    }
    result.lastIndex = 0;
    return result;
  }
  const _defaultConfig = new LinkedList();
  _defaultConfig.unshift({
    maxLen: 1e3,
    windowSize: 15,
    timeBudget: 150
  });
  function getWordAtText(column, wordDefinition, text, textOffset, config) {
    wordDefinition = ensureValidWordDefinition(wordDefinition);
    if (!config) {
      config = Iterable.first(_defaultConfig);
    }
    if (text.length > config.maxLen) {
      let start2 = column - config.maxLen / 2;
      if (start2 < 0) {
        start2 = 0;
      } else {
        textOffset += start2;
      }
      text = text.substring(start2, column + config.maxLen / 2);
      return getWordAtText(column, wordDefinition, text, textOffset, config);
    }
    const t1 = Date.now();
    const pos = column - 1 - textOffset;
    let prevRegexIndex = -1;
    let match = null;
    for (let i = 1; ; i++) {
      if (Date.now() - t1 >= config.timeBudget) {
        break;
      }
      const regexIndex = pos - config.windowSize * i;
      wordDefinition.lastIndex = Math.max(0, regexIndex);
      const thisMatch = _findRegexMatchEnclosingPosition(wordDefinition, text, pos, prevRegexIndex);
      if (!thisMatch && match) {
        break;
      }
      match = thisMatch;
      if (regexIndex <= 0) {
        break;
      }
      prevRegexIndex = regexIndex;
    }
    if (match) {
      const result = {
        word: match[0],
        startColumn: textOffset + 1 + match.index,
        endColumn: textOffset + 1 + match.index + match[0].length
      };
      wordDefinition.lastIndex = 0;
      return result;
    }
    return null;
  }
  function _findRegexMatchEnclosingPosition(wordDefinition, text, pos, stopPos) {
    let match;
    while (match = wordDefinition.exec(text)) {
      const matchIndex = match.index || 0;
      if (matchIndex <= pos && wordDefinition.lastIndex >= pos) {
        return match;
      } else if (stopPos > 0 && matchIndex > stopPos) {
        return null;
      }
    }
    return null;
  }
  class UnicodeTextModelHighlighter {
    static computeUnicodeHighlights(model, options, range) {
      const startLine = range ? range.startLineNumber : 1;
      const endLine = range ? range.endLineNumber : model.getLineCount();
      const codePointHighlighter = new CodePointHighlighter(options);
      const candidates = codePointHighlighter.getCandidateCodePoints();
      let regex;
      if (candidates === "allNonBasicAscii") {
        regex = new RegExp("[^\\t\\n\\r\\x20-\\x7E]", "g");
      } else {
        regex = new RegExp(`${buildRegExpCharClassExpr(Array.from(candidates))}`, "g");
      }
      const searcher = new Searcher(null, regex);
      const ranges = [];
      let hasMore = false;
      let m;
      let ambiguousCharacterCount = 0;
      let invisibleCharacterCount = 0;
      let nonBasicAsciiCharacterCount = 0;
      forLoop: for (let lineNumber = startLine, lineCount = endLine; lineNumber <= lineCount; lineNumber++) {
        const lineContent = model.getLineContent(lineNumber);
        const lineLength = lineContent.length;
        searcher.reset(0);
        do {
          m = searcher.next(lineContent);
          if (m) {
            let startIndex = m.index;
            let endIndex = m.index + m[0].length;
            if (startIndex > 0) {
              const charCodeBefore = lineContent.charCodeAt(startIndex - 1);
              if (isHighSurrogate(charCodeBefore)) {
                startIndex--;
              }
            }
            if (endIndex + 1 < lineLength) {
              const charCodeBefore = lineContent.charCodeAt(endIndex - 1);
              if (isHighSurrogate(charCodeBefore)) {
                endIndex++;
              }
            }
            const str = lineContent.substring(startIndex, endIndex);
            let word = getWordAtText(startIndex + 1, DEFAULT_WORD_REGEXP, lineContent, 0);
            if (word && word.endColumn <= startIndex + 1) {
              word = null;
            }
            const highlightReason = codePointHighlighter.shouldHighlightNonBasicASCII(str, word ? word.word : null);
            if (highlightReason !== 0) {
              if (highlightReason === 3) {
                ambiguousCharacterCount++;
              } else if (highlightReason === 2) {
                invisibleCharacterCount++;
              } else if (highlightReason === 1) {
                nonBasicAsciiCharacterCount++;
              } else {
                assertNever();
              }
              const MAX_RESULT_LENGTH = 1e3;
              if (ranges.length >= MAX_RESULT_LENGTH) {
                hasMore = true;
                break forLoop;
              }
              ranges.push(new Range$1(lineNumber, startIndex + 1, lineNumber, endIndex + 1));
            }
          }
        } while (m);
      }
      return {
        ranges,
        hasMore,
        ambiguousCharacterCount,
        invisibleCharacterCount,
        nonBasicAsciiCharacterCount
      };
    }
    static computeUnicodeHighlightReason(char, options) {
      const codePointHighlighter = new CodePointHighlighter(options);
      const reason = codePointHighlighter.shouldHighlightNonBasicASCII(char, null);
      switch (reason) {
        case 0:
          return null;
        case 2:
          return {
            kind: 1
            /* UnicodeHighlighterReasonKind.Invisible */
          };
        case 3: {
          const codePoint = char.codePointAt(0);
          const primaryConfusable = codePointHighlighter.ambiguousCharacters.getPrimaryConfusable(codePoint);
          const notAmbiguousInLocales = AmbiguousCharacters.getLocales().filter((l) => !AmbiguousCharacters.getInstance(/* @__PURE__ */ new Set([...options.allowedLocales, l])).isAmbiguous(codePoint));
          return { kind: 0, confusableWith: String.fromCodePoint(primaryConfusable), notAmbiguousInLocales };
        }
        case 1:
          return {
            kind: 2
            /* UnicodeHighlighterReasonKind.NonBasicAscii */
          };
      }
    }
  }
  function buildRegExpCharClassExpr(codePoints, flags) {
    const src = `[${escapeRegExpCharacters(codePoints.map((i) => String.fromCodePoint(i)).join(""))}]`;
    return src;
  }
  class CodePointHighlighter {
    constructor(options) {
      this.options = options;
      this.allowedCodePoints = new Set(options.allowedCodePoints);
      this.ambiguousCharacters = AmbiguousCharacters.getInstance(new Set(options.allowedLocales));
    }
    getCandidateCodePoints() {
      if (this.options.nonBasicASCII) {
        return "allNonBasicAscii";
      }
      const set = /* @__PURE__ */ new Set();
      if (this.options.invisibleCharacters) {
        for (const cp of InvisibleCharacters.codePoints) {
          if (!isAllowedInvisibleCharacter(String.fromCodePoint(cp))) {
            set.add(cp);
          }
        }
      }
      if (this.options.ambiguousCharacters) {
        for (const cp of this.ambiguousCharacters.getConfusableCodePoints()) {
          set.add(cp);
        }
      }
      for (const cp of this.allowedCodePoints) {
        set.delete(cp);
      }
      return set;
    }
    shouldHighlightNonBasicASCII(character, wordContext) {
      const codePoint = character.codePointAt(0);
      if (this.allowedCodePoints.has(codePoint)) {
        return 0;
      }
      if (this.options.nonBasicASCII) {
        return 1;
      }
      let hasBasicASCIICharacters = false;
      let hasNonConfusableNonBasicAsciiCharacter = false;
      if (wordContext) {
        for (const char of wordContext) {
          const codePoint2 = char.codePointAt(0);
          const isBasicASCII$1 = isBasicASCII(char);
          hasBasicASCIICharacters = hasBasicASCIICharacters || isBasicASCII$1;
          if (!isBasicASCII$1 && !this.ambiguousCharacters.isAmbiguous(codePoint2) && !InvisibleCharacters.isInvisibleCharacter(codePoint2)) {
            hasNonConfusableNonBasicAsciiCharacter = true;
          }
        }
      }
      if (
        /* Don't allow mixing weird looking characters with ASCII */
        !hasBasicASCIICharacters && /* Is there an obviously weird looking character? */
        hasNonConfusableNonBasicAsciiCharacter
      ) {
        return 0;
      }
      if (this.options.invisibleCharacters) {
        if (!isAllowedInvisibleCharacter(character) && InvisibleCharacters.isInvisibleCharacter(codePoint)) {
          return 2;
        }
      }
      if (this.options.ambiguousCharacters) {
        if (this.ambiguousCharacters.isAmbiguous(codePoint)) {
          return 3;
        }
      }
      return 0;
    }
  }
  function isAllowedInvisibleCharacter(character) {
    return character === " " || character === "\n" || character === "	";
  }
  class LinesDiff {
    constructor(changes, moves, hitTimeout) {
      this.changes = changes;
      this.moves = moves;
      this.hitTimeout = hitTimeout;
    }
  }
  class MovedText {
    constructor(lineRangeMapping, changes) {
      this.lineRangeMapping = lineRangeMapping;
      this.changes = changes;
    }
  }
  function equals(one, other, itemEquals = (a, b) => a === b) {
    if (one === other) {
      return true;
    }
    if (!one || !other) {
      return false;
    }
    if (one.length !== other.length) {
      return false;
    }
    for (let i = 0, len = one.length; i < len; i++) {
      if (!itemEquals(one[i], other[i])) {
        return false;
      }
    }
    return true;
  }
  function* groupAdjacentBy(items, shouldBeGrouped) {
    let currentGroup;
    let last;
    for (const item of items) {
      if (last !== void 0 && shouldBeGrouped(last, item)) {
        currentGroup.push(item);
      } else {
        if (currentGroup) {
          yield currentGroup;
        }
        currentGroup = [item];
      }
      last = item;
    }
    if (currentGroup) {
      yield currentGroup;
    }
  }
  function forEachAdjacent(arr, f) {
    for (let i = 0; i <= arr.length; i++) {
      f(i === 0 ? void 0 : arr[i - 1], i === arr.length ? void 0 : arr[i]);
    }
  }
  function forEachWithNeighbors(arr, f) {
    for (let i = 0; i < arr.length; i++) {
      f(i === 0 ? void 0 : arr[i - 1], arr[i], i + 1 === arr.length ? void 0 : arr[i + 1]);
    }
  }
  function pushMany(arr, items) {
    for (const item of items) {
      arr.push(item);
    }
  }
  var CompareResult;
  (function(CompareResult2) {
    function isLessThan(result) {
      return result < 0;
    }
    CompareResult2.isLessThan = isLessThan;
    function isLessThanOrEqual(result) {
      return result <= 0;
    }
    CompareResult2.isLessThanOrEqual = isLessThanOrEqual;
    function isGreaterThan(result) {
      return result > 0;
    }
    CompareResult2.isGreaterThan = isGreaterThan;
    function isNeitherLessOrGreaterThan(result) {
      return result === 0;
    }
    CompareResult2.isNeitherLessOrGreaterThan = isNeitherLessOrGreaterThan;
    CompareResult2.greaterThan = 1;
    CompareResult2.lessThan = -1;
    CompareResult2.neitherLessOrGreaterThan = 0;
  })(CompareResult || (CompareResult = {}));
  function compareBy(selector, comparator) {
    return (a, b) => comparator(selector(a), selector(b));
  }
  const numberComparator = (a, b) => a - b;
  function reverseOrder(comparator) {
    return (a, b) => -comparator(a, b);
  }
  const _CallbackIterable = class _CallbackIterable {
    constructor(iterate) {
      this.iterate = iterate;
    }
    toArray() {
      const result = [];
      this.iterate((item) => {
        result.push(item);
        return true;
      });
      return result;
    }
    filter(predicate) {
      return new _CallbackIterable((cb) => this.iterate((item) => predicate(item) ? cb(item) : true));
    }
    map(mapFn) {
      return new _CallbackIterable((cb) => this.iterate((item) => cb(mapFn(item))));
    }
    findLast(predicate) {
      let result;
      this.iterate((item) => {
        if (predicate(item)) {
          result = item;
        }
        return true;
      });
      return result;
    }
    findLastMaxBy(comparator) {
      let result;
      let first = true;
      this.iterate((item) => {
        if (first || CompareResult.isGreaterThan(comparator(item, result))) {
          first = false;
          result = item;
        }
        return true;
      });
      return result;
    }
  };
  _CallbackIterable.empty = new _CallbackIterable((_callback) => {
  });
  let CallbackIterable = _CallbackIterable;
  class OffsetRange {
    static fromTo(start2, endExclusive) {
      return new OffsetRange(start2, endExclusive);
    }
    static addRange(range, sortedRanges) {
      let i = 0;
      while (i < sortedRanges.length && sortedRanges[i].endExclusive < range.start) {
        i++;
      }
      let j = i;
      while (j < sortedRanges.length && sortedRanges[j].start <= range.endExclusive) {
        j++;
      }
      if (i === j) {
        sortedRanges.splice(i, 0, range);
      } else {
        const start2 = Math.min(range.start, sortedRanges[i].start);
        const end = Math.max(range.endExclusive, sortedRanges[j - 1].endExclusive);
        sortedRanges.splice(i, j - i, new OffsetRange(start2, end));
      }
    }
    static tryCreate(start2, endExclusive) {
      if (start2 > endExclusive) {
        return void 0;
      }
      return new OffsetRange(start2, endExclusive);
    }
    static ofLength(length) {
      return new OffsetRange(0, length);
    }
    static ofStartAndLength(start2, length) {
      return new OffsetRange(start2, start2 + length);
    }
    static emptyAt(offset) {
      return new OffsetRange(offset, offset);
    }
    constructor(start2, endExclusive) {
      this.start = start2;
      this.endExclusive = endExclusive;
      if (start2 > endExclusive) {
        throw new BugIndicatingError(`Invalid range: ${this.toString()}`);
      }
    }
    get isEmpty() {
      return this.start === this.endExclusive;
    }
    delta(offset) {
      return new OffsetRange(this.start + offset, this.endExclusive + offset);
    }
    deltaStart(offset) {
      return new OffsetRange(this.start + offset, this.endExclusive);
    }
    deltaEnd(offset) {
      return new OffsetRange(this.start, this.endExclusive + offset);
    }
    get length() {
      return this.endExclusive - this.start;
    }
    toString() {
      return `[${this.start}, ${this.endExclusive})`;
    }
    equals(other) {
      return this.start === other.start && this.endExclusive === other.endExclusive;
    }
    contains(offset) {
      return this.start <= offset && offset < this.endExclusive;
    }
    /**
     * for all numbers n: range1.contains(n) or range2.contains(n) => range1.join(range2).contains(n)
     * The joined range is the smallest range that contains both ranges.
     */
    join(other) {
      return new OffsetRange(Math.min(this.start, other.start), Math.max(this.endExclusive, other.endExclusive));
    }
    /**
     * for all numbers n: range1.contains(n) and range2.contains(n) <=> range1.intersect(range2).contains(n)
     *
     * The resulting range is empty if the ranges do not intersect, but touch.
     * If the ranges don't even touch, the result is undefined.
     */
    intersect(other) {
      const start2 = Math.max(this.start, other.start);
      const end = Math.min(this.endExclusive, other.endExclusive);
      if (start2 <= end) {
        return new OffsetRange(start2, end);
      }
      return void 0;
    }
    intersectionLength(range) {
      const start2 = Math.max(this.start, range.start);
      const end = Math.min(this.endExclusive, range.endExclusive);
      return Math.max(0, end - start2);
    }
    intersects(other) {
      const start2 = Math.max(this.start, other.start);
      const end = Math.min(this.endExclusive, other.endExclusive);
      return start2 < end;
    }
    intersectsOrTouches(other) {
      const start2 = Math.max(this.start, other.start);
      const end = Math.min(this.endExclusive, other.endExclusive);
      return start2 <= end;
    }
    isBefore(other) {
      return this.endExclusive <= other.start;
    }
    isAfter(other) {
      return this.start >= other.endExclusive;
    }
    slice(arr) {
      return arr.slice(this.start, this.endExclusive);
    }
    substring(str) {
      return str.substring(this.start, this.endExclusive);
    }
    /**
     * Returns the given value if it is contained in this instance, otherwise the closest value that is contained.
     * The range must not be empty.
     */
    clip(value) {
      if (this.isEmpty) {
        throw new BugIndicatingError(`Invalid clipping range: ${this.toString()}`);
      }
      return Math.max(this.start, Math.min(this.endExclusive - 1, value));
    }
    /**
     * Returns `r := value + k * length` such that `r` is contained in this range.
     * The range must not be empty.
     *
     * E.g. `[5, 10).clipCyclic(10) === 5`, `[5, 10).clipCyclic(11) === 6` and `[5, 10).clipCyclic(4) === 9`.
     */
    clipCyclic(value) {
      if (this.isEmpty) {
        throw new BugIndicatingError(`Invalid clipping range: ${this.toString()}`);
      }
      if (value < this.start) {
        return this.endExclusive - (this.start - value) % this.length;
      }
      if (value >= this.endExclusive) {
        return this.start + (value - this.start) % this.length;
      }
      return value;
    }
    forEach(f) {
      for (let i = this.start; i < this.endExclusive; i++) {
        f(i);
      }
    }
    /**
     * this: [ 5, 10), range: [10, 15) => [5, 15)]
     * Throws if the ranges are not touching.
    */
    joinRightTouching(range) {
      if (this.endExclusive !== range.start) {
        throw new BugIndicatingError(`Invalid join: ${this.toString()} and ${range.toString()}`);
      }
      return new OffsetRange(this.start, range.endExclusive);
    }
  }
  function findLastMonotonous(array, predicate) {
    const idx = findLastIdxMonotonous(array, predicate);
    return idx === -1 ? void 0 : array[idx];
  }
  function findLastIdxMonotonous(array, predicate, startIdx = 0, endIdxEx = array.length) {
    let i = startIdx;
    let j = endIdxEx;
    while (i < j) {
      const k = Math.floor((i + j) / 2);
      if (predicate(array[k])) {
        i = k + 1;
      } else {
        j = k;
      }
    }
    return i - 1;
  }
  function findFirstMonotonous(array, predicate) {
    const idx = findFirstIdxMonotonousOrArrLen(array, predicate);
    return idx === array.length ? void 0 : array[idx];
  }
  function findFirstIdxMonotonousOrArrLen(array, predicate, startIdx = 0, endIdxEx = array.length) {
    let i = startIdx;
    let j = endIdxEx;
    while (i < j) {
      const k = Math.floor((i + j) / 2);
      if (predicate(array[k])) {
        j = k;
      } else {
        i = k + 1;
      }
    }
    return i;
  }
  const _MonotonousArray = class _MonotonousArray {
    constructor(_array) {
      this._array = _array;
      this._findLastMonotonousLastIdx = 0;
    }
    /**
     * The predicate must be monotonous, i.e. `arr.map(predicate)` must be like `[true, ..., true, false, ..., false]`!
     * For subsequent calls, current predicate must be weaker than (or equal to) the previous predicate, i.e. more entries must be `true`.
     */
    findLastMonotonous(predicate) {
      if (_MonotonousArray.assertInvariants) {
        if (this._prevFindLastPredicate) {
          for (const item of this._array) {
            if (this._prevFindLastPredicate(item) && !predicate(item)) {
              throw new Error("MonotonousArray: current predicate must be weaker than (or equal to) the previous predicate.");
            }
          }
        }
        this._prevFindLastPredicate = predicate;
      }
      const idx = findLastIdxMonotonous(this._array, predicate, this._findLastMonotonousLastIdx);
      this._findLastMonotonousLastIdx = idx + 1;
      return idx === -1 ? void 0 : this._array[idx];
    }
  };
  _MonotonousArray.assertInvariants = false;
  let MonotonousArray = _MonotonousArray;
  const _LineRange = class _LineRange {
    static ofLength(startLineNumber, length) {
      return new _LineRange(startLineNumber, startLineNumber + length);
    }
    static fromRange(range) {
      return new _LineRange(range.startLineNumber, range.endLineNumber);
    }
    static fromRangeInclusive(range) {
      return new _LineRange(range.startLineNumber, range.endLineNumber + 1);
    }
    /**
     * @param lineRanges An array of arrays of of sorted line ranges.
     */
    static joinMany(lineRanges) {
      if (lineRanges.length === 0) {
        return [];
      }
      let result = new LineRangeSet(lineRanges[0].slice());
      for (let i = 1; i < lineRanges.length; i++) {
        result = result.getUnion(new LineRangeSet(lineRanges[i].slice()));
      }
      return result.ranges;
    }
    static join(lineRanges) {
      if (lineRanges.length === 0) {
        throw new BugIndicatingError("lineRanges cannot be empty");
      }
      let startLineNumber = lineRanges[0].startLineNumber;
      let endLineNumberExclusive = lineRanges[0].endLineNumberExclusive;
      for (let i = 1; i < lineRanges.length; i++) {
        startLineNumber = Math.min(startLineNumber, lineRanges[i].startLineNumber);
        endLineNumberExclusive = Math.max(endLineNumberExclusive, lineRanges[i].endLineNumberExclusive);
      }
      return new _LineRange(startLineNumber, endLineNumberExclusive);
    }
    /**
     * @internal
     */
    static deserialize(lineRange) {
      return new _LineRange(lineRange[0], lineRange[1]);
    }
    constructor(startLineNumber, endLineNumberExclusive) {
      if (startLineNumber > endLineNumberExclusive) {
        throw new BugIndicatingError(`startLineNumber ${startLineNumber} cannot be after endLineNumberExclusive ${endLineNumberExclusive}`);
      }
      this.startLineNumber = startLineNumber;
      this.endLineNumberExclusive = endLineNumberExclusive;
    }
    /**
     * Indicates if this line range contains the given line number.
     */
    contains(lineNumber) {
      return this.startLineNumber <= lineNumber && lineNumber < this.endLineNumberExclusive;
    }
    /**
     * Indicates if this line range is empty.
     */
    get isEmpty() {
      return this.startLineNumber === this.endLineNumberExclusive;
    }
    /**
     * Moves this line range by the given offset of line numbers.
     */
    delta(offset) {
      return new _LineRange(this.startLineNumber + offset, this.endLineNumberExclusive + offset);
    }
    deltaLength(offset) {
      return new _LineRange(this.startLineNumber, this.endLineNumberExclusive + offset);
    }
    /**
     * The number of lines this line range spans.
     */
    get length() {
      return this.endLineNumberExclusive - this.startLineNumber;
    }
    /**
     * Creates a line range that combines this and the given line range.
     */
    join(other) {
      return new _LineRange(Math.min(this.startLineNumber, other.startLineNumber), Math.max(this.endLineNumberExclusive, other.endLineNumberExclusive));
    }
    toString() {
      return `[${this.startLineNumber},${this.endLineNumberExclusive})`;
    }
    /**
     * The resulting range is empty if the ranges do not intersect, but touch.
     * If the ranges don't even touch, the result is undefined.
     */
    intersect(other) {
      const startLineNumber = Math.max(this.startLineNumber, other.startLineNumber);
      const endLineNumberExclusive = Math.min(this.endLineNumberExclusive, other.endLineNumberExclusive);
      if (startLineNumber <= endLineNumberExclusive) {
        return new _LineRange(startLineNumber, endLineNumberExclusive);
      }
      return void 0;
    }
    intersectsStrict(other) {
      return this.startLineNumber < other.endLineNumberExclusive && other.startLineNumber < this.endLineNumberExclusive;
    }
    intersectsOrTouches(other) {
      return this.startLineNumber <= other.endLineNumberExclusive && other.startLineNumber <= this.endLineNumberExclusive;
    }
    equals(b) {
      return this.startLineNumber === b.startLineNumber && this.endLineNumberExclusive === b.endLineNumberExclusive;
    }
    toInclusiveRange() {
      if (this.isEmpty) {
        return null;
      }
      return new Range$1(this.startLineNumber, 1, this.endLineNumberExclusive - 1, Number.MAX_SAFE_INTEGER);
    }
    /**
     * @deprecated Using this function is discouraged because it might lead to bugs: The end position is not guaranteed to be a valid position!
    */
    toExclusiveRange() {
      return new Range$1(this.startLineNumber, 1, this.endLineNumberExclusive, 1);
    }
    mapToLineArray(f) {
      const result = [];
      for (let lineNumber = this.startLineNumber; lineNumber < this.endLineNumberExclusive; lineNumber++) {
        result.push(f(lineNumber));
      }
      return result;
    }
    forEach(f) {
      for (let lineNumber = this.startLineNumber; lineNumber < this.endLineNumberExclusive; lineNumber++) {
        f(lineNumber);
      }
    }
    /**
     * @internal
     */
    serialize() {
      return [this.startLineNumber, this.endLineNumberExclusive];
    }
    /**
     * Converts this 1-based line range to a 0-based offset range (subtracts 1!).
     * @internal
     */
    toOffsetRange() {
      return new OffsetRange(this.startLineNumber - 1, this.endLineNumberExclusive - 1);
    }
    addMargin(marginTop, marginBottom) {
      return new _LineRange(this.startLineNumber - marginTop, this.endLineNumberExclusive + marginBottom);
    }
  };
  _LineRange.compareByStart = compareBy((l) => l.startLineNumber, numberComparator);
  let LineRange = _LineRange;
  class LineRangeSet {
    constructor(_normalizedRanges = []) {
      this._normalizedRanges = _normalizedRanges;
    }
    get ranges() {
      return this._normalizedRanges;
    }
    addRange(range) {
      if (range.length === 0) {
        return;
      }
      const joinRangeStartIdx = findFirstIdxMonotonousOrArrLen(this._normalizedRanges, (r) => r.endLineNumberExclusive >= range.startLineNumber);
      const joinRangeEndIdxExclusive = findLastIdxMonotonous(this._normalizedRanges, (r) => r.startLineNumber <= range.endLineNumberExclusive) + 1;
      if (joinRangeStartIdx === joinRangeEndIdxExclusive) {
        this._normalizedRanges.splice(joinRangeStartIdx, 0, range);
      } else if (joinRangeStartIdx === joinRangeEndIdxExclusive - 1) {
        const joinRange = this._normalizedRanges[joinRangeStartIdx];
        this._normalizedRanges[joinRangeStartIdx] = joinRange.join(range);
      } else {
        const joinRange = this._normalizedRanges[joinRangeStartIdx].join(this._normalizedRanges[joinRangeEndIdxExclusive - 1]).join(range);
        this._normalizedRanges.splice(joinRangeStartIdx, joinRangeEndIdxExclusive - joinRangeStartIdx, joinRange);
      }
    }
    contains(lineNumber) {
      const rangeThatStartsBeforeEnd = findLastMonotonous(this._normalizedRanges, (r) => r.startLineNumber <= lineNumber);
      return !!rangeThatStartsBeforeEnd && rangeThatStartsBeforeEnd.endLineNumberExclusive > lineNumber;
    }
    intersects(range) {
      const rangeThatStartsBeforeEnd = findLastMonotonous(this._normalizedRanges, (r) => r.startLineNumber < range.endLineNumberExclusive);
      return !!rangeThatStartsBeforeEnd && rangeThatStartsBeforeEnd.endLineNumberExclusive > range.startLineNumber;
    }
    getUnion(other) {
      if (this._normalizedRanges.length === 0) {
        return other;
      }
      if (other._normalizedRanges.length === 0) {
        return this;
      }
      const result = [];
      let i1 = 0;
      let i2 = 0;
      let current = null;
      while (i1 < this._normalizedRanges.length || i2 < other._normalizedRanges.length) {
        let next = null;
        if (i1 < this._normalizedRanges.length && i2 < other._normalizedRanges.length) {
          const lineRange1 = this._normalizedRanges[i1];
          const lineRange2 = other._normalizedRanges[i2];
          if (lineRange1.startLineNumber < lineRange2.startLineNumber) {
            next = lineRange1;
            i1++;
          } else {
            next = lineRange2;
            i2++;
          }
        } else if (i1 < this._normalizedRanges.length) {
          next = this._normalizedRanges[i1];
          i1++;
        } else {
          next = other._normalizedRanges[i2];
          i2++;
        }
        if (current === null) {
          current = next;
        } else {
          if (current.endLineNumberExclusive >= next.startLineNumber) {
            current = new LineRange(current.startLineNumber, Math.max(current.endLineNumberExclusive, next.endLineNumberExclusive));
          } else {
            result.push(current);
            current = next;
          }
        }
      }
      if (current !== null) {
        result.push(current);
      }
      return new LineRangeSet(result);
    }
    /**
     * Subtracts all ranges in this set from `range` and returns the result.
     */
    subtractFrom(range) {
      const joinRangeStartIdx = findFirstIdxMonotonousOrArrLen(this._normalizedRanges, (r) => r.endLineNumberExclusive >= range.startLineNumber);
      const joinRangeEndIdxExclusive = findLastIdxMonotonous(this._normalizedRanges, (r) => r.startLineNumber <= range.endLineNumberExclusive) + 1;
      if (joinRangeStartIdx === joinRangeEndIdxExclusive) {
        return new LineRangeSet([range]);
      }
      const result = [];
      let startLineNumber = range.startLineNumber;
      for (let i = joinRangeStartIdx; i < joinRangeEndIdxExclusive; i++) {
        const r = this._normalizedRanges[i];
        if (r.startLineNumber > startLineNumber) {
          result.push(new LineRange(startLineNumber, r.startLineNumber));
        }
        startLineNumber = r.endLineNumberExclusive;
      }
      if (startLineNumber < range.endLineNumberExclusive) {
        result.push(new LineRange(startLineNumber, range.endLineNumberExclusive));
      }
      return new LineRangeSet(result);
    }
    toString() {
      return this._normalizedRanges.map((r) => r.toString()).join(", ");
    }
    getIntersection(other) {
      const result = [];
      let i1 = 0;
      let i2 = 0;
      while (i1 < this._normalizedRanges.length && i2 < other._normalizedRanges.length) {
        const r1 = this._normalizedRanges[i1];
        const r2 = other._normalizedRanges[i2];
        const i = r1.intersect(r2);
        if (i && !i.isEmpty) {
          result.push(i);
        }
        if (r1.endLineNumberExclusive < r2.endLineNumberExclusive) {
          i1++;
        } else {
          i2++;
        }
      }
      return new LineRangeSet(result);
    }
    getWithDelta(value) {
      return new LineRangeSet(this._normalizedRanges.map((r) => r.delta(value)));
    }
  }
  const _TextLength = class _TextLength {
    static betweenPositions(position1, position2) {
      if (position1.lineNumber === position2.lineNumber) {
        return new _TextLength(0, position2.column - position1.column);
      } else {
        return new _TextLength(position2.lineNumber - position1.lineNumber, position2.column - 1);
      }
    }
    static fromPosition(pos) {
      return new _TextLength(pos.lineNumber - 1, pos.column - 1);
    }
    static ofRange(range) {
      return _TextLength.betweenPositions(range.getStartPosition(), range.getEndPosition());
    }
    static ofText(text) {
      let line = 0;
      let column = 0;
      for (const c of text) {
        if (c === "\n") {
          line++;
          column = 0;
        } else {
          column++;
        }
      }
      return new _TextLength(line, column);
    }
    constructor(lineCount, columnCount) {
      this.lineCount = lineCount;
      this.columnCount = columnCount;
    }
    isGreaterThanOrEqualTo(other) {
      if (this.lineCount !== other.lineCount) {
        return this.lineCount > other.lineCount;
      }
      return this.columnCount >= other.columnCount;
    }
    add(other) {
      if (other.lineCount === 0) {
        return new _TextLength(this.lineCount, this.columnCount + other.columnCount);
      } else {
        return new _TextLength(this.lineCount + other.lineCount, other.columnCount);
      }
    }
    createRange(startPosition) {
      if (this.lineCount === 0) {
        return new Range$1(startPosition.lineNumber, startPosition.column, startPosition.lineNumber, startPosition.column + this.columnCount);
      } else {
        return new Range$1(startPosition.lineNumber, startPosition.column, startPosition.lineNumber + this.lineCount, this.columnCount + 1);
      }
    }
    toRange() {
      return new Range$1(1, 1, this.lineCount + 1, this.columnCount + 1);
    }
    toLineRange() {
      return LineRange.ofLength(1, this.lineCount + 1);
    }
    addToPosition(position) {
      if (this.lineCount === 0) {
        return new Position$1(position.lineNumber, position.column + this.columnCount);
      } else {
        return new Position$1(position.lineNumber + this.lineCount, this.columnCount + 1);
      }
    }
    toString() {
      return `${this.lineCount},${this.columnCount}`;
    }
  };
  _TextLength.zero = new _TextLength(0, 0);
  let TextLength = _TextLength;
  class PositionOffsetTransformerBase {
    getOffsetRange(range) {
      return new OffsetRange(this.getOffset(range.getStartPosition()), this.getOffset(range.getEndPosition()));
    }
    getRange(offsetRange) {
      return Range$1.fromPositions(this.getPosition(offsetRange.start), this.getPosition(offsetRange.endExclusive));
    }
    getStringReplacement(edit) {
      return new Deps.deps.StringReplacement(this.getOffsetRange(edit.range), edit.text);
    }
    getTextReplacement(edit) {
      return new Deps.deps.TextReplacement(this.getRange(edit.replaceRange), edit.newText);
    }
    getTextEdit(edit) {
      const edits = edit.replacements.map((e) => this.getTextReplacement(e));
      return new Deps.deps.TextEdit(edits);
    }
  }
  const _Deps = class _Deps {
    static get deps() {
      if (!this._deps) {
        throw new Error("Dependencies not set. Call _setDependencies first.");
      }
      return this._deps;
    }
  };
  _Deps._deps = void 0;
  let Deps = _Deps;
  class PositionOffsetTransformer extends PositionOffsetTransformerBase {
    constructor(text) {
      super();
      this.text = text;
      this.lineStartOffsetByLineIdx = [];
      this.lineEndOffsetByLineIdx = [];
      this.lineStartOffsetByLineIdx.push(0);
      for (let i = 0; i < text.length; i++) {
        if (text.charAt(i) === "\n") {
          this.lineStartOffsetByLineIdx.push(i + 1);
          if (i > 0 && text.charAt(i - 1) === "\r") {
            this.lineEndOffsetByLineIdx.push(i - 1);
          } else {
            this.lineEndOffsetByLineIdx.push(i);
          }
        }
      }
      this.lineEndOffsetByLineIdx.push(text.length);
    }
    getOffset(position) {
      const valPos = this._validatePosition(position);
      return this.lineStartOffsetByLineIdx[valPos.lineNumber - 1] + valPos.column - 1;
    }
    _validatePosition(position) {
      if (position.lineNumber < 1) {
        return new Position$1(1, 1);
      }
      const lineCount = this.textLength.lineCount + 1;
      if (position.lineNumber > lineCount) {
        const lineLength2 = this.getLineLength(lineCount);
        return new Position$1(lineCount, lineLength2 + 1);
      }
      if (position.column < 1) {
        return new Position$1(position.lineNumber, 1);
      }
      const lineLength = this.getLineLength(position.lineNumber);
      if (position.column - 1 > lineLength) {
        return new Position$1(position.lineNumber, lineLength + 1);
      }
      return position;
    }
    getPosition(offset) {
      const idx = findLastIdxMonotonous(this.lineStartOffsetByLineIdx, (i) => i <= offset);
      const lineNumber = idx + 1;
      const column = offset - this.lineStartOffsetByLineIdx[idx] + 1;
      return new Position$1(lineNumber, column);
    }
    get textLength() {
      const lineIdx = this.lineStartOffsetByLineIdx.length - 1;
      return new Deps.deps.TextLength(lineIdx, this.text.length - this.lineStartOffsetByLineIdx[lineIdx]);
    }
    getLineLength(lineNumber) {
      return this.lineEndOffsetByLineIdx[lineNumber - 1] - this.lineStartOffsetByLineIdx[lineNumber - 1];
    }
  }
  class AbstractText {
    constructor() {
      this._transformer = void 0;
    }
    get endPositionExclusive() {
      return this.length.addToPosition(new Position$1(1, 1));
    }
    get lineRange() {
      return this.length.toLineRange();
    }
    getValue() {
      return this.getValueOfRange(this.length.toRange());
    }
    getValueOfOffsetRange(range) {
      return this.getValueOfRange(this.getTransformer().getRange(range));
    }
    getLineLength(lineNumber) {
      return this.getValueOfRange(new Range$1(lineNumber, 1, lineNumber, Number.MAX_SAFE_INTEGER)).length;
    }
    getTransformer() {
      if (!this._transformer) {
        this._transformer = new PositionOffsetTransformer(this.getValue());
      }
      return this._transformer;
    }
    getLineAt(lineNumber) {
      return this.getValueOfRange(new Range$1(lineNumber, 1, lineNumber, Number.MAX_SAFE_INTEGER));
    }
  }
  class LineBasedText extends AbstractText {
    constructor(_getLineContent, _lineCount) {
      assert(_lineCount >= 1);
      super();
      this._getLineContent = _getLineContent;
      this._lineCount = _lineCount;
    }
    getValueOfRange(range) {
      if (range.startLineNumber === range.endLineNumber) {
        return this._getLineContent(range.startLineNumber).substring(range.startColumn - 1, range.endColumn - 1);
      }
      let result = this._getLineContent(range.startLineNumber).substring(range.startColumn - 1);
      for (let i = range.startLineNumber + 1; i < range.endLineNumber; i++) {
        result += "\n" + this._getLineContent(i);
      }
      result += "\n" + this._getLineContent(range.endLineNumber).substring(0, range.endColumn - 1);
      return result;
    }
    getLineLength(lineNumber) {
      return this._getLineContent(lineNumber).length;
    }
    get length() {
      const lastLine = this._getLineContent(this._lineCount);
      return new TextLength(this._lineCount - 1, lastLine.length);
    }
  }
  class ArrayText extends LineBasedText {
    constructor(lines) {
      super((lineNumber) => lines[lineNumber - 1], lines.length);
    }
  }
  class TextReplacement {
    static joinReplacements(replacements, initialValue) {
      if (replacements.length === 0) {
        throw new BugIndicatingError();
      }
      if (replacements.length === 1) {
        return replacements[0];
      }
      const startPos = replacements[0].range.getStartPosition();
      const endPos = replacements[replacements.length - 1].range.getEndPosition();
      let newText = "";
      for (let i = 0; i < replacements.length; i++) {
        const curEdit = replacements[i];
        newText += curEdit.text;
        if (i < replacements.length - 1) {
          const nextEdit = replacements[i + 1];
          const gapRange = Range$1.fromPositions(curEdit.range.getEndPosition(), nextEdit.range.getStartPosition());
          const gapText = initialValue.getValueOfRange(gapRange);
          newText += gapText;
        }
      }
      return new TextReplacement(Range$1.fromPositions(startPos, endPos), newText);
    }
    static fromStringReplacement(replacement, initialState) {
      return new TextReplacement(initialState.getTransformer().getRange(replacement.replaceRange), replacement.newText);
    }
    static delete(range) {
      return new TextReplacement(range, "");
    }
    constructor(range, text) {
      this.range = range;
      this.text = text;
    }
    get isEmpty() {
      return this.range.isEmpty() && this.text.length === 0;
    }
    static equals(first, second) {
      return first.range.equalsRange(second.range) && first.text === second.text;
    }
    equals(other) {
      return TextReplacement.equals(this, other);
    }
    removeCommonPrefixAndSuffix(text) {
      const prefix = this.removeCommonPrefix(text);
      const suffix = prefix.removeCommonSuffix(text);
      return suffix;
    }
    removeCommonPrefix(text) {
      const normalizedOriginalText = text.getValueOfRange(this.range).replaceAll("\r\n", "\n");
      const normalizedModifiedText = this.text.replaceAll("\r\n", "\n");
      const commonPrefixLen = commonPrefixLength(normalizedOriginalText, normalizedModifiedText);
      const start2 = TextLength.ofText(normalizedOriginalText.substring(0, commonPrefixLen)).addToPosition(this.range.getStartPosition());
      const newText = normalizedModifiedText.substring(commonPrefixLen);
      const range = Range$1.fromPositions(start2, this.range.getEndPosition());
      return new TextReplacement(range, newText);
    }
    removeCommonSuffix(text) {
      const normalizedOriginalText = text.getValueOfRange(this.range).replaceAll("\r\n", "\n");
      const normalizedModifiedText = this.text.replaceAll("\r\n", "\n");
      const commonSuffixLen = commonSuffixLength(normalizedOriginalText, normalizedModifiedText);
      const end = TextLength.ofText(normalizedOriginalText.substring(0, normalizedOriginalText.length - commonSuffixLen)).addToPosition(this.range.getStartPosition());
      const newText = normalizedModifiedText.substring(0, normalizedModifiedText.length - commonSuffixLen);
      const range = Range$1.fromPositions(this.range.getStartPosition(), end);
      return new TextReplacement(range, newText);
    }
    toString() {
      const start2 = this.range.getStartPosition();
      const end = this.range.getEndPosition();
      return `(${start2.lineNumber},${start2.column} -> ${end.lineNumber},${end.column}): "${this.text}"`;
    }
  }
  class LineRangeMapping {
    static inverse(mapping, originalLineCount, modifiedLineCount) {
      const result = [];
      let lastOriginalEndLineNumber = 1;
      let lastModifiedEndLineNumber = 1;
      for (const m of mapping) {
        const r2 = new LineRangeMapping(new LineRange(lastOriginalEndLineNumber, m.original.startLineNumber), new LineRange(lastModifiedEndLineNumber, m.modified.startLineNumber));
        if (!r2.modified.isEmpty) {
          result.push(r2);
        }
        lastOriginalEndLineNumber = m.original.endLineNumberExclusive;
        lastModifiedEndLineNumber = m.modified.endLineNumberExclusive;
      }
      const r = new LineRangeMapping(new LineRange(lastOriginalEndLineNumber, originalLineCount + 1), new LineRange(lastModifiedEndLineNumber, modifiedLineCount + 1));
      if (!r.modified.isEmpty) {
        result.push(r);
      }
      return result;
    }
    static clip(mapping, originalRange, modifiedRange) {
      const result = [];
      for (const m of mapping) {
        const original = m.original.intersect(originalRange);
        const modified = m.modified.intersect(modifiedRange);
        if (original && !original.isEmpty && modified && !modified.isEmpty) {
          result.push(new LineRangeMapping(original, modified));
        }
      }
      return result;
    }
    constructor(originalRange, modifiedRange) {
      this.original = originalRange;
      this.modified = modifiedRange;
    }
    toString() {
      return `{${this.original.toString()}->${this.modified.toString()}}`;
    }
    flip() {
      return new LineRangeMapping(this.modified, this.original);
    }
    join(other) {
      return new LineRangeMapping(this.original.join(other.original), this.modified.join(other.modified));
    }
    /**
     * This method assumes that the LineRangeMapping describes a valid diff!
     * I.e. if one range is empty, the other range cannot be the entire document.
     * It avoids various problems when the line range points to non-existing line-numbers.
    */
    toRangeMapping() {
      const origInclusiveRange = this.original.toInclusiveRange();
      const modInclusiveRange = this.modified.toInclusiveRange();
      if (origInclusiveRange && modInclusiveRange) {
        return new RangeMapping(origInclusiveRange, modInclusiveRange);
      } else if (this.original.startLineNumber === 1 || this.modified.startLineNumber === 1) {
        if (!(this.modified.startLineNumber === 1 && this.original.startLineNumber === 1)) {
          throw new BugIndicatingError("not a valid diff");
        }
        return new RangeMapping(new Range$1(this.original.startLineNumber, 1, this.original.endLineNumberExclusive, 1), new Range$1(this.modified.startLineNumber, 1, this.modified.endLineNumberExclusive, 1));
      } else {
        return new RangeMapping(new Range$1(this.original.startLineNumber - 1, Number.MAX_SAFE_INTEGER, this.original.endLineNumberExclusive - 1, Number.MAX_SAFE_INTEGER), new Range$1(this.modified.startLineNumber - 1, Number.MAX_SAFE_INTEGER, this.modified.endLineNumberExclusive - 1, Number.MAX_SAFE_INTEGER));
      }
    }
    /**
     * This method assumes that the LineRangeMapping describes a valid diff!
     * I.e. if one range is empty, the other range cannot be the entire document.
     * It avoids various problems when the line range points to non-existing line-numbers.
    */
    toRangeMapping2(original, modified) {
      if (isValidLineNumber(this.original.endLineNumberExclusive, original) && isValidLineNumber(this.modified.endLineNumberExclusive, modified)) {
        return new RangeMapping(new Range$1(this.original.startLineNumber, 1, this.original.endLineNumberExclusive, 1), new Range$1(this.modified.startLineNumber, 1, this.modified.endLineNumberExclusive, 1));
      }
      if (!this.original.isEmpty && !this.modified.isEmpty) {
        return new RangeMapping(Range$1.fromPositions(new Position$1(this.original.startLineNumber, 1), normalizePosition(new Position$1(this.original.endLineNumberExclusive - 1, Number.MAX_SAFE_INTEGER), original)), Range$1.fromPositions(new Position$1(this.modified.startLineNumber, 1), normalizePosition(new Position$1(this.modified.endLineNumberExclusive - 1, Number.MAX_SAFE_INTEGER), modified)));
      }
      if (this.original.startLineNumber > 1 && this.modified.startLineNumber > 1) {
        return new RangeMapping(Range$1.fromPositions(normalizePosition(new Position$1(this.original.startLineNumber - 1, Number.MAX_SAFE_INTEGER), original), normalizePosition(new Position$1(this.original.endLineNumberExclusive - 1, Number.MAX_SAFE_INTEGER), original)), Range$1.fromPositions(normalizePosition(new Position$1(this.modified.startLineNumber - 1, Number.MAX_SAFE_INTEGER), modified), normalizePosition(new Position$1(this.modified.endLineNumberExclusive - 1, Number.MAX_SAFE_INTEGER), modified)));
      }
      throw new BugIndicatingError();
    }
  }
  function normalizePosition(position, content) {
    if (position.lineNumber < 1) {
      return new Position$1(1, 1);
    }
    if (position.lineNumber > content.length) {
      return new Position$1(content.length, content[content.length - 1].length + 1);
    }
    const line = content[position.lineNumber - 1];
    if (position.column > line.length + 1) {
      return new Position$1(position.lineNumber, line.length + 1);
    }
    return position;
  }
  function isValidLineNumber(lineNumber, lines) {
    return lineNumber >= 1 && lineNumber <= lines.length;
  }
  class DetailedLineRangeMapping extends LineRangeMapping {
    static fromRangeMappings(rangeMappings) {
      const originalRange = LineRange.join(rangeMappings.map((r) => LineRange.fromRangeInclusive(r.originalRange)));
      const modifiedRange = LineRange.join(rangeMappings.map((r) => LineRange.fromRangeInclusive(r.modifiedRange)));
      return new DetailedLineRangeMapping(originalRange, modifiedRange, rangeMappings);
    }
    constructor(originalRange, modifiedRange, innerChanges) {
      super(originalRange, modifiedRange);
      this.innerChanges = innerChanges;
    }
    flip() {
      return new DetailedLineRangeMapping(this.modified, this.original, this.innerChanges?.map((c) => c.flip()));
    }
    withInnerChangesFromLineRanges() {
      return new DetailedLineRangeMapping(this.original, this.modified, [this.toRangeMapping()]);
    }
  }
  class RangeMapping {
    static fromEdit(edit) {
      const newRanges = edit.getNewRanges();
      const result = edit.replacements.map((e, idx) => new RangeMapping(e.range, newRanges[idx]));
      return result;
    }
    static assertSorted(rangeMappings) {
      for (let i = 1; i < rangeMappings.length; i++) {
        const previous = rangeMappings[i - 1];
        const current = rangeMappings[i];
        if (!(previous.originalRange.getEndPosition().isBeforeOrEqual(current.originalRange.getStartPosition()) && previous.modifiedRange.getEndPosition().isBeforeOrEqual(current.modifiedRange.getStartPosition()))) {
          throw new BugIndicatingError("Range mappings must be sorted");
        }
      }
    }
    constructor(originalRange, modifiedRange) {
      this.originalRange = originalRange;
      this.modifiedRange = modifiedRange;
    }
    toString() {
      return `{${this.originalRange.toString()}->${this.modifiedRange.toString()}}`;
    }
    flip() {
      return new RangeMapping(this.modifiedRange, this.originalRange);
    }
    /**
     * Creates a single text edit that describes the change from the original to the modified text.
    */
    toTextEdit(modified) {
      const newText = modified.getValueOfRange(this.modifiedRange);
      return new TextReplacement(this.originalRange, newText);
    }
  }
  function lineRangeMappingFromRangeMappings(alignments, originalLines, modifiedLines, dontAssertStartLine = false) {
    const changes = [];
    for (const g of groupAdjacentBy(alignments.map((a) => getLineRangeMapping(a, originalLines, modifiedLines)), (a1, a2) => a1.original.intersectsOrTouches(a2.original) || a1.modified.intersectsOrTouches(a2.modified))) {
      const first = g[0];
      const last = g[g.length - 1];
      changes.push(new DetailedLineRangeMapping(first.original.join(last.original), first.modified.join(last.modified), g.map((a) => a.innerChanges[0])));
    }
    assertFn(() => {
      if (!dontAssertStartLine && changes.length > 0) {
        if (changes[0].modified.startLineNumber !== changes[0].original.startLineNumber) {
          return false;
        }
        if (modifiedLines.length.lineCount - changes[changes.length - 1].modified.endLineNumberExclusive !== originalLines.length.lineCount - changes[changes.length - 1].original.endLineNumberExclusive) {
          return false;
        }
      }
      return checkAdjacentItems(changes, (m1, m2) => m2.original.startLineNumber - m1.original.endLineNumberExclusive === m2.modified.startLineNumber - m1.modified.endLineNumberExclusive && // There has to be an unchanged line in between (otherwise both diffs should have been joined)
      m1.original.endLineNumberExclusive < m2.original.startLineNumber && m1.modified.endLineNumberExclusive < m2.modified.startLineNumber);
    });
    return changes;
  }
  function getLineRangeMapping(rangeMapping, originalLines, modifiedLines) {
    let lineStartDelta = 0;
    let lineEndDelta = 0;
    if (rangeMapping.modifiedRange.endColumn === 1 && rangeMapping.originalRange.endColumn === 1 && rangeMapping.originalRange.startLineNumber + lineStartDelta <= rangeMapping.originalRange.endLineNumber && rangeMapping.modifiedRange.startLineNumber + lineStartDelta <= rangeMapping.modifiedRange.endLineNumber) {
      lineEndDelta = -1;
    }
    if (rangeMapping.modifiedRange.startColumn - 1 >= modifiedLines.getLineLength(rangeMapping.modifiedRange.startLineNumber) && rangeMapping.originalRange.startColumn - 1 >= originalLines.getLineLength(rangeMapping.originalRange.startLineNumber) && rangeMapping.originalRange.startLineNumber <= rangeMapping.originalRange.endLineNumber + lineEndDelta && rangeMapping.modifiedRange.startLineNumber <= rangeMapping.modifiedRange.endLineNumber + lineEndDelta) {
      lineStartDelta = 1;
    }
    const originalLineRange = new LineRange(rangeMapping.originalRange.startLineNumber + lineStartDelta, rangeMapping.originalRange.endLineNumber + 1 + lineEndDelta);
    const modifiedLineRange = new LineRange(rangeMapping.modifiedRange.startLineNumber + lineStartDelta, rangeMapping.modifiedRange.endLineNumber + 1 + lineEndDelta);
    return new DetailedLineRangeMapping(originalLineRange, modifiedLineRange, [rangeMapping]);
  }
  const MINIMUM_MATCHING_CHARACTER_LENGTH = 3;
  class LegacyLinesDiffComputer {
    computeDiff(originalLines, modifiedLines, options) {
      const diffComputer = new DiffComputer(originalLines, modifiedLines, {
        maxComputationTime: options.maxComputationTimeMs,
        shouldIgnoreTrimWhitespace: options.ignoreTrimWhitespace,
        shouldComputeCharChanges: true,
        shouldMakePrettyDiff: true,
        shouldPostProcessCharChanges: true
      });
      const result = diffComputer.computeDiff();
      const changes = [];
      let lastChange = null;
      for (const c of result.changes) {
        let originalRange;
        if (c.originalEndLineNumber === 0) {
          originalRange = new LineRange(c.originalStartLineNumber + 1, c.originalStartLineNumber + 1);
        } else {
          originalRange = new LineRange(c.originalStartLineNumber, c.originalEndLineNumber + 1);
        }
        let modifiedRange;
        if (c.modifiedEndLineNumber === 0) {
          modifiedRange = new LineRange(c.modifiedStartLineNumber + 1, c.modifiedStartLineNumber + 1);
        } else {
          modifiedRange = new LineRange(c.modifiedStartLineNumber, c.modifiedEndLineNumber + 1);
        }
        let change = new DetailedLineRangeMapping(originalRange, modifiedRange, c.charChanges?.map((c2) => new RangeMapping(new Range$1(c2.originalStartLineNumber, c2.originalStartColumn, c2.originalEndLineNumber, c2.originalEndColumn), new Range$1(c2.modifiedStartLineNumber, c2.modifiedStartColumn, c2.modifiedEndLineNumber, c2.modifiedEndColumn))));
        if (lastChange) {
          if (lastChange.modified.endLineNumberExclusive === change.modified.startLineNumber || lastChange.original.endLineNumberExclusive === change.original.startLineNumber) {
            change = new DetailedLineRangeMapping(lastChange.original.join(change.original), lastChange.modified.join(change.modified), lastChange.innerChanges && change.innerChanges ? lastChange.innerChanges.concat(change.innerChanges) : void 0);
            changes.pop();
          }
        }
        changes.push(change);
        lastChange = change;
      }
      assertFn(() => {
        return checkAdjacentItems(changes, (m1, m2) => m2.original.startLineNumber - m1.original.endLineNumberExclusive === m2.modified.startLineNumber - m1.modified.endLineNumberExclusive && // There has to be an unchanged line in between (otherwise both diffs should have been joined)
        m1.original.endLineNumberExclusive < m2.original.startLineNumber && m1.modified.endLineNumberExclusive < m2.modified.startLineNumber);
      });
      return new LinesDiff(changes, [], result.quitEarly);
    }
  }
  function computeDiff(originalSequence, modifiedSequence, continueProcessingPredicate, pretty) {
    const diffAlgo = new LcsDiff(originalSequence, modifiedSequence, continueProcessingPredicate);
    return diffAlgo.ComputeDiff(pretty);
  }
  let LineSequence$1 = class LineSequence {
    constructor(lines) {
      const startColumns = [];
      const endColumns = [];
      for (let i = 0, length = lines.length; i < length; i++) {
        startColumns[i] = getFirstNonBlankColumn(lines[i], 1);
        endColumns[i] = getLastNonBlankColumn(lines[i], 1);
      }
      this.lines = lines;
      this._startColumns = startColumns;
      this._endColumns = endColumns;
    }
    getElements() {
      const elements = [];
      for (let i = 0, len = this.lines.length; i < len; i++) {
        elements[i] = this.lines[i].substring(this._startColumns[i] - 1, this._endColumns[i] - 1);
      }
      return elements;
    }
    getStrictElement(index) {
      return this.lines[index];
    }
    getStartLineNumber(i) {
      return i + 1;
    }
    getEndLineNumber(i) {
      return i + 1;
    }
    createCharSequence(shouldIgnoreTrimWhitespace, startIndex, endIndex) {
      const charCodes = [];
      const lineNumbers = [];
      const columns = [];
      let len = 0;
      for (let index = startIndex; index <= endIndex; index++) {
        const lineContent = this.lines[index];
        const startColumn = shouldIgnoreTrimWhitespace ? this._startColumns[index] : 1;
        const endColumn = shouldIgnoreTrimWhitespace ? this._endColumns[index] : lineContent.length + 1;
        for (let col = startColumn; col < endColumn; col++) {
          charCodes[len] = lineContent.charCodeAt(col - 1);
          lineNumbers[len] = index + 1;
          columns[len] = col;
          len++;
        }
        if (!shouldIgnoreTrimWhitespace && index < endIndex) {
          charCodes[len] = 10;
          lineNumbers[len] = index + 1;
          columns[len] = lineContent.length + 1;
          len++;
        }
      }
      return new CharSequence(charCodes, lineNumbers, columns);
    }
  };
  class CharSequence {
    constructor(charCodes, lineNumbers, columns) {
      this._charCodes = charCodes;
      this._lineNumbers = lineNumbers;
      this._columns = columns;
    }
    toString() {
      return "[" + this._charCodes.map((s, idx) => (s === 10 ? "\\n" : String.fromCharCode(s)) + `-(${this._lineNumbers[idx]},${this._columns[idx]})`).join(", ") + "]";
    }
    _assertIndex(index, arr) {
      if (index < 0 || index >= arr.length) {
        throw new Error(`Illegal index`);
      }
    }
    getElements() {
      return this._charCodes;
    }
    getStartLineNumber(i) {
      if (i > 0 && i === this._lineNumbers.length) {
        return this.getEndLineNumber(i - 1);
      }
      this._assertIndex(i, this._lineNumbers);
      return this._lineNumbers[i];
    }
    getEndLineNumber(i) {
      if (i === -1) {
        return this.getStartLineNumber(i + 1);
      }
      this._assertIndex(i, this._lineNumbers);
      if (this._charCodes[i] === 10) {
        return this._lineNumbers[i] + 1;
      }
      return this._lineNumbers[i];
    }
    getStartColumn(i) {
      if (i > 0 && i === this._columns.length) {
        return this.getEndColumn(i - 1);
      }
      this._assertIndex(i, this._columns);
      return this._columns[i];
    }
    getEndColumn(i) {
      if (i === -1) {
        return this.getStartColumn(i + 1);
      }
      this._assertIndex(i, this._columns);
      if (this._charCodes[i] === 10) {
        return 1;
      }
      return this._columns[i] + 1;
    }
  }
  class CharChange {
    constructor(originalStartLineNumber, originalStartColumn, originalEndLineNumber, originalEndColumn, modifiedStartLineNumber, modifiedStartColumn, modifiedEndLineNumber, modifiedEndColumn) {
      this.originalStartLineNumber = originalStartLineNumber;
      this.originalStartColumn = originalStartColumn;
      this.originalEndLineNumber = originalEndLineNumber;
      this.originalEndColumn = originalEndColumn;
      this.modifiedStartLineNumber = modifiedStartLineNumber;
      this.modifiedStartColumn = modifiedStartColumn;
      this.modifiedEndLineNumber = modifiedEndLineNumber;
      this.modifiedEndColumn = modifiedEndColumn;
    }
    static createFromDiffChange(diffChange, originalCharSequence, modifiedCharSequence) {
      const originalStartLineNumber = originalCharSequence.getStartLineNumber(diffChange.originalStart);
      const originalStartColumn = originalCharSequence.getStartColumn(diffChange.originalStart);
      const originalEndLineNumber = originalCharSequence.getEndLineNumber(diffChange.originalStart + diffChange.originalLength - 1);
      const originalEndColumn = originalCharSequence.getEndColumn(diffChange.originalStart + diffChange.originalLength - 1);
      const modifiedStartLineNumber = modifiedCharSequence.getStartLineNumber(diffChange.modifiedStart);
      const modifiedStartColumn = modifiedCharSequence.getStartColumn(diffChange.modifiedStart);
      const modifiedEndLineNumber = modifiedCharSequence.getEndLineNumber(diffChange.modifiedStart + diffChange.modifiedLength - 1);
      const modifiedEndColumn = modifiedCharSequence.getEndColumn(diffChange.modifiedStart + diffChange.modifiedLength - 1);
      return new CharChange(originalStartLineNumber, originalStartColumn, originalEndLineNumber, originalEndColumn, modifiedStartLineNumber, modifiedStartColumn, modifiedEndLineNumber, modifiedEndColumn);
    }
  }
  function postProcessCharChanges(rawChanges) {
    if (rawChanges.length <= 1) {
      return rawChanges;
    }
    const result = [rawChanges[0]];
    let prevChange = result[0];
    for (let i = 1, len = rawChanges.length; i < len; i++) {
      const currChange = rawChanges[i];
      const originalMatchingLength = currChange.originalStart - (prevChange.originalStart + prevChange.originalLength);
      const modifiedMatchingLength = currChange.modifiedStart - (prevChange.modifiedStart + prevChange.modifiedLength);
      const matchingLength = Math.min(originalMatchingLength, modifiedMatchingLength);
      if (matchingLength < MINIMUM_MATCHING_CHARACTER_LENGTH) {
        prevChange.originalLength = currChange.originalStart + currChange.originalLength - prevChange.originalStart;
        prevChange.modifiedLength = currChange.modifiedStart + currChange.modifiedLength - prevChange.modifiedStart;
      } else {
        result.push(currChange);
        prevChange = currChange;
      }
    }
    return result;
  }
  class LineChange {
    constructor(originalStartLineNumber, originalEndLineNumber, modifiedStartLineNumber, modifiedEndLineNumber, charChanges) {
      this.originalStartLineNumber = originalStartLineNumber;
      this.originalEndLineNumber = originalEndLineNumber;
      this.modifiedStartLineNumber = modifiedStartLineNumber;
      this.modifiedEndLineNumber = modifiedEndLineNumber;
      this.charChanges = charChanges;
    }
    static createFromDiffResult(shouldIgnoreTrimWhitespace, diffChange, originalLineSequence, modifiedLineSequence, continueCharDiff, shouldComputeCharChanges, shouldPostProcessCharChanges) {
      let originalStartLineNumber;
      let originalEndLineNumber;
      let modifiedStartLineNumber;
      let modifiedEndLineNumber;
      let charChanges = void 0;
      if (diffChange.originalLength === 0) {
        originalStartLineNumber = originalLineSequence.getStartLineNumber(diffChange.originalStart) - 1;
        originalEndLineNumber = 0;
      } else {
        originalStartLineNumber = originalLineSequence.getStartLineNumber(diffChange.originalStart);
        originalEndLineNumber = originalLineSequence.getEndLineNumber(diffChange.originalStart + diffChange.originalLength - 1);
      }
      if (diffChange.modifiedLength === 0) {
        modifiedStartLineNumber = modifiedLineSequence.getStartLineNumber(diffChange.modifiedStart) - 1;
        modifiedEndLineNumber = 0;
      } else {
        modifiedStartLineNumber = modifiedLineSequence.getStartLineNumber(diffChange.modifiedStart);
        modifiedEndLineNumber = modifiedLineSequence.getEndLineNumber(diffChange.modifiedStart + diffChange.modifiedLength - 1);
      }
      if (shouldComputeCharChanges && diffChange.originalLength > 0 && diffChange.originalLength < 20 && diffChange.modifiedLength > 0 && diffChange.modifiedLength < 20 && continueCharDiff()) {
        const originalCharSequence = originalLineSequence.createCharSequence(shouldIgnoreTrimWhitespace, diffChange.originalStart, diffChange.originalStart + diffChange.originalLength - 1);
        const modifiedCharSequence = modifiedLineSequence.createCharSequence(shouldIgnoreTrimWhitespace, diffChange.modifiedStart, diffChange.modifiedStart + diffChange.modifiedLength - 1);
        if (originalCharSequence.getElements().length > 0 && modifiedCharSequence.getElements().length > 0) {
          let rawChanges = computeDiff(originalCharSequence, modifiedCharSequence, continueCharDiff, true).changes;
          if (shouldPostProcessCharChanges) {
            rawChanges = postProcessCharChanges(rawChanges);
          }
          charChanges = [];
          for (let i = 0, length = rawChanges.length; i < length; i++) {
            charChanges.push(CharChange.createFromDiffChange(rawChanges[i], originalCharSequence, modifiedCharSequence));
          }
        }
      }
      return new LineChange(originalStartLineNumber, originalEndLineNumber, modifiedStartLineNumber, modifiedEndLineNumber, charChanges);
    }
  }
  class DiffComputer {
    constructor(originalLines, modifiedLines, opts) {
      this.shouldComputeCharChanges = opts.shouldComputeCharChanges;
      this.shouldPostProcessCharChanges = opts.shouldPostProcessCharChanges;
      this.shouldIgnoreTrimWhitespace = opts.shouldIgnoreTrimWhitespace;
      this.shouldMakePrettyDiff = opts.shouldMakePrettyDiff;
      this.originalLines = originalLines;
      this.modifiedLines = modifiedLines;
      this.original = new LineSequence$1(originalLines);
      this.modified = new LineSequence$1(modifiedLines);
      this.continueLineDiff = createContinueProcessingPredicate(opts.maxComputationTime);
      this.continueCharDiff = createContinueProcessingPredicate(opts.maxComputationTime === 0 ? 0 : Math.min(opts.maxComputationTime, 5e3));
    }
    computeDiff() {
      if (this.original.lines.length === 1 && this.original.lines[0].length === 0) {
        if (this.modified.lines.length === 1 && this.modified.lines[0].length === 0) {
          return {
            quitEarly: false,
            changes: []
          };
        }
        return {
          quitEarly: false,
          changes: [{
            originalStartLineNumber: 1,
            originalEndLineNumber: 1,
            modifiedStartLineNumber: 1,
            modifiedEndLineNumber: this.modified.lines.length,
            charChanges: void 0
          }]
        };
      }
      if (this.modified.lines.length === 1 && this.modified.lines[0].length === 0) {
        return {
          quitEarly: false,
          changes: [{
            originalStartLineNumber: 1,
            originalEndLineNumber: this.original.lines.length,
            modifiedStartLineNumber: 1,
            modifiedEndLineNumber: 1,
            charChanges: void 0
          }]
        };
      }
      const diffResult = computeDiff(this.original, this.modified, this.continueLineDiff, this.shouldMakePrettyDiff);
      const rawChanges = diffResult.changes;
      const quitEarly = diffResult.quitEarly;
      if (this.shouldIgnoreTrimWhitespace) {
        const lineChanges = [];
        for (let i = 0, length = rawChanges.length; i < length; i++) {
          lineChanges.push(LineChange.createFromDiffResult(this.shouldIgnoreTrimWhitespace, rawChanges[i], this.original, this.modified, this.continueCharDiff, this.shouldComputeCharChanges, this.shouldPostProcessCharChanges));
        }
        return {
          quitEarly,
          changes: lineChanges
        };
      }
      const result = [];
      let originalLineIndex = 0;
      let modifiedLineIndex = 0;
      for (let i = -1, len = rawChanges.length; i < len; i++) {
        const nextChange = i + 1 < len ? rawChanges[i + 1] : null;
        const originalStop = nextChange ? nextChange.originalStart : this.originalLines.length;
        const modifiedStop = nextChange ? nextChange.modifiedStart : this.modifiedLines.length;
        while (originalLineIndex < originalStop && modifiedLineIndex < modifiedStop) {
          const originalLine = this.originalLines[originalLineIndex];
          const modifiedLine = this.modifiedLines[modifiedLineIndex];
          if (originalLine !== modifiedLine) {
            {
              let originalStartColumn = getFirstNonBlankColumn(originalLine, 1);
              let modifiedStartColumn = getFirstNonBlankColumn(modifiedLine, 1);
              while (originalStartColumn > 1 && modifiedStartColumn > 1) {
                const originalChar = originalLine.charCodeAt(originalStartColumn - 2);
                const modifiedChar = modifiedLine.charCodeAt(modifiedStartColumn - 2);
                if (originalChar !== modifiedChar) {
                  break;
                }
                originalStartColumn--;
                modifiedStartColumn--;
              }
              if (originalStartColumn > 1 || modifiedStartColumn > 1) {
                this._pushTrimWhitespaceCharChange(result, originalLineIndex + 1, 1, originalStartColumn, modifiedLineIndex + 1, 1, modifiedStartColumn);
              }
            }
            {
              let originalEndColumn = getLastNonBlankColumn(originalLine, 1);
              let modifiedEndColumn = getLastNonBlankColumn(modifiedLine, 1);
              const originalMaxColumn = originalLine.length + 1;
              const modifiedMaxColumn = modifiedLine.length + 1;
              while (originalEndColumn < originalMaxColumn && modifiedEndColumn < modifiedMaxColumn) {
                const originalChar = originalLine.charCodeAt(originalEndColumn - 1);
                const modifiedChar = originalLine.charCodeAt(modifiedEndColumn - 1);
                if (originalChar !== modifiedChar) {
                  break;
                }
                originalEndColumn++;
                modifiedEndColumn++;
              }
              if (originalEndColumn < originalMaxColumn || modifiedEndColumn < modifiedMaxColumn) {
                this._pushTrimWhitespaceCharChange(result, originalLineIndex + 1, originalEndColumn, originalMaxColumn, modifiedLineIndex + 1, modifiedEndColumn, modifiedMaxColumn);
              }
            }
          }
          originalLineIndex++;
          modifiedLineIndex++;
        }
        if (nextChange) {
          result.push(LineChange.createFromDiffResult(this.shouldIgnoreTrimWhitespace, nextChange, this.original, this.modified, this.continueCharDiff, this.shouldComputeCharChanges, this.shouldPostProcessCharChanges));
          originalLineIndex += nextChange.originalLength;
          modifiedLineIndex += nextChange.modifiedLength;
        }
      }
      return {
        quitEarly,
        changes: result
      };
    }
    _pushTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn) {
      if (this._mergeTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn)) {
        return;
      }
      let charChanges = void 0;
      if (this.shouldComputeCharChanges) {
        charChanges = [new CharChange(originalLineNumber, originalStartColumn, originalLineNumber, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedLineNumber, modifiedEndColumn)];
      }
      result.push(new LineChange(originalLineNumber, originalLineNumber, modifiedLineNumber, modifiedLineNumber, charChanges));
    }
    _mergeTrimWhitespaceCharChange(result, originalLineNumber, originalStartColumn, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedEndColumn) {
      const len = result.length;
      if (len === 0) {
        return false;
      }
      const prevChange = result[len - 1];
      if (prevChange.originalEndLineNumber === 0 || prevChange.modifiedEndLineNumber === 0) {
        return false;
      }
      if (prevChange.originalEndLineNumber === originalLineNumber && prevChange.modifiedEndLineNumber === modifiedLineNumber) {
        if (this.shouldComputeCharChanges && prevChange.charChanges) {
          prevChange.charChanges.push(new CharChange(originalLineNumber, originalStartColumn, originalLineNumber, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedLineNumber, modifiedEndColumn));
        }
        return true;
      }
      if (prevChange.originalEndLineNumber + 1 === originalLineNumber && prevChange.modifiedEndLineNumber + 1 === modifiedLineNumber) {
        prevChange.originalEndLineNumber = originalLineNumber;
        prevChange.modifiedEndLineNumber = modifiedLineNumber;
        if (this.shouldComputeCharChanges && prevChange.charChanges) {
          prevChange.charChanges.push(new CharChange(originalLineNumber, originalStartColumn, originalLineNumber, originalEndColumn, modifiedLineNumber, modifiedStartColumn, modifiedLineNumber, modifiedEndColumn));
        }
        return true;
      }
      return false;
    }
  }
  function getFirstNonBlankColumn(txt, defaultValue) {
    const r = firstNonWhitespaceIndex(txt);
    if (r === -1) {
      return defaultValue;
    }
    return r + 1;
  }
  function getLastNonBlankColumn(txt, defaultValue) {
    const r = lastNonWhitespaceIndex(txt);
    if (r === -1) {
      return defaultValue;
    }
    return r + 2;
  }
  function createContinueProcessingPredicate(maximumRuntime) {
    if (maximumRuntime === 0) {
      return () => true;
    }
    const startTime = Date.now();
    return () => {
      return Date.now() - startTime < maximumRuntime;
    };
  }
  class DiffAlgorithmResult {
    static trivial(seq1, seq2) {
      return new DiffAlgorithmResult([new SequenceDiff(OffsetRange.ofLength(seq1.length), OffsetRange.ofLength(seq2.length))], false);
    }
    static trivialTimedOut(seq1, seq2) {
      return new DiffAlgorithmResult([new SequenceDiff(OffsetRange.ofLength(seq1.length), OffsetRange.ofLength(seq2.length))], true);
    }
    constructor(diffs, hitTimeout) {
      this.diffs = diffs;
      this.hitTimeout = hitTimeout;
    }
  }
  class SequenceDiff {
    static invert(sequenceDiffs, doc1Length) {
      const result = [];
      forEachAdjacent(sequenceDiffs, (a, b) => {
        result.push(SequenceDiff.fromOffsetPairs(a ? a.getEndExclusives() : OffsetPair.zero, b ? b.getStarts() : new OffsetPair(doc1Length, (a ? a.seq2Range.endExclusive - a.seq1Range.endExclusive : 0) + doc1Length)));
      });
      return result;
    }
    static fromOffsetPairs(start2, endExclusive) {
      return new SequenceDiff(new OffsetRange(start2.offset1, endExclusive.offset1), new OffsetRange(start2.offset2, endExclusive.offset2));
    }
    static assertSorted(sequenceDiffs) {
      let last = void 0;
      for (const cur of sequenceDiffs) {
        if (last) {
          if (!(last.seq1Range.endExclusive <= cur.seq1Range.start && last.seq2Range.endExclusive <= cur.seq2Range.start)) {
            throw new BugIndicatingError("Sequence diffs must be sorted");
          }
        }
        last = cur;
      }
    }
    constructor(seq1Range, seq2Range) {
      this.seq1Range = seq1Range;
      this.seq2Range = seq2Range;
    }
    swap() {
      return new SequenceDiff(this.seq2Range, this.seq1Range);
    }
    toString() {
      return `${this.seq1Range} <-> ${this.seq2Range}`;
    }
    join(other) {
      return new SequenceDiff(this.seq1Range.join(other.seq1Range), this.seq2Range.join(other.seq2Range));
    }
    delta(offset) {
      if (offset === 0) {
        return this;
      }
      return new SequenceDiff(this.seq1Range.delta(offset), this.seq2Range.delta(offset));
    }
    deltaStart(offset) {
      if (offset === 0) {
        return this;
      }
      return new SequenceDiff(this.seq1Range.deltaStart(offset), this.seq2Range.deltaStart(offset));
    }
    deltaEnd(offset) {
      if (offset === 0) {
        return this;
      }
      return new SequenceDiff(this.seq1Range.deltaEnd(offset), this.seq2Range.deltaEnd(offset));
    }
    intersect(other) {
      const i1 = this.seq1Range.intersect(other.seq1Range);
      const i2 = this.seq2Range.intersect(other.seq2Range);
      if (!i1 || !i2) {
        return void 0;
      }
      return new SequenceDiff(i1, i2);
    }
    getStarts() {
      return new OffsetPair(this.seq1Range.start, this.seq2Range.start);
    }
    getEndExclusives() {
      return new OffsetPair(this.seq1Range.endExclusive, this.seq2Range.endExclusive);
    }
  }
  const _OffsetPair = class _OffsetPair {
    constructor(offset1, offset2) {
      this.offset1 = offset1;
      this.offset2 = offset2;
    }
    toString() {
      return `${this.offset1} <-> ${this.offset2}`;
    }
    delta(offset) {
      if (offset === 0) {
        return this;
      }
      return new _OffsetPair(this.offset1 + offset, this.offset2 + offset);
    }
    equals(other) {
      return this.offset1 === other.offset1 && this.offset2 === other.offset2;
    }
  };
  _OffsetPair.zero = new _OffsetPair(0, 0);
  _OffsetPair.max = new _OffsetPair(Number.MAX_SAFE_INTEGER, Number.MAX_SAFE_INTEGER);
  let OffsetPair = _OffsetPair;
  const _InfiniteTimeout = class _InfiniteTimeout {
    isValid() {
      return true;
    }
  };
  _InfiniteTimeout.instance = new _InfiniteTimeout();
  let InfiniteTimeout = _InfiniteTimeout;
  class DateTimeout {
    constructor(timeout) {
      this.timeout = timeout;
      this.startTime = Date.now();
      this.valid = true;
      if (timeout <= 0) {
        throw new BugIndicatingError("timeout must be positive");
      }
    }
    // Recommendation: Set a log-point `{this.disable()}` in the body
    isValid() {
      const valid = Date.now() - this.startTime < this.timeout;
      if (!valid && this.valid) {
        this.valid = false;
      }
      return this.valid;
    }
  }
  class Array2D {
    constructor(width, height) {
      this.width = width;
      this.height = height;
      this.array = [];
      this.array = new Array(width * height);
    }
    get(x, y) {
      return this.array[x + y * this.width];
    }
    set(x, y, value) {
      this.array[x + y * this.width] = value;
    }
  }
  function isSpace(charCode) {
    return charCode === 32 || charCode === 9;
  }
  const _LineRangeFragment = class _LineRangeFragment {
    static getKey(chr) {
      let key = this.chrKeys.get(chr);
      if (key === void 0) {
        key = this.chrKeys.size;
        this.chrKeys.set(chr, key);
      }
      return key;
    }
    constructor(range, lines, source) {
      this.range = range;
      this.lines = lines;
      this.source = source;
      this.histogram = [];
      let counter = 0;
      for (let i = range.startLineNumber - 1; i < range.endLineNumberExclusive - 1; i++) {
        const line = lines[i];
        for (let j = 0; j < line.length; j++) {
          counter++;
          const chr = line[j];
          const key2 = _LineRangeFragment.getKey(chr);
          this.histogram[key2] = (this.histogram[key2] || 0) + 1;
        }
        counter++;
        const key = _LineRangeFragment.getKey("\n");
        this.histogram[key] = (this.histogram[key] || 0) + 1;
      }
      this.totalCount = counter;
    }
    computeSimilarity(other) {
      let sumDifferences = 0;
      const maxLength = Math.max(this.histogram.length, other.histogram.length);
      for (let i = 0; i < maxLength; i++) {
        sumDifferences += Math.abs((this.histogram[i] ?? 0) - (other.histogram[i] ?? 0));
      }
      return 1 - sumDifferences / (this.totalCount + other.totalCount);
    }
  };
  _LineRangeFragment.chrKeys = /* @__PURE__ */ new Map();
  let LineRangeFragment = _LineRangeFragment;
  class DynamicProgrammingDiffing {
    compute(sequence1, sequence2, timeout = InfiniteTimeout.instance, equalityScore) {
      if (sequence1.length === 0 || sequence2.length === 0) {
        return DiffAlgorithmResult.trivial(sequence1, sequence2);
      }
      const lcsLengths = new Array2D(sequence1.length, sequence2.length);
      const directions = new Array2D(sequence1.length, sequence2.length);
      const lengths = new Array2D(sequence1.length, sequence2.length);
      for (let s12 = 0; s12 < sequence1.length; s12++) {
        for (let s22 = 0; s22 < sequence2.length; s22++) {
          if (!timeout.isValid()) {
            return DiffAlgorithmResult.trivialTimedOut(sequence1, sequence2);
          }
          const horizontalLen = s12 === 0 ? 0 : lcsLengths.get(s12 - 1, s22);
          const verticalLen = s22 === 0 ? 0 : lcsLengths.get(s12, s22 - 1);
          let extendedSeqScore;
          if (sequence1.getElement(s12) === sequence2.getElement(s22)) {
            if (s12 === 0 || s22 === 0) {
              extendedSeqScore = 0;
            } else {
              extendedSeqScore = lcsLengths.get(s12 - 1, s22 - 1);
            }
            if (s12 > 0 && s22 > 0 && directions.get(s12 - 1, s22 - 1) === 3) {
              extendedSeqScore += lengths.get(s12 - 1, s22 - 1);
            }
            extendedSeqScore += equalityScore ? equalityScore(s12, s22) : 1;
          } else {
            extendedSeqScore = -1;
          }
          const newValue = Math.max(horizontalLen, verticalLen, extendedSeqScore);
          if (newValue === extendedSeqScore) {
            const prevLen = s12 > 0 && s22 > 0 ? lengths.get(s12 - 1, s22 - 1) : 0;
            lengths.set(s12, s22, prevLen + 1);
            directions.set(s12, s22, 3);
          } else if (newValue === horizontalLen) {
            lengths.set(s12, s22, 0);
            directions.set(s12, s22, 1);
          } else if (newValue === verticalLen) {
            lengths.set(s12, s22, 0);
            directions.set(s12, s22, 2);
          }
          lcsLengths.set(s12, s22, newValue);
        }
      }
      const result = [];
      let lastAligningPosS1 = sequence1.length;
      let lastAligningPosS2 = sequence2.length;
      function reportDecreasingAligningPositions(s12, s22) {
        if (s12 + 1 !== lastAligningPosS1 || s22 + 1 !== lastAligningPosS2) {
          result.push(new SequenceDiff(new OffsetRange(s12 + 1, lastAligningPosS1), new OffsetRange(s22 + 1, lastAligningPosS2)));
        }
        lastAligningPosS1 = s12;
        lastAligningPosS2 = s22;
      }
      let s1 = sequence1.length - 1;
      let s2 = sequence2.length - 1;
      while (s1 >= 0 && s2 >= 0) {
        if (directions.get(s1, s2) === 3) {
          reportDecreasingAligningPositions(s1, s2);
          s1--;
          s2--;
        } else {
          if (directions.get(s1, s2) === 1) {
            s1--;
          } else {
            s2--;
          }
        }
      }
      reportDecreasingAligningPositions(-1, -1);
      result.reverse();
      return new DiffAlgorithmResult(result, false);
    }
  }
  class MyersDiffAlgorithm {
    compute(seq1, seq2, timeout = InfiniteTimeout.instance) {
      if (seq1.length === 0 || seq2.length === 0) {
        return DiffAlgorithmResult.trivial(seq1, seq2);
      }
      const seqX = seq1;
      const seqY = seq2;
      function getXAfterSnake(x, y) {
        while (x < seqX.length && y < seqY.length && seqX.getElement(x) === seqY.getElement(y)) {
          x++;
          y++;
        }
        return x;
      }
      let d = 0;
      const V = new FastInt32Array();
      V.set(0, getXAfterSnake(0, 0));
      const paths = new FastArrayNegativeIndices();
      paths.set(0, V.get(0) === 0 ? null : new SnakePath(null, 0, 0, V.get(0)));
      let k = 0;
      loop: while (true) {
        d++;
        if (!timeout.isValid()) {
          return DiffAlgorithmResult.trivialTimedOut(seqX, seqY);
        }
        const lowerBound = -Math.min(d, seqY.length + d % 2);
        const upperBound = Math.min(d, seqX.length + d % 2);
        for (k = lowerBound; k <= upperBound; k += 2) {
          const maxXofDLineTop = k === upperBound ? -1 : V.get(k + 1);
          const maxXofDLineLeft = k === lowerBound ? -1 : V.get(k - 1) + 1;
          const x = Math.min(Math.max(maxXofDLineTop, maxXofDLineLeft), seqX.length);
          const y = x - k;
          if (x > seqX.length || y > seqY.length) {
            continue;
          }
          const newMaxX = getXAfterSnake(x, y);
          V.set(k, newMaxX);
          const lastPath = x === maxXofDLineTop ? paths.get(k + 1) : paths.get(k - 1);
          paths.set(k, newMaxX !== x ? new SnakePath(lastPath, x, y, newMaxX - x) : lastPath);
          if (V.get(k) === seqX.length && V.get(k) - k === seqY.length) {
            break loop;
          }
        }
      }
      let path = paths.get(k);
      const result = [];
      let lastAligningPosS1 = seqX.length;
      let lastAligningPosS2 = seqY.length;
      while (true) {
        const endX = path ? path.x + path.length : 0;
        const endY = path ? path.y + path.length : 0;
        if (endX !== lastAligningPosS1 || endY !== lastAligningPosS2) {
          result.push(new SequenceDiff(new OffsetRange(endX, lastAligningPosS1), new OffsetRange(endY, lastAligningPosS2)));
        }
        if (!path) {
          break;
        }
        lastAligningPosS1 = path.x;
        lastAligningPosS2 = path.y;
        path = path.prev;
      }
      result.reverse();
      return new DiffAlgorithmResult(result, false);
    }
  }
  class SnakePath {
    constructor(prev, x, y, length) {
      this.prev = prev;
      this.x = x;
      this.y = y;
      this.length = length;
    }
  }
  class FastInt32Array {
    constructor() {
      this.positiveArr = new Int32Array(10);
      this.negativeArr = new Int32Array(10);
    }
    get(idx) {
      if (idx < 0) {
        idx = -idx - 1;
        return this.negativeArr[idx];
      } else {
        return this.positiveArr[idx];
      }
    }
    set(idx, value) {
      if (idx < 0) {
        idx = -idx - 1;
        if (idx >= this.negativeArr.length) {
          const arr = this.negativeArr;
          this.negativeArr = new Int32Array(arr.length * 2);
          this.negativeArr.set(arr);
        }
        this.negativeArr[idx] = value;
      } else {
        if (idx >= this.positiveArr.length) {
          const arr = this.positiveArr;
          this.positiveArr = new Int32Array(arr.length * 2);
          this.positiveArr.set(arr);
        }
        this.positiveArr[idx] = value;
      }
    }
  }
  class FastArrayNegativeIndices {
    constructor() {
      this.positiveArr = [];
      this.negativeArr = [];
    }
    get(idx) {
      if (idx < 0) {
        idx = -idx - 1;
        return this.negativeArr[idx];
      } else {
        return this.positiveArr[idx];
      }
    }
    set(idx, value) {
      if (idx < 0) {
        idx = -idx - 1;
        this.negativeArr[idx] = value;
      } else {
        this.positiveArr[idx] = value;
      }
    }
  }
  class LinesSliceCharSequence {
    constructor(lines, range, considerWhitespaceChanges) {
      this.lines = lines;
      this.range = range;
      this.considerWhitespaceChanges = considerWhitespaceChanges;
      this.elements = [];
      this.firstElementOffsetByLineIdx = [];
      this.lineStartOffsets = [];
      this.trimmedWsLengthsByLineIdx = [];
      this.firstElementOffsetByLineIdx.push(0);
      for (let lineNumber = this.range.startLineNumber; lineNumber <= this.range.endLineNumber; lineNumber++) {
        let line = lines[lineNumber - 1];
        let lineStartOffset = 0;
        if (lineNumber === this.range.startLineNumber && this.range.startColumn > 1) {
          lineStartOffset = this.range.startColumn - 1;
          line = line.substring(lineStartOffset);
        }
        this.lineStartOffsets.push(lineStartOffset);
        let trimmedWsLength = 0;
        if (!considerWhitespaceChanges) {
          const trimmedStartLine = line.trimStart();
          trimmedWsLength = line.length - trimmedStartLine.length;
          line = trimmedStartLine.trimEnd();
        }
        this.trimmedWsLengthsByLineIdx.push(trimmedWsLength);
        const lineLength = lineNumber === this.range.endLineNumber ? Math.min(this.range.endColumn - 1 - lineStartOffset - trimmedWsLength, line.length) : line.length;
        for (let i = 0; i < lineLength; i++) {
          this.elements.push(line.charCodeAt(i));
        }
        if (lineNumber < this.range.endLineNumber) {
          this.elements.push("\n".charCodeAt(0));
          this.firstElementOffsetByLineIdx.push(this.elements.length);
        }
      }
    }
    toString() {
      return `Slice: "${this.text}"`;
    }
    get text() {
      return this.getText(new OffsetRange(0, this.length));
    }
    getText(range) {
      return this.elements.slice(range.start, range.endExclusive).map((e) => String.fromCharCode(e)).join("");
    }
    getElement(offset) {
      return this.elements[offset];
    }
    get length() {
      return this.elements.length;
    }
    getBoundaryScore(length) {
      const prevCategory = getCategory(length > 0 ? this.elements[length - 1] : -1);
      const nextCategory = getCategory(length < this.elements.length ? this.elements[length] : -1);
      if (prevCategory === 7 && nextCategory === 8) {
        return 0;
      }
      if (prevCategory === 8) {
        return 150;
      }
      let score2 = 0;
      if (prevCategory !== nextCategory) {
        score2 += 10;
        if (prevCategory === 0 && nextCategory === 1) {
          score2 += 1;
        }
      }
      score2 += getCategoryBoundaryScore(prevCategory);
      score2 += getCategoryBoundaryScore(nextCategory);
      return score2;
    }
    translateOffset(offset, preference = "right") {
      const i = findLastIdxMonotonous(this.firstElementOffsetByLineIdx, (value) => value <= offset);
      const lineOffset = offset - this.firstElementOffsetByLineIdx[i];
      return new Position$1(this.range.startLineNumber + i, 1 + this.lineStartOffsets[i] + lineOffset + (lineOffset === 0 && preference === "left" ? 0 : this.trimmedWsLengthsByLineIdx[i]));
    }
    translateRange(range) {
      const pos1 = this.translateOffset(range.start, "right");
      const pos2 = this.translateOffset(range.endExclusive, "left");
      if (pos2.isBefore(pos1)) {
        return Range$1.fromPositions(pos2, pos2);
      }
      return Range$1.fromPositions(pos1, pos2);
    }
    /**
     * Finds the word that contains the character at the given offset
     */
    findWordContaining(offset) {
      if (offset < 0 || offset >= this.elements.length) {
        return void 0;
      }
      if (!isWordChar(this.elements[offset])) {
        return void 0;
      }
      let start2 = offset;
      while (start2 > 0 && isWordChar(this.elements[start2 - 1])) {
        start2--;
      }
      let end = offset;
      while (end < this.elements.length && isWordChar(this.elements[end])) {
        end++;
      }
      return new OffsetRange(start2, end);
    }
    /** fooBar has the two sub-words foo and bar */
    findSubWordContaining(offset) {
      if (offset < 0 || offset >= this.elements.length) {
        return void 0;
      }
      if (!isWordChar(this.elements[offset])) {
        return void 0;
      }
      let start2 = offset;
      while (start2 > 0 && isWordChar(this.elements[start2 - 1]) && !isUpperCase(this.elements[start2])) {
        start2--;
      }
      let end = offset;
      while (end < this.elements.length && isWordChar(this.elements[end]) && !isUpperCase(this.elements[end])) {
        end++;
      }
      return new OffsetRange(start2, end);
    }
    countLinesIn(range) {
      return this.translateOffset(range.endExclusive).lineNumber - this.translateOffset(range.start).lineNumber;
    }
    isStronglyEqual(offset1, offset2) {
      return this.elements[offset1] === this.elements[offset2];
    }
    extendToFullLines(range) {
      const start2 = findLastMonotonous(this.firstElementOffsetByLineIdx, (x) => x <= range.start) ?? 0;
      const end = findFirstMonotonous(this.firstElementOffsetByLineIdx, (x) => range.endExclusive <= x) ?? this.elements.length;
      return new OffsetRange(start2, end);
    }
  }
  function isWordChar(charCode) {
    return charCode >= 97 && charCode <= 122 || charCode >= 65 && charCode <= 90 || charCode >= 48 && charCode <= 57;
  }
  function isUpperCase(charCode) {
    return charCode >= 65 && charCode <= 90;
  }
  const score = {
    [
      0
      /* CharBoundaryCategory.WordLower */
    ]: 0,
    [
      1
      /* CharBoundaryCategory.WordUpper */
    ]: 0,
    [
      2
      /* CharBoundaryCategory.WordNumber */
    ]: 0,
    [
      3
      /* CharBoundaryCategory.End */
    ]: 10,
    [
      4
      /* CharBoundaryCategory.Other */
    ]: 2,
    [
      5
      /* CharBoundaryCategory.Separator */
    ]: 30,
    [
      6
      /* CharBoundaryCategory.Space */
    ]: 3,
    [
      7
      /* CharBoundaryCategory.LineBreakCR */
    ]: 10,
    [
      8
      /* CharBoundaryCategory.LineBreakLF */
    ]: 10
  };
  function getCategoryBoundaryScore(category) {
    return score[category];
  }
  function getCategory(charCode) {
    if (charCode === 10) {
      return 8;
    } else if (charCode === 13) {
      return 7;
    } else if (isSpace(charCode)) {
      return 6;
    } else if (charCode >= 97 && charCode <= 122) {
      return 0;
    } else if (charCode >= 65 && charCode <= 90) {
      return 1;
    } else if (charCode >= 48 && charCode <= 57) {
      return 2;
    } else if (charCode === -1) {
      return 3;
    } else if (charCode === 44 || charCode === 59) {
      return 5;
    } else {
      return 4;
    }
  }
  function computeMovedLines(changes, originalLines, modifiedLines, hashedOriginalLines, hashedModifiedLines, timeout) {
    let { moves, excludedChanges } = computeMovesFromSimpleDeletionsToSimpleInsertions(changes, originalLines, modifiedLines, timeout);
    if (!timeout.isValid()) {
      return [];
    }
    const filteredChanges = changes.filter((c) => !excludedChanges.has(c));
    const unchangedMoves = computeUnchangedMoves(filteredChanges, hashedOriginalLines, hashedModifiedLines, originalLines, modifiedLines, timeout);
    pushMany(moves, unchangedMoves);
    moves = joinCloseConsecutiveMoves(moves);
    moves = moves.filter((current) => {
      const lines = current.original.toOffsetRange().slice(originalLines).map((l) => l.trim());
      const originalText = lines.join("\n");
      return originalText.length >= 15 && countWhere(lines, (l) => l.length >= 2) >= 2;
    });
    moves = removeMovesInSameDiff(changes, moves);
    return moves;
  }
  function countWhere(arr, predicate) {
    let count = 0;
    for (const t2 of arr) {
      if (predicate(t2)) {
        count++;
      }
    }
    return count;
  }
  function computeMovesFromSimpleDeletionsToSimpleInsertions(changes, originalLines, modifiedLines, timeout) {
    const moves = [];
    const deletions = changes.filter((c) => c.modified.isEmpty && c.original.length >= 3).map((d) => new LineRangeFragment(d.original, originalLines, d));
    const insertions = new Set(changes.filter((c) => c.original.isEmpty && c.modified.length >= 3).map((d) => new LineRangeFragment(d.modified, modifiedLines, d)));
    const excludedChanges = /* @__PURE__ */ new Set();
    for (const deletion of deletions) {
      let highestSimilarity = -1;
      let best;
      for (const insertion of insertions) {
        const similarity = deletion.computeSimilarity(insertion);
        if (similarity > highestSimilarity) {
          highestSimilarity = similarity;
          best = insertion;
        }
      }
      if (highestSimilarity > 0.9 && best) {
        insertions.delete(best);
        moves.push(new LineRangeMapping(deletion.range, best.range));
        excludedChanges.add(deletion.source);
        excludedChanges.add(best.source);
      }
      if (!timeout.isValid()) {
        return { moves, excludedChanges };
      }
    }
    return { moves, excludedChanges };
  }
  function computeUnchangedMoves(changes, hashedOriginalLines, hashedModifiedLines, originalLines, modifiedLines, timeout) {
    const moves = [];
    const original3LineHashes = new SetMap();
    for (const change of changes) {
      for (let i = change.original.startLineNumber; i < change.original.endLineNumberExclusive - 2; i++) {
        const key = `${hashedOriginalLines[i - 1]}:${hashedOriginalLines[i + 1 - 1]}:${hashedOriginalLines[i + 2 - 1]}`;
        original3LineHashes.add(key, { range: new LineRange(i, i + 3) });
      }
    }
    const possibleMappings = [];
    changes.sort(compareBy((c) => c.modified.startLineNumber, numberComparator));
    for (const change of changes) {
      let lastMappings = [];
      for (let i = change.modified.startLineNumber; i < change.modified.endLineNumberExclusive - 2; i++) {
        const key = `${hashedModifiedLines[i - 1]}:${hashedModifiedLines[i + 1 - 1]}:${hashedModifiedLines[i + 2 - 1]}`;
        const currentModifiedRange = new LineRange(i, i + 3);
        const nextMappings = [];
        original3LineHashes.forEach(key, ({ range }) => {
          for (const lastMapping of lastMappings) {
            if (lastMapping.originalLineRange.endLineNumberExclusive + 1 === range.endLineNumberExclusive && lastMapping.modifiedLineRange.endLineNumberExclusive + 1 === currentModifiedRange.endLineNumberExclusive) {
              lastMapping.originalLineRange = new LineRange(lastMapping.originalLineRange.startLineNumber, range.endLineNumberExclusive);
              lastMapping.modifiedLineRange = new LineRange(lastMapping.modifiedLineRange.startLineNumber, currentModifiedRange.endLineNumberExclusive);
              nextMappings.push(lastMapping);
              return;
            }
          }
          const mapping = {
            modifiedLineRange: currentModifiedRange,
            originalLineRange: range
          };
          possibleMappings.push(mapping);
          nextMappings.push(mapping);
        });
        lastMappings = nextMappings;
      }
      if (!timeout.isValid()) {
        return [];
      }
    }
    possibleMappings.sort(reverseOrder(compareBy((m) => m.modifiedLineRange.length, numberComparator)));
    const modifiedSet = new LineRangeSet();
    const originalSet = new LineRangeSet();
    for (const mapping of possibleMappings) {
      const diffOrigToMod = mapping.modifiedLineRange.startLineNumber - mapping.originalLineRange.startLineNumber;
      const modifiedSections = modifiedSet.subtractFrom(mapping.modifiedLineRange);
      const originalTranslatedSections = originalSet.subtractFrom(mapping.originalLineRange).getWithDelta(diffOrigToMod);
      const modifiedIntersectedSections = modifiedSections.getIntersection(originalTranslatedSections);
      for (const s of modifiedIntersectedSections.ranges) {
        if (s.length < 3) {
          continue;
        }
        const modifiedLineRange = s;
        const originalLineRange = s.delta(-diffOrigToMod);
        moves.push(new LineRangeMapping(originalLineRange, modifiedLineRange));
        modifiedSet.addRange(modifiedLineRange);
        originalSet.addRange(originalLineRange);
      }
    }
    moves.sort(compareBy((m) => m.original.startLineNumber, numberComparator));
    const monotonousChanges = new MonotonousArray(changes);
    for (let i = 0; i < moves.length; i++) {
      const move = moves[i];
      const firstTouchingChangeOrig = monotonousChanges.findLastMonotonous((c) => c.original.startLineNumber <= move.original.startLineNumber);
      const firstTouchingChangeMod = findLastMonotonous(changes, (c) => c.modified.startLineNumber <= move.modified.startLineNumber);
      const linesAbove = Math.max(move.original.startLineNumber - firstTouchingChangeOrig.original.startLineNumber, move.modified.startLineNumber - firstTouchingChangeMod.modified.startLineNumber);
      const lastTouchingChangeOrig = monotonousChanges.findLastMonotonous((c) => c.original.startLineNumber < move.original.endLineNumberExclusive);
      const lastTouchingChangeMod = findLastMonotonous(changes, (c) => c.modified.startLineNumber < move.modified.endLineNumberExclusive);
      const linesBelow = Math.max(lastTouchingChangeOrig.original.endLineNumberExclusive - move.original.endLineNumberExclusive, lastTouchingChangeMod.modified.endLineNumberExclusive - move.modified.endLineNumberExclusive);
      let extendToTop;
      for (extendToTop = 0; extendToTop < linesAbove; extendToTop++) {
        const origLine = move.original.startLineNumber - extendToTop - 1;
        const modLine = move.modified.startLineNumber - extendToTop - 1;
        if (origLine > originalLines.length || modLine > modifiedLines.length) {
          break;
        }
        if (modifiedSet.contains(modLine) || originalSet.contains(origLine)) {
          break;
        }
        if (!areLinesSimilar(originalLines[origLine - 1], modifiedLines[modLine - 1], timeout)) {
          break;
        }
      }
      if (extendToTop > 0) {
        originalSet.addRange(new LineRange(move.original.startLineNumber - extendToTop, move.original.startLineNumber));
        modifiedSet.addRange(new LineRange(move.modified.startLineNumber - extendToTop, move.modified.startLineNumber));
      }
      let extendToBottom;
      for (extendToBottom = 0; extendToBottom < linesBelow; extendToBottom++) {
        const origLine = move.original.endLineNumberExclusive + extendToBottom;
        const modLine = move.modified.endLineNumberExclusive + extendToBottom;
        if (origLine > originalLines.length || modLine > modifiedLines.length) {
          break;
        }
        if (modifiedSet.contains(modLine) || originalSet.contains(origLine)) {
          break;
        }
        if (!areLinesSimilar(originalLines[origLine - 1], modifiedLines[modLine - 1], timeout)) {
          break;
        }
      }
      if (extendToBottom > 0) {
        originalSet.addRange(new LineRange(move.original.endLineNumberExclusive, move.original.endLineNumberExclusive + extendToBottom));
        modifiedSet.addRange(new LineRange(move.modified.endLineNumberExclusive, move.modified.endLineNumberExclusive + extendToBottom));
      }
      if (extendToTop > 0 || extendToBottom > 0) {
        moves[i] = new LineRangeMapping(new LineRange(move.original.startLineNumber - extendToTop, move.original.endLineNumberExclusive + extendToBottom), new LineRange(move.modified.startLineNumber - extendToTop, move.modified.endLineNumberExclusive + extendToBottom));
      }
    }
    return moves;
  }
  function areLinesSimilar(line1, line2, timeout) {
    if (line1.trim() === line2.trim()) {
      return true;
    }
    if (line1.length > 300 && line2.length > 300) {
      return false;
    }
    const myersDiffingAlgorithm = new MyersDiffAlgorithm();
    const result = myersDiffingAlgorithm.compute(new LinesSliceCharSequence([line1], new Range$1(1, 1, 1, line1.length), false), new LinesSliceCharSequence([line2], new Range$1(1, 1, 1, line2.length), false), timeout);
    let commonNonSpaceCharCount = 0;
    const inverted = SequenceDiff.invert(result.diffs, line1.length);
    for (const seq of inverted) {
      seq.seq1Range.forEach((idx) => {
        if (!isSpace(line1.charCodeAt(idx))) {
          commonNonSpaceCharCount++;
        }
      });
    }
    function countNonWsChars(str) {
      let count = 0;
      for (let i = 0; i < line1.length; i++) {
        if (!isSpace(str.charCodeAt(i))) {
          count++;
        }
      }
      return count;
    }
    const longerLineLength = countNonWsChars(line1.length > line2.length ? line1 : line2);
    const r = commonNonSpaceCharCount / longerLineLength > 0.6 && longerLineLength > 10;
    return r;
  }
  function joinCloseConsecutiveMoves(moves) {
    if (moves.length === 0) {
      return moves;
    }
    moves.sort(compareBy((m) => m.original.startLineNumber, numberComparator));
    const result = [moves[0]];
    for (let i = 1; i < moves.length; i++) {
      const last = result[result.length - 1];
      const current = moves[i];
      const originalDist = current.original.startLineNumber - last.original.endLineNumberExclusive;
      const modifiedDist = current.modified.startLineNumber - last.modified.endLineNumberExclusive;
      const currentMoveAfterLast = originalDist >= 0 && modifiedDist >= 0;
      if (currentMoveAfterLast && originalDist + modifiedDist <= 2) {
        result[result.length - 1] = last.join(current);
        continue;
      }
      result.push(current);
    }
    return result;
  }
  function removeMovesInSameDiff(changes, moves) {
    const changesMonotonous = new MonotonousArray(changes);
    moves = moves.filter((m) => {
      const diffBeforeEndOfMoveOriginal = changesMonotonous.findLastMonotonous((c) => c.original.startLineNumber < m.original.endLineNumberExclusive) || new LineRangeMapping(new LineRange(1, 1), new LineRange(1, 1));
      const diffBeforeEndOfMoveModified = findLastMonotonous(changes, (c) => c.modified.startLineNumber < m.modified.endLineNumberExclusive);
      const differentDiffs = diffBeforeEndOfMoveOriginal !== diffBeforeEndOfMoveModified;
      return differentDiffs;
    });
    return moves;
  }
  function optimizeSequenceDiffs(sequence1, sequence2, sequenceDiffs) {
    let result = sequenceDiffs;
    result = joinSequenceDiffsByShifting(sequence1, sequence2, result);
    result = joinSequenceDiffsByShifting(sequence1, sequence2, result);
    result = shiftSequenceDiffs(sequence1, sequence2, result);
    return result;
  }
  function joinSequenceDiffsByShifting(sequence1, sequence2, sequenceDiffs) {
    if (sequenceDiffs.length === 0) {
      return sequenceDiffs;
    }
    const result = [];
    result.push(sequenceDiffs[0]);
    for (let i = 1; i < sequenceDiffs.length; i++) {
      const prevResult = result[result.length - 1];
      let cur = sequenceDiffs[i];
      if (cur.seq1Range.isEmpty || cur.seq2Range.isEmpty) {
        const length = cur.seq1Range.start - prevResult.seq1Range.endExclusive;
        let d;
        for (d = 1; d <= length; d++) {
          if (sequence1.getElement(cur.seq1Range.start - d) !== sequence1.getElement(cur.seq1Range.endExclusive - d) || sequence2.getElement(cur.seq2Range.start - d) !== sequence2.getElement(cur.seq2Range.endExclusive - d)) {
            break;
          }
        }
        d--;
        if (d === length) {
          result[result.length - 1] = new SequenceDiff(new OffsetRange(prevResult.seq1Range.start, cur.seq1Range.endExclusive - length), new OffsetRange(prevResult.seq2Range.start, cur.seq2Range.endExclusive - length));
          continue;
        }
        cur = cur.delta(-d);
      }
      result.push(cur);
    }
    const result2 = [];
    for (let i = 0; i < result.length - 1; i++) {
      const nextResult = result[i + 1];
      let cur = result[i];
      if (cur.seq1Range.isEmpty || cur.seq2Range.isEmpty) {
        const length = nextResult.seq1Range.start - cur.seq1Range.endExclusive;
        let d;
        for (d = 0; d < length; d++) {
          if (!sequence1.isStronglyEqual(cur.seq1Range.start + d, cur.seq1Range.endExclusive + d) || !sequence2.isStronglyEqual(cur.seq2Range.start + d, cur.seq2Range.endExclusive + d)) {
            break;
          }
        }
        if (d === length) {
          result[i + 1] = new SequenceDiff(new OffsetRange(cur.seq1Range.start + length, nextResult.seq1Range.endExclusive), new OffsetRange(cur.seq2Range.start + length, nextResult.seq2Range.endExclusive));
          continue;
        }
        if (d > 0) {
          cur = cur.delta(d);
        }
      }
      result2.push(cur);
    }
    if (result.length > 0) {
      result2.push(result[result.length - 1]);
    }
    return result2;
  }
  function shiftSequenceDiffs(sequence1, sequence2, sequenceDiffs) {
    if (!sequence1.getBoundaryScore || !sequence2.getBoundaryScore) {
      return sequenceDiffs;
    }
    for (let i = 0; i < sequenceDiffs.length; i++) {
      const prevDiff = i > 0 ? sequenceDiffs[i - 1] : void 0;
      const diff = sequenceDiffs[i];
      const nextDiff = i + 1 < sequenceDiffs.length ? sequenceDiffs[i + 1] : void 0;
      const seq1ValidRange = new OffsetRange(prevDiff ? prevDiff.seq1Range.endExclusive + 1 : 0, nextDiff ? nextDiff.seq1Range.start - 1 : sequence1.length);
      const seq2ValidRange = new OffsetRange(prevDiff ? prevDiff.seq2Range.endExclusive + 1 : 0, nextDiff ? nextDiff.seq2Range.start - 1 : sequence2.length);
      if (diff.seq1Range.isEmpty) {
        sequenceDiffs[i] = shiftDiffToBetterPosition(diff, sequence1, sequence2, seq1ValidRange, seq2ValidRange);
      } else if (diff.seq2Range.isEmpty) {
        sequenceDiffs[i] = shiftDiffToBetterPosition(diff.swap(), sequence2, sequence1, seq2ValidRange, seq1ValidRange).swap();
      }
    }
    return sequenceDiffs;
  }
  function shiftDiffToBetterPosition(diff, sequence1, sequence2, seq1ValidRange, seq2ValidRange) {
    const maxShiftLimit = 100;
    let deltaBefore = 1;
    while (diff.seq1Range.start - deltaBefore >= seq1ValidRange.start && diff.seq2Range.start - deltaBefore >= seq2ValidRange.start && sequence2.isStronglyEqual(diff.seq2Range.start - deltaBefore, diff.seq2Range.endExclusive - deltaBefore) && deltaBefore < maxShiftLimit) {
      deltaBefore++;
    }
    deltaBefore--;
    let deltaAfter = 0;
    while (diff.seq1Range.start + deltaAfter < seq1ValidRange.endExclusive && diff.seq2Range.endExclusive + deltaAfter < seq2ValidRange.endExclusive && sequence2.isStronglyEqual(diff.seq2Range.start + deltaAfter, diff.seq2Range.endExclusive + deltaAfter) && deltaAfter < maxShiftLimit) {
      deltaAfter++;
    }
    if (deltaBefore === 0 && deltaAfter === 0) {
      return diff;
    }
    let bestDelta = 0;
    let bestScore = -1;
    for (let delta = -deltaBefore; delta <= deltaAfter; delta++) {
      const seq2OffsetStart = diff.seq2Range.start + delta;
      const seq2OffsetEndExclusive = diff.seq2Range.endExclusive + delta;
      const seq1Offset = diff.seq1Range.start + delta;
      const score2 = sequence1.getBoundaryScore(seq1Offset) + sequence2.getBoundaryScore(seq2OffsetStart) + sequence2.getBoundaryScore(seq2OffsetEndExclusive);
      if (score2 > bestScore) {
        bestScore = score2;
        bestDelta = delta;
      }
    }
    return diff.delta(bestDelta);
  }
  function removeShortMatches(sequence1, sequence2, sequenceDiffs) {
    const result = [];
    for (const s of sequenceDiffs) {
      const last = result[result.length - 1];
      if (!last) {
        result.push(s);
        continue;
      }
      if (s.seq1Range.start - last.seq1Range.endExclusive <= 2 || s.seq2Range.start - last.seq2Range.endExclusive <= 2) {
        result[result.length - 1] = new SequenceDiff(last.seq1Range.join(s.seq1Range), last.seq2Range.join(s.seq2Range));
      } else {
        result.push(s);
      }
    }
    return result;
  }
  function extendDiffsToEntireWordIfAppropriate(sequence1, sequence2, sequenceDiffs, findParent, force = false) {
    const equalMappings = SequenceDiff.invert(sequenceDiffs, sequence1.length);
    const additional = [];
    let lastPoint = new OffsetPair(0, 0);
    function scanWord(pair, equalMapping) {
      if (pair.offset1 < lastPoint.offset1 || pair.offset2 < lastPoint.offset2) {
        return;
      }
      const w1 = findParent(sequence1, pair.offset1);
      const w2 = findParent(sequence2, pair.offset2);
      if (!w1 || !w2) {
        return;
      }
      let w = new SequenceDiff(w1, w2);
      const equalPart = w.intersect(equalMapping);
      let equalChars1 = equalPart.seq1Range.length;
      let equalChars2 = equalPart.seq2Range.length;
      while (equalMappings.length > 0) {
        const next = equalMappings[0];
        const intersects = next.seq1Range.intersects(w.seq1Range) || next.seq2Range.intersects(w.seq2Range);
        if (!intersects) {
          break;
        }
        const v1 = findParent(sequence1, next.seq1Range.start);
        const v2 = findParent(sequence2, next.seq2Range.start);
        const v = new SequenceDiff(v1, v2);
        const equalPart2 = v.intersect(next);
        equalChars1 += equalPart2.seq1Range.length;
        equalChars2 += equalPart2.seq2Range.length;
        w = w.join(v);
        if (w.seq1Range.endExclusive >= next.seq1Range.endExclusive) {
          equalMappings.shift();
        } else {
          break;
        }
      }
      if (force && equalChars1 + equalChars2 < w.seq1Range.length + w.seq2Range.length || equalChars1 + equalChars2 < (w.seq1Range.length + w.seq2Range.length) * 2 / 3) {
        additional.push(w);
      }
      lastPoint = w.getEndExclusives();
    }
    while (equalMappings.length > 0) {
      const next = equalMappings.shift();
      if (next.seq1Range.isEmpty) {
        continue;
      }
      scanWord(next.getStarts(), next);
      scanWord(next.getEndExclusives().delta(-1), next);
    }
    const merged = mergeSequenceDiffs(sequenceDiffs, additional);
    return merged;
  }
  function mergeSequenceDiffs(sequenceDiffs1, sequenceDiffs2) {
    const result = [];
    while (sequenceDiffs1.length > 0 || sequenceDiffs2.length > 0) {
      const sd1 = sequenceDiffs1[0];
      const sd2 = sequenceDiffs2[0];
      let next;
      if (sd1 && (!sd2 || sd1.seq1Range.start < sd2.seq1Range.start)) {
        next = sequenceDiffs1.shift();
      } else {
        next = sequenceDiffs2.shift();
      }
      if (result.length > 0 && result[result.length - 1].seq1Range.endExclusive >= next.seq1Range.start) {
        result[result.length - 1] = result[result.length - 1].join(next);
      } else {
        result.push(next);
      }
    }
    return result;
  }
  function removeVeryShortMatchingLinesBetweenDiffs(sequence1, _sequence2, sequenceDiffs) {
    let diffs = sequenceDiffs;
    if (diffs.length === 0) {
      return diffs;
    }
    let counter = 0;
    let shouldRepeat;
    do {
      shouldRepeat = false;
      const result = [
        diffs[0]
      ];
      for (let i = 1; i < diffs.length; i++) {
        let shouldJoinDiffs = function(before, after) {
          const unchangedRange = new OffsetRange(lastResult.seq1Range.endExclusive, cur.seq1Range.start);
          const unchangedText = sequence1.getText(unchangedRange);
          const unchangedTextWithoutWs = unchangedText.replace(/\s/g, "");
          if (unchangedTextWithoutWs.length <= 4 && (before.seq1Range.length + before.seq2Range.length > 5 || after.seq1Range.length + after.seq2Range.length > 5)) {
            return true;
          }
          return false;
        };
        const cur = diffs[i];
        const lastResult = result[result.length - 1];
        const shouldJoin = shouldJoinDiffs(lastResult, cur);
        if (shouldJoin) {
          shouldRepeat = true;
          result[result.length - 1] = result[result.length - 1].join(cur);
        } else {
          result.push(cur);
        }
      }
      diffs = result;
    } while (counter++ < 10 && shouldRepeat);
    return diffs;
  }
  function removeVeryShortMatchingTextBetweenLongDiffs(sequence1, sequence2, sequenceDiffs) {
    let diffs = sequenceDiffs;
    if (diffs.length === 0) {
      return diffs;
    }
    let counter = 0;
    let shouldRepeat;
    do {
      shouldRepeat = false;
      const result = [
        diffs[0]
      ];
      for (let i = 1; i < diffs.length; i++) {
        let shouldJoinDiffs = function(before, after) {
          const unchangedRange = new OffsetRange(lastResult.seq1Range.endExclusive, cur.seq1Range.start);
          const unchangedLineCount = sequence1.countLinesIn(unchangedRange);
          if (unchangedLineCount > 5 || unchangedRange.length > 500) {
            return false;
          }
          const unchangedText = sequence1.getText(unchangedRange).trim();
          if (unchangedText.length > 20 || unchangedText.split(/\r\n|\r|\n/).length > 1) {
            return false;
          }
          const beforeLineCount1 = sequence1.countLinesIn(before.seq1Range);
          const beforeSeq1Length = before.seq1Range.length;
          const beforeLineCount2 = sequence2.countLinesIn(before.seq2Range);
          const beforeSeq2Length = before.seq2Range.length;
          const afterLineCount1 = sequence1.countLinesIn(after.seq1Range);
          const afterSeq1Length = after.seq1Range.length;
          const afterLineCount2 = sequence2.countLinesIn(after.seq2Range);
          const afterSeq2Length = after.seq2Range.length;
          const max = 2 * 40 + 50;
          function cap(v) {
            return Math.min(v, max);
          }
          if (Math.pow(Math.pow(cap(beforeLineCount1 * 40 + beforeSeq1Length), 1.5) + Math.pow(cap(beforeLineCount2 * 40 + beforeSeq2Length), 1.5), 1.5) + Math.pow(Math.pow(cap(afterLineCount1 * 40 + afterSeq1Length), 1.5) + Math.pow(cap(afterLineCount2 * 40 + afterSeq2Length), 1.5), 1.5) > (max ** 1.5) ** 1.5 * 1.3) {
            return true;
          }
          return false;
        };
        const cur = diffs[i];
        const lastResult = result[result.length - 1];
        const shouldJoin = shouldJoinDiffs(lastResult, cur);
        if (shouldJoin) {
          shouldRepeat = true;
          result[result.length - 1] = result[result.length - 1].join(cur);
        } else {
          result.push(cur);
        }
      }
      diffs = result;
    } while (counter++ < 10 && shouldRepeat);
    const newDiffs = [];
    forEachWithNeighbors(diffs, (prev, cur, next) => {
      let newDiff = cur;
      function shouldMarkAsChanged(text) {
        return text.length > 0 && text.trim().length <= 3 && cur.seq1Range.length + cur.seq2Range.length > 100;
      }
      const fullRange1 = sequence1.extendToFullLines(cur.seq1Range);
      const prefix = sequence1.getText(new OffsetRange(fullRange1.start, cur.seq1Range.start));
      if (shouldMarkAsChanged(prefix)) {
        newDiff = newDiff.deltaStart(-prefix.length);
      }
      const suffix = sequence1.getText(new OffsetRange(cur.seq1Range.endExclusive, fullRange1.endExclusive));
      if (shouldMarkAsChanged(suffix)) {
        newDiff = newDiff.deltaEnd(suffix.length);
      }
      const availableSpace = SequenceDiff.fromOffsetPairs(prev ? prev.getEndExclusives() : OffsetPair.zero, next ? next.getStarts() : OffsetPair.max);
      const result = newDiff.intersect(availableSpace);
      if (newDiffs.length > 0 && result.getStarts().equals(newDiffs[newDiffs.length - 1].getEndExclusives())) {
        newDiffs[newDiffs.length - 1] = newDiffs[newDiffs.length - 1].join(result);
      } else {
        newDiffs.push(result);
      }
    });
    return newDiffs;
  }
  class LineSequence {
    constructor(trimmedHash, lines) {
      this.trimmedHash = trimmedHash;
      this.lines = lines;
    }
    getElement(offset) {
      return this.trimmedHash[offset];
    }
    get length() {
      return this.trimmedHash.length;
    }
    getBoundaryScore(length) {
      const indentationBefore = length === 0 ? 0 : getIndentation(this.lines[length - 1]);
      const indentationAfter = length === this.lines.length ? 0 : getIndentation(this.lines[length]);
      return 1e3 - (indentationBefore + indentationAfter);
    }
    getText(range) {
      return this.lines.slice(range.start, range.endExclusive).join("\n");
    }
    isStronglyEqual(offset1, offset2) {
      return this.lines[offset1] === this.lines[offset2];
    }
  }
  function getIndentation(str) {
    let i = 0;
    while (i < str.length && (str.charCodeAt(i) === 32 || str.charCodeAt(i) === 9)) {
      i++;
    }
    return i;
  }
  class DefaultLinesDiffComputer {
    constructor() {
      this.dynamicProgrammingDiffing = new DynamicProgrammingDiffing();
      this.myersDiffingAlgorithm = new MyersDiffAlgorithm();
    }
    computeDiff(originalLines, modifiedLines, options) {
      if (originalLines.length <= 1 && equals(originalLines, modifiedLines, (a, b) => a === b)) {
        return new LinesDiff([], [], false);
      }
      if (originalLines.length === 1 && originalLines[0].length === 0 || modifiedLines.length === 1 && modifiedLines[0].length === 0) {
        return new LinesDiff([
          new DetailedLineRangeMapping(new LineRange(1, originalLines.length + 1), new LineRange(1, modifiedLines.length + 1), [
            new RangeMapping(new Range$1(1, 1, originalLines.length, originalLines[originalLines.length - 1].length + 1), new Range$1(1, 1, modifiedLines.length, modifiedLines[modifiedLines.length - 1].length + 1))
          ])
        ], [], false);
      }
      const timeout = options.maxComputationTimeMs === 0 ? InfiniteTimeout.instance : new DateTimeout(options.maxComputationTimeMs);
      const considerWhitespaceChanges = !options.ignoreTrimWhitespace;
      const perfectHashes = /* @__PURE__ */ new Map();
      function getOrCreateHash(text) {
        let hash = perfectHashes.get(text);
        if (hash === void 0) {
          hash = perfectHashes.size;
          perfectHashes.set(text, hash);
        }
        return hash;
      }
      const originalLinesHashes = originalLines.map((l) => getOrCreateHash(l.trim()));
      const modifiedLinesHashes = modifiedLines.map((l) => getOrCreateHash(l.trim()));
      const sequence1 = new LineSequence(originalLinesHashes, originalLines);
      const sequence2 = new LineSequence(modifiedLinesHashes, modifiedLines);
      const lineAlignmentResult = (() => {
        if (sequence1.length + sequence2.length < 1700) {
          return this.dynamicProgrammingDiffing.compute(sequence1, sequence2, timeout, (offset1, offset2) => originalLines[offset1] === modifiedLines[offset2] ? modifiedLines[offset2].length === 0 ? 0.1 : 1 + Math.log(1 + modifiedLines[offset2].length) : 0.99);
        }
        return this.myersDiffingAlgorithm.compute(sequence1, sequence2, timeout);
      })();
      let lineAlignments = lineAlignmentResult.diffs;
      let hitTimeout = lineAlignmentResult.hitTimeout;
      lineAlignments = optimizeSequenceDiffs(sequence1, sequence2, lineAlignments);
      lineAlignments = removeVeryShortMatchingLinesBetweenDiffs(sequence1, sequence2, lineAlignments);
      const alignments = [];
      const scanForWhitespaceChanges = (equalLinesCount) => {
        if (!considerWhitespaceChanges) {
          return;
        }
        for (let i = 0; i < equalLinesCount; i++) {
          const seq1Offset = seq1LastStart + i;
          const seq2Offset = seq2LastStart + i;
          if (originalLines[seq1Offset] !== modifiedLines[seq2Offset]) {
            const characterDiffs = this.refineDiff(originalLines, modifiedLines, new SequenceDiff(new OffsetRange(seq1Offset, seq1Offset + 1), new OffsetRange(seq2Offset, seq2Offset + 1)), timeout, considerWhitespaceChanges, options);
            for (const a of characterDiffs.mappings) {
              alignments.push(a);
            }
            if (characterDiffs.hitTimeout) {
              hitTimeout = true;
            }
          }
        }
      };
      let seq1LastStart = 0;
      let seq2LastStart = 0;
      for (const diff of lineAlignments) {
        assertFn(() => diff.seq1Range.start - seq1LastStart === diff.seq2Range.start - seq2LastStart);
        const equalLinesCount = diff.seq1Range.start - seq1LastStart;
        scanForWhitespaceChanges(equalLinesCount);
        seq1LastStart = diff.seq1Range.endExclusive;
        seq2LastStart = diff.seq2Range.endExclusive;
        const characterDiffs = this.refineDiff(originalLines, modifiedLines, diff, timeout, considerWhitespaceChanges, options);
        if (characterDiffs.hitTimeout) {
          hitTimeout = true;
        }
        for (const a of characterDiffs.mappings) {
          alignments.push(a);
        }
      }
      scanForWhitespaceChanges(originalLines.length - seq1LastStart);
      const original = new ArrayText(originalLines);
      const modified = new ArrayText(modifiedLines);
      const changes = lineRangeMappingFromRangeMappings(alignments, original, modified);
      let moves = [];
      if (options.computeMoves) {
        moves = this.computeMoves(changes, originalLines, modifiedLines, originalLinesHashes, modifiedLinesHashes, timeout, considerWhitespaceChanges, options);
      }
      assertFn(() => {
        function validatePosition(pos, lines) {
          if (pos.lineNumber < 1 || pos.lineNumber > lines.length) {
            return false;
          }
          const line = lines[pos.lineNumber - 1];
          if (pos.column < 1 || pos.column > line.length + 1) {
            return false;
          }
          return true;
        }
        function validateRange(range, lines) {
          if (range.startLineNumber < 1 || range.startLineNumber > lines.length + 1) {
            return false;
          }
          if (range.endLineNumberExclusive < 1 || range.endLineNumberExclusive > lines.length + 1) {
            return false;
          }
          return true;
        }
        for (const c of changes) {
          if (!c.innerChanges) {
            return false;
          }
          for (const ic of c.innerChanges) {
            const valid = validatePosition(ic.modifiedRange.getStartPosition(), modifiedLines) && validatePosition(ic.modifiedRange.getEndPosition(), modifiedLines) && validatePosition(ic.originalRange.getStartPosition(), originalLines) && validatePosition(ic.originalRange.getEndPosition(), originalLines);
            if (!valid) {
              return false;
            }
          }
          if (!validateRange(c.modified, modifiedLines) || !validateRange(c.original, originalLines)) {
            return false;
          }
        }
        return true;
      });
      return new LinesDiff(changes, moves, hitTimeout);
    }
    computeMoves(changes, originalLines, modifiedLines, hashedOriginalLines, hashedModifiedLines, timeout, considerWhitespaceChanges, options) {
      const moves = computeMovedLines(changes, originalLines, modifiedLines, hashedOriginalLines, hashedModifiedLines, timeout);
      const movesWithDiffs = moves.map((m) => {
        const moveChanges = this.refineDiff(originalLines, modifiedLines, new SequenceDiff(m.original.toOffsetRange(), m.modified.toOffsetRange()), timeout, considerWhitespaceChanges, options);
        const mappings = lineRangeMappingFromRangeMappings(moveChanges.mappings, new ArrayText(originalLines), new ArrayText(modifiedLines), true);
        return new MovedText(m, mappings);
      });
      return movesWithDiffs;
    }
    refineDiff(originalLines, modifiedLines, diff, timeout, considerWhitespaceChanges, options) {
      const lineRangeMapping = toLineRangeMapping(diff);
      const rangeMapping = lineRangeMapping.toRangeMapping2(originalLines, modifiedLines);
      const slice1 = new LinesSliceCharSequence(originalLines, rangeMapping.originalRange, considerWhitespaceChanges);
      const slice2 = new LinesSliceCharSequence(modifiedLines, rangeMapping.modifiedRange, considerWhitespaceChanges);
      const diffResult = slice1.length + slice2.length < 500 ? this.dynamicProgrammingDiffing.compute(slice1, slice2, timeout) : this.myersDiffingAlgorithm.compute(slice1, slice2, timeout);
      let diffs = diffResult.diffs;
      diffs = optimizeSequenceDiffs(slice1, slice2, diffs);
      diffs = extendDiffsToEntireWordIfAppropriate(slice1, slice2, diffs, (seq, idx) => seq.findWordContaining(idx));
      if (options.extendToSubwords) {
        diffs = extendDiffsToEntireWordIfAppropriate(slice1, slice2, diffs, (seq, idx) => seq.findSubWordContaining(idx), true);
      }
      diffs = removeShortMatches(slice1, slice2, diffs);
      diffs = removeVeryShortMatchingTextBetweenLongDiffs(slice1, slice2, diffs);
      const result = diffs.map((d) => new RangeMapping(slice1.translateRange(d.seq1Range), slice2.translateRange(d.seq2Range)));
      return {
        mappings: result,
        hitTimeout: diffResult.hitTimeout
      };
    }
  }
  function toLineRangeMapping(sequenceDiff) {
    return new LineRangeMapping(new LineRange(sequenceDiff.seq1Range.start + 1, sequenceDiff.seq1Range.endExclusive + 1), new LineRange(sequenceDiff.seq2Range.start + 1, sequenceDiff.seq2Range.endExclusive + 1));
  }
  const linesDiffComputers = {
    getLegacy: () => new LegacyLinesDiffComputer(),
    getDefault: () => new DefaultLinesDiffComputer()
  };
  function roundFloat(number, decimalPoints) {
    const decimal = Math.pow(10, decimalPoints);
    return Math.round(number * decimal) / decimal;
  }
  class RGBA {
    constructor(r, g, b, a = 1) {
      this._rgbaBrand = void 0;
      this.r = Math.min(255, Math.max(0, r)) | 0;
      this.g = Math.min(255, Math.max(0, g)) | 0;
      this.b = Math.min(255, Math.max(0, b)) | 0;
      this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
    }
    static equals(a, b) {
      return a.r === b.r && a.g === b.g && a.b === b.b && a.a === b.a;
    }
  }
  class HSLA {
    constructor(h, s, l, a) {
      this._hslaBrand = void 0;
      this.h = Math.max(Math.min(360, h), 0) | 0;
      this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
      this.l = roundFloat(Math.max(Math.min(1, l), 0), 3);
      this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
    }
    static equals(a, b) {
      return a.h === b.h && a.s === b.s && a.l === b.l && a.a === b.a;
    }
    /**
     * Converts an RGB color value to HSL. Conversion formula
     * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
     * Assumes r, g, and b are contained in the set [0, 255] and
     * returns h in the set [0, 360], s, and l in the set [0, 1].
     */
    static fromRGBA(rgba) {
      const r = rgba.r / 255;
      const g = rgba.g / 255;
      const b = rgba.b / 255;
      const a = rgba.a;
      const max = Math.max(r, g, b);
      const min = Math.min(r, g, b);
      let h = 0;
      let s = 0;
      const l = (min + max) / 2;
      const chroma = max - min;
      if (chroma > 0) {
        s = Math.min(l <= 0.5 ? chroma / (2 * l) : chroma / (2 - 2 * l), 1);
        switch (max) {
          case r:
            h = (g - b) / chroma + (g < b ? 6 : 0);
            break;
          case g:
            h = (b - r) / chroma + 2;
            break;
          case b:
            h = (r - g) / chroma + 4;
            break;
        }
        h *= 60;
        h = Math.round(h);
      }
      return new HSLA(h, s, l, a);
    }
    static _hue2rgb(p, q, t2) {
      if (t2 < 0) {
        t2 += 1;
      }
      if (t2 > 1) {
        t2 -= 1;
      }
      if (t2 < 1 / 6) {
        return p + (q - p) * 6 * t2;
      }
      if (t2 < 1 / 2) {
        return q;
      }
      if (t2 < 2 / 3) {
        return p + (q - p) * (2 / 3 - t2) * 6;
      }
      return p;
    }
    /**
     * Converts an HSL color value to RGB. Conversion formula
     * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
     * Assumes h in the set [0, 360] s, and l are contained in the set [0, 1] and
     * returns r, g, and b in the set [0, 255].
     */
    static toRGBA(hsla) {
      const h = hsla.h / 360;
      const { s, l, a } = hsla;
      let r, g, b;
      if (s === 0) {
        r = g = b = l;
      } else {
        const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        const p = 2 * l - q;
        r = HSLA._hue2rgb(p, q, h + 1 / 3);
        g = HSLA._hue2rgb(p, q, h);
        b = HSLA._hue2rgb(p, q, h - 1 / 3);
      }
      return new RGBA(Math.round(r * 255), Math.round(g * 255), Math.round(b * 255), a);
    }
  }
  class HSVA {
    constructor(h, s, v, a) {
      this._hsvaBrand = void 0;
      this.h = Math.max(Math.min(360, h), 0) | 0;
      this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
      this.v = roundFloat(Math.max(Math.min(1, v), 0), 3);
      this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
    }
    static equals(a, b) {
      return a.h === b.h && a.s === b.s && a.v === b.v && a.a === b.a;
    }
    // from http://www.rapidtables.com/convert/color/rgb-to-hsv.htm
    static fromRGBA(rgba) {
      const r = rgba.r / 255;
      const g = rgba.g / 255;
      const b = rgba.b / 255;
      const cmax = Math.max(r, g, b);
      const cmin = Math.min(r, g, b);
      const delta = cmax - cmin;
      const s = cmax === 0 ? 0 : delta / cmax;
      let m;
      if (delta === 0) {
        m = 0;
      } else if (cmax === r) {
        m = ((g - b) / delta % 6 + 6) % 6;
      } else if (cmax === g) {
        m = (b - r) / delta + 2;
      } else {
        m = (r - g) / delta + 4;
      }
      return new HSVA(Math.round(m * 60), s, cmax, rgba.a);
    }
    // from http://www.rapidtables.com/convert/color/hsv-to-rgb.htm
    static toRGBA(hsva) {
      const { h, s, v, a } = hsva;
      const c = v * s;
      const x = c * (1 - Math.abs(h / 60 % 2 - 1));
      const m = v - c;
      let [r, g, b] = [0, 0, 0];
      if (h < 60) {
        r = c;
        g = x;
      } else if (h < 120) {
        r = x;
        g = c;
      } else if (h < 180) {
        g = c;
        b = x;
      } else if (h < 240) {
        g = x;
        b = c;
      } else if (h < 300) {
        r = x;
        b = c;
      } else if (h <= 360) {
        r = c;
        b = x;
      }
      r = Math.round((r + m) * 255);
      g = Math.round((g + m) * 255);
      b = Math.round((b + m) * 255);
      return new RGBA(r, g, b, a);
    }
  }
  let Color$1 = (_c2 = class {
    static fromHex(hex) {
      return _c2.Format.CSS.parseHex(hex) || _c2.red;
    }
    static equals(a, b) {
      if (!a && !b) {
        return true;
      }
      if (!a || !b) {
        return false;
      }
      return a.equals(b);
    }
    get hsla() {
      if (this._hsla) {
        return this._hsla;
      } else {
        return HSLA.fromRGBA(this.rgba);
      }
    }
    get hsva() {
      if (this._hsva) {
        return this._hsva;
      }
      return HSVA.fromRGBA(this.rgba);
    }
    constructor(arg) {
      if (!arg) {
        throw new Error("Color needs a value");
      } else if (arg instanceof RGBA) {
        this.rgba = arg;
      } else if (arg instanceof HSLA) {
        this._hsla = arg;
        this.rgba = HSLA.toRGBA(arg);
      } else if (arg instanceof HSVA) {
        this._hsva = arg;
        this.rgba = HSVA.toRGBA(arg);
      } else {
        throw new Error("Invalid color ctor argument");
      }
    }
    equals(other) {
      return !!other && RGBA.equals(this.rgba, other.rgba) && HSLA.equals(this.hsla, other.hsla) && HSVA.equals(this.hsva, other.hsva);
    }
    /**
     * http://www.w3.org/TR/WCAG20/#relativeluminancedef
     * Returns the number in the set [0, 1]. O => Darkest Black. 1 => Lightest white.
     */
    getRelativeLuminance() {
      const R = _c2._relativeLuminanceForComponent(this.rgba.r);
      const G = _c2._relativeLuminanceForComponent(this.rgba.g);
      const B = _c2._relativeLuminanceForComponent(this.rgba.b);
      const luminance = 0.2126 * R + 0.7152 * G + 0.0722 * B;
      return roundFloat(luminance, 4);
    }
    static _relativeLuminanceForComponent(color) {
      const c = color / 255;
      return c <= 0.03928 ? c / 12.92 : Math.pow((c + 0.055) / 1.055, 2.4);
    }
    /**
     *	http://24ways.org/2010/calculating-color-contrast
     *  Return 'true' if lighter color otherwise 'false'
     */
    isLighter() {
      const yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1e3;
      return yiq >= 128;
    }
    isLighterThan(another) {
      const lum1 = this.getRelativeLuminance();
      const lum2 = another.getRelativeLuminance();
      return lum1 > lum2;
    }
    isDarkerThan(another) {
      const lum1 = this.getRelativeLuminance();
      const lum2 = another.getRelativeLuminance();
      return lum1 < lum2;
    }
    lighten(factor) {
      return new _c2(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l + this.hsla.l * factor, this.hsla.a));
    }
    darken(factor) {
      return new _c2(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l - this.hsla.l * factor, this.hsla.a));
    }
    transparent(factor) {
      const { r, g, b, a } = this.rgba;
      return new _c2(new RGBA(r, g, b, a * factor));
    }
    isTransparent() {
      return this.rgba.a === 0;
    }
    isOpaque() {
      return this.rgba.a === 1;
    }
    opposite() {
      return new _c2(new RGBA(255 - this.rgba.r, 255 - this.rgba.g, 255 - this.rgba.b, this.rgba.a));
    }
    /**
     * Mixes the current color with the provided color based on the given factor.
     * @param color The color to mix with
     * @param factor The factor of mixing (0 means this color, 1 means the input color, 0.5 means equal mix)
     * @returns A new color representing the mix
     */
    mix(color, factor = 0.5) {
      const normalize = Math.min(Math.max(factor, 0), 1);
      const thisRGBA = this.rgba;
      const otherRGBA = color.rgba;
      const r = thisRGBA.r + (otherRGBA.r - thisRGBA.r) * normalize;
      const g = thisRGBA.g + (otherRGBA.g - thisRGBA.g) * normalize;
      const b = thisRGBA.b + (otherRGBA.b - thisRGBA.b) * normalize;
      const a = thisRGBA.a + (otherRGBA.a - thisRGBA.a) * normalize;
      return new _c2(new RGBA(r, g, b, a));
    }
    makeOpaque(opaqueBackground) {
      if (this.isOpaque() || opaqueBackground.rgba.a !== 1) {
        return this;
      }
      const { r, g, b, a } = this.rgba;
      return new _c2(new RGBA(opaqueBackground.rgba.r - a * (opaqueBackground.rgba.r - r), opaqueBackground.rgba.g - a * (opaqueBackground.rgba.g - g), opaqueBackground.rgba.b - a * (opaqueBackground.rgba.b - b), 1));
    }
    toString() {
      if (!this._toString) {
        this._toString = _c2.Format.CSS.format(this);
      }
      return this._toString;
    }
    toNumber32Bit() {
      if (!this._toNumber32Bit) {
        this._toNumber32Bit = (this.rgba.r << 24 | this.rgba.g << 16 | this.rgba.b << 8 | this.rgba.a * 255 << 0) >>> 0;
      }
      return this._toNumber32Bit;
    }
    static getLighterColor(of, relative, factor) {
      if (of.isLighterThan(relative)) {
        return of;
      }
      factor = factor ? factor : 0.5;
      const lum1 = of.getRelativeLuminance();
      const lum2 = relative.getRelativeLuminance();
      factor = factor * (lum2 - lum1) / lum2;
      return of.lighten(factor);
    }
    static getDarkerColor(of, relative, factor) {
      if (of.isDarkerThan(relative)) {
        return of;
      }
      factor = factor ? factor : 0.5;
      const lum1 = of.getRelativeLuminance();
      const lum2 = relative.getRelativeLuminance();
      factor = factor * (lum1 - lum2) / lum1;
      return of.darken(factor);
    }
  }, _c2.white = new _c2(new RGBA(255, 255, 255, 1)), _c2.black = new _c2(new RGBA(0, 0, 0, 1)), _c2.red = new _c2(new RGBA(255, 0, 0, 1)), _c2.blue = new _c2(new RGBA(0, 0, 255, 1)), _c2.green = new _c2(new RGBA(0, 255, 0, 1)), _c2.cyan = new _c2(new RGBA(0, 255, 255, 1)), _c2.lightgrey = new _c2(new RGBA(211, 211, 211, 1)), _c2.transparent = new _c2(new RGBA(0, 0, 0, 0)), _c2);
  (function(Color2) {
    (function(Format) {
      (function(CSS) {
        function formatRGB(color) {
          if (color.rgba.a === 1) {
            return `rgb(${color.rgba.r}, ${color.rgba.g}, ${color.rgba.b})`;
          }
          return Color2.Format.CSS.formatRGBA(color);
        }
        CSS.formatRGB = formatRGB;
        function formatRGBA(color) {
          return `rgba(${color.rgba.r}, ${color.rgba.g}, ${color.rgba.b}, ${+color.rgba.a.toFixed(2)})`;
        }
        CSS.formatRGBA = formatRGBA;
        function formatHSL(color) {
          if (color.hsla.a === 1) {
            return `hsl(${color.hsla.h}, ${Math.round(color.hsla.s * 100)}%, ${Math.round(color.hsla.l * 100)}%)`;
          }
          return Color2.Format.CSS.formatHSLA(color);
        }
        CSS.formatHSL = formatHSL;
        function formatHSLA(color) {
          return `hsla(${color.hsla.h}, ${Math.round(color.hsla.s * 100)}%, ${Math.round(color.hsla.l * 100)}%, ${color.hsla.a.toFixed(2)})`;
        }
        CSS.formatHSLA = formatHSLA;
        function _toTwoDigitHex(n) {
          const r = n.toString(16);
          return r.length !== 2 ? "0" + r : r;
        }
        function formatHex(color) {
          return `#${_toTwoDigitHex(color.rgba.r)}${_toTwoDigitHex(color.rgba.g)}${_toTwoDigitHex(color.rgba.b)}`;
        }
        CSS.formatHex = formatHex;
        function formatHexA(color, compact = false) {
          if (compact && color.rgba.a === 1) {
            return Color2.Format.CSS.formatHex(color);
          }
          return `#${_toTwoDigitHex(color.rgba.r)}${_toTwoDigitHex(color.rgba.g)}${_toTwoDigitHex(color.rgba.b)}${_toTwoDigitHex(Math.round(color.rgba.a * 255))}`;
        }
        CSS.formatHexA = formatHexA;
        function format2(color) {
          if (color.isOpaque()) {
            return Color2.Format.CSS.formatHex(color);
          }
          return Color2.Format.CSS.formatRGBA(color);
        }
        CSS.format = format2;
        function parse(css) {
          if (css === "transparent") {
            return Color2.transparent;
          }
          if (css.startsWith("#")) {
            return parseHex(css);
          }
          if (css.startsWith("rgba(")) {
            const color = css.match(/rgba\((?<r>(?:\+|-)?\d+), *(?<g>(?:\+|-)?\d+), *(?<b>(?:\+|-)?\d+), *(?<a>(?:\+|-)?\d+(\.\d+)?)\)/);
            if (!color) {
              throw new Error("Invalid color format " + css);
            }
            const r = parseInt(color.groups?.r ?? "0");
            const g = parseInt(color.groups?.g ?? "0");
            const b = parseInt(color.groups?.b ?? "0");
            const a = parseFloat(color.groups?.a ?? "0");
            return new Color2(new RGBA(r, g, b, a));
          }
          if (css.startsWith("rgb(")) {
            const color = css.match(/rgb\((?<r>(?:\+|-)?\d+), *(?<g>(?:\+|-)?\d+), *(?<b>(?:\+|-)?\d+)\)/);
            if (!color) {
              throw new Error("Invalid color format " + css);
            }
            const r = parseInt(color.groups?.r ?? "0");
            const g = parseInt(color.groups?.g ?? "0");
            const b = parseInt(color.groups?.b ?? "0");
            return new Color2(new RGBA(r, g, b));
          }
          return parseNamedKeyword(css);
        }
        CSS.parse = parse;
        function parseNamedKeyword(css) {
          switch (css) {
            case "aliceblue":
              return new Color2(new RGBA(240, 248, 255, 1));
            case "antiquewhite":
              return new Color2(new RGBA(250, 235, 215, 1));
            case "aqua":
              return new Color2(new RGBA(0, 255, 255, 1));
            case "aquamarine":
              return new Color2(new RGBA(127, 255, 212, 1));
            case "azure":
              return new Color2(new RGBA(240, 255, 255, 1));
            case "beige":
              return new Color2(new RGBA(245, 245, 220, 1));
            case "bisque":
              return new Color2(new RGBA(255, 228, 196, 1));
            case "black":
              return new Color2(new RGBA(0, 0, 0, 1));
            case "blanchedalmond":
              return new Color2(new RGBA(255, 235, 205, 1));
            case "blue":
              return new Color2(new RGBA(0, 0, 255, 1));
            case "blueviolet":
              return new Color2(new RGBA(138, 43, 226, 1));
            case "brown":
              return new Color2(new RGBA(165, 42, 42, 1));
            case "burlywood":
              return new Color2(new RGBA(222, 184, 135, 1));
            case "cadetblue":
              return new Color2(new RGBA(95, 158, 160, 1));
            case "chartreuse":
              return new Color2(new RGBA(127, 255, 0, 1));
            case "chocolate":
              return new Color2(new RGBA(210, 105, 30, 1));
            case "coral":
              return new Color2(new RGBA(255, 127, 80, 1));
            case "cornflowerblue":
              return new Color2(new RGBA(100, 149, 237, 1));
            case "cornsilk":
              return new Color2(new RGBA(255, 248, 220, 1));
            case "crimson":
              return new Color2(new RGBA(220, 20, 60, 1));
            case "cyan":
              return new Color2(new RGBA(0, 255, 255, 1));
            case "darkblue":
              return new Color2(new RGBA(0, 0, 139, 1));
            case "darkcyan":
              return new Color2(new RGBA(0, 139, 139, 1));
            case "darkgoldenrod":
              return new Color2(new RGBA(184, 134, 11, 1));
            case "darkgray":
              return new Color2(new RGBA(169, 169, 169, 1));
            case "darkgreen":
              return new Color2(new RGBA(0, 100, 0, 1));
            case "darkgrey":
              return new Color2(new RGBA(169, 169, 169, 1));
            case "darkkhaki":
              return new Color2(new RGBA(189, 183, 107, 1));
            case "darkmagenta":
              return new Color2(new RGBA(139, 0, 139, 1));
            case "darkolivegreen":
              return new Color2(new RGBA(85, 107, 47, 1));
            case "darkorange":
              return new Color2(new RGBA(255, 140, 0, 1));
            case "darkorchid":
              return new Color2(new RGBA(153, 50, 204, 1));
            case "darkred":
              return new Color2(new RGBA(139, 0, 0, 1));
            case "darksalmon":
              return new Color2(new RGBA(233, 150, 122, 1));
            case "darkseagreen":
              return new Color2(new RGBA(143, 188, 143, 1));
            case "darkslateblue":
              return new Color2(new RGBA(72, 61, 139, 1));
            case "darkslategray":
              return new Color2(new RGBA(47, 79, 79, 1));
            case "darkslategrey":
              return new Color2(new RGBA(47, 79, 79, 1));
            case "darkturquoise":
              return new Color2(new RGBA(0, 206, 209, 1));
            case "darkviolet":
              return new Color2(new RGBA(148, 0, 211, 1));
            case "deeppink":
              return new Color2(new RGBA(255, 20, 147, 1));
            case "deepskyblue":
              return new Color2(new RGBA(0, 191, 255, 1));
            case "dimgray":
              return new Color2(new RGBA(105, 105, 105, 1));
            case "dimgrey":
              return new Color2(new RGBA(105, 105, 105, 1));
            case "dodgerblue":
              return new Color2(new RGBA(30, 144, 255, 1));
            case "firebrick":
              return new Color2(new RGBA(178, 34, 34, 1));
            case "floralwhite":
              return new Color2(new RGBA(255, 250, 240, 1));
            case "forestgreen":
              return new Color2(new RGBA(34, 139, 34, 1));
            case "fuchsia":
              return new Color2(new RGBA(255, 0, 255, 1));
            case "gainsboro":
              return new Color2(new RGBA(220, 220, 220, 1));
            case "ghostwhite":
              return new Color2(new RGBA(248, 248, 255, 1));
            case "gold":
              return new Color2(new RGBA(255, 215, 0, 1));
            case "goldenrod":
              return new Color2(new RGBA(218, 165, 32, 1));
            case "gray":
              return new Color2(new RGBA(128, 128, 128, 1));
            case "green":
              return new Color2(new RGBA(0, 128, 0, 1));
            case "greenyellow":
              return new Color2(new RGBA(173, 255, 47, 1));
            case "grey":
              return new Color2(new RGBA(128, 128, 128, 1));
            case "honeydew":
              return new Color2(new RGBA(240, 255, 240, 1));
            case "hotpink":
              return new Color2(new RGBA(255, 105, 180, 1));
            case "indianred":
              return new Color2(new RGBA(205, 92, 92, 1));
            case "indigo":
              return new Color2(new RGBA(75, 0, 130, 1));
            case "ivory":
              return new Color2(new RGBA(255, 255, 240, 1));
            case "khaki":
              return new Color2(new RGBA(240, 230, 140, 1));
            case "lavender":
              return new Color2(new RGBA(230, 230, 250, 1));
            case "lavenderblush":
              return new Color2(new RGBA(255, 240, 245, 1));
            case "lawngreen":
              return new Color2(new RGBA(124, 252, 0, 1));
            case "lemonchiffon":
              return new Color2(new RGBA(255, 250, 205, 1));
            case "lightblue":
              return new Color2(new RGBA(173, 216, 230, 1));
            case "lightcoral":
              return new Color2(new RGBA(240, 128, 128, 1));
            case "lightcyan":
              return new Color2(new RGBA(224, 255, 255, 1));
            case "lightgoldenrodyellow":
              return new Color2(new RGBA(250, 250, 210, 1));
            case "lightgray":
              return new Color2(new RGBA(211, 211, 211, 1));
            case "lightgreen":
              return new Color2(new RGBA(144, 238, 144, 1));
            case "lightgrey":
              return new Color2(new RGBA(211, 211, 211, 1));
            case "lightpink":
              return new Color2(new RGBA(255, 182, 193, 1));
            case "lightsalmon":
              return new Color2(new RGBA(255, 160, 122, 1));
            case "lightseagreen":
              return new Color2(new RGBA(32, 178, 170, 1));
            case "lightskyblue":
              return new Color2(new RGBA(135, 206, 250, 1));
            case "lightslategray":
              return new Color2(new RGBA(119, 136, 153, 1));
            case "lightslategrey":
              return new Color2(new RGBA(119, 136, 153, 1));
            case "lightsteelblue":
              return new Color2(new RGBA(176, 196, 222, 1));
            case "lightyellow":
              return new Color2(new RGBA(255, 255, 224, 1));
            case "lime":
              return new Color2(new RGBA(0, 255, 0, 1));
            case "limegreen":
              return new Color2(new RGBA(50, 205, 50, 1));
            case "linen":
              return new Color2(new RGBA(250, 240, 230, 1));
            case "magenta":
              return new Color2(new RGBA(255, 0, 255, 1));
            case "maroon":
              return new Color2(new RGBA(128, 0, 0, 1));
            case "mediumaquamarine":
              return new Color2(new RGBA(102, 205, 170, 1));
            case "mediumblue":
              return new Color2(new RGBA(0, 0, 205, 1));
            case "mediumorchid":
              return new Color2(new RGBA(186, 85, 211, 1));
            case "mediumpurple":
              return new Color2(new RGBA(147, 112, 219, 1));
            case "mediumseagreen":
              return new Color2(new RGBA(60, 179, 113, 1));
            case "mediumslateblue":
              return new Color2(new RGBA(123, 104, 238, 1));
            case "mediumspringgreen":
              return new Color2(new RGBA(0, 250, 154, 1));
            case "mediumturquoise":
              return new Color2(new RGBA(72, 209, 204, 1));
            case "mediumvioletred":
              return new Color2(new RGBA(199, 21, 133, 1));
            case "midnightblue":
              return new Color2(new RGBA(25, 25, 112, 1));
            case "mintcream":
              return new Color2(new RGBA(245, 255, 250, 1));
            case "mistyrose":
              return new Color2(new RGBA(255, 228, 225, 1));
            case "moccasin":
              return new Color2(new RGBA(255, 228, 181, 1));
            case "navajowhite":
              return new Color2(new RGBA(255, 222, 173, 1));
            case "navy":
              return new Color2(new RGBA(0, 0, 128, 1));
            case "oldlace":
              return new Color2(new RGBA(253, 245, 230, 1));
            case "olive":
              return new Color2(new RGBA(128, 128, 0, 1));
            case "olivedrab":
              return new Color2(new RGBA(107, 142, 35, 1));
            case "orange":
              return new Color2(new RGBA(255, 165, 0, 1));
            case "orangered":
              return new Color2(new RGBA(255, 69, 0, 1));
            case "orchid":
              return new Color2(new RGBA(218, 112, 214, 1));
            case "palegoldenrod":
              return new Color2(new RGBA(238, 232, 170, 1));
            case "palegreen":
              return new Color2(new RGBA(152, 251, 152, 1));
            case "paleturquoise":
              return new Color2(new RGBA(175, 238, 238, 1));
            case "palevioletred":
              return new Color2(new RGBA(219, 112, 147, 1));
            case "papayawhip":
              return new Color2(new RGBA(255, 239, 213, 1));
            case "peachpuff":
              return new Color2(new RGBA(255, 218, 185, 1));
            case "peru":
              return new Color2(new RGBA(205, 133, 63, 1));
            case "pink":
              return new Color2(new RGBA(255, 192, 203, 1));
            case "plum":
              return new Color2(new RGBA(221, 160, 221, 1));
            case "powderblue":
              return new Color2(new RGBA(176, 224, 230, 1));
            case "purple":
              return new Color2(new RGBA(128, 0, 128, 1));
            case "rebeccapurple":
              return new Color2(new RGBA(102, 51, 153, 1));
            case "red":
              return new Color2(new RGBA(255, 0, 0, 1));
            case "rosybrown":
              return new Color2(new RGBA(188, 143, 143, 1));
            case "royalblue":
              return new Color2(new RGBA(65, 105, 225, 1));
            case "saddlebrown":
              return new Color2(new RGBA(139, 69, 19, 1));
            case "salmon":
              return new Color2(new RGBA(250, 128, 114, 1));
            case "sandybrown":
              return new Color2(new RGBA(244, 164, 96, 1));
            case "seagreen":
              return new Color2(new RGBA(46, 139, 87, 1));
            case "seashell":
              return new Color2(new RGBA(255, 245, 238, 1));
            case "sienna":
              return new Color2(new RGBA(160, 82, 45, 1));
            case "silver":
              return new Color2(new RGBA(192, 192, 192, 1));
            case "skyblue":
              return new Color2(new RGBA(135, 206, 235, 1));
            case "slateblue":
              return new Color2(new RGBA(106, 90, 205, 1));
            case "slategray":
              return new Color2(new RGBA(112, 128, 144, 1));
            case "slategrey":
              return new Color2(new RGBA(112, 128, 144, 1));
            case "snow":
              return new Color2(new RGBA(255, 250, 250, 1));
            case "springgreen":
              return new Color2(new RGBA(0, 255, 127, 1));
            case "steelblue":
              return new Color2(new RGBA(70, 130, 180, 1));
            case "tan":
              return new Color2(new RGBA(210, 180, 140, 1));
            case "teal":
              return new Color2(new RGBA(0, 128, 128, 1));
            case "thistle":
              return new Color2(new RGBA(216, 191, 216, 1));
            case "tomato":
              return new Color2(new RGBA(255, 99, 71, 1));
            case "turquoise":
              return new Color2(new RGBA(64, 224, 208, 1));
            case "violet":
              return new Color2(new RGBA(238, 130, 238, 1));
            case "wheat":
              return new Color2(new RGBA(245, 222, 179, 1));
            case "white":
              return new Color2(new RGBA(255, 255, 255, 1));
            case "whitesmoke":
              return new Color2(new RGBA(245, 245, 245, 1));
            case "yellow":
              return new Color2(new RGBA(255, 255, 0, 1));
            case "yellowgreen":
              return new Color2(new RGBA(154, 205, 50, 1));
            default:
              return null;
          }
        }
        function parseHex(hex) {
          const length = hex.length;
          if (length === 0) {
            return null;
          }
          if (hex.charCodeAt(0) !== 35) {
            return null;
          }
          if (length === 7) {
            const r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
            const g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
            const b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
            return new Color2(new RGBA(r, g, b, 1));
          }
          if (length === 9) {
            const r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
            const g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
            const b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
            const a = 16 * _parseHexDigit(hex.charCodeAt(7)) + _parseHexDigit(hex.charCodeAt(8));
            return new Color2(new RGBA(r, g, b, a / 255));
          }
          if (length === 4) {
            const r = _parseHexDigit(hex.charCodeAt(1));
            const g = _parseHexDigit(hex.charCodeAt(2));
            const b = _parseHexDigit(hex.charCodeAt(3));
            return new Color2(new RGBA(16 * r + r, 16 * g + g, 16 * b + b));
          }
          if (length === 5) {
            const r = _parseHexDigit(hex.charCodeAt(1));
            const g = _parseHexDigit(hex.charCodeAt(2));
            const b = _parseHexDigit(hex.charCodeAt(3));
            const a = _parseHexDigit(hex.charCodeAt(4));
            return new Color2(new RGBA(16 * r + r, 16 * g + g, 16 * b + b, (16 * a + a) / 255));
          }
          return null;
        }
        CSS.parseHex = parseHex;
        function _parseHexDigit(charCode) {
          switch (charCode) {
            case 48:
              return 0;
            case 49:
              return 1;
            case 50:
              return 2;
            case 51:
              return 3;
            case 52:
              return 4;
            case 53:
              return 5;
            case 54:
              return 6;
            case 55:
              return 7;
            case 56:
              return 8;
            case 57:
              return 9;
            case 97:
              return 10;
            case 65:
              return 10;
            case 98:
              return 11;
            case 66:
              return 11;
            case 99:
              return 12;
            case 67:
              return 12;
            case 100:
              return 13;
            case 68:
              return 13;
            case 101:
              return 14;
            case 69:
              return 14;
            case 102:
              return 15;
            case 70:
              return 15;
          }
          return 0;
        }
      })(Format.CSS || (Format.CSS = {}));
    })(Color2.Format || (Color2.Format = {}));
  })(Color$1 || (Color$1 = {}));
  function _parseCaptureGroups(captureGroups) {
    const values = [];
    for (const captureGroup of captureGroups) {
      const parsedNumber = Number(captureGroup);
      if (parsedNumber || parsedNumber === 0 && captureGroup.replace(/\s/g, "") !== "") {
        values.push(parsedNumber);
      }
    }
    return values;
  }
  function _toIColor(r, g, b, a) {
    return {
      red: r / 255,
      blue: b / 255,
      green: g / 255,
      alpha: a
    };
  }
  function _findRange(model, match) {
    const index = match.index;
    const length = match[0].length;
    if (index === void 0) {
      return;
    }
    const startPosition = model.positionAt(index);
    const range = {
      startLineNumber: startPosition.lineNumber,
      startColumn: startPosition.column,
      endLineNumber: startPosition.lineNumber,
      endColumn: startPosition.column + length
    };
    return range;
  }
  function _findHexColorInformation(range, hexValue) {
    if (!range) {
      return;
    }
    const parsedHexColor = Color$1.Format.CSS.parseHex(hexValue);
    if (!parsedHexColor) {
      return;
    }
    return {
      range,
      color: _toIColor(parsedHexColor.rgba.r, parsedHexColor.rgba.g, parsedHexColor.rgba.b, parsedHexColor.rgba.a)
    };
  }
  function _findRGBColorInformation(range, matches, isAlpha) {
    if (!range || matches.length !== 1) {
      return;
    }
    const match = matches[0];
    const captureGroups = match.values();
    const parsedRegex = _parseCaptureGroups(captureGroups);
    return {
      range,
      color: _toIColor(parsedRegex[0], parsedRegex[1], parsedRegex[2], isAlpha ? parsedRegex[3] : 1)
    };
  }
  function _findHSLColorInformation(range, matches, isAlpha) {
    if (!range || matches.length !== 1) {
      return;
    }
    const match = matches[0];
    const captureGroups = match.values();
    const parsedRegex = _parseCaptureGroups(captureGroups);
    const colorEquivalent = new Color$1(new HSLA(parsedRegex[0], parsedRegex[1] / 100, parsedRegex[2] / 100, isAlpha ? parsedRegex[3] : 1));
    return {
      range,
      color: _toIColor(colorEquivalent.rgba.r, colorEquivalent.rgba.g, colorEquivalent.rgba.b, colorEquivalent.rgba.a)
    };
  }
  function _findMatches(model, regex) {
    if (typeof model === "string") {
      return [...model.matchAll(regex)];
    } else {
      return model.findMatches(regex);
    }
  }
  function computeColors(model) {
    const result = [];
    const initialValidationRegex = new RegExp(`\\b(rgb|rgba|hsl|hsla)(\\([0-9\\s,.\\%]*\\))|^(#)([A-Fa-f0-9]{3})\\b|^(#)([A-Fa-f0-9]{4})\\b|^(#)([A-Fa-f0-9]{6})\\b|^(#)([A-Fa-f0-9]{8})\\b|(?<=['"\\s])(#)([A-Fa-f0-9]{3})\\b|(?<=['"\\s])(#)([A-Fa-f0-9]{4})\\b|(?<=['"\\s])(#)([A-Fa-f0-9]{6})\\b|(?<=['"\\s])(#)([A-Fa-f0-9]{8})\\b`, "gm");
    const initialValidationMatches = _findMatches(model, initialValidationRegex);
    if (initialValidationMatches.length > 0) {
      for (const initialMatch of initialValidationMatches) {
        const initialCaptureGroups = initialMatch.filter((captureGroup) => captureGroup !== void 0);
        const colorScheme = initialCaptureGroups[1];
        const colorParameters = initialCaptureGroups[2];
        if (!colorParameters) {
          continue;
        }
        let colorInformation;
        if (colorScheme === "rgb") {
          const regexParameters = /^\(\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*\)$/gm;
          colorInformation = _findRGBColorInformation(_findRange(model, initialMatch), _findMatches(colorParameters, regexParameters), false);
        } else if (colorScheme === "rgba") {
          const regexParameters = /^\(\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\s*,\s*(0[.][0-9]+|[.][0-9]+|[01][.]|[01])\s*\)$/gm;
          colorInformation = _findRGBColorInformation(_findRange(model, initialMatch), _findMatches(colorParameters, regexParameters), true);
        } else if (colorScheme === "hsl") {
          const regexParameters = /^\(\s*((?:360(?:\.0+)?|(?:36[0]|3[0-5][0-9]|[12][0-9][0-9]|[1-9]?[0-9])(?:\.\d+)?))\s*[\s,]\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*[\s,]\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*\)$/gm;
          colorInformation = _findHSLColorInformation(_findRange(model, initialMatch), _findMatches(colorParameters, regexParameters), false);
        } else if (colorScheme === "hsla") {
          const regexParameters = /^\(\s*((?:360(?:\.0+)?|(?:36[0]|3[0-5][0-9]|[12][0-9][0-9]|[1-9]?[0-9])(?:\.\d+)?))\s*[\s,]\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*[\s,]\s*(100|\d{1,2}[.]\d*|\d{1,2})%\s*[\s,]\s*(0[.][0-9]+|[.][0-9]+|[01][.]0*|[01])\s*\)$/gm;
          colorInformation = _findHSLColorInformation(_findRange(model, initialMatch), _findMatches(colorParameters, regexParameters), true);
        } else if (colorScheme === "#") {
          colorInformation = _findHexColorInformation(_findRange(model, initialMatch), colorScheme + colorParameters);
        }
        if (colorInformation) {
          result.push(colorInformation);
        }
      }
    }
    return result;
  }
  function computeDefaultDocumentColors(model) {
    if (!model || typeof model.getValue !== "function" || typeof model.positionAt !== "function") {
      return [];
    }
    return computeColors(model);
  }
  const trimDashesRegex = /^-+|-+$/g;
  const CHUNK_SIZE = 100;
  const MAX_SECTION_LINES = 5;
  function findSectionHeaders(model, options) {
    let headers = [];
    if (options.findRegionSectionHeaders && options.foldingRules?.markers) {
      const regionHeaders = collectRegionHeaders(model, options);
      headers = headers.concat(regionHeaders);
    }
    if (options.findMarkSectionHeaders) {
      const markHeaders = collectMarkHeaders(model, options);
      headers = headers.concat(markHeaders);
    }
    return headers;
  }
  function collectRegionHeaders(model, options) {
    const regionHeaders = [];
    const endLineNumber = model.getLineCount();
    for (let lineNumber = 1; lineNumber <= endLineNumber; lineNumber++) {
      const lineContent = model.getLineContent(lineNumber);
      const match = lineContent.match(options.foldingRules.markers.start);
      if (match) {
        const range = { startLineNumber: lineNumber, startColumn: match[0].length + 1, endLineNumber: lineNumber, endColumn: lineContent.length + 1 };
        if (range.endColumn > range.startColumn) {
          const sectionHeader = {
            range,
            ...getHeaderText(lineContent.substring(match[0].length)),
            shouldBeInComments: false
          };
          if (sectionHeader.text || sectionHeader.hasSeparatorLine) {
            regionHeaders.push(sectionHeader);
          }
        }
      }
    }
    return regionHeaders;
  }
  function collectMarkHeaders(model, options) {
    const markHeaders = [];
    const endLineNumber = model.getLineCount();
    if (!options.markSectionHeaderRegex || options.markSectionHeaderRegex.trim() === "") {
      return markHeaders;
    }
    const multiline = isMultilineRegexSource(options.markSectionHeaderRegex);
    const regex = new RegExp(options.markSectionHeaderRegex, `gdm${multiline ? "s" : ""}`);
    if (regExpLeadsToEndlessLoop(regex)) {
      return markHeaders;
    }
    for (let startLine = 1; startLine <= endLineNumber; startLine += CHUNK_SIZE - MAX_SECTION_LINES) {
      const endLine = Math.min(startLine + CHUNK_SIZE - 1, endLineNumber);
      const lines = [];
      for (let i = startLine; i <= endLine; i++) {
        lines.push(model.getLineContent(i));
      }
      const text = lines.join("\n");
      regex.lastIndex = 0;
      let match;
      while ((match = regex.exec(text)) !== null) {
        const precedingText = text.substring(0, match.index);
        const lineOffset = (precedingText.match(/\n/g) || []).length;
        const lineNumber = startLine + lineOffset;
        const matchLines = match[0].split("\n");
        const matchHeight = matchLines.length;
        const matchEndLine = lineNumber + matchHeight - 1;
        const lineStartIndex = precedingText.lastIndexOf("\n") + 1;
        const startColumn = match.index - lineStartIndex + 1;
        const lastMatchLine = matchLines[matchLines.length - 1];
        const endColumn = matchHeight === 1 ? startColumn + match[0].length : lastMatchLine.length + 1;
        const range = {
          startLineNumber: lineNumber,
          startColumn,
          endLineNumber: matchEndLine,
          endColumn
        };
        const text2 = (match.groups ?? {})["label"] ?? "";
        const hasSeparatorLine = ((match.groups ?? {})["separator"] ?? "") !== "";
        const sectionHeader = {
          range,
          text: text2,
          hasSeparatorLine,
          shouldBeInComments: true
        };
        if (sectionHeader.text || sectionHeader.hasSeparatorLine) {
          if (markHeaders.length === 0 || markHeaders[markHeaders.length - 1].range.endLineNumber < sectionHeader.range.startLineNumber) {
            markHeaders.push(sectionHeader);
          }
        }
        regex.lastIndex = match.index + match[0].length;
      }
    }
    return markHeaders;
  }
  function getHeaderText(text) {
    text = text.trim();
    const hasSeparatorLine = text.startsWith("-");
    text = text.replace(trimDashesRegex, "");
    return { text, hasSeparatorLine };
  }
  class DeferredPromise {
    get isRejected() {
      return this.outcome?.outcome === 1;
    }
    get isSettled() {
      return !!this.outcome;
    }
    constructor() {
      this.p = new Promise((c, e) => {
        this.completeCallback = c;
        this.errorCallback = e;
      });
    }
    complete(value) {
      if (this.isSettled) {
        return Promise.resolve();
      }
      return new Promise((resolve) => {
        this.completeCallback(value);
        this.outcome = { outcome: 0, value };
        resolve();
      });
    }
    error(err) {
      if (this.isSettled) {
        return Promise.resolve();
      }
      return new Promise((resolve) => {
        this.errorCallback(err);
        this.outcome = { outcome: 1, value: err };
        resolve();
      });
    }
    cancel() {
      return this.error(new CancellationError());
    }
  }
  var Promises;
  (function(Promises2) {
    async function settled(promises) {
      let firstError = void 0;
      const result = await Promise.all(promises.map((promise) => promise.then((value) => value, (error) => {
        if (!firstError) {
          firstError = error;
        }
        return void 0;
      })));
      if (typeof firstError !== "undefined") {
        throw firstError;
      }
      return result;
    }
    Promises2.settled = settled;
    function withAsyncBody(bodyFn) {
      return new Promise(async (resolve, reject) => {
        try {
          await bodyFn(resolve, reject);
        } catch (error) {
          reject(error);
        }
      });
    }
    Promises2.withAsyncBody = withAsyncBody;
  })(Promises || (Promises = {}));
  class ProducerConsumer {
    constructor() {
      this._unsatisfiedConsumers = [];
      this._unconsumedValues = [];
    }
    get hasFinalValue() {
      return !!this._finalValue;
    }
    produce(value) {
      this._ensureNoFinalValue();
      if (this._unsatisfiedConsumers.length > 0) {
        const deferred = this._unsatisfiedConsumers.shift();
        this._resolveOrRejectDeferred(deferred, value);
      } else {
        this._unconsumedValues.push(value);
      }
    }
    produceFinal(value) {
      this._ensureNoFinalValue();
      this._finalValue = value;
      for (const deferred of this._unsatisfiedConsumers) {
        this._resolveOrRejectDeferred(deferred, value);
      }
      this._unsatisfiedConsumers.length = 0;
    }
    _ensureNoFinalValue() {
      if (this._finalValue) {
        throw new BugIndicatingError("ProducerConsumer: cannot produce after final value has been set");
      }
    }
    _resolveOrRejectDeferred(deferred, value) {
      if (value.ok) {
        deferred.complete(value.value);
      } else {
        deferred.error(value.error);
      }
    }
    consume() {
      if (this._unconsumedValues.length > 0 || this._finalValue) {
        const value = this._unconsumedValues.length > 0 ? this._unconsumedValues.shift() : this._finalValue;
        if (value.ok) {
          return Promise.resolve(value.value);
        } else {
          return Promise.reject(value.error);
        }
      } else {
        const deferred = new DeferredPromise();
        this._unsatisfiedConsumers.push(deferred);
        return deferred.p;
      }
    }
  }
  const _AsyncIterableProducer = class _AsyncIterableProducer {
    constructor(executor, _onReturn) {
      this._onReturn = _onReturn;
      this._producerConsumer = new ProducerConsumer();
      this._iterator = {
        next: () => this._producerConsumer.consume(),
        return: () => {
          this._onReturn?.();
          return Promise.resolve({ done: true, value: void 0 });
        },
        throw: async (e) => {
          this._finishError(e);
          return { done: true, value: void 0 };
        }
      };
      queueMicrotask(async () => {
        const p = executor({
          emitOne: (value) => this._producerConsumer.produce({ ok: true, value: { done: false, value } }),
          emitMany: (values) => {
            for (const value of values) {
              this._producerConsumer.produce({ ok: true, value: { done: false, value } });
            }
          },
          reject: (error) => this._finishError(error)
        });
        if (!this._producerConsumer.hasFinalValue) {
          try {
            await p;
            this._finishOk();
          } catch (error) {
            this._finishError(error);
          }
        }
      });
    }
    static fromArray(items) {
      return new _AsyncIterableProducer((writer) => {
        writer.emitMany(items);
      });
    }
    static fromPromise(promise) {
      return new _AsyncIterableProducer(async (emitter) => {
        emitter.emitMany(await promise);
      });
    }
    static fromPromisesResolveOrder(promises) {
      return new _AsyncIterableProducer(async (emitter) => {
        await Promise.all(promises.map(async (p) => emitter.emitOne(await p)));
      });
    }
    static merge(iterables) {
      return new _AsyncIterableProducer(async (emitter) => {
        await Promise.all(iterables.map(async (iterable) => {
          for await (const item of iterable) {
            emitter.emitOne(item);
          }
        }));
      });
    }
    static map(iterable, mapFn) {
      return new _AsyncIterableProducer(async (emitter) => {
        for await (const item of iterable) {
          emitter.emitOne(mapFn(item));
        }
      });
    }
    map(mapFn) {
      return _AsyncIterableProducer.map(this, mapFn);
    }
    static coalesce(iterable) {
      return _AsyncIterableProducer.filter(iterable, (item) => !!item);
    }
    coalesce() {
      return _AsyncIterableProducer.coalesce(this);
    }
    static filter(iterable, filterFn) {
      return new _AsyncIterableProducer(async (emitter) => {
        for await (const item of iterable) {
          if (filterFn(item)) {
            emitter.emitOne(item);
          }
        }
      });
    }
    filter(filterFn) {
      return _AsyncIterableProducer.filter(this, filterFn);
    }
    _finishOk() {
      if (!this._producerConsumer.hasFinalValue) {
        this._producerConsumer.produceFinal({ ok: true, value: { done: true, value: void 0 } });
      }
    }
    _finishError(error) {
      if (!this._producerConsumer.hasFinalValue) {
        this._producerConsumer.produceFinal({ ok: false, error });
      }
    }
    [Symbol.asyncIterator]() {
      return this._iterator;
    }
  };
  _AsyncIterableProducer.EMPTY = _AsyncIterableProducer.fromArray([]);
  let AsyncIterableProducer = _AsyncIterableProducer;
  class PrefixSumComputer {
    constructor(values) {
      this.values = values;
      this.prefixSum = new Uint32Array(values.length);
      this.prefixSumValidIndex = new Int32Array(1);
      this.prefixSumValidIndex[0] = -1;
    }
    insertValues(insertIndex, insertValues) {
      insertIndex = toUint32(insertIndex);
      const oldValues = this.values;
      const oldPrefixSum = this.prefixSum;
      const insertValuesLen = insertValues.length;
      if (insertValuesLen === 0) {
        return false;
      }
      this.values = new Uint32Array(oldValues.length + insertValuesLen);
      this.values.set(oldValues.subarray(0, insertIndex), 0);
      this.values.set(oldValues.subarray(insertIndex), insertIndex + insertValuesLen);
      this.values.set(insertValues, insertIndex);
      if (insertIndex - 1 < this.prefixSumValidIndex[0]) {
        this.prefixSumValidIndex[0] = insertIndex - 1;
      }
      this.prefixSum = new Uint32Array(this.values.length);
      if (this.prefixSumValidIndex[0] >= 0) {
        this.prefixSum.set(oldPrefixSum.subarray(0, this.prefixSumValidIndex[0] + 1));
      }
      return true;
    }
    setValue(index, value) {
      index = toUint32(index);
      value = toUint32(value);
      if (this.values[index] === value) {
        return false;
      }
      this.values[index] = value;
      if (index - 1 < this.prefixSumValidIndex[0]) {
        this.prefixSumValidIndex[0] = index - 1;
      }
      return true;
    }
    removeValues(startIndex, count) {
      startIndex = toUint32(startIndex);
      count = toUint32(count);
      const oldValues = this.values;
      const oldPrefixSum = this.prefixSum;
      if (startIndex >= oldValues.length) {
        return false;
      }
      const maxCount = oldValues.length - startIndex;
      if (count >= maxCount) {
        count = maxCount;
      }
      if (count === 0) {
        return false;
      }
      this.values = new Uint32Array(oldValues.length - count);
      this.values.set(oldValues.subarray(0, startIndex), 0);
      this.values.set(oldValues.subarray(startIndex + count), startIndex);
      this.prefixSum = new Uint32Array(this.values.length);
      if (startIndex - 1 < this.prefixSumValidIndex[0]) {
        this.prefixSumValidIndex[0] = startIndex - 1;
      }
      if (this.prefixSumValidIndex[0] >= 0) {
        this.prefixSum.set(oldPrefixSum.subarray(0, this.prefixSumValidIndex[0] + 1));
      }
      return true;
    }
    getTotalSum() {
      if (this.values.length === 0) {
        return 0;
      }
      return this._getPrefixSum(this.values.length - 1);
    }
    /**
     * Returns the sum of the first `index + 1` many items.
     * @returns `SUM(0 <= j <= index, values[j])`.
     */
    getPrefixSum(index) {
      if (index < 0) {
        return 0;
      }
      index = toUint32(index);
      return this._getPrefixSum(index);
    }
    _getPrefixSum(index) {
      if (index <= this.prefixSumValidIndex[0]) {
        return this.prefixSum[index];
      }
      let startIndex = this.prefixSumValidIndex[0] + 1;
      if (startIndex === 0) {
        this.prefixSum[0] = this.values[0];
        startIndex++;
      }
      if (index >= this.values.length) {
        index = this.values.length - 1;
      }
      for (let i = startIndex; i <= index; i++) {
        this.prefixSum[i] = this.prefixSum[i - 1] + this.values[i];
      }
      this.prefixSumValidIndex[0] = Math.max(this.prefixSumValidIndex[0], index);
      return this.prefixSum[index];
    }
    getIndexOf(sum) {
      sum = Math.floor(sum);
      this.getTotalSum();
      let low = 0;
      let high = this.values.length - 1;
      let mid = 0;
      let midStop = 0;
      let midStart = 0;
      while (low <= high) {
        mid = low + (high - low) / 2 | 0;
        midStop = this.prefixSum[mid];
        midStart = midStop - this.values[mid];
        if (sum < midStart) {
          high = mid - 1;
        } else if (sum >= midStop) {
          low = mid + 1;
        } else {
          break;
        }
      }
      return new PrefixSumIndexOfResult(mid, sum - midStart);
    }
  }
  class PrefixSumIndexOfResult {
    constructor(index, remainder) {
      this.index = index;
      this.remainder = remainder;
      this._prefixSumIndexOfResultBrand = void 0;
      this.index = index;
      this.remainder = remainder;
    }
  }
  class MirrorTextModel {
    constructor(uri, lines, eol, versionId) {
      this._uri = uri;
      this._lines = lines;
      this._eol = eol;
      this._versionId = versionId;
      this._lineStarts = null;
      this._cachedTextValue = null;
    }
    dispose() {
      this._lines.length = 0;
    }
    get version() {
      return this._versionId;
    }
    getText() {
      if (this._cachedTextValue === null) {
        this._cachedTextValue = this._lines.join(this._eol);
      }
      return this._cachedTextValue;
    }
    onEvents(e) {
      if (e.eol && e.eol !== this._eol) {
        this._eol = e.eol;
        this._lineStarts = null;
      }
      const changes = e.changes;
      for (const change of changes) {
        this._acceptDeleteRange(change.range);
        this._acceptInsertText(new Position$1(change.range.startLineNumber, change.range.startColumn), change.text);
      }
      this._versionId = e.versionId;
      this._cachedTextValue = null;
    }
    _ensureLineStarts() {
      if (!this._lineStarts) {
        const eolLength = this._eol.length;
        const linesLength = this._lines.length;
        const lineStartValues = new Uint32Array(linesLength);
        for (let i = 0; i < linesLength; i++) {
          lineStartValues[i] = this._lines[i].length + eolLength;
        }
        this._lineStarts = new PrefixSumComputer(lineStartValues);
      }
    }
    /**
     * All changes to a line's text go through this method
     */
    _setLineText(lineIndex, newValue) {
      this._lines[lineIndex] = newValue;
      if (this._lineStarts) {
        this._lineStarts.setValue(lineIndex, this._lines[lineIndex].length + this._eol.length);
      }
    }
    _acceptDeleteRange(range) {
      if (range.startLineNumber === range.endLineNumber) {
        if (range.startColumn === range.endColumn) {
          return;
        }
        this._setLineText(range.startLineNumber - 1, this._lines[range.startLineNumber - 1].substring(0, range.startColumn - 1) + this._lines[range.startLineNumber - 1].substring(range.endColumn - 1));
        return;
      }
      this._setLineText(range.startLineNumber - 1, this._lines[range.startLineNumber - 1].substring(0, range.startColumn - 1) + this._lines[range.endLineNumber - 1].substring(range.endColumn - 1));
      this._lines.splice(range.startLineNumber, range.endLineNumber - range.startLineNumber);
      if (this._lineStarts) {
        this._lineStarts.removeValues(range.startLineNumber, range.endLineNumber - range.startLineNumber);
      }
    }
    _acceptInsertText(position, insertText) {
      if (insertText.length === 0) {
        return;
      }
      const insertLines = splitLines(insertText);
      if (insertLines.length === 1) {
        this._setLineText(position.lineNumber - 1, this._lines[position.lineNumber - 1].substring(0, position.column - 1) + insertLines[0] + this._lines[position.lineNumber - 1].substring(position.column - 1));
        return;
      }
      insertLines[insertLines.length - 1] += this._lines[position.lineNumber - 1].substring(position.column - 1);
      this._setLineText(position.lineNumber - 1, this._lines[position.lineNumber - 1].substring(0, position.column - 1) + insertLines[0]);
      const newLengths = new Uint32Array(insertLines.length - 1);
      for (let i = 1; i < insertLines.length; i++) {
        this._lines.splice(position.lineNumber + i - 1, 0, insertLines[i]);
        newLengths[i - 1] = insertLines[i].length + this._eol.length;
      }
      if (this._lineStarts) {
        this._lineStarts.insertValues(position.lineNumber, newLengths);
      }
    }
  }
  class WorkerTextModelSyncServer {
    constructor() {
      this._models = /* @__PURE__ */ Object.create(null);
    }
    getModel(uri) {
      return this._models[uri];
    }
    getModels() {
      const all = [];
      Object.keys(this._models).forEach((key) => all.push(this._models[key]));
      return all;
    }
    $acceptNewModel(data) {
      this._models[data.url] = new MirrorModel(URI$2.parse(data.url), data.lines, data.EOL, data.versionId);
    }
    $acceptModelChanged(uri, e) {
      if (!this._models[uri]) {
        return;
      }
      const model = this._models[uri];
      model.onEvents(e);
    }
    $acceptRemovedModel(uri) {
      if (!this._models[uri]) {
        return;
      }
      delete this._models[uri];
    }
  }
  class MirrorModel extends MirrorTextModel {
    get uri() {
      return this._uri;
    }
    get eol() {
      return this._eol;
    }
    getValue() {
      return this.getText();
    }
    findMatches(regex) {
      const matches = [];
      for (let i = 0; i < this._lines.length; i++) {
        const line = this._lines[i];
        const offsetToAdd = this.offsetAt(new Position$1(i + 1, 1));
        const iteratorOverMatches = line.matchAll(regex);
        for (const match of iteratorOverMatches) {
          if (match.index || match.index === 0) {
            match.index = match.index + offsetToAdd;
          }
          matches.push(match);
        }
      }
      return matches;
    }
    getLinesContent() {
      return this._lines.slice(0);
    }
    getLineCount() {
      return this._lines.length;
    }
    getLineContent(lineNumber) {
      return this._lines[lineNumber - 1];
    }
    getWordAtPosition(position, wordDefinition) {
      const wordAtText = getWordAtText(position.column, ensureValidWordDefinition(wordDefinition), this._lines[position.lineNumber - 1], 0);
      if (wordAtText) {
        return new Range$1(position.lineNumber, wordAtText.startColumn, position.lineNumber, wordAtText.endColumn);
      }
      return null;
    }
    words(wordDefinition) {
      const lines = this._lines;
      const wordenize = this._wordenize.bind(this);
      let lineNumber = 0;
      let lineText = "";
      let wordRangesIdx = 0;
      let wordRanges = [];
      return {
        *[Symbol.iterator]() {
          while (true) {
            if (wordRangesIdx < wordRanges.length) {
              const value = lineText.substring(wordRanges[wordRangesIdx].start, wordRanges[wordRangesIdx].end);
              wordRangesIdx += 1;
              yield value;
            } else {
              if (lineNumber < lines.length) {
                lineText = lines[lineNumber];
                wordRanges = wordenize(lineText, wordDefinition);
                wordRangesIdx = 0;
                lineNumber += 1;
              } else {
                break;
              }
            }
          }
        }
      };
    }
    getLineWords(lineNumber, wordDefinition) {
      const content = this._lines[lineNumber - 1];
      const ranges = this._wordenize(content, wordDefinition);
      const words = [];
      for (const range of ranges) {
        words.push({
          word: content.substring(range.start, range.end),
          startColumn: range.start + 1,
          endColumn: range.end + 1
        });
      }
      return words;
    }
    _wordenize(content, wordDefinition) {
      const result = [];
      let match;
      wordDefinition.lastIndex = 0;
      while (match = wordDefinition.exec(content)) {
        if (match[0].length === 0) {
          break;
        }
        result.push({ start: match.index, end: match.index + match[0].length });
      }
      return result;
    }
    getValueInRange(range) {
      range = this._validateRange(range);
      if (range.startLineNumber === range.endLineNumber) {
        return this._lines[range.startLineNumber - 1].substring(range.startColumn - 1, range.endColumn - 1);
      }
      const lineEnding = this._eol;
      const startLineIndex = range.startLineNumber - 1;
      const endLineIndex = range.endLineNumber - 1;
      const resultLines = [];
      resultLines.push(this._lines[startLineIndex].substring(range.startColumn - 1));
      for (let i = startLineIndex + 1; i < endLineIndex; i++) {
        resultLines.push(this._lines[i]);
      }
      resultLines.push(this._lines[endLineIndex].substring(0, range.endColumn - 1));
      return resultLines.join(lineEnding);
    }
    offsetAt(position) {
      position = this._validatePosition(position);
      this._ensureLineStarts();
      return this._lineStarts.getPrefixSum(position.lineNumber - 2) + (position.column - 1);
    }
    positionAt(offset) {
      offset = Math.floor(offset);
      offset = Math.max(0, offset);
      this._ensureLineStarts();
      const out = this._lineStarts.getIndexOf(offset);
      const lineLength = this._lines[out.index].length;
      return {
        lineNumber: 1 + out.index,
        column: 1 + Math.min(out.remainder, lineLength)
      };
    }
    _validateRange(range) {
      const start2 = this._validatePosition({ lineNumber: range.startLineNumber, column: range.startColumn });
      const end = this._validatePosition({ lineNumber: range.endLineNumber, column: range.endColumn });
      if (start2.lineNumber !== range.startLineNumber || start2.column !== range.startColumn || end.lineNumber !== range.endLineNumber || end.column !== range.endColumn) {
        return {
          startLineNumber: start2.lineNumber,
          startColumn: start2.column,
          endLineNumber: end.lineNumber,
          endColumn: end.column
        };
      }
      return range;
    }
    _validatePosition(position) {
      if (!Position$1.isIPosition(position)) {
        throw new Error("bad position");
      }
      let { lineNumber, column } = position;
      let hasChanged = false;
      if (lineNumber < 1) {
        lineNumber = 1;
        column = 1;
        hasChanged = true;
      } else if (lineNumber > this._lines.length) {
        lineNumber = this._lines.length;
        column = this._lines[lineNumber - 1].length + 1;
        hasChanged = true;
      } else {
        const maxCharacter = this._lines[lineNumber - 1].length + 1;
        if (column < 1) {
          column = 1;
          hasChanged = true;
        } else if (column > maxCharacter) {
          column = maxCharacter;
          hasChanged = true;
        }
      }
      if (!hasChanged) {
        return position;
      } else {
        return { lineNumber, column };
      }
    }
  }
  const _EditorWorker = class _EditorWorker {
    constructor(_foreignModule = null) {
      this._foreignModule = _foreignModule;
      this._workerTextModelSyncServer = new WorkerTextModelSyncServer();
    }
    dispose() {
    }
    async $ping() {
      return "pong";
    }
    _getModel(uri) {
      return this._workerTextModelSyncServer.getModel(uri);
    }
    getModels() {
      return this._workerTextModelSyncServer.getModels();
    }
    $acceptNewModel(data) {
      this._workerTextModelSyncServer.$acceptNewModel(data);
    }
    $acceptModelChanged(uri, e) {
      this._workerTextModelSyncServer.$acceptModelChanged(uri, e);
    }
    $acceptRemovedModel(uri) {
      this._workerTextModelSyncServer.$acceptRemovedModel(uri);
    }
    async $computeUnicodeHighlights(url, options, range) {
      const model = this._getModel(url);
      if (!model) {
        return { ranges: [], hasMore: false, ambiguousCharacterCount: 0, invisibleCharacterCount: 0, nonBasicAsciiCharacterCount: 0 };
      }
      return UnicodeTextModelHighlighter.computeUnicodeHighlights(model, options, range);
    }
    async $findSectionHeaders(url, options) {
      const model = this._getModel(url);
      if (!model) {
        return [];
      }
      return findSectionHeaders(model, options);
    }
    // ---- BEGIN diff --------------------------------------------------------------------------
    async $computeDiff(originalUrl, modifiedUrl, options, algorithm) {
      const original = this._getModel(originalUrl);
      const modified = this._getModel(modifiedUrl);
      if (!original || !modified) {
        return null;
      }
      const result = _EditorWorker.computeDiff(original, modified, options, algorithm);
      return result;
    }
    static computeDiff(originalTextModel, modifiedTextModel, options, algorithm) {
      const diffAlgorithm = algorithm === "advanced" ? linesDiffComputers.getDefault() : linesDiffComputers.getLegacy();
      const originalLines = originalTextModel.getLinesContent();
      const modifiedLines = modifiedTextModel.getLinesContent();
      const result = diffAlgorithm.computeDiff(originalLines, modifiedLines, options);
      const identical = result.changes.length > 0 ? false : this._modelsAreIdentical(originalTextModel, modifiedTextModel);
      function getLineChanges(changes) {
        return changes.map((m) => [m.original.startLineNumber, m.original.endLineNumberExclusive, m.modified.startLineNumber, m.modified.endLineNumberExclusive, m.innerChanges?.map((m2) => [
          m2.originalRange.startLineNumber,
          m2.originalRange.startColumn,
          m2.originalRange.endLineNumber,
          m2.originalRange.endColumn,
          m2.modifiedRange.startLineNumber,
          m2.modifiedRange.startColumn,
          m2.modifiedRange.endLineNumber,
          m2.modifiedRange.endColumn
        ])]);
      }
      return {
        identical,
        quitEarly: result.hitTimeout,
        changes: getLineChanges(result.changes),
        moves: result.moves.map((m) => [
          m.lineRangeMapping.original.startLineNumber,
          m.lineRangeMapping.original.endLineNumberExclusive,
          m.lineRangeMapping.modified.startLineNumber,
          m.lineRangeMapping.modified.endLineNumberExclusive,
          getLineChanges(m.changes)
        ])
      };
    }
    static _modelsAreIdentical(original, modified) {
      const originalLineCount = original.getLineCount();
      const modifiedLineCount = modified.getLineCount();
      if (originalLineCount !== modifiedLineCount) {
        return false;
      }
      for (let line = 1; line <= originalLineCount; line++) {
        const originalLine = original.getLineContent(line);
        const modifiedLine = modified.getLineContent(line);
        if (originalLine !== modifiedLine) {
          return false;
        }
      }
      return true;
    }
    async $computeMoreMinimalEdits(modelUrl, edits, pretty) {
      const model = this._getModel(modelUrl);
      if (!model) {
        return edits;
      }
      const result = [];
      let lastEol = void 0;
      edits = edits.slice(0).sort((a, b) => {
        if (a.range && b.range) {
          return Range$1.compareRangesUsingStarts(a.range, b.range);
        }
        const aRng = a.range ? 0 : 1;
        const bRng = b.range ? 0 : 1;
        return aRng - bRng;
      });
      let writeIndex = 0;
      for (let readIndex = 1; readIndex < edits.length; readIndex++) {
        if (Range$1.getEndPosition(edits[writeIndex].range).equals(Range$1.getStartPosition(edits[readIndex].range))) {
          edits[writeIndex].range = Range$1.fromPositions(Range$1.getStartPosition(edits[writeIndex].range), Range$1.getEndPosition(edits[readIndex].range));
          edits[writeIndex].text += edits[readIndex].text;
        } else {
          writeIndex++;
          edits[writeIndex] = edits[readIndex];
        }
      }
      edits.length = writeIndex + 1;
      for (let { range, text, eol } of edits) {
        if (typeof eol === "number") {
          lastEol = eol;
        }
        if (Range$1.isEmpty(range) && !text) {
          continue;
        }
        const original = model.getValueInRange(range);
        text = text.replace(/\r\n|\n|\r/g, model.eol);
        if (original === text) {
          continue;
        }
        if (Math.max(text.length, original.length) > _EditorWorker._diffLimit) {
          result.push({ range, text });
          continue;
        }
        const changes = stringDiff(original, text, pretty);
        const editOffset = model.offsetAt(Range$1.lift(range).getStartPosition());
        for (const change of changes) {
          const start2 = model.positionAt(editOffset + change.originalStart);
          const end = model.positionAt(editOffset + change.originalStart + change.originalLength);
          const newEdit = {
            text: text.substr(change.modifiedStart, change.modifiedLength),
            range: { startLineNumber: start2.lineNumber, startColumn: start2.column, endLineNumber: end.lineNumber, endColumn: end.column }
          };
          if (model.getValueInRange(newEdit.range) !== newEdit.text) {
            result.push(newEdit);
          }
        }
      }
      if (typeof lastEol === "number") {
        result.push({ eol: lastEol, text: "", range: { startLineNumber: 0, startColumn: 0, endLineNumber: 0, endColumn: 0 } });
      }
      return result;
    }
    // ---- END minimal edits ---------------------------------------------------------------
    async $computeLinks(modelUrl) {
      const model = this._getModel(modelUrl);
      if (!model) {
        return null;
      }
      return computeLinks(model);
    }
    // --- BEGIN default document colors -----------------------------------------------------------
    async $computeDefaultDocumentColors(modelUrl) {
      const model = this._getModel(modelUrl);
      if (!model) {
        return null;
      }
      return computeDefaultDocumentColors(model);
    }
    async $textualSuggest(modelUrls, leadingWord, wordDef, wordDefFlags) {
      const sw = new StopWatch();
      const wordDefRegExp = new RegExp(wordDef, wordDefFlags);
      const seen = /* @__PURE__ */ new Set();
      outer: for (const url of modelUrls) {
        const model = this._getModel(url);
        if (!model) {
          continue;
        }
        for (const word of model.words(wordDefRegExp)) {
          if (word === leadingWord || !isNaN(Number(word))) {
            continue;
          }
          seen.add(word);
          if (seen.size > _EditorWorker._suggestionsLimit) {
            break outer;
          }
        }
      }
      return { words: Array.from(seen), duration: sw.elapsed() };
    }
    // ---- END suggest --------------------------------------------------------------------------
    //#region -- word ranges --
    async $computeWordRanges(modelUrl, range, wordDef, wordDefFlags) {
      const model = this._getModel(modelUrl);
      if (!model) {
        return /* @__PURE__ */ Object.create(null);
      }
      const wordDefRegExp = new RegExp(wordDef, wordDefFlags);
      const result = /* @__PURE__ */ Object.create(null);
      for (let line = range.startLineNumber; line < range.endLineNumber; line++) {
        const words = model.getLineWords(line, wordDefRegExp);
        for (const word of words) {
          if (!isNaN(Number(word.word))) {
            continue;
          }
          let array = result[word.word];
          if (!array) {
            array = [];
            result[word.word] = array;
          }
          array.push({
            startLineNumber: line,
            startColumn: word.startColumn,
            endLineNumber: line,
            endColumn: word.endColumn
          });
        }
      }
      return result;
    }
    //#endregion
    async $navigateValueSet(modelUrl, range, up, wordDef, wordDefFlags) {
      const model = this._getModel(modelUrl);
      if (!model) {
        return null;
      }
      const wordDefRegExp = new RegExp(wordDef, wordDefFlags);
      if (range.startColumn === range.endColumn) {
        range = {
          startLineNumber: range.startLineNumber,
          startColumn: range.startColumn,
          endLineNumber: range.endLineNumber,
          endColumn: range.endColumn + 1
        };
      }
      const selectionText = model.getValueInRange(range);
      const wordRange = model.getWordAtPosition({ lineNumber: range.startLineNumber, column: range.startColumn }, wordDefRegExp);
      if (!wordRange) {
        return null;
      }
      const word = model.getValueInRange(wordRange);
      const result = BasicInplaceReplace.INSTANCE.navigateValueSet(range, selectionText, wordRange, word, up);
      return result;
    }
    // ---- BEGIN foreign module support --------------------------------------------------------------------------
    // foreign method request
    $fmr(method, args) {
      if (!this._foreignModule || typeof this._foreignModule[method] !== "function") {
        return Promise.reject(new Error("Missing requestHandler or method: " + method));
      }
      try {
        return Promise.resolve(this._foreignModule[method].apply(this._foreignModule, args));
      } catch (e) {
        return Promise.reject(e);
      }
    }
  };
  _EditorWorker._diffLimit = 1e5;
  _EditorWorker._suggestionsLimit = 1e4;
  let EditorWorker = _EditorWorker;
  if (typeof importScripts === "function") {
    globalThis.monaco = createMonacoBaseAPI();
  }
  const _EditorWorkerHost = class _EditorWorkerHost {
    static getChannel(workerServer) {
      return workerServer.getChannel(_EditorWorkerHost.CHANNEL_NAME);
    }
    static setChannel(workerClient, obj) {
      workerClient.setChannel(_EditorWorkerHost.CHANNEL_NAME, obj);
    }
  };
  _EditorWorkerHost.CHANNEL_NAME = "editorWorkerHost";
  let EditorWorkerHost = _EditorWorkerHost;
  function start(createClient) {
    let client;
    const webWorkerServer = initialize$1((workerServer) => {
      const editorWorkerHost = EditorWorkerHost.getChannel(workerServer);
      const host = new Proxy({}, {
        get(target, prop, receiver) {
          if (prop === "then") {
            return void 0;
          }
          if (typeof prop !== "string") {
            throw new Error(`Not supported`);
          }
          return (...args) => {
            return editorWorkerHost.$fhr(prop, args);
          };
        }
      });
      const ctx = {
        host,
        getMirrorModels: () => {
          return webWorkerServer.requestHandler.getModels();
        }
      };
      client = createClient(ctx);
      return new EditorWorker(client);
    });
    return client;
  }
  function initialize(callback) {
    self.onmessage = (m) => {
      start((ctx) => {
        return callback(ctx, m.data);
      });
    };
  }
  function t(...args) {
    const firstArg = args[0];
    let key;
    let message;
    let formatArgs;
    if (typeof firstArg === "string") {
      key = firstArg;
      message = firstArg;
      args.splice(0, 1);
      formatArgs = !args || typeof args[0] !== "object" ? args : args[0];
    } else if (firstArg instanceof Array) {
      const replacements = args.slice(1);
      if (firstArg.length !== replacements.length + 1) {
        throw new Error("expected a string as the first argument to l10n.t");
      }
      let str = firstArg[0];
      for (let i = 1; i < firstArg.length; i++) {
        str += `{${i - 1}}` + firstArg[i];
      }
      return t(str, ...replacements);
    } else {
      message = firstArg.message;
      key = message;
      if (firstArg.comment && firstArg.comment.length > 0) {
        key += `/${Array.isArray(firstArg.comment) ? firstArg.comment.join("") : firstArg.comment}`;
      }
      formatArgs = firstArg.args ?? {};
    }
    {
      return format$1(message, formatArgs);
    }
  }
  var _format2Regexp = /{([^}]+)}/g;
  function format$1(template, values) {
    if (Object.keys(values).length === 0) {
      return template;
    }
    return template.replace(_format2Regexp, (match, group) => values[group] ?? match);
  }
  var DocumentUri;
  (function(DocumentUri2) {
    function is(value) {
      return typeof value === "string";
    }
    DocumentUri2.is = is;
  })(DocumentUri || (DocumentUri = {}));
  var URI$1;
  (function(URI2) {
    function is(value) {
      return typeof value === "string";
    }
    URI2.is = is;
  })(URI$1 || (URI$1 = {}));
  var integer;
  (function(integer2) {
    integer2.MIN_VALUE = -2147483648;
    integer2.MAX_VALUE = 2147483647;
    function is(value) {
      return typeof value === "number" && integer2.MIN_VALUE <= value && value <= integer2.MAX_VALUE;
    }
    integer2.is = is;
  })(integer || (integer = {}));
  var uinteger;
  (function(uinteger2) {
    uinteger2.MIN_VALUE = 0;
    uinteger2.MAX_VALUE = 2147483647;
    function is(value) {
      return typeof value === "number" && uinteger2.MIN_VALUE <= value && value <= uinteger2.MAX_VALUE;
    }
    uinteger2.is = is;
  })(uinteger || (uinteger = {}));
  var Position;
  (function(Position2) {
    function create(line, character) {
      if (line === Number.MAX_VALUE) {
        line = uinteger.MAX_VALUE;
      }
      if (character === Number.MAX_VALUE) {
        character = uinteger.MAX_VALUE;
      }
      return { line, character };
    }
    Position2.create = create;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Is.uinteger(candidate.line) && Is.uinteger(candidate.character);
    }
    Position2.is = is;
  })(Position || (Position = {}));
  var Range;
  (function(Range2) {
    function create(one, two, three, four) {
      if (Is.uinteger(one) && Is.uinteger(two) && Is.uinteger(three) && Is.uinteger(four)) {
        return { start: Position.create(one, two), end: Position.create(three, four) };
      } else if (Position.is(one) && Position.is(two)) {
        return { start: one, end: two };
      } else {
        throw new Error(`Range#create called with invalid arguments[${one}, ${two}, ${three}, ${four}]`);
      }
    }
    Range2.create = create;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Position.is(candidate.start) && Position.is(candidate.end);
    }
    Range2.is = is;
  })(Range || (Range = {}));
  var Location;
  (function(Location2) {
    function create(uri, range) {
      return { uri, range };
    }
    Location2.create = create;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Range.is(candidate.range) && (Is.string(candidate.uri) || Is.undefined(candidate.uri));
    }
    Location2.is = is;
  })(Location || (Location = {}));
  var LocationLink;
  (function(LocationLink2) {
    function create(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
      return { targetUri, targetRange, targetSelectionRange, originSelectionRange };
    }
    LocationLink2.create = create;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Range.is(candidate.targetRange) && Is.string(candidate.targetUri) && Range.is(candidate.targetSelectionRange) && (Range.is(candidate.originSelectionRange) || Is.undefined(candidate.originSelectionRange));
    }
    LocationLink2.is = is;
  })(LocationLink || (LocationLink = {}));
  var Color;
  (function(Color2) {
    function create(red, green, blue, alpha) {
      return {
        red,
        green,
        blue,
        alpha
      };
    }
    Color2.create = create;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.numberRange(candidate.red, 0, 1) && Is.numberRange(candidate.green, 0, 1) && Is.numberRange(candidate.blue, 0, 1) && Is.numberRange(candidate.alpha, 0, 1);
    }
    Color2.is = is;
  })(Color || (Color = {}));
  var ColorInformation;
  (function(ColorInformation2) {
    function create(range, color) {
      return {
        range,
        color
      };
    }
    ColorInformation2.create = create;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Range.is(candidate.range) && Color.is(candidate.color);
    }
    ColorInformation2.is = is;
  })(ColorInformation || (ColorInformation = {}));
  var ColorPresentation;
  (function(ColorPresentation2) {
    function create(label, textEdit, additionalTextEdits) {
      return {
        label,
        textEdit,
        additionalTextEdits
      };
    }
    ColorPresentation2.create = create;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.string(candidate.label) && (Is.undefined(candidate.textEdit) || TextEdit.is(candidate)) && (Is.undefined(candidate.additionalTextEdits) || Is.typedArray(candidate.additionalTextEdits, TextEdit.is));
    }
    ColorPresentation2.is = is;
  })(ColorPresentation || (ColorPresentation = {}));
  var FoldingRangeKind;
  (function(FoldingRangeKind2) {
    FoldingRangeKind2.Comment = "comment";
    FoldingRangeKind2.Imports = "imports";
    FoldingRangeKind2.Region = "region";
  })(FoldingRangeKind || (FoldingRangeKind = {}));
  var FoldingRange;
  (function(FoldingRange2) {
    function create(startLine, endLine, startCharacter, endCharacter, kind, collapsedText) {
      const result = {
        startLine,
        endLine
      };
      if (Is.defined(startCharacter)) {
        result.startCharacter = startCharacter;
      }
      if (Is.defined(endCharacter)) {
        result.endCharacter = endCharacter;
      }
      if (Is.defined(kind)) {
        result.kind = kind;
      }
      if (Is.defined(collapsedText)) {
        result.collapsedText = collapsedText;
      }
      return result;
    }
    FoldingRange2.create = create;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.uinteger(candidate.startLine) && Is.uinteger(candidate.startLine) && (Is.undefined(candidate.startCharacter) || Is.uinteger(candidate.startCharacter)) && (Is.undefined(candidate.endCharacter) || Is.uinteger(candidate.endCharacter)) && (Is.undefined(candidate.kind) || Is.string(candidate.kind));
    }
    FoldingRange2.is = is;
  })(FoldingRange || (FoldingRange = {}));
  var DiagnosticRelatedInformation;
  (function(DiagnosticRelatedInformation2) {
    function create(location, message) {
      return {
        location,
        message
      };
    }
    DiagnosticRelatedInformation2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Location.is(candidate.location) && Is.string(candidate.message);
    }
    DiagnosticRelatedInformation2.is = is;
  })(DiagnosticRelatedInformation || (DiagnosticRelatedInformation = {}));
  var DiagnosticSeverity;
  (function(DiagnosticSeverity2) {
    DiagnosticSeverity2.Error = 1;
    DiagnosticSeverity2.Warning = 2;
    DiagnosticSeverity2.Information = 3;
    DiagnosticSeverity2.Hint = 4;
  })(DiagnosticSeverity || (DiagnosticSeverity = {}));
  var DiagnosticTag;
  (function(DiagnosticTag2) {
    DiagnosticTag2.Unnecessary = 1;
    DiagnosticTag2.Deprecated = 2;
  })(DiagnosticTag || (DiagnosticTag = {}));
  var CodeDescription;
  (function(CodeDescription2) {
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.string(candidate.href);
    }
    CodeDescription2.is = is;
  })(CodeDescription || (CodeDescription = {}));
  var Diagnostic;
  (function(Diagnostic2) {
    function create(range, message, severity, code, source, relatedInformation) {
      let result = { range, message };
      if (Is.defined(severity)) {
        result.severity = severity;
      }
      if (Is.defined(code)) {
        result.code = code;
      }
      if (Is.defined(source)) {
        result.source = source;
      }
      if (Is.defined(relatedInformation)) {
        result.relatedInformation = relatedInformation;
      }
      return result;
    }
    Diagnostic2.create = create;
    function is(value) {
      var _a3;
      let candidate = value;
      return Is.defined(candidate) && Range.is(candidate.range) && Is.string(candidate.message) && (Is.number(candidate.severity) || Is.undefined(candidate.severity)) && (Is.integer(candidate.code) || Is.string(candidate.code) || Is.undefined(candidate.code)) && (Is.undefined(candidate.codeDescription) || Is.string((_a3 = candidate.codeDescription) === null || _a3 === void 0 ? void 0 : _a3.href)) && (Is.string(candidate.source) || Is.undefined(candidate.source)) && (Is.undefined(candidate.relatedInformation) || Is.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation.is));
    }
    Diagnostic2.is = is;
  })(Diagnostic || (Diagnostic = {}));
  var Command;
  (function(Command2) {
    function create(title, command, ...args) {
      let result = { title, command };
      if (Is.defined(args) && args.length > 0) {
        result.arguments = args;
      }
      return result;
    }
    Command2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.title) && Is.string(candidate.command);
    }
    Command2.is = is;
  })(Command || (Command = {}));
  var TextEdit;
  (function(TextEdit2) {
    function replace(range, newText) {
      return { range, newText };
    }
    TextEdit2.replace = replace;
    function insert(position, newText) {
      return { range: { start: position, end: position }, newText };
    }
    TextEdit2.insert = insert;
    function del(range) {
      return { range, newText: "" };
    }
    TextEdit2.del = del;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.string(candidate.newText) && Range.is(candidate.range);
    }
    TextEdit2.is = is;
  })(TextEdit || (TextEdit = {}));
  var ChangeAnnotation;
  (function(ChangeAnnotation2) {
    function create(label, needsConfirmation, description) {
      const result = { label };
      if (needsConfirmation !== void 0) {
        result.needsConfirmation = needsConfirmation;
      }
      if (description !== void 0) {
        result.description = description;
      }
      return result;
    }
    ChangeAnnotation2.create = create;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.string(candidate.label) && (Is.boolean(candidate.needsConfirmation) || candidate.needsConfirmation === void 0) && (Is.string(candidate.description) || candidate.description === void 0);
    }
    ChangeAnnotation2.is = is;
  })(ChangeAnnotation || (ChangeAnnotation = {}));
  var ChangeAnnotationIdentifier;
  (function(ChangeAnnotationIdentifier2) {
    function is(value) {
      const candidate = value;
      return Is.string(candidate);
    }
    ChangeAnnotationIdentifier2.is = is;
  })(ChangeAnnotationIdentifier || (ChangeAnnotationIdentifier = {}));
  var AnnotatedTextEdit;
  (function(AnnotatedTextEdit2) {
    function replace(range, newText, annotation) {
      return { range, newText, annotationId: annotation };
    }
    AnnotatedTextEdit2.replace = replace;
    function insert(position, newText, annotation) {
      return { range: { start: position, end: position }, newText, annotationId: annotation };
    }
    AnnotatedTextEdit2.insert = insert;
    function del(range, annotation) {
      return { range, newText: "", annotationId: annotation };
    }
    AnnotatedTextEdit2.del = del;
    function is(value) {
      const candidate = value;
      return TextEdit.is(candidate) && (ChangeAnnotation.is(candidate.annotationId) || ChangeAnnotationIdentifier.is(candidate.annotationId));
    }
    AnnotatedTextEdit2.is = is;
  })(AnnotatedTextEdit || (AnnotatedTextEdit = {}));
  var TextDocumentEdit;
  (function(TextDocumentEdit2) {
    function create(textDocument, edits) {
      return { textDocument, edits };
    }
    TextDocumentEdit2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && OptionalVersionedTextDocumentIdentifier.is(candidate.textDocument) && Array.isArray(candidate.edits);
    }
    TextDocumentEdit2.is = is;
  })(TextDocumentEdit || (TextDocumentEdit = {}));
  var CreateFile;
  (function(CreateFile2) {
    function create(uri, options, annotation) {
      let result = {
        kind: "create",
        uri
      };
      if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
        result.options = options;
      }
      if (annotation !== void 0) {
        result.annotationId = annotation;
      }
      return result;
    }
    CreateFile2.create = create;
    function is(value) {
      let candidate = value;
      return candidate && candidate.kind === "create" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
    }
    CreateFile2.is = is;
  })(CreateFile || (CreateFile = {}));
  var RenameFile;
  (function(RenameFile2) {
    function create(oldUri, newUri, options, annotation) {
      let result = {
        kind: "rename",
        oldUri,
        newUri
      };
      if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
        result.options = options;
      }
      if (annotation !== void 0) {
        result.annotationId = annotation;
      }
      return result;
    }
    RenameFile2.create = create;
    function is(value) {
      let candidate = value;
      return candidate && candidate.kind === "rename" && Is.string(candidate.oldUri) && Is.string(candidate.newUri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
    }
    RenameFile2.is = is;
  })(RenameFile || (RenameFile = {}));
  var DeleteFile;
  (function(DeleteFile2) {
    function create(uri, options, annotation) {
      let result = {
        kind: "delete",
        uri
      };
      if (options !== void 0 && (options.recursive !== void 0 || options.ignoreIfNotExists !== void 0)) {
        result.options = options;
      }
      if (annotation !== void 0) {
        result.annotationId = annotation;
      }
      return result;
    }
    DeleteFile2.create = create;
    function is(value) {
      let candidate = value;
      return candidate && candidate.kind === "delete" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.recursive === void 0 || Is.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === void 0 || Is.boolean(candidate.options.ignoreIfNotExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
    }
    DeleteFile2.is = is;
  })(DeleteFile || (DeleteFile = {}));
  var WorkspaceEdit;
  (function(WorkspaceEdit2) {
    function is(value) {
      let candidate = value;
      return candidate && (candidate.changes !== void 0 || candidate.documentChanges !== void 0) && (candidate.documentChanges === void 0 || candidate.documentChanges.every((change) => {
        if (Is.string(change.kind)) {
          return CreateFile.is(change) || RenameFile.is(change) || DeleteFile.is(change);
        } else {
          return TextDocumentEdit.is(change);
        }
      }));
    }
    WorkspaceEdit2.is = is;
  })(WorkspaceEdit || (WorkspaceEdit = {}));
  var TextDocumentIdentifier;
  (function(TextDocumentIdentifier2) {
    function create(uri) {
      return { uri };
    }
    TextDocumentIdentifier2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri);
    }
    TextDocumentIdentifier2.is = is;
  })(TextDocumentIdentifier || (TextDocumentIdentifier = {}));
  var VersionedTextDocumentIdentifier;
  (function(VersionedTextDocumentIdentifier2) {
    function create(uri, version) {
      return { uri, version };
    }
    VersionedTextDocumentIdentifier2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri) && Is.integer(candidate.version);
    }
    VersionedTextDocumentIdentifier2.is = is;
  })(VersionedTextDocumentIdentifier || (VersionedTextDocumentIdentifier = {}));
  var OptionalVersionedTextDocumentIdentifier;
  (function(OptionalVersionedTextDocumentIdentifier2) {
    function create(uri, version) {
      return { uri, version };
    }
    OptionalVersionedTextDocumentIdentifier2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri) && (candidate.version === null || Is.integer(candidate.version));
    }
    OptionalVersionedTextDocumentIdentifier2.is = is;
  })(OptionalVersionedTextDocumentIdentifier || (OptionalVersionedTextDocumentIdentifier = {}));
  var TextDocumentItem;
  (function(TextDocumentItem2) {
    function create(uri, languageId, version, text) {
      return { uri, languageId, version, text };
    }
    TextDocumentItem2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri) && Is.string(candidate.languageId) && Is.integer(candidate.version) && Is.string(candidate.text);
    }
    TextDocumentItem2.is = is;
  })(TextDocumentItem || (TextDocumentItem = {}));
  var MarkupKind;
  (function(MarkupKind2) {
    MarkupKind2.PlainText = "plaintext";
    MarkupKind2.Markdown = "markdown";
    function is(value) {
      const candidate = value;
      return candidate === MarkupKind2.PlainText || candidate === MarkupKind2.Markdown;
    }
    MarkupKind2.is = is;
  })(MarkupKind || (MarkupKind = {}));
  var MarkupContent;
  (function(MarkupContent2) {
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(value) && MarkupKind.is(candidate.kind) && Is.string(candidate.value);
    }
    MarkupContent2.is = is;
  })(MarkupContent || (MarkupContent = {}));
  var CompletionItemKind;
  (function(CompletionItemKind2) {
    CompletionItemKind2.Text = 1;
    CompletionItemKind2.Method = 2;
    CompletionItemKind2.Function = 3;
    CompletionItemKind2.Constructor = 4;
    CompletionItemKind2.Field = 5;
    CompletionItemKind2.Variable = 6;
    CompletionItemKind2.Class = 7;
    CompletionItemKind2.Interface = 8;
    CompletionItemKind2.Module = 9;
    CompletionItemKind2.Property = 10;
    CompletionItemKind2.Unit = 11;
    CompletionItemKind2.Value = 12;
    CompletionItemKind2.Enum = 13;
    CompletionItemKind2.Keyword = 14;
    CompletionItemKind2.Snippet = 15;
    CompletionItemKind2.Color = 16;
    CompletionItemKind2.File = 17;
    CompletionItemKind2.Reference = 18;
    CompletionItemKind2.Folder = 19;
    CompletionItemKind2.EnumMember = 20;
    CompletionItemKind2.Constant = 21;
    CompletionItemKind2.Struct = 22;
    CompletionItemKind2.Event = 23;
    CompletionItemKind2.Operator = 24;
    CompletionItemKind2.TypeParameter = 25;
  })(CompletionItemKind || (CompletionItemKind = {}));
  var InsertTextFormat;
  (function(InsertTextFormat2) {
    InsertTextFormat2.PlainText = 1;
    InsertTextFormat2.Snippet = 2;
  })(InsertTextFormat || (InsertTextFormat = {}));
  var CompletionItemTag;
  (function(CompletionItemTag2) {
    CompletionItemTag2.Deprecated = 1;
  })(CompletionItemTag || (CompletionItemTag = {}));
  var InsertReplaceEdit;
  (function(InsertReplaceEdit2) {
    function create(newText, insert, replace) {
      return { newText, insert, replace };
    }
    InsertReplaceEdit2.create = create;
    function is(value) {
      const candidate = value;
      return candidate && Is.string(candidate.newText) && Range.is(candidate.insert) && Range.is(candidate.replace);
    }
    InsertReplaceEdit2.is = is;
  })(InsertReplaceEdit || (InsertReplaceEdit = {}));
  var InsertTextMode;
  (function(InsertTextMode2) {
    InsertTextMode2.asIs = 1;
    InsertTextMode2.adjustIndentation = 2;
  })(InsertTextMode || (InsertTextMode = {}));
  var CompletionItemLabelDetails;
  (function(CompletionItemLabelDetails2) {
    function is(value) {
      const candidate = value;
      return candidate && (Is.string(candidate.detail) || candidate.detail === void 0) && (Is.string(candidate.description) || candidate.description === void 0);
    }
    CompletionItemLabelDetails2.is = is;
  })(CompletionItemLabelDetails || (CompletionItemLabelDetails = {}));
  var CompletionItem;
  (function(CompletionItem2) {
    function create(label) {
      return { label };
    }
    CompletionItem2.create = create;
  })(CompletionItem || (CompletionItem = {}));
  var CompletionList;
  (function(CompletionList2) {
    function create(items, isIncomplete) {
      return { items: items ? items : [], isIncomplete: !!isIncomplete };
    }
    CompletionList2.create = create;
  })(CompletionList || (CompletionList = {}));
  var MarkedString;
  (function(MarkedString2) {
    function fromPlainText(plainText) {
      return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, "\\$&");
    }
    MarkedString2.fromPlainText = fromPlainText;
    function is(value) {
      const candidate = value;
      return Is.string(candidate) || Is.objectLiteral(candidate) && Is.string(candidate.language) && Is.string(candidate.value);
    }
    MarkedString2.is = is;
  })(MarkedString || (MarkedString = {}));
  var Hover;
  (function(Hover2) {
    function is(value) {
      let candidate = value;
      return !!candidate && Is.objectLiteral(candidate) && (MarkupContent.is(candidate.contents) || MarkedString.is(candidate.contents) || Is.typedArray(candidate.contents, MarkedString.is)) && (value.range === void 0 || Range.is(value.range));
    }
    Hover2.is = is;
  })(Hover || (Hover = {}));
  var ParameterInformation;
  (function(ParameterInformation2) {
    function create(label, documentation) {
      return documentation ? { label, documentation } : { label };
    }
    ParameterInformation2.create = create;
  })(ParameterInformation || (ParameterInformation = {}));
  var SignatureInformation;
  (function(SignatureInformation2) {
    function create(label, documentation, ...parameters) {
      let result = { label };
      if (Is.defined(documentation)) {
        result.documentation = documentation;
      }
      if (Is.defined(parameters)) {
        result.parameters = parameters;
      } else {
        result.parameters = [];
      }
      return result;
    }
    SignatureInformation2.create = create;
  })(SignatureInformation || (SignatureInformation = {}));
  var DocumentHighlightKind;
  (function(DocumentHighlightKind2) {
    DocumentHighlightKind2.Text = 1;
    DocumentHighlightKind2.Read = 2;
    DocumentHighlightKind2.Write = 3;
  })(DocumentHighlightKind || (DocumentHighlightKind = {}));
  var DocumentHighlight;
  (function(DocumentHighlight2) {
    function create(range, kind) {
      let result = { range };
      if (Is.number(kind)) {
        result.kind = kind;
      }
      return result;
    }
    DocumentHighlight2.create = create;
  })(DocumentHighlight || (DocumentHighlight = {}));
  var SymbolKind;
  (function(SymbolKind2) {
    SymbolKind2.File = 1;
    SymbolKind2.Module = 2;
    SymbolKind2.Namespace = 3;
    SymbolKind2.Package = 4;
    SymbolKind2.Class = 5;
    SymbolKind2.Method = 6;
    SymbolKind2.Property = 7;
    SymbolKind2.Field = 8;
    SymbolKind2.Constructor = 9;
    SymbolKind2.Enum = 10;
    SymbolKind2.Interface = 11;
    SymbolKind2.Function = 12;
    SymbolKind2.Variable = 13;
    SymbolKind2.Constant = 14;
    SymbolKind2.String = 15;
    SymbolKind2.Number = 16;
    SymbolKind2.Boolean = 17;
    SymbolKind2.Array = 18;
    SymbolKind2.Object = 19;
    SymbolKind2.Key = 20;
    SymbolKind2.Null = 21;
    SymbolKind2.EnumMember = 22;
    SymbolKind2.Struct = 23;
    SymbolKind2.Event = 24;
    SymbolKind2.Operator = 25;
    SymbolKind2.TypeParameter = 26;
  })(SymbolKind || (SymbolKind = {}));
  var SymbolTag;
  (function(SymbolTag2) {
    SymbolTag2.Deprecated = 1;
  })(SymbolTag || (SymbolTag = {}));
  var SymbolInformation;
  (function(SymbolInformation2) {
    function create(name, kind, range, uri, containerName) {
      let result = {
        name,
        kind,
        location: { uri, range }
      };
      if (containerName) {
        result.containerName = containerName;
      }
      return result;
    }
    SymbolInformation2.create = create;
  })(SymbolInformation || (SymbolInformation = {}));
  var WorkspaceSymbol;
  (function(WorkspaceSymbol2) {
    function create(name, kind, uri, range) {
      return range !== void 0 ? { name, kind, location: { uri, range } } : { name, kind, location: { uri } };
    }
    WorkspaceSymbol2.create = create;
  })(WorkspaceSymbol || (WorkspaceSymbol = {}));
  var DocumentSymbol;
  (function(DocumentSymbol2) {
    function create(name, detail, kind, range, selectionRange, children) {
      let result = {
        name,
        detail,
        kind,
        range,
        selectionRange
      };
      if (children !== void 0) {
        result.children = children;
      }
      return result;
    }
    DocumentSymbol2.create = create;
    function is(value) {
      let candidate = value;
      return candidate && Is.string(candidate.name) && Is.number(candidate.kind) && Range.is(candidate.range) && Range.is(candidate.selectionRange) && (candidate.detail === void 0 || Is.string(candidate.detail)) && (candidate.deprecated === void 0 || Is.boolean(candidate.deprecated)) && (candidate.children === void 0 || Array.isArray(candidate.children)) && (candidate.tags === void 0 || Array.isArray(candidate.tags));
    }
    DocumentSymbol2.is = is;
  })(DocumentSymbol || (DocumentSymbol = {}));
  var CodeActionKind;
  (function(CodeActionKind2) {
    CodeActionKind2.Empty = "";
    CodeActionKind2.QuickFix = "quickfix";
    CodeActionKind2.Refactor = "refactor";
    CodeActionKind2.RefactorExtract = "refactor.extract";
    CodeActionKind2.RefactorInline = "refactor.inline";
    CodeActionKind2.RefactorRewrite = "refactor.rewrite";
    CodeActionKind2.Source = "source";
    CodeActionKind2.SourceOrganizeImports = "source.organizeImports";
    CodeActionKind2.SourceFixAll = "source.fixAll";
  })(CodeActionKind || (CodeActionKind = {}));
  var CodeActionTriggerKind;
  (function(CodeActionTriggerKind2) {
    CodeActionTriggerKind2.Invoked = 1;
    CodeActionTriggerKind2.Automatic = 2;
  })(CodeActionTriggerKind || (CodeActionTriggerKind = {}));
  var CodeActionContext;
  (function(CodeActionContext2) {
    function create(diagnostics, only, triggerKind) {
      let result = { diagnostics };
      if (only !== void 0 && only !== null) {
        result.only = only;
      }
      if (triggerKind !== void 0 && triggerKind !== null) {
        result.triggerKind = triggerKind;
      }
      return result;
    }
    CodeActionContext2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.typedArray(candidate.diagnostics, Diagnostic.is) && (candidate.only === void 0 || Is.typedArray(candidate.only, Is.string)) && (candidate.triggerKind === void 0 || candidate.triggerKind === CodeActionTriggerKind.Invoked || candidate.triggerKind === CodeActionTriggerKind.Automatic);
    }
    CodeActionContext2.is = is;
  })(CodeActionContext || (CodeActionContext = {}));
  var CodeAction;
  (function(CodeAction2) {
    function create(title, kindOrCommandOrEdit, kind) {
      let result = { title };
      let checkKind = true;
      if (typeof kindOrCommandOrEdit === "string") {
        checkKind = false;
        result.kind = kindOrCommandOrEdit;
      } else if (Command.is(kindOrCommandOrEdit)) {
        result.command = kindOrCommandOrEdit;
      } else {
        result.edit = kindOrCommandOrEdit;
      }
      if (checkKind && kind !== void 0) {
        result.kind = kind;
      }
      return result;
    }
    CodeAction2.create = create;
    function is(value) {
      let candidate = value;
      return candidate && Is.string(candidate.title) && (candidate.diagnostics === void 0 || Is.typedArray(candidate.diagnostics, Diagnostic.is)) && (candidate.kind === void 0 || Is.string(candidate.kind)) && (candidate.edit !== void 0 || candidate.command !== void 0) && (candidate.command === void 0 || Command.is(candidate.command)) && (candidate.isPreferred === void 0 || Is.boolean(candidate.isPreferred)) && (candidate.edit === void 0 || WorkspaceEdit.is(candidate.edit));
    }
    CodeAction2.is = is;
  })(CodeAction || (CodeAction = {}));
  var CodeLens;
  (function(CodeLens2) {
    function create(range, data) {
      let result = { range };
      if (Is.defined(data)) {
        result.data = data;
      }
      return result;
    }
    CodeLens2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.command) || Command.is(candidate.command));
    }
    CodeLens2.is = is;
  })(CodeLens || (CodeLens = {}));
  var FormattingOptions;
  (function(FormattingOptions2) {
    function create(tabSize, insertSpaces) {
      return { tabSize, insertSpaces };
    }
    FormattingOptions2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.uinteger(candidate.tabSize) && Is.boolean(candidate.insertSpaces);
    }
    FormattingOptions2.is = is;
  })(FormattingOptions || (FormattingOptions = {}));
  var DocumentLink;
  (function(DocumentLink2) {
    function create(range, target, data) {
      return { range, target, data };
    }
    DocumentLink2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.target) || Is.string(candidate.target));
    }
    DocumentLink2.is = is;
  })(DocumentLink || (DocumentLink = {}));
  var SelectionRange;
  (function(SelectionRange2) {
    function create(range, parent) {
      return { range, parent };
    }
    SelectionRange2.create = create;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Range.is(candidate.range) && (candidate.parent === void 0 || SelectionRange2.is(candidate.parent));
    }
    SelectionRange2.is = is;
  })(SelectionRange || (SelectionRange = {}));
  var SemanticTokenTypes;
  (function(SemanticTokenTypes2) {
    SemanticTokenTypes2["namespace"] = "namespace";
    SemanticTokenTypes2["type"] = "type";
    SemanticTokenTypes2["class"] = "class";
    SemanticTokenTypes2["enum"] = "enum";
    SemanticTokenTypes2["interface"] = "interface";
    SemanticTokenTypes2["struct"] = "struct";
    SemanticTokenTypes2["typeParameter"] = "typeParameter";
    SemanticTokenTypes2["parameter"] = "parameter";
    SemanticTokenTypes2["variable"] = "variable";
    SemanticTokenTypes2["property"] = "property";
    SemanticTokenTypes2["enumMember"] = "enumMember";
    SemanticTokenTypes2["event"] = "event";
    SemanticTokenTypes2["function"] = "function";
    SemanticTokenTypes2["method"] = "method";
    SemanticTokenTypes2["macro"] = "macro";
    SemanticTokenTypes2["keyword"] = "keyword";
    SemanticTokenTypes2["modifier"] = "modifier";
    SemanticTokenTypes2["comment"] = "comment";
    SemanticTokenTypes2["string"] = "string";
    SemanticTokenTypes2["number"] = "number";
    SemanticTokenTypes2["regexp"] = "regexp";
    SemanticTokenTypes2["operator"] = "operator";
    SemanticTokenTypes2["decorator"] = "decorator";
  })(SemanticTokenTypes || (SemanticTokenTypes = {}));
  var SemanticTokenModifiers;
  (function(SemanticTokenModifiers2) {
    SemanticTokenModifiers2["declaration"] = "declaration";
    SemanticTokenModifiers2["definition"] = "definition";
    SemanticTokenModifiers2["readonly"] = "readonly";
    SemanticTokenModifiers2["static"] = "static";
    SemanticTokenModifiers2["deprecated"] = "deprecated";
    SemanticTokenModifiers2["abstract"] = "abstract";
    SemanticTokenModifiers2["async"] = "async";
    SemanticTokenModifiers2["modification"] = "modification";
    SemanticTokenModifiers2["documentation"] = "documentation";
    SemanticTokenModifiers2["defaultLibrary"] = "defaultLibrary";
  })(SemanticTokenModifiers || (SemanticTokenModifiers = {}));
  var SemanticTokens;
  (function(SemanticTokens2) {
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && (candidate.resultId === void 0 || typeof candidate.resultId === "string") && Array.isArray(candidate.data) && (candidate.data.length === 0 || typeof candidate.data[0] === "number");
    }
    SemanticTokens2.is = is;
  })(SemanticTokens || (SemanticTokens = {}));
  var InlineValueText;
  (function(InlineValueText2) {
    function create(range, text) {
      return { range, text };
    }
    InlineValueText2.create = create;
    function is(value) {
      const candidate = value;
      return candidate !== void 0 && candidate !== null && Range.is(candidate.range) && Is.string(candidate.text);
    }
    InlineValueText2.is = is;
  })(InlineValueText || (InlineValueText = {}));
  var InlineValueVariableLookup;
  (function(InlineValueVariableLookup2) {
    function create(range, variableName, caseSensitiveLookup) {
      return { range, variableName, caseSensitiveLookup };
    }
    InlineValueVariableLookup2.create = create;
    function is(value) {
      const candidate = value;
      return candidate !== void 0 && candidate !== null && Range.is(candidate.range) && Is.boolean(candidate.caseSensitiveLookup) && (Is.string(candidate.variableName) || candidate.variableName === void 0);
    }
    InlineValueVariableLookup2.is = is;
  })(InlineValueVariableLookup || (InlineValueVariableLookup = {}));
  var InlineValueEvaluatableExpression;
  (function(InlineValueEvaluatableExpression2) {
    function create(range, expression) {
      return { range, expression };
    }
    InlineValueEvaluatableExpression2.create = create;
    function is(value) {
      const candidate = value;
      return candidate !== void 0 && candidate !== null && Range.is(candidate.range) && (Is.string(candidate.expression) || candidate.expression === void 0);
    }
    InlineValueEvaluatableExpression2.is = is;
  })(InlineValueEvaluatableExpression || (InlineValueEvaluatableExpression = {}));
  var InlineValueContext;
  (function(InlineValueContext2) {
    function create(frameId, stoppedLocation) {
      return { frameId, stoppedLocation };
    }
    InlineValueContext2.create = create;
    function is(value) {
      const candidate = value;
      return Is.defined(candidate) && Range.is(value.stoppedLocation);
    }
    InlineValueContext2.is = is;
  })(InlineValueContext || (InlineValueContext = {}));
  var InlayHintKind;
  (function(InlayHintKind2) {
    InlayHintKind2.Type = 1;
    InlayHintKind2.Parameter = 2;
    function is(value) {
      return value === 1 || value === 2;
    }
    InlayHintKind2.is = is;
  })(InlayHintKind || (InlayHintKind = {}));
  var InlayHintLabelPart;
  (function(InlayHintLabelPart2) {
    function create(value) {
      return { value };
    }
    InlayHintLabelPart2.create = create;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && (candidate.tooltip === void 0 || Is.string(candidate.tooltip) || MarkupContent.is(candidate.tooltip)) && (candidate.location === void 0 || Location.is(candidate.location)) && (candidate.command === void 0 || Command.is(candidate.command));
    }
    InlayHintLabelPart2.is = is;
  })(InlayHintLabelPart || (InlayHintLabelPart = {}));
  var InlayHint;
  (function(InlayHint2) {
    function create(position, label, kind) {
      const result = { position, label };
      if (kind !== void 0) {
        result.kind = kind;
      }
      return result;
    }
    InlayHint2.create = create;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Position.is(candidate.position) && (Is.string(candidate.label) || Is.typedArray(candidate.label, InlayHintLabelPart.is)) && (candidate.kind === void 0 || InlayHintKind.is(candidate.kind)) && candidate.textEdits === void 0 || Is.typedArray(candidate.textEdits, TextEdit.is) && (candidate.tooltip === void 0 || Is.string(candidate.tooltip) || MarkupContent.is(candidate.tooltip)) && (candidate.paddingLeft === void 0 || Is.boolean(candidate.paddingLeft)) && (candidate.paddingRight === void 0 || Is.boolean(candidate.paddingRight));
    }
    InlayHint2.is = is;
  })(InlayHint || (InlayHint = {}));
  var StringValue;
  (function(StringValue2) {
    function createSnippet(value) {
      return { kind: "snippet", value };
    }
    StringValue2.createSnippet = createSnippet;
  })(StringValue || (StringValue = {}));
  var InlineCompletionItem;
  (function(InlineCompletionItem2) {
    function create(insertText, filterText, range, command) {
      return { insertText, filterText, range, command };
    }
    InlineCompletionItem2.create = create;
  })(InlineCompletionItem || (InlineCompletionItem = {}));
  var InlineCompletionList;
  (function(InlineCompletionList2) {
    function create(items) {
      return { items };
    }
    InlineCompletionList2.create = create;
  })(InlineCompletionList || (InlineCompletionList = {}));
  var InlineCompletionTriggerKind;
  (function(InlineCompletionTriggerKind2) {
    InlineCompletionTriggerKind2.Invoked = 0;
    InlineCompletionTriggerKind2.Automatic = 1;
  })(InlineCompletionTriggerKind || (InlineCompletionTriggerKind = {}));
  var SelectedCompletionInfo;
  (function(SelectedCompletionInfo2) {
    function create(range, text) {
      return { range, text };
    }
    SelectedCompletionInfo2.create = create;
  })(SelectedCompletionInfo || (SelectedCompletionInfo = {}));
  var InlineCompletionContext;
  (function(InlineCompletionContext2) {
    function create(triggerKind, selectedCompletionInfo) {
      return { triggerKind, selectedCompletionInfo };
    }
    InlineCompletionContext2.create = create;
  })(InlineCompletionContext || (InlineCompletionContext = {}));
  var WorkspaceFolder;
  (function(WorkspaceFolder2) {
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && URI$1.is(candidate.uri) && Is.string(candidate.name);
    }
    WorkspaceFolder2.is = is;
  })(WorkspaceFolder || (WorkspaceFolder = {}));
  var TextDocument$1;
  (function(TextDocument2) {
    function create(uri, languageId, version, content) {
      return new FullTextDocument$1(uri, languageId, version, content);
    }
    TextDocument2.create = create;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri) && (Is.undefined(candidate.languageId) || Is.string(candidate.languageId)) && Is.uinteger(candidate.lineCount) && Is.func(candidate.getText) && Is.func(candidate.positionAt) && Is.func(candidate.offsetAt) ? true : false;
    }
    TextDocument2.is = is;
    function applyEdits(document2, edits) {
      let text = document2.getText();
      let sortedEdits = mergeSort2(edits, (a, b) => {
        let diff = a.range.start.line - b.range.start.line;
        if (diff === 0) {
          return a.range.start.character - b.range.start.character;
        }
        return diff;
      });
      let lastModifiedOffset = text.length;
      for (let i = sortedEdits.length - 1; i >= 0; i--) {
        let e = sortedEdits[i];
        let startOffset = document2.offsetAt(e.range.start);
        let endOffset = document2.offsetAt(e.range.end);
        if (endOffset <= lastModifiedOffset) {
          text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
        } else {
          throw new Error("Overlapping edit");
        }
        lastModifiedOffset = startOffset;
      }
      return text;
    }
    TextDocument2.applyEdits = applyEdits;
    function mergeSort2(data, compare) {
      if (data.length <= 1) {
        return data;
      }
      const p = data.length / 2 | 0;
      const left = data.slice(0, p);
      const right = data.slice(p);
      mergeSort2(left, compare);
      mergeSort2(right, compare);
      let leftIdx = 0;
      let rightIdx = 0;
      let i = 0;
      while (leftIdx < left.length && rightIdx < right.length) {
        let ret = compare(left[leftIdx], right[rightIdx]);
        if (ret <= 0) {
          data[i++] = left[leftIdx++];
        } else {
          data[i++] = right[rightIdx++];
        }
      }
      while (leftIdx < left.length) {
        data[i++] = left[leftIdx++];
      }
      while (rightIdx < right.length) {
        data[i++] = right[rightIdx++];
      }
      return data;
    }
  })(TextDocument$1 || (TextDocument$1 = {}));
  let FullTextDocument$1 = class FullTextDocument {
    constructor(uri, languageId, version, content) {
      this._uri = uri;
      this._languageId = languageId;
      this._version = version;
      this._content = content;
      this._lineOffsets = void 0;
    }
    get uri() {
      return this._uri;
    }
    get languageId() {
      return this._languageId;
    }
    get version() {
      return this._version;
    }
    getText(range) {
      if (range) {
        let start2 = this.offsetAt(range.start);
        let end = this.offsetAt(range.end);
        return this._content.substring(start2, end);
      }
      return this._content;
    }
    update(event, version) {
      this._content = event.text;
      this._version = version;
      this._lineOffsets = void 0;
    }
    getLineOffsets() {
      if (this._lineOffsets === void 0) {
        let lineOffsets = [];
        let text = this._content;
        let isLineStart = true;
        for (let i = 0; i < text.length; i++) {
          if (isLineStart) {
            lineOffsets.push(i);
            isLineStart = false;
          }
          let ch = text.charAt(i);
          isLineStart = ch === "\r" || ch === "\n";
          if (ch === "\r" && i + 1 < text.length && text.charAt(i + 1) === "\n") {
            i++;
          }
        }
        if (isLineStart && text.length > 0) {
          lineOffsets.push(text.length);
        }
        this._lineOffsets = lineOffsets;
      }
      return this._lineOffsets;
    }
    positionAt(offset) {
      offset = Math.max(Math.min(offset, this._content.length), 0);
      let lineOffsets = this.getLineOffsets();
      let low = 0, high = lineOffsets.length;
      if (high === 0) {
        return Position.create(0, offset);
      }
      while (low < high) {
        let mid = Math.floor((low + high) / 2);
        if (lineOffsets[mid] > offset) {
          high = mid;
        } else {
          low = mid + 1;
        }
      }
      let line = low - 1;
      return Position.create(line, offset - lineOffsets[line]);
    }
    offsetAt(position) {
      let lineOffsets = this.getLineOffsets();
      if (position.line >= lineOffsets.length) {
        return this._content.length;
      } else if (position.line < 0) {
        return 0;
      }
      let lineOffset = lineOffsets[position.line];
      let nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
      return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
    }
    get lineCount() {
      return this.getLineOffsets().length;
    }
  };
  var Is;
  (function(Is2) {
    const toString = Object.prototype.toString;
    function defined(value) {
      return typeof value !== "undefined";
    }
    Is2.defined = defined;
    function undefined$1(value) {
      return typeof value === "undefined";
    }
    Is2.undefined = undefined$1;
    function boolean(value) {
      return value === true || value === false;
    }
    Is2.boolean = boolean;
    function string(value) {
      return toString.call(value) === "[object String]";
    }
    Is2.string = string;
    function number(value) {
      return toString.call(value) === "[object Number]";
    }
    Is2.number = number;
    function numberRange(value, min, max) {
      return toString.call(value) === "[object Number]" && min <= value && value <= max;
    }
    Is2.numberRange = numberRange;
    function integer2(value) {
      return toString.call(value) === "[object Number]" && -2147483648 <= value && value <= 2147483647;
    }
    Is2.integer = integer2;
    function uinteger2(value) {
      return toString.call(value) === "[object Number]" && 0 <= value && value <= 2147483647;
    }
    Is2.uinteger = uinteger2;
    function func(value) {
      return toString.call(value) === "[object Function]";
    }
    Is2.func = func;
    function objectLiteral(value) {
      return value !== null && typeof value === "object";
    }
    Is2.objectLiteral = objectLiteral;
    function typedArray(value, check) {
      return Array.isArray(value) && value.every(check);
    }
    Is2.typedArray = typedArray;
  })(Is || (Is = {}));
  class FullTextDocument {
    constructor(uri, languageId, version, content) {
      this._uri = uri;
      this._languageId = languageId;
      this._version = version;
      this._content = content;
      this._lineOffsets = void 0;
    }
    get uri() {
      return this._uri;
    }
    get languageId() {
      return this._languageId;
    }
    get version() {
      return this._version;
    }
    getText(range) {
      if (range) {
        const start2 = this.offsetAt(range.start);
        const end = this.offsetAt(range.end);
        return this._content.substring(start2, end);
      }
      return this._content;
    }
    update(changes, version) {
      for (let change of changes) {
        if (FullTextDocument.isIncremental(change)) {
          const range = getWellformedRange(change.range);
          const startOffset = this.offsetAt(range.start);
          const endOffset = this.offsetAt(range.end);
          this._content = this._content.substring(0, startOffset) + change.text + this._content.substring(endOffset, this._content.length);
          const startLine = Math.max(range.start.line, 0);
          const endLine = Math.max(range.end.line, 0);
          let lineOffsets = this._lineOffsets;
          const addedLineOffsets = computeLineOffsets(change.text, false, startOffset);
          if (endLine - startLine === addedLineOffsets.length) {
            for (let i = 0, len = addedLineOffsets.length; i < len; i++) {
              lineOffsets[i + startLine + 1] = addedLineOffsets[i];
            }
          } else {
            if (addedLineOffsets.length < 1e4) {
              lineOffsets.splice(startLine + 1, endLine - startLine, ...addedLineOffsets);
            } else {
              this._lineOffsets = lineOffsets = lineOffsets.slice(0, startLine + 1).concat(addedLineOffsets, lineOffsets.slice(endLine + 1));
            }
          }
          const diff = change.text.length - (endOffset - startOffset);
          if (diff !== 0) {
            for (let i = startLine + 1 + addedLineOffsets.length, len = lineOffsets.length; i < len; i++) {
              lineOffsets[i] = lineOffsets[i] + diff;
            }
          }
        } else if (FullTextDocument.isFull(change)) {
          this._content = change.text;
          this._lineOffsets = void 0;
        } else {
          throw new Error("Unknown change event received");
        }
      }
      this._version = version;
    }
    getLineOffsets() {
      if (this._lineOffsets === void 0) {
        this._lineOffsets = computeLineOffsets(this._content, true);
      }
      return this._lineOffsets;
    }
    positionAt(offset) {
      offset = Math.max(Math.min(offset, this._content.length), 0);
      let lineOffsets = this.getLineOffsets();
      let low = 0, high = lineOffsets.length;
      if (high === 0) {
        return { line: 0, character: offset };
      }
      while (low < high) {
        let mid = Math.floor((low + high) / 2);
        if (lineOffsets[mid] > offset) {
          high = mid;
        } else {
          low = mid + 1;
        }
      }
      let line = low - 1;
      return { line, character: offset - lineOffsets[line] };
    }
    offsetAt(position) {
      let lineOffsets = this.getLineOffsets();
      if (position.line >= lineOffsets.length) {
        return this._content.length;
      } else if (position.line < 0) {
        return 0;
      }
      let lineOffset = lineOffsets[position.line];
      let nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
      return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
    }
    get lineCount() {
      return this.getLineOffsets().length;
    }
    static isIncremental(event) {
      let candidate = event;
      return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range !== void 0 && (candidate.rangeLength === void 0 || typeof candidate.rangeLength === "number");
    }
    static isFull(event) {
      let candidate = event;
      return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range === void 0 && candidate.rangeLength === void 0;
    }
  }
  var TextDocument;
  (function(TextDocument2) {
    function create(uri, languageId, version, content) {
      return new FullTextDocument(uri, languageId, version, content);
    }
    TextDocument2.create = create;
    function update(document2, changes, version) {
      if (document2 instanceof FullTextDocument) {
        document2.update(changes, version);
        return document2;
      } else {
        throw new Error("TextDocument.update: document must be created by TextDocument.create");
      }
    }
    TextDocument2.update = update;
    function applyEdits(document2, edits) {
      let text = document2.getText();
      let sortedEdits = mergeSort(edits.map(getWellformedEdit), (a, b) => {
        let diff = a.range.start.line - b.range.start.line;
        if (diff === 0) {
          return a.range.start.character - b.range.start.character;
        }
        return diff;
      });
      let lastModifiedOffset = 0;
      const spans = [];
      for (const e of sortedEdits) {
        let startOffset = document2.offsetAt(e.range.start);
        if (startOffset < lastModifiedOffset) {
          throw new Error("Overlapping edit");
        } else if (startOffset > lastModifiedOffset) {
          spans.push(text.substring(lastModifiedOffset, startOffset));
        }
        if (e.newText.length) {
          spans.push(e.newText);
        }
        lastModifiedOffset = document2.offsetAt(e.range.end);
      }
      spans.push(text.substr(lastModifiedOffset));
      return spans.join("");
    }
    TextDocument2.applyEdits = applyEdits;
  })(TextDocument || (TextDocument = {}));
  function mergeSort(data, compare) {
    if (data.length <= 1) {
      return data;
    }
    const p = data.length / 2 | 0;
    const left = data.slice(0, p);
    const right = data.slice(p);
    mergeSort(left, compare);
    mergeSort(right, compare);
    let leftIdx = 0;
    let rightIdx = 0;
    let i = 0;
    while (leftIdx < left.length && rightIdx < right.length) {
      let ret = compare(left[leftIdx], right[rightIdx]);
      if (ret <= 0) {
        data[i++] = left[leftIdx++];
      } else {
        data[i++] = right[rightIdx++];
      }
    }
    while (leftIdx < left.length) {
      data[i++] = left[leftIdx++];
    }
    while (rightIdx < right.length) {
      data[i++] = right[rightIdx++];
    }
    return data;
  }
  function computeLineOffsets(text, isAtLineStart, textOffset = 0) {
    const result = isAtLineStart ? [textOffset] : [];
    for (let i = 0; i < text.length; i++) {
      let ch = text.charCodeAt(i);
      if (ch === 13 || ch === 10) {
        if (ch === 13 && i + 1 < text.length && text.charCodeAt(i + 1) === 10) {
          i++;
        }
        result.push(textOffset + i + 1);
      }
    }
    return result;
  }
  function getWellformedRange(range) {
    const start2 = range.start;
    const end = range.end;
    if (start2.line > end.line || start2.line === end.line && start2.character > end.character) {
      return { start: end, end: start2 };
    }
    return range;
  }
  function getWellformedEdit(textEdit) {
    const range = getWellformedRange(textEdit.range);
    if (range !== textEdit.range) {
      return { newText: textEdit.newText, range };
    }
    return textEdit;
  }
  var TokenType;
  (function(TokenType2) {
    TokenType2[TokenType2["StartCommentTag"] = 0] = "StartCommentTag";
    TokenType2[TokenType2["Comment"] = 1] = "Comment";
    TokenType2[TokenType2["EndCommentTag"] = 2] = "EndCommentTag";
    TokenType2[TokenType2["StartTagOpen"] = 3] = "StartTagOpen";
    TokenType2[TokenType2["StartTagClose"] = 4] = "StartTagClose";
    TokenType2[TokenType2["StartTagSelfClose"] = 5] = "StartTagSelfClose";
    TokenType2[TokenType2["StartTag"] = 6] = "StartTag";
    TokenType2[TokenType2["EndTagOpen"] = 7] = "EndTagOpen";
    TokenType2[TokenType2["EndTagClose"] = 8] = "EndTagClose";
    TokenType2[TokenType2["EndTag"] = 9] = "EndTag";
    TokenType2[TokenType2["DelimiterAssign"] = 10] = "DelimiterAssign";
    TokenType2[TokenType2["AttributeName"] = 11] = "AttributeName";
    TokenType2[TokenType2["AttributeValue"] = 12] = "AttributeValue";
    TokenType2[TokenType2["StartDoctypeTag"] = 13] = "StartDoctypeTag";
    TokenType2[TokenType2["Doctype"] = 14] = "Doctype";
    TokenType2[TokenType2["EndDoctypeTag"] = 15] = "EndDoctypeTag";
    TokenType2[TokenType2["Content"] = 16] = "Content";
    TokenType2[TokenType2["Whitespace"] = 17] = "Whitespace";
    TokenType2[TokenType2["Unknown"] = 18] = "Unknown";
    TokenType2[TokenType2["Script"] = 19] = "Script";
    TokenType2[TokenType2["Styles"] = 20] = "Styles";
    TokenType2[TokenType2["EOS"] = 21] = "EOS";
  })(TokenType || (TokenType = {}));
  var ScannerState;
  (function(ScannerState2) {
    ScannerState2[ScannerState2["WithinContent"] = 0] = "WithinContent";
    ScannerState2[ScannerState2["AfterOpeningStartTag"] = 1] = "AfterOpeningStartTag";
    ScannerState2[ScannerState2["AfterOpeningEndTag"] = 2] = "AfterOpeningEndTag";
    ScannerState2[ScannerState2["WithinDoctype"] = 3] = "WithinDoctype";
    ScannerState2[ScannerState2["WithinTag"] = 4] = "WithinTag";
    ScannerState2[ScannerState2["WithinEndTag"] = 5] = "WithinEndTag";
    ScannerState2[ScannerState2["WithinComment"] = 6] = "WithinComment";
    ScannerState2[ScannerState2["WithinScriptContent"] = 7] = "WithinScriptContent";
    ScannerState2[ScannerState2["WithinStyleContent"] = 8] = "WithinStyleContent";
    ScannerState2[ScannerState2["AfterAttributeName"] = 9] = "AfterAttributeName";
    ScannerState2[ScannerState2["BeforeAttributeValue"] = 10] = "BeforeAttributeValue";
  })(ScannerState || (ScannerState = {}));
  var ClientCapabilities;
  (function(ClientCapabilities2) {
    ClientCapabilities2.LATEST = {
      textDocument: {
        completion: {
          completionItem: {
            documentationFormat: [MarkupKind.Markdown, MarkupKind.PlainText]
          }
        },
        hover: {
          contentFormat: [MarkupKind.Markdown, MarkupKind.PlainText]
        }
      }
    };
  })(ClientCapabilities || (ClientCapabilities = {}));
  var FileType;
  (function(FileType2) {
    FileType2[FileType2["Unknown"] = 0] = "Unknown";
    FileType2[FileType2["File"] = 1] = "File";
    FileType2[FileType2["Directory"] = 2] = "Directory";
    FileType2[FileType2["SymbolicLink"] = 64] = "SymbolicLink";
  })(FileType || (FileType = {}));
  class MultiLineStream {
    constructor(source, position) {
      this.source = source;
      this.len = source.length;
      this.position = position;
    }
    eos() {
      return this.len <= this.position;
    }
    getSource() {
      return this.source;
    }
    pos() {
      return this.position;
    }
    goBackTo(pos) {
      this.position = pos;
    }
    goBack(n) {
      this.position -= n;
    }
    advance(n) {
      this.position += n;
    }
    goToEnd() {
      this.position = this.source.length;
    }
    nextChar() {
      return this.source.charCodeAt(this.position++) || 0;
    }
    peekChar(n = 0) {
      return this.source.charCodeAt(this.position + n) || 0;
    }
    advanceIfChar(ch) {
      if (ch === this.source.charCodeAt(this.position)) {
        this.position++;
        return true;
      }
      return false;
    }
    advanceIfChars(ch) {
      let i;
      if (this.position + ch.length > this.source.length) {
        return false;
      }
      for (i = 0; i < ch.length; i++) {
        if (this.source.charCodeAt(this.position + i) !== ch[i]) {
          return false;
        }
      }
      this.advance(i);
      return true;
    }
    advanceIfRegExp(regex) {
      const str = this.source.substr(this.position);
      const match = str.match(regex);
      if (match) {
        this.position = this.position + match.index + match[0].length;
        return match[0];
      }
      return "";
    }
    advanceUntilRegExp(regex) {
      const str = this.source.substr(this.position);
      const match = str.match(regex);
      if (match) {
        this.position = this.position + match.index;
        return match[0];
      } else {
        this.goToEnd();
      }
      return "";
    }
    advanceUntilChar(ch) {
      while (this.position < this.source.length) {
        if (this.source.charCodeAt(this.position) === ch) {
          return true;
        }
        this.advance(1);
      }
      return false;
    }
    advanceUntilChars(ch) {
      while (this.position + ch.length <= this.source.length) {
        let i = 0;
        for (; i < ch.length && this.source.charCodeAt(this.position + i) === ch[i]; i++) {
        }
        if (i === ch.length) {
          return true;
        }
        this.advance(1);
      }
      this.goToEnd();
      return false;
    }
    skipWhitespace() {
      const n = this.advanceWhileChar((ch) => {
        return ch === _WSP || ch === _TAB || ch === _NWL || ch === _LFD || ch === _CAR;
      });
      return n > 0;
    }
    advanceWhileChar(condition) {
      const posNow = this.position;
      while (this.position < this.len && condition(this.source.charCodeAt(this.position))) {
        this.position++;
      }
      return this.position - posNow;
    }
  }
  const _BNG = "!".charCodeAt(0);
  const _MIN = "-".charCodeAt(0);
  const _LAN = "<".charCodeAt(0);
  const _RAN = ">".charCodeAt(0);
  const _FSL = "/".charCodeAt(0);
  const _EQS = "=".charCodeAt(0);
  const _DQO = '"'.charCodeAt(0);
  const _SQO = "'".charCodeAt(0);
  const _NWL = "\n".charCodeAt(0);
  const _CAR = "\r".charCodeAt(0);
  const _LFD = "\f".charCodeAt(0);
  const _WSP = " ".charCodeAt(0);
  const _TAB = "	".charCodeAt(0);
  const htmlScriptContents = {
    "text/x-handlebars-template": true,
    // Fix for https://github.com/microsoft/vscode/issues/77977
    "text/html": true
  };
  function createScanner(input, initialOffset = 0, initialState = ScannerState.WithinContent, emitPseudoCloseTags = false) {
    const stream = new MultiLineStream(input, initialOffset);
    let state = initialState;
    let tokenOffset = 0;
    let tokenType = TokenType.Unknown;
    let tokenError;
    let hasSpaceAfterTag;
    let lastTag;
    let lastAttributeName;
    let lastTypeValue;
    function nextElementName() {
      return stream.advanceIfRegExp(/^[_:\w][_:\w-.\d]*/).toLowerCase();
    }
    function nextAttributeName() {
      return stream.advanceIfRegExp(/^[^\s"'></=\x00-\x0F\x7F\x80-\x9F]*/).toLowerCase();
    }
    function finishToken(offset, type, errorMessage) {
      tokenType = type;
      tokenOffset = offset;
      tokenError = errorMessage;
      return type;
    }
    function scan() {
      const offset = stream.pos();
      const oldState = state;
      const token = internalScan();
      if (token !== TokenType.EOS && offset === stream.pos() && !(emitPseudoCloseTags && (token === TokenType.StartTagClose || token === TokenType.EndTagClose))) {
        console.warn("Scanner.scan has not advanced at offset " + offset + ", state before: " + oldState + " after: " + state);
        stream.advance(1);
        return finishToken(offset, TokenType.Unknown);
      }
      return token;
    }
    function internalScan() {
      const offset = stream.pos();
      if (stream.eos()) {
        return finishToken(offset, TokenType.EOS);
      }
      let errorMessage;
      switch (state) {
        case ScannerState.WithinComment:
          if (stream.advanceIfChars([_MIN, _MIN, _RAN])) {
            state = ScannerState.WithinContent;
            return finishToken(offset, TokenType.EndCommentTag);
          }
          stream.advanceUntilChars([_MIN, _MIN, _RAN]);
          return finishToken(offset, TokenType.Comment);
        case ScannerState.WithinDoctype:
          if (stream.advanceIfChar(_RAN)) {
            state = ScannerState.WithinContent;
            return finishToken(offset, TokenType.EndDoctypeTag);
          }
          stream.advanceUntilChar(_RAN);
          return finishToken(offset, TokenType.Doctype);
        case ScannerState.WithinContent:
          if (stream.advanceIfChar(_LAN)) {
            if (!stream.eos() && stream.peekChar() === _BNG) {
              if (stream.advanceIfChars([_BNG, _MIN, _MIN])) {
                state = ScannerState.WithinComment;
                return finishToken(offset, TokenType.StartCommentTag);
              }
              if (stream.advanceIfRegExp(/^!doctype/i)) {
                state = ScannerState.WithinDoctype;
                return finishToken(offset, TokenType.StartDoctypeTag);
              }
            }
            if (stream.advanceIfChar(_FSL)) {
              state = ScannerState.AfterOpeningEndTag;
              return finishToken(offset, TokenType.EndTagOpen);
            }
            state = ScannerState.AfterOpeningStartTag;
            return finishToken(offset, TokenType.StartTagOpen);
          }
          stream.advanceUntilChar(_LAN);
          return finishToken(offset, TokenType.Content);
        case ScannerState.AfterOpeningEndTag:
          const tagName = nextElementName();
          if (tagName.length > 0) {
            state = ScannerState.WithinEndTag;
            return finishToken(offset, TokenType.EndTag);
          }
          if (stream.skipWhitespace()) {
            return finishToken(offset, TokenType.Whitespace, t("Tag name must directly follow the open bracket."));
          }
          state = ScannerState.WithinEndTag;
          stream.advanceUntilChar(_RAN);
          if (offset < stream.pos()) {
            return finishToken(offset, TokenType.Unknown, t("End tag name expected."));
          }
          return internalScan();
        case ScannerState.WithinEndTag:
          if (stream.skipWhitespace()) {
            return finishToken(offset, TokenType.Whitespace);
          }
          if (stream.advanceIfChar(_RAN)) {
            state = ScannerState.WithinContent;
            return finishToken(offset, TokenType.EndTagClose);
          }
          if (emitPseudoCloseTags && stream.peekChar() === _LAN) {
            state = ScannerState.WithinContent;
            return finishToken(offset, TokenType.EndTagClose, t("Closing bracket missing."));
          }
          errorMessage = t("Closing bracket expected.");
          break;
        case ScannerState.AfterOpeningStartTag:
          lastTag = nextElementName();
          lastTypeValue = void 0;
          lastAttributeName = void 0;
          if (lastTag.length > 0) {
            hasSpaceAfterTag = false;
            state = ScannerState.WithinTag;
            return finishToken(offset, TokenType.StartTag);
          }
          if (stream.skipWhitespace()) {
            return finishToken(offset, TokenType.Whitespace, t("Tag name must directly follow the open bracket."));
          }
          state = ScannerState.WithinTag;
          stream.advanceUntilChar(_RAN);
          if (offset < stream.pos()) {
            return finishToken(offset, TokenType.Unknown, t("Start tag name expected."));
          }
          return internalScan();
        case ScannerState.WithinTag:
          if (stream.skipWhitespace()) {
            hasSpaceAfterTag = true;
            return finishToken(offset, TokenType.Whitespace);
          }
          if (hasSpaceAfterTag) {
            lastAttributeName = nextAttributeName();
            if (lastAttributeName.length > 0) {
              state = ScannerState.AfterAttributeName;
              hasSpaceAfterTag = false;
              return finishToken(offset, TokenType.AttributeName);
            }
          }
          if (stream.advanceIfChars([_FSL, _RAN])) {
            state = ScannerState.WithinContent;
            return finishToken(offset, TokenType.StartTagSelfClose);
          }
          if (stream.advanceIfChar(_RAN)) {
            if (lastTag === "script") {
              if (lastTypeValue && htmlScriptContents[lastTypeValue]) {
                state = ScannerState.WithinContent;
              } else {
                state = ScannerState.WithinScriptContent;
              }
            } else if (lastTag === "style") {
              state = ScannerState.WithinStyleContent;
            } else {
              state = ScannerState.WithinContent;
            }
            return finishToken(offset, TokenType.StartTagClose);
          }
          if (emitPseudoCloseTags && stream.peekChar() === _LAN) {
            state = ScannerState.WithinContent;
            return finishToken(offset, TokenType.StartTagClose, t("Closing bracket missing."));
          }
          stream.advance(1);
          return finishToken(offset, TokenType.Unknown, t("Unexpected character in tag."));
        case ScannerState.AfterAttributeName:
          if (stream.skipWhitespace()) {
            hasSpaceAfterTag = true;
            return finishToken(offset, TokenType.Whitespace);
          }
          if (stream.advanceIfChar(_EQS)) {
            state = ScannerState.BeforeAttributeValue;
            return finishToken(offset, TokenType.DelimiterAssign);
          }
          state = ScannerState.WithinTag;
          return internalScan();
        // no advance yet - jump to WithinTag
        case ScannerState.BeforeAttributeValue:
          if (stream.skipWhitespace()) {
            return finishToken(offset, TokenType.Whitespace);
          }
          let attributeValue = stream.advanceIfRegExp(/^[^\s"'`=<>]+/);
          if (attributeValue.length > 0) {
            if (stream.peekChar() === _RAN && stream.peekChar(-1) === _FSL) {
              stream.goBack(1);
              attributeValue = attributeValue.substring(0, attributeValue.length - 1);
            }
            if (lastAttributeName === "type") {
              lastTypeValue = attributeValue;
            }
            if (attributeValue.length > 0) {
              state = ScannerState.WithinTag;
              hasSpaceAfterTag = false;
              return finishToken(offset, TokenType.AttributeValue);
            }
          }
          const ch = stream.peekChar();
          if (ch === _SQO || ch === _DQO) {
            stream.advance(1);
            if (stream.advanceUntilChar(ch)) {
              stream.advance(1);
            }
            if (lastAttributeName === "type") {
              lastTypeValue = stream.getSource().substring(offset + 1, stream.pos() - 1);
            }
            state = ScannerState.WithinTag;
            hasSpaceAfterTag = false;
            return finishToken(offset, TokenType.AttributeValue);
          }
          state = ScannerState.WithinTag;
          hasSpaceAfterTag = false;
          return internalScan();
        // no advance yet - jump to WithinTag
        case ScannerState.WithinScriptContent:
          let sciptState = 1;
          while (!stream.eos()) {
            const match = stream.advanceIfRegExp(/<!--|-->|<\/?script\s*\/?>?/i);
            if (match.length === 0) {
              stream.goToEnd();
              return finishToken(offset, TokenType.Script);
            } else if (match === "<!--") {
              if (sciptState === 1) {
                sciptState = 2;
              }
            } else if (match === "-->") {
              sciptState = 1;
            } else if (match[1] !== "/") {
              if (sciptState === 2) {
                sciptState = 3;
              }
            } else {
              if (sciptState === 3) {
                sciptState = 2;
              } else {
                stream.goBack(match.length);
                break;
              }
            }
          }
          state = ScannerState.WithinContent;
          if (offset < stream.pos()) {
            return finishToken(offset, TokenType.Script);
          }
          return internalScan();
        // no advance yet - jump to content
        case ScannerState.WithinStyleContent:
          stream.advanceUntilRegExp(/<\/style/i);
          state = ScannerState.WithinContent;
          if (offset < stream.pos()) {
            return finishToken(offset, TokenType.Styles);
          }
          return internalScan();
      }
      stream.advance(1);
      state = ScannerState.WithinContent;
      return finishToken(offset, TokenType.Unknown, errorMessage);
    }
    return {
      scan,
      getTokenType: () => tokenType,
      getTokenOffset: () => tokenOffset,
      getTokenLength: () => stream.pos() - tokenOffset,
      getTokenEnd: () => stream.pos(),
      getTokenText: () => stream.getSource().substring(tokenOffset, stream.pos()),
      getScannerState: () => state,
      getTokenError: () => tokenError
    };
  }
  function findFirst(array, p) {
    let low = 0, high = array.length;
    if (high === 0) {
      return 0;
    }
    while (low < high) {
      let mid = Math.floor((low + high) / 2);
      if (p(array[mid])) {
        high = mid;
      } else {
        low = mid + 1;
      }
    }
    return low;
  }
  function binarySearch(array, key, comparator) {
    let low = 0, high = array.length - 1;
    while (low <= high) {
      const mid = (low + high) / 2 | 0;
      const comp = comparator(array[mid], key);
      if (comp < 0) {
        low = mid + 1;
      } else if (comp > 0) {
        high = mid - 1;
      } else {
        return mid;
      }
    }
    return -(low + 1);
  }
  class Node {
    get attributeNames() {
      return this.attributes ? Object.keys(this.attributes) : [];
    }
    constructor(start2, end, children, parent) {
      this.start = start2;
      this.end = end;
      this.children = children;
      this.parent = parent;
      this.closed = false;
    }
    isSameTag(tagInLowerCase) {
      if (this.tag === void 0) {
        return tagInLowerCase === void 0;
      } else {
        return tagInLowerCase !== void 0 && this.tag.length === tagInLowerCase.length && this.tag.toLowerCase() === tagInLowerCase;
      }
    }
    get firstChild() {
      return this.children[0];
    }
    get lastChild() {
      return this.children.length ? this.children[this.children.length - 1] : void 0;
    }
    findNodeBefore(offset) {
      const idx = findFirst(this.children, (c) => offset <= c.start) - 1;
      if (idx >= 0) {
        const child = this.children[idx];
        if (offset > child.start) {
          if (offset < child.end) {
            return child.findNodeBefore(offset);
          }
          const lastChild = child.lastChild;
          if (lastChild && lastChild.end === child.end) {
            return child.findNodeBefore(offset);
          }
          return child;
        }
      }
      return this;
    }
    findNodeAt(offset) {
      const idx = findFirst(this.children, (c) => offset <= c.start) - 1;
      if (idx >= 0) {
        const child = this.children[idx];
        if (offset > child.start && offset <= child.end) {
          return child.findNodeAt(offset);
        }
      }
      return this;
    }
  }
  class HTMLParser {
    constructor(dataManager) {
      this.dataManager = dataManager;
    }
    parseDocument(document2) {
      return this.parse(document2.getText(), this.dataManager.getVoidElements(document2.languageId));
    }
    parse(text, voidElements) {
      const scanner = createScanner(text, void 0, void 0, true);
      const htmlDocument = new Node(0, text.length, [], void 0);
      let curr = htmlDocument;
      let endTagStart = -1;
      let endTagName = void 0;
      let pendingAttribute = null;
      let token = scanner.scan();
      while (token !== TokenType.EOS) {
        switch (token) {
          case TokenType.StartTagOpen:
            const child = new Node(scanner.getTokenOffset(), text.length, [], curr);
            curr.children.push(child);
            curr = child;
            break;
          case TokenType.StartTag:
            curr.tag = scanner.getTokenText();
            break;
          case TokenType.StartTagClose:
            if (curr.parent) {
              curr.end = scanner.getTokenEnd();
              if (scanner.getTokenLength()) {
                curr.startTagEnd = scanner.getTokenEnd();
                if (curr.tag && this.dataManager.isVoidElement(curr.tag, voidElements)) {
                  curr.closed = true;
                  curr = curr.parent;
                }
              } else {
                curr = curr.parent;
              }
            }
            break;
          case TokenType.StartTagSelfClose:
            if (curr.parent) {
              curr.closed = true;
              curr.end = scanner.getTokenEnd();
              curr.startTagEnd = scanner.getTokenEnd();
              curr = curr.parent;
            }
            break;
          case TokenType.EndTagOpen:
            endTagStart = scanner.getTokenOffset();
            endTagName = void 0;
            break;
          case TokenType.EndTag:
            endTagName = scanner.getTokenText().toLowerCase();
            break;
          case TokenType.EndTagClose:
            let node = curr;
            while (!node.isSameTag(endTagName) && node.parent) {
              node = node.parent;
            }
            if (node.parent) {
              while (curr !== node) {
                curr.end = endTagStart;
                curr.closed = false;
                curr = curr.parent;
              }
              curr.closed = true;
              curr.endTagStart = endTagStart;
              curr.end = scanner.getTokenEnd();
              curr = curr.parent;
            }
            break;
          case TokenType.AttributeName: {
            pendingAttribute = scanner.getTokenText();
            let attributes = curr.attributes;
            if (!attributes) {
              curr.attributes = attributes = {};
            }
            attributes[pendingAttribute] = null;
            break;
          }
          case TokenType.AttributeValue: {
            const value = scanner.getTokenText();
            const attributes = curr.attributes;
            if (attributes && pendingAttribute) {
              attributes[pendingAttribute] = value;
              pendingAttribute = null;
            }
            break;
          }
        }
        token = scanner.scan();
      }
      while (curr.parent) {
        curr.end = text.length;
        curr.closed = false;
        curr = curr.parent;
      }
      return {
        roots: htmlDocument.children,
        findNodeBefore: htmlDocument.findNodeBefore.bind(htmlDocument),
        findNodeAt: htmlDocument.findNodeAt.bind(htmlDocument)
      };
    }
  }
  const entities = {
    "Aacute;": "Á",
    "Aacute": "Á",
    "aacute;": "á",
    "aacute": "á",
    "Abreve;": "Ă",
    "abreve;": "ă",
    "ac;": "∾",
    "acd;": "∿",
    "acE;": "∾̳",
    "Acirc;": "Â",
    "Acirc": "Â",
    "acirc;": "â",
    "acirc": "â",
    "acute;": "´",
    "acute": "´",
    "Acy;": "А",
    "acy;": "а",
    "AElig;": "Æ",
    "AElig": "Æ",
    "aelig;": "æ",
    "aelig": "æ",
    "af;": "⁡",
    "Afr;": "𝔄",
    "afr;": "𝔞",
    "Agrave;": "À",
    "Agrave": "À",
    "agrave;": "à",
    "agrave": "à",
    "alefsym;": "ℵ",
    "aleph;": "ℵ",
    "Alpha;": "Α",
    "alpha;": "α",
    "Amacr;": "Ā",
    "amacr;": "ā",
    "amalg;": "⨿",
    "AMP;": "&",
    "AMP": "&",
    "amp;": "&",
    "amp": "&",
    "And;": "⩓",
    "and;": "∧",
    "andand;": "⩕",
    "andd;": "⩜",
    "andslope;": "⩘",
    "andv;": "⩚",
    "ang;": "∠",
    "ange;": "⦤",
    "angle;": "∠",
    "angmsd;": "∡",
    "angmsdaa;": "⦨",
    "angmsdab;": "⦩",
    "angmsdac;": "⦪",
    "angmsdad;": "⦫",
    "angmsdae;": "⦬",
    "angmsdaf;": "⦭",
    "angmsdag;": "⦮",
    "angmsdah;": "⦯",
    "angrt;": "∟",
    "angrtvb;": "⊾",
    "angrtvbd;": "⦝",
    "angsph;": "∢",
    "angst;": "Å",
    "angzarr;": "⍼",
    "Aogon;": "Ą",
    "aogon;": "ą",
    "Aopf;": "𝔸",
    "aopf;": "𝕒",
    "ap;": "≈",
    "apacir;": "⩯",
    "apE;": "⩰",
    "ape;": "≊",
    "apid;": "≋",
    "apos;": "'",
    "ApplyFunction;": "⁡",
    "approx;": "≈",
    "approxeq;": "≊",
    "Aring;": "Å",
    "Aring": "Å",
    "aring;": "å",
    "aring": "å",
    "Ascr;": "𝒜",
    "ascr;": "𝒶",
    "Assign;": "≔",
    "ast;": "*",
    "asymp;": "≈",
    "asympeq;": "≍",
    "Atilde;": "Ã",
    "Atilde": "Ã",
    "atilde;": "ã",
    "atilde": "ã",
    "Auml;": "Ä",
    "Auml": "Ä",
    "auml;": "ä",
    "auml": "ä",
    "awconint;": "∳",
    "awint;": "⨑",
    "backcong;": "≌",
    "backepsilon;": "϶",
    "backprime;": "‵",
    "backsim;": "∽",
    "backsimeq;": "⋍",
    "Backslash;": "∖",
    "Barv;": "⫧",
    "barvee;": "⊽",
    "Barwed;": "⌆",
    "barwed;": "⌅",
    "barwedge;": "⌅",
    "bbrk;": "⎵",
    "bbrktbrk;": "⎶",
    "bcong;": "≌",
    "Bcy;": "Б",
    "bcy;": "б",
    "bdquo;": "„",
    "becaus;": "∵",
    "Because;": "∵",
    "because;": "∵",
    "bemptyv;": "⦰",
    "bepsi;": "϶",
    "bernou;": "ℬ",
    "Bernoullis;": "ℬ",
    "Beta;": "Β",
    "beta;": "β",
    "beth;": "ℶ",
    "between;": "≬",
    "Bfr;": "𝔅",
    "bfr;": "𝔟",
    "bigcap;": "⋂",
    "bigcirc;": "◯",
    "bigcup;": "⋃",
    "bigodot;": "⨀",
    "bigoplus;": "⨁",
    "bigotimes;": "⨂",
    "bigsqcup;": "⨆",
    "bigstar;": "★",
    "bigtriangledown;": "▽",
    "bigtriangleup;": "△",
    "biguplus;": "⨄",
    "bigvee;": "⋁",
    "bigwedge;": "⋀",
    "bkarow;": "⤍",
    "blacklozenge;": "⧫",
    "blacksquare;": "▪",
    "blacktriangle;": "▴",
    "blacktriangledown;": "▾",
    "blacktriangleleft;": "◂",
    "blacktriangleright;": "▸",
    "blank;": "␣",
    "blk12;": "▒",
    "blk14;": "░",
    "blk34;": "▓",
    "block;": "█",
    "bne;": "=⃥",
    "bnequiv;": "≡⃥",
    "bNot;": "⫭",
    "bnot;": "⌐",
    "Bopf;": "𝔹",
    "bopf;": "𝕓",
    "bot;": "⊥",
    "bottom;": "⊥",
    "bowtie;": "⋈",
    "boxbox;": "⧉",
    "boxDL;": "╗",
    "boxDl;": "╖",
    "boxdL;": "╕",
    "boxdl;": "┐",
    "boxDR;": "╔",
    "boxDr;": "╓",
    "boxdR;": "╒",
    "boxdr;": "┌",
    "boxH;": "═",
    "boxh;": "─",
    "boxHD;": "╦",
    "boxHd;": "╤",
    "boxhD;": "╥",
    "boxhd;": "┬",
    "boxHU;": "╩",
    "boxHu;": "╧",
    "boxhU;": "╨",
    "boxhu;": "┴",
    "boxminus;": "⊟",
    "boxplus;": "⊞",
    "boxtimes;": "⊠",
    "boxUL;": "╝",
    "boxUl;": "╜",
    "boxuL;": "╛",
    "boxul;": "┘",
    "boxUR;": "╚",
    "boxUr;": "╙",
    "boxuR;": "╘",
    "boxur;": "└",
    "boxV;": "║",
    "boxv;": "│",
    "boxVH;": "╬",
    "boxVh;": "╫",
    "boxvH;": "╪",
    "boxvh;": "┼",
    "boxVL;": "╣",
    "boxVl;": "╢",
    "boxvL;": "╡",
    "boxvl;": "┤",
    "boxVR;": "╠",
    "boxVr;": "╟",
    "boxvR;": "╞",
    "boxvr;": "├",
    "bprime;": "‵",
    "Breve;": "˘",
    "breve;": "˘",
    "brvbar;": "¦",
    "brvbar": "¦",
    "Bscr;": "ℬ",
    "bscr;": "𝒷",
    "bsemi;": "⁏",
    "bsim;": "∽",
    "bsime;": "⋍",
    "bsol;": "\\",
    "bsolb;": "⧅",
    "bsolhsub;": "⟈",
    "bull;": "•",
    "bullet;": "•",
    "bump;": "≎",
    "bumpE;": "⪮",
    "bumpe;": "≏",
    "Bumpeq;": "≎",
    "bumpeq;": "≏",
    "Cacute;": "Ć",
    "cacute;": "ć",
    "Cap;": "⋒",
    "cap;": "∩",
    "capand;": "⩄",
    "capbrcup;": "⩉",
    "capcap;": "⩋",
    "capcup;": "⩇",
    "capdot;": "⩀",
    "CapitalDifferentialD;": "ⅅ",
    "caps;": "∩︀",
    "caret;": "⁁",
    "caron;": "ˇ",
    "Cayleys;": "ℭ",
    "ccaps;": "⩍",
    "Ccaron;": "Č",
    "ccaron;": "č",
    "Ccedil;": "Ç",
    "Ccedil": "Ç",
    "ccedil;": "ç",
    "ccedil": "ç",
    "Ccirc;": "Ĉ",
    "ccirc;": "ĉ",
    "Cconint;": "∰",
    "ccups;": "⩌",
    "ccupssm;": "⩐",
    "Cdot;": "Ċ",
    "cdot;": "ċ",
    "cedil;": "¸",
    "cedil": "¸",
    "Cedilla;": "¸",
    "cemptyv;": "⦲",
    "cent;": "¢",
    "cent": "¢",
    "CenterDot;": "·",
    "centerdot;": "·",
    "Cfr;": "ℭ",
    "cfr;": "𝔠",
    "CHcy;": "Ч",
    "chcy;": "ч",
    "check;": "✓",
    "checkmark;": "✓",
    "Chi;": "Χ",
    "chi;": "χ",
    "cir;": "○",
    "circ;": "ˆ",
    "circeq;": "≗",
    "circlearrowleft;": "↺",
    "circlearrowright;": "↻",
    "circledast;": "⊛",
    "circledcirc;": "⊚",
    "circleddash;": "⊝",
    "CircleDot;": "⊙",
    "circledR;": "®",
    "circledS;": "Ⓢ",
    "CircleMinus;": "⊖",
    "CirclePlus;": "⊕",
    "CircleTimes;": "⊗",
    "cirE;": "⧃",
    "cire;": "≗",
    "cirfnint;": "⨐",
    "cirmid;": "⫯",
    "cirscir;": "⧂",
    "ClockwiseContourIntegral;": "∲",
    "CloseCurlyDoubleQuote;": "”",
    "CloseCurlyQuote;": "’",
    "clubs;": "♣",
    "clubsuit;": "♣",
    "Colon;": "∷",
    "colon;": ":",
    "Colone;": "⩴",
    "colone;": "≔",
    "coloneq;": "≔",
    "comma;": ",",
    "commat;": "@",
    "comp;": "∁",
    "compfn;": "∘",
    "complement;": "∁",
    "complexes;": "ℂ",
    "cong;": "≅",
    "congdot;": "⩭",
    "Congruent;": "≡",
    "Conint;": "∯",
    "conint;": "∮",
    "ContourIntegral;": "∮",
    "Copf;": "ℂ",
    "copf;": "𝕔",
    "coprod;": "∐",
    "Coproduct;": "∐",
    "COPY;": "©",
    "COPY": "©",
    "copy;": "©",
    "copy": "©",
    "copysr;": "℗",
    "CounterClockwiseContourIntegral;": "∳",
    "crarr;": "↵",
    "Cross;": "⨯",
    "cross;": "✗",
    "Cscr;": "𝒞",
    "cscr;": "𝒸",
    "csub;": "⫏",
    "csube;": "⫑",
    "csup;": "⫐",
    "csupe;": "⫒",
    "ctdot;": "⋯",
    "cudarrl;": "⤸",
    "cudarrr;": "⤵",
    "cuepr;": "⋞",
    "cuesc;": "⋟",
    "cularr;": "↶",
    "cularrp;": "⤽",
    "Cup;": "⋓",
    "cup;": "∪",
    "cupbrcap;": "⩈",
    "CupCap;": "≍",
    "cupcap;": "⩆",
    "cupcup;": "⩊",
    "cupdot;": "⊍",
    "cupor;": "⩅",
    "cups;": "∪︀",
    "curarr;": "↷",
    "curarrm;": "⤼",
    "curlyeqprec;": "⋞",
    "curlyeqsucc;": "⋟",
    "curlyvee;": "⋎",
    "curlywedge;": "⋏",
    "curren;": "¤",
    "curren": "¤",
    "curvearrowleft;": "↶",
    "curvearrowright;": "↷",
    "cuvee;": "⋎",
    "cuwed;": "⋏",
    "cwconint;": "∲",
    "cwint;": "∱",
    "cylcty;": "⌭",
    "Dagger;": "‡",
    "dagger;": "†",
    "daleth;": "ℸ",
    "Darr;": "↡",
    "dArr;": "⇓",
    "darr;": "↓",
    "dash;": "‐",
    "Dashv;": "⫤",
    "dashv;": "⊣",
    "dbkarow;": "⤏",
    "dblac;": "˝",
    "Dcaron;": "Ď",
    "dcaron;": "ď",
    "Dcy;": "Д",
    "dcy;": "д",
    "DD;": "ⅅ",
    "dd;": "ⅆ",
    "ddagger;": "‡",
    "ddarr;": "⇊",
    "DDotrahd;": "⤑",
    "ddotseq;": "⩷",
    "deg;": "°",
    "deg": "°",
    "Del;": "∇",
    "Delta;": "Δ",
    "delta;": "δ",
    "demptyv;": "⦱",
    "dfisht;": "⥿",
    "Dfr;": "𝔇",
    "dfr;": "𝔡",
    "dHar;": "⥥",
    "dharl;": "⇃",
    "dharr;": "⇂",
    "DiacriticalAcute;": "´",
    "DiacriticalDot;": "˙",
    "DiacriticalDoubleAcute;": "˝",
    "DiacriticalGrave;": "`",
    "DiacriticalTilde;": "˜",
    "diam;": "⋄",
    "Diamond;": "⋄",
    "diamond;": "⋄",
    "diamondsuit;": "♦",
    "diams;": "♦",
    "die;": "¨",
    "DifferentialD;": "ⅆ",
    "digamma;": "ϝ",
    "disin;": "⋲",
    "div;": "÷",
    "divide;": "÷",
    "divide": "÷",
    "divideontimes;": "⋇",
    "divonx;": "⋇",
    "DJcy;": "Ђ",
    "djcy;": "ђ",
    "dlcorn;": "⌞",
    "dlcrop;": "⌍",
    "dollar;": "$",
    "Dopf;": "𝔻",
    "dopf;": "𝕕",
    "Dot;": "¨",
    "dot;": "˙",
    "DotDot;": "⃜",
    "doteq;": "≐",
    "doteqdot;": "≑",
    "DotEqual;": "≐",
    "dotminus;": "∸",
    "dotplus;": "∔",
    "dotsquare;": "⊡",
    "doublebarwedge;": "⌆",
    "DoubleContourIntegral;": "∯",
    "DoubleDot;": "¨",
    "DoubleDownArrow;": "⇓",
    "DoubleLeftArrow;": "⇐",
    "DoubleLeftRightArrow;": "⇔",
    "DoubleLeftTee;": "⫤",
    "DoubleLongLeftArrow;": "⟸",
    "DoubleLongLeftRightArrow;": "⟺",
    "DoubleLongRightArrow;": "⟹",
    "DoubleRightArrow;": "⇒",
    "DoubleRightTee;": "⊨",
    "DoubleUpArrow;": "⇑",
    "DoubleUpDownArrow;": "⇕",
    "DoubleVerticalBar;": "∥",
    "DownArrow;": "↓",
    "Downarrow;": "⇓",
    "downarrow;": "↓",
    "DownArrowBar;": "⤓",
    "DownArrowUpArrow;": "⇵",
    "DownBreve;": "̑",
    "downdownarrows;": "⇊",
    "downharpoonleft;": "⇃",
    "downharpoonright;": "⇂",
    "DownLeftRightVector;": "⥐",
    "DownLeftTeeVector;": "⥞",
    "DownLeftVector;": "↽",
    "DownLeftVectorBar;": "⥖",
    "DownRightTeeVector;": "⥟",
    "DownRightVector;": "⇁",
    "DownRightVectorBar;": "⥗",
    "DownTee;": "⊤",
    "DownTeeArrow;": "↧",
    "drbkarow;": "⤐",
    "drcorn;": "⌟",
    "drcrop;": "⌌",
    "Dscr;": "𝒟",
    "dscr;": "𝒹",
    "DScy;": "Ѕ",
    "dscy;": "ѕ",
    "dsol;": "⧶",
    "Dstrok;": "Đ",
    "dstrok;": "đ",
    "dtdot;": "⋱",
    "dtri;": "▿",
    "dtrif;": "▾",
    "duarr;": "⇵",
    "duhar;": "⥯",
    "dwangle;": "⦦",
    "DZcy;": "Џ",
    "dzcy;": "џ",
    "dzigrarr;": "⟿",
    "Eacute;": "É",
    "Eacute": "É",
    "eacute;": "é",
    "eacute": "é",
    "easter;": "⩮",
    "Ecaron;": "Ě",
    "ecaron;": "ě",
    "ecir;": "≖",
    "Ecirc;": "Ê",
    "Ecirc": "Ê",
    "ecirc;": "ê",
    "ecirc": "ê",
    "ecolon;": "≕",
    "Ecy;": "Э",
    "ecy;": "э",
    "eDDot;": "⩷",
    "Edot;": "Ė",
    "eDot;": "≑",
    "edot;": "ė",
    "ee;": "ⅇ",
    "efDot;": "≒",
    "Efr;": "𝔈",
    "efr;": "𝔢",
    "eg;": "⪚",
    "Egrave;": "È",
    "Egrave": "È",
    "egrave;": "è",
    "egrave": "è",
    "egs;": "⪖",
    "egsdot;": "⪘",
    "el;": "⪙",
    "Element;": "∈",
    "elinters;": "⏧",
    "ell;": "ℓ",
    "els;": "⪕",
    "elsdot;": "⪗",
    "Emacr;": "Ē",
    "emacr;": "ē",
    "empty;": "∅",
    "emptyset;": "∅",
    "EmptySmallSquare;": "◻",
    "emptyv;": "∅",
    "EmptyVerySmallSquare;": "▫",
    "emsp;": " ",
    "emsp13;": " ",
    "emsp14;": " ",
    "ENG;": "Ŋ",
    "eng;": "ŋ",
    "ensp;": " ",
    "Eogon;": "Ę",
    "eogon;": "ę",
    "Eopf;": "𝔼",
    "eopf;": "𝕖",
    "epar;": "⋕",
    "eparsl;": "⧣",
    "eplus;": "⩱",
    "epsi;": "ε",
    "Epsilon;": "Ε",
    "epsilon;": "ε",
    "epsiv;": "ϵ",
    "eqcirc;": "≖",
    "eqcolon;": "≕",
    "eqsim;": "≂",
    "eqslantgtr;": "⪖",
    "eqslantless;": "⪕",
    "Equal;": "⩵",
    "equals;": "=",
    "EqualTilde;": "≂",
    "equest;": "≟",
    "Equilibrium;": "⇌",
    "equiv;": "≡",
    "equivDD;": "⩸",
    "eqvparsl;": "⧥",
    "erarr;": "⥱",
    "erDot;": "≓",
    "Escr;": "ℰ",
    "escr;": "ℯ",
    "esdot;": "≐",
    "Esim;": "⩳",
    "esim;": "≂",
    "Eta;": "Η",
    "eta;": "η",
    "ETH;": "Ð",
    "ETH": "Ð",
    "eth;": "ð",
    "eth": "ð",
    "Euml;": "Ë",
    "Euml": "Ë",
    "euml;": "ë",
    "euml": "ë",
    "euro;": "€",
    "excl;": "!",
    "exist;": "∃",
    "Exists;": "∃",
    "expectation;": "ℰ",
    "ExponentialE;": "ⅇ",
    "exponentiale;": "ⅇ",
    "fallingdotseq;": "≒",
    "Fcy;": "Ф",
    "fcy;": "ф",
    "female;": "♀",
    "ffilig;": "ﬃ",
    "fflig;": "ﬀ",
    "ffllig;": "ﬄ",
    "Ffr;": "𝔉",
    "ffr;": "𝔣",
    "filig;": "ﬁ",
    "FilledSmallSquare;": "◼",
    "FilledVerySmallSquare;": "▪",
    "fjlig;": "fj",
    "flat;": "♭",
    "fllig;": "ﬂ",
    "fltns;": "▱",
    "fnof;": "ƒ",
    "Fopf;": "𝔽",
    "fopf;": "𝕗",
    "ForAll;": "∀",
    "forall;": "∀",
    "fork;": "⋔",
    "forkv;": "⫙",
    "Fouriertrf;": "ℱ",
    "fpartint;": "⨍",
    "frac12;": "½",
    "frac12": "½",
    "frac13;": "⅓",
    "frac14;": "¼",
    "frac14": "¼",
    "frac15;": "⅕",
    "frac16;": "⅙",
    "frac18;": "⅛",
    "frac23;": "⅔",
    "frac25;": "⅖",
    "frac34;": "¾",
    "frac34": "¾",
    "frac35;": "⅗",
    "frac38;": "⅜",
    "frac45;": "⅘",
    "frac56;": "⅚",
    "frac58;": "⅝",
    "frac78;": "⅞",
    "frasl;": "⁄",
    "frown;": "⌢",
    "Fscr;": "ℱ",
    "fscr;": "𝒻",
    "gacute;": "ǵ",
    "Gamma;": "Γ",
    "gamma;": "γ",
    "Gammad;": "Ϝ",
    "gammad;": "ϝ",
    "gap;": "⪆",
    "Gbreve;": "Ğ",
    "gbreve;": "ğ",
    "Gcedil;": "Ģ",
    "Gcirc;": "Ĝ",
    "gcirc;": "ĝ",
    "Gcy;": "Г",
    "gcy;": "г",
    "Gdot;": "Ġ",
    "gdot;": "ġ",
    "gE;": "≧",
    "ge;": "≥",
    "gEl;": "⪌",
    "gel;": "⋛",
    "geq;": "≥",
    "geqq;": "≧",
    "geqslant;": "⩾",
    "ges;": "⩾",
    "gescc;": "⪩",
    "gesdot;": "⪀",
    "gesdoto;": "⪂",
    "gesdotol;": "⪄",
    "gesl;": "⋛︀",
    "gesles;": "⪔",
    "Gfr;": "𝔊",
    "gfr;": "𝔤",
    "Gg;": "⋙",
    "gg;": "≫",
    "ggg;": "⋙",
    "gimel;": "ℷ",
    "GJcy;": "Ѓ",
    "gjcy;": "ѓ",
    "gl;": "≷",
    "gla;": "⪥",
    "glE;": "⪒",
    "glj;": "⪤",
    "gnap;": "⪊",
    "gnapprox;": "⪊",
    "gnE;": "≩",
    "gne;": "⪈",
    "gneq;": "⪈",
    "gneqq;": "≩",
    "gnsim;": "⋧",
    "Gopf;": "𝔾",
    "gopf;": "𝕘",
    "grave;": "`",
    "GreaterEqual;": "≥",
    "GreaterEqualLess;": "⋛",
    "GreaterFullEqual;": "≧",
    "GreaterGreater;": "⪢",
    "GreaterLess;": "≷",
    "GreaterSlantEqual;": "⩾",
    "GreaterTilde;": "≳",
    "Gscr;": "𝒢",
    "gscr;": "ℊ",
    "gsim;": "≳",
    "gsime;": "⪎",
    "gsiml;": "⪐",
    "GT;": ">",
    "GT": ">",
    "Gt;": "≫",
    "gt;": ">",
    "gt": ">",
    "gtcc;": "⪧",
    "gtcir;": "⩺",
    "gtdot;": "⋗",
    "gtlPar;": "⦕",
    "gtquest;": "⩼",
    "gtrapprox;": "⪆",
    "gtrarr;": "⥸",
    "gtrdot;": "⋗",
    "gtreqless;": "⋛",
    "gtreqqless;": "⪌",
    "gtrless;": "≷",
    "gtrsim;": "≳",
    "gvertneqq;": "≩︀",
    "gvnE;": "≩︀",
    "Hacek;": "ˇ",
    "hairsp;": " ",
    "half;": "½",
    "hamilt;": "ℋ",
    "HARDcy;": "Ъ",
    "hardcy;": "ъ",
    "hArr;": "⇔",
    "harr;": "↔",
    "harrcir;": "⥈",
    "harrw;": "↭",
    "Hat;": "^",
    "hbar;": "ℏ",
    "Hcirc;": "Ĥ",
    "hcirc;": "ĥ",
    "hearts;": "♥",
    "heartsuit;": "♥",
    "hellip;": "…",
    "hercon;": "⊹",
    "Hfr;": "ℌ",
    "hfr;": "𝔥",
    "HilbertSpace;": "ℋ",
    "hksearow;": "⤥",
    "hkswarow;": "⤦",
    "hoarr;": "⇿",
    "homtht;": "∻",
    "hookleftarrow;": "↩",
    "hookrightarrow;": "↪",
    "Hopf;": "ℍ",
    "hopf;": "𝕙",
    "horbar;": "―",
    "HorizontalLine;": "─",
    "Hscr;": "ℋ",
    "hscr;": "𝒽",
    "hslash;": "ℏ",
    "Hstrok;": "Ħ",
    "hstrok;": "ħ",
    "HumpDownHump;": "≎",
    "HumpEqual;": "≏",
    "hybull;": "⁃",
    "hyphen;": "‐",
    "Iacute;": "Í",
    "Iacute": "Í",
    "iacute;": "í",
    "iacute": "í",
    "ic;": "⁣",
    "Icirc;": "Î",
    "Icirc": "Î",
    "icirc;": "î",
    "icirc": "î",
    "Icy;": "И",
    "icy;": "и",
    "Idot;": "İ",
    "IEcy;": "Е",
    "iecy;": "е",
    "iexcl;": "¡",
    "iexcl": "¡",
    "iff;": "⇔",
    "Ifr;": "ℑ",
    "ifr;": "𝔦",
    "Igrave;": "Ì",
    "Igrave": "Ì",
    "igrave;": "ì",
    "igrave": "ì",
    "ii;": "ⅈ",
    "iiiint;": "⨌",
    "iiint;": "∭",
    "iinfin;": "⧜",
    "iiota;": "℩",
    "IJlig;": "Ĳ",
    "ijlig;": "ĳ",
    "Im;": "ℑ",
    "Imacr;": "Ī",
    "imacr;": "ī",
    "image;": "ℑ",
    "ImaginaryI;": "ⅈ",
    "imagline;": "ℐ",
    "imagpart;": "ℑ",
    "imath;": "ı",
    "imof;": "⊷",
    "imped;": "Ƶ",
    "Implies;": "⇒",
    "in;": "∈",
    "incare;": "℅",
    "infin;": "∞",
    "infintie;": "⧝",
    "inodot;": "ı",
    "Int;": "∬",
    "int;": "∫",
    "intcal;": "⊺",
    "integers;": "ℤ",
    "Integral;": "∫",
    "intercal;": "⊺",
    "Intersection;": "⋂",
    "intlarhk;": "⨗",
    "intprod;": "⨼",
    "InvisibleComma;": "⁣",
    "InvisibleTimes;": "⁢",
    "IOcy;": "Ё",
    "iocy;": "ё",
    "Iogon;": "Į",
    "iogon;": "į",
    "Iopf;": "𝕀",
    "iopf;": "𝕚",
    "Iota;": "Ι",
    "iota;": "ι",
    "iprod;": "⨼",
    "iquest;": "¿",
    "iquest": "¿",
    "Iscr;": "ℐ",
    "iscr;": "𝒾",
    "isin;": "∈",
    "isindot;": "⋵",
    "isinE;": "⋹",
    "isins;": "⋴",
    "isinsv;": "⋳",
    "isinv;": "∈",
    "it;": "⁢",
    "Itilde;": "Ĩ",
    "itilde;": "ĩ",
    "Iukcy;": "І",
    "iukcy;": "і",
    "Iuml;": "Ï",
    "Iuml": "Ï",
    "iuml;": "ï",
    "iuml": "ï",
    "Jcirc;": "Ĵ",
    "jcirc;": "ĵ",
    "Jcy;": "Й",
    "jcy;": "й",
    "Jfr;": "𝔍",
    "jfr;": "𝔧",
    "jmath;": "ȷ",
    "Jopf;": "𝕁",
    "jopf;": "𝕛",
    "Jscr;": "𝒥",
    "jscr;": "𝒿",
    "Jsercy;": "Ј",
    "jsercy;": "ј",
    "Jukcy;": "Є",
    "jukcy;": "є",
    "Kappa;": "Κ",
    "kappa;": "κ",
    "kappav;": "ϰ",
    "Kcedil;": "Ķ",
    "kcedil;": "ķ",
    "Kcy;": "К",
    "kcy;": "к",
    "Kfr;": "𝔎",
    "kfr;": "𝔨",
    "kgreen;": "ĸ",
    "KHcy;": "Х",
    "khcy;": "х",
    "KJcy;": "Ќ",
    "kjcy;": "ќ",
    "Kopf;": "𝕂",
    "kopf;": "𝕜",
    "Kscr;": "𝒦",
    "kscr;": "𝓀",
    "lAarr;": "⇚",
    "Lacute;": "Ĺ",
    "lacute;": "ĺ",
    "laemptyv;": "⦴",
    "lagran;": "ℒ",
    "Lambda;": "Λ",
    "lambda;": "λ",
    "Lang;": "⟪",
    "lang;": "⟨",
    "langd;": "⦑",
    "langle;": "⟨",
    "lap;": "⪅",
    "Laplacetrf;": "ℒ",
    "laquo;": "«",
    "laquo": "«",
    "Larr;": "↞",
    "lArr;": "⇐",
    "larr;": "←",
    "larrb;": "⇤",
    "larrbfs;": "⤟",
    "larrfs;": "⤝",
    "larrhk;": "↩",
    "larrlp;": "↫",
    "larrpl;": "⤹",
    "larrsim;": "⥳",
    "larrtl;": "↢",
    "lat;": "⪫",
    "lAtail;": "⤛",
    "latail;": "⤙",
    "late;": "⪭",
    "lates;": "⪭︀",
    "lBarr;": "⤎",
    "lbarr;": "⤌",
    "lbbrk;": "❲",
    "lbrace;": "{",
    "lbrack;": "[",
    "lbrke;": "⦋",
    "lbrksld;": "⦏",
    "lbrkslu;": "⦍",
    "Lcaron;": "Ľ",
    "lcaron;": "ľ",
    "Lcedil;": "Ļ",
    "lcedil;": "ļ",
    "lceil;": "⌈",
    "lcub;": "{",
    "Lcy;": "Л",
    "lcy;": "л",
    "ldca;": "⤶",
    "ldquo;": "“",
    "ldquor;": "„",
    "ldrdhar;": "⥧",
    "ldrushar;": "⥋",
    "ldsh;": "↲",
    "lE;": "≦",
    "le;": "≤",
    "LeftAngleBracket;": "⟨",
    "LeftArrow;": "←",
    "Leftarrow;": "⇐",
    "leftarrow;": "←",
    "LeftArrowBar;": "⇤",
    "LeftArrowRightArrow;": "⇆",
    "leftarrowtail;": "↢",
    "LeftCeiling;": "⌈",
    "LeftDoubleBracket;": "⟦",
    "LeftDownTeeVector;": "⥡",
    "LeftDownVector;": "⇃",
    "LeftDownVectorBar;": "⥙",
    "LeftFloor;": "⌊",
    "leftharpoondown;": "↽",
    "leftharpoonup;": "↼",
    "leftleftarrows;": "⇇",
    "LeftRightArrow;": "↔",
    "Leftrightarrow;": "⇔",
    "leftrightarrow;": "↔",
    "leftrightarrows;": "⇆",
    "leftrightharpoons;": "⇋",
    "leftrightsquigarrow;": "↭",
    "LeftRightVector;": "⥎",
    "LeftTee;": "⊣",
    "LeftTeeArrow;": "↤",
    "LeftTeeVector;": "⥚",
    "leftthreetimes;": "⋋",
    "LeftTriangle;": "⊲",
    "LeftTriangleBar;": "⧏",
    "LeftTriangleEqual;": "⊴",
    "LeftUpDownVector;": "⥑",
    "LeftUpTeeVector;": "⥠",
    "LeftUpVector;": "↿",
    "LeftUpVectorBar;": "⥘",
    "LeftVector;": "↼",
    "LeftVectorBar;": "⥒",
    "lEg;": "⪋",
    "leg;": "⋚",
    "leq;": "≤",
    "leqq;": "≦",
    "leqslant;": "⩽",
    "les;": "⩽",
    "lescc;": "⪨",
    "lesdot;": "⩿",
    "lesdoto;": "⪁",
    "lesdotor;": "⪃",
    "lesg;": "⋚︀",
    "lesges;": "⪓",
    "lessapprox;": "⪅",
    "lessdot;": "⋖",
    "lesseqgtr;": "⋚",
    "lesseqqgtr;": "⪋",
    "LessEqualGreater;": "⋚",
    "LessFullEqual;": "≦",
    "LessGreater;": "≶",
    "lessgtr;": "≶",
    "LessLess;": "⪡",
    "lesssim;": "≲",
    "LessSlantEqual;": "⩽",
    "LessTilde;": "≲",
    "lfisht;": "⥼",
    "lfloor;": "⌊",
    "Lfr;": "𝔏",
    "lfr;": "𝔩",
    "lg;": "≶",
    "lgE;": "⪑",
    "lHar;": "⥢",
    "lhard;": "↽",
    "lharu;": "↼",
    "lharul;": "⥪",
    "lhblk;": "▄",
    "LJcy;": "Љ",
    "ljcy;": "љ",
    "Ll;": "⋘",
    "ll;": "≪",
    "llarr;": "⇇",
    "llcorner;": "⌞",
    "Lleftarrow;": "⇚",
    "llhard;": "⥫",
    "lltri;": "◺",
    "Lmidot;": "Ŀ",
    "lmidot;": "ŀ",
    "lmoust;": "⎰",
    "lmoustache;": "⎰",
    "lnap;": "⪉",
    "lnapprox;": "⪉",
    "lnE;": "≨",
    "lne;": "⪇",
    "lneq;": "⪇",
    "lneqq;": "≨",
    "lnsim;": "⋦",
    "loang;": "⟬",
    "loarr;": "⇽",
    "lobrk;": "⟦",
    "LongLeftArrow;": "⟵",
    "Longleftarrow;": "⟸",
    "longleftarrow;": "⟵",
    "LongLeftRightArrow;": "⟷",
    "Longleftrightarrow;": "⟺",
    "longleftrightarrow;": "⟷",
    "longmapsto;": "⟼",
    "LongRightArrow;": "⟶",
    "Longrightarrow;": "⟹",
    "longrightarrow;": "⟶",
    "looparrowleft;": "↫",
    "looparrowright;": "↬",
    "lopar;": "⦅",
    "Lopf;": "𝕃",
    "lopf;": "𝕝",
    "loplus;": "⨭",
    "lotimes;": "⨴",
    "lowast;": "∗",
    "lowbar;": "_",
    "LowerLeftArrow;": "↙",
    "LowerRightArrow;": "↘",
    "loz;": "◊",
    "lozenge;": "◊",
    "lozf;": "⧫",
    "lpar;": "(",
    "lparlt;": "⦓",
    "lrarr;": "⇆",
    "lrcorner;": "⌟",
    "lrhar;": "⇋",
    "lrhard;": "⥭",
    "lrm;": "‎",
    "lrtri;": "⊿",
    "lsaquo;": "‹",
    "Lscr;": "ℒ",
    "lscr;": "𝓁",
    "Lsh;": "↰",
    "lsh;": "↰",
    "lsim;": "≲",
    "lsime;": "⪍",
    "lsimg;": "⪏",
    "lsqb;": "[",
    "lsquo;": "‘",
    "lsquor;": "‚",
    "Lstrok;": "Ł",
    "lstrok;": "ł",
    "LT;": "<",
    "LT": "<",
    "Lt;": "≪",
    "lt;": "<",
    "lt": "<",
    "ltcc;": "⪦",
    "ltcir;": "⩹",
    "ltdot;": "⋖",
    "lthree;": "⋋",
    "ltimes;": "⋉",
    "ltlarr;": "⥶",
    "ltquest;": "⩻",
    "ltri;": "◃",
    "ltrie;": "⊴",
    "ltrif;": "◂",
    "ltrPar;": "⦖",
    "lurdshar;": "⥊",
    "luruhar;": "⥦",
    "lvertneqq;": "≨︀",
    "lvnE;": "≨︀",
    "macr;": "¯",
    "macr": "¯",
    "male;": "♂",
    "malt;": "✠",
    "maltese;": "✠",
    "Map;": "⤅",
    "map;": "↦",
    "mapsto;": "↦",
    "mapstodown;": "↧",
    "mapstoleft;": "↤",
    "mapstoup;": "↥",
    "marker;": "▮",
    "mcomma;": "⨩",
    "Mcy;": "М",
    "mcy;": "м",
    "mdash;": "—",
    "mDDot;": "∺",
    "measuredangle;": "∡",
    "MediumSpace;": " ",
    "Mellintrf;": "ℳ",
    "Mfr;": "𝔐",
    "mfr;": "𝔪",
    "mho;": "℧",
    "micro;": "µ",
    "micro": "µ",
    "mid;": "∣",
    "midast;": "*",
    "midcir;": "⫰",
    "middot;": "·",
    "middot": "·",
    "minus;": "−",
    "minusb;": "⊟",
    "minusd;": "∸",
    "minusdu;": "⨪",
    "MinusPlus;": "∓",
    "mlcp;": "⫛",
    "mldr;": "…",
    "mnplus;": "∓",
    "models;": "⊧",
    "Mopf;": "𝕄",
    "mopf;": "𝕞",
    "mp;": "∓",
    "Mscr;": "ℳ",
    "mscr;": "𝓂",
    "mstpos;": "∾",
    "Mu;": "Μ",
    "mu;": "μ",
    "multimap;": "⊸",
    "mumap;": "⊸",
    "nabla;": "∇",
    "Nacute;": "Ń",
    "nacute;": "ń",
    "nang;": "∠⃒",
    "nap;": "≉",
    "napE;": "⩰̸",
    "napid;": "≋̸",
    "napos;": "ŉ",
    "napprox;": "≉",
    "natur;": "♮",
    "natural;": "♮",
    "naturals;": "ℕ",
    "nbsp;": " ",
    "nbsp": " ",
    "nbump;": "≎̸",
    "nbumpe;": "≏̸",
    "ncap;": "⩃",
    "Ncaron;": "Ň",
    "ncaron;": "ň",
    "Ncedil;": "Ņ",
    "ncedil;": "ņ",
    "ncong;": "≇",
    "ncongdot;": "⩭̸",
    "ncup;": "⩂",
    "Ncy;": "Н",
    "ncy;": "н",
    "ndash;": "–",
    "ne;": "≠",
    "nearhk;": "⤤",
    "neArr;": "⇗",
    "nearr;": "↗",
    "nearrow;": "↗",
    "nedot;": "≐̸",
    "NegativeMediumSpace;": "​",
    "NegativeThickSpace;": "​",
    "NegativeThinSpace;": "​",
    "NegativeVeryThinSpace;": "​",
    "nequiv;": "≢",
    "nesear;": "⤨",
    "nesim;": "≂̸",
    "NestedGreaterGreater;": "≫",
    "NestedLessLess;": "≪",
    "NewLine;": "\n",
    "nexist;": "∄",
    "nexists;": "∄",
    "Nfr;": "𝔑",
    "nfr;": "𝔫",
    "ngE;": "≧̸",
    "nge;": "≱",
    "ngeq;": "≱",
    "ngeqq;": "≧̸",
    "ngeqslant;": "⩾̸",
    "nges;": "⩾̸",
    "nGg;": "⋙̸",
    "ngsim;": "≵",
    "nGt;": "≫⃒",
    "ngt;": "≯",
    "ngtr;": "≯",
    "nGtv;": "≫̸",
    "nhArr;": "⇎",
    "nharr;": "↮",
    "nhpar;": "⫲",
    "ni;": "∋",
    "nis;": "⋼",
    "nisd;": "⋺",
    "niv;": "∋",
    "NJcy;": "Њ",
    "njcy;": "њ",
    "nlArr;": "⇍",
    "nlarr;": "↚",
    "nldr;": "‥",
    "nlE;": "≦̸",
    "nle;": "≰",
    "nLeftarrow;": "⇍",
    "nleftarrow;": "↚",
    "nLeftrightarrow;": "⇎",
    "nleftrightarrow;": "↮",
    "nleq;": "≰",
    "nleqq;": "≦̸",
    "nleqslant;": "⩽̸",
    "nles;": "⩽̸",
    "nless;": "≮",
    "nLl;": "⋘̸",
    "nlsim;": "≴",
    "nLt;": "≪⃒",
    "nlt;": "≮",
    "nltri;": "⋪",
    "nltrie;": "⋬",
    "nLtv;": "≪̸",
    "nmid;": "∤",
    "NoBreak;": "⁠",
    "NonBreakingSpace;": " ",
    "Nopf;": "ℕ",
    "nopf;": "𝕟",
    "Not;": "⫬",
    "not;": "¬",
    "not": "¬",
    "NotCongruent;": "≢",
    "NotCupCap;": "≭",
    "NotDoubleVerticalBar;": "∦",
    "NotElement;": "∉",
    "NotEqual;": "≠",
    "NotEqualTilde;": "≂̸",
    "NotExists;": "∄",
    "NotGreater;": "≯",
    "NotGreaterEqual;": "≱",
    "NotGreaterFullEqual;": "≧̸",
    "NotGreaterGreater;": "≫̸",
    "NotGreaterLess;": "≹",
    "NotGreaterSlantEqual;": "⩾̸",
    "NotGreaterTilde;": "≵",
    "NotHumpDownHump;": "≎̸",
    "NotHumpEqual;": "≏̸",
    "notin;": "∉",
    "notindot;": "⋵̸",
    "notinE;": "⋹̸",
    "notinva;": "∉",
    "notinvb;": "⋷",
    "notinvc;": "⋶",
    "NotLeftTriangle;": "⋪",
    "NotLeftTriangleBar;": "⧏̸",
    "NotLeftTriangleEqual;": "⋬",
    "NotLess;": "≮",
    "NotLessEqual;": "≰",
    "NotLessGreater;": "≸",
    "NotLessLess;": "≪̸",
    "NotLessSlantEqual;": "⩽̸",
    "NotLessTilde;": "≴",
    "NotNestedGreaterGreater;": "⪢̸",
    "NotNestedLessLess;": "⪡̸",
    "notni;": "∌",
    "notniva;": "∌",
    "notnivb;": "⋾",
    "notnivc;": "⋽",
    "NotPrecedes;": "⊀",
    "NotPrecedesEqual;": "⪯̸",
    "NotPrecedesSlantEqual;": "⋠",
    "NotReverseElement;": "∌",
    "NotRightTriangle;": "⋫",
    "NotRightTriangleBar;": "⧐̸",
    "NotRightTriangleEqual;": "⋭",
    "NotSquareSubset;": "⊏̸",
    "NotSquareSubsetEqual;": "⋢",
    "NotSquareSuperset;": "⊐̸",
    "NotSquareSupersetEqual;": "⋣",
    "NotSubset;": "⊂⃒",
    "NotSubsetEqual;": "⊈",
    "NotSucceeds;": "⊁",
    "NotSucceedsEqual;": "⪰̸",
    "NotSucceedsSlantEqual;": "⋡",
    "NotSucceedsTilde;": "≿̸",
    "NotSuperset;": "⊃⃒",
    "NotSupersetEqual;": "⊉",
    "NotTilde;": "≁",
    "NotTildeEqual;": "≄",
    "NotTildeFullEqual;": "≇",
    "NotTildeTilde;": "≉",
    "NotVerticalBar;": "∤",
    "npar;": "∦",
    "nparallel;": "∦",
    "nparsl;": "⫽⃥",
    "npart;": "∂̸",
    "npolint;": "⨔",
    "npr;": "⊀",
    "nprcue;": "⋠",
    "npre;": "⪯̸",
    "nprec;": "⊀",
    "npreceq;": "⪯̸",
    "nrArr;": "⇏",
    "nrarr;": "↛",
    "nrarrc;": "⤳̸",
    "nrarrw;": "↝̸",
    "nRightarrow;": "⇏",
    "nrightarrow;": "↛",
    "nrtri;": "⋫",
    "nrtrie;": "⋭",
    "nsc;": "⊁",
    "nsccue;": "⋡",
    "nsce;": "⪰̸",
    "Nscr;": "𝒩",
    "nscr;": "𝓃",
    "nshortmid;": "∤",
    "nshortparallel;": "∦",
    "nsim;": "≁",
    "nsime;": "≄",
    "nsimeq;": "≄",
    "nsmid;": "∤",
    "nspar;": "∦",
    "nsqsube;": "⋢",
    "nsqsupe;": "⋣",
    "nsub;": "⊄",
    "nsubE;": "⫅̸",
    "nsube;": "⊈",
    "nsubset;": "⊂⃒",
    "nsubseteq;": "⊈",
    "nsubseteqq;": "⫅̸",
    "nsucc;": "⊁",
    "nsucceq;": "⪰̸",
    "nsup;": "⊅",
    "nsupE;": "⫆̸",
    "nsupe;": "⊉",
    "nsupset;": "⊃⃒",
    "nsupseteq;": "⊉",
    "nsupseteqq;": "⫆̸",
    "ntgl;": "≹",
    "Ntilde;": "Ñ",
    "Ntilde": "Ñ",
    "ntilde;": "ñ",
    "ntilde": "ñ",
    "ntlg;": "≸",
    "ntriangleleft;": "⋪",
    "ntrianglelefteq;": "⋬",
    "ntriangleright;": "⋫",
    "ntrianglerighteq;": "⋭",
    "Nu;": "Ν",
    "nu;": "ν",
    "num;": "#",
    "numero;": "№",
    "numsp;": " ",
    "nvap;": "≍⃒",
    "nVDash;": "⊯",
    "nVdash;": "⊮",
    "nvDash;": "⊭",
    "nvdash;": "⊬",
    "nvge;": "≥⃒",
    "nvgt;": ">⃒",
    "nvHarr;": "⤄",
    "nvinfin;": "⧞",
    "nvlArr;": "⤂",
    "nvle;": "≤⃒",
    "nvlt;": "<⃒",
    "nvltrie;": "⊴⃒",
    "nvrArr;": "⤃",
    "nvrtrie;": "⊵⃒",
    "nvsim;": "∼⃒",
    "nwarhk;": "⤣",
    "nwArr;": "⇖",
    "nwarr;": "↖",
    "nwarrow;": "↖",
    "nwnear;": "⤧",
    "Oacute;": "Ó",
    "Oacute": "Ó",
    "oacute;": "ó",
    "oacute": "ó",
    "oast;": "⊛",
    "ocir;": "⊚",
    "Ocirc;": "Ô",
    "Ocirc": "Ô",
    "ocirc;": "ô",
    "ocirc": "ô",
    "Ocy;": "О",
    "ocy;": "о",
    "odash;": "⊝",
    "Odblac;": "Ő",
    "odblac;": "ő",
    "odiv;": "⨸",
    "odot;": "⊙",
    "odsold;": "⦼",
    "OElig;": "Œ",
    "oelig;": "œ",
    "ofcir;": "⦿",
    "Ofr;": "𝔒",
    "ofr;": "𝔬",
    "ogon;": "˛",
    "Ograve;": "Ò",
    "Ograve": "Ò",
    "ograve;": "ò",
    "ograve": "ò",
    "ogt;": "⧁",
    "ohbar;": "⦵",
    "ohm;": "Ω",
    "oint;": "∮",
    "olarr;": "↺",
    "olcir;": "⦾",
    "olcross;": "⦻",
    "oline;": "‾",
    "olt;": "⧀",
    "Omacr;": "Ō",
    "omacr;": "ō",
    "Omega;": "Ω",
    "omega;": "ω",
    "Omicron;": "Ο",
    "omicron;": "ο",
    "omid;": "⦶",
    "ominus;": "⊖",
    "Oopf;": "𝕆",
    "oopf;": "𝕠",
    "opar;": "⦷",
    "OpenCurlyDoubleQuote;": "“",
    "OpenCurlyQuote;": "‘",
    "operp;": "⦹",
    "oplus;": "⊕",
    "Or;": "⩔",
    "or;": "∨",
    "orarr;": "↻",
    "ord;": "⩝",
    "order;": "ℴ",
    "orderof;": "ℴ",
    "ordf;": "ª",
    "ordf": "ª",
    "ordm;": "º",
    "ordm": "º",
    "origof;": "⊶",
    "oror;": "⩖",
    "orslope;": "⩗",
    "orv;": "⩛",
    "oS;": "Ⓢ",
    "Oscr;": "𝒪",
    "oscr;": "ℴ",
    "Oslash;": "Ø",
    "Oslash": "Ø",
    "oslash;": "ø",
    "oslash": "ø",
    "osol;": "⊘",
    "Otilde;": "Õ",
    "Otilde": "Õ",
    "otilde;": "õ",
    "otilde": "õ",
    "Otimes;": "⨷",
    "otimes;": "⊗",
    "otimesas;": "⨶",
    "Ouml;": "Ö",
    "Ouml": "Ö",
    "ouml;": "ö",
    "ouml": "ö",
    "ovbar;": "⌽",
    "OverBar;": "‾",
    "OverBrace;": "⏞",
    "OverBracket;": "⎴",
    "OverParenthesis;": "⏜",
    "par;": "∥",
    "para;": "¶",
    "para": "¶",
    "parallel;": "∥",
    "parsim;": "⫳",
    "parsl;": "⫽",
    "part;": "∂",
    "PartialD;": "∂",
    "Pcy;": "П",
    "pcy;": "п",
    "percnt;": "%",
    "period;": ".",
    "permil;": "‰",
    "perp;": "⊥",
    "pertenk;": "‱",
    "Pfr;": "𝔓",
    "pfr;": "𝔭",
    "Phi;": "Φ",
    "phi;": "φ",
    "phiv;": "ϕ",
    "phmmat;": "ℳ",
    "phone;": "☎",
    "Pi;": "Π",
    "pi;": "π",
    "pitchfork;": "⋔",
    "piv;": "ϖ",
    "planck;": "ℏ",
    "planckh;": "ℎ",
    "plankv;": "ℏ",
    "plus;": "+",
    "plusacir;": "⨣",
    "plusb;": "⊞",
    "pluscir;": "⨢",
    "plusdo;": "∔",
    "plusdu;": "⨥",
    "pluse;": "⩲",
    "PlusMinus;": "±",
    "plusmn;": "±",
    "plusmn": "±",
    "plussim;": "⨦",
    "plustwo;": "⨧",
    "pm;": "±",
    "Poincareplane;": "ℌ",
    "pointint;": "⨕",
    "Popf;": "ℙ",
    "popf;": "𝕡",
    "pound;": "£",
    "pound": "£",
    "Pr;": "⪻",
    "pr;": "≺",
    "prap;": "⪷",
    "prcue;": "≼",
    "prE;": "⪳",
    "pre;": "⪯",
    "prec;": "≺",
    "precapprox;": "⪷",
    "preccurlyeq;": "≼",
    "Precedes;": "≺",
    "PrecedesEqual;": "⪯",
    "PrecedesSlantEqual;": "≼",
    "PrecedesTilde;": "≾",
    "preceq;": "⪯",
    "precnapprox;": "⪹",
    "precneqq;": "⪵",
    "precnsim;": "⋨",
    "precsim;": "≾",
    "Prime;": "″",
    "prime;": "′",
    "primes;": "ℙ",
    "prnap;": "⪹",
    "prnE;": "⪵",
    "prnsim;": "⋨",
    "prod;": "∏",
    "Product;": "∏",
    "profalar;": "⌮",
    "profline;": "⌒",
    "profsurf;": "⌓",
    "prop;": "∝",
    "Proportion;": "∷",
    "Proportional;": "∝",
    "propto;": "∝",
    "prsim;": "≾",
    "prurel;": "⊰",
    "Pscr;": "𝒫",
    "pscr;": "𝓅",
    "Psi;": "Ψ",
    "psi;": "ψ",
    "puncsp;": " ",
    "Qfr;": "𝔔",
    "qfr;": "𝔮",
    "qint;": "⨌",
    "Qopf;": "ℚ",
    "qopf;": "𝕢",
    "qprime;": "⁗",
    "Qscr;": "𝒬",
    "qscr;": "𝓆",
    "quaternions;": "ℍ",
    "quatint;": "⨖",
    "quest;": "?",
    "questeq;": "≟",
    "QUOT;": '"',
    "QUOT": '"',
    "quot;": '"',
    "quot": '"',
    "rAarr;": "⇛",
    "race;": "∽̱",
    "Racute;": "Ŕ",
    "racute;": "ŕ",
    "radic;": "√",
    "raemptyv;": "⦳",
    "Rang;": "⟫",
    "rang;": "⟩",
    "rangd;": "⦒",
    "range;": "⦥",
    "rangle;": "⟩",
    "raquo;": "»",
    "raquo": "»",
    "Rarr;": "↠",
    "rArr;": "⇒",
    "rarr;": "→",
    "rarrap;": "⥵",
    "rarrb;": "⇥",
    "rarrbfs;": "⤠",
    "rarrc;": "⤳",
    "rarrfs;": "⤞",
    "rarrhk;": "↪",
    "rarrlp;": "↬",
    "rarrpl;": "⥅",
    "rarrsim;": "⥴",
    "Rarrtl;": "⤖",
    "rarrtl;": "↣",
    "rarrw;": "↝",
    "rAtail;": "⤜",
    "ratail;": "⤚",
    "ratio;": "∶",
    "rationals;": "ℚ",
    "RBarr;": "⤐",
    "rBarr;": "⤏",
    "rbarr;": "⤍",
    "rbbrk;": "❳",
    "rbrace;": "}",
    "rbrack;": "]",
    "rbrke;": "⦌",
    "rbrksld;": "⦎",
    "rbrkslu;": "⦐",
    "Rcaron;": "Ř",
    "rcaron;": "ř",
    "Rcedil;": "Ŗ",
    "rcedil;": "ŗ",
    "rceil;": "⌉",
    "rcub;": "}",
    "Rcy;": "Р",
    "rcy;": "р",
    "rdca;": "⤷",
    "rdldhar;": "⥩",
    "rdquo;": "”",
    "rdquor;": "”",
    "rdsh;": "↳",
    "Re;": "ℜ",
    "real;": "ℜ",
    "realine;": "ℛ",
    "realpart;": "ℜ",
    "reals;": "ℝ",
    "rect;": "▭",
    "REG;": "®",
    "REG": "®",
    "reg;": "®",
    "reg": "®",
    "ReverseElement;": "∋",
    "ReverseEquilibrium;": "⇋",
    "ReverseUpEquilibrium;": "⥯",
    "rfisht;": "⥽",
    "rfloor;": "⌋",
    "Rfr;": "ℜ",
    "rfr;": "𝔯",
    "rHar;": "⥤",
    "rhard;": "⇁",
    "rharu;": "⇀",
    "rharul;": "⥬",
    "Rho;": "Ρ",
    "rho;": "ρ",
    "rhov;": "ϱ",
    "RightAngleBracket;": "⟩",
    "RightArrow;": "→",
    "Rightarrow;": "⇒",
    "rightarrow;": "→",
    "RightArrowBar;": "⇥",
    "RightArrowLeftArrow;": "⇄",
    "rightarrowtail;": "↣",
    "RightCeiling;": "⌉",
    "RightDoubleBracket;": "⟧",
    "RightDownTeeVector;": "⥝",
    "RightDownVector;": "⇂",
    "RightDownVectorBar;": "⥕",
    "RightFloor;": "⌋",
    "rightharpoondown;": "⇁",
    "rightharpoonup;": "⇀",
    "rightleftarrows;": "⇄",
    "rightleftharpoons;": "⇌",
    "rightrightarrows;": "⇉",
    "rightsquigarrow;": "↝",
    "RightTee;": "⊢",
    "RightTeeArrow;": "↦",
    "RightTeeVector;": "⥛",
    "rightthreetimes;": "⋌",
    "RightTriangle;": "⊳",
    "RightTriangleBar;": "⧐",
    "RightTriangleEqual;": "⊵",
    "RightUpDownVector;": "⥏",
    "RightUpTeeVector;": "⥜",
    "RightUpVector;": "↾",
    "RightUpVectorBar;": "⥔",
    "RightVector;": "⇀",
    "RightVectorBar;": "⥓",
    "ring;": "˚",
    "risingdotseq;": "≓",
    "rlarr;": "⇄",
    "rlhar;": "⇌",
    "rlm;": "‏",
    "rmoust;": "⎱",
    "rmoustache;": "⎱",
    "rnmid;": "⫮",
    "roang;": "⟭",
    "roarr;": "⇾",
    "robrk;": "⟧",
    "ropar;": "⦆",
    "Ropf;": "ℝ",
    "ropf;": "𝕣",
    "roplus;": "⨮",
    "rotimes;": "⨵",
    "RoundImplies;": "⥰",
    "rpar;": ")",
    "rpargt;": "⦔",
    "rppolint;": "⨒",
    "rrarr;": "⇉",
    "Rrightarrow;": "⇛",
    "rsaquo;": "›",
    "Rscr;": "ℛ",
    "rscr;": "𝓇",
    "Rsh;": "↱",
    "rsh;": "↱",
    "rsqb;": "]",
    "rsquo;": "’",
    "rsquor;": "’",
    "rthree;": "⋌",
    "rtimes;": "⋊",
    "rtri;": "▹",
    "rtrie;": "⊵",
    "rtrif;": "▸",
    "rtriltri;": "⧎",
    "RuleDelayed;": "⧴",
    "ruluhar;": "⥨",
    "rx;": "℞",
    "Sacute;": "Ś",
    "sacute;": "ś",
    "sbquo;": "‚",
    "Sc;": "⪼",
    "sc;": "≻",
    "scap;": "⪸",
    "Scaron;": "Š",
    "scaron;": "š",
    "sccue;": "≽",
    "scE;": "⪴",
    "sce;": "⪰",
    "Scedil;": "Ş",
    "scedil;": "ş",
    "Scirc;": "Ŝ",
    "scirc;": "ŝ",
    "scnap;": "⪺",
    "scnE;": "⪶",
    "scnsim;": "⋩",
    "scpolint;": "⨓",
    "scsim;": "≿",
    "Scy;": "С",
    "scy;": "с",
    "sdot;": "⋅",
    "sdotb;": "⊡",
    "sdote;": "⩦",
    "searhk;": "⤥",
    "seArr;": "⇘",
    "searr;": "↘",
    "searrow;": "↘",
    "sect;": "§",
    "sect": "§",
    "semi;": ";",
    "seswar;": "⤩",
    "setminus;": "∖",
    "setmn;": "∖",
    "sext;": "✶",
    "Sfr;": "𝔖",
    "sfr;": "𝔰",
    "sfrown;": "⌢",
    "sharp;": "♯",
    "SHCHcy;": "Щ",
    "shchcy;": "щ",
    "SHcy;": "Ш",
    "shcy;": "ш",
    "ShortDownArrow;": "↓",
    "ShortLeftArrow;": "←",
    "shortmid;": "∣",
    "shortparallel;": "∥",
    "ShortRightArrow;": "→",
    "ShortUpArrow;": "↑",
    "shy;": "­",
    "shy": "­",
    "Sigma;": "Σ",
    "sigma;": "σ",
    "sigmaf;": "ς",
    "sigmav;": "ς",
    "sim;": "∼",
    "simdot;": "⩪",
    "sime;": "≃",
    "simeq;": "≃",
    "simg;": "⪞",
    "simgE;": "⪠",
    "siml;": "⪝",
    "simlE;": "⪟",
    "simne;": "≆",
    "simplus;": "⨤",
    "simrarr;": "⥲",
    "slarr;": "←",
    "SmallCircle;": "∘",
    "smallsetminus;": "∖",
    "smashp;": "⨳",
    "smeparsl;": "⧤",
    "smid;": "∣",
    "smile;": "⌣",
    "smt;": "⪪",
    "smte;": "⪬",
    "smtes;": "⪬︀",
    "SOFTcy;": "Ь",
    "softcy;": "ь",
    "sol;": "/",
    "solb;": "⧄",
    "solbar;": "⌿",
    "Sopf;": "𝕊",
    "sopf;": "𝕤",
    "spades;": "♠",
    "spadesuit;": "♠",
    "spar;": "∥",
    "sqcap;": "⊓",
    "sqcaps;": "⊓︀",
    "sqcup;": "⊔",
    "sqcups;": "⊔︀",
    "Sqrt;": "√",
    "sqsub;": "⊏",
    "sqsube;": "⊑",
    "sqsubset;": "⊏",
    "sqsubseteq;": "⊑",
    "sqsup;": "⊐",
    "sqsupe;": "⊒",
    "sqsupset;": "⊐",
    "sqsupseteq;": "⊒",
    "squ;": "□",
    "Square;": "□",
    "square;": "□",
    "SquareIntersection;": "⊓",
    "SquareSubset;": "⊏",
    "SquareSubsetEqual;": "⊑",
    "SquareSuperset;": "⊐",
    "SquareSupersetEqual;": "⊒",
    "SquareUnion;": "⊔",
    "squarf;": "▪",
    "squf;": "▪",
    "srarr;": "→",
    "Sscr;": "𝒮",
    "sscr;": "𝓈",
    "ssetmn;": "∖",
    "ssmile;": "⌣",
    "sstarf;": "⋆",
    "Star;": "⋆",
    "star;": "☆",
    "starf;": "★",
    "straightepsilon;": "ϵ",
    "straightphi;": "ϕ",
    "strns;": "¯",
    "Sub;": "⋐",
    "sub;": "⊂",
    "subdot;": "⪽",
    "subE;": "⫅",
    "sube;": "⊆",
    "subedot;": "⫃",
    "submult;": "⫁",
    "subnE;": "⫋",
    "subne;": "⊊",
    "subplus;": "⪿",
    "subrarr;": "⥹",
    "Subset;": "⋐",
    "subset;": "⊂",
    "subseteq;": "⊆",
    "subseteqq;": "⫅",
    "SubsetEqual;": "⊆",
    "subsetneq;": "⊊",
    "subsetneqq;": "⫋",
    "subsim;": "⫇",
    "subsub;": "⫕",
    "subsup;": "⫓",
    "succ;": "≻",
    "succapprox;": "⪸",
    "succcurlyeq;": "≽",
    "Succeeds;": "≻",
    "SucceedsEqual;": "⪰",
    "SucceedsSlantEqual;": "≽",
    "SucceedsTilde;": "≿",
    "succeq;": "⪰",
    "succnapprox;": "⪺",
    "succneqq;": "⪶",
    "succnsim;": "⋩",
    "succsim;": "≿",
    "SuchThat;": "∋",
    "Sum;": "∑",
    "sum;": "∑",
    "sung;": "♪",
    "Sup;": "⋑",
    "sup;": "⊃",
    "sup1;": "¹",
    "sup1": "¹",
    "sup2;": "²",
    "sup2": "²",
    "sup3;": "³",
    "sup3": "³",
    "supdot;": "⪾",
    "supdsub;": "⫘",
    "supE;": "⫆",
    "supe;": "⊇",
    "supedot;": "⫄",
    "Superset;": "⊃",
    "SupersetEqual;": "⊇",
    "suphsol;": "⟉",
    "suphsub;": "⫗",
    "suplarr;": "⥻",
    "supmult;": "⫂",
    "supnE;": "⫌",
    "supne;": "⊋",
    "supplus;": "⫀",
    "Supset;": "⋑",
    "supset;": "⊃",
    "supseteq;": "⊇",
    "supseteqq;": "⫆",
    "supsetneq;": "⊋",
    "supsetneqq;": "⫌",
    "supsim;": "⫈",
    "supsub;": "⫔",
    "supsup;": "⫖",
    "swarhk;": "⤦",
    "swArr;": "⇙",
    "swarr;": "↙",
    "swarrow;": "↙",
    "swnwar;": "⤪",
    "szlig;": "ß",
    "szlig": "ß",
    "Tab;": "	",
    "target;": "⌖",
    "Tau;": "Τ",
    "tau;": "τ",
    "tbrk;": "⎴",
    "Tcaron;": "Ť",
    "tcaron;": "ť",
    "Tcedil;": "Ţ",
    "tcedil;": "ţ",
    "Tcy;": "Т",
    "tcy;": "т",
    "tdot;": "⃛",
    "telrec;": "⌕",
    "Tfr;": "𝔗",
    "tfr;": "𝔱",
    "there4;": "∴",
    "Therefore;": "∴",
    "therefore;": "∴",
    "Theta;": "Θ",
    "theta;": "θ",
    "thetasym;": "ϑ",
    "thetav;": "ϑ",
    "thickapprox;": "≈",
    "thicksim;": "∼",
    "ThickSpace;": "  ",
    "thinsp;": " ",
    "ThinSpace;": " ",
    "thkap;": "≈",
    "thksim;": "∼",
    "THORN;": "Þ",
    "THORN": "Þ",
    "thorn;": "þ",
    "thorn": "þ",
    "Tilde;": "∼",
    "tilde;": "˜",
    "TildeEqual;": "≃",
    "TildeFullEqual;": "≅",
    "TildeTilde;": "≈",
    "times;": "×",
    "times": "×",
    "timesb;": "⊠",
    "timesbar;": "⨱",
    "timesd;": "⨰",
    "tint;": "∭",
    "toea;": "⤨",
    "top;": "⊤",
    "topbot;": "⌶",
    "topcir;": "⫱",
    "Topf;": "𝕋",
    "topf;": "𝕥",
    "topfork;": "⫚",
    "tosa;": "⤩",
    "tprime;": "‴",
    "TRADE;": "™",
    "trade;": "™",
    "triangle;": "▵",
    "triangledown;": "▿",
    "triangleleft;": "◃",
    "trianglelefteq;": "⊴",
    "triangleq;": "≜",
    "triangleright;": "▹",
    "trianglerighteq;": "⊵",
    "tridot;": "◬",
    "trie;": "≜",
    "triminus;": "⨺",
    "TripleDot;": "⃛",
    "triplus;": "⨹",
    "trisb;": "⧍",
    "tritime;": "⨻",
    "trpezium;": "⏢",
    "Tscr;": "𝒯",
    "tscr;": "𝓉",
    "TScy;": "Ц",
    "tscy;": "ц",
    "TSHcy;": "Ћ",
    "tshcy;": "ћ",
    "Tstrok;": "Ŧ",
    "tstrok;": "ŧ",
    "twixt;": "≬",
    "twoheadleftarrow;": "↞",
    "twoheadrightarrow;": "↠",
    "Uacute;": "Ú",
    "Uacute": "Ú",
    "uacute;": "ú",
    "uacute": "ú",
    "Uarr;": "↟",
    "uArr;": "⇑",
    "uarr;": "↑",
    "Uarrocir;": "⥉",
    "Ubrcy;": "Ў",
    "ubrcy;": "ў",
    "Ubreve;": "Ŭ",
    "ubreve;": "ŭ",
    "Ucirc;": "Û",
    "Ucirc": "Û",
    "ucirc;": "û",
    "ucirc": "û",
    "Ucy;": "У",
    "ucy;": "у",
    "udarr;": "⇅",
    "Udblac;": "Ű",
    "udblac;": "ű",
    "udhar;": "⥮",
    "ufisht;": "⥾",
    "Ufr;": "𝔘",
    "ufr;": "𝔲",
    "Ugrave;": "Ù",
    "Ugrave": "Ù",
    "ugrave;": "ù",
    "ugrave": "ù",
    "uHar;": "⥣",
    "uharl;": "↿",
    "uharr;": "↾",
    "uhblk;": "▀",
    "ulcorn;": "⌜",
    "ulcorner;": "⌜",
    "ulcrop;": "⌏",
    "ultri;": "◸",
    "Umacr;": "Ū",
    "umacr;": "ū",
    "uml;": "¨",
    "uml": "¨",
    "UnderBar;": "_",
    "UnderBrace;": "⏟",
    "UnderBracket;": "⎵",
    "UnderParenthesis;": "⏝",
    "Union;": "⋃",
    "UnionPlus;": "⊎",
    "Uogon;": "Ų",
    "uogon;": "ų",
    "Uopf;": "𝕌",
    "uopf;": "𝕦",
    "UpArrow;": "↑",
    "Uparrow;": "⇑",
    "uparrow;": "↑",
    "UpArrowBar;": "⤒",
    "UpArrowDownArrow;": "⇅",
    "UpDownArrow;": "↕",
    "Updownarrow;": "⇕",
    "updownarrow;": "↕",
    "UpEquilibrium;": "⥮",
    "upharpoonleft;": "↿",
    "upharpoonright;": "↾",
    "uplus;": "⊎",
    "UpperLeftArrow;": "↖",
    "UpperRightArrow;": "↗",
    "Upsi;": "ϒ",
    "upsi;": "υ",
    "upsih;": "ϒ",
    "Upsilon;": "Υ",
    "upsilon;": "υ",
    "UpTee;": "⊥",
    "UpTeeArrow;": "↥",
    "upuparrows;": "⇈",
    "urcorn;": "⌝",
    "urcorner;": "⌝",
    "urcrop;": "⌎",
    "Uring;": "Ů",
    "uring;": "ů",
    "urtri;": "◹",
    "Uscr;": "𝒰",
    "uscr;": "𝓊",
    "utdot;": "⋰",
    "Utilde;": "Ũ",
    "utilde;": "ũ",
    "utri;": "▵",
    "utrif;": "▴",
    "uuarr;": "⇈",
    "Uuml;": "Ü",
    "Uuml": "Ü",
    "uuml;": "ü",
    "uuml": "ü",
    "uwangle;": "⦧",
    "vangrt;": "⦜",
    "varepsilon;": "ϵ",
    "varkappa;": "ϰ",
    "varnothing;": "∅",
    "varphi;": "ϕ",
    "varpi;": "ϖ",
    "varpropto;": "∝",
    "vArr;": "⇕",
    "varr;": "↕",
    "varrho;": "ϱ",
    "varsigma;": "ς",
    "varsubsetneq;": "⊊︀",
    "varsubsetneqq;": "⫋︀",
    "varsupsetneq;": "⊋︀",
    "varsupsetneqq;": "⫌︀",
    "vartheta;": "ϑ",
    "vartriangleleft;": "⊲",
    "vartriangleright;": "⊳",
    "Vbar;": "⫫",
    "vBar;": "⫨",
    "vBarv;": "⫩",
    "Vcy;": "В",
    "vcy;": "в",
    "VDash;": "⊫",
    "Vdash;": "⊩",
    "vDash;": "⊨",
    "vdash;": "⊢",
    "Vdashl;": "⫦",
    "Vee;": "⋁",
    "vee;": "∨",
    "veebar;": "⊻",
    "veeeq;": "≚",
    "vellip;": "⋮",
    "Verbar;": "‖",
    "verbar;": "|",
    "Vert;": "‖",
    "vert;": "|",
    "VerticalBar;": "∣",
    "VerticalLine;": "|",
    "VerticalSeparator;": "❘",
    "VerticalTilde;": "≀",
    "VeryThinSpace;": " ",
    "Vfr;": "𝔙",
    "vfr;": "𝔳",
    "vltri;": "⊲",
    "vnsub;": "⊂⃒",
    "vnsup;": "⊃⃒",
    "Vopf;": "𝕍",
    "vopf;": "𝕧",
    "vprop;": "∝",
    "vrtri;": "⊳",
    "Vscr;": "𝒱",
    "vscr;": "𝓋",
    "vsubnE;": "⫋︀",
    "vsubne;": "⊊︀",
    "vsupnE;": "⫌︀",
    "vsupne;": "⊋︀",
    "Vvdash;": "⊪",
    "vzigzag;": "⦚",
    "Wcirc;": "Ŵ",
    "wcirc;": "ŵ",
    "wedbar;": "⩟",
    "Wedge;": "⋀",
    "wedge;": "∧",
    "wedgeq;": "≙",
    "weierp;": "℘",
    "Wfr;": "𝔚",
    "wfr;": "𝔴",
    "Wopf;": "𝕎",
    "wopf;": "𝕨",
    "wp;": "℘",
    "wr;": "≀",
    "wreath;": "≀",
    "Wscr;": "𝒲",
    "wscr;": "𝓌",
    "xcap;": "⋂",
    "xcirc;": "◯",
    "xcup;": "⋃",
    "xdtri;": "▽",
    "Xfr;": "𝔛",
    "xfr;": "𝔵",
    "xhArr;": "⟺",
    "xharr;": "⟷",
    "Xi;": "Ξ",
    "xi;": "ξ",
    "xlArr;": "⟸",
    "xlarr;": "⟵",
    "xmap;": "⟼",
    "xnis;": "⋻",
    "xodot;": "⨀",
    "Xopf;": "𝕏",
    "xopf;": "𝕩",
    "xoplus;": "⨁",
    "xotime;": "⨂",
    "xrArr;": "⟹",
    "xrarr;": "⟶",
    "Xscr;": "𝒳",
    "xscr;": "𝓍",
    "xsqcup;": "⨆",
    "xuplus;": "⨄",
    "xutri;": "△",
    "xvee;": "⋁",
    "xwedge;": "⋀",
    "Yacute;": "Ý",
    "Yacute": "Ý",
    "yacute;": "ý",
    "yacute": "ý",
    "YAcy;": "Я",
    "yacy;": "я",
    "Ycirc;": "Ŷ",
    "ycirc;": "ŷ",
    "Ycy;": "Ы",
    "ycy;": "ы",
    "yen;": "¥",
    "yen": "¥",
    "Yfr;": "𝔜",
    "yfr;": "𝔶",
    "YIcy;": "Ї",
    "yicy;": "ї",
    "Yopf;": "𝕐",
    "yopf;": "𝕪",
    "Yscr;": "𝒴",
    "yscr;": "𝓎",
    "YUcy;": "Ю",
    "yucy;": "ю",
    "Yuml;": "Ÿ",
    "yuml;": "ÿ",
    "yuml": "ÿ",
    "Zacute;": "Ź",
    "zacute;": "ź",
    "Zcaron;": "Ž",
    "zcaron;": "ž",
    "Zcy;": "З",
    "zcy;": "з",
    "Zdot;": "Ż",
    "zdot;": "ż",
    "zeetrf;": "ℨ",
    "ZeroWidthSpace;": "​",
    "Zeta;": "Ζ",
    "zeta;": "ζ",
    "Zfr;": "ℨ",
    "zfr;": "𝔷",
    "ZHcy;": "Ж",
    "zhcy;": "ж",
    "zigrarr;": "⇝",
    "Zopf;": "ℤ",
    "zopf;": "𝕫",
    "Zscr;": "𝒵",
    "zscr;": "𝓏",
    "zwj;": "‍",
    "zwnj;": "‌"
  };
  function startsWith(haystack, needle) {
    if (haystack.length < needle.length) {
      return false;
    }
    for (let i = 0; i < needle.length; i++) {
      if (haystack[i] !== needle[i]) {
        return false;
      }
    }
    return true;
  }
  function endsWith(haystack, needle) {
    const diff = haystack.length - needle.length;
    if (diff > 0) {
      return haystack.lastIndexOf(needle) === diff;
    } else if (diff === 0) {
      return haystack === needle;
    } else {
      return false;
    }
  }
  function repeat(value, count) {
    let s = "";
    while (count > 0) {
      if ((count & 1) === 1) {
        s += value;
      }
      value += value;
      count = count >>> 1;
    }
    return s;
  }
  const _a = "a".charCodeAt(0);
  const _z = "z".charCodeAt(0);
  const _A = "A".charCodeAt(0);
  const _Z = "Z".charCodeAt(0);
  const _0 = "0".charCodeAt(0);
  const _9 = "9".charCodeAt(0);
  function isLetterOrDigit(text, index) {
    const c = text.charCodeAt(index);
    return _a <= c && c <= _z || _A <= c && c <= _Z || _0 <= c && c <= _9;
  }
  function isDefined(obj) {
    return typeof obj !== "undefined";
  }
  function normalizeMarkupContent(input) {
    if (!input) {
      return void 0;
    }
    if (typeof input === "string") {
      return {
        kind: "markdown",
        value: input
      };
    }
    return {
      kind: "markdown",
      value: input.value
    };
  }
  class HTMLDataProvider {
    isApplicable() {
      return true;
    }
    /**
     * Currently, unversioned data uses the V1 implementation
     * In the future when the provider handles multiple versions of HTML custom data,
     * use the latest implementation for unversioned data
     */
    constructor(id, customData) {
      this.id = id;
      this._tags = [];
      this._tagMap = {};
      this._valueSetMap = {};
      this._tags = customData.tags || [];
      this._globalAttributes = customData.globalAttributes || [];
      this._tags.forEach((t2) => {
        this._tagMap[t2.name.toLowerCase()] = t2;
      });
      if (customData.valueSets) {
        customData.valueSets.forEach((vs) => {
          this._valueSetMap[vs.name] = vs.values;
        });
      }
    }
    getId() {
      return this.id;
    }
    provideTags() {
      return this._tags;
    }
    provideAttributes(tag) {
      const attributes = [];
      const processAttribute = (a) => {
        attributes.push(a);
      };
      const tagEntry = this._tagMap[tag.toLowerCase()];
      if (tagEntry) {
        tagEntry.attributes.forEach(processAttribute);
      }
      this._globalAttributes.forEach(processAttribute);
      return attributes;
    }
    provideValues(tag, attribute) {
      const values = [];
      attribute = attribute.toLowerCase();
      const processAttributes = (attributes) => {
        attributes.forEach((a) => {
          if (a.name.toLowerCase() === attribute) {
            if (a.values) {
              a.values.forEach((v) => {
                values.push(v);
              });
            }
            if (a.valueSet) {
              if (this._valueSetMap[a.valueSet]) {
                this._valueSetMap[a.valueSet].forEach((v) => {
                  values.push(v);
                });
              }
            }
          }
        });
      };
      const tagEntry = this._tagMap[tag.toLowerCase()];
      if (tagEntry) {
        processAttributes(tagEntry.attributes);
      }
      processAttributes(this._globalAttributes);
      return values;
    }
  }
  function generateDocumentation(item, settings = {}, doesSupportMarkdown) {
    const result = {
      kind: doesSupportMarkdown ? "markdown" : "plaintext",
      value: ""
    };
    if (item.description && settings.documentation !== false) {
      const normalizedDescription = normalizeMarkupContent(item.description);
      if (normalizedDescription) {
        result.value += normalizedDescription.value;
      }
    }
    if (item.references && item.references.length > 0 && settings.references !== false) {
      if (result.value.length) {
        result.value += `

`;
      }
      if (doesSupportMarkdown) {
        result.value += item.references.map((r) => {
          return `[${r.name}](${r.url})`;
        }).join(" | ");
      } else {
        result.value += item.references.map((r) => {
          return `${r.name}: ${r.url}`;
        }).join("\n");
      }
    }
    if (result.value === "") {
      return void 0;
    }
    return result;
  }
  class PathCompletionParticipant {
    constructor(dataManager, readDirectory) {
      this.dataManager = dataManager;
      this.readDirectory = readDirectory;
      this.atributeCompletions = [];
    }
    onHtmlAttributeValue(context) {
      if (this.dataManager.isPathAttribute(context.tag, context.attribute)) {
        this.atributeCompletions.push(context);
      }
    }
    async computeCompletions(document2, documentContext) {
      const result = { items: [], isIncomplete: false };
      for (const attributeCompletion of this.atributeCompletions) {
        const fullValue = stripQuotes(document2.getText(attributeCompletion.range));
        if (isCompletablePath(fullValue)) {
          if (fullValue === "." || fullValue === "..") {
            result.isIncomplete = true;
          } else {
            const replaceRange = pathToReplaceRange(attributeCompletion.value, fullValue, attributeCompletion.range);
            const suggestions = await this.providePathSuggestions(attributeCompletion.value, replaceRange, document2, documentContext);
            for (const item of suggestions) {
              result.items.push(item);
            }
          }
        }
      }
      return result;
    }
    async providePathSuggestions(valueBeforeCursor, replaceRange, document2, documentContext) {
      const valueBeforeLastSlash = valueBeforeCursor.substring(0, valueBeforeCursor.lastIndexOf("/") + 1);
      let parentDir = documentContext.resolveReference(valueBeforeLastSlash || ".", document2.uri);
      if (parentDir) {
        try {
          const result = [];
          const infos = await this.readDirectory(parentDir);
          for (const [name, type] of infos) {
            if (name.charCodeAt(0) !== CharCode_dot) {
              result.push(createCompletionItem(name, type === FileType.Directory, replaceRange));
            }
          }
          return result;
        } catch (e) {
        }
      }
      return [];
    }
  }
  const CharCode_dot = ".".charCodeAt(0);
  function stripQuotes(fullValue) {
    if (startsWith(fullValue, `'`) || startsWith(fullValue, `"`)) {
      return fullValue.slice(1, -1);
    } else {
      return fullValue;
    }
  }
  function isCompletablePath(value) {
    if (startsWith(value, "http") || startsWith(value, "https") || startsWith(value, "//")) {
      return false;
    }
    return true;
  }
  function pathToReplaceRange(valueBeforeCursor, fullValue, range) {
    let replaceRange;
    const lastIndexOfSlash = valueBeforeCursor.lastIndexOf("/");
    if (lastIndexOfSlash === -1) {
      replaceRange = shiftRange(range, 1, -1);
    } else {
      const valueAfterLastSlash = fullValue.slice(lastIndexOfSlash + 1);
      const startPos = shiftPosition(range.end, -1 - valueAfterLastSlash.length);
      const whitespaceIndex = valueAfterLastSlash.indexOf(" ");
      let endPos;
      if (whitespaceIndex !== -1) {
        endPos = shiftPosition(startPos, whitespaceIndex);
      } else {
        endPos = shiftPosition(range.end, -1);
      }
      replaceRange = Range.create(startPos, endPos);
    }
    return replaceRange;
  }
  function createCompletionItem(p, isDir, replaceRange) {
    if (isDir) {
      p = p + "/";
      return {
        label: p,
        kind: CompletionItemKind.Folder,
        textEdit: TextEdit.replace(replaceRange, p),
        command: {
          title: "Suggest",
          command: "editor.action.triggerSuggest"
        }
      };
    } else {
      return {
        label: p,
        kind: CompletionItemKind.File,
        textEdit: TextEdit.replace(replaceRange, p)
      };
    }
  }
  function shiftPosition(pos, offset) {
    return Position.create(pos.line, pos.character + offset);
  }
  function shiftRange(range, startOffset, endOffset) {
    const start2 = shiftPosition(range.start, startOffset);
    const end = shiftPosition(range.end, endOffset);
    return Range.create(start2, end);
  }
  class HTMLCompletion {
    constructor(lsOptions, dataManager) {
      this.lsOptions = lsOptions;
      this.dataManager = dataManager;
      this.completionParticipants = [];
    }
    setCompletionParticipants(registeredCompletionParticipants) {
      this.completionParticipants = registeredCompletionParticipants || [];
    }
    async doComplete2(document2, position, htmlDocument, documentContext, settings) {
      if (!this.lsOptions.fileSystemProvider || !this.lsOptions.fileSystemProvider.readDirectory) {
        return this.doComplete(document2, position, htmlDocument, settings);
      }
      const participant = new PathCompletionParticipant(this.dataManager, this.lsOptions.fileSystemProvider.readDirectory);
      const contributedParticipants = this.completionParticipants;
      this.completionParticipants = [participant].concat(contributedParticipants);
      const result = this.doComplete(document2, position, htmlDocument, settings);
      try {
        const pathCompletionResult = await participant.computeCompletions(document2, documentContext);
        return {
          isIncomplete: result.isIncomplete || pathCompletionResult.isIncomplete,
          items: pathCompletionResult.items.concat(result.items)
        };
      } finally {
        this.completionParticipants = contributedParticipants;
      }
    }
    doComplete(document2, position, htmlDocument, settings) {
      const result = this._doComplete(document2, position, htmlDocument, settings);
      return this.convertCompletionList(result);
    }
    _doComplete(document2, position, htmlDocument, settings) {
      const result = {
        isIncomplete: false,
        items: []
      };
      const completionParticipants = this.completionParticipants;
      const dataProviders = this.dataManager.getDataProviders().filter((p) => p.isApplicable(document2.languageId) && (!settings || settings[p.getId()] !== false));
      const voidElements = this.dataManager.getVoidElements(dataProviders);
      const doesSupportMarkdown = this.doesSupportMarkdown();
      const text = document2.getText();
      const offset = document2.offsetAt(position);
      const node = htmlDocument.findNodeBefore(offset);
      if (!node) {
        return result;
      }
      const scanner = createScanner(text, node.start);
      let currentTag = "";
      let currentAttributeName;
      function getReplaceRange(replaceStart, replaceEnd = offset) {
        if (replaceStart > offset) {
          replaceStart = offset;
        }
        return { start: document2.positionAt(replaceStart), end: document2.positionAt(replaceEnd) };
      }
      function collectOpenTagSuggestions(afterOpenBracket, tagNameEnd) {
        const range = getReplaceRange(afterOpenBracket, tagNameEnd);
        dataProviders.forEach((provider) => {
          provider.provideTags().forEach((tag) => {
            result.items.push({
              label: tag.name,
              kind: CompletionItemKind.Property,
              documentation: generateDocumentation(tag, void 0, doesSupportMarkdown),
              textEdit: TextEdit.replace(range, tag.name),
              insertTextFormat: InsertTextFormat.PlainText
            });
          });
        });
        return result;
      }
      function getLineIndent(offset2) {
        let start2 = offset2;
        while (start2 > 0) {
          const ch = text.charAt(start2 - 1);
          if ("\n\r".indexOf(ch) >= 0) {
            return text.substring(start2, offset2);
          }
          if (!isWhiteSpace(ch)) {
            return null;
          }
          start2--;
        }
        return text.substring(0, offset2);
      }
      function collectCloseTagSuggestions(afterOpenBracket, inOpenTag, tagNameEnd = offset) {
        const range = getReplaceRange(afterOpenBracket, tagNameEnd);
        const closeTag = isFollowedBy(text, tagNameEnd, ScannerState.WithinEndTag, TokenType.EndTagClose) ? "" : ">";
        let curr = node;
        if (inOpenTag) {
          curr = curr.parent;
        }
        while (curr) {
          const tag = curr.tag;
          if (tag && (!curr.closed || curr.endTagStart && curr.endTagStart > offset)) {
            const item = {
              label: "/" + tag,
              kind: CompletionItemKind.Property,
              filterText: "/" + tag,
              textEdit: TextEdit.replace(range, "/" + tag + closeTag),
              insertTextFormat: InsertTextFormat.PlainText
            };
            const startIndent = getLineIndent(curr.start);
            const endIndent = getLineIndent(afterOpenBracket - 1);
            if (startIndent !== null && endIndent !== null && startIndent !== endIndent) {
              const insertText = startIndent + "</" + tag + closeTag;
              item.textEdit = TextEdit.replace(getReplaceRange(afterOpenBracket - 1 - endIndent.length), insertText);
              item.filterText = endIndent + "</" + tag;
            }
            result.items.push(item);
            return result;
          }
          curr = curr.parent;
        }
        if (inOpenTag) {
          return result;
        }
        dataProviders.forEach((provider) => {
          provider.provideTags().forEach((tag) => {
            result.items.push({
              label: "/" + tag.name,
              kind: CompletionItemKind.Property,
              documentation: generateDocumentation(tag, void 0, doesSupportMarkdown),
              filterText: "/" + tag.name + closeTag,
              textEdit: TextEdit.replace(range, "/" + tag.name + closeTag),
              insertTextFormat: InsertTextFormat.PlainText
            });
          });
        });
        return result;
      }
      const collectAutoCloseTagSuggestion = (tagCloseEnd, tag) => {
        if (settings && settings.hideAutoCompleteProposals) {
          return result;
        }
        if (!this.dataManager.isVoidElement(tag, voidElements)) {
          const pos = document2.positionAt(tagCloseEnd);
          result.items.push({
            label: "</" + tag + ">",
            kind: CompletionItemKind.Property,
            filterText: "</" + tag + ">",
            textEdit: TextEdit.insert(pos, "$0</" + tag + ">"),
            insertTextFormat: InsertTextFormat.Snippet
          });
        }
        return result;
      };
      function collectTagSuggestions(tagStart, tagEnd) {
        collectOpenTagSuggestions(tagStart, tagEnd);
        collectCloseTagSuggestions(tagStart, true, tagEnd);
        return result;
      }
      function getExistingAttributes() {
        const existingAttributes = /* @__PURE__ */ Object.create(null);
        node.attributeNames.forEach((attribute) => {
          existingAttributes[attribute] = true;
        });
        return existingAttributes;
      }
      function collectAttributeNameSuggestions(nameStart, nameEnd = offset) {
        let replaceEnd = offset;
        while (replaceEnd < nameEnd && text[replaceEnd] !== "<") {
          replaceEnd++;
        }
        const currentAttribute = text.substring(nameStart, nameEnd);
        const range = getReplaceRange(nameStart, replaceEnd);
        let value = "";
        if (!isFollowedBy(text, nameEnd, ScannerState.AfterAttributeName, TokenType.DelimiterAssign)) {
          const defaultValue = settings?.attributeDefaultValue ?? "doublequotes";
          if (defaultValue === "empty") {
            value = "=$1";
          } else if (defaultValue === "singlequotes") {
            value = "='$1'";
          } else {
            value = '="$1"';
          }
        }
        const seenAttributes = getExistingAttributes();
        seenAttributes[currentAttribute] = false;
        dataProviders.forEach((provider) => {
          provider.provideAttributes(currentTag).forEach((attr) => {
            if (seenAttributes[attr.name]) {
              return;
            }
            seenAttributes[attr.name] = true;
            let codeSnippet = attr.name;
            let command;
            if (attr.valueSet !== "v" && value.length) {
              codeSnippet = codeSnippet + value;
              if (attr.valueSet || attr.name === "style") {
                command = {
                  title: "Suggest",
                  command: "editor.action.triggerSuggest"
                };
              }
            }
            result.items.push({
              label: attr.name,
              kind: attr.valueSet === "handler" ? CompletionItemKind.Function : CompletionItemKind.Value,
              documentation: generateDocumentation(attr, void 0, doesSupportMarkdown),
              textEdit: TextEdit.replace(range, codeSnippet),
              insertTextFormat: InsertTextFormat.Snippet,
              command
            });
          });
        });
        collectDataAttributesSuggestions(range, seenAttributes);
        return result;
      }
      function collectDataAttributesSuggestions(range, seenAttributes) {
        const dataAttr = "data-";
        const dataAttributes = {};
        dataAttributes[dataAttr] = `${dataAttr}$1="$2"`;
        function addNodeDataAttributes(node2) {
          node2.attributeNames.forEach((attr) => {
            if (startsWith(attr, dataAttr) && !dataAttributes[attr] && !seenAttributes[attr]) {
              dataAttributes[attr] = attr + '="$1"';
            }
          });
          node2.children.forEach((child) => addNodeDataAttributes(child));
        }
        if (htmlDocument) {
          htmlDocument.roots.forEach((root) => addNodeDataAttributes(root));
        }
        Object.keys(dataAttributes).forEach((attr) => result.items.push({
          label: attr,
          kind: CompletionItemKind.Value,
          textEdit: TextEdit.replace(range, dataAttributes[attr]),
          insertTextFormat: InsertTextFormat.Snippet
        }));
      }
      function collectAttributeValueSuggestions(valueStart, valueEnd = offset) {
        let range;
        let addQuotes;
        let valuePrefix;
        if (offset > valueStart && offset <= valueEnd && isQuote(text[valueStart])) {
          const valueContentStart = valueStart + 1;
          let valueContentEnd = valueEnd;
          if (valueEnd > valueStart && text[valueEnd - 1] === text[valueStart]) {
            valueContentEnd--;
          }
          const wsBefore = getWordStart(text, offset, valueContentStart);
          const wsAfter = getWordEnd(text, offset, valueContentEnd);
          range = getReplaceRange(wsBefore, wsAfter);
          valuePrefix = offset >= valueContentStart && offset <= valueContentEnd ? text.substring(valueContentStart, offset) : "";
          addQuotes = false;
        } else {
          range = getReplaceRange(valueStart, valueEnd);
          valuePrefix = text.substring(valueStart, offset);
          addQuotes = true;
        }
        if (completionParticipants.length > 0) {
          const tag = currentTag.toLowerCase();
          const attribute = currentAttributeName.toLowerCase();
          const fullRange = getReplaceRange(valueStart, valueEnd);
          for (const participant of completionParticipants) {
            if (participant.onHtmlAttributeValue) {
              participant.onHtmlAttributeValue({ document: document2, position, tag, attribute, value: valuePrefix, range: fullRange });
            }
          }
        }
        dataProviders.forEach((provider) => {
          provider.provideValues(currentTag, currentAttributeName).forEach((value) => {
            const insertText = addQuotes ? '"' + value.name + '"' : value.name;
            result.items.push({
              label: value.name,
              filterText: insertText,
              kind: CompletionItemKind.Unit,
              documentation: generateDocumentation(value, void 0, doesSupportMarkdown),
              textEdit: TextEdit.replace(range, insertText),
              insertTextFormat: InsertTextFormat.PlainText
            });
          });
        });
        collectCharacterEntityProposals();
        return result;
      }
      function scanNextForEndPos(nextToken) {
        if (offset === scanner.getTokenEnd()) {
          token = scanner.scan();
          if (token === nextToken && scanner.getTokenOffset() === offset) {
            return scanner.getTokenEnd();
          }
        }
        return offset;
      }
      function collectInsideContent() {
        for (const participant of completionParticipants) {
          if (participant.onHtmlContent) {
            participant.onHtmlContent({ document: document2, position });
          }
        }
        return collectCharacterEntityProposals();
      }
      function collectCharacterEntityProposals() {
        let k = offset - 1;
        let characterStart = position.character;
        while (k >= 0 && isLetterOrDigit(text, k)) {
          k--;
          characterStart--;
        }
        if (k >= 0 && text[k] === "&") {
          const range = Range.create(Position.create(position.line, characterStart - 1), position);
          for (const entity in entities) {
            if (endsWith(entity, ";")) {
              const label = "&" + entity;
              result.items.push({
                label,
                kind: CompletionItemKind.Keyword,
                documentation: t("Character entity representing '{0}'", entities[entity]),
                textEdit: TextEdit.replace(range, label),
                insertTextFormat: InsertTextFormat.PlainText
              });
            }
          }
        }
        return result;
      }
      function suggestDoctype(replaceStart, replaceEnd) {
        const range = getReplaceRange(replaceStart, replaceEnd);
        result.items.push({
          label: "!DOCTYPE",
          kind: CompletionItemKind.Property,
          documentation: "A preamble for an HTML document.",
          textEdit: TextEdit.replace(range, "!DOCTYPE html>"),
          insertTextFormat: InsertTextFormat.PlainText
        });
      }
      let token = scanner.scan();
      while (token !== TokenType.EOS && scanner.getTokenOffset() <= offset) {
        switch (token) {
          case TokenType.StartTagOpen:
            if (scanner.getTokenEnd() === offset) {
              const endPos = scanNextForEndPos(TokenType.StartTag);
              if (position.line === 0) {
                suggestDoctype(offset, endPos);
              }
              return collectTagSuggestions(offset, endPos);
            }
            break;
          case TokenType.StartTag:
            if (scanner.getTokenOffset() <= offset && offset <= scanner.getTokenEnd()) {
              return collectOpenTagSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd());
            }
            currentTag = scanner.getTokenText();
            break;
          case TokenType.AttributeName:
            if (scanner.getTokenOffset() <= offset && offset <= scanner.getTokenEnd()) {
              return collectAttributeNameSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd());
            }
            currentAttributeName = scanner.getTokenText();
            break;
          case TokenType.DelimiterAssign:
            if (scanner.getTokenEnd() === offset) {
              const endPos = scanNextForEndPos(TokenType.AttributeValue);
              return collectAttributeValueSuggestions(offset, endPos);
            }
            break;
          case TokenType.AttributeValue:
            if (scanner.getTokenOffset() <= offset && offset <= scanner.getTokenEnd()) {
              return collectAttributeValueSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd());
            }
            break;
          case TokenType.Whitespace:
            if (offset <= scanner.getTokenEnd()) {
              switch (scanner.getScannerState()) {
                case ScannerState.AfterOpeningStartTag:
                  const startPos = scanner.getTokenOffset();
                  const endTagPos = scanNextForEndPos(TokenType.StartTag);
                  return collectTagSuggestions(startPos, endTagPos);
                case ScannerState.WithinTag:
                case ScannerState.AfterAttributeName:
                  return collectAttributeNameSuggestions(scanner.getTokenEnd());
                case ScannerState.BeforeAttributeValue:
                  return collectAttributeValueSuggestions(scanner.getTokenEnd());
                case ScannerState.AfterOpeningEndTag:
                  return collectCloseTagSuggestions(scanner.getTokenOffset() - 1, false);
                case ScannerState.WithinContent:
                  return collectInsideContent();
              }
            }
            break;
          case TokenType.EndTagOpen:
            if (offset <= scanner.getTokenEnd()) {
              const afterOpenBracket = scanner.getTokenOffset() + 1;
              const endOffset = scanNextForEndPos(TokenType.EndTag);
              return collectCloseTagSuggestions(afterOpenBracket, false, endOffset);
            }
            break;
          case TokenType.EndTag:
            if (offset <= scanner.getTokenEnd()) {
              let start2 = scanner.getTokenOffset() - 1;
              while (start2 >= 0) {
                const ch = text.charAt(start2);
                if (ch === "/") {
                  return collectCloseTagSuggestions(start2, false, scanner.getTokenEnd());
                } else if (!isWhiteSpace(ch)) {
                  break;
                }
                start2--;
              }
            }
            break;
          case TokenType.StartTagClose:
            if (offset <= scanner.getTokenEnd()) {
              if (currentTag) {
                return collectAutoCloseTagSuggestion(scanner.getTokenEnd(), currentTag);
              }
            }
            break;
          case TokenType.Content:
            if (offset <= scanner.getTokenEnd()) {
              return collectInsideContent();
            }
            break;
          default:
            if (offset <= scanner.getTokenEnd()) {
              return result;
            }
            break;
        }
        token = scanner.scan();
      }
      return result;
    }
    doQuoteComplete(document2, position, htmlDocument, settings) {
      const offset = document2.offsetAt(position);
      if (offset <= 0) {
        return null;
      }
      const defaultValue = settings?.attributeDefaultValue ?? "doublequotes";
      if (defaultValue === "empty") {
        return null;
      }
      const char = document2.getText().charAt(offset - 1);
      if (char !== "=") {
        return null;
      }
      const value = defaultValue === "doublequotes" ? '"$1"' : "'$1'";
      const node = htmlDocument.findNodeBefore(offset);
      if (node && node.attributes && node.start < offset && (!node.endTagStart || node.endTagStart > offset)) {
        const scanner = createScanner(document2.getText(), node.start);
        let token = scanner.scan();
        while (token !== TokenType.EOS && scanner.getTokenEnd() <= offset) {
          if (token === TokenType.AttributeName && scanner.getTokenEnd() === offset - 1) {
            token = scanner.scan();
            if (token !== TokenType.DelimiterAssign) {
              return null;
            }
            token = scanner.scan();
            if (token === TokenType.Unknown || token === TokenType.AttributeValue) {
              return null;
            }
            return value;
          }
          token = scanner.scan();
        }
      }
      return null;
    }
    doTagComplete(document2, position, htmlDocument) {
      const offset = document2.offsetAt(position);
      if (offset <= 0) {
        return null;
      }
      const char = document2.getText().charAt(offset - 1);
      if (char === ">") {
        const voidElements = this.dataManager.getVoidElements(document2.languageId);
        const node = htmlDocument.findNodeBefore(offset);
        if (node && node.tag && !this.dataManager.isVoidElement(node.tag, voidElements) && node.start < offset && (!node.endTagStart || node.endTagStart > offset)) {
          const scanner = createScanner(document2.getText(), node.start);
          let token = scanner.scan();
          while (token !== TokenType.EOS && scanner.getTokenEnd() <= offset) {
            if (token === TokenType.StartTagClose && scanner.getTokenEnd() === offset) {
              return `$0</${node.tag}>`;
            }
            token = scanner.scan();
          }
        }
      } else if (char === "/") {
        let node = htmlDocument.findNodeBefore(offset);
        while (node && node.closed && !(node.endTagStart && node.endTagStart > offset)) {
          node = node.parent;
        }
        if (node && node.tag) {
          const scanner = createScanner(document2.getText(), node.start);
          let token = scanner.scan();
          while (token !== TokenType.EOS && scanner.getTokenEnd() <= offset) {
            if (token === TokenType.EndTagOpen && scanner.getTokenEnd() === offset) {
              if (document2.getText().charAt(offset) !== ">") {
                return `${node.tag}>`;
              } else {
                return node.tag;
              }
            }
            token = scanner.scan();
          }
        }
      }
      return null;
    }
    convertCompletionList(list) {
      if (!this.doesSupportMarkdown()) {
        list.items.forEach((item) => {
          if (item.documentation && typeof item.documentation !== "string") {
            item.documentation = {
              kind: "plaintext",
              value: item.documentation.value
            };
          }
        });
      }
      return list;
    }
    doesSupportMarkdown() {
      if (!isDefined(this.supportsMarkdown)) {
        if (!isDefined(this.lsOptions.clientCapabilities)) {
          this.supportsMarkdown = true;
          return this.supportsMarkdown;
        }
        const documentationFormat = this.lsOptions.clientCapabilities.textDocument?.completion?.completionItem?.documentationFormat;
        this.supportsMarkdown = Array.isArray(documentationFormat) && documentationFormat.indexOf(MarkupKind.Markdown) !== -1;
      }
      return this.supportsMarkdown;
    }
  }
  function isQuote(s) {
    return /^["']*$/.test(s);
  }
  function isWhiteSpace(s) {
    return /^\s*$/.test(s);
  }
  function isFollowedBy(s, offset, intialState, expectedToken) {
    const scanner = createScanner(s, offset, intialState);
    let token = scanner.scan();
    while (token === TokenType.Whitespace) {
      token = scanner.scan();
    }
    return token === expectedToken;
  }
  function getWordStart(s, offset, limit) {
    while (offset > limit && !isWhiteSpace(s[offset - 1])) {
      offset--;
    }
    return offset;
  }
  function getWordEnd(s, offset, limit) {
    while (offset < limit && !isWhiteSpace(s[offset])) {
      offset++;
    }
    return offset;
  }
  class HTMLHover {
    constructor(lsOptions, dataManager) {
      this.lsOptions = lsOptions;
      this.dataManager = dataManager;
    }
    doHover(document2, position, htmlDocument, options) {
      const convertContents = this.convertContents.bind(this);
      const doesSupportMarkdown = this.doesSupportMarkdown();
      const offset = document2.offsetAt(position);
      const node = htmlDocument.findNodeAt(offset);
      const text = document2.getText();
      if (!node || !node.tag) {
        return null;
      }
      const dataProviders = this.dataManager.getDataProviders().filter((p) => p.isApplicable(document2.languageId));
      function getTagHover(currTag, range, open) {
        for (const provider of dataProviders) {
          let hover = null;
          provider.provideTags().forEach((tag) => {
            if (tag.name.toLowerCase() === currTag.toLowerCase()) {
              let markupContent = generateDocumentation(tag, options, doesSupportMarkdown);
              if (!markupContent) {
                markupContent = {
                  kind: doesSupportMarkdown ? "markdown" : "plaintext",
                  value: ""
                };
              }
              hover = { contents: markupContent, range };
            }
          });
          if (hover) {
            hover.contents = convertContents(hover.contents);
            return hover;
          }
        }
        return null;
      }
      function getAttrHover(currTag, currAttr, range) {
        for (const provider of dataProviders) {
          let hover = null;
          provider.provideAttributes(currTag).forEach((attr) => {
            if (currAttr === attr.name && attr.description) {
              const contentsDoc = generateDocumentation(attr, options, doesSupportMarkdown);
              if (contentsDoc) {
                hover = { contents: contentsDoc, range };
              } else {
                hover = null;
              }
            }
          });
          if (hover) {
            hover.contents = convertContents(hover.contents);
            return hover;
          }
        }
        return null;
      }
      function getAttrValueHover(currTag, currAttr, currAttrValue, range) {
        for (const provider of dataProviders) {
          let hover = null;
          provider.provideValues(currTag, currAttr).forEach((attrValue) => {
            if (currAttrValue === attrValue.name && attrValue.description) {
              const contentsDoc = generateDocumentation(attrValue, options, doesSupportMarkdown);
              if (contentsDoc) {
                hover = { contents: contentsDoc, range };
              } else {
                hover = null;
              }
            }
          });
          if (hover) {
            hover.contents = convertContents(hover.contents);
            return hover;
          }
        }
        return null;
      }
      function getEntityHover(text2, range) {
        let currEntity = filterEntity(text2);
        for (const entity in entities) {
          let hover = null;
          const label = "&" + entity;
          if (currEntity === label) {
            let code = entities[entity].charCodeAt(0).toString(16).toUpperCase();
            let hex = "U+";
            if (code.length < 4) {
              const zeroes = 4 - code.length;
              let k = 0;
              while (k < zeroes) {
                hex += "0";
                k += 1;
              }
            }
            hex += code;
            const contentsDoc = t("Character entity representing '{0}', unicode equivalent '{1}'", entities[entity], hex);
            if (contentsDoc) {
              hover = { contents: contentsDoc, range };
            } else {
              hover = null;
            }
          }
          if (hover) {
            hover.contents = convertContents(hover.contents);
            return hover;
          }
        }
        return null;
      }
      function getTagNameRange2(tokenType, startOffset) {
        const scanner = createScanner(document2.getText(), startOffset);
        let token = scanner.scan();
        while (token !== TokenType.EOS && (scanner.getTokenEnd() < offset || scanner.getTokenEnd() === offset && token !== tokenType)) {
          token = scanner.scan();
        }
        if (token === tokenType && offset <= scanner.getTokenEnd()) {
          return { start: document2.positionAt(scanner.getTokenOffset()), end: document2.positionAt(scanner.getTokenEnd()) };
        }
        return null;
      }
      function getEntityRange() {
        let k = offset - 1;
        let characterStart = position.character;
        while (k >= 0 && isLetterOrDigit(text, k)) {
          k--;
          characterStart--;
        }
        let n = k + 1;
        let characterEnd = characterStart;
        while (isLetterOrDigit(text, n)) {
          n++;
          characterEnd++;
        }
        if (k >= 0 && text[k] === "&") {
          let range = null;
          if (text[n] === ";") {
            range = Range.create(Position.create(position.line, characterStart), Position.create(position.line, characterEnd + 1));
          } else {
            range = Range.create(Position.create(position.line, characterStart), Position.create(position.line, characterEnd));
          }
          return range;
        }
        return null;
      }
      function filterEntity(text2) {
        let k = offset - 1;
        let newText = "&";
        while (k >= 0 && isLetterOrDigit(text2, k)) {
          k--;
        }
        k = k + 1;
        while (isLetterOrDigit(text2, k)) {
          newText += text2[k];
          k += 1;
        }
        newText += ";";
        return newText;
      }
      if (node.endTagStart && offset >= node.endTagStart) {
        const tagRange2 = getTagNameRange2(TokenType.EndTag, node.endTagStart);
        if (tagRange2) {
          return getTagHover(node.tag, tagRange2);
        }
        return null;
      }
      const tagRange = getTagNameRange2(TokenType.StartTag, node.start);
      if (tagRange) {
        return getTagHover(node.tag, tagRange);
      }
      const attrRange = getTagNameRange2(TokenType.AttributeName, node.start);
      if (attrRange) {
        const tag = node.tag;
        const attr = document2.getText(attrRange);
        return getAttrHover(tag, attr, attrRange);
      }
      const entityRange = getEntityRange();
      if (entityRange) {
        return getEntityHover(text, entityRange);
      }
      function scanAttrAndAttrValue(nodeStart, attrValueStart) {
        const scanner = createScanner(document2.getText(), nodeStart);
        let token = scanner.scan();
        let prevAttr = void 0;
        while (token !== TokenType.EOS && scanner.getTokenEnd() <= attrValueStart) {
          token = scanner.scan();
          if (token === TokenType.AttributeName) {
            prevAttr = scanner.getTokenText();
          }
        }
        return prevAttr;
      }
      const attrValueRange = getTagNameRange2(TokenType.AttributeValue, node.start);
      if (attrValueRange) {
        const tag = node.tag;
        const attrValue = trimQuotes(document2.getText(attrValueRange));
        const matchAttr = scanAttrAndAttrValue(node.start, document2.offsetAt(attrValueRange.start));
        if (matchAttr) {
          return getAttrValueHover(tag, matchAttr, attrValue, attrValueRange);
        }
      }
      return null;
    }
    convertContents(contents) {
      if (!this.doesSupportMarkdown()) {
        if (typeof contents === "string") {
          return contents;
        } else if ("kind" in contents) {
          return {
            kind: "plaintext",
            value: contents.value
          };
        } else if (Array.isArray(contents)) {
          contents.map((c) => {
            return typeof c === "string" ? c : c.value;
          });
        } else {
          return contents.value;
        }
      }
      return contents;
    }
    doesSupportMarkdown() {
      if (!isDefined(this.supportsMarkdown)) {
        if (!isDefined(this.lsOptions.clientCapabilities)) {
          this.supportsMarkdown = true;
          return this.supportsMarkdown;
        }
        const contentFormat = this.lsOptions.clientCapabilities?.textDocument?.hover?.contentFormat;
        this.supportsMarkdown = Array.isArray(contentFormat) && contentFormat.indexOf(MarkupKind.Markdown) !== -1;
      }
      return this.supportsMarkdown;
    }
  }
  function trimQuotes(s) {
    if (s.length <= 1) {
      return s.replace(/['"]/, "");
    }
    if (s[0] === `'` || s[0] === `"`) {
      s = s.slice(1);
    }
    if (s[s.length - 1] === `'` || s[s.length - 1] === `"`) {
      s = s.slice(0, -1);
    }
    return s;
  }
  function js_beautify(js_source_text, options) {
    return js_source_text;
  }
  var legacy_beautify_css;
  (function() {
    var __webpack_modules__ = [
      ,
      ,
      /* 2 */
      /***/
      (function(module) {
        function OutputLine(parent) {
          this.__parent = parent;
          this.__character_count = 0;
          this.__indent_count = -1;
          this.__alignment_count = 0;
          this.__wrap_point_index = 0;
          this.__wrap_point_character_count = 0;
          this.__wrap_point_indent_count = -1;
          this.__wrap_point_alignment_count = 0;
          this.__items = [];
        }
        OutputLine.prototype.clone_empty = function() {
          var line = new OutputLine(this.__parent);
          line.set_indent(this.__indent_count, this.__alignment_count);
          return line;
        };
        OutputLine.prototype.item = function(index) {
          if (index < 0) {
            return this.__items[this.__items.length + index];
          } else {
            return this.__items[index];
          }
        };
        OutputLine.prototype.has_match = function(pattern) {
          for (var lastCheckedOutput = this.__items.length - 1; lastCheckedOutput >= 0; lastCheckedOutput--) {
            if (this.__items[lastCheckedOutput].match(pattern)) {
              return true;
            }
          }
          return false;
        };
        OutputLine.prototype.set_indent = function(indent, alignment) {
          if (this.is_empty()) {
            this.__indent_count = indent || 0;
            this.__alignment_count = alignment || 0;
            this.__character_count = this.__parent.get_indent_size(this.__indent_count, this.__alignment_count);
          }
        };
        OutputLine.prototype._set_wrap_point = function() {
          if (this.__parent.wrap_line_length) {
            this.__wrap_point_index = this.__items.length;
            this.__wrap_point_character_count = this.__character_count;
            this.__wrap_point_indent_count = this.__parent.next_line.__indent_count;
            this.__wrap_point_alignment_count = this.__parent.next_line.__alignment_count;
          }
        };
        OutputLine.prototype._should_wrap = function() {
          return this.__wrap_point_index && this.__character_count > this.__parent.wrap_line_length && this.__wrap_point_character_count > this.__parent.next_line.__character_count;
        };
        OutputLine.prototype._allow_wrap = function() {
          if (this._should_wrap()) {
            this.__parent.add_new_line();
            var next = this.__parent.current_line;
            next.set_indent(this.__wrap_point_indent_count, this.__wrap_point_alignment_count);
            next.__items = this.__items.slice(this.__wrap_point_index);
            this.__items = this.__items.slice(0, this.__wrap_point_index);
            next.__character_count += this.__character_count - this.__wrap_point_character_count;
            this.__character_count = this.__wrap_point_character_count;
            if (next.__items[0] === " ") {
              next.__items.splice(0, 1);
              next.__character_count -= 1;
            }
            return true;
          }
          return false;
        };
        OutputLine.prototype.is_empty = function() {
          return this.__items.length === 0;
        };
        OutputLine.prototype.last = function() {
          if (!this.is_empty()) {
            return this.__items[this.__items.length - 1];
          } else {
            return null;
          }
        };
        OutputLine.prototype.push = function(item) {
          this.__items.push(item);
          var last_newline_index = item.lastIndexOf("\n");
          if (last_newline_index !== -1) {
            this.__character_count = item.length - last_newline_index;
          } else {
            this.__character_count += item.length;
          }
        };
        OutputLine.prototype.pop = function() {
          var item = null;
          if (!this.is_empty()) {
            item = this.__items.pop();
            this.__character_count -= item.length;
          }
          return item;
        };
        OutputLine.prototype._remove_indent = function() {
          if (this.__indent_count > 0) {
            this.__indent_count -= 1;
            this.__character_count -= this.__parent.indent_size;
          }
        };
        OutputLine.prototype._remove_wrap_indent = function() {
          if (this.__wrap_point_indent_count > 0) {
            this.__wrap_point_indent_count -= 1;
          }
        };
        OutputLine.prototype.trim = function() {
          while (this.last() === " ") {
            this.__items.pop();
            this.__character_count -= 1;
          }
        };
        OutputLine.prototype.toString = function() {
          var result = "";
          if (this.is_empty()) {
            if (this.__parent.indent_empty_lines) {
              result = this.__parent.get_indent_string(this.__indent_count);
            }
          } else {
            result = this.__parent.get_indent_string(this.__indent_count, this.__alignment_count);
            result += this.__items.join("");
          }
          return result;
        };
        function IndentStringCache(options, baseIndentString) {
          this.__cache = [""];
          this.__indent_size = options.indent_size;
          this.__indent_string = options.indent_char;
          if (!options.indent_with_tabs) {
            this.__indent_string = new Array(options.indent_size + 1).join(options.indent_char);
          }
          baseIndentString = baseIndentString || "";
          if (options.indent_level > 0) {
            baseIndentString = new Array(options.indent_level + 1).join(this.__indent_string);
          }
          this.__base_string = baseIndentString;
          this.__base_string_length = baseIndentString.length;
        }
        IndentStringCache.prototype.get_indent_size = function(indent, column) {
          var result = this.__base_string_length;
          column = column || 0;
          if (indent < 0) {
            result = 0;
          }
          result += indent * this.__indent_size;
          result += column;
          return result;
        };
        IndentStringCache.prototype.get_indent_string = function(indent_level, column) {
          var result = this.__base_string;
          column = column || 0;
          if (indent_level < 0) {
            indent_level = 0;
            result = "";
          }
          column += indent_level * this.__indent_size;
          this.__ensure_cache(column);
          result += this.__cache[column];
          return result;
        };
        IndentStringCache.prototype.__ensure_cache = function(column) {
          while (column >= this.__cache.length) {
            this.__add_column();
          }
        };
        IndentStringCache.prototype.__add_column = function() {
          var column = this.__cache.length;
          var indent = 0;
          var result = "";
          if (this.__indent_size && column >= this.__indent_size) {
            indent = Math.floor(column / this.__indent_size);
            column -= indent * this.__indent_size;
            result = new Array(indent + 1).join(this.__indent_string);
          }
          if (column) {
            result += new Array(column + 1).join(" ");
          }
          this.__cache.push(result);
        };
        function Output(options, baseIndentString) {
          this.__indent_cache = new IndentStringCache(options, baseIndentString);
          this.raw = false;
          this._end_with_newline = options.end_with_newline;
          this.indent_size = options.indent_size;
          this.wrap_line_length = options.wrap_line_length;
          this.indent_empty_lines = options.indent_empty_lines;
          this.__lines = [];
          this.previous_line = null;
          this.current_line = null;
          this.next_line = new OutputLine(this);
          this.space_before_token = false;
          this.non_breaking_space = false;
          this.previous_token_wrapped = false;
          this.__add_outputline();
        }
        Output.prototype.__add_outputline = function() {
          this.previous_line = this.current_line;
          this.current_line = this.next_line.clone_empty();
          this.__lines.push(this.current_line);
        };
        Output.prototype.get_line_number = function() {
          return this.__lines.length;
        };
        Output.prototype.get_indent_string = function(indent, column) {
          return this.__indent_cache.get_indent_string(indent, column);
        };
        Output.prototype.get_indent_size = function(indent, column) {
          return this.__indent_cache.get_indent_size(indent, column);
        };
        Output.prototype.is_empty = function() {
          return !this.previous_line && this.current_line.is_empty();
        };
        Output.prototype.add_new_line = function(force_newline) {
          if (this.is_empty() || !force_newline && this.just_added_newline()) {
            return false;
          }
          if (!this.raw) {
            this.__add_outputline();
          }
          return true;
        };
        Output.prototype.get_code = function(eol) {
          this.trim(true);
          var last_item = this.current_line.pop();
          if (last_item) {
            if (last_item[last_item.length - 1] === "\n") {
              last_item = last_item.replace(/\n+$/g, "");
            }
            this.current_line.push(last_item);
          }
          if (this._end_with_newline) {
            this.__add_outputline();
          }
          var sweet_code = this.__lines.join("\n");
          if (eol !== "\n") {
            sweet_code = sweet_code.replace(/[\n]/g, eol);
          }
          return sweet_code;
        };
        Output.prototype.set_wrap_point = function() {
          this.current_line._set_wrap_point();
        };
        Output.prototype.set_indent = function(indent, alignment) {
          indent = indent || 0;
          alignment = alignment || 0;
          this.next_line.set_indent(indent, alignment);
          if (this.__lines.length > 1) {
            this.current_line.set_indent(indent, alignment);
            return true;
          }
          this.current_line.set_indent();
          return false;
        };
        Output.prototype.add_raw_token = function(token) {
          for (var x = 0; x < token.newlines; x++) {
            this.__add_outputline();
          }
          this.current_line.set_indent(-1);
          this.current_line.push(token.whitespace_before);
          this.current_line.push(token.text);
          this.space_before_token = false;
          this.non_breaking_space = false;
          this.previous_token_wrapped = false;
        };
        Output.prototype.add_token = function(printable_token) {
          this.__add_space_before_token();
          this.current_line.push(printable_token);
          this.space_before_token = false;
          this.non_breaking_space = false;
          this.previous_token_wrapped = this.current_line._allow_wrap();
        };
        Output.prototype.__add_space_before_token = function() {
          if (this.space_before_token && !this.just_added_newline()) {
            if (!this.non_breaking_space) {
              this.set_wrap_point();
            }
            this.current_line.push(" ");
          }
        };
        Output.prototype.remove_indent = function(index) {
          var output_length = this.__lines.length;
          while (index < output_length) {
            this.__lines[index]._remove_indent();
            index++;
          }
          this.current_line._remove_wrap_indent();
        };
        Output.prototype.trim = function(eat_newlines) {
          eat_newlines = eat_newlines === void 0 ? false : eat_newlines;
          this.current_line.trim();
          while (eat_newlines && this.__lines.length > 1 && this.current_line.is_empty()) {
            this.__lines.pop();
            this.current_line = this.__lines[this.__lines.length - 1];
            this.current_line.trim();
          }
          this.previous_line = this.__lines.length > 1 ? this.__lines[this.__lines.length - 2] : null;
        };
        Output.prototype.just_added_newline = function() {
          return this.current_line.is_empty();
        };
        Output.prototype.just_added_blankline = function() {
          return this.is_empty() || this.current_line.is_empty() && this.previous_line.is_empty();
        };
        Output.prototype.ensure_empty_line_above = function(starts_with, ends_with) {
          var index = this.__lines.length - 2;
          while (index >= 0) {
            var potentialEmptyLine = this.__lines[index];
            if (potentialEmptyLine.is_empty()) {
              break;
            } else if (potentialEmptyLine.item(0).indexOf(starts_with) !== 0 && potentialEmptyLine.item(-1) !== ends_with) {
              this.__lines.splice(index + 1, 0, new OutputLine(this));
              this.previous_line = this.__lines[this.__lines.length - 2];
              break;
            }
            index--;
          }
        };
        module.exports.Output = Output;
      }),
      ,
      ,
      ,
      /* 6 */
      /***/
      (function(module) {
        function Options(options, merge_child_field) {
          this.raw_options = _mergeOpts(options, merge_child_field);
          this.disabled = this._get_boolean("disabled");
          this.eol = this._get_characters("eol", "auto");
          this.end_with_newline = this._get_boolean("end_with_newline");
          this.indent_size = this._get_number("indent_size", 4);
          this.indent_char = this._get_characters("indent_char", " ");
          this.indent_level = this._get_number("indent_level");
          this.preserve_newlines = this._get_boolean("preserve_newlines", true);
          this.max_preserve_newlines = this._get_number("max_preserve_newlines", 32786);
          if (!this.preserve_newlines) {
            this.max_preserve_newlines = 0;
          }
          this.indent_with_tabs = this._get_boolean("indent_with_tabs", this.indent_char === "	");
          if (this.indent_with_tabs) {
            this.indent_char = "	";
            if (this.indent_size === 1) {
              this.indent_size = 4;
            }
          }
          this.wrap_line_length = this._get_number("wrap_line_length", this._get_number("max_char"));
          this.indent_empty_lines = this._get_boolean("indent_empty_lines");
          this.templating = this._get_selection_list("templating", ["auto", "none", "angular", "django", "erb", "handlebars", "php", "smarty"], ["auto"]);
        }
        Options.prototype._get_array = function(name, default_value) {
          var option_value = this.raw_options[name];
          var result = default_value || [];
          if (typeof option_value === "object") {
            if (option_value !== null && typeof option_value.concat === "function") {
              result = option_value.concat();
            }
          } else if (typeof option_value === "string") {
            result = option_value.split(/[^a-zA-Z0-9_\/\-]+/);
          }
          return result;
        };
        Options.prototype._get_boolean = function(name, default_value) {
          var option_value = this.raw_options[name];
          var result = option_value === void 0 ? !!default_value : !!option_value;
          return result;
        };
        Options.prototype._get_characters = function(name, default_value) {
          var option_value = this.raw_options[name];
          var result = default_value || "";
          if (typeof option_value === "string") {
            result = option_value.replace(/\\r/, "\r").replace(/\\n/, "\n").replace(/\\t/, "	");
          }
          return result;
        };
        Options.prototype._get_number = function(name, default_value) {
          var option_value = this.raw_options[name];
          default_value = parseInt(default_value, 10);
          if (isNaN(default_value)) {
            default_value = 0;
          }
          var result = parseInt(option_value, 10);
          if (isNaN(result)) {
            result = default_value;
          }
          return result;
        };
        Options.prototype._get_selection = function(name, selection_list, default_value) {
          var result = this._get_selection_list(name, selection_list, default_value);
          if (result.length !== 1) {
            throw new Error(
              "Invalid Option Value: The option '" + name + "' can only be one of the following values:\n" + selection_list + "\nYou passed in: '" + this.raw_options[name] + "'"
            );
          }
          return result[0];
        };
        Options.prototype._get_selection_list = function(name, selection_list, default_value) {
          if (!selection_list || selection_list.length === 0) {
            throw new Error("Selection list cannot be empty.");
          }
          default_value = default_value || [selection_list[0]];
          if (!this._is_valid_selection(default_value, selection_list)) {
            throw new Error("Invalid Default Value!");
          }
          var result = this._get_array(name, default_value);
          if (!this._is_valid_selection(result, selection_list)) {
            throw new Error(
              "Invalid Option Value: The option '" + name + "' can contain only the following values:\n" + selection_list + "\nYou passed in: '" + this.raw_options[name] + "'"
            );
          }
          return result;
        };
        Options.prototype._is_valid_selection = function(result, selection_list) {
          return result.length && selection_list.length && !result.some(function(item) {
            return selection_list.indexOf(item) === -1;
          });
        };
        function _mergeOpts(allOptions, childFieldName) {
          var finalOpts = {};
          allOptions = _normalizeOpts(allOptions);
          var name;
          for (name in allOptions) {
            if (name !== childFieldName) {
              finalOpts[name] = allOptions[name];
            }
          }
          if (childFieldName && allOptions[childFieldName]) {
            for (name in allOptions[childFieldName]) {
              finalOpts[name] = allOptions[childFieldName][name];
            }
          }
          return finalOpts;
        }
        function _normalizeOpts(options) {
          var convertedOpts = {};
          var key;
          for (key in options) {
            var newKey = key.replace(/-/g, "_");
            convertedOpts[newKey] = options[key];
          }
          return convertedOpts;
        }
        module.exports.Options = Options;
        module.exports.normalizeOpts = _normalizeOpts;
        module.exports.mergeOpts = _mergeOpts;
      }),
      ,
      /* 8 */
      /***/
      (function(module) {
        var regexp_has_sticky = RegExp.prototype.hasOwnProperty("sticky");
        function InputScanner(input_string) {
          this.__input = input_string || "";
          this.__input_length = this.__input.length;
          this.__position = 0;
        }
        InputScanner.prototype.restart = function() {
          this.__position = 0;
        };
        InputScanner.prototype.back = function() {
          if (this.__position > 0) {
            this.__position -= 1;
          }
        };
        InputScanner.prototype.hasNext = function() {
          return this.__position < this.__input_length;
        };
        InputScanner.prototype.next = function() {
          var val = null;
          if (this.hasNext()) {
            val = this.__input.charAt(this.__position);
            this.__position += 1;
          }
          return val;
        };
        InputScanner.prototype.peek = function(index) {
          var val = null;
          index = index || 0;
          index += this.__position;
          if (index >= 0 && index < this.__input_length) {
            val = this.__input.charAt(index);
          }
          return val;
        };
        InputScanner.prototype.__match = function(pattern, index) {
          pattern.lastIndex = index;
          var pattern_match = pattern.exec(this.__input);
          if (pattern_match && !(regexp_has_sticky && pattern.sticky)) {
            if (pattern_match.index !== index) {
              pattern_match = null;
            }
          }
          return pattern_match;
        };
        InputScanner.prototype.test = function(pattern, index) {
          index = index || 0;
          index += this.__position;
          if (index >= 0 && index < this.__input_length) {
            return !!this.__match(pattern, index);
          } else {
            return false;
          }
        };
        InputScanner.prototype.testChar = function(pattern, index) {
          var val = this.peek(index);
          pattern.lastIndex = 0;
          return val !== null && pattern.test(val);
        };
        InputScanner.prototype.match = function(pattern) {
          var pattern_match = this.__match(pattern, this.__position);
          if (pattern_match) {
            this.__position += pattern_match[0].length;
          } else {
            pattern_match = null;
          }
          return pattern_match;
        };
        InputScanner.prototype.read = function(starting_pattern, until_pattern, until_after) {
          var val = "";
          var match;
          if (starting_pattern) {
            match = this.match(starting_pattern);
            if (match) {
              val += match[0];
            }
          }
          if (until_pattern && (match || !starting_pattern)) {
            val += this.readUntil(until_pattern, until_after);
          }
          return val;
        };
        InputScanner.prototype.readUntil = function(pattern, until_after) {
          var val = "";
          var match_index = this.__position;
          pattern.lastIndex = this.__position;
          var pattern_match = pattern.exec(this.__input);
          if (pattern_match) {
            match_index = pattern_match.index;
            if (until_after) {
              match_index += pattern_match[0].length;
            }
          } else {
            match_index = this.__input_length;
          }
          val = this.__input.substring(this.__position, match_index);
          this.__position = match_index;
          return val;
        };
        InputScanner.prototype.readUntilAfter = function(pattern) {
          return this.readUntil(pattern, true);
        };
        InputScanner.prototype.get_regexp = function(pattern, match_from) {
          var result = null;
          var flags = "g";
          if (match_from && regexp_has_sticky) {
            flags = "y";
          }
          if (typeof pattern === "string" && pattern !== "") {
            result = new RegExp(pattern, flags);
          } else if (pattern) {
            result = new RegExp(pattern.source, flags);
          }
          return result;
        };
        InputScanner.prototype.get_literal_regexp = function(literal_string) {
          return RegExp(literal_string.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&"));
        };
        InputScanner.prototype.peekUntilAfter = function(pattern) {
          var start2 = this.__position;
          var val = this.readUntilAfter(pattern);
          this.__position = start2;
          return val;
        };
        InputScanner.prototype.lookBack = function(testVal) {
          var start2 = this.__position - 1;
          return start2 >= testVal.length && this.__input.substring(start2 - testVal.length, start2).toLowerCase() === testVal;
        };
        module.exports.InputScanner = InputScanner;
      }),
      ,
      ,
      ,
      ,
      /* 13 */
      /***/
      (function(module) {
        function Directives(start_block_pattern, end_block_pattern) {
          start_block_pattern = typeof start_block_pattern === "string" ? start_block_pattern : start_block_pattern.source;
          end_block_pattern = typeof end_block_pattern === "string" ? end_block_pattern : end_block_pattern.source;
          this.__directives_block_pattern = new RegExp(start_block_pattern + / beautify( \w+[:]\w+)+ /.source + end_block_pattern, "g");
          this.__directive_pattern = / (\w+)[:](\w+)/g;
          this.__directives_end_ignore_pattern = new RegExp(start_block_pattern + /\sbeautify\signore:end\s/.source + end_block_pattern, "g");
        }
        Directives.prototype.get_directives = function(text) {
          if (!text.match(this.__directives_block_pattern)) {
            return null;
          }
          var directives = {};
          this.__directive_pattern.lastIndex = 0;
          var directive_match = this.__directive_pattern.exec(text);
          while (directive_match) {
            directives[directive_match[1]] = directive_match[2];
            directive_match = this.__directive_pattern.exec(text);
          }
          return directives;
        };
        Directives.prototype.readIgnored = function(input) {
          return input.readUntilAfter(this.__directives_end_ignore_pattern);
        };
        module.exports.Directives = Directives;
      }),
      ,
      /* 15 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var Beautifier = __webpack_require__2(16).Beautifier, Options = __webpack_require__2(17).Options;
        function css_beautify2(source_text, options) {
          var beautifier = new Beautifier(source_text, options);
          return beautifier.beautify();
        }
        module.exports = css_beautify2;
        module.exports.defaultOptions = function() {
          return new Options();
        };
      }),
      /* 16 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var Options = __webpack_require__2(17).Options;
        var Output = __webpack_require__2(2).Output;
        var InputScanner = __webpack_require__2(8).InputScanner;
        var Directives = __webpack_require__2(13).Directives;
        var directives_core = new Directives(/\/\*/, /\*\//);
        var lineBreak = /\r\n|[\r\n]/;
        var allLineBreaks = /\r\n|[\r\n]/g;
        var whitespaceChar = /\s/;
        var whitespacePattern = /(?:\s|\n)+/g;
        var block_comment_pattern = /\/\*(?:[\s\S]*?)((?:\*\/)|$)/g;
        var comment_pattern = /\/\/(?:[^\n\r\u2028\u2029]*)/g;
        function Beautifier(source_text, options) {
          this._source_text = source_text || "";
          this._options = new Options(options);
          this._ch = null;
          this._input = null;
          this.NESTED_AT_RULE = {
            "page": true,
            "font-face": true,
            "keyframes": true,
            // also in CONDITIONAL_GROUP_RULE below
            "media": true,
            "supports": true,
            "document": true
          };
          this.CONDITIONAL_GROUP_RULE = {
            "media": true,
            "supports": true,
            "document": true
          };
          this.NON_SEMICOLON_NEWLINE_PROPERTY = [
            "grid-template-areas",
            "grid-template"
          ];
        }
        Beautifier.prototype.eatString = function(endChars) {
          var result = "";
          this._ch = this._input.next();
          while (this._ch) {
            result += this._ch;
            if (this._ch === "\\") {
              result += this._input.next();
            } else if (endChars.indexOf(this._ch) !== -1 || this._ch === "\n") {
              break;
            }
            this._ch = this._input.next();
          }
          return result;
        };
        Beautifier.prototype.eatWhitespace = function(allowAtLeastOneNewLine) {
          var result = whitespaceChar.test(this._input.peek());
          var newline_count = 0;
          while (whitespaceChar.test(this._input.peek())) {
            this._ch = this._input.next();
            if (allowAtLeastOneNewLine && this._ch === "\n") {
              if (newline_count === 0 || newline_count < this._options.max_preserve_newlines) {
                newline_count++;
                this._output.add_new_line(true);
              }
            }
          }
          return result;
        };
        Beautifier.prototype.foundNestedPseudoClass = function() {
          var openParen = 0;
          var i = 1;
          var ch = this._input.peek(i);
          while (ch) {
            if (ch === "{") {
              return true;
            } else if (ch === "(") {
              openParen += 1;
            } else if (ch === ")") {
              if (openParen === 0) {
                return false;
              }
              openParen -= 1;
            } else if (ch === ";" || ch === "}") {
              return false;
            }
            i++;
            ch = this._input.peek(i);
          }
          return false;
        };
        Beautifier.prototype.print_string = function(output_string) {
          this._output.set_indent(this._indentLevel);
          this._output.non_breaking_space = true;
          this._output.add_token(output_string);
        };
        Beautifier.prototype.preserveSingleSpace = function(isAfterSpace) {
          if (isAfterSpace) {
            this._output.space_before_token = true;
          }
        };
        Beautifier.prototype.indent = function() {
          this._indentLevel++;
        };
        Beautifier.prototype.outdent = function() {
          if (this._indentLevel > 0) {
            this._indentLevel--;
          }
        };
        Beautifier.prototype.beautify = function() {
          if (this._options.disabled) {
            return this._source_text;
          }
          var source_text = this._source_text;
          var eol = this._options.eol;
          if (eol === "auto") {
            eol = "\n";
            if (source_text && lineBreak.test(source_text || "")) {
              eol = source_text.match(lineBreak)[0];
            }
          }
          source_text = source_text.replace(allLineBreaks, "\n");
          var baseIndentString = source_text.match(/^[\t ]*/)[0];
          this._output = new Output(this._options, baseIndentString);
          this._input = new InputScanner(source_text);
          this._indentLevel = 0;
          this._nestedLevel = 0;
          this._ch = null;
          var parenLevel = 0;
          var insideRule = false;
          var insidePropertyValue = false;
          var enteringConditionalGroup = false;
          var insideNonNestedAtRule = false;
          var insideScssMap = false;
          var topCharacter = this._ch;
          var insideNonSemiColonValues = false;
          var whitespace;
          var isAfterSpace;
          var previous_ch;
          while (true) {
            whitespace = this._input.read(whitespacePattern);
            isAfterSpace = whitespace !== "";
            previous_ch = topCharacter;
            this._ch = this._input.next();
            if (this._ch === "\\" && this._input.hasNext()) {
              this._ch += this._input.next();
            }
            topCharacter = this._ch;
            if (!this._ch) {
              break;
            } else if (this._ch === "/" && this._input.peek() === "*") {
              this._output.add_new_line();
              this._input.back();
              var comment = this._input.read(block_comment_pattern);
              var directives = directives_core.get_directives(comment);
              if (directives && directives.ignore === "start") {
                comment += directives_core.readIgnored(this._input);
              }
              this.print_string(comment);
              this.eatWhitespace(true);
              this._output.add_new_line();
            } else if (this._ch === "/" && this._input.peek() === "/") {
              this._output.space_before_token = true;
              this._input.back();
              this.print_string(this._input.read(comment_pattern));
              this.eatWhitespace(true);
            } else if (this._ch === "$") {
              this.preserveSingleSpace(isAfterSpace);
              this.print_string(this._ch);
              var variable = this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);
              if (variable.match(/[ :]$/)) {
                variable = this.eatString(": ").replace(/\s+$/, "");
                this.print_string(variable);
                this._output.space_before_token = true;
              }
              if (parenLevel === 0 && variable.indexOf(":") !== -1) {
                insidePropertyValue = true;
                this.indent();
              }
            } else if (this._ch === "@") {
              this.preserveSingleSpace(isAfterSpace);
              if (this._input.peek() === "{") {
                this.print_string(this._ch + this.eatString("}"));
              } else {
                this.print_string(this._ch);
                var variableOrRule = this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);
                if (variableOrRule.match(/[ :]$/)) {
                  variableOrRule = this.eatString(": ").replace(/\s+$/, "");
                  this.print_string(variableOrRule);
                  this._output.space_before_token = true;
                }
                if (parenLevel === 0 && variableOrRule.indexOf(":") !== -1) {
                  insidePropertyValue = true;
                  this.indent();
                } else if (variableOrRule in this.NESTED_AT_RULE) {
                  this._nestedLevel += 1;
                  if (variableOrRule in this.CONDITIONAL_GROUP_RULE) {
                    enteringConditionalGroup = true;
                  }
                } else if (parenLevel === 0 && !insidePropertyValue) {
                  insideNonNestedAtRule = true;
                }
              }
            } else if (this._ch === "#" && this._input.peek() === "{") {
              this.preserveSingleSpace(isAfterSpace);
              this.print_string(this._ch + this.eatString("}"));
            } else if (this._ch === "{") {
              if (insidePropertyValue) {
                insidePropertyValue = false;
                this.outdent();
              }
              insideNonNestedAtRule = false;
              if (enteringConditionalGroup) {
                enteringConditionalGroup = false;
                insideRule = this._indentLevel >= this._nestedLevel;
              } else {
                insideRule = this._indentLevel >= this._nestedLevel - 1;
              }
              if (this._options.newline_between_rules && insideRule) {
                if (this._output.previous_line && this._output.previous_line.item(-1) !== "{") {
                  this._output.ensure_empty_line_above("/", ",");
                }
              }
              this._output.space_before_token = true;
              if (this._options.brace_style === "expand") {
                this._output.add_new_line();
                this.print_string(this._ch);
                this.indent();
                this._output.set_indent(this._indentLevel);
              } else {
                if (previous_ch === "(") {
                  this._output.space_before_token = false;
                } else if (previous_ch !== ",") {
                  this.indent();
                }
                this.print_string(this._ch);
              }
              this.eatWhitespace(true);
              this._output.add_new_line();
            } else if (this._ch === "}") {
              this.outdent();
              this._output.add_new_line();
              if (previous_ch === "{") {
                this._output.trim(true);
              }
              if (insidePropertyValue) {
                this.outdent();
                insidePropertyValue = false;
              }
              this.print_string(this._ch);
              insideRule = false;
              if (this._nestedLevel) {
                this._nestedLevel--;
              }
              this.eatWhitespace(true);
              this._output.add_new_line();
              if (this._options.newline_between_rules && !this._output.just_added_blankline()) {
                if (this._input.peek() !== "}") {
                  this._output.add_new_line(true);
                }
              }
              if (this._input.peek() === ")") {
                this._output.trim(true);
                if (this._options.brace_style === "expand") {
                  this._output.add_new_line(true);
                }
              }
            } else if (this._ch === ":") {
              for (var i = 0; i < this.NON_SEMICOLON_NEWLINE_PROPERTY.length; i++) {
                if (this._input.lookBack(this.NON_SEMICOLON_NEWLINE_PROPERTY[i])) {
                  insideNonSemiColonValues = true;
                  break;
                }
              }
              if ((insideRule || enteringConditionalGroup) && !(this._input.lookBack("&") || this.foundNestedPseudoClass()) && !this._input.lookBack("(") && !insideNonNestedAtRule && parenLevel === 0) {
                this.print_string(":");
                if (!insidePropertyValue) {
                  insidePropertyValue = true;
                  this._output.space_before_token = true;
                  this.eatWhitespace(true);
                  this.indent();
                }
              } else {
                if (this._input.lookBack(" ")) {
                  this._output.space_before_token = true;
                }
                if (this._input.peek() === ":") {
                  this._ch = this._input.next();
                  this.print_string("::");
                } else {
                  this.print_string(":");
                }
              }
            } else if (this._ch === '"' || this._ch === "'") {
              var preserveQuoteSpace = previous_ch === '"' || previous_ch === "'";
              this.preserveSingleSpace(preserveQuoteSpace || isAfterSpace);
              this.print_string(this._ch + this.eatString(this._ch));
              this.eatWhitespace(true);
            } else if (this._ch === ";") {
              insideNonSemiColonValues = false;
              if (parenLevel === 0) {
                if (insidePropertyValue) {
                  this.outdent();
                  insidePropertyValue = false;
                }
                insideNonNestedAtRule = false;
                this.print_string(this._ch);
                this.eatWhitespace(true);
                if (this._input.peek() !== "/") {
                  this._output.add_new_line();
                }
              } else {
                this.print_string(this._ch);
                this.eatWhitespace(true);
                this._output.space_before_token = true;
              }
            } else if (this._ch === "(") {
              if (this._input.lookBack("url")) {
                this.print_string(this._ch);
                this.eatWhitespace();
                parenLevel++;
                this.indent();
                this._ch = this._input.next();
                if (this._ch === ")" || this._ch === '"' || this._ch === "'") {
                  this._input.back();
                } else if (this._ch) {
                  this.print_string(this._ch + this.eatString(")"));
                  if (parenLevel) {
                    parenLevel--;
                    this.outdent();
                  }
                }
              } else {
                var space_needed = false;
                if (this._input.lookBack("with")) {
                  space_needed = true;
                }
                this.preserveSingleSpace(isAfterSpace || space_needed);
                this.print_string(this._ch);
                if (insidePropertyValue && previous_ch === "$" && this._options.selector_separator_newline) {
                  this._output.add_new_line();
                  insideScssMap = true;
                } else {
                  this.eatWhitespace();
                  parenLevel++;
                  this.indent();
                }
              }
            } else if (this._ch === ")") {
              if (parenLevel) {
                parenLevel--;
                this.outdent();
              }
              if (insideScssMap && this._input.peek() === ";" && this._options.selector_separator_newline) {
                insideScssMap = false;
                this.outdent();
                this._output.add_new_line();
              }
              this.print_string(this._ch);
            } else if (this._ch === ",") {
              this.print_string(this._ch);
              this.eatWhitespace(true);
              if (this._options.selector_separator_newline && (!insidePropertyValue || insideScssMap) && parenLevel === 0 && !insideNonNestedAtRule) {
                this._output.add_new_line();
              } else {
                this._output.space_before_token = true;
              }
            } else if ((this._ch === ">" || this._ch === "+" || this._ch === "~") && !insidePropertyValue && parenLevel === 0) {
              if (this._options.space_around_combinator) {
                this._output.space_before_token = true;
                this.print_string(this._ch);
                this._output.space_before_token = true;
              } else {
                this.print_string(this._ch);
                this.eatWhitespace();
                if (this._ch && whitespaceChar.test(this._ch)) {
                  this._ch = "";
                }
              }
            } else if (this._ch === "]") {
              this.print_string(this._ch);
            } else if (this._ch === "[") {
              this.preserveSingleSpace(isAfterSpace);
              this.print_string(this._ch);
            } else if (this._ch === "=") {
              this.eatWhitespace();
              this.print_string("=");
              if (whitespaceChar.test(this._ch)) {
                this._ch = "";
              }
            } else if (this._ch === "!" && !this._input.lookBack("\\")) {
              this._output.space_before_token = true;
              this.print_string(this._ch);
            } else {
              var preserveAfterSpace = previous_ch === '"' || previous_ch === "'";
              this.preserveSingleSpace(preserveAfterSpace || isAfterSpace);
              this.print_string(this._ch);
              if (!this._output.just_added_newline() && this._input.peek() === "\n" && insideNonSemiColonValues) {
                this._output.add_new_line();
              }
            }
          }
          var sweetCode = this._output.get_code(eol);
          return sweetCode;
        };
        module.exports.Beautifier = Beautifier;
      }),
      /* 17 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var BaseOptions = __webpack_require__2(6).Options;
        function Options(options) {
          BaseOptions.call(this, options, "css");
          this.selector_separator_newline = this._get_boolean("selector_separator_newline", true);
          this.newline_between_rules = this._get_boolean("newline_between_rules", true);
          var space_around_selector_separator = this._get_boolean("space_around_selector_separator");
          this.space_around_combinator = this._get_boolean("space_around_combinator") || space_around_selector_separator;
          var brace_style_split = this._get_selection_list("brace_style", ["collapse", "expand", "end-expand", "none", "preserve-inline"]);
          this.brace_style = "collapse";
          for (var bs = 0; bs < brace_style_split.length; bs++) {
            if (brace_style_split[bs] !== "expand") {
              this.brace_style = "collapse";
            } else {
              this.brace_style = brace_style_split[bs];
            }
          }
        }
        Options.prototype = new BaseOptions();
        module.exports.Options = Options;
      })
      /******/
    ];
    var __webpack_module_cache__ = {};
    function __webpack_require__(moduleId) {
      var cachedModule = __webpack_module_cache__[moduleId];
      if (cachedModule !== void 0) {
        return cachedModule.exports;
      }
      var module = __webpack_module_cache__[moduleId] = {
        /******/
        // no module.id needed
        /******/
        // no module.loaded needed
        /******/
        exports: {}
        /******/
      };
      __webpack_modules__[moduleId](module, module.exports, __webpack_require__);
      return module.exports;
    }
    var __webpack_exports__ = __webpack_require__(15);
    legacy_beautify_css = __webpack_exports__;
  })();
  var css_beautify = legacy_beautify_css;
  var legacy_beautify_html;
  (function() {
    var __webpack_modules__ = [
      ,
      ,
      /* 2 */
      /***/
      (function(module) {
        function OutputLine(parent) {
          this.__parent = parent;
          this.__character_count = 0;
          this.__indent_count = -1;
          this.__alignment_count = 0;
          this.__wrap_point_index = 0;
          this.__wrap_point_character_count = 0;
          this.__wrap_point_indent_count = -1;
          this.__wrap_point_alignment_count = 0;
          this.__items = [];
        }
        OutputLine.prototype.clone_empty = function() {
          var line = new OutputLine(this.__parent);
          line.set_indent(this.__indent_count, this.__alignment_count);
          return line;
        };
        OutputLine.prototype.item = function(index) {
          if (index < 0) {
            return this.__items[this.__items.length + index];
          } else {
            return this.__items[index];
          }
        };
        OutputLine.prototype.has_match = function(pattern) {
          for (var lastCheckedOutput = this.__items.length - 1; lastCheckedOutput >= 0; lastCheckedOutput--) {
            if (this.__items[lastCheckedOutput].match(pattern)) {
              return true;
            }
          }
          return false;
        };
        OutputLine.prototype.set_indent = function(indent, alignment) {
          if (this.is_empty()) {
            this.__indent_count = indent || 0;
            this.__alignment_count = alignment || 0;
            this.__character_count = this.__parent.get_indent_size(this.__indent_count, this.__alignment_count);
          }
        };
        OutputLine.prototype._set_wrap_point = function() {
          if (this.__parent.wrap_line_length) {
            this.__wrap_point_index = this.__items.length;
            this.__wrap_point_character_count = this.__character_count;
            this.__wrap_point_indent_count = this.__parent.next_line.__indent_count;
            this.__wrap_point_alignment_count = this.__parent.next_line.__alignment_count;
          }
        };
        OutputLine.prototype._should_wrap = function() {
          return this.__wrap_point_index && this.__character_count > this.__parent.wrap_line_length && this.__wrap_point_character_count > this.__parent.next_line.__character_count;
        };
        OutputLine.prototype._allow_wrap = function() {
          if (this._should_wrap()) {
            this.__parent.add_new_line();
            var next = this.__parent.current_line;
            next.set_indent(this.__wrap_point_indent_count, this.__wrap_point_alignment_count);
            next.__items = this.__items.slice(this.__wrap_point_index);
            this.__items = this.__items.slice(0, this.__wrap_point_index);
            next.__character_count += this.__character_count - this.__wrap_point_character_count;
            this.__character_count = this.__wrap_point_character_count;
            if (next.__items[0] === " ") {
              next.__items.splice(0, 1);
              next.__character_count -= 1;
            }
            return true;
          }
          return false;
        };
        OutputLine.prototype.is_empty = function() {
          return this.__items.length === 0;
        };
        OutputLine.prototype.last = function() {
          if (!this.is_empty()) {
            return this.__items[this.__items.length - 1];
          } else {
            return null;
          }
        };
        OutputLine.prototype.push = function(item) {
          this.__items.push(item);
          var last_newline_index = item.lastIndexOf("\n");
          if (last_newline_index !== -1) {
            this.__character_count = item.length - last_newline_index;
          } else {
            this.__character_count += item.length;
          }
        };
        OutputLine.prototype.pop = function() {
          var item = null;
          if (!this.is_empty()) {
            item = this.__items.pop();
            this.__character_count -= item.length;
          }
          return item;
        };
        OutputLine.prototype._remove_indent = function() {
          if (this.__indent_count > 0) {
            this.__indent_count -= 1;
            this.__character_count -= this.__parent.indent_size;
          }
        };
        OutputLine.prototype._remove_wrap_indent = function() {
          if (this.__wrap_point_indent_count > 0) {
            this.__wrap_point_indent_count -= 1;
          }
        };
        OutputLine.prototype.trim = function() {
          while (this.last() === " ") {
            this.__items.pop();
            this.__character_count -= 1;
          }
        };
        OutputLine.prototype.toString = function() {
          var result = "";
          if (this.is_empty()) {
            if (this.__parent.indent_empty_lines) {
              result = this.__parent.get_indent_string(this.__indent_count);
            }
          } else {
            result = this.__parent.get_indent_string(this.__indent_count, this.__alignment_count);
            result += this.__items.join("");
          }
          return result;
        };
        function IndentStringCache(options, baseIndentString) {
          this.__cache = [""];
          this.__indent_size = options.indent_size;
          this.__indent_string = options.indent_char;
          if (!options.indent_with_tabs) {
            this.__indent_string = new Array(options.indent_size + 1).join(options.indent_char);
          }
          baseIndentString = baseIndentString || "";
          if (options.indent_level > 0) {
            baseIndentString = new Array(options.indent_level + 1).join(this.__indent_string);
          }
          this.__base_string = baseIndentString;
          this.__base_string_length = baseIndentString.length;
        }
        IndentStringCache.prototype.get_indent_size = function(indent, column) {
          var result = this.__base_string_length;
          column = column || 0;
          if (indent < 0) {
            result = 0;
          }
          result += indent * this.__indent_size;
          result += column;
          return result;
        };
        IndentStringCache.prototype.get_indent_string = function(indent_level, column) {
          var result = this.__base_string;
          column = column || 0;
          if (indent_level < 0) {
            indent_level = 0;
            result = "";
          }
          column += indent_level * this.__indent_size;
          this.__ensure_cache(column);
          result += this.__cache[column];
          return result;
        };
        IndentStringCache.prototype.__ensure_cache = function(column) {
          while (column >= this.__cache.length) {
            this.__add_column();
          }
        };
        IndentStringCache.prototype.__add_column = function() {
          var column = this.__cache.length;
          var indent = 0;
          var result = "";
          if (this.__indent_size && column >= this.__indent_size) {
            indent = Math.floor(column / this.__indent_size);
            column -= indent * this.__indent_size;
            result = new Array(indent + 1).join(this.__indent_string);
          }
          if (column) {
            result += new Array(column + 1).join(" ");
          }
          this.__cache.push(result);
        };
        function Output(options, baseIndentString) {
          this.__indent_cache = new IndentStringCache(options, baseIndentString);
          this.raw = false;
          this._end_with_newline = options.end_with_newline;
          this.indent_size = options.indent_size;
          this.wrap_line_length = options.wrap_line_length;
          this.indent_empty_lines = options.indent_empty_lines;
          this.__lines = [];
          this.previous_line = null;
          this.current_line = null;
          this.next_line = new OutputLine(this);
          this.space_before_token = false;
          this.non_breaking_space = false;
          this.previous_token_wrapped = false;
          this.__add_outputline();
        }
        Output.prototype.__add_outputline = function() {
          this.previous_line = this.current_line;
          this.current_line = this.next_line.clone_empty();
          this.__lines.push(this.current_line);
        };
        Output.prototype.get_line_number = function() {
          return this.__lines.length;
        };
        Output.prototype.get_indent_string = function(indent, column) {
          return this.__indent_cache.get_indent_string(indent, column);
        };
        Output.prototype.get_indent_size = function(indent, column) {
          return this.__indent_cache.get_indent_size(indent, column);
        };
        Output.prototype.is_empty = function() {
          return !this.previous_line && this.current_line.is_empty();
        };
        Output.prototype.add_new_line = function(force_newline) {
          if (this.is_empty() || !force_newline && this.just_added_newline()) {
            return false;
          }
          if (!this.raw) {
            this.__add_outputline();
          }
          return true;
        };
        Output.prototype.get_code = function(eol) {
          this.trim(true);
          var last_item = this.current_line.pop();
          if (last_item) {
            if (last_item[last_item.length - 1] === "\n") {
              last_item = last_item.replace(/\n+$/g, "");
            }
            this.current_line.push(last_item);
          }
          if (this._end_with_newline) {
            this.__add_outputline();
          }
          var sweet_code = this.__lines.join("\n");
          if (eol !== "\n") {
            sweet_code = sweet_code.replace(/[\n]/g, eol);
          }
          return sweet_code;
        };
        Output.prototype.set_wrap_point = function() {
          this.current_line._set_wrap_point();
        };
        Output.prototype.set_indent = function(indent, alignment) {
          indent = indent || 0;
          alignment = alignment || 0;
          this.next_line.set_indent(indent, alignment);
          if (this.__lines.length > 1) {
            this.current_line.set_indent(indent, alignment);
            return true;
          }
          this.current_line.set_indent();
          return false;
        };
        Output.prototype.add_raw_token = function(token) {
          for (var x = 0; x < token.newlines; x++) {
            this.__add_outputline();
          }
          this.current_line.set_indent(-1);
          this.current_line.push(token.whitespace_before);
          this.current_line.push(token.text);
          this.space_before_token = false;
          this.non_breaking_space = false;
          this.previous_token_wrapped = false;
        };
        Output.prototype.add_token = function(printable_token) {
          this.__add_space_before_token();
          this.current_line.push(printable_token);
          this.space_before_token = false;
          this.non_breaking_space = false;
          this.previous_token_wrapped = this.current_line._allow_wrap();
        };
        Output.prototype.__add_space_before_token = function() {
          if (this.space_before_token && !this.just_added_newline()) {
            if (!this.non_breaking_space) {
              this.set_wrap_point();
            }
            this.current_line.push(" ");
          }
        };
        Output.prototype.remove_indent = function(index) {
          var output_length = this.__lines.length;
          while (index < output_length) {
            this.__lines[index]._remove_indent();
            index++;
          }
          this.current_line._remove_wrap_indent();
        };
        Output.prototype.trim = function(eat_newlines) {
          eat_newlines = eat_newlines === void 0 ? false : eat_newlines;
          this.current_line.trim();
          while (eat_newlines && this.__lines.length > 1 && this.current_line.is_empty()) {
            this.__lines.pop();
            this.current_line = this.__lines[this.__lines.length - 1];
            this.current_line.trim();
          }
          this.previous_line = this.__lines.length > 1 ? this.__lines[this.__lines.length - 2] : null;
        };
        Output.prototype.just_added_newline = function() {
          return this.current_line.is_empty();
        };
        Output.prototype.just_added_blankline = function() {
          return this.is_empty() || this.current_line.is_empty() && this.previous_line.is_empty();
        };
        Output.prototype.ensure_empty_line_above = function(starts_with, ends_with) {
          var index = this.__lines.length - 2;
          while (index >= 0) {
            var potentialEmptyLine = this.__lines[index];
            if (potentialEmptyLine.is_empty()) {
              break;
            } else if (potentialEmptyLine.item(0).indexOf(starts_with) !== 0 && potentialEmptyLine.item(-1) !== ends_with) {
              this.__lines.splice(index + 1, 0, new OutputLine(this));
              this.previous_line = this.__lines[this.__lines.length - 2];
              break;
            }
            index--;
          }
        };
        module.exports.Output = Output;
      }),
      /* 3 */
      /***/
      (function(module) {
        function Token2(type, text, newlines, whitespace_before) {
          this.type = type;
          this.text = text;
          this.comments_before = null;
          this.newlines = newlines || 0;
          this.whitespace_before = whitespace_before || "";
          this.parent = null;
          this.next = null;
          this.previous = null;
          this.opened = null;
          this.closed = null;
          this.directives = null;
        }
        module.exports.Token = Token2;
      }),
      ,
      ,
      /* 6 */
      /***/
      (function(module) {
        function Options(options, merge_child_field) {
          this.raw_options = _mergeOpts(options, merge_child_field);
          this.disabled = this._get_boolean("disabled");
          this.eol = this._get_characters("eol", "auto");
          this.end_with_newline = this._get_boolean("end_with_newline");
          this.indent_size = this._get_number("indent_size", 4);
          this.indent_char = this._get_characters("indent_char", " ");
          this.indent_level = this._get_number("indent_level");
          this.preserve_newlines = this._get_boolean("preserve_newlines", true);
          this.max_preserve_newlines = this._get_number("max_preserve_newlines", 32786);
          if (!this.preserve_newlines) {
            this.max_preserve_newlines = 0;
          }
          this.indent_with_tabs = this._get_boolean("indent_with_tabs", this.indent_char === "	");
          if (this.indent_with_tabs) {
            this.indent_char = "	";
            if (this.indent_size === 1) {
              this.indent_size = 4;
            }
          }
          this.wrap_line_length = this._get_number("wrap_line_length", this._get_number("max_char"));
          this.indent_empty_lines = this._get_boolean("indent_empty_lines");
          this.templating = this._get_selection_list("templating", ["auto", "none", "angular", "django", "erb", "handlebars", "php", "smarty"], ["auto"]);
        }
        Options.prototype._get_array = function(name, default_value) {
          var option_value = this.raw_options[name];
          var result = default_value || [];
          if (typeof option_value === "object") {
            if (option_value !== null && typeof option_value.concat === "function") {
              result = option_value.concat();
            }
          } else if (typeof option_value === "string") {
            result = option_value.split(/[^a-zA-Z0-9_\/\-]+/);
          }
          return result;
        };
        Options.prototype._get_boolean = function(name, default_value) {
          var option_value = this.raw_options[name];
          var result = option_value === void 0 ? !!default_value : !!option_value;
          return result;
        };
        Options.prototype._get_characters = function(name, default_value) {
          var option_value = this.raw_options[name];
          var result = default_value || "";
          if (typeof option_value === "string") {
            result = option_value.replace(/\\r/, "\r").replace(/\\n/, "\n").replace(/\\t/, "	");
          }
          return result;
        };
        Options.prototype._get_number = function(name, default_value) {
          var option_value = this.raw_options[name];
          default_value = parseInt(default_value, 10);
          if (isNaN(default_value)) {
            default_value = 0;
          }
          var result = parseInt(option_value, 10);
          if (isNaN(result)) {
            result = default_value;
          }
          return result;
        };
        Options.prototype._get_selection = function(name, selection_list, default_value) {
          var result = this._get_selection_list(name, selection_list, default_value);
          if (result.length !== 1) {
            throw new Error(
              "Invalid Option Value: The option '" + name + "' can only be one of the following values:\n" + selection_list + "\nYou passed in: '" + this.raw_options[name] + "'"
            );
          }
          return result[0];
        };
        Options.prototype._get_selection_list = function(name, selection_list, default_value) {
          if (!selection_list || selection_list.length === 0) {
            throw new Error("Selection list cannot be empty.");
          }
          default_value = default_value || [selection_list[0]];
          if (!this._is_valid_selection(default_value, selection_list)) {
            throw new Error("Invalid Default Value!");
          }
          var result = this._get_array(name, default_value);
          if (!this._is_valid_selection(result, selection_list)) {
            throw new Error(
              "Invalid Option Value: The option '" + name + "' can contain only the following values:\n" + selection_list + "\nYou passed in: '" + this.raw_options[name] + "'"
            );
          }
          return result;
        };
        Options.prototype._is_valid_selection = function(result, selection_list) {
          return result.length && selection_list.length && !result.some(function(item) {
            return selection_list.indexOf(item) === -1;
          });
        };
        function _mergeOpts(allOptions, childFieldName) {
          var finalOpts = {};
          allOptions = _normalizeOpts(allOptions);
          var name;
          for (name in allOptions) {
            if (name !== childFieldName) {
              finalOpts[name] = allOptions[name];
            }
          }
          if (childFieldName && allOptions[childFieldName]) {
            for (name in allOptions[childFieldName]) {
              finalOpts[name] = allOptions[childFieldName][name];
            }
          }
          return finalOpts;
        }
        function _normalizeOpts(options) {
          var convertedOpts = {};
          var key;
          for (key in options) {
            var newKey = key.replace(/-/g, "_");
            convertedOpts[newKey] = options[key];
          }
          return convertedOpts;
        }
        module.exports.Options = Options;
        module.exports.normalizeOpts = _normalizeOpts;
        module.exports.mergeOpts = _mergeOpts;
      }),
      ,
      /* 8 */
      /***/
      (function(module) {
        var regexp_has_sticky = RegExp.prototype.hasOwnProperty("sticky");
        function InputScanner(input_string) {
          this.__input = input_string || "";
          this.__input_length = this.__input.length;
          this.__position = 0;
        }
        InputScanner.prototype.restart = function() {
          this.__position = 0;
        };
        InputScanner.prototype.back = function() {
          if (this.__position > 0) {
            this.__position -= 1;
          }
        };
        InputScanner.prototype.hasNext = function() {
          return this.__position < this.__input_length;
        };
        InputScanner.prototype.next = function() {
          var val = null;
          if (this.hasNext()) {
            val = this.__input.charAt(this.__position);
            this.__position += 1;
          }
          return val;
        };
        InputScanner.prototype.peek = function(index) {
          var val = null;
          index = index || 0;
          index += this.__position;
          if (index >= 0 && index < this.__input_length) {
            val = this.__input.charAt(index);
          }
          return val;
        };
        InputScanner.prototype.__match = function(pattern, index) {
          pattern.lastIndex = index;
          var pattern_match = pattern.exec(this.__input);
          if (pattern_match && !(regexp_has_sticky && pattern.sticky)) {
            if (pattern_match.index !== index) {
              pattern_match = null;
            }
          }
          return pattern_match;
        };
        InputScanner.prototype.test = function(pattern, index) {
          index = index || 0;
          index += this.__position;
          if (index >= 0 && index < this.__input_length) {
            return !!this.__match(pattern, index);
          } else {
            return false;
          }
        };
        InputScanner.prototype.testChar = function(pattern, index) {
          var val = this.peek(index);
          pattern.lastIndex = 0;
          return val !== null && pattern.test(val);
        };
        InputScanner.prototype.match = function(pattern) {
          var pattern_match = this.__match(pattern, this.__position);
          if (pattern_match) {
            this.__position += pattern_match[0].length;
          } else {
            pattern_match = null;
          }
          return pattern_match;
        };
        InputScanner.prototype.read = function(starting_pattern, until_pattern, until_after) {
          var val = "";
          var match;
          if (starting_pattern) {
            match = this.match(starting_pattern);
            if (match) {
              val += match[0];
            }
          }
          if (until_pattern && (match || !starting_pattern)) {
            val += this.readUntil(until_pattern, until_after);
          }
          return val;
        };
        InputScanner.prototype.readUntil = function(pattern, until_after) {
          var val = "";
          var match_index = this.__position;
          pattern.lastIndex = this.__position;
          var pattern_match = pattern.exec(this.__input);
          if (pattern_match) {
            match_index = pattern_match.index;
            if (until_after) {
              match_index += pattern_match[0].length;
            }
          } else {
            match_index = this.__input_length;
          }
          val = this.__input.substring(this.__position, match_index);
          this.__position = match_index;
          return val;
        };
        InputScanner.prototype.readUntilAfter = function(pattern) {
          return this.readUntil(pattern, true);
        };
        InputScanner.prototype.get_regexp = function(pattern, match_from) {
          var result = null;
          var flags = "g";
          if (match_from && regexp_has_sticky) {
            flags = "y";
          }
          if (typeof pattern === "string" && pattern !== "") {
            result = new RegExp(pattern, flags);
          } else if (pattern) {
            result = new RegExp(pattern.source, flags);
          }
          return result;
        };
        InputScanner.prototype.get_literal_regexp = function(literal_string) {
          return RegExp(literal_string.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&"));
        };
        InputScanner.prototype.peekUntilAfter = function(pattern) {
          var start2 = this.__position;
          var val = this.readUntilAfter(pattern);
          this.__position = start2;
          return val;
        };
        InputScanner.prototype.lookBack = function(testVal) {
          var start2 = this.__position - 1;
          return start2 >= testVal.length && this.__input.substring(start2 - testVal.length, start2).toLowerCase() === testVal;
        };
        module.exports.InputScanner = InputScanner;
      }),
      /* 9 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var InputScanner = __webpack_require__2(8).InputScanner;
        var Token2 = __webpack_require__2(3).Token;
        var TokenStream = __webpack_require__2(10).TokenStream;
        var WhitespacePattern = __webpack_require__2(11).WhitespacePattern;
        var TOKEN = {
          START: "TK_START",
          RAW: "TK_RAW",
          EOF: "TK_EOF"
        };
        var Tokenizer = function(input_string, options) {
          this._input = new InputScanner(input_string);
          this._options = options || {};
          this.__tokens = null;
          this._patterns = {};
          this._patterns.whitespace = new WhitespacePattern(this._input);
        };
        Tokenizer.prototype.tokenize = function() {
          this._input.restart();
          this.__tokens = new TokenStream();
          this._reset();
          var current;
          var previous = new Token2(TOKEN.START, "");
          var open_token = null;
          var open_stack = [];
          var comments = new TokenStream();
          while (previous.type !== TOKEN.EOF) {
            current = this._get_next_token(previous, open_token);
            while (this._is_comment(current)) {
              comments.add(current);
              current = this._get_next_token(previous, open_token);
            }
            if (!comments.isEmpty()) {
              current.comments_before = comments;
              comments = new TokenStream();
            }
            current.parent = open_token;
            if (this._is_opening(current)) {
              open_stack.push(open_token);
              open_token = current;
            } else if (open_token && this._is_closing(current, open_token)) {
              current.opened = open_token;
              open_token.closed = current;
              open_token = open_stack.pop();
              current.parent = open_token;
            }
            current.previous = previous;
            previous.next = current;
            this.__tokens.add(current);
            previous = current;
          }
          return this.__tokens;
        };
        Tokenizer.prototype._is_first_token = function() {
          return this.__tokens.isEmpty();
        };
        Tokenizer.prototype._reset = function() {
        };
        Tokenizer.prototype._get_next_token = function(previous_token, open_token) {
          this._readWhitespace();
          var resulting_string = this._input.read(/.+/g);
          if (resulting_string) {
            return this._create_token(TOKEN.RAW, resulting_string);
          } else {
            return this._create_token(TOKEN.EOF, "");
          }
        };
        Tokenizer.prototype._is_comment = function(current_token) {
          return false;
        };
        Tokenizer.prototype._is_opening = function(current_token) {
          return false;
        };
        Tokenizer.prototype._is_closing = function(current_token, open_token) {
          return false;
        };
        Tokenizer.prototype._create_token = function(type, text) {
          var token = new Token2(
            type,
            text,
            this._patterns.whitespace.newline_count,
            this._patterns.whitespace.whitespace_before_token
          );
          return token;
        };
        Tokenizer.prototype._readWhitespace = function() {
          return this._patterns.whitespace.read();
        };
        module.exports.Tokenizer = Tokenizer;
        module.exports.TOKEN = TOKEN;
      }),
      /* 10 */
      /***/
      (function(module) {
        function TokenStream(parent_token) {
          this.__tokens = [];
          this.__tokens_length = this.__tokens.length;
          this.__position = 0;
          this.__parent_token = parent_token;
        }
        TokenStream.prototype.restart = function() {
          this.__position = 0;
        };
        TokenStream.prototype.isEmpty = function() {
          return this.__tokens_length === 0;
        };
        TokenStream.prototype.hasNext = function() {
          return this.__position < this.__tokens_length;
        };
        TokenStream.prototype.next = function() {
          var val = null;
          if (this.hasNext()) {
            val = this.__tokens[this.__position];
            this.__position += 1;
          }
          return val;
        };
        TokenStream.prototype.peek = function(index) {
          var val = null;
          index = index || 0;
          index += this.__position;
          if (index >= 0 && index < this.__tokens_length) {
            val = this.__tokens[index];
          }
          return val;
        };
        TokenStream.prototype.add = function(token) {
          if (this.__parent_token) {
            token.parent = this.__parent_token;
          }
          this.__tokens.push(token);
          this.__tokens_length += 1;
        };
        module.exports.TokenStream = TokenStream;
      }),
      /* 11 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var Pattern = __webpack_require__2(12).Pattern;
        function WhitespacePattern(input_scanner, parent) {
          Pattern.call(this, input_scanner, parent);
          if (parent) {
            this._line_regexp = this._input.get_regexp(parent._line_regexp);
          } else {
            this.__set_whitespace_patterns("", "");
          }
          this.newline_count = 0;
          this.whitespace_before_token = "";
        }
        WhitespacePattern.prototype = new Pattern();
        WhitespacePattern.prototype.__set_whitespace_patterns = function(whitespace_chars, newline_chars) {
          whitespace_chars += "\\t ";
          newline_chars += "\\n\\r";
          this._match_pattern = this._input.get_regexp(
            "[" + whitespace_chars + newline_chars + "]+",
            true
          );
          this._newline_regexp = this._input.get_regexp(
            "\\r\\n|[" + newline_chars + "]"
          );
        };
        WhitespacePattern.prototype.read = function() {
          this.newline_count = 0;
          this.whitespace_before_token = "";
          var resulting_string = this._input.read(this._match_pattern);
          if (resulting_string === " ") {
            this.whitespace_before_token = " ";
          } else if (resulting_string) {
            var matches = this.__split(this._newline_regexp, resulting_string);
            this.newline_count = matches.length - 1;
            this.whitespace_before_token = matches[this.newline_count];
          }
          return resulting_string;
        };
        WhitespacePattern.prototype.matching = function(whitespace_chars, newline_chars) {
          var result = this._create();
          result.__set_whitespace_patterns(whitespace_chars, newline_chars);
          result._update();
          return result;
        };
        WhitespacePattern.prototype._create = function() {
          return new WhitespacePattern(this._input, this);
        };
        WhitespacePattern.prototype.__split = function(regexp, input_string) {
          regexp.lastIndex = 0;
          var start_index = 0;
          var result = [];
          var next_match = regexp.exec(input_string);
          while (next_match) {
            result.push(input_string.substring(start_index, next_match.index));
            start_index = next_match.index + next_match[0].length;
            next_match = regexp.exec(input_string);
          }
          if (start_index < input_string.length) {
            result.push(input_string.substring(start_index, input_string.length));
          } else {
            result.push("");
          }
          return result;
        };
        module.exports.WhitespacePattern = WhitespacePattern;
      }),
      /* 12 */
      /***/
      (function(module) {
        function Pattern(input_scanner, parent) {
          this._input = input_scanner;
          this._starting_pattern = null;
          this._match_pattern = null;
          this._until_pattern = null;
          this._until_after = false;
          if (parent) {
            this._starting_pattern = this._input.get_regexp(parent._starting_pattern, true);
            this._match_pattern = this._input.get_regexp(parent._match_pattern, true);
            this._until_pattern = this._input.get_regexp(parent._until_pattern);
            this._until_after = parent._until_after;
          }
        }
        Pattern.prototype.read = function() {
          var result = this._input.read(this._starting_pattern);
          if (!this._starting_pattern || result) {
            result += this._input.read(this._match_pattern, this._until_pattern, this._until_after);
          }
          return result;
        };
        Pattern.prototype.read_match = function() {
          return this._input.match(this._match_pattern);
        };
        Pattern.prototype.until_after = function(pattern) {
          var result = this._create();
          result._until_after = true;
          result._until_pattern = this._input.get_regexp(pattern);
          result._update();
          return result;
        };
        Pattern.prototype.until = function(pattern) {
          var result = this._create();
          result._until_after = false;
          result._until_pattern = this._input.get_regexp(pattern);
          result._update();
          return result;
        };
        Pattern.prototype.starting_with = function(pattern) {
          var result = this._create();
          result._starting_pattern = this._input.get_regexp(pattern, true);
          result._update();
          return result;
        };
        Pattern.prototype.matching = function(pattern) {
          var result = this._create();
          result._match_pattern = this._input.get_regexp(pattern, true);
          result._update();
          return result;
        };
        Pattern.prototype._create = function() {
          return new Pattern(this._input, this);
        };
        Pattern.prototype._update = function() {
        };
        module.exports.Pattern = Pattern;
      }),
      /* 13 */
      /***/
      (function(module) {
        function Directives(start_block_pattern, end_block_pattern) {
          start_block_pattern = typeof start_block_pattern === "string" ? start_block_pattern : start_block_pattern.source;
          end_block_pattern = typeof end_block_pattern === "string" ? end_block_pattern : end_block_pattern.source;
          this.__directives_block_pattern = new RegExp(start_block_pattern + / beautify( \w+[:]\w+)+ /.source + end_block_pattern, "g");
          this.__directive_pattern = / (\w+)[:](\w+)/g;
          this.__directives_end_ignore_pattern = new RegExp(start_block_pattern + /\sbeautify\signore:end\s/.source + end_block_pattern, "g");
        }
        Directives.prototype.get_directives = function(text) {
          if (!text.match(this.__directives_block_pattern)) {
            return null;
          }
          var directives = {};
          this.__directive_pattern.lastIndex = 0;
          var directive_match = this.__directive_pattern.exec(text);
          while (directive_match) {
            directives[directive_match[1]] = directive_match[2];
            directive_match = this.__directive_pattern.exec(text);
          }
          return directives;
        };
        Directives.prototype.readIgnored = function(input) {
          return input.readUntilAfter(this.__directives_end_ignore_pattern);
        };
        module.exports.Directives = Directives;
      }),
      /* 14 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var Pattern = __webpack_require__2(12).Pattern;
        var template_names = {
          django: false,
          erb: false,
          handlebars: false,
          php: false,
          smarty: false,
          angular: false
        };
        function TemplatablePattern(input_scanner, parent) {
          Pattern.call(this, input_scanner, parent);
          this.__template_pattern = null;
          this._disabled = Object.assign({}, template_names);
          this._excluded = Object.assign({}, template_names);
          if (parent) {
            this.__template_pattern = this._input.get_regexp(parent.__template_pattern);
            this._excluded = Object.assign(this._excluded, parent._excluded);
            this._disabled = Object.assign(this._disabled, parent._disabled);
          }
          var pattern = new Pattern(input_scanner);
          this.__patterns = {
            handlebars_comment: pattern.starting_with(/{{!--/).until_after(/--}}/),
            handlebars_unescaped: pattern.starting_with(/{{{/).until_after(/}}}/),
            handlebars: pattern.starting_with(/{{/).until_after(/}}/),
            php: pattern.starting_with(/<\?(?:[= ]|php)/).until_after(/\?>/),
            erb: pattern.starting_with(/<%[^%]/).until_after(/[^%]%>/),
            // django coflicts with handlebars a bit.
            django: pattern.starting_with(/{%/).until_after(/%}/),
            django_value: pattern.starting_with(/{{/).until_after(/}}/),
            django_comment: pattern.starting_with(/{#/).until_after(/#}/),
            smarty: pattern.starting_with(/{(?=[^}{\s\n])/).until_after(/[^\s\n]}/),
            smarty_comment: pattern.starting_with(/{\*/).until_after(/\*}/),
            smarty_literal: pattern.starting_with(/{literal}/).until_after(/{\/literal}/)
          };
        }
        TemplatablePattern.prototype = new Pattern();
        TemplatablePattern.prototype._create = function() {
          return new TemplatablePattern(this._input, this);
        };
        TemplatablePattern.prototype._update = function() {
          this.__set_templated_pattern();
        };
        TemplatablePattern.prototype.disable = function(language) {
          var result = this._create();
          result._disabled[language] = true;
          result._update();
          return result;
        };
        TemplatablePattern.prototype.read_options = function(options) {
          var result = this._create();
          for (var language in template_names) {
            result._disabled[language] = options.templating.indexOf(language) === -1;
          }
          result._update();
          return result;
        };
        TemplatablePattern.prototype.exclude = function(language) {
          var result = this._create();
          result._excluded[language] = true;
          result._update();
          return result;
        };
        TemplatablePattern.prototype.read = function() {
          var result = "";
          if (this._match_pattern) {
            result = this._input.read(this._starting_pattern);
          } else {
            result = this._input.read(this._starting_pattern, this.__template_pattern);
          }
          var next = this._read_template();
          while (next) {
            if (this._match_pattern) {
              next += this._input.read(this._match_pattern);
            } else {
              next += this._input.readUntil(this.__template_pattern);
            }
            result += next;
            next = this._read_template();
          }
          if (this._until_after) {
            result += this._input.readUntilAfter(this._until_pattern);
          }
          return result;
        };
        TemplatablePattern.prototype.__set_templated_pattern = function() {
          var items = [];
          if (!this._disabled.php) {
            items.push(this.__patterns.php._starting_pattern.source);
          }
          if (!this._disabled.handlebars) {
            items.push(this.__patterns.handlebars._starting_pattern.source);
          }
          if (!this._disabled.erb) {
            items.push(this.__patterns.erb._starting_pattern.source);
          }
          if (!this._disabled.django) {
            items.push(this.__patterns.django._starting_pattern.source);
            items.push(this.__patterns.django_value._starting_pattern.source);
            items.push(this.__patterns.django_comment._starting_pattern.source);
          }
          if (!this._disabled.smarty) {
            items.push(this.__patterns.smarty._starting_pattern.source);
          }
          if (this._until_pattern) {
            items.push(this._until_pattern.source);
          }
          this.__template_pattern = this._input.get_regexp("(?:" + items.join("|") + ")");
        };
        TemplatablePattern.prototype._read_template = function() {
          var resulting_string = "";
          var c = this._input.peek();
          if (c === "<") {
            var peek1 = this._input.peek(1);
            if (!this._disabled.php && !this._excluded.php && peek1 === "?") {
              resulting_string = resulting_string || this.__patterns.php.read();
            }
            if (!this._disabled.erb && !this._excluded.erb && peek1 === "%") {
              resulting_string = resulting_string || this.__patterns.erb.read();
            }
          } else if (c === "{") {
            if (!this._disabled.handlebars && !this._excluded.handlebars) {
              resulting_string = resulting_string || this.__patterns.handlebars_comment.read();
              resulting_string = resulting_string || this.__patterns.handlebars_unescaped.read();
              resulting_string = resulting_string || this.__patterns.handlebars.read();
            }
            if (!this._disabled.django) {
              if (!this._excluded.django && !this._excluded.handlebars) {
                resulting_string = resulting_string || this.__patterns.django_value.read();
              }
              if (!this._excluded.django) {
                resulting_string = resulting_string || this.__patterns.django_comment.read();
                resulting_string = resulting_string || this.__patterns.django.read();
              }
            }
            if (!this._disabled.smarty) {
              if (this._disabled.django && this._disabled.handlebars) {
                resulting_string = resulting_string || this.__patterns.smarty_comment.read();
                resulting_string = resulting_string || this.__patterns.smarty_literal.read();
                resulting_string = resulting_string || this.__patterns.smarty.read();
              }
            }
          }
          return resulting_string;
        };
        module.exports.TemplatablePattern = TemplatablePattern;
      }),
      ,
      ,
      ,
      /* 18 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var Beautifier = __webpack_require__2(19).Beautifier, Options = __webpack_require__2(20).Options;
        function style_html(html_source, options, js_beautify2, css_beautify2) {
          var beautifier = new Beautifier(html_source, options, js_beautify2, css_beautify2);
          return beautifier.beautify();
        }
        module.exports = style_html;
        module.exports.defaultOptions = function() {
          return new Options();
        };
      }),
      /* 19 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var Options = __webpack_require__2(20).Options;
        var Output = __webpack_require__2(2).Output;
        var Tokenizer = __webpack_require__2(21).Tokenizer;
        var TOKEN = __webpack_require__2(21).TOKEN;
        var lineBreak = /\r\n|[\r\n]/;
        var allLineBreaks = /\r\n|[\r\n]/g;
        var Printer = function(options, base_indent_string) {
          this.indent_level = 0;
          this.alignment_size = 0;
          this.max_preserve_newlines = options.max_preserve_newlines;
          this.preserve_newlines = options.preserve_newlines;
          this._output = new Output(options, base_indent_string);
        };
        Printer.prototype.current_line_has_match = function(pattern) {
          return this._output.current_line.has_match(pattern);
        };
        Printer.prototype.set_space_before_token = function(value, non_breaking) {
          this._output.space_before_token = value;
          this._output.non_breaking_space = non_breaking;
        };
        Printer.prototype.set_wrap_point = function() {
          this._output.set_indent(this.indent_level, this.alignment_size);
          this._output.set_wrap_point();
        };
        Printer.prototype.add_raw_token = function(token) {
          this._output.add_raw_token(token);
        };
        Printer.prototype.print_preserved_newlines = function(raw_token) {
          var newlines = 0;
          if (raw_token.type !== TOKEN.TEXT && raw_token.previous.type !== TOKEN.TEXT) {
            newlines = raw_token.newlines ? 1 : 0;
          }
          if (this.preserve_newlines) {
            newlines = raw_token.newlines < this.max_preserve_newlines + 1 ? raw_token.newlines : this.max_preserve_newlines + 1;
          }
          for (var n = 0; n < newlines; n++) {
            this.print_newline(n > 0);
          }
          return newlines !== 0;
        };
        Printer.prototype.traverse_whitespace = function(raw_token) {
          if (raw_token.whitespace_before || raw_token.newlines) {
            if (!this.print_preserved_newlines(raw_token)) {
              this._output.space_before_token = true;
            }
            return true;
          }
          return false;
        };
        Printer.prototype.previous_token_wrapped = function() {
          return this._output.previous_token_wrapped;
        };
        Printer.prototype.print_newline = function(force) {
          this._output.add_new_line(force);
        };
        Printer.prototype.print_token = function(token) {
          if (token.text) {
            this._output.set_indent(this.indent_level, this.alignment_size);
            this._output.add_token(token.text);
          }
        };
        Printer.prototype.indent = function() {
          this.indent_level++;
        };
        Printer.prototype.deindent = function() {
          if (this.indent_level > 0) {
            this.indent_level--;
            this._output.set_indent(this.indent_level, this.alignment_size);
          }
        };
        Printer.prototype.get_full_indent = function(level) {
          level = this.indent_level + (level || 0);
          if (level < 1) {
            return "";
          }
          return this._output.get_indent_string(level);
        };
        var get_type_attribute = function(start_token) {
          var result = null;
          var raw_token = start_token.next;
          while (raw_token.type !== TOKEN.EOF && start_token.closed !== raw_token) {
            if (raw_token.type === TOKEN.ATTRIBUTE && raw_token.text === "type") {
              if (raw_token.next && raw_token.next.type === TOKEN.EQUALS && raw_token.next.next && raw_token.next.next.type === TOKEN.VALUE) {
                result = raw_token.next.next.text;
              }
              break;
            }
            raw_token = raw_token.next;
          }
          return result;
        };
        var get_custom_beautifier_name = function(tag_check, raw_token) {
          var typeAttribute = null;
          var result = null;
          if (!raw_token.closed) {
            return null;
          }
          if (tag_check === "script") {
            typeAttribute = "text/javascript";
          } else if (tag_check === "style") {
            typeAttribute = "text/css";
          }
          typeAttribute = get_type_attribute(raw_token) || typeAttribute;
          if (typeAttribute.search("text/css") > -1) {
            result = "css";
          } else if (typeAttribute.search(/module|((text|application|dojo)\/(x-)?(javascript|ecmascript|jscript|livescript|(ld\+)?json|method|aspect))/) > -1) {
            result = "javascript";
          } else if (typeAttribute.search(/(text|application|dojo)\/(x-)?(html)/) > -1) {
            result = "html";
          } else if (typeAttribute.search(/test\/null/) > -1) {
            result = "null";
          }
          return result;
        };
        function in_array(what, arr) {
          return arr.indexOf(what) !== -1;
        }
        function TagFrame(parent, parser_token, indent_level) {
          this.parent = parent || null;
          this.tag = parser_token ? parser_token.tag_name : "";
          this.indent_level = indent_level || 0;
          this.parser_token = parser_token || null;
        }
        function TagStack(printer) {
          this._printer = printer;
          this._current_frame = null;
        }
        TagStack.prototype.get_parser_token = function() {
          return this._current_frame ? this._current_frame.parser_token : null;
        };
        TagStack.prototype.record_tag = function(parser_token) {
          var new_frame = new TagFrame(this._current_frame, parser_token, this._printer.indent_level);
          this._current_frame = new_frame;
        };
        TagStack.prototype._try_pop_frame = function(frame) {
          var parser_token = null;
          if (frame) {
            parser_token = frame.parser_token;
            this._printer.indent_level = frame.indent_level;
            this._current_frame = frame.parent;
          }
          return parser_token;
        };
        TagStack.prototype._get_frame = function(tag_list, stop_list) {
          var frame = this._current_frame;
          while (frame) {
            if (tag_list.indexOf(frame.tag) !== -1) {
              break;
            } else if (stop_list && stop_list.indexOf(frame.tag) !== -1) {
              frame = null;
              break;
            }
            frame = frame.parent;
          }
          return frame;
        };
        TagStack.prototype.try_pop = function(tag, stop_list) {
          var frame = this._get_frame([tag], stop_list);
          return this._try_pop_frame(frame);
        };
        TagStack.prototype.indent_to_tag = function(tag_list) {
          var frame = this._get_frame(tag_list);
          if (frame) {
            this._printer.indent_level = frame.indent_level;
          }
        };
        function Beautifier(source_text, options, js_beautify2, css_beautify2) {
          this._source_text = source_text || "";
          options = options || {};
          this._js_beautify = js_beautify2;
          this._css_beautify = css_beautify2;
          this._tag_stack = null;
          var optionHtml = new Options(options, "html");
          this._options = optionHtml;
          this._is_wrap_attributes_force = this._options.wrap_attributes.substr(0, "force".length) === "force";
          this._is_wrap_attributes_force_expand_multiline = this._options.wrap_attributes === "force-expand-multiline";
          this._is_wrap_attributes_force_aligned = this._options.wrap_attributes === "force-aligned";
          this._is_wrap_attributes_aligned_multiple = this._options.wrap_attributes === "aligned-multiple";
          this._is_wrap_attributes_preserve = this._options.wrap_attributes.substr(0, "preserve".length) === "preserve";
          this._is_wrap_attributes_preserve_aligned = this._options.wrap_attributes === "preserve-aligned";
        }
        Beautifier.prototype.beautify = function() {
          if (this._options.disabled) {
            return this._source_text;
          }
          var source_text = this._source_text;
          var eol = this._options.eol;
          if (this._options.eol === "auto") {
            eol = "\n";
            if (source_text && lineBreak.test(source_text)) {
              eol = source_text.match(lineBreak)[0];
            }
          }
          source_text = source_text.replace(allLineBreaks, "\n");
          var baseIndentString = source_text.match(/^[\t ]*/)[0];
          var last_token = {
            text: "",
            type: ""
          };
          var last_tag_token = new TagOpenParserToken();
          var printer = new Printer(this._options, baseIndentString);
          var tokens = new Tokenizer(source_text, this._options).tokenize();
          this._tag_stack = new TagStack(printer);
          var parser_token = null;
          var raw_token = tokens.next();
          while (raw_token.type !== TOKEN.EOF) {
            if (raw_token.type === TOKEN.TAG_OPEN || raw_token.type === TOKEN.COMMENT) {
              parser_token = this._handle_tag_open(printer, raw_token, last_tag_token, last_token, tokens);
              last_tag_token = parser_token;
            } else if (raw_token.type === TOKEN.ATTRIBUTE || raw_token.type === TOKEN.EQUALS || raw_token.type === TOKEN.VALUE || raw_token.type === TOKEN.TEXT && !last_tag_token.tag_complete) {
              parser_token = this._handle_inside_tag(printer, raw_token, last_tag_token, last_token);
            } else if (raw_token.type === TOKEN.TAG_CLOSE) {
              parser_token = this._handle_tag_close(printer, raw_token, last_tag_token);
            } else if (raw_token.type === TOKEN.TEXT) {
              parser_token = this._handle_text(printer, raw_token, last_tag_token);
            } else if (raw_token.type === TOKEN.CONTROL_FLOW_OPEN) {
              parser_token = this._handle_control_flow_open(printer, raw_token);
            } else if (raw_token.type === TOKEN.CONTROL_FLOW_CLOSE) {
              parser_token = this._handle_control_flow_close(printer, raw_token);
            } else {
              printer.add_raw_token(raw_token);
            }
            last_token = parser_token;
            raw_token = tokens.next();
          }
          var sweet_code = printer._output.get_code(eol);
          return sweet_code;
        };
        Beautifier.prototype._handle_control_flow_open = function(printer, raw_token) {
          var parser_token = {
            text: raw_token.text,
            type: raw_token.type
          };
          printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
          if (raw_token.newlines) {
            printer.print_preserved_newlines(raw_token);
          } else {
            printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
          }
          printer.print_token(raw_token);
          printer.indent();
          return parser_token;
        };
        Beautifier.prototype._handle_control_flow_close = function(printer, raw_token) {
          var parser_token = {
            text: raw_token.text,
            type: raw_token.type
          };
          printer.deindent();
          if (raw_token.newlines) {
            printer.print_preserved_newlines(raw_token);
          } else {
            printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
          }
          printer.print_token(raw_token);
          return parser_token;
        };
        Beautifier.prototype._handle_tag_close = function(printer, raw_token, last_tag_token) {
          var parser_token = {
            text: raw_token.text,
            type: raw_token.type
          };
          printer.alignment_size = 0;
          last_tag_token.tag_complete = true;
          printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
          if (last_tag_token.is_unformatted) {
            printer.add_raw_token(raw_token);
          } else {
            if (last_tag_token.tag_start_char === "<") {
              printer.set_space_before_token(raw_token.text[0] === "/", true);
              if (this._is_wrap_attributes_force_expand_multiline && last_tag_token.has_wrapped_attrs) {
                printer.print_newline(false);
              }
            }
            printer.print_token(raw_token);
          }
          if (last_tag_token.indent_content && !(last_tag_token.is_unformatted || last_tag_token.is_content_unformatted)) {
            printer.indent();
            last_tag_token.indent_content = false;
          }
          if (!last_tag_token.is_inline_element && !(last_tag_token.is_unformatted || last_tag_token.is_content_unformatted)) {
            printer.set_wrap_point();
          }
          return parser_token;
        };
        Beautifier.prototype._handle_inside_tag = function(printer, raw_token, last_tag_token, last_token) {
          var wrapped = last_tag_token.has_wrapped_attrs;
          var parser_token = {
            text: raw_token.text,
            type: raw_token.type
          };
          printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
          if (last_tag_token.is_unformatted) {
            printer.add_raw_token(raw_token);
          } else if (last_tag_token.tag_start_char === "{" && raw_token.type === TOKEN.TEXT) {
            if (printer.print_preserved_newlines(raw_token)) {
              raw_token.newlines = 0;
              printer.add_raw_token(raw_token);
            } else {
              printer.print_token(raw_token);
            }
          } else {
            if (raw_token.type === TOKEN.ATTRIBUTE) {
              printer.set_space_before_token(true);
            } else if (raw_token.type === TOKEN.EQUALS) {
              printer.set_space_before_token(false);
            } else if (raw_token.type === TOKEN.VALUE && raw_token.previous.type === TOKEN.EQUALS) {
              printer.set_space_before_token(false);
            }
            if (raw_token.type === TOKEN.ATTRIBUTE && last_tag_token.tag_start_char === "<") {
              if (this._is_wrap_attributes_preserve || this._is_wrap_attributes_preserve_aligned) {
                printer.traverse_whitespace(raw_token);
                wrapped = wrapped || raw_token.newlines !== 0;
              }
              if (this._is_wrap_attributes_force && last_tag_token.attr_count >= this._options.wrap_attributes_min_attrs && (last_token.type !== TOKEN.TAG_OPEN || // ie. second attribute and beyond
              this._is_wrap_attributes_force_expand_multiline)) {
                printer.print_newline(false);
                wrapped = true;
              }
            }
            printer.print_token(raw_token);
            wrapped = wrapped || printer.previous_token_wrapped();
            last_tag_token.has_wrapped_attrs = wrapped;
          }
          return parser_token;
        };
        Beautifier.prototype._handle_text = function(printer, raw_token, last_tag_token) {
          var parser_token = {
            text: raw_token.text,
            type: "TK_CONTENT"
          };
          if (last_tag_token.custom_beautifier_name) {
            this._print_custom_beatifier_text(printer, raw_token, last_tag_token);
          } else if (last_tag_token.is_unformatted || last_tag_token.is_content_unformatted) {
            printer.add_raw_token(raw_token);
          } else {
            printer.traverse_whitespace(raw_token);
            printer.print_token(raw_token);
          }
          return parser_token;
        };
        Beautifier.prototype._print_custom_beatifier_text = function(printer, raw_token, last_tag_token) {
          var local = this;
          if (raw_token.text !== "") {
            var text = raw_token.text, _beautifier, script_indent_level = 1, pre = "", post = "";
            if (last_tag_token.custom_beautifier_name === "javascript" && typeof this._js_beautify === "function") {
              _beautifier = this._js_beautify;
            } else if (last_tag_token.custom_beautifier_name === "css" && typeof this._css_beautify === "function") {
              _beautifier = this._css_beautify;
            } else if (last_tag_token.custom_beautifier_name === "html") {
              _beautifier = function(html_source, options) {
                var beautifier = new Beautifier(html_source, options, local._js_beautify, local._css_beautify);
                return beautifier.beautify();
              };
            }
            if (this._options.indent_scripts === "keep") {
              script_indent_level = 0;
            } else if (this._options.indent_scripts === "separate") {
              script_indent_level = -printer.indent_level;
            }
            var indentation = printer.get_full_indent(script_indent_level);
            text = text.replace(/\n[ \t]*$/, "");
            if (last_tag_token.custom_beautifier_name !== "html" && text[0] === "<" && text.match(/^(<!--|<!\[CDATA\[)/)) {
              var matched = /^(<!--[^\n]*|<!\[CDATA\[)(\n?)([ \t\n]*)([\s\S]*)(-->|]]>)$/.exec(text);
              if (!matched) {
                printer.add_raw_token(raw_token);
                return;
              }
              pre = indentation + matched[1] + "\n";
              text = matched[4];
              if (matched[5]) {
                post = indentation + matched[5];
              }
              text = text.replace(/\n[ \t]*$/, "");
              if (matched[2] || matched[3].indexOf("\n") !== -1) {
                matched = matched[3].match(/[ \t]+$/);
                if (matched) {
                  raw_token.whitespace_before = matched[0];
                }
              }
            }
            if (text) {
              if (_beautifier) {
                var Child_options = function() {
                  this.eol = "\n";
                };
                Child_options.prototype = this._options.raw_options;
                var child_options = new Child_options();
                text = _beautifier(indentation + text, child_options);
              } else {
                var white = raw_token.whitespace_before;
                if (white) {
                  text = text.replace(new RegExp("\n(" + white + ")?", "g"), "\n");
                }
                text = indentation + text.replace(/\n/g, "\n" + indentation);
              }
            }
            if (pre) {
              if (!text) {
                text = pre + post;
              } else {
                text = pre + text + "\n" + post;
              }
            }
            printer.print_newline(false);
            if (text) {
              raw_token.text = text;
              raw_token.whitespace_before = "";
              raw_token.newlines = 0;
              printer.add_raw_token(raw_token);
              printer.print_newline(true);
            }
          }
        };
        Beautifier.prototype._handle_tag_open = function(printer, raw_token, last_tag_token, last_token, tokens) {
          var parser_token = this._get_tag_open_token(raw_token);
          if ((last_tag_token.is_unformatted || last_tag_token.is_content_unformatted) && !last_tag_token.is_empty_element && raw_token.type === TOKEN.TAG_OPEN && !parser_token.is_start_tag) {
            printer.add_raw_token(raw_token);
            parser_token.start_tag_token = this._tag_stack.try_pop(parser_token.tag_name);
          } else {
            printer.traverse_whitespace(raw_token);
            this._set_tag_position(printer, raw_token, parser_token, last_tag_token, last_token);
            if (!parser_token.is_inline_element) {
              printer.set_wrap_point();
            }
            printer.print_token(raw_token);
          }
          if (parser_token.is_start_tag && this._is_wrap_attributes_force) {
            var peek_index = 0;
            var peek_token;
            do {
              peek_token = tokens.peek(peek_index);
              if (peek_token.type === TOKEN.ATTRIBUTE) {
                parser_token.attr_count += 1;
              }
              peek_index += 1;
            } while (peek_token.type !== TOKEN.EOF && peek_token.type !== TOKEN.TAG_CLOSE);
          }
          if (this._is_wrap_attributes_force_aligned || this._is_wrap_attributes_aligned_multiple || this._is_wrap_attributes_preserve_aligned) {
            parser_token.alignment_size = raw_token.text.length + 1;
          }
          if (!parser_token.tag_complete && !parser_token.is_unformatted) {
            printer.alignment_size = parser_token.alignment_size;
          }
          return parser_token;
        };
        var TagOpenParserToken = function(parent, raw_token) {
          this.parent = parent || null;
          this.text = "";
          this.type = "TK_TAG_OPEN";
          this.tag_name = "";
          this.is_inline_element = false;
          this.is_unformatted = false;
          this.is_content_unformatted = false;
          this.is_empty_element = false;
          this.is_start_tag = false;
          this.is_end_tag = false;
          this.indent_content = false;
          this.multiline_content = false;
          this.custom_beautifier_name = null;
          this.start_tag_token = null;
          this.attr_count = 0;
          this.has_wrapped_attrs = false;
          this.alignment_size = 0;
          this.tag_complete = false;
          this.tag_start_char = "";
          this.tag_check = "";
          if (!raw_token) {
            this.tag_complete = true;
          } else {
            var tag_check_match;
            this.tag_start_char = raw_token.text[0];
            this.text = raw_token.text;
            if (this.tag_start_char === "<") {
              tag_check_match = raw_token.text.match(/^<([^\s>]*)/);
              this.tag_check = tag_check_match ? tag_check_match[1] : "";
            } else {
              tag_check_match = raw_token.text.match(/^{{~?(?:[\^]|#\*?)?([^\s}]+)/);
              this.tag_check = tag_check_match ? tag_check_match[1] : "";
              if ((raw_token.text.startsWith("{{#>") || raw_token.text.startsWith("{{~#>")) && this.tag_check[0] === ">") {
                if (this.tag_check === ">" && raw_token.next !== null) {
                  this.tag_check = raw_token.next.text.split(" ")[0];
                } else {
                  this.tag_check = raw_token.text.split(">")[1];
                }
              }
            }
            this.tag_check = this.tag_check.toLowerCase();
            if (raw_token.type === TOKEN.COMMENT) {
              this.tag_complete = true;
            }
            this.is_start_tag = this.tag_check.charAt(0) !== "/";
            this.tag_name = !this.is_start_tag ? this.tag_check.substr(1) : this.tag_check;
            this.is_end_tag = !this.is_start_tag || raw_token.closed && raw_token.closed.text === "/>";
            var handlebar_starts = 2;
            if (this.tag_start_char === "{" && this.text.length >= 3) {
              if (this.text.charAt(2) === "~") {
                handlebar_starts = 3;
              }
            }
            this.is_end_tag = this.is_end_tag || this.tag_start_char === "{" && (this.text.length < 3 || /[^#\^]/.test(this.text.charAt(handlebar_starts)));
          }
        };
        Beautifier.prototype._get_tag_open_token = function(raw_token) {
          var parser_token = new TagOpenParserToken(this._tag_stack.get_parser_token(), raw_token);
          parser_token.alignment_size = this._options.wrap_attributes_indent_size;
          parser_token.is_end_tag = parser_token.is_end_tag || in_array(parser_token.tag_check, this._options.void_elements);
          parser_token.is_empty_element = parser_token.tag_complete || parser_token.is_start_tag && parser_token.is_end_tag;
          parser_token.is_unformatted = !parser_token.tag_complete && in_array(parser_token.tag_check, this._options.unformatted);
          parser_token.is_content_unformatted = !parser_token.is_empty_element && in_array(parser_token.tag_check, this._options.content_unformatted);
          parser_token.is_inline_element = in_array(parser_token.tag_name, this._options.inline) || this._options.inline_custom_elements && parser_token.tag_name.includes("-") || parser_token.tag_start_char === "{";
          return parser_token;
        };
        Beautifier.prototype._set_tag_position = function(printer, raw_token, parser_token, last_tag_token, last_token) {
          if (!parser_token.is_empty_element) {
            if (parser_token.is_end_tag) {
              parser_token.start_tag_token = this._tag_stack.try_pop(parser_token.tag_name);
            } else {
              if (this._do_optional_end_element(parser_token)) {
                if (!parser_token.is_inline_element) {
                  printer.print_newline(false);
                }
              }
              this._tag_stack.record_tag(parser_token);
              if ((parser_token.tag_name === "script" || parser_token.tag_name === "style") && !(parser_token.is_unformatted || parser_token.is_content_unformatted)) {
                parser_token.custom_beautifier_name = get_custom_beautifier_name(parser_token.tag_check, raw_token);
              }
            }
          }
          if (in_array(parser_token.tag_check, this._options.extra_liners)) {
            printer.print_newline(false);
            if (!printer._output.just_added_blankline()) {
              printer.print_newline(true);
            }
          }
          if (parser_token.is_empty_element) {
            if (parser_token.tag_start_char === "{" && parser_token.tag_check === "else") {
              this._tag_stack.indent_to_tag(["if", "unless", "each"]);
              parser_token.indent_content = true;
              var foundIfOnCurrentLine = printer.current_line_has_match(/{{#if/);
              if (!foundIfOnCurrentLine) {
                printer.print_newline(false);
              }
            }
            if (parser_token.tag_name === "!--" && last_token.type === TOKEN.TAG_CLOSE && last_tag_token.is_end_tag && parser_token.text.indexOf("\n") === -1) ;
            else {
              if (!(parser_token.is_inline_element || parser_token.is_unformatted)) {
                printer.print_newline(false);
              }
              this._calcluate_parent_multiline(printer, parser_token);
            }
          } else if (parser_token.is_end_tag) {
            var do_end_expand = false;
            do_end_expand = parser_token.start_tag_token && parser_token.start_tag_token.multiline_content;
            do_end_expand = do_end_expand || !parser_token.is_inline_element && !(last_tag_token.is_inline_element || last_tag_token.is_unformatted) && !(last_token.type === TOKEN.TAG_CLOSE && parser_token.start_tag_token === last_tag_token) && last_token.type !== "TK_CONTENT";
            if (parser_token.is_content_unformatted || parser_token.is_unformatted) {
              do_end_expand = false;
            }
            if (do_end_expand) {
              printer.print_newline(false);
            }
          } else {
            parser_token.indent_content = !parser_token.custom_beautifier_name;
            if (parser_token.tag_start_char === "<") {
              if (parser_token.tag_name === "html") {
                parser_token.indent_content = this._options.indent_inner_html;
              } else if (parser_token.tag_name === "head") {
                parser_token.indent_content = this._options.indent_head_inner_html;
              } else if (parser_token.tag_name === "body") {
                parser_token.indent_content = this._options.indent_body_inner_html;
              }
            }
            if (!(parser_token.is_inline_element || parser_token.is_unformatted) && (last_token.type !== "TK_CONTENT" || parser_token.is_content_unformatted)) {
              printer.print_newline(false);
            }
            this._calcluate_parent_multiline(printer, parser_token);
          }
        };
        Beautifier.prototype._calcluate_parent_multiline = function(printer, parser_token) {
          if (parser_token.parent && printer._output.just_added_newline() && !((parser_token.is_inline_element || parser_token.is_unformatted) && parser_token.parent.is_inline_element)) {
            parser_token.parent.multiline_content = true;
          }
        };
        var p_closers = ["address", "article", "aside", "blockquote", "details", "div", "dl", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hr", "main", "menu", "nav", "ol", "p", "pre", "section", "table", "ul"];
        var p_parent_excludes = ["a", "audio", "del", "ins", "map", "noscript", "video"];
        Beautifier.prototype._do_optional_end_element = function(parser_token) {
          var result = null;
          if (parser_token.is_empty_element || !parser_token.is_start_tag || !parser_token.parent) {
            return;
          }
          if (parser_token.tag_name === "body") {
            result = result || this._tag_stack.try_pop("head");
          } else if (parser_token.tag_name === "li") {
            result = result || this._tag_stack.try_pop("li", ["ol", "ul", "menu"]);
          } else if (parser_token.tag_name === "dd" || parser_token.tag_name === "dt") {
            result = result || this._tag_stack.try_pop("dt", ["dl"]);
            result = result || this._tag_stack.try_pop("dd", ["dl"]);
          } else if (parser_token.parent.tag_name === "p" && p_closers.indexOf(parser_token.tag_name) !== -1) {
            var p_parent = parser_token.parent.parent;
            if (!p_parent || p_parent_excludes.indexOf(p_parent.tag_name) === -1) {
              result = result || this._tag_stack.try_pop("p");
            }
          } else if (parser_token.tag_name === "rp" || parser_token.tag_name === "rt") {
            result = result || this._tag_stack.try_pop("rt", ["ruby", "rtc"]);
            result = result || this._tag_stack.try_pop("rp", ["ruby", "rtc"]);
          } else if (parser_token.tag_name === "optgroup") {
            result = result || this._tag_stack.try_pop("optgroup", ["select"]);
          } else if (parser_token.tag_name === "option") {
            result = result || this._tag_stack.try_pop("option", ["select", "datalist", "optgroup"]);
          } else if (parser_token.tag_name === "colgroup") {
            result = result || this._tag_stack.try_pop("caption", ["table"]);
          } else if (parser_token.tag_name === "thead") {
            result = result || this._tag_stack.try_pop("caption", ["table"]);
            result = result || this._tag_stack.try_pop("colgroup", ["table"]);
          } else if (parser_token.tag_name === "tbody" || parser_token.tag_name === "tfoot") {
            result = result || this._tag_stack.try_pop("caption", ["table"]);
            result = result || this._tag_stack.try_pop("colgroup", ["table"]);
            result = result || this._tag_stack.try_pop("thead", ["table"]);
            result = result || this._tag_stack.try_pop("tbody", ["table"]);
          } else if (parser_token.tag_name === "tr") {
            result = result || this._tag_stack.try_pop("caption", ["table"]);
            result = result || this._tag_stack.try_pop("colgroup", ["table"]);
            result = result || this._tag_stack.try_pop("tr", ["table", "thead", "tbody", "tfoot"]);
          } else if (parser_token.tag_name === "th" || parser_token.tag_name === "td") {
            result = result || this._tag_stack.try_pop("td", ["table", "thead", "tbody", "tfoot", "tr"]);
            result = result || this._tag_stack.try_pop("th", ["table", "thead", "tbody", "tfoot", "tr"]);
          }
          parser_token.parent = this._tag_stack.get_parser_token();
          return result;
        };
        module.exports.Beautifier = Beautifier;
      }),
      /* 20 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var BaseOptions = __webpack_require__2(6).Options;
        function Options(options) {
          BaseOptions.call(this, options, "html");
          if (this.templating.length === 1 && this.templating[0] === "auto") {
            this.templating = ["django", "erb", "handlebars", "php"];
          }
          this.indent_inner_html = this._get_boolean("indent_inner_html");
          this.indent_body_inner_html = this._get_boolean("indent_body_inner_html", true);
          this.indent_head_inner_html = this._get_boolean("indent_head_inner_html", true);
          this.indent_handlebars = this._get_boolean("indent_handlebars", true);
          this.wrap_attributes = this._get_selection(
            "wrap_attributes",
            ["auto", "force", "force-aligned", "force-expand-multiline", "aligned-multiple", "preserve", "preserve-aligned"]
          );
          this.wrap_attributes_min_attrs = this._get_number("wrap_attributes_min_attrs", 2);
          this.wrap_attributes_indent_size = this._get_number("wrap_attributes_indent_size", this.indent_size);
          this.extra_liners = this._get_array("extra_liners", ["head", "body", "/html"]);
          this.inline = this._get_array("inline", [
            "a",
            "abbr",
            "area",
            "audio",
            "b",
            "bdi",
            "bdo",
            "br",
            "button",
            "canvas",
            "cite",
            "code",
            "data",
            "datalist",
            "del",
            "dfn",
            "em",
            "embed",
            "i",
            "iframe",
            "img",
            "input",
            "ins",
            "kbd",
            "keygen",
            "label",
            "map",
            "mark",
            "math",
            "meter",
            "noscript",
            "object",
            "output",
            "progress",
            "q",
            "ruby",
            "s",
            "samp",
            /* 'script', */
            "select",
            "small",
            "span",
            "strong",
            "sub",
            "sup",
            "svg",
            "template",
            "textarea",
            "time",
            "u",
            "var",
            "video",
            "wbr",
            "text",
            // obsolete inline tags
            "acronym",
            "big",
            "strike",
            "tt"
          ]);
          this.inline_custom_elements = this._get_boolean("inline_custom_elements", true);
          this.void_elements = this._get_array("void_elements", [
            // HTLM void elements - aka self-closing tags - aka singletons
            // https://www.w3.org/html/wg/drafts/html/master/syntax.html#void-elements
            "area",
            "base",
            "br",
            "col",
            "embed",
            "hr",
            "img",
            "input",
            "keygen",
            "link",
            "menuitem",
            "meta",
            "param",
            "source",
            "track",
            "wbr",
            // NOTE: Optional tags are too complex for a simple list
            // they are hard coded in _do_optional_end_element
            // Doctype and xml elements
            "!doctype",
            "?xml",
            // obsolete tags
            // basefont: https://www.computerhope.com/jargon/h/html-basefont-tag.htm
            // isndex: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/isindex
            "basefont",
            "isindex"
          ]);
          this.unformatted = this._get_array("unformatted", []);
          this.content_unformatted = this._get_array("content_unformatted", [
            "pre",
            "textarea"
          ]);
          this.unformatted_content_delimiter = this._get_characters("unformatted_content_delimiter");
          this.indent_scripts = this._get_selection("indent_scripts", ["normal", "keep", "separate"]);
        }
        Options.prototype = new BaseOptions();
        module.exports.Options = Options;
      }),
      /* 21 */
      /***/
      (function(module, __unused_webpack_exports, __webpack_require__2) {
        var BaseTokenizer = __webpack_require__2(9).Tokenizer;
        var BASETOKEN = __webpack_require__2(9).TOKEN;
        var Directives = __webpack_require__2(13).Directives;
        var TemplatablePattern = __webpack_require__2(14).TemplatablePattern;
        var Pattern = __webpack_require__2(12).Pattern;
        var TOKEN = {
          TAG_OPEN: "TK_TAG_OPEN",
          TAG_CLOSE: "TK_TAG_CLOSE",
          CONTROL_FLOW_OPEN: "TK_CONTROL_FLOW_OPEN",
          CONTROL_FLOW_CLOSE: "TK_CONTROL_FLOW_CLOSE",
          ATTRIBUTE: "TK_ATTRIBUTE",
          EQUALS: "TK_EQUALS",
          VALUE: "TK_VALUE",
          COMMENT: "TK_COMMENT",
          TEXT: "TK_TEXT",
          UNKNOWN: "TK_UNKNOWN",
          START: BASETOKEN.START,
          RAW: BASETOKEN.RAW,
          EOF: BASETOKEN.EOF
        };
        var directives_core = new Directives(/<\!--/, /-->/);
        var Tokenizer = function(input_string, options) {
          BaseTokenizer.call(this, input_string, options);
          this._current_tag_name = "";
          var templatable_reader = new TemplatablePattern(this._input).read_options(this._options);
          var pattern_reader = new Pattern(this._input);
          this.__patterns = {
            word: templatable_reader.until(/[\n\r\t <]/),
            word_control_flow_close_excluded: templatable_reader.until(/[\n\r\t <}]/),
            single_quote: templatable_reader.until_after(/'/),
            double_quote: templatable_reader.until_after(/"/),
            attribute: templatable_reader.until(/[\n\r\t =>]|\/>/),
            element_name: templatable_reader.until(/[\n\r\t >\/]/),
            angular_control_flow_start: pattern_reader.matching(/\@[a-zA-Z]+[^({]*[({]/),
            handlebars_comment: pattern_reader.starting_with(/{{!--/).until_after(/--}}/),
            handlebars: pattern_reader.starting_with(/{{/).until_after(/}}/),
            handlebars_open: pattern_reader.until(/[\n\r\t }]/),
            handlebars_raw_close: pattern_reader.until(/}}/),
            comment: pattern_reader.starting_with(/<!--/).until_after(/-->/),
            cdata: pattern_reader.starting_with(/<!\[CDATA\[/).until_after(/]]>/),
            // https://en.wikipedia.org/wiki/Conditional_comment
            conditional_comment: pattern_reader.starting_with(/<!\[/).until_after(/]>/),
            processing: pattern_reader.starting_with(/<\?/).until_after(/\?>/)
          };
          if (this._options.indent_handlebars) {
            this.__patterns.word = this.__patterns.word.exclude("handlebars");
            this.__patterns.word_control_flow_close_excluded = this.__patterns.word_control_flow_close_excluded.exclude("handlebars");
          }
          this._unformatted_content_delimiter = null;
          if (this._options.unformatted_content_delimiter) {
            var literal_regexp = this._input.get_literal_regexp(this._options.unformatted_content_delimiter);
            this.__patterns.unformatted_content_delimiter = pattern_reader.matching(literal_regexp).until_after(literal_regexp);
          }
        };
        Tokenizer.prototype = new BaseTokenizer();
        Tokenizer.prototype._is_comment = function(current_token) {
          return false;
        };
        Tokenizer.prototype._is_opening = function(current_token) {
          return current_token.type === TOKEN.TAG_OPEN || current_token.type === TOKEN.CONTROL_FLOW_OPEN;
        };
        Tokenizer.prototype._is_closing = function(current_token, open_token) {
          return current_token.type === TOKEN.TAG_CLOSE && (open_token && ((current_token.text === ">" || current_token.text === "/>") && open_token.text[0] === "<" || current_token.text === "}}" && open_token.text[0] === "{" && open_token.text[1] === "{")) || current_token.type === TOKEN.CONTROL_FLOW_CLOSE && (current_token.text === "}" && open_token.text.endsWith("{"));
        };
        Tokenizer.prototype._reset = function() {
          this._current_tag_name = "";
        };
        Tokenizer.prototype._get_next_token = function(previous_token, open_token) {
          var token = null;
          this._readWhitespace();
          var c = this._input.peek();
          if (c === null) {
            return this._create_token(TOKEN.EOF, "");
          }
          token = token || this._read_open_handlebars(c, open_token);
          token = token || this._read_attribute(c, previous_token, open_token);
          token = token || this._read_close(c, open_token);
          token = token || this._read_control_flows(c, open_token);
          token = token || this._read_raw_content(c, previous_token, open_token);
          token = token || this._read_content_word(c, open_token);
          token = token || this._read_comment_or_cdata(c);
          token = token || this._read_processing(c);
          token = token || this._read_open(c, open_token);
          token = token || this._create_token(TOKEN.UNKNOWN, this._input.next());
          return token;
        };
        Tokenizer.prototype._read_comment_or_cdata = function(c) {
          var token = null;
          var resulting_string = null;
          var directives = null;
          if (c === "<") {
            var peek1 = this._input.peek(1);
            if (peek1 === "!") {
              resulting_string = this.__patterns.comment.read();
              if (resulting_string) {
                directives = directives_core.get_directives(resulting_string);
                if (directives && directives.ignore === "start") {
                  resulting_string += directives_core.readIgnored(this._input);
                }
              } else {
                resulting_string = this.__patterns.cdata.read();
              }
            }
            if (resulting_string) {
              token = this._create_token(TOKEN.COMMENT, resulting_string);
              token.directives = directives;
            }
          }
          return token;
        };
        Tokenizer.prototype._read_processing = function(c) {
          var token = null;
          var resulting_string = null;
          var directives = null;
          if (c === "<") {
            var peek1 = this._input.peek(1);
            if (peek1 === "!" || peek1 === "?") {
              resulting_string = this.__patterns.conditional_comment.read();
              resulting_string = resulting_string || this.__patterns.processing.read();
            }
            if (resulting_string) {
              token = this._create_token(TOKEN.COMMENT, resulting_string);
              token.directives = directives;
            }
          }
          return token;
        };
        Tokenizer.prototype._read_open = function(c, open_token) {
          var resulting_string = null;
          var token = null;
          if (!open_token || open_token.type === TOKEN.CONTROL_FLOW_OPEN) {
            if (c === "<") {
              resulting_string = this._input.next();
              if (this._input.peek() === "/") {
                resulting_string += this._input.next();
              }
              resulting_string += this.__patterns.element_name.read();
              token = this._create_token(TOKEN.TAG_OPEN, resulting_string);
            }
          }
          return token;
        };
        Tokenizer.prototype._read_open_handlebars = function(c, open_token) {
          var resulting_string = null;
          var token = null;
          if (!open_token || open_token.type === TOKEN.CONTROL_FLOW_OPEN) {
            if (this._options.indent_handlebars && c === "{" && this._input.peek(1) === "{") {
              if (this._input.peek(2) === "!") {
                resulting_string = this.__patterns.handlebars_comment.read();
                resulting_string = resulting_string || this.__patterns.handlebars.read();
                token = this._create_token(TOKEN.COMMENT, resulting_string);
              } else {
                resulting_string = this.__patterns.handlebars_open.read();
                token = this._create_token(TOKEN.TAG_OPEN, resulting_string);
              }
            }
          }
          return token;
        };
        Tokenizer.prototype._read_control_flows = function(c, open_token) {
          var resulting_string = "";
          var token = null;
          if (!this._options.templating.includes("angular") || !this._options.indent_handlebars) {
            return token;
          }
          if (c === "@") {
            resulting_string = this.__patterns.angular_control_flow_start.read();
            if (resulting_string === "") {
              return token;
            }
            var opening_parentheses_count = resulting_string.endsWith("(") ? 1 : 0;
            var closing_parentheses_count = 0;
            while (!(resulting_string.endsWith("{") && opening_parentheses_count === closing_parentheses_count)) {
              var next_char = this._input.next();
              if (next_char === null) {
                break;
              } else if (next_char === "(") {
                opening_parentheses_count++;
              } else if (next_char === ")") {
                closing_parentheses_count++;
              }
              resulting_string += next_char;
            }
            token = this._create_token(TOKEN.CONTROL_FLOW_OPEN, resulting_string);
          } else if (c === "}" && open_token && open_token.type === TOKEN.CONTROL_FLOW_OPEN) {
            resulting_string = this._input.next();
            token = this._create_token(TOKEN.CONTROL_FLOW_CLOSE, resulting_string);
          }
          return token;
        };
        Tokenizer.prototype._read_close = function(c, open_token) {
          var resulting_string = null;
          var token = null;
          if (open_token && open_token.type === TOKEN.TAG_OPEN) {
            if (open_token.text[0] === "<" && (c === ">" || c === "/" && this._input.peek(1) === ">")) {
              resulting_string = this._input.next();
              if (c === "/") {
                resulting_string += this._input.next();
              }
              token = this._create_token(TOKEN.TAG_CLOSE, resulting_string);
            } else if (open_token.text[0] === "{" && c === "}" && this._input.peek(1) === "}") {
              this._input.next();
              this._input.next();
              token = this._create_token(TOKEN.TAG_CLOSE, "}}");
            }
          }
          return token;
        };
        Tokenizer.prototype._read_attribute = function(c, previous_token, open_token) {
          var token = null;
          var resulting_string = "";
          if (open_token && open_token.text[0] === "<") {
            if (c === "=") {
              token = this._create_token(TOKEN.EQUALS, this._input.next());
            } else if (c === '"' || c === "'") {
              var content = this._input.next();
              if (c === '"') {
                content += this.__patterns.double_quote.read();
              } else {
                content += this.__patterns.single_quote.read();
              }
              token = this._create_token(TOKEN.VALUE, content);
            } else {
              resulting_string = this.__patterns.attribute.read();
              if (resulting_string) {
                if (previous_token.type === TOKEN.EQUALS) {
                  token = this._create_token(TOKEN.VALUE, resulting_string);
                } else {
                  token = this._create_token(TOKEN.ATTRIBUTE, resulting_string);
                }
              }
            }
          }
          return token;
        };
        Tokenizer.prototype._is_content_unformatted = function(tag_name) {
          return this._options.void_elements.indexOf(tag_name) === -1 && (this._options.content_unformatted.indexOf(tag_name) !== -1 || this._options.unformatted.indexOf(tag_name) !== -1);
        };
        Tokenizer.prototype._read_raw_content = function(c, previous_token, open_token) {
          var resulting_string = "";
          if (open_token && open_token.text[0] === "{") {
            resulting_string = this.__patterns.handlebars_raw_close.read();
          } else if (previous_token.type === TOKEN.TAG_CLOSE && previous_token.opened.text[0] === "<" && previous_token.text[0] !== "/") {
            var tag_name = previous_token.opened.text.substr(1).toLowerCase();
            if (tag_name === "script" || tag_name === "style") {
              var token = this._read_comment_or_cdata(c);
              if (token) {
                token.type = TOKEN.TEXT;
                return token;
              }
              resulting_string = this._input.readUntil(new RegExp("</" + tag_name + "[\\n\\r\\t ]*?>", "ig"));
            } else if (this._is_content_unformatted(tag_name)) {
              resulting_string = this._input.readUntil(new RegExp("</" + tag_name + "[\\n\\r\\t ]*?>", "ig"));
            }
          }
          if (resulting_string) {
            return this._create_token(TOKEN.TEXT, resulting_string);
          }
          return null;
        };
        Tokenizer.prototype._read_content_word = function(c, open_token) {
          var resulting_string = "";
          if (this._options.unformatted_content_delimiter) {
            if (c === this._options.unformatted_content_delimiter[0]) {
              resulting_string = this.__patterns.unformatted_content_delimiter.read();
            }
          }
          if (!resulting_string) {
            resulting_string = open_token && open_token.type === TOKEN.CONTROL_FLOW_OPEN ? this.__patterns.word_control_flow_close_excluded.read() : this.__patterns.word.read();
          }
          if (resulting_string) {
            return this._create_token(TOKEN.TEXT, resulting_string);
          }
        };
        module.exports.Tokenizer = Tokenizer;
        module.exports.TOKEN = TOKEN;
      })
      /******/
    ];
    var __webpack_module_cache__ = {};
    function __webpack_require__(moduleId) {
      var cachedModule = __webpack_module_cache__[moduleId];
      if (cachedModule !== void 0) {
        return cachedModule.exports;
      }
      var module = __webpack_module_cache__[moduleId] = {
        /******/
        // no module.id needed
        /******/
        // no module.loaded needed
        /******/
        exports: {}
        /******/
      };
      __webpack_modules__[moduleId](module, module.exports, __webpack_require__);
      return module.exports;
    }
    var __webpack_exports__ = __webpack_require__(18);
    legacy_beautify_html = __webpack_exports__;
  })();
  function html_beautify(html_source, options) {
    return legacy_beautify_html(html_source, options, js_beautify, css_beautify);
  }
  function format(document2, range, options) {
    let value = document2.getText();
    let includesEnd = true;
    let initialIndentLevel = 0;
    const tabSize = options.tabSize || 4;
    if (range) {
      let startOffset = document2.offsetAt(range.start);
      let extendedStart = startOffset;
      while (extendedStart > 0 && isWhitespace(value, extendedStart - 1)) {
        extendedStart--;
      }
      if (extendedStart === 0 || isEOL(value, extendedStart - 1)) {
        startOffset = extendedStart;
      } else {
        if (extendedStart < startOffset) {
          startOffset = extendedStart + 1;
        }
      }
      let endOffset = document2.offsetAt(range.end);
      let extendedEnd = endOffset;
      while (extendedEnd < value.length && isWhitespace(value, extendedEnd)) {
        extendedEnd++;
      }
      if (extendedEnd === value.length || isEOL(value, extendedEnd)) {
        endOffset = extendedEnd;
      }
      range = Range.create(document2.positionAt(startOffset), document2.positionAt(endOffset));
      const firstHalf = value.substring(0, startOffset);
      if (new RegExp(/.*[<][^>]*$/).test(firstHalf)) {
        value = value.substring(startOffset, endOffset);
        return [{
          range,
          newText: value
        }];
      }
      includesEnd = endOffset === value.length;
      value = value.substring(startOffset, endOffset);
      if (startOffset !== 0) {
        const startOfLineOffset = document2.offsetAt(Position.create(range.start.line, 0));
        initialIndentLevel = computeIndentLevel(document2.getText(), startOfLineOffset, options);
      }
    } else {
      range = Range.create(Position.create(0, 0), document2.positionAt(value.length));
    }
    const htmlOptions = {
      indent_size: tabSize,
      indent_char: options.insertSpaces ? " " : "	",
      indent_empty_lines: getFormatOption(options, "indentEmptyLines", false),
      wrap_line_length: getFormatOption(options, "wrapLineLength", 120),
      unformatted: getTagsFormatOption(options, "unformatted", void 0),
      content_unformatted: getTagsFormatOption(options, "contentUnformatted", void 0),
      indent_inner_html: getFormatOption(options, "indentInnerHtml", false),
      preserve_newlines: getFormatOption(options, "preserveNewLines", true),
      max_preserve_newlines: getFormatOption(options, "maxPreserveNewLines", 32786),
      indent_handlebars: getFormatOption(options, "indentHandlebars", false),
      end_with_newline: includesEnd && getFormatOption(options, "endWithNewline", false),
      extra_liners: getTagsFormatOption(options, "extraLiners", void 0),
      wrap_attributes: getFormatOption(options, "wrapAttributes", "auto"),
      wrap_attributes_indent_size: getFormatOption(options, "wrapAttributesIndentSize", void 0),
      eol: "\n",
      indent_scripts: getFormatOption(options, "indentScripts", "normal"),
      templating: getTemplatingFormatOption(options, "all"),
      unformatted_content_delimiter: getFormatOption(options, "unformattedContentDelimiter", "")
    };
    let result = html_beautify(trimLeft(value), htmlOptions);
    if (initialIndentLevel > 0) {
      const indent = options.insertSpaces ? repeat(" ", tabSize * initialIndentLevel) : repeat("	", initialIndentLevel);
      result = result.split("\n").join("\n" + indent);
      if (range.start.character === 0) {
        result = indent + result;
      }
    }
    return [{
      range,
      newText: result
    }];
  }
  function trimLeft(str) {
    return str.replace(/^\s+/, "");
  }
  function getFormatOption(options, key, dflt) {
    if (options && options.hasOwnProperty(key)) {
      const value = options[key];
      if (value !== null) {
        return value;
      }
    }
    return dflt;
  }
  function getTagsFormatOption(options, key, dflt) {
    const list = getFormatOption(options, key, null);
    if (typeof list === "string") {
      if (list.length > 0) {
        return list.split(",").map((t2) => t2.trim().toLowerCase());
      }
      return [];
    }
    return dflt;
  }
  function getTemplatingFormatOption(options, dflt) {
    const value = getFormatOption(options, "templating", dflt);
    if (value === true) {
      return ["auto"];
    }
    if (value === false || value === dflt || Array.isArray(value) === false) {
      return ["none"];
    }
    return value;
  }
  function computeIndentLevel(content, offset, options) {
    let i = offset;
    let nChars = 0;
    const tabSize = options.tabSize || 4;
    while (i < content.length) {
      const ch = content.charAt(i);
      if (ch === " ") {
        nChars++;
      } else if (ch === "	") {
        nChars += tabSize;
      } else {
        break;
      }
      i++;
    }
    return Math.floor(nChars / tabSize);
  }
  function isEOL(text, offset) {
    return "\r\n".indexOf(text.charAt(offset)) !== -1;
  }
  function isWhitespace(text, offset) {
    return " 	".indexOf(text.charAt(offset)) !== -1;
  }
  var LIB;
  (() => {
    var t2 = { 470: (t3) => {
      function e2(t4) {
        if ("string" != typeof t4) throw new TypeError("Path must be a string. Received " + JSON.stringify(t4));
      }
      function r2(t4, e3) {
        for (var r3, n3 = "", i = 0, o = -1, s = 0, h = 0; h <= t4.length; ++h) {
          if (h < t4.length) r3 = t4.charCodeAt(h);
          else {
            if (47 === r3) break;
            r3 = 47;
          }
          if (47 === r3) {
            if (o === h - 1 || 1 === s) ;
            else if (o !== h - 1 && 2 === s) {
              if (n3.length < 2 || 2 !== i || 46 !== n3.charCodeAt(n3.length - 1) || 46 !== n3.charCodeAt(n3.length - 2)) {
                if (n3.length > 2) {
                  var a = n3.lastIndexOf("/");
                  if (a !== n3.length - 1) {
                    -1 === a ? (n3 = "", i = 0) : i = (n3 = n3.slice(0, a)).length - 1 - n3.lastIndexOf("/"), o = h, s = 0;
                    continue;
                  }
                } else if (2 === n3.length || 1 === n3.length) {
                  n3 = "", i = 0, o = h, s = 0;
                  continue;
                }
              }
              e3 && (n3.length > 0 ? n3 += "/.." : n3 = "..", i = 2);
            } else n3.length > 0 ? n3 += "/" + t4.slice(o + 1, h) : n3 = t4.slice(o + 1, h), i = h - o - 1;
            o = h, s = 0;
          } else 46 === r3 && -1 !== s ? ++s : s = -1;
        }
        return n3;
      }
      var n2 = { resolve: function() {
        for (var t4, n3 = "", i = false, o = arguments.length - 1; o >= -1 && !i; o--) {
          var s;
          o >= 0 ? s = arguments[o] : (void 0 === t4 && (t4 = process.cwd()), s = t4), e2(s), 0 !== s.length && (n3 = s + "/" + n3, i = 47 === s.charCodeAt(0));
        }
        return n3 = r2(n3, !i), i ? n3.length > 0 ? "/" + n3 : "/" : n3.length > 0 ? n3 : ".";
      }, normalize: function(t4) {
        if (e2(t4), 0 === t4.length) return ".";
        var n3 = 47 === t4.charCodeAt(0), i = 47 === t4.charCodeAt(t4.length - 1);
        return 0 !== (t4 = r2(t4, !n3)).length || n3 || (t4 = "."), t4.length > 0 && i && (t4 += "/"), n3 ? "/" + t4 : t4;
      }, isAbsolute: function(t4) {
        return e2(t4), t4.length > 0 && 47 === t4.charCodeAt(0);
      }, join: function() {
        if (0 === arguments.length) return ".";
        for (var t4, r3 = 0; r3 < arguments.length; ++r3) {
          var i = arguments[r3];
          e2(i), i.length > 0 && (void 0 === t4 ? t4 = i : t4 += "/" + i);
        }
        return void 0 === t4 ? "." : n2.normalize(t4);
      }, relative: function(t4, r3) {
        if (e2(t4), e2(r3), t4 === r3) return "";
        if ((t4 = n2.resolve(t4)) === (r3 = n2.resolve(r3))) return "";
        for (var i = 1; i < t4.length && 47 === t4.charCodeAt(i); ++i) ;
        for (var o = t4.length, s = o - i, h = 1; h < r3.length && 47 === r3.charCodeAt(h); ++h) ;
        for (var a = r3.length - h, c = s < a ? s : a, f = -1, u = 0; u <= c; ++u) {
          if (u === c) {
            if (a > c) {
              if (47 === r3.charCodeAt(h + u)) return r3.slice(h + u + 1);
              if (0 === u) return r3.slice(h + u);
            } else s > c && (47 === t4.charCodeAt(i + u) ? f = u : 0 === u && (f = 0));
            break;
          }
          var l = t4.charCodeAt(i + u);
          if (l !== r3.charCodeAt(h + u)) break;
          47 === l && (f = u);
        }
        var g = "";
        for (u = i + f + 1; u <= o; ++u) u !== o && 47 !== t4.charCodeAt(u) || (0 === g.length ? g += ".." : g += "/..");
        return g.length > 0 ? g + r3.slice(h + f) : (h += f, 47 === r3.charCodeAt(h) && ++h, r3.slice(h));
      }, _makeLong: function(t4) {
        return t4;
      }, dirname: function(t4) {
        if (e2(t4), 0 === t4.length) return ".";
        for (var r3 = t4.charCodeAt(0), n3 = 47 === r3, i = -1, o = true, s = t4.length - 1; s >= 1; --s) if (47 === (r3 = t4.charCodeAt(s))) {
          if (!o) {
            i = s;
            break;
          }
        } else o = false;
        return -1 === i ? n3 ? "/" : "." : n3 && 1 === i ? "//" : t4.slice(0, i);
      }, basename: function(t4, r3) {
        if (void 0 !== r3 && "string" != typeof r3) throw new TypeError('"ext" argument must be a string');
        e2(t4);
        var n3, i = 0, o = -1, s = true;
        if (void 0 !== r3 && r3.length > 0 && r3.length <= t4.length) {
          if (r3.length === t4.length && r3 === t4) return "";
          var h = r3.length - 1, a = -1;
          for (n3 = t4.length - 1; n3 >= 0; --n3) {
            var c = t4.charCodeAt(n3);
            if (47 === c) {
              if (!s) {
                i = n3 + 1;
                break;
              }
            } else -1 === a && (s = false, a = n3 + 1), h >= 0 && (c === r3.charCodeAt(h) ? -1 == --h && (o = n3) : (h = -1, o = a));
          }
          return i === o ? o = a : -1 === o && (o = t4.length), t4.slice(i, o);
        }
        for (n3 = t4.length - 1; n3 >= 0; --n3) if (47 === t4.charCodeAt(n3)) {
          if (!s) {
            i = n3 + 1;
            break;
          }
        } else -1 === o && (s = false, o = n3 + 1);
        return -1 === o ? "" : t4.slice(i, o);
      }, extname: function(t4) {
        e2(t4);
        for (var r3 = -1, n3 = 0, i = -1, o = true, s = 0, h = t4.length - 1; h >= 0; --h) {
          var a = t4.charCodeAt(h);
          if (47 !== a) -1 === i && (o = false, i = h + 1), 46 === a ? -1 === r3 ? r3 = h : 1 !== s && (s = 1) : -1 !== r3 && (s = -1);
          else if (!o) {
            n3 = h + 1;
            break;
          }
        }
        return -1 === r3 || -1 === i || 0 === s || 1 === s && r3 === i - 1 && r3 === n3 + 1 ? "" : t4.slice(r3, i);
      }, format: function(t4) {
        if (null === t4 || "object" != typeof t4) throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof t4);
        return (function(t5, e3) {
          var r3 = e3.dir || e3.root, n3 = e3.base || (e3.name || "") + (e3.ext || "");
          return r3 ? r3 === e3.root ? r3 + n3 : r3 + "/" + n3 : n3;
        })(0, t4);
      }, parse: function(t4) {
        e2(t4);
        var r3 = { root: "", dir: "", base: "", ext: "", name: "" };
        if (0 === t4.length) return r3;
        var n3, i = t4.charCodeAt(0), o = 47 === i;
        o ? (r3.root = "/", n3 = 1) : n3 = 0;
        for (var s = -1, h = 0, a = -1, c = true, f = t4.length - 1, u = 0; f >= n3; --f) if (47 !== (i = t4.charCodeAt(f))) -1 === a && (c = false, a = f + 1), 46 === i ? -1 === s ? s = f : 1 !== u && (u = 1) : -1 !== s && (u = -1);
        else if (!c) {
          h = f + 1;
          break;
        }
        return -1 === s || -1 === a || 0 === u || 1 === u && s === a - 1 && s === h + 1 ? -1 !== a && (r3.base = r3.name = 0 === h && o ? t4.slice(1, a) : t4.slice(h, a)) : (0 === h && o ? (r3.name = t4.slice(1, s), r3.base = t4.slice(1, a)) : (r3.name = t4.slice(h, s), r3.base = t4.slice(h, a)), r3.ext = t4.slice(s, a)), h > 0 ? r3.dir = t4.slice(0, h - 1) : o && (r3.dir = "/"), r3;
      }, sep: "/", delimiter: ":", win32: null, posix: null };
      n2.posix = n2, t3.exports = n2;
    } }, e = {};
    function r(n2) {
      var i = e[n2];
      if (void 0 !== i) return i.exports;
      var o = e[n2] = { exports: {} };
      return t2[n2](o, o.exports, r), o.exports;
    }
    r.d = (t3, e2) => {
      for (var n2 in e2) r.o(e2, n2) && !r.o(t3, n2) && Object.defineProperty(t3, n2, { enumerable: true, get: e2[n2] });
    }, r.o = (t3, e2) => Object.prototype.hasOwnProperty.call(t3, e2), r.r = (t3) => {
      "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(t3, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(t3, "__esModule", { value: true });
    };
    var n = {};
    (() => {
      let t3;
      if (r.r(n), r.d(n, { URI: () => f, Utils: () => P }), "object" == typeof process) t3 = "win32" === process.platform;
      else if ("object" == typeof navigator) {
        let e3 = navigator.userAgent;
        t3 = e3.indexOf("Windows") >= 0;
      }
      const e2 = /^\w[\w\d+.-]*$/, i = /^\//, o = /^\/\//;
      function s(t4, r2) {
        if (!t4.scheme && r2) throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${t4.authority}", path: "${t4.path}", query: "${t4.query}", fragment: "${t4.fragment}"}`);
        if (t4.scheme && !e2.test(t4.scheme)) throw new Error("[UriError]: Scheme contains illegal characters.");
        if (t4.path) {
          if (t4.authority) {
            if (!i.test(t4.path)) throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
          } else if (o.test(t4.path)) throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
        }
      }
      const h = "", a = "/", c = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
      class f {
        static isUri(t4) {
          return t4 instanceof f || !!t4 && "string" == typeof t4.authority && "string" == typeof t4.fragment && "string" == typeof t4.path && "string" == typeof t4.query && "string" == typeof t4.scheme && "string" == typeof t4.fsPath && "function" == typeof t4.with && "function" == typeof t4.toString;
        }
        scheme;
        authority;
        path;
        query;
        fragment;
        constructor(t4, e3, r2, n2, i2, o2 = false) {
          "object" == typeof t4 ? (this.scheme = t4.scheme || h, this.authority = t4.authority || h, this.path = t4.path || h, this.query = t4.query || h, this.fragment = t4.fragment || h) : (this.scheme = /* @__PURE__ */ (function(t5, e4) {
            return t5 || e4 ? t5 : "file";
          })(t4, o2), this.authority = e3 || h, this.path = (function(t5, e4) {
            switch (t5) {
              case "https":
              case "http":
              case "file":
                e4 ? e4[0] !== a && (e4 = a + e4) : e4 = a;
            }
            return e4;
          })(this.scheme, r2 || h), this.query = n2 || h, this.fragment = i2 || h, s(this, o2));
        }
        get fsPath() {
          return m(this);
        }
        with(t4) {
          if (!t4) return this;
          let { scheme: e3, authority: r2, path: n2, query: i2, fragment: o2 } = t4;
          return void 0 === e3 ? e3 = this.scheme : null === e3 && (e3 = h), void 0 === r2 ? r2 = this.authority : null === r2 && (r2 = h), void 0 === n2 ? n2 = this.path : null === n2 && (n2 = h), void 0 === i2 ? i2 = this.query : null === i2 && (i2 = h), void 0 === o2 ? o2 = this.fragment : null === o2 && (o2 = h), e3 === this.scheme && r2 === this.authority && n2 === this.path && i2 === this.query && o2 === this.fragment ? this : new l(e3, r2, n2, i2, o2);
        }
        static parse(t4, e3 = false) {
          const r2 = c.exec(t4);
          return r2 ? new l(r2[2] || h, C(r2[4] || h), C(r2[5] || h), C(r2[7] || h), C(r2[9] || h), e3) : new l(h, h, h, h, h);
        }
        static file(e3) {
          let r2 = h;
          if (t3 && (e3 = e3.replace(/\\/g, a)), e3[0] === a && e3[1] === a) {
            const t4 = e3.indexOf(a, 2);
            -1 === t4 ? (r2 = e3.substring(2), e3 = a) : (r2 = e3.substring(2, t4), e3 = e3.substring(t4) || a);
          }
          return new l("file", r2, e3, h, h);
        }
        static from(t4) {
          const e3 = new l(t4.scheme, t4.authority, t4.path, t4.query, t4.fragment);
          return s(e3, true), e3;
        }
        toString(t4 = false) {
          return y(this, t4);
        }
        toJSON() {
          return this;
        }
        static revive(t4) {
          if (t4) {
            if (t4 instanceof f) return t4;
            {
              const e3 = new l(t4);
              return e3._formatted = t4.external, e3._fsPath = t4._sep === u ? t4.fsPath : null, e3;
            }
          }
          return t4;
        }
      }
      const u = t3 ? 1 : void 0;
      class l extends f {
        _formatted = null;
        _fsPath = null;
        get fsPath() {
          return this._fsPath || (this._fsPath = m(this)), this._fsPath;
        }
        toString(t4 = false) {
          return t4 ? y(this, true) : (this._formatted || (this._formatted = y(this, false)), this._formatted);
        }
        toJSON() {
          const t4 = { $mid: 1 };
          return this._fsPath && (t4.fsPath = this._fsPath, t4._sep = u), this._formatted && (t4.external = this._formatted), this.path && (t4.path = this.path), this.scheme && (t4.scheme = this.scheme), this.authority && (t4.authority = this.authority), this.query && (t4.query = this.query), this.fragment && (t4.fragment = this.fragment), t4;
        }
      }
      const g = { 58: "%3A", 47: "%2F", 63: "%3F", 35: "%23", 91: "%5B", 93: "%5D", 64: "%40", 33: "%21", 36: "%24", 38: "%26", 39: "%27", 40: "%28", 41: "%29", 42: "%2A", 43: "%2B", 44: "%2C", 59: "%3B", 61: "%3D", 32: "%20" };
      function d(t4, e3, r2) {
        let n2, i2 = -1;
        for (let o2 = 0; o2 < t4.length; o2++) {
          const s2 = t4.charCodeAt(o2);
          if (s2 >= 97 && s2 <= 122 || s2 >= 65 && s2 <= 90 || s2 >= 48 && s2 <= 57 || 45 === s2 || 46 === s2 || 95 === s2 || 126 === s2 || e3 && 47 === s2 || r2 && 91 === s2 || r2 && 93 === s2 || r2 && 58 === s2) -1 !== i2 && (n2 += encodeURIComponent(t4.substring(i2, o2)), i2 = -1), void 0 !== n2 && (n2 += t4.charAt(o2));
          else {
            void 0 === n2 && (n2 = t4.substr(0, o2));
            const e4 = g[s2];
            void 0 !== e4 ? (-1 !== i2 && (n2 += encodeURIComponent(t4.substring(i2, o2)), i2 = -1), n2 += e4) : -1 === i2 && (i2 = o2);
          }
        }
        return -1 !== i2 && (n2 += encodeURIComponent(t4.substring(i2))), void 0 !== n2 ? n2 : t4;
      }
      function p(t4) {
        let e3;
        for (let r2 = 0; r2 < t4.length; r2++) {
          const n2 = t4.charCodeAt(r2);
          35 === n2 || 63 === n2 ? (void 0 === e3 && (e3 = t4.substr(0, r2)), e3 += g[n2]) : void 0 !== e3 && (e3 += t4[r2]);
        }
        return void 0 !== e3 ? e3 : t4;
      }
      function m(e3, r2) {
        let n2;
        return n2 = e3.authority && e3.path.length > 1 && "file" === e3.scheme ? `//${e3.authority}${e3.path}` : 47 === e3.path.charCodeAt(0) && (e3.path.charCodeAt(1) >= 65 && e3.path.charCodeAt(1) <= 90 || e3.path.charCodeAt(1) >= 97 && e3.path.charCodeAt(1) <= 122) && 58 === e3.path.charCodeAt(2) ? e3.path[1].toLowerCase() + e3.path.substr(2) : e3.path, t3 && (n2 = n2.replace(/\//g, "\\")), n2;
      }
      function y(t4, e3) {
        const r2 = e3 ? p : d;
        let n2 = "", { scheme: i2, authority: o2, path: s2, query: h2, fragment: c2 } = t4;
        if (i2 && (n2 += i2, n2 += ":"), (o2 || "file" === i2) && (n2 += a, n2 += a), o2) {
          let t5 = o2.indexOf("@");
          if (-1 !== t5) {
            const e4 = o2.substr(0, t5);
            o2 = o2.substr(t5 + 1), t5 = e4.lastIndexOf(":"), -1 === t5 ? n2 += r2(e4, false, false) : (n2 += r2(e4.substr(0, t5), false, false), n2 += ":", n2 += r2(e4.substr(t5 + 1), false, true)), n2 += "@";
          }
          o2 = o2.toLowerCase(), t5 = o2.lastIndexOf(":"), -1 === t5 ? n2 += r2(o2, false, true) : (n2 += r2(o2.substr(0, t5), false, true), n2 += o2.substr(t5));
        }
        if (s2) {
          if (s2.length >= 3 && 47 === s2.charCodeAt(0) && 58 === s2.charCodeAt(2)) {
            const t5 = s2.charCodeAt(1);
            t5 >= 65 && t5 <= 90 && (s2 = `/${String.fromCharCode(t5 + 32)}:${s2.substr(3)}`);
          } else if (s2.length >= 2 && 58 === s2.charCodeAt(1)) {
            const t5 = s2.charCodeAt(0);
            t5 >= 65 && t5 <= 90 && (s2 = `${String.fromCharCode(t5 + 32)}:${s2.substr(2)}`);
          }
          n2 += r2(s2, true, false);
        }
        return h2 && (n2 += "?", n2 += r2(h2, false, false)), c2 && (n2 += "#", n2 += e3 ? c2 : d(c2, false, false)), n2;
      }
      function v(t4) {
        try {
          return decodeURIComponent(t4);
        } catch {
          return t4.length > 3 ? t4.substr(0, 3) + v(t4.substr(3)) : t4;
        }
      }
      const b = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
      function C(t4) {
        return t4.match(b) ? t4.replace(b, ((t5) => v(t5))) : t4;
      }
      var A = r(470);
      const w = A.posix || A, x = "/";
      var P;
      !(function(t4) {
        t4.joinPath = function(t5, ...e3) {
          return t5.with({ path: w.join(t5.path, ...e3) });
        }, t4.resolvePath = function(t5, ...e3) {
          let r2 = t5.path, n2 = false;
          r2[0] !== x && (r2 = x + r2, n2 = true);
          let i2 = w.resolve(r2, ...e3);
          return n2 && i2[0] === x && !t5.authority && (i2 = i2.substring(1)), t5.with({ path: i2 });
        }, t4.dirname = function(t5) {
          if (0 === t5.path.length || t5.path === x) return t5;
          let e3 = w.dirname(t5.path);
          return 1 === e3.length && 46 === e3.charCodeAt(0) && (e3 = ""), t5.with({ path: e3 });
        }, t4.basename = function(t5) {
          return w.basename(t5.path);
        }, t4.extname = function(t5) {
          return w.extname(t5.path);
        };
      })(P || (P = {}));
    })(), LIB = n;
  })();
  const { URI, Utils } = LIB;
  function normalizeRef(url) {
    const first = url[0];
    const last = url[url.length - 1];
    if (first === last && (first === "'" || first === '"')) {
      url = url.substring(1, url.length - 1);
    }
    return url;
  }
  function validateRef(url, languageId) {
    if (!url.length) {
      return false;
    }
    if (languageId === "handlebars" && /{{|}}/.test(url)) {
      return false;
    }
    return /\b(w[\w\d+.-]*:\/\/)?[^\s()<>]+(?:\([\w\d]+\)|([^[:punct:]\s]|\/?))/.test(url);
  }
  function getWorkspaceUrl(documentUri, tokenContent, documentContext, base) {
    if (/^\s*javascript\:/i.test(tokenContent) || /[\n\r]/.test(tokenContent)) {
      return void 0;
    }
    tokenContent = tokenContent.replace(/^\s*/g, "");
    const match = tokenContent.match(/^(\w[\w\d+.-]*):/);
    if (match) {
      const schema = match[1].toLowerCase();
      if (schema === "http" || schema === "https" || schema === "file") {
        return tokenContent;
      }
      return void 0;
    }
    if (/^\#/i.test(tokenContent)) {
      return documentUri + tokenContent;
    }
    if (/^\/\//i.test(tokenContent)) {
      const pickedScheme = startsWith(documentUri, "https://") ? "https" : "http";
      return pickedScheme + ":" + tokenContent.replace(/^\s*/g, "");
    }
    if (documentContext) {
      return documentContext.resolveReference(tokenContent, base || documentUri);
    }
    return tokenContent;
  }
  function createLink(document2, documentContext, attributeValue, startOffset, endOffset, base) {
    const tokenContent = normalizeRef(attributeValue);
    if (!validateRef(tokenContent, document2.languageId)) {
      return void 0;
    }
    if (tokenContent.length < attributeValue.length) {
      startOffset++;
      endOffset--;
    }
    const workspaceUrl = getWorkspaceUrl(document2.uri, tokenContent, documentContext, base);
    if (!workspaceUrl) {
      return void 0;
    }
    const target = validateAndCleanURI(workspaceUrl, document2);
    return {
      range: Range.create(document2.positionAt(startOffset), document2.positionAt(endOffset)),
      target
    };
  }
  const _hash = "#".charCodeAt(0);
  function validateAndCleanURI(uriStr, document2) {
    try {
      let uri = URI.parse(uriStr);
      if (uri.scheme === "file" && uri.query) {
        uri = uri.with({ query: null });
        uriStr = uri.toString(
          /* skipEncodig*/
          true
        );
      }
      if (uri.scheme === "file" && uri.fragment && !(uriStr.startsWith(document2.uri) && uriStr.charCodeAt(document2.uri.length) === _hash)) {
        return uri.with({ fragment: null }).toString(
          /* skipEncodig*/
          true
        );
      }
      return uriStr;
    } catch (e) {
      return void 0;
    }
  }
  class HTMLDocumentLinks {
    constructor(dataManager) {
      this.dataManager = dataManager;
    }
    findDocumentLinks(document2, documentContext) {
      const newLinks = [];
      const scanner = createScanner(document2.getText(), 0);
      let token = scanner.scan();
      let lastAttributeName = void 0;
      let lastTagName = void 0;
      let afterBase = false;
      let base = void 0;
      const idLocations = {};
      while (token !== TokenType.EOS) {
        switch (token) {
          case TokenType.StartTag:
            lastTagName = scanner.getTokenText().toLowerCase();
            if (!base) {
              afterBase = lastTagName === "base";
            }
            break;
          case TokenType.AttributeName:
            lastAttributeName = scanner.getTokenText().toLowerCase();
            break;
          case TokenType.AttributeValue:
            if (lastTagName && lastAttributeName && this.dataManager.isPathAttribute(lastTagName, lastAttributeName)) {
              const attributeValue = scanner.getTokenText();
              if (!afterBase) {
                const link = createLink(document2, documentContext, attributeValue, scanner.getTokenOffset(), scanner.getTokenEnd(), base);
                if (link) {
                  newLinks.push(link);
                }
              }
              if (afterBase && typeof base === "undefined") {
                base = normalizeRef(attributeValue);
                if (base && documentContext) {
                  base = documentContext.resolveReference(base, document2.uri);
                }
              }
              afterBase = false;
              lastAttributeName = void 0;
            } else if (lastAttributeName === "id") {
              const id = normalizeRef(scanner.getTokenText());
              idLocations[id] = scanner.getTokenOffset();
            }
            break;
        }
        token = scanner.scan();
      }
      for (const link of newLinks) {
        const localWithHash = document2.uri + "#";
        if (link.target && startsWith(link.target, localWithHash)) {
          const target = link.target.substring(localWithHash.length);
          const offset = idLocations[target];
          if (offset !== void 0) {
            const pos = document2.positionAt(offset);
            link.target = `${localWithHash}${pos.line + 1},${pos.character + 1}`;
          } else {
            link.target = document2.uri;
          }
        }
      }
      return newLinks;
    }
  }
  function findDocumentHighlights(document2, position, htmlDocument) {
    const offset = document2.offsetAt(position);
    const node = htmlDocument.findNodeAt(offset);
    if (!node.tag) {
      return [];
    }
    const result = [];
    const startTagRange = getTagNameRange(TokenType.StartTag, document2, node.start);
    const endTagRange = typeof node.endTagStart === "number" && getTagNameRange(TokenType.EndTag, document2, node.endTagStart);
    if (startTagRange && covers(startTagRange, position) || endTagRange && covers(endTagRange, position)) {
      if (startTagRange) {
        result.push({ kind: DocumentHighlightKind.Read, range: startTagRange });
      }
      if (endTagRange) {
        result.push({ kind: DocumentHighlightKind.Read, range: endTagRange });
      }
    }
    return result;
  }
  function isBeforeOrEqual(pos1, pos2) {
    return pos1.line < pos2.line || pos1.line === pos2.line && pos1.character <= pos2.character;
  }
  function covers(range, position) {
    return isBeforeOrEqual(range.start, position) && isBeforeOrEqual(position, range.end);
  }
  function getTagNameRange(tokenType, document2, startOffset) {
    const scanner = createScanner(document2.getText(), startOffset);
    let token = scanner.scan();
    while (token !== TokenType.EOS && token !== tokenType) {
      token = scanner.scan();
    }
    if (token !== TokenType.EOS) {
      return { start: document2.positionAt(scanner.getTokenOffset()), end: document2.positionAt(scanner.getTokenEnd()) };
    }
    return null;
  }
  function findDocumentSymbols(document2, htmlDocument) {
    const symbols = [];
    const symbols2 = findDocumentSymbols2(document2, htmlDocument);
    for (const symbol of symbols2) {
      walk(symbol, void 0);
    }
    return symbols;
    function walk(node, parent) {
      const symbol = SymbolInformation.create(node.name, node.kind, node.range, document2.uri, parent?.name);
      symbol.containerName ?? (symbol.containerName = "");
      symbols.push(symbol);
      if (node.children) {
        for (const child of node.children) {
          walk(child, node);
        }
      }
    }
  }
  function findDocumentSymbols2(document2, htmlDocument) {
    const symbols = [];
    htmlDocument.roots.forEach((node) => {
      provideFileSymbolsInternal(document2, node, symbols);
    });
    return symbols;
  }
  function provideFileSymbolsInternal(document2, node, symbols) {
    const name = nodeToName(node);
    const range = Range.create(document2.positionAt(node.start), document2.positionAt(node.end));
    const symbol = DocumentSymbol.create(name, void 0, SymbolKind.Field, range, range);
    symbols.push(symbol);
    node.children.forEach((child) => {
      symbol.children ?? (symbol.children = []);
      provideFileSymbolsInternal(document2, child, symbol.children);
    });
  }
  function nodeToName(node) {
    let name = node.tag;
    if (node.attributes) {
      const id = node.attributes["id"];
      const classes = node.attributes["class"];
      if (id) {
        name += `#${id.replace(/[\"\']/g, "")}`;
      }
      if (classes) {
        name += classes.replace(/[\"\']/g, "").split(/\s+/).map((className) => `.${className}`).join("");
      }
    }
    return name || "?";
  }
  function doRename(document2, position, newName, htmlDocument) {
    const offset = document2.offsetAt(position);
    const node = htmlDocument.findNodeAt(offset);
    if (!node.tag) {
      return null;
    }
    if (!isWithinTagRange(node, offset, node.tag)) {
      return null;
    }
    const edits = [];
    const startTagRange = {
      start: document2.positionAt(node.start + "<".length),
      end: document2.positionAt(node.start + "<".length + node.tag.length)
    };
    edits.push({
      range: startTagRange,
      newText: newName
    });
    if (node.endTagStart) {
      const endTagRange = {
        start: document2.positionAt(node.endTagStart + "</".length),
        end: document2.positionAt(node.endTagStart + "</".length + node.tag.length)
      };
      edits.push({
        range: endTagRange,
        newText: newName
      });
    }
    const changes = {
      [document2.uri.toString()]: edits
    };
    return {
      changes
    };
  }
  function isWithinTagRange(node, offset, nodeTag) {
    if (node.endTagStart) {
      if (node.endTagStart + "</".length <= offset && offset <= node.endTagStart + "</".length + nodeTag.length) {
        return true;
      }
    }
    return node.start + "<".length <= offset && offset <= node.start + "<".length + nodeTag.length;
  }
  function findMatchingTagPosition(document2, position, htmlDocument) {
    const offset = document2.offsetAt(position);
    const node = htmlDocument.findNodeAt(offset);
    if (!node.tag) {
      return null;
    }
    if (!node.endTagStart) {
      return null;
    }
    if (node.start + "<".length <= offset && offset <= node.start + "<".length + node.tag.length) {
      const mirrorOffset = offset - "<".length - node.start + node.endTagStart + "</".length;
      return document2.positionAt(mirrorOffset);
    }
    if (node.endTagStart + "</".length <= offset && offset <= node.endTagStart + "</".length + node.tag.length) {
      const mirrorOffset = offset - "</".length - node.endTagStart + node.start + "<".length;
      return document2.positionAt(mirrorOffset);
    }
    return null;
  }
  function findLinkedEditingRanges(document2, position, htmlDocument) {
    const offset = document2.offsetAt(position);
    const node = htmlDocument.findNodeAt(offset);
    const tagLength = node.tag ? node.tag.length : 0;
    if (!node.endTagStart) {
      return null;
    }
    if (
      // Within open tag, compute close tag
      node.start + "<".length <= offset && offset <= node.start + "<".length + tagLength || // Within closing tag, compute open tag
      node.endTagStart + "</".length <= offset && offset <= node.endTagStart + "</".length + tagLength
    ) {
      return [
        Range.create(document2.positionAt(node.start + "<".length), document2.positionAt(node.start + "<".length + tagLength)),
        Range.create(document2.positionAt(node.endTagStart + "</".length), document2.positionAt(node.endTagStart + "</".length + tagLength))
      ];
    }
    return null;
  }
  class HTMLFolding {
    constructor(dataManager) {
      this.dataManager = dataManager;
    }
    limitRanges(ranges, rangeLimit) {
      ranges = ranges.sort((r1, r2) => {
        let diff = r1.startLine - r2.startLine;
        if (diff === 0) {
          diff = r1.endLine - r2.endLine;
        }
        return diff;
      });
      let top = void 0;
      const previous = [];
      const nestingLevels = [];
      const nestingLevelCounts = [];
      const setNestingLevel = (index, level) => {
        nestingLevels[index] = level;
        if (level < 30) {
          nestingLevelCounts[level] = (nestingLevelCounts[level] || 0) + 1;
        }
      };
      for (let i = 0; i < ranges.length; i++) {
        const entry = ranges[i];
        if (!top) {
          top = entry;
          setNestingLevel(i, 0);
        } else {
          if (entry.startLine > top.startLine) {
            if (entry.endLine <= top.endLine) {
              previous.push(top);
              top = entry;
              setNestingLevel(i, previous.length);
            } else if (entry.startLine > top.endLine) {
              do {
                top = previous.pop();
              } while (top && entry.startLine > top.endLine);
              if (top) {
                previous.push(top);
              }
              top = entry;
              setNestingLevel(i, previous.length);
            }
          }
        }
      }
      let entries = 0;
      let maxLevel = 0;
      for (let i = 0; i < nestingLevelCounts.length; i++) {
        const n = nestingLevelCounts[i];
        if (n) {
          if (n + entries > rangeLimit) {
            maxLevel = i;
            break;
          }
          entries += n;
        }
      }
      const result = [];
      for (let i = 0; i < ranges.length; i++) {
        const level = nestingLevels[i];
        if (typeof level === "number") {
          if (level < maxLevel || level === maxLevel && entries++ < rangeLimit) {
            result.push(ranges[i]);
          }
        }
      }
      return result;
    }
    getFoldingRanges(document2, context) {
      const voidElements = this.dataManager.getVoidElements(document2.languageId);
      const scanner = createScanner(document2.getText());
      let token = scanner.scan();
      const ranges = [];
      const stack = [];
      let lastTagName = null;
      let prevStart = -1;
      function addRange(range) {
        ranges.push(range);
        prevStart = range.startLine;
      }
      while (token !== TokenType.EOS) {
        switch (token) {
          case TokenType.StartTag: {
            const tagName = scanner.getTokenText();
            const startLine = document2.positionAt(scanner.getTokenOffset()).line;
            stack.push({ startLine, tagName });
            lastTagName = tagName;
            break;
          }
          case TokenType.EndTag: {
            lastTagName = scanner.getTokenText();
            break;
          }
          case TokenType.StartTagClose:
            if (!lastTagName || !this.dataManager.isVoidElement(lastTagName, voidElements)) {
              break;
            }
          // fallthrough
          case TokenType.EndTagClose:
          case TokenType.StartTagSelfClose: {
            let i = stack.length - 1;
            while (i >= 0 && stack[i].tagName !== lastTagName) {
              i--;
            }
            if (i >= 0) {
              const stackElement = stack[i];
              stack.length = i;
              const line = document2.positionAt(scanner.getTokenOffset()).line;
              const startLine = stackElement.startLine;
              const endLine = line - 1;
              if (endLine > startLine && prevStart !== startLine) {
                addRange({ startLine, endLine });
              }
            }
            break;
          }
          case TokenType.Comment: {
            let startLine = document2.positionAt(scanner.getTokenOffset()).line;
            const text = scanner.getTokenText();
            const m = text.match(/^\s*#(region\b)|(endregion\b)/);
            if (m) {
              if (m[1]) {
                stack.push({ startLine, tagName: "" });
              } else {
                let i = stack.length - 1;
                while (i >= 0 && stack[i].tagName.length) {
                  i--;
                }
                if (i >= 0) {
                  const stackElement = stack[i];
                  stack.length = i;
                  const endLine = startLine;
                  startLine = stackElement.startLine;
                  if (endLine > startLine && prevStart !== startLine) {
                    addRange({ startLine, endLine, kind: FoldingRangeKind.Region });
                  }
                }
              }
            } else {
              const endLine = document2.positionAt(scanner.getTokenOffset() + scanner.getTokenLength()).line;
              if (startLine < endLine) {
                addRange({ startLine, endLine, kind: FoldingRangeKind.Comment });
              }
            }
            break;
          }
        }
        token = scanner.scan();
      }
      const rangeLimit = context && context.rangeLimit || Number.MAX_VALUE;
      if (ranges.length > rangeLimit) {
        return this.limitRanges(ranges, rangeLimit);
      }
      return ranges;
    }
  }
  class HTMLSelectionRange {
    constructor(htmlParser) {
      this.htmlParser = htmlParser;
    }
    getSelectionRanges(document2, positions) {
      const htmlDocument = this.htmlParser.parseDocument(document2);
      return positions.map((p) => this.getSelectionRange(p, document2, htmlDocument));
    }
    getSelectionRange(position, document2, htmlDocument) {
      const applicableRanges = this.getApplicableRanges(document2, position, htmlDocument);
      let prev = void 0;
      let current = void 0;
      for (let index = applicableRanges.length - 1; index >= 0; index--) {
        const range = applicableRanges[index];
        if (!prev || range[0] !== prev[0] || range[1] !== prev[1]) {
          current = SelectionRange.create(Range.create(document2.positionAt(applicableRanges[index][0]), document2.positionAt(applicableRanges[index][1])), current);
        }
        prev = range;
      }
      if (!current) {
        current = SelectionRange.create(Range.create(position, position));
      }
      return current;
    }
    getApplicableRanges(document2, position, htmlDoc) {
      const currOffset = document2.offsetAt(position);
      const currNode = htmlDoc.findNodeAt(currOffset);
      let result = this.getAllParentTagRanges(currNode);
      if (currNode.startTagEnd && !currNode.endTagStart) {
        if (currNode.startTagEnd !== currNode.end) {
          return [[currNode.start, currNode.end]];
        }
        const closeRange = Range.create(document2.positionAt(currNode.startTagEnd - 2), document2.positionAt(currNode.startTagEnd));
        const closeText = document2.getText(closeRange);
        if (closeText === "/>") {
          result.unshift([currNode.start + 1, currNode.startTagEnd - 2]);
        } else {
          result.unshift([currNode.start + 1, currNode.startTagEnd - 1]);
        }
        const attributeLevelRanges = this.getAttributeLevelRanges(document2, currNode, currOffset);
        result = attributeLevelRanges.concat(result);
        return result;
      }
      if (!currNode.startTagEnd || !currNode.endTagStart) {
        return result;
      }
      result.unshift([currNode.start, currNode.end]);
      if (currNode.start < currOffset && currOffset < currNode.startTagEnd) {
        result.unshift([currNode.start + 1, currNode.startTagEnd - 1]);
        const attributeLevelRanges = this.getAttributeLevelRanges(document2, currNode, currOffset);
        result = attributeLevelRanges.concat(result);
        return result;
      } else if (currNode.startTagEnd <= currOffset && currOffset <= currNode.endTagStart) {
        result.unshift([currNode.startTagEnd, currNode.endTagStart]);
        return result;
      } else {
        if (currOffset >= currNode.endTagStart + 2) {
          result.unshift([currNode.endTagStart + 2, currNode.end - 1]);
        }
        return result;
      }
    }
    getAllParentTagRanges(initialNode) {
      let currNode = initialNode;
      const result = [];
      while (currNode.parent) {
        currNode = currNode.parent;
        this.getNodeRanges(currNode).forEach((r) => result.push(r));
      }
      return result;
    }
    getNodeRanges(n) {
      if (n.startTagEnd && n.endTagStart && n.startTagEnd < n.endTagStart) {
        return [
          [n.startTagEnd, n.endTagStart],
          [n.start, n.end]
        ];
      }
      return [
        [n.start, n.end]
      ];
    }
    getAttributeLevelRanges(document2, currNode, currOffset) {
      const currNodeRange = Range.create(document2.positionAt(currNode.start), document2.positionAt(currNode.end));
      const currNodeText = document2.getText(currNodeRange);
      const relativeOffset = currOffset - currNode.start;
      const scanner = createScanner(currNodeText);
      let token = scanner.scan();
      const positionOffset = currNode.start;
      const result = [];
      let isInsideAttribute = false;
      let attrStart = -1;
      while (token !== TokenType.EOS) {
        switch (token) {
          case TokenType.AttributeName: {
            if (relativeOffset < scanner.getTokenOffset()) {
              isInsideAttribute = false;
              break;
            }
            if (relativeOffset <= scanner.getTokenEnd()) {
              result.unshift([scanner.getTokenOffset(), scanner.getTokenEnd()]);
            }
            isInsideAttribute = true;
            attrStart = scanner.getTokenOffset();
            break;
          }
          case TokenType.AttributeValue: {
            if (!isInsideAttribute) {
              break;
            }
            const valueText = scanner.getTokenText();
            if (relativeOffset < scanner.getTokenOffset()) {
              result.push([attrStart, scanner.getTokenEnd()]);
              break;
            }
            if (relativeOffset >= scanner.getTokenOffset() && relativeOffset <= scanner.getTokenEnd()) {
              result.unshift([scanner.getTokenOffset(), scanner.getTokenEnd()]);
              if (valueText[0] === `"` && valueText[valueText.length - 1] === `"` || valueText[0] === `'` && valueText[valueText.length - 1] === `'`) {
                if (relativeOffset >= scanner.getTokenOffset() + 1 && relativeOffset <= scanner.getTokenEnd() - 1) {
                  result.unshift([scanner.getTokenOffset() + 1, scanner.getTokenEnd() - 1]);
                }
              }
              result.push([attrStart, scanner.getTokenEnd()]);
            }
            break;
          }
        }
        token = scanner.scan();
      }
      return result.map((pair) => {
        return [pair[0] + positionOffset, pair[1] + positionOffset];
      });
    }
  }
  const htmlData = {
    "version": 1.1,
    "tags": [
      {
        "name": "html",
        "description": {
          "kind": "markdown",
          "value": "The html element represents the root of an HTML document."
        },
        "attributes": [
          {
            "name": "manifest",
            "description": {
              "kind": "markdown",
              "value": "Specifies the URI of a resource manifest indicating resources that should be cached locally. See [Using the application cache](https://developer.mozilla.org/en-US/docs/Web/HTML/Using_the_application_cache) for details."
            }
          },
          {
            "name": "version",
            "description": 'Specifies the version of the HTML [Document Type Definition](https://developer.mozilla.org/en-US/docs/Glossary/DTD "Document Type Definition: In HTML, the doctype is the required "<!DOCTYPE html>" preamble found at the top of all documents. Its sole purpose is to prevent a browser from switching into so-called “quirks mode” when rendering a document; that is, the "<!DOCTYPE html>" doctype ensures that the browser makes a best-effort attempt at following the relevant specifications, rather than using a different rendering mode that is incompatible with some specifications.") that governs the current document. This attribute is not needed, because it is redundant with the version information in the document type declaration.'
          },
          {
            "name": "xmlns",
            "description": 'Specifies the XML Namespace of the document. Default value is `"http://www.w3.org/1999/xhtml"`. This is required in documents parsed with XML parsers, and optional in text/html documents.'
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/html"
          }
        ]
      },
      {
        "name": "head",
        "description": {
          "kind": "markdown",
          "value": "The head element represents a collection of metadata for the Document."
        },
        "attributes": [
          {
            "name": "profile",
            "description": "The URIs of one or more metadata profiles, separated by white space."
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/head"
          }
        ]
      },
      {
        "name": "title",
        "description": {
          "kind": "markdown",
          "value": "The title element represents the document's title or name. Authors should use titles that identify their documents even when they are used out of context, for example in a user's history or bookmarks, or in search results. The document's title is often different from its first heading, since the first heading does not have to stand alone when taken out of context."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/title"
          }
        ]
      },
      {
        "name": "base",
        "description": {
          "kind": "markdown",
          "value": "The base element allows authors to specify the document base URL for the purposes of resolving relative URLs, and the name of the default browsing context for the purposes of following hyperlinks. The element does not represent any content beyond this information."
        },
        "void": true,
        "attributes": [
          {
            "name": "href",
            "description": {
              "kind": "markdown",
              "value": "The base URL to be used throughout the document for relative URL addresses. If this attribute is specified, this element must come before any other elements with attributes whose values are URLs. Absolute and relative URLs are allowed."
            }
          },
          {
            "name": "target",
            "valueSet": "target",
            "description": {
              "kind": "markdown",
              "value": "A name or keyword indicating the default location to display the result when hyperlinks or forms cause navigation, for elements that do not have an explicit target reference. It is a name of, or keyword for, a _browsing context_ (for example: tab, window, or inline frame). The following keywords have special meanings:\n\n*   `_self`: Load the result into the same browsing context as the current one. This value is the default if the attribute is not specified.\n*   `_blank`: Load the result into a new unnamed browsing context.\n*   `_parent`: Load the result into the parent browsing context of the current one. If there is no parent, this option behaves the same way as `_self`.\n*   `_top`: Load the result into the top-level browsing context (that is, the browsing context that is an ancestor of the current one, and has no parent). If there is no parent, this option behaves the same way as `_self`.\n\nIf this attribute is specified, this element must come before any other elements with attributes whose values are URLs."
            }
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/base"
          }
        ]
      },
      {
        "name": "link",
        "description": {
          "kind": "markdown",
          "value": "The link element allows authors to link their document to other resources."
        },
        "void": true,
        "attributes": [
          {
            "name": "href",
            "description": {
              "kind": "markdown",
              "value": 'This attribute specifies the [URL](https://developer.mozilla.org/en-US/docs/Glossary/URL "URL: Uniform Resource Locator (URL) is a text string specifying where a resource can be found on the Internet.") of the linked resource. A URL can be absolute or relative.'
            }
          },
          {
            "name": "crossorigin",
            "valueSet": "xo",
            "description": {
              "kind": "markdown",
              "value": 'This enumerated attribute indicates whether [CORS](https://developer.mozilla.org/en-US/docs/Glossary/CORS "CORS: CORS (Cross-Origin Resource Sharing) is a system, consisting of transmitting HTTP headers, that determines whether browsers block frontend JavaScript code from accessing responses for cross-origin requests.") must be used when fetching the resource. [CORS-enabled images](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_Enabled_Image) can be reused in the [`<canvas>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas "Use the HTML <canvas> element with either the canvas scripting API or the WebGL API to draw graphics and animations.") element without being _tainted_. The allowed values are:\n\n`anonymous`\n\nA cross-origin request (i.e. with an [`Origin`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin "The Origin request header indicates where a fetch originates from. It doesn\'t include any path information, but only the server name. It is sent with CORS requests, as well as with POST requests. It is similar to the Referer header, but, unlike this header, it doesn\'t disclose the whole path.") HTTP header) is performed, but no credential is sent (i.e. no cookie, X.509 certificate, or HTTP Basic authentication). If the server does not give credentials to the origin site (by not setting the [`Access-Control-Allow-Origin`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin "The Access-Control-Allow-Origin response header indicates whether the response can be shared with requesting code from the given origin.") HTTP header) the image will be tainted and its usage restricted.\n\n`use-credentials`\n\nA cross-origin request (i.e. with an `Origin` HTTP header) is performed along with a credential sent (i.e. a cookie, certificate, and/or HTTP Basic authentication is performed). If the server does not give credentials to the origin site (through [`Access-Control-Allow-Credentials`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials "The Access-Control-Allow-Credentials response header tells browsers whether to expose the response to frontend JavaScript code when the request\'s credentials mode (Request.credentials) is "include".") HTTP header), the resource will be _tainted_ and its usage restricted.\n\nIf the attribute is not present, the resource is fetched without a [CORS](https://developer.mozilla.org/en-US/docs/Glossary/CORS "CORS: CORS (Cross-Origin Resource Sharing) is a system, consisting of transmitting HTTP headers, that determines whether browsers block frontend JavaScript code from accessing responses for cross-origin requests.") request (i.e. without sending the `Origin` HTTP header), preventing its non-tainted usage. If invalid, it is handled as if the enumerated keyword **anonymous** was used. See [CORS settings attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for additional information.'
            }
          },
          {
            "name": "rel",
            "description": {
              "kind": "markdown",
              "value": "This attribute names a relationship of the linked document to the current document. The attribute must be a space-separated list of the [link types values](https://developer.mozilla.org/en-US/docs/Web/HTML/Link_types)."
            }
          },
          {
            "name": "media",
            "description": {
              "kind": "markdown",
              "value": "This attribute specifies the media that the linked resource applies to. Its value must be a media type / [media query](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_queries). This attribute is mainly useful when linking to external stylesheets — it allows the user agent to pick the best adapted one for the device it runs on.\n\n**Notes:**\n\n*   In HTML 4, this can only be a simple white-space-separated list of media description literals, i.e., [media types and groups](https://developer.mozilla.org/en-US/docs/Web/CSS/@media), where defined and allowed as values for this attribute, such as `print`, `screen`, `aural`, `braille`. HTML5 extended this to any kind of [media queries](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_queries), which are a superset of the allowed values of HTML 4.\n*   Browsers not supporting [CSS3 Media Queries](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_queries) won't necessarily recognize the adequate link; do not forget to set fallback links, the restricted set of media queries defined in HTML 4."
            }
          },
          {
            "name": "hreflang",
            "description": {
              "kind": "markdown",
              "value": "This attribute indicates the language of the linked resource. It is purely advisory. Allowed values are determined by [BCP47](https://www.ietf.org/rfc/bcp/bcp47.txt). Use this attribute only if the [`href`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a#attr-href) attribute is present."
            }
          },
          {
            "name": "type",
            "description": {
              "kind": "markdown",
              "value": 'This attribute is used to define the type of the content linked to. The value of the attribute should be a MIME type such as **text/html**, **text/css**, and so on. The common use of this attribute is to define the type of stylesheet being referenced (such as **text/css**), but given that CSS is the only stylesheet language used on the web, not only is it possible to omit the `type` attribute, but is actually now recommended practice. It is also used on `rel="preload"` link types, to make sure the browser only downloads file types that it supports.'
            }
          },
          {
            "name": "sizes",
            "description": {
              "kind": "markdown",
              "value": "This attribute defines the sizes of the icons for visual media contained in the resource. It must be present only if the [`rel`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/link#attr-rel) contains a value of `icon` or a non-standard type such as Apple's `apple-touch-icon`. It may have the following values:\n\n*   `any`, meaning that the icon can be scaled to any size as it is in a vector format, like `image/svg+xml`.\n*   a white-space separated list of sizes, each in the format `_<width in pixels>_x_<height in pixels>_` or `_<width in pixels>_X_<height in pixels>_`. Each of these sizes must be contained in the resource.\n\n**Note:** Most icon formats are only able to store one single icon; therefore most of the time the [`sizes`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes#attr-sizes) contains only one entry. MS's ICO format does, as well as Apple's ICNS. ICO is more ubiquitous; you should definitely use it."
            }
          },
          {
            "name": "as",
            "description": 'This attribute is only used when `rel="preload"` or `rel="prefetch"` has been set on the `<link>` element. It specifies the type of content being loaded by the `<link>`, which is necessary for content prioritization, request matching, application of correct [content security policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP), and setting of correct [`Accept`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept "The Accept request HTTP header advertises which content types, expressed as MIME types, the client is able to understand. Using content negotiation, the server then selects one of the proposals, uses it and informs the client of its choice with the Content-Type response header. Browsers set adequate values for this header depending on the context where the request is done: when fetching a CSS stylesheet a different value is set for the request than when fetching an image, video or a script.") request header.'
          },
          {
            "name": "importance",
            "description": "Indicates the relative importance of the resource. Priority hints are delegated using the values:"
          },
          {
            "name": "importance",
            "description": '**`auto`**: Indicates **no preference**. The browser may use its own heuristics to decide the priority of the resource.\n\n**`high`**: Indicates to the browser that the resource is of **high** priority.\n\n**`low`**: Indicates to the browser that the resource is of **low** priority.\n\n**Note:** The `importance` attribute may only be used for the `<link>` element if `rel="preload"` or `rel="prefetch"` is present.'
          },
          {
            "name": "integrity",
            "description": "Contains inline metadata — a base64-encoded cryptographic hash of the resource (file) you’re telling the browser to fetch. The browser can use this to verify that the fetched resource has been delivered free of unexpected manipulation. See [Subresource Integrity](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity)."
          },
          {
            "name": "referrerpolicy",
            "description": 'A string indicating which referrer to use when fetching the resource:\n\n*   `no-referrer` means that the [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer "The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.") header will not be sent.\n*   `no-referrer-when-downgrade` means that no [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer "The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.") header will be sent when navigating to an origin without TLS (HTTPS). This is a user agent’s default behavior, if no policy is otherwise specified.\n*   `origin` means that the referrer will be the origin of the page, which is roughly the scheme, the host, and the port.\n*   `origin-when-cross-origin` means that navigating to other origins will be limited to the scheme, the host, and the port, while navigating on the same origin will include the referrer\'s path.\n*   `unsafe-url` means that the referrer will include the origin and the path (but not the fragment, password, or username). This case is unsafe because it can leak origins and paths from TLS-protected resources to insecure origins.'
          },
          {
            "name": "title",
            "description": 'The `title` attribute has special semantics on the `<link>` element. When used on a `<link rel="stylesheet">` it defines a [preferred or an alternate stylesheet](https://developer.mozilla.org/en-US/docs/Web/CSS/Alternative_style_sheets). Incorrectly using it may [cause the stylesheet to be ignored](https://developer.mozilla.org/en-US/docs/Correctly_Using_Titles_With_External_Stylesheets).'
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/link"
          }
        ]
      },
      {
        "name": "meta",
        "description": {
          "kind": "markdown",
          "value": "The meta element represents various kinds of metadata that cannot be expressed using the title, base, link, style, and script elements."
        },
        "void": true,
        "attributes": [
          {
            "name": "name",
            "description": {
              "kind": "markdown",
              "value": 'This attribute defines the name of a piece of document-level metadata. It should not be set if one of the attributes [`itemprop`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes#attr-itemprop), [`http-equiv`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-http-equiv) or [`charset`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-charset) is also set.\n\nThis metadata name is associated with the value contained by the [`content`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-content) attribute. The possible values for the name attribute are:\n\n*   `application-name` which defines the name of the application running in the web page.\n    \n    **Note:**\n    \n    *   Browsers may use this to identify the application. It is different from the [`<title>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/title "The HTML Title element (<title>) defines the document\'s title that is shown in a browser\'s title bar or a page\'s tab.") element, which usually contain the application name, but may also contain information like the document name or a status.\n    *   Simple web pages shouldn\'t define an application-name.\n    \n*   `author` which defines the name of the document\'s author.\n*   `description` which contains a short and accurate summary of the content of the page. Several browsers, like Firefox and Opera, use this as the default description of bookmarked pages.\n*   `generator` which contains the identifier of the software that generated the page.\n*   `keywords` which contains words relevant to the page\'s content separated by commas.\n*   `referrer` which controls the [`Referer` HTTP header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer) attached to requests sent from the document:\n    \n    Values for the `content` attribute of `<meta name="referrer">`\n    \n    `no-referrer`\n    \n    Do not send a HTTP `Referrer` header.\n    \n    `origin`\n    \n    Send the [origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) of the document.\n    \n    `no-referrer-when-downgrade`\n    \n    Send the [origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) as a referrer to URLs as secure as the current page, (https→https), but does not send a referrer to less secure URLs (https→http). This is the default behaviour.\n    \n    `origin-when-cross-origin`\n    \n    Send the full URL (stripped of parameters) for same-origin requests, but only send the [origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) for other cases.\n    \n    `same-origin`\n    \n    A referrer will be sent for [same-site origins](https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy), but cross-origin requests will contain no referrer information.\n    \n    `strict-origin`\n    \n    Only send the origin of the document as the referrer to a-priori as-much-secure destination (HTTPS->HTTPS), but don\'t send it to a less secure destination (HTTPS->HTTP).\n    \n    `strict-origin-when-cross-origin`\n    \n    Send a full URL when performing a same-origin request, only send the origin of the document to a-priori as-much-secure destination (HTTPS->HTTPS), and send no header to a less secure destination (HTTPS->HTTP).\n    \n    `unsafe-URL`\n    \n    Send the full URL (stripped of parameters) for same-origin or cross-origin requests.\n    \n    **Notes:**\n    \n    *   Some browsers support the deprecated values of `always`, `default`, and `never` for referrer.\n    *   Dynamically inserting `<meta name="referrer">` (with [`document.write`](https://developer.mozilla.org/en-US/docs/Web/API/Document/write) or [`appendChild`](https://developer.mozilla.org/en-US/docs/Web/API/Node/appendChild)) makes the referrer behaviour unpredictable.\n    *   When several conflicting policies are defined, the no-referrer policy is applied.\n    \n\nThis attribute may also have a value taken from the extended list defined on [WHATWG Wiki MetaExtensions page](https://wiki.whatwg.org/wiki/MetaExtensions). Although none have been formally accepted yet, a few commonly used names are:\n\n*   `creator` which defines the name of the creator of the document, such as an organization or institution. If there are more than one, several [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") elements should be used.\n*   `googlebot`, a synonym of `robots`, is only followed by Googlebot (the indexing crawler for Google).\n*   `publisher` which defines the name of the document\'s publisher.\n*   `robots` which defines the behaviour that cooperative crawlers, or "robots", should use with the page. It is a comma-separated list of the values below:\n    \n    Values for the content of `<meta name="robots">`\n    \n    Value\n    \n    Description\n    \n    Used by\n    \n    `index`\n    \n    Allows the robot to index the page (default).\n    \n    All\n    \n    `noindex`\n    \n    Requests the robot to not index the page.\n    \n    All\n    \n    `follow`\n    \n    Allows the robot to follow the links on the page (default).\n    \n    All\n    \n    `nofollow`\n    \n    Requests the robot to not follow the links on the page.\n    \n    All\n    \n    `none`\n    \n    Equivalent to `noindex, nofollow`\n    \n    [Google](https://support.google.com/webmasters/answer/79812)\n    \n    `noodp`\n    \n    Prevents using the [Open Directory Project](https://www.dmoz.org/) description, if any, as the page description in search engine results.\n    \n    [Google](https://support.google.com/webmasters/answer/35624#nodmoz), [Yahoo](https://help.yahoo.com/kb/search-for-desktop/meta-tags-robotstxt-yahoo-search-sln2213.html#cont5), [Bing](https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240)\n    \n    `noarchive`\n    \n    Requests the search engine not to cache the page content.\n    \n    [Google](https://developers.google.com/webmasters/control-crawl-index/docs/robots_meta_tag#valid-indexing--serving-directives), [Yahoo](https://help.yahoo.com/kb/search-for-desktop/SLN2213.html), [Bing](https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240)\n    \n    `nosnippet`\n    \n    Prevents displaying any description of the page in search engine results.\n    \n    [Google](https://developers.google.com/webmasters/control-crawl-index/docs/robots_meta_tag#valid-indexing--serving-directives), [Bing](https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240)\n    \n    `noimageindex`\n    \n    Requests this page not to appear as the referring page of an indexed image.\n    \n    [Google](https://developers.google.com/webmasters/control-crawl-index/docs/robots_meta_tag#valid-indexing--serving-directives)\n    \n    `nocache`\n    \n    Synonym of `noarchive`.\n    \n    [Bing](https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240)\n    \n    **Notes:**\n    \n    *   Only cooperative robots follow these rules. Do not expect to prevent e-mail harvesters with them.\n    *   The robot still needs to access the page in order to read these rules. To prevent bandwidth consumption, use a _[robots.txt](https://developer.mozilla.org/en-US/docs/Glossary/robots.txt "robots.txt: Robots.txt is a file which is usually placed in the root of any website. It decides whether crawlers are permitted or forbidden access to the web site.")_ file.\n    *   If you want to remove a page, `noindex` will work, but only after the robot visits the page again. Ensure that the `robots.txt` file is not preventing revisits.\n    *   Some values are mutually exclusive, like `index` and `noindex`, or `follow` and `nofollow`. In these cases the robot\'s behaviour is undefined and may vary between them.\n    *   Some crawler robots, like Google, Yahoo and Bing, support the same values for the HTTP header `X-Robots-Tag`; this allows non-HTML documents like images to use these rules.\n    \n*   `slurp`, is a synonym of `robots`, but only for Slurp - the crawler for Yahoo Search.\n*   `viewport`, which gives hints about the size of the initial size of the [viewport](https://developer.mozilla.org/en-US/docs/Glossary/viewport "viewport: A viewport represents a polygonal (normally rectangular) area in computer graphics that is currently being viewed. In web browser terms, it refers to the part of the document you\'re viewing which is currently visible in its window (or the screen, if the document is being viewed in full screen mode). Content outside the viewport is not visible onscreen until scrolled into view."). Used by mobile devices only.\n    \n    Values for the content of `<meta name="viewport">`\n    \n    Value\n    \n    Possible subvalues\n    \n    Description\n    \n    `width`\n    \n    A positive integer number, or the text `device-width`\n    \n    Defines the pixel width of the viewport that you want the web site to be rendered at.\n    \n    `height`\n    \n    A positive integer, or the text `device-height`\n    \n    Defines the height of the viewport. Not used by any browser.\n    \n    `initial-scale`\n    \n    A positive number between `0.0` and `10.0`\n    \n    Defines the ratio between the device width (`device-width` in portrait mode or `device-height` in landscape mode) and the viewport size.\n    \n    `maximum-scale`\n    \n    A positive number between `0.0` and `10.0`\n    \n    Defines the maximum amount to zoom in. It must be greater or equal to the `minimum-scale` or the behaviour is undefined. Browser settings can ignore this rule and iOS10+ ignores it by default.\n    \n    `minimum-scale`\n    \n    A positive number between `0.0` and `10.0`\n    \n    Defines the minimum zoom level. It must be smaller or equal to the `maximum-scale` or the behaviour is undefined. Browser settings can ignore this rule and iOS10+ ignores it by default.\n    \n    `user-scalable`\n    \n    `yes` or `no`\n    \n    If set to `no`, the user is not able to zoom in the webpage. The default is `yes`. Browser settings can ignore this rule, and iOS10+ ignores it by default.\n    \n    Specification\n    \n    Status\n    \n    Comment\n    \n    [CSS Device Adaptation  \n    The definition of \'<meta name="viewport">\' in that specification.](https://drafts.csswg.org/css-device-adapt/#viewport-meta)\n    \n    Working Draft\n    \n    Non-normatively describes the Viewport META element\n    \n    See also: [`@viewport`](https://developer.mozilla.org/en-US/docs/Web/CSS/@viewport "The @viewport CSS at-rule lets you configure the viewport through which the document is viewed. It\'s primarily used for mobile devices, but is also used by desktop browsers that support features like "snap to edge" (such as Microsoft Edge).")\n    \n    **Notes:**\n    \n    *   Though unstandardized, this declaration is respected by most mobile browsers due to de-facto dominance.\n    *   The default values may vary between devices and browsers.\n    *   To learn about this declaration in Firefox for Mobile, see [this article](https://developer.mozilla.org/en-US/docs/Mobile/Viewport_meta_tag "Mobile/Viewport meta tag").'
            }
          },
          {
            "name": "http-equiv",
            "description": {
              "kind": "markdown",
              "value": 'Defines a pragma directive. The attribute is named `**http-equiv**(alent)` because all the allowed values are names of particular HTTP headers:\n\n*   `"content-language"`  \n    Defines the default language of the page. It can be overridden by the [lang](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/lang) attribute on any element.\n    \n    **Warning:** Do not use this value, as it is obsolete. Prefer the `lang` attribute on the [`<html>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/html "The HTML <html> element represents the root (top-level element) of an HTML document, so it is also referred to as the root element. All other elements must be descendants of this element.") element.\n    \n*   `"content-security-policy"`  \n    Allows page authors to define a [content policy](https://developer.mozilla.org/en-US/docs/Web/Security/CSP/CSP_policy_directives) for the current page. Content policies mostly specify allowed server origins and script endpoints which help guard against cross-site scripting attacks.\n*   `"content-type"`  \n    Defines the [MIME type](https://developer.mozilla.org/en-US/docs/Glossary/MIME_type) of the document, followed by its character encoding. It follows the same syntax as the HTTP `content-type` entity-header field, but as it is inside a HTML page, most values other than `text/html` are impossible. Therefore the valid syntax for its `content` is the string \'`text/html`\' followed by a character set with the following syntax: \'`; charset=_IANAcharset_`\', where `IANAcharset` is the _preferred MIME name_ for a character set as [defined by the IANA.](https://www.iana.org/assignments/character-sets)\n    \n    **Warning:** Do not use this value, as it is obsolete. Use the [`charset`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-charset) attribute on the [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") element.\n    \n    **Note:** As [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") can\'t change documents\' types in XHTML or HTML5\'s XHTML serialization, never set the MIME type to an XHTML MIME type with `<meta>`.\n    \n*   `"refresh"`  \n    This instruction specifies:\n    *   The number of seconds until the page should be reloaded - only if the [`content`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-content) attribute contains a positive integer.\n    *   The number of seconds until the page should redirect to another - only if the [`content`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-content) attribute contains a positive integer followed by the string \'`;url=`\', and a valid URL.\n*   `"set-cookie"`  \n    Defines a [cookie](https://developer.mozilla.org/en-US/docs/cookie) for the page. Its content must follow the syntax defined in the [IETF HTTP Cookie Specification](https://tools.ietf.org/html/draft-ietf-httpstate-cookie-14).\n    \n    **Warning:** Do not use this instruction, as it is obsolete. Use the HTTP header [`Set-Cookie`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) instead.'
            }
          },
          {
            "name": "content",
            "description": {
              "kind": "markdown",
              "value": "This attribute contains the value for the [`http-equiv`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-http-equiv) or [`name`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-name) attribute, depending on which is used."
            }
          },
          {
            "name": "charset",
            "description": {
              "kind": "markdown",
              "value": 'This attribute declares the page\'s character encoding. It must contain a [standard IANA MIME name for character encodings](https://www.iana.org/assignments/character-sets). Although the standard doesn\'t request a specific encoding, it suggests:\n\n*   Authors are encouraged to use [`UTF-8`](https://developer.mozilla.org/en-US/docs/Glossary/UTF-8).\n*   Authors should not use ASCII-incompatible encodings to avoid security risk: browsers not supporting them may interpret harmful content as HTML. This happens with the `JIS_C6226-1983`, `JIS_X0212-1990`, `HZ-GB-2312`, `JOHAB`, the ISO-2022 family and the EBCDIC family.\n\n**Note:** ASCII-incompatible encodings are those that don\'t map the 8-bit code points `0x20` to `0x7E` to the `0x0020` to `0x007E` Unicode code points)\n\n*   Authors **must not** use `CESU-8`, `UTF-7`, `BOCU-1` and/or `SCSU` as [cross-site scripting](https://developer.mozilla.org/en-US/docs/Glossary/Cross-site_scripting) attacks with these encodings have been demonstrated.\n*   Authors should not use `UTF-32` because not all HTML5 encoding algorithms can distinguish it from `UTF-16`.\n\n**Notes:**\n\n*   The declared character encoding must match the one the page was saved with to avoid garbled characters and security holes.\n*   The [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") element declaring the encoding must be inside the [`<head>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/head "The HTML <head> element provides general information (metadata) about the document, including its title and links to its scripts and style sheets.") element and **within the first 1024 bytes** of the HTML as some browsers only look at those bytes before choosing an encoding.\n*   This [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") element is only one part of the [algorithm to determine a page\'s character set](https://www.whatwg.org/specs/web-apps/current-work/multipage/parsing.html#encoding-sniffing-algorithm "Algorithm charset page"). The [`Content-Type` header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Type) and any [Byte-Order Marks](https://developer.mozilla.org/en-US/docs/Glossary/Byte-Order_Mark "The definition of that term (Byte-Order Marks) has not been written yet; please consider contributing it!") override this element.\n*   It is strongly recommended to define the character encoding. If a page\'s encoding is undefined, cross-scripting techniques are possible, such as the [`UTF-7` fallback cross-scripting technique](https://code.google.com/p/doctype-mirror/wiki/ArticleUtf7).\n*   The [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") element with a `charset` attribute is a synonym for the pre-HTML5 `<meta http-equiv="Content-Type" content="text/html; charset=_IANAcharset_">`, where _`IANAcharset`_ contains the value of the equivalent [`charset`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-charset) attribute. This syntax is still allowed, although no longer recommended.'
            }
          },
          {
            "name": "scheme",
            "description": "This attribute defines the scheme in which metadata is described. A scheme is a context leading to the correct interpretations of the [`content`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-content) value, like a format.\n\n**Warning:** Do not use this value, as it is obsolete. There is no replacement as there was no real usage for it."
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/meta"
          }
        ]
      },
      {
        "name": "style",
        "description": {
          "kind": "markdown",
          "value": "The style element allows authors to embed style information in their documents. The style element is one of several inputs to the styling processing model. The element does not represent content for the user."
        },
        "attributes": [
          {
            "name": "media",
            "description": {
              "kind": "markdown",
              "value": "This attribute defines which media the style should be applied to. Its value is a [media query](https://developer.mozilla.org/en-US/docs/Web/Guide/CSS/Media_queries), which defaults to `all` if the attribute is missing."
            }
          },
          {
            "name": "nonce",
            "description": {
              "kind": "markdown",
              "value": "A cryptographic nonce (number used once) used to whitelist inline styles in a [style-src Content-Security-Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/style-src). The server must generate a unique nonce value each time it transmits a policy. It is critical to provide a nonce that cannot be guessed as bypassing a resource’s policy is otherwise trivial."
            }
          },
          {
            "name": "type",
            "description": {
              "kind": "markdown",
              "value": "This attribute defines the styling language as a MIME type (charset should not be specified). This attribute is optional and defaults to `text/css` if it is not specified — there is very little reason to include this in modern web documents."
            }
          },
          {
            "name": "scoped",
            "valueSet": "v"
          },
          {
            "name": "title",
            "description": "This attribute specifies [alternative style sheet](https://developer.mozilla.org/en-US/docs/Web/CSS/Alternative_style_sheets) sets."
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/style"
          }
        ]
      },
      {
        "name": "body",
        "description": {
          "kind": "markdown",
          "value": "The body element represents the content of the document."
        },
        "attributes": [
          {
            "name": "onafterprint",
            "description": {
              "kind": "markdown",
              "value": "Function to call after the user has printed the document."
            }
          },
          {
            "name": "onbeforeprint",
            "description": {
              "kind": "markdown",
              "value": "Function to call when the user requests printing of the document."
            }
          },
          {
            "name": "onbeforeunload",
            "description": {
              "kind": "markdown",
              "value": "Function to call when the document is about to be unloaded."
            }
          },
          {
            "name": "onhashchange",
            "description": {
              "kind": "markdown",
              "value": "Function to call when the fragment identifier part (starting with the hash (`'#'`) character) of the document's current address has changed."
            }
          },
          {
            "name": "onlanguagechange",
            "description": {
              "kind": "markdown",
              "value": "Function to call when the preferred languages changed."
            }
          },
          {
            "name": "onmessage",
            "description": {
              "kind": "markdown",
              "value": "Function to call when the document has received a message."
            }
          },
          {
            "name": "onoffline",
            "description": {
              "kind": "markdown",
              "value": "Function to call when network communication has failed."
            }
          },
          {
            "name": "ononline",
            "description": {
              "kind": "markdown",
              "value": "Function to call when network communication has been restored."
            }
          },
          {
            "name": "onpagehide"
          },
          {
            "name": "onpageshow"
          },
          {
            "name": "onpopstate",
            "description": {
              "kind": "markdown",
              "value": "Function to call when the user has navigated session history."
            }
          },
          {
            "name": "onstorage",
            "description": {
              "kind": "markdown",
              "value": "Function to call when the storage area has changed."
            }
          },
          {
            "name": "onunload",
            "description": {
              "kind": "markdown",
              "value": "Function to call when the document is going away."
            }
          },
          {
            "name": "alink",
            "description": 'Color of text for hyperlinks when selected. _This method is non-conforming, use CSS [`color`](https://developer.mozilla.org/en-US/docs/Web/CSS/color "The color CSS property sets the foreground color value of an element\'s text and text decorations, and sets the currentcolor value.") property in conjunction with the [`:active`](https://developer.mozilla.org/en-US/docs/Web/CSS/:active "The :active CSS pseudo-class represents an element (such as a button) that is being activated by the user.") pseudo-class instead._'
          },
          {
            "name": "background",
            "description": 'URI of a image to use as a background. _This method is non-conforming, use CSS [`background`](https://developer.mozilla.org/en-US/docs/Web/CSS/background "The background shorthand CSS property sets all background style properties at once, such as color, image, origin and size, or repeat method.") property on the element instead._'
          },
          {
            "name": "bgcolor",
            "description": 'Background color for the document. _This method is non-conforming, use CSS [`background-color`](https://developer.mozilla.org/en-US/docs/Web/CSS/background-color "The background-color CSS property sets the background color of an element.") property on the element instead._'
          },
          {
            "name": "bottommargin",
            "description": 'The margin of the bottom of the body. _This method is non-conforming, use CSS [`margin-bottom`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-bottom "The margin-bottom CSS property sets the margin area on the bottom of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") property on the element instead._'
          },
          {
            "name": "leftmargin",
            "description": 'The margin of the left of the body. _This method is non-conforming, use CSS [`margin-left`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-left "The margin-left CSS property sets the margin area on the left side of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") property on the element instead._'
          },
          {
            "name": "link",
            "description": 'Color of text for unvisited hypertext links. _This method is non-conforming, use CSS [`color`](https://developer.mozilla.org/en-US/docs/Web/CSS/color "The color CSS property sets the foreground color value of an element\'s text and text decorations, and sets the currentcolor value.") property in conjunction with the [`:link`](https://developer.mozilla.org/en-US/docs/Web/CSS/:link "The :link CSS pseudo-class represents an element that has not yet been visited. It matches every unvisited <a>, <area>, or <link> element that has an href attribute.") pseudo-class instead._'
          },
          {
            "name": "onblur",
            "description": "Function to call when the document loses focus."
          },
          {
            "name": "onerror",
            "description": "Function to call when the document fails to load properly."
          },
          {
            "name": "onfocus",
            "description": "Function to call when the document receives focus."
          },
          {
            "name": "onload",
            "description": "Function to call when the document has finished loading."
          },
          {
            "name": "onredo",
            "description": "Function to call when the user has moved forward in undo transaction history."
          },
          {
            "name": "onresize",
            "description": "Function to call when the document has been resized."
          },
          {
            "name": "onundo",
            "description": "Function to call when the user has moved backward in undo transaction history."
          },
          {
            "name": "rightmargin",
            "description": 'The margin of the right of the body. _This method is non-conforming, use CSS [`margin-right`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-right "The margin-right CSS property sets the margin area on the right side of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") property on the element instead._'
          },
          {
            "name": "text",
            "description": 'Foreground color of text. _This method is non-conforming, use CSS [`color`](https://developer.mozilla.org/en-US/docs/Web/CSS/color "The color CSS property sets the foreground color value of an element\'s text and text decorations, and sets the currentcolor value.") property on the element instead._'
          },
          {
            "name": "topmargin",
            "description": 'The margin of the top of the body. _This method is non-conforming, use CSS [`margin-top`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-top "The margin-top CSS property sets the margin area on the top of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") property on the element instead._'
          },
          {
            "name": "vlink",
            "description": 'Color of text for visited hypertext links. _This method is non-conforming, use CSS [`color`](https://developer.mozilla.org/en-US/docs/Web/CSS/color "The color CSS property sets the foreground color value of an element\'s text and text decorations, and sets the currentcolor value.") property in conjunction with the [`:visited`](https://developer.mozilla.org/en-US/docs/Web/CSS/:visited "The :visited CSS pseudo-class represents links that the user has already visited. For privacy reasons, the styles that can be modified using this selector are very limited.") pseudo-class instead._'
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/body"
          }
        ]
      },
      {
        "name": "article",
        "description": {
          "kind": "markdown",
          "value": "The article element represents a complete, or self-contained, composition in a document, page, application, or site and that is, in principle, independently distributable or reusable, e.g. in syndication. This could be a forum post, a magazine or newspaper article, a blog entry, a user-submitted comment, an interactive widget or gadget, or any other independent item of content. Each article should be identified, typically by including a heading (h1–h6 element) as a child of the article element."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/article"
          }
        ]
      },
      {
        "name": "section",
        "description": {
          "kind": "markdown",
          "value": "The section element represents a generic section of a document or application. A section, in this context, is a thematic grouping of content. Each section should be identified, typically by including a heading ( h1- h6 element) as a child of the section element."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/section"
          }
        ]
      },
      {
        "name": "nav",
        "description": {
          "kind": "markdown",
          "value": "The nav element represents a section of a page that links to other pages or to parts within the page: a section with navigation links."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/nav"
          }
        ]
      },
      {
        "name": "aside",
        "description": {
          "kind": "markdown",
          "value": "The aside element represents a section of a page that consists of content that is tangentially related to the content around the aside element, and which could be considered separate from that content. Such sections are often represented as sidebars in printed typography."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/aside"
          }
        ]
      },
      {
        "name": "h1",
        "description": {
          "kind": "markdown",
          "value": "The h1 element represents a section heading."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"
          }
        ]
      },
      {
        "name": "h2",
        "description": {
          "kind": "markdown",
          "value": "The h2 element represents a section heading."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"
          }
        ]
      },
      {
        "name": "h3",
        "description": {
          "kind": "markdown",
          "value": "The h3 element represents a section heading."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"
          }
        ]
      },
      {
        "name": "h4",
        "description": {
          "kind": "markdown",
          "value": "The h4 element represents a section heading."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"
          }
        ]
      },
      {
        "name": "h5",
        "description": {
          "kind": "markdown",
          "value": "The h5 element represents a section heading."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"
          }
        ]
      },
      {
        "name": "h6",
        "description": {
          "kind": "markdown",
          "value": "The h6 element represents a section heading."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"
          }
        ]
      },
      {
        "name": "header",
        "description": {
          "kind": "markdown",
          "value": "The header element represents introductory content for its nearest ancestor sectioning content or sectioning root element. A header typically contains a group of introductory or navigational aids. When the nearest ancestor sectioning content or sectioning root element is the body element, then it applies to the whole page."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/header"
          }
        ]
      },
      {
        "name": "footer",
        "description": {
          "kind": "markdown",
          "value": "The footer element represents a footer for its nearest ancestor sectioning content or sectioning root element. A footer typically contains information about its section such as who wrote it, links to related documents, copyright data, and the like."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/footer"
          }
        ]
      },
      {
        "name": "address",
        "description": {
          "kind": "markdown",
          "value": "The address element represents the contact information for its nearest article or body element ancestor. If that is the body element, then the contact information applies to the document as a whole."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/address"
          }
        ]
      },
      {
        "name": "p",
        "description": {
          "kind": "markdown",
          "value": "The p element represents a paragraph."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/p"
          }
        ]
      },
      {
        "name": "hr",
        "description": {
          "kind": "markdown",
          "value": "The hr element represents a paragraph-level thematic break, e.g. a scene change in a story, or a transition to another topic within a section of a reference book."
        },
        "void": true,
        "attributes": [
          {
            "name": "align",
            "description": "Sets the alignment of the rule on the page. If no value is specified, the default value is `left`."
          },
          {
            "name": "color",
            "description": "Sets the color of the rule through color name or hexadecimal value."
          },
          {
            "name": "noshade",
            "description": "Sets the rule to have no shading."
          },
          {
            "name": "size",
            "description": "Sets the height, in pixels, of the rule."
          },
          {
            "name": "width",
            "description": "Sets the length of the rule on the page through a pixel or percentage value."
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/hr"
          }
        ]
      },
      {
        "name": "pre",
        "description": {
          "kind": "markdown",
          "value": "The pre element represents a block of preformatted text, in which structure is represented by typographic conventions rather than by elements."
        },
        "attributes": [
          {
            "name": "cols",
            "description": 'Contains the _preferred_ count of characters that a line should have. It was a non-standard synonym of [`width`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/pre#attr-width). To achieve such an effect, use CSS [`width`](https://developer.mozilla.org/en-US/docs/Web/CSS/width "The width CSS property sets an element\'s width. By default it sets the width of the content area, but if box-sizing is set to border-box, it sets the width of the border area.") instead.'
          },
          {
            "name": "width",
            "description": 'Contains the _preferred_ count of characters that a line should have. Though technically still implemented, this attribute has no visual effect; to achieve such an effect, use CSS [`width`](https://developer.mozilla.org/en-US/docs/Web/CSS/width "The width CSS property sets an element\'s width. By default it sets the width of the content area, but if box-sizing is set to border-box, it sets the width of the border area.") instead.'
          },
          {
            "name": "wrap",
            "description": 'Is a _hint_ indicating how the overflow must happen. In modern browser this hint is ignored and no visual effect results in its present; to achieve such an effect, use CSS [`white-space`](https://developer.mozilla.org/en-US/docs/Web/CSS/white-space "The white-space CSS property sets how white space inside an element is handled.") instead.'
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/pre"
          }
        ]
      },
      {
        "name": "blockquote",
        "description": {
          "kind": "markdown",
          "value": "The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element, and optionally with in-line changes such as annotations and abbreviations."
        },
        "attributes": [
          {
            "name": "cite",
            "description": {
              "kind": "markdown",
              "value": "A URL that designates a source document or message for the information quoted. This attribute is intended to point to information explaining the context or the reference for the quote."
            }
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/blockquote"
          }
        ]
      },
      {
        "name": "ol",
        "description": {
          "kind": "markdown",
          "value": "The ol element represents a list of items, where the items have been intentionally ordered, such that changing the order would change the meaning of the document."
        },
        "attributes": [
          {
            "name": "reversed",
            "valueSet": "v",
            "description": {
              "kind": "markdown",
              "value": "This Boolean attribute specifies that the items of the list are specified in reversed order."
            }
          },
          {
            "name": "start",
            "description": {
              "kind": "markdown",
              "value": 'This integer attribute specifies the start value for numbering the individual list items. Although the ordering type of list elements might be Roman numerals, such as XXXI, or letters, the value of start is always represented as a number. To start numbering elements from the letter "C", use `<ol start="3">`.\n\n**Note**: This attribute was deprecated in HTML4, but reintroduced in HTML5.'
            }
          },
          {
            "name": "type",
            "valueSet": "lt",
            "description": {
              "kind": "markdown",
              "value": "Indicates the numbering type:\n\n*   `'a'` indicates lowercase letters,\n*   `'A'` indicates uppercase letters,\n*   `'i'` indicates lowercase Roman numerals,\n*   `'I'` indicates uppercase Roman numerals,\n*   and `'1'` indicates numbers (default).\n\nThe type set is used for the entire list unless a different [`type`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/li#attr-type) attribute is used within an enclosed [`<li>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/li \"The HTML <li> element is used to represent an item in a list. It must be contained in a parent element: an ordered list (<ol>), an unordered list (<ul>), or a menu (<menu>). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter.\") element.\n\n**Note:** This attribute was deprecated in HTML4, but reintroduced in HTML5.\n\nUnless the value of the list number matters (e.g. in legal or technical documents where items are to be referenced by their number/letter), the CSS [`list-style-type`](https://developer.mozilla.org/en-US/docs/Web/CSS/list-style-type \"The list-style-type CSS property sets the marker (such as a disc, character, or custom counter style) of a list item element.\") property should be used instead."
            }
          },
          {
            "name": "compact",
            "description": 'This Boolean attribute hints that the list should be rendered in a compact style. The interpretation of this attribute depends on the user agent and it doesn\'t work in all browsers.\n\n**Warning:** Do not use this attribute, as it has been deprecated: the [`<ol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol "The HTML <ol> element represents an ordered list of items, typically rendered as a numbered list.") element should be styled using [CSS](https://developer.mozilla.org/en-US/docs/CSS). To give an effect similar to the `compact` attribute, the [CSS](https://developer.mozilla.org/en-US/docs/CSS) property [`line-height`](https://developer.mozilla.org/en-US/docs/Web/CSS/line-height "The line-height CSS property sets the amount of space used for lines, such as in text. On block-level elements, it specifies the minimum height of line boxes within the element. On non-replaced inline elements, it specifies the height that is used to calculate line box height.") can be used with a value of `80%`.'
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/ol"
          }
        ]
      },
      {
        "name": "ul",
        "description": {
          "kind": "markdown",
          "value": "The ul element represents a list of items, where the order of the items is not important — that is, where changing the order would not materially change the meaning of the document."
        },
        "attributes": [
          {
            "name": "compact",
            "description": 'This Boolean attribute hints that the list should be rendered in a compact style. The interpretation of this attribute depends on the user agent and it doesn\'t work in all browsers.\n\n**Usage note: **Do not use this attribute, as it has been deprecated: the [`<ul>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ul "The HTML <ul> element represents an unordered list of items, typically rendered as a bulleted list.") element should be styled using [CSS](https://developer.mozilla.org/en-US/docs/CSS). To give a similar effect as the `compact` attribute, the [CSS](https://developer.mozilla.org/en-US/docs/CSS) property [line-height](https://developer.mozilla.org/en-US/docs/CSS/line-height) can be used with a value of `80%`.'
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/ul"
          }
        ]
      },
      {
        "name": "li",
        "description": {
          "kind": "markdown",
          "value": "The li element represents a list item. If its parent element is an ol, ul, or menu element, then the element is an item of the parent element's list, as defined for those elements. Otherwise, the list item has no defined list-related relationship to any other li element."
        },
        "attributes": [
          {
            "name": "value",
            "description": {
              "kind": "markdown",
              "value": 'This integer attribute indicates the current ordinal value of the list item as defined by the [`<ol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol "The HTML <ol> element represents an ordered list of items, typically rendered as a numbered list.") element. The only allowed value for this attribute is a number, even if the list is displayed with Roman numerals or letters. List items that follow this one continue numbering from the value set. The **value** attribute has no meaning for unordered lists ([`<ul>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ul "The HTML <ul> element represents an unordered list of items, typically rendered as a bulleted list.")) or for menus ([`<menu>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/menu "The HTML <menu> element represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked.")).\n\n**Note**: This attribute was deprecated in HTML4, but reintroduced in HTML5.\n\n**Note:** Prior to Gecko 9.0, negative values were incorrectly converted to 0. Starting in Gecko 9.0 all integer values are correctly parsed.'
            }
          },
          {
            "name": "type",
            "description": 'This character attribute indicates the numbering type:\n\n*   `a`: lowercase letters\n*   `A`: uppercase letters\n*   `i`: lowercase Roman numerals\n*   `I`: uppercase Roman numerals\n*   `1`: numbers\n\nThis type overrides the one used by its parent [`<ol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol "The HTML <ol> element represents an ordered list of items, typically rendered as a numbered list.") element, if any.\n\n**Usage note:** This attribute has been deprecated: use the CSS [`list-style-type`](https://developer.mozilla.org/en-US/docs/Web/CSS/list-style-type "The list-style-type CSS property sets the marker (such as a disc, character, or custom counter style) of a list item element.") property instead.'
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/li"
          }
        ]
      },
      {
        "name": "dl",
        "description": {
          "kind": "markdown",
          "value": "The dl element represents an association list consisting of zero or more name-value groups (a description list). A name-value group consists of one or more names (dt elements) followed by one or more values (dd elements), ignoring any nodes other than dt and dd elements. Within a single dl element, there should not be more than one dt element for each name."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/dl"
          }
        ]
      },
      {
        "name": "dt",
        "description": {
          "kind": "markdown",
          "value": "The dt element represents the term, or name, part of a term-description group in a description list (dl element)."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/dt"
          }
        ]
      },
      {
        "name": "dd",
        "description": {
          "kind": "markdown",
          "value": "The dd element represents the description, definition, or value, part of a term-description group in a description list (dl element)."
        },
        "attributes": [
          {
            "name": "nowrap",
            "description": "If the value of this attribute is set to `yes`, the definition text will not wrap. The default value is `no`."
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/dd"
          }
        ]
      },
      {
        "name": "figure",
        "description": {
          "kind": "markdown",
          "value": "The figure element represents some flow content, optionally with a caption, that is self-contained (like a complete sentence) and is typically referenced as a single unit from the main flow of the document."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/figure"
          }
        ]
      },
      {
        "name": "figcaption",
        "description": {
          "kind": "markdown",
          "value": "The figcaption element represents a caption or legend for the rest of the contents of the figcaption element's parent figure element, if any."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/figcaption"
          }
        ]
      },
      {
        "name": "main",
        "description": {
          "kind": "markdown",
          "value": "The main element represents the main content of the body of a document or application. The main content area consists of content that is directly related to or expands upon the central topic of a document or central functionality of an application."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/main"
          }
        ]
      },
      {
        "name": "div",
        "description": {
          "kind": "markdown",
          "value": "The div element has no special meaning at all. It represents its children. It can be used with the class, lang, and title attributes to mark up semantics common to a group of consecutive elements."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/div"
          }
        ]
      },
      {
        "name": "a",
        "description": {
          "kind": "markdown",
          "value": "If the a element has an href attribute, then it represents a hyperlink (a hypertext anchor) labeled by its contents."
        },
        "attributes": [
          {
            "name": "href",
            "description": {
              "kind": "markdown",
              "value": 'Contains a URL or a URL fragment that the hyperlink points to.\nA URL fragment is a name preceded by a hash mark (`#`), which specifies an internal target location (an [`id`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes#attr-id) of an HTML element) within the current document. URLs are not restricted to Web (HTTP)-based documents, but can use any protocol supported by the browser. For example, [`file:`](https://en.wikipedia.org/wiki/File_URI_scheme), `ftp:`, and `mailto:` work in most browsers.\n\n**Note:** You can use `href="#top"` or the empty fragment `href="#"` to link to the top of the current page. [This behavior is specified by HTML5](https://www.w3.org/TR/html5/single-page.html#scroll-to-fragid).'
            }
          },
          {
            "name": "target",
            "valueSet": "target",
            "description": {
              "kind": "markdown",
              "value": 'Specifies where to display the linked URL. It is a name of, or keyword for, a _browsing context_: a tab, window, or `<iframe>`. The following keywords have special meanings:\n\n*   `_self`: Load the URL into the same browsing context as the current one. This is the default behavior.\n*   `_blank`: Load the URL into a new browsing context. This is usually a tab, but users can configure browsers to use new windows instead.\n*   `_parent`: Load the URL into the parent browsing context of the current one. If there is no parent, this behaves the same way as `_self`.\n*   `_top`: Load the URL into the top-level browsing context (that is, the "highest" browsing context that is an ancestor of the current one, and has no parent). If there is no parent, this behaves the same way as `_self`.\n\n**Note:** When using `target`, consider adding `rel="noreferrer"` to avoid exploitation of the `window.opener` API.\n\n**Note:** Linking to another page using `target="_blank"` will run the new page on the same process as your page. If the new page is executing expensive JS, your page\'s performance may suffer. To avoid this use `rel="noopener"`.'
            }
          },
          {
            "name": "download",
            "description": {
              "kind": "markdown",
              "value": "This attribute instructs browsers to download a URL instead of navigating to it, so the user will be prompted to save it as a local file. If the attribute has a value, it is used as the pre-filled file name in the Save prompt (the user can still change the file name if they want). There are no restrictions on allowed values, though `/` and `\\` are converted to underscores. Most file systems limit some punctuation in file names, and browsers will adjust the suggested name accordingly.\n\n**Notes:**\n\n*   This attribute only works for [same-origin URLs](https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy).\n*   Although HTTP(s) URLs need to be in the same-origin, [`blob:` URLs](https://developer.mozilla.org/en-US/docs/Web/API/URL.createObjectURL) and [`data:` URLs](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URIs) are allowed so that content generated by JavaScript, such as pictures created in an image-editor Web app, can be downloaded.\n*   If the HTTP header [`Content-Disposition:`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Disposition) gives a different filename than this attribute, the HTTP header takes priority over this attribute.\n*   If `Content-Disposition:` is set to `inline`, Firefox prioritizes `Content-Disposition`, like the filename case, while Chrome prioritizes the `download` attribute."
            }
          },
          {
            "name": "ping",
            "description": {
              "kind": "markdown",
              "value": 'Contains a space-separated list of URLs to which, when the hyperlink is followed, [`POST`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/POST "The HTTP POST method sends data to the server. The type of the body of the request is indicated by the Content-Type header.") requests with the body `PING` will be sent by the browser (in the background). Typically used for tracking.'
            }
          },
          {
            "name": "rel",
            "description": {
              "kind": "markdown",
              "value": "Specifies the relationship of the target object to the link object. The value is a space-separated list of [link types](https://developer.mozilla.org/en-US/docs/Web/HTML/Link_types)."
            }
          },
          {
            "name": "hreflang",
            "description": {
              "kind": "markdown",
              "value": 'This attribute indicates the human language of the linked resource. It is purely advisory, with no built-in functionality. Allowed values are determined by [BCP47](https://www.ietf.org/rfc/bcp/bcp47.txt "Tags for Identifying Languages").'
            }
          },
          {
            "name": "type",
            "description": {
              "kind": "markdown",
              "value": 'Specifies the media type in the form of a [MIME type](https://developer.mozilla.org/en-US/docs/Glossary/MIME_type "MIME type: A MIME type (now properly called "media type", but also sometimes "content type") is a string sent along with a file indicating the type of the file (describing the content format, for example, a sound file might be labeled audio/ogg, or an image file image/png).") for the linked URL. It is purely advisory, with no built-in functionality.'
            }
          },
          {
            "name": "referrerpolicy",
            "description": "Indicates which [referrer](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer) to send when fetching the URL:\n\n*   `'no-referrer'` means the `Referer:` header will not be sent.\n*   `'no-referrer-when-downgrade'` means no `Referer:` header will be sent when navigating to an origin without HTTPS. This is the default behavior.\n*   `'origin'` means the referrer will be the [origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) of the page, not including information after the domain.\n*   `'origin-when-cross-origin'` meaning that navigations to other origins will be limited to the scheme, the host and the port, while navigations on the same origin will include the referrer's path.\n*   `'strict-origin-when-cross-origin'`\n*   `'unsafe-url'` means the referrer will include the origin and path, but not the fragment, password, or username. This is unsafe because it can leak data from secure URLs to insecure ones."
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/a"
          }
        ]
      },
      {
        "name": "em",
        "description": {
          "kind": "markdown",
          "value": "The em element represents stress emphasis of its contents."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/em"
          }
        ]
      },
      {
        "name": "strong",
        "description": {
          "kind": "markdown",
          "value": "The strong element represents strong importance, seriousness, or urgency for its contents."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/strong"
          }
        ]
      },
      {
        "name": "small",
        "description": {
          "kind": "markdown",
          "value": "The small element represents side comments such as small print."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/small"
          }
        ]
      },
      {
        "name": "s",
        "description": {
          "kind": "markdown",
          "value": "The s element represents contents that are no longer accurate or no longer relevant."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/s"
          }
        ]
      },
      {
        "name": "cite",
        "description": {
          "kind": "markdown",
          "value": "The cite element represents a reference to a creative work. It must include the title of the work or the name of the author(person, people or organization) or an URL reference, or a reference in abbreviated form as per the conventions used for the addition of citation metadata."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/cite"
          }
        ]
      },
      {
        "name": "q",
        "description": {
          "kind": "markdown",
          "value": "The q element represents some phrasing content quoted from another source."
        },
        "attributes": [
          {
            "name": "cite",
            "description": {
              "kind": "markdown",
              "value": "The value of this attribute is a URL that designates a source document or message for the information quoted. This attribute is intended to point to information explaining the context or the reference for the quote."
            }
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/q"
          }
        ]
      },
      {
        "name": "dfn",
        "description": {
          "kind": "markdown",
          "value": "The dfn element represents the defining instance of a term. The paragraph, description list group, or section that is the nearest ancestor of the dfn element must also contain the definition(s) for the term given by the dfn element."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/dfn"
          }
        ]
      },
      {
        "name": "abbr",
        "description": {
          "kind": "markdown",
          "value": "The abbr element represents an abbreviation or acronym, optionally with its expansion. The title attribute may be used to provide an expansion of the abbreviation. The attribute, if specified, must contain an expansion of the abbreviation, and nothing else."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/abbr"
          }
        ]
      },
      {
        "name": "ruby",
        "description": {
          "kind": "markdown",
          "value": "The ruby element allows one or more spans of phrasing content to be marked with ruby annotations. Ruby annotations are short runs of text presented alongside base text, primarily used in East Asian typography as a guide for pronunciation or to include other annotations. In Japanese, this form of typography is also known as furigana. Ruby text can appear on either side, and sometimes both sides, of the base text, and it is possible to control its position using CSS. A more complete introduction to ruby can be found in the Use Cases & Exploratory Approaches for Ruby Markup document as well as in CSS Ruby Module Level 1. [RUBY-UC] [CSSRUBY]"
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/ruby"
          }
        ]
      },
      {
        "name": "rb",
        "description": {
          "kind": "markdown",
          "value": "The rb element marks the base text component of a ruby annotation. When it is the child of a ruby element, it doesn't represent anything itself, but its parent ruby element uses it as part of determining what it represents."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/rb"
          }
        ]
      },
      {
        "name": "rt",
        "description": {
          "kind": "markdown",
          "value": "The rt element marks the ruby text component of a ruby annotation. When it is the child of a ruby element or of an rtc element that is itself the child of a ruby element, it doesn't represent anything itself, but its ancestor ruby element uses it as part of determining what it represents."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/rt"
          }
        ]
      },
      {
        "name": "rp",
        "description": {
          "kind": "markdown",
          "value": "The rp element is used to provide fallback text to be shown by user agents that don't support ruby annotations. One widespread convention is to provide parentheses around the ruby text component of a ruby annotation."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/rp"
          }
        ]
      },
      {
        "name": "time",
        "description": {
          "kind": "markdown",
          "value": "The time element represents its contents, along with a machine-readable form of those contents in the datetime attribute. The kind of content is limited to various kinds of dates, times, time-zone offsets, and durations, as described below."
        },
        "attributes": [
          {
            "name": "datetime",
            "description": {
              "kind": "markdown",
              "value": "This attribute indicates the time and/or date of the element and must be in one of the formats described below."
            }
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/time"
          }
        ]
      },
      {
        "name": "code",
        "description": {
          "kind": "markdown",
          "value": "The code element represents a fragment of computer code. This could be an XML element name, a file name, a computer program, or any other string that a computer would recognize."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/code"
          }
        ]
      },
      {
        "name": "var",
        "description": {
          "kind": "markdown",
          "value": "The var element represents a variable. This could be an actual variable in a mathematical expression or programming context, an identifier representing a constant, a symbol identifying a physical quantity, a function parameter, or just be a term used as a placeholder in prose."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/var"
          }
        ]
      },
      {
        "name": "samp",
        "description": {
          "kind": "markdown",
          "value": "The samp element represents sample or quoted output from another program or computing system."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/samp"
          }
        ]
      },
      {
        "name": "kbd",
        "description": {
          "kind": "markdown",
          "value": "The kbd element represents user input (typically keyboard input, although it may also be used to represent other input, such as voice commands)."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/kbd"
          }
        ]
      },
      {
        "name": "sub",
        "description": {
          "kind": "markdown",
          "value": "The sub element represents a subscript."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/sub"
          }
        ]
      },
      {
        "name": "sup",
        "description": {
          "kind": "markdown",
          "value": "The sup element represents a superscript."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/sup"
          }
        ]
      },
      {
        "name": "i",
        "description": {
          "kind": "markdown",
          "value": "The i element represents a span of text in an alternate voice or mood, or otherwise offset from the normal prose in a manner indicating a different quality of text, such as a taxonomic designation, a technical term, an idiomatic phrase from another language, transliteration, a thought, or a ship name in Western texts."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/i"
          }
        ]
      },
      {
        "name": "b",
        "description": {
          "kind": "markdown",
          "value": "The b element represents a span of text to which attention is being drawn for utilitarian purposes without conveying any extra importance and with no implication of an alternate voice or mood, such as key words in a document abstract, product names in a review, actionable words in interactive text-driven software, or an article lede."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/b"
          }
        ]
      },
      {
        "name": "u",
        "description": {
          "kind": "markdown",
          "value": "The u element represents a span of text with an unarticulated, though explicitly rendered, non-textual annotation, such as labeling the text as being a proper name in Chinese text (a Chinese proper name mark), or labeling the text as being misspelt."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/u"
          }
        ]
      },
      {
        "name": "mark",
        "description": {
          "kind": "markdown",
          "value": "The mark element represents a run of text in one document marked or highlighted for reference purposes, due to its relevance in another context. When used in a quotation or other block of text referred to from the prose, it indicates a highlight that was not originally present but which has been added to bring the reader's attention to a part of the text that might not have been considered important by the original author when the block was originally written, but which is now under previously unexpected scrutiny. When used in the main prose of a document, it indicates a part of the document that has been highlighted due to its likely relevance to the user's current activity."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/mark"
          }
        ]
      },
      {
        "name": "bdi",
        "description": {
          "kind": "markdown",
          "value": "The bdi element represents a span of text that is to be isolated from its surroundings for the purposes of bidirectional text formatting. [BIDI]"
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/bdi"
          }
        ]
      },
      {
        "name": "bdo",
        "description": {
          "kind": "markdown",
          "value": "The bdo element represents explicit text directionality formatting control for its children. It allows authors to override the Unicode bidirectional algorithm by explicitly specifying a direction override. [BIDI]"
        },
        "attributes": [
          {
            "name": "dir",
            "description": "The direction in which text should be rendered in this element's contents. Possible values are:\n\n*   `ltr`: Indicates that the text should go in a left-to-right direction.\n*   `rtl`: Indicates that the text should go in a right-to-left direction."
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/bdo"
          }
        ]
      },
      {
        "name": "span",
        "description": {
          "kind": "markdown",
          "value": "The span element doesn't mean anything on its own, but can be useful when used together with the global attributes, e.g. class, lang, or dir. It represents its children."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/span"
          }
        ]
      },
      {
        "name": "br",
        "description": {
          "kind": "markdown",
          "value": "The br element represents a line break."
        },
        "void": true,
        "attributes": [
          {
            "name": "clear",
            "description": "Indicates where to begin the next line after the break."
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/br"
          }
        ]
      },
      {
        "name": "wbr",
        "description": {
          "kind": "markdown",
          "value": "The wbr element represents a line break opportunity."
        },
        "void": true,
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/wbr"
          }
        ]
      },
      {
        "name": "ins",
        "description": {
          "kind": "markdown",
          "value": "The ins element represents an addition to the document."
        },
        "attributes": [
          {
            "name": "cite",
            "description": "This attribute defines the URI of a resource that explains the change, such as a link to meeting minutes or a ticket in a troubleshooting system."
          },
          {
            "name": "datetime",
            "description": 'This attribute indicates the time and date of the change and must be a valid date with an optional time string. If the value cannot be parsed as a date with an optional time string, the element does not have an associated time stamp. For the format of the string without a time, see [Format of a valid date string](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats#Format_of_a_valid_date_string "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.") in [Date and time formats used in HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article."). The format of the string if it includes both date and time is covered in [Format of a valid local date and time string](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats#Format_of_a_valid_local_date_and_time_string "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.") in [Date and time formats used in HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.").'
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/ins"
          }
        ]
      },
      {
        "name": "del",
        "description": {
          "kind": "markdown",
          "value": "The del element represents a removal from the document."
        },
        "attributes": [
          {
            "name": "cite",
            "description": {
              "kind": "markdown",
              "value": "A URI for a resource that explains the change (for example, meeting minutes)."
            }
          },
          {
            "name": "datetime",
            "description": {
              "kind": "markdown",
              "value": 'This attribute indicates the time and date of the change and must be a valid date string with an optional time. If the value cannot be parsed as a date with an optional time string, the element does not have an associated time stamp. For the format of the string without a time, see [Format of a valid date string](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats#Format_of_a_valid_date_string "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.") in [Date and time formats used in HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article."). The format of the string if it includes both date and time is covered in [Format of a valid local date and time string](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats#Format_of_a_valid_local_date_and_time_string "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.") in [Date and time formats used in HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.").'
            }
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/del"
          }
        ]
      },
      {
        "name": "picture",
        "description": {
          "kind": "markdown",
          "value": "The picture element is a container which provides multiple sources to its contained img element to allow authors to declaratively control or give hints to the user agent about which image resource to use, based on the screen pixel density, viewport size, image format, and other factors. It represents its children."
        },
        "attributes": [],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/picture"
          }
        ]
      },
      {
        "name": "img",
        "description": {
          "kind": "markdown",
          "value": "An img element represents an image."
        },
        "void": true,
        "attributes": [
          {
            "name": "alt",
            "description": {
              "kind": "markdown",
              "value": 'This attribute defines an alternative text description of the image.\n\n**Note:** Browsers do not always display the image referenced by the element. This is the case for non-graphical browsers (including those used by people with visual impairments), if the user chooses not to display images, or if the browser cannot display the image because it is invalid or an [unsupported type](#Supported_image_formats). In these cases, the browser may replace the image with the text defined in this element\'s `alt` attribute. You should, for these reasons and others, provide a useful value for `alt` whenever possible.\n\n**Note:** Omitting this attribute altogether indicates that the image is a key part of the content, and no textual equivalent is available. Setting this attribute to an empty string (`alt=""`) indicates that this image is _not_ a key part of the content (decorative), and that non-visual browsers may omit it from rendering.'
            }
          },
          {
            "name": "src",
            "description": {
              "kind": "markdown",
              "value": "The image URL. This attribute is mandatory for the `<img>` element. On browsers supporting `srcset`, `src` is treated like a candidate image with a pixel density descriptor `1x` unless an image with this pixel density descriptor is already defined in `srcset,` or unless `srcset` contains '`w`' descriptors."
            }
          },
          {
            "name": "srcset",
            "description": {
              "kind": "markdown",
              "value": "A list of one or more strings separated by commas indicating a set of possible image sources for the user agent to use. Each string is composed of:\n\n1.  a URL to an image,\n2.  optionally, whitespace followed by one of:\n    *   A width descriptor, or a positive integer directly followed by '`w`'. The width descriptor is divided by the source size given in the `sizes` attribute to calculate the effective pixel density.\n    *   A pixel density descriptor, which is a positive floating point number directly followed by '`x`'.\n\nIf no descriptor is specified, the source is assigned the default descriptor: `1x`.\n\nIt is incorrect to mix width descriptors and pixel density descriptors in the same `srcset` attribute. Duplicate descriptors (for instance, two sources in the same `srcset` which are both described with '`2x`') are also invalid.\n\nThe user agent selects any one of the available sources at its discretion. This provides them with significant leeway to tailor their selection based on things like user preferences or bandwidth conditions. See our [Responsive images](https://developer.mozilla.org/en-US/docs/Learn/HTML/Multimedia_and_embedding/Responsive_images) tutorial for an example."
            }
          },
          {
            "name": "crossorigin",
            "valueSet": "xo",
            "description": {
              "kind": "markdown",
              "value": 'This enumerated attribute indicates if the fetching of the related image must be done using CORS or not. [CORS-enabled images](https://developer.mozilla.org/en-US/docs/CORS_Enabled_Image) can be reused in the [`<canvas>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas "Use the HTML <canvas> element with either the canvas scripting API or the WebGL API to draw graphics and animations.") element without being "[tainted](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_enabled_image#What_is_a_tainted_canvas)." The allowed values are:\n`anonymous`\n\nA cross-origin request (i.e., with `Origin:` HTTP header) is performed, but no credential is sent (i.e., no cookie, X.509 certificate, or HTTP Basic authentication). If the server does not give credentials to the origin site (by not setting the [`Access-Control-Allow-Origin`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin "The Access-Control-Allow-Origin response header indicates whether the response can be shared with requesting code from the given origin.") HTTP header), the image will be tainted and its usage restricted.\n\n`use-credentials`\n\nA cross-origin request (i.e., with the [`Origin`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin "The Origin request header indicates where a fetch originates from. It doesn\'t include any path information, but only the server name. It is sent with CORS requests, as well as with POST requests. It is similar to the Referer header, but, unlike this header, it doesn\'t disclose the whole path.") HTTP header) performed along with credentials sent (i.e., a cookie, certificate, or HTTP Basic authentication). If the server does not give credentials to the origin site (through the `Access-Control-Allow-Credentials` HTTP header), the image will be tainted and its usage restricted.\n\nIf the attribute is not present, the resource is fetched without a CORS request (i.e., without sending the `Origin` HTTP header), preventing its non-tainted usage in [`<canvas>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas "Use the HTML <canvas> element with either the canvas scripting API or the WebGL API to draw graphics and animations.") elements. If invalid, it is handled as if the `anonymous` value was used. See [CORS settings attributes](https://developer.mozilla.org/en-US/docs/HTML/CORS_settings_attributes) for additional information.'
            }
          },
          {
            "name": "usemap",
            "description": {
              "kind": "markdown",
              "value": 'The partial URL (starting with \'#\') of an [image map](https://developer.mozilla.org/en-US/docs/HTML/Element/map) associated with the element.\n\n**Note:** You cannot use this attribute if the `<img>` element is a descendant of an [`<a>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a "The HTML <a> element (or anchor element) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL.") or [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") element.'
            }
          },
          {
            "name": "ismap",
            "valueSet": "v",
            "description": {
              "kind": "markdown",
              "value": 'This Boolean attribute indicates that the image is part of a server-side map. If so, the precise coordinates of a click are sent to the server.\n\n**Note:** This attribute is allowed only if the `<img>` element is a descendant of an [`<a>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a "The HTML <a> element (or anchor element) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL.") element with a valid [`href`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a#attr-href) attribute.'
            }
          },
          {
            "name": "width",
            "description": {
              "kind": "markdown",
              "value": "The intrinsic width of the image in pixels."
            }
          },
          {
            "name": "height",
            "description": {
              "kind": "markdown",
              "value": "The intrinsic height of the image in pixels."
            }
          },
          {
            "name": "decoding",
            "valueSet": "decoding",
            "description": {
              "kind": "markdown",
              "value": "Provides an image decoding hint to the browser. The allowed values are:\n`sync`\n\nDecode the image synchronously for atomic presentation with other content.\n\n`async`\n\nDecode the image asynchronously to reduce delay in presenting other content.\n\n`auto`\n\nDefault mode, which indicates no preference for the decoding mode. The browser decides what is best for the user."
            }
          },
          {
            "name": "loading",
            "valueSet": "loading",
            "description": {
              "kind": "markdown",
              "value": "Indicates how the browser should load the image."
            }
          },
          {
            "name": "referrerpolicy",
            "valueSet": "referrerpolicy",
            "description": {
              "kind": "markdown",
              "value": "A string indicating which referrer to use when fetching the resource:\n\n*   `no-referrer:` The [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer \"The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.\") header will not be sent.\n*   `no-referrer-when-downgrade:` No `Referer` header will be sent when navigating to an origin without TLS (HTTPS). This is a user agent’s default behavior if no policy is otherwise specified.\n*   `origin:` The `Referer` header will include the page of origin's scheme, the host, and the port.\n*   `origin-when-cross-origin:` Navigating to other origins will limit the included referral data to the scheme, the host and the port, while navigating from the same origin will include the referrer's full path.\n*   `unsafe-url:` The `Referer` header will include the origin and the path, but not the fragment, password, or username. This case is unsafe because it can leak origins and paths from TLS-protected resources to insecure origins."
            }
          },
          {
            "name": "sizes",
            "description": {
              "kind": "markdown",
              "value": "A list of one or more strings separated by commas indicating a set of source sizes. Each source size consists of:\n\n1.  a media condition. This must be omitted for the last item.\n2.  a source size value.\n\nSource size values specify the intended display size of the image. User agents use the current source size to select one of the sources supplied by the `srcset` attribute, when those sources are described using width ('`w`') descriptors. The selected source size affects the intrinsic size of the image (the image’s display size if no CSS styling is applied). If the `srcset` attribute is absent, or contains no values with a width (`w`) descriptor, then the `sizes` attribute has no effect."
            }
          },
          {
            "name": "importance",
            "description": "Indicates the relative importance of the resource. Priority hints are delegated using the values:"
          },
          {
            "name": "importance",
            "description": "`auto`: Indicates **no preference**. The browser may use its own heuristics to decide the priority of the image.\n\n`high`: Indicates to the browser that the image is of **high** priority.\n\n`low`: Indicates to the browser that the image is of **low** priority."
          },
          {
            "name": "intrinsicsize",
            "description": "This attribute tells the browser to ignore the actual intrinsic size of the image and pretend it’s the size specified in the attribute. Specifically, the image would raster at these dimensions and `naturalWidth`/`naturalHeight` on images would return the values specified in this attribute. [Explainer](https://github.com/ojanvafai/intrinsicsize-attribute), [examples](https://googlechrome.github.io/samples/intrinsic-size/index.html)"
          }
        ],
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/HTML/Element/img"
          }
        ]
      },
      {
        "name": "iframe",
        "description": {
          "kind": "markdown",
          "value": "The iframe element represents a nested browsing context."
        },
        "attributes": [
          {
            "name": "src",
            "description": {
              "kind": "markdown",
              "value": 'The URL of the page to embed. Use a value of `about:blank` to embed an empty page that conforms to the [same-origin policy](https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy#Inherited_origins). Also note that programatically removing an `<iframe>`\'s src attribute (e.g. via [`Element.removeAttribute()`](https://developer.mozilla.org/en-US/docs/Web/API/Element/removeAttribute "The Element method removeAttribute() removes the attribute with the specified name from the element.")) causes `about:blank` t