<?php declare(strict_types = 1);

namespace PHPStan\Type\Doctrine\Query;

use PhpParser\Node\Expr\MethodCall;
use PHPStan\Analyser\Scope;
use PHPStan\Reflection\MethodReflection;
use PHPStan\Type\Constant\ConstantStringType;
use PHPStan\Type\Doctrine\DoctrineTypeUtils;
use PHPStan\Type\DynamicMethodReturnTypeExtension;
use PHPStan\Type\Type;
use PHPStan\Type\TypeCombinator;
use function count;

class QueryGetDqlDynamicReturnTypeExtension implements DynamicMethodReturnTypeExtension
{

	public function getClass(): string
	{
		return 'Doctrine\ORM\Query';
	}

	public function isMethodSupported(MethodReflection $methodReflection): bool
	{
		return $methodReflection->getName() === 'getDQL';
	}

	public function getTypeFromMethodCall(
		MethodReflection $methodReflection,
		MethodCall $methodCall,
		Scope $scope
	): ?Type
	{
		$calledOnType = $scope->getType($methodCall->var);
		$queryTypes = DoctrineTypeUtils::getQueryTypes($calledOnType);
		if (count($queryTypes) === 0) {
			return null;
		}

		$dqls = [];
		foreach ($queryTypes as $queryType) {
			$dqls[] = new ConstantStringType($queryType->getDql());
		}

		return TypeCombinator::union(...$dqls);
	}

}
