# -*- coding: utf-8 -*-
# 
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))

import time
import sphinx_rtd_theme

# -- Project information -----------------------------------------------------

copyright = '2004-' + time.strftime('%Y') + ' by the DOMjudge developers and contributors'
author = 'DOMjudge Team'

import os

if os.path.isfile("version.py"):
    exec(open("version.py").read())
else:
    exec(open("version.dist.py").read())

if os.path.isfile("substitutions.py"):
    exec(open("substitutions.py").read())
else:
    exec(open("substitutions.dist.py").read())

# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.

extensions = [
    'sphinx.ext.ifconfig',
    'sphinx_rtd_theme',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

today_fmt = '%Y'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

html_context = {
  'display_github': True,
  'github_user': 'DOMjudge',
  'github_repo': 'domjudge',
  'github_version': 'main',
  'conf_py_path': '/doc/manual/'
}

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}

html_js_files = ['js/versionswitcher.js']

# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'DOMjudgedoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    'papersize': 'a4paper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    'preamble': r'''
\definecolor{VerbatimColor}{rgb}{0.95,0.95,0.95}
\definecolor{OuterLinkColor}{rgb}{0,0,1}
\definecolor{noteBgColor}{rgb}{1,0,1}

\definecolor{sphinxnoteBgColor}{RGB}{221,233,239}

\usepackage{fancyhdr}
\pagestyle{fancy}
\renewcommand{\familydefault}{\sfdefault}

% Begin new paragraphs without indentation but vertical space.
\setlength{\parindent}{0pt}
\setlength{\parskip}{1.5ex plus 0.5ex minus 0.2ex}
\usepackage{titlesec}

% No chapter numbers.
\renewcommand{\thesection}{\arabic{section}}

''',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',

    # No empty pages between chapters.
    'extraclassoptions': 'openany',
    
    # No toc.
    'tableofcontents': '',

    # No title page.
    'maketitle': '',
}

latex_toplevel_sectioning = 'section'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'DOMjudge.tex', 'DOMjudge Documentation',
     'DOMjudge Team', 'manual'),
    ('team', 'domjudge-team-manual.tex', 'DOMjudge Team Manual',
     'DOMjudge Team', 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'domjudge', 'DOMjudge Documentation',
     [author], 1)
]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'DOMjudge', 'DOMjudge Documentation',
     author, 'DOMjudge', 'One line description of project.',
     'Miscellaneous'),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']


# -- Extension configuration -------------------------------------------------

# Options specifically for the Team manual PDF

pdf_documents = [
    ('team', u'domjudge-team-manual', u'DOMjudge Team Manual', u'The DOMjudge Developers'),
]

pdf_compressed = True
pdf_stylesheets = ['sphinx','kerning','a4','sphinx-team']

pdf_use_coverpage = False

# This is of string type, not bool. See: https://github.com/rst2pdf/rst2pdf/pull/846
pdf_use_toc = ''

# This is needed to avoid a bug in rst2pdf << 0.94 (Debian buster has 0.93)
# See: https://github.com/rst2pdf/rst2pdf/issues/678
pdf_invariant = False
