<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.8.4
*/function
adminer_errors($hc,$jc){return!!preg_match('~^(Trying to access array offset on( value of type)? null|Undefined array key)~',$jc);}error_reporting(6135);set_error_handler('adminer_errors',E_WARNING);$Ac=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($Ac||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$nh=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($nh)$$X=$nh;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$f;return$f;}function
adminer(){global$b;return$b;}function
version(){global$ga;return$ga;}function
idf_unescape($t){if(!preg_match('~^[`\'"[]~',$t))return$t;$Dd=substr($t,-1);return
str_replace($Dd.$Dd,$Dd,substr($t,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($tf,$Ac=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($x,$X)=each($tf)){foreach($X
as$wd=>$W){unset($tf[$x][$wd]);if(is_array($W)){$tf[$x][stripslashes($wd)]=$W;$tf[]=&$tf[$x][stripslashes($wd)];}else$tf[$x][stripslashes($wd)]=($Ac?$W:stripslashes($W));}}}}function
bracket_escape($t,$Ba=false){static$ah=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($t,($Ba?array_flip($ah):$ah));}function
min_version($Bh,$Qd="",$g=null){global$f;if(!$g)$g=$f;$ag=$g->server_info;if($Qd&&preg_match('~([\d.]+)-MariaDB~',$ag,$B)){$ag=$B[1];$Bh=$Qd;}return(version_compare($ag,$Bh)>=0);}function
charset($f){return(min_version("5.5.3",0,$f)?"utf8mb4":"utf8");}function
script($jg,$Zg="\n"){return"<script".nonce().">$jg</script>$Zg";}function
script_src($sh){return"<script src='".h($sh)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($tg){return
str_replace("\0","&#0;",htmlspecialchars($tg,ENT_QUOTES,'utf-8'));}function
nl_br($tg){return
str_replace("\n","<br>",$tg);}function
checkbox($E,$Y,$Pa,$_d="",$_e="",$Ta="",$Ad=""){$K="<input type='checkbox' name='$E' value='".h($Y)."'".($Pa?" checked":"").($Ad?" aria-labelledby='$Ad'":"").">".($_e?script("qsl('input').onclick = function () { $_e };",""):"");return($_d!=""||$Ta?"<label".($Ta?" class='$Ta'":"").">$K".h($_d)."</label>":$K);}function
optionlist($Ee,$Vf=null,$wh=false){$K="";foreach($Ee
as$wd=>$W){$Fe=array($wd=>$W);if(is_array($W)){$K.='<optgroup label="'.h($wd).'">';$Fe=$W;}foreach($Fe
as$x=>$X)$K.='<option'.($wh||is_string($x)?' value="'.h($x).'"':'').(($wh||is_string($x)?(string)$x:$X)===$Vf?' selected':'').'>'.h($X);if(is_array($W))$K.='</optgroup>';}return$K;}function
html_select($E,$Ee,$Y="",$ze=true,$Ad=""){if($ze)return"<select name='".h($E)."'".($Ad?" aria-labelledby='$Ad'":"").">".optionlist($Ee,$Y)."</select>".(is_string($ze)?script("qsl('select').onchange = function () { $ze };",""):"");$K="";foreach($Ee
as$x=>$X)$K.="<label><input type='radio' name='".h($E)."' value='".h($x)."'".($x==$Y?" checked":"").">".h($X)."</label>";return$K;}function
select_input($ya,$Ee,$Y="",$ze="",$gf=""){$Hg=($Ee?"select":"input");return"<$Hg$ya".($Ee?"><option value=''>$gf".optionlist($Ee,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$gf'>").($ze?script("qsl('$Hg').onchange = $ze;",""):"");}function
confirm($D="",$Wf="qsl('input')"){return
script("$Wf.onclick = function () { return confirm('".($D?js_escape($D):lang(0))."'); };","");}function
print_fieldset($s,$Id,$Eh=false){echo"<fieldset><legend>","<a href='#fieldset-$s'>$Id</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$s');",""),"</legend>","<div id='fieldset-$s'".($Eh?"":" class='hidden'").">\n";}function
generate_linksbar($_){$Md="<p class='links'>";foreach($_
as$x=>$z){if($x!==key(array_keys($_)))$Md.="<span class='separator'>|</span>";$Md.=$z;}$Md.="</p>";return$Md;}function
bold($Ia,$Ta=""){return($Ia?" class='active $Ta'":($Ta?" class='$Ta'":""));}function
odd($K=' class="odd"'){static$r=0;if(!$K)$r=-1;return($r++%2?$K:'');}function
js_escape($tg){return
addcslashes($tg,"\r\n'\\/");}function
json_row($x,$X=null){static$Bc=true;if($Bc)echo"{";if($x!=""){echo($Bc?"":",")."\n\t\"".addcslashes($x,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$Bc=false;}else{echo"\n}\n";$Bc=true;}}function
ini_bool($kd){$X=ini_get($kd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$K;if($K===null)$K=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$K;}function
set_password($Ah,$O,$V,$G){$_SESSION["pwds"][$Ah][$O][$V]=($_COOKIE["adminer_key"]&&is_string($G)?array(encrypt_string($G,$_COOKIE["adminer_key"])):$G);}function
get_password(){$K=get_session("pwds");if(is_array($K))$K=($_COOKIE["adminer_key"]?decrypt_string($K[0],$_COOKIE["adminer_key"]):false);return$K;}function
q($tg){global$f;return$f->quote($tg);}function
get_vals($I,$c=0){global$f;$K=array();$J=$f->query($I);if(is_object($J)){while($L=$J->fetch_row())$K[]=$L[$c];}return$K;}function
get_key_vals($I,$g=null,$dg=true){global$f;if(!is_object($g))$g=$f;$K=array();$J=$g->query($I);if(is_object($J)){while($L=$J->fetch_row()){if($dg)$K[$L[0]]=$L[1];else$K[]=$L[0];}}return$K;}function
get_rows($I,$g=null,$l="<p class='error'>"){global$f;$ib=(is_object($g)?$g:$f);$K=array();$J=$ib->query($I);if(is_object($J)){while($L=$J->fetch_assoc())$K[]=$L;}elseif(!$J&&!is_object($g)&&$l&&defined("PAGE_HEADER"))echo$l.error()."\n";return$K;}function
unique_array($L,$v){foreach($v
as$u){if(preg_match("~PRIMARY|UNIQUE~",$u["type"])){$K=array();foreach($u["columns"]as$x){if(!isset($L[$x]))continue
2;$K[$x]=$L[$x];}return$K;}}}function
escape_key($x){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$x,$B))return$B[1].idf_escape(idf_unescape($B[2])).$B[3];return
idf_escape($x);}function
where($Z,$n=array()){global$f,$w;$K=array();foreach((array)$Z["where"]as$x=>$X){$x=bracket_escape($x,1);$c=escape_key($x);$K[]=$c.($w=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($w=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($n[$x],q($X))));if($w=="sql"&&preg_match('~char|text~',$n[$x]["type"]??null)&&preg_match("~[^ -@]~",$X))$K[]="$c = ".q($X)." COLLATE ".charset($f)."_bin";}foreach((array)$Z["null"]as$x)$K[]=escape_key($x)." IS NULL";return
implode(" AND ",$K);}function
where_check($X,$n=array()){parse_str($X,$Oa);remove_slashes(array(&$Oa));return
where($Oa,$n);}function
where_link($r,$c,$Y,$Ae="="){return"&where%5B$r%5D%5Bcol%5D=".urlencode($c)."&where%5B$r%5D%5Bop%5D=".urlencode(($Y!==null?$Ae:"IS NULL"))."&where%5B$r%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($d,$n,$N=array()){$K="";foreach($d
as$x=>$X){if($N&&!in_array(idf_escape($x),$N))continue;$wa=convert_field($n[$x]);if($wa)$K.=", $wa AS ".idf_escape($x);}return$K;}function
cookie($E,$Y,$Ld=2592000){global$ba;return
header("Set-Cookie: $E=".urlencode($Y).($Ld?"; expires=".gmdate("D, d M Y H:i:s",time()+$Ld)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))session_start();}function
stop_session($Ec=false){$vh=ini_bool("session.use_cookies");if(!$vh||$Ec){session_write_close();if($vh&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($x){return$_SESSION[$x][DRIVER][SERVER][$_GET["username"]];}function
set_session($x,$X){$_SESSION[$x][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Ah,$O,$V,$j=null){global$Pb;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($Pb))."|username|".($j!==null?"db|":"").session_name()),$B);return"$B[1]?".(sid()?SID."&":"").($Ah!="server"||$O!=""?urlencode($Ah)."=".urlencode($O)."&":"")."username=".urlencode($V).($j!=""?"&db=".urlencode($j):"").($B[2]?"&$B[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($A,$D=null){if($D!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($A!==null?$A:$_SERVER["REQUEST_URI"]))][]=$D;}if($A!==null){if($A=="")$A=".";header("Location: $A");exit;}}function
query_redirect($I,$A,$D,$_f=true,$oc=true,$vc=false,$Og=""){global$f,$l,$b;if($oc){$pg=microtime(true);$vc=!$f->query($I);$Og=format_time($pg);}$lg="";if($I)$lg=$b->messageQuery($I,$Og,$vc);if($vc){$l=error().$lg.script("messagesPrint();");return
false;}if($_f)redirect($A,$D.$lg);return
true;}function
queries($I){global$f;static$vf=array();static$pg;if(!$pg)$pg=microtime(true);if($I===null)return
array(implode("\n",$vf),format_time($pg));$vf[]=(preg_match('~;$~',$I)?"DELIMITER ;;\n$I;\nDELIMITER ":$I).";";return$f->query($I);}function
apply_queries($I,$S,$kc='table'){foreach($S
as$Q){if(!queries("$I ".$kc($Q)))return
false;}return
true;}function
queries_redirect($A,$D,$_f){list($vf,$Og)=queries(null);return
query_redirect($vf,$A,$D,$_f,false,!$_f,$Og);}function
format_time($pg){return
lang(1,max(0,microtime(true)-$pg));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Te=""){return
substr(preg_replace("~(?<=[?&])($Te".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($F,$tb){return" ".($F==$tb?$F+1:'<a href="'.h(remove_from_uri("page").($F?"&page=$F".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($F+1)."</a>");}function
get_file($x,$Ab=false){$zc=$_FILES[$x];if(!$zc)return
null;foreach($zc
as$x=>$X)$zc[$x]=(array)$X;$K='';foreach($zc["error"]as$x=>$l){if($l)return$l;$E=$zc["name"][$x];$Wg=$zc["tmp_name"][$x];$jb=file_get_contents($Ab&&preg_match('~\.gz$~',$E)?"compress.zlib://$Wg":$Wg);if($Ab){$pg=substr($jb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$pg,$Ff))$jb=iconv("utf-16","utf-8",$jb);elseif($pg=="\xEF\xBB\xBF")$jb=substr($jb,3);$K.=$jb."\n\n";}else$K.=$jb;}return$K;}function
upload_error($l){$Vd=($l==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($l?lang(2).($Vd?" ".lang(3,$Vd):""):lang(4));}function
repeat_pattern($df,$Jd){return
str_repeat("$df{0,65535}",$Jd/65535)."$df{0,".($Jd%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($tg,$Jd=80,$xg=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Jd).")($)?)u",$tg,$B))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Jd).")($)?)",$tg,$B);return
h($B[1]).$xg.(isset($B[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($tf,$gd=array(),$mf=''){$K=false;foreach($tf
as$x=>$X){if(!in_array($x,$gd)){if(is_array($X))hidden_fields($X,array(),$x);else{$K=true;echo'<input type="hidden" name="'.h($mf?$mf."[$x]":$x).'" value="'.h($X).'">';}}}return$K;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($Q,$wc=false){$K=table_status($Q,$wc);return($K?$K:array("Name"=>$Q));}function
column_foreign_keys($Q){global$b;$K=array();foreach($b->foreignKeys($Q)as$o){foreach($o["source"]as$X)$K[$X][]=$o;}return$K;}function
enum_input($U,$ya,$m,$Y,$dc=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$m["length"],$C);$K=($dc!==null?"<label><input type='$U'$ya value='$dc'".((is_array($Y)?in_array($dc,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($C[1]as$r=>$X){$X=stripcslashes(str_replace("''","'",$X));$Pa=(is_int($Y)?$Y==$r+1:(is_array($Y)?in_array($r+1,$Y):$Y===$X));$K.=" <label><input type='$U'$ya value='".($r+1)."'".($Pa?' checked':'').'>'.h($b->editVal($X,$m)).'</label>';}return$K;}function
input($m,$Y,$q){global$ih,$b,$w;$E=h(bracket_escape($m["field"]));echo"<td class='function'>";if(is_array($Y)&&!$q){$va=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$va[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$va);$q="json";}$Hf=($w=="mssql"&&$m["auto_increment"]);if($Hf&&!$_POST["save"])$q=null;$Mc=(isset($_GET["select"])||$Hf?array("orig"=>lang(8)):array())+$b->editFunctions($m);$ya=" name='fields[$E]'";if($m["type"]=="enum")echo
h($Mc[""])."<td>".$b->editInput($_GET["edit"],$m,$ya,$Y);else{$Xc=(in_array($q,$Mc)||isset($Mc[$q]));echo(count($Mc)>1?"<select name='function[$E]'>".optionlist($Mc,$q===null||$Xc?$q:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($Mc))).'<td>';$md=$b->editInput($_GET["edit"],$m,$ya,$Y);if($md!="")echo$md;elseif(preg_match('~bool~',$m["type"]))echo"<input type='hidden'$ya value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$ya value='1'>";elseif($m["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$m["length"],$C);foreach($C[1]as$r=>$X){$X=stripcslashes(str_replace("''","'",$X));$Pa=(is_int($Y)?($Y>>$r)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$E][$r]' value='".(1<<$r)."'".($Pa?' checked':'').">".h($b->editVal($X,$m)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$m["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$E'>";elseif(($Mg=preg_match('~text|lob|memo~i',$m["type"]))||preg_match("~\n~",$Y)){if($Mg&&$w!="sqlite")$ya.=" cols='50' rows='12'";else{$M=min(12,substr_count($Y,"\n")+1);$ya.=" cols='30' rows='$M'".($M==1?" style='height: 1.2em;'":"");}echo"<textarea$ya>".h($Y).'</textarea>';}elseif($q=="json"||preg_match('~^jsonb?$~',$m["type"]))echo"<textarea$ya cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Xd=(!preg_match('~int~',$m["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$m["length"],$B)?((preg_match("~binary~",$m["type"])?2:1)*$B[1]+($B[3]?1:0)+($B[2]&&!$m["unsigned"]?1:0)):($ih[$m["type"]]?$ih[$m["type"]]+($m["unsigned"]?0:1):0));if($w=='sql'&&min_version(5.6)&&preg_match('~time~',$m["type"]))$Xd+=7;echo"<input".((!$Xc||$q==="")&&preg_match('~(?<!o)int(?!er)~',$m["type"])&&!preg_match('~\[\]~',$m["full_type"])?" type='number'":"")." value='".h($Y)."'".($Xd?" data-maxlength='$Xd'":"").(preg_match('~char|binary~',$m["type"])&&$Xd>20?" size='40'":"")."$ya>";}echo$b->editHint($_GET["edit"],$m,$Y);$Bc=0;foreach($Mc
as$x=>$X){if($x===""||!$X)break;$Bc++;}if($Bc)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $Bc), oninput: function () { this.onchange(); }});");}}function
process_input($m){global$b,$k;$t=bracket_escape($m["field"]);$q=$_POST["function"][$t]??null;$Y=$_POST["fields"][$t];if($m["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($m["auto_increment"]&&$Y=="")return
null;if($q=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?idf_escape($m["field"]):false);if($q=="NULL")return"NULL";if($m["type"]=="set")return
array_sum((array)$Y);if($q=="json"){$q="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$m["type"])&&ini_bool("file_uploads")){$zc=get_file("fields-$t");if(!is_string($zc))return
false;return$k->quoteBinary($zc);}return$b->processInput($m,$Y,$q);}function
fields_from_edit(){global$k;$K=array();foreach((array)$_POST["field_keys"]as$x=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$x];$_POST["fields"][$X]=$_POST["field_vals"][$x];}}foreach((array)$_POST["fields"]as$x=>$X){$E=bracket_escape($x,1);$K[$E]=array("field"=>$E,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($x==$k->primary),);}return$K;}function
search_tables(){global$b,$f;$_GET["where"][0]["val"]=$_POST["query"];$Yf="<ul>\n";foreach(table_status('',true)as$Q=>$R){$E=$b->tableName($R);if(isset($R["Engine"])&&$E!=""&&(!$_POST["tables"]||in_array($Q,$_POST["tables"]))){$J=$f->query("SELECT".limit("1 FROM ".table($Q)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($Q),array())),1));if(!$J||$J->fetch_row()){$pf="<a href='".h(ME."select=".urlencode($Q)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$E</a>";echo"$Yf<li>".($J?$pf:"<p class='error'>$pf: ".error())."\n";$Yf="";}}}echo($Yf?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($fd,$ee=false){global$b;$K=$b->dumpHeaders($fd,$ee);$Qe=$_POST["output"];if($Qe!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($fd).".$K".($Qe!="file"&&preg_match('~^[0-9a-z]+$~',$Qe)?".$Qe":""));session_write_close();ob_flush();flush();return$K;}function
dump_csv($L){foreach($L
as$x=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$L[$x]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$L)."\r\n";}function
apply_sql_function($q,$c){return($q?($q=="unixepoch"?"DATETIME($c, '$q')":($q=="count distinct"?"COUNT(DISTINCT ":strtoupper("$q("))."$c)"):$c);}function
get_temp_dir(){$K=ini_get("upload_tmp_dir");if(!$K){if(function_exists('sys_get_temp_dir'))$K=sys_get_temp_dir();else{$_c=@tempnam("","");if(!$_c)return
false;$K=dirname($_c);unlink($_c);}}return$K;}function
file_open_lock($_c){$p=@fopen($_c,"r+");if(!$p){$p=@fopen($_c,"w");if(!$p)return;chmod($_c,0660);}flock($p,LOCK_EX);return$p;}function
file_write_unlock($p,$vb){rewind($p);fwrite($p,$vb);ftruncate($p,strlen($vb));flock($p,LOCK_UN);fclose($p);}function
password_file($h){$_c=get_temp_dir()."/adminer.key";$K=@file_get_contents($_c);if($K||!$h)return$K;$p=@fopen($_c,"w");if($p){chmod($_c,0660);$K=rand_string();fwrite($p,$K);fclose($p);}return$K;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$z,$m,$Ng){global$b;if(is_array($X)){$K="";foreach($X
as$wd=>$W)$K.="<tr>".($X!=array_values($X)?"<th>".h($wd):"")."<td>".select_value($W,$z,$m,$Ng);return"<table cellspacing='0'>$K</table>";}if(!$z)$z=$b->selectLink($X,$m);if($z===null){if(is_mail($X))$z="mailto:$X";if(is_url($X))$z=$X;}$K=$b->editVal($X,$m);if($K!==null){if(!is_utf8($K))$K="\0";elseif($Ng!=""&&is_shortable($m))$K=shorten_utf8($K,max(0,+$Ng));else$K=h($K);}return$b->selectVal($K,$z,$m,$X);}function
is_mail($ac){$xa='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$Ob='[[:alnum:]](?:[-[:alnum:]]{0,61}[[:alnum:]])';$df="$xa+(?:\\.$xa+)*@(?:$Ob?\\.)+$Ob";return
is_string($ac)&&preg_match("(^$df(?:,\\s*$df)*\$)i",$ac);}function
is_url($tg){return(bool)preg_match('~^
			https?://                 # scheme
			(?:
				# IPv6 in square brackets
				\[(?:
					(?:[[:xdigit:]]{1,4}:){7}[[:xdigit:]]{1,4} |             # 1:2:3:4:5:6:7:8
					(?:[[:xdigit:]]{1,4}:){1,7}: |                           # 1::                             1:2:3:4:5:6:7::
					(?:[[:xdigit:]]{1,4}:){1,6}:[[:xdigit:]]{1,4} |          # 1::8            1:2:3:4:5:6::8  1:2:3:4:5:6::8
					(?:[[:xdigit:]]{1,4}:){1,5}(?::[[:xdigit:]]{1,4}){1,2} | # 1::7:8          1:2:3:4:5::7:8  1:2:3:4:5::8
					(?:[[:xdigit:]]{1,4}:){1,4}(?::[[:xdigit:]]{1,4}){1,3} | # 1::6:7:8        1:2:3:4::6:7:8  1:2:3:4::8
					(?:[[:xdigit:]]{1,4}:){1,3}(?::[[:xdigit:]]{1,4}){1,4} | # 1::5:6:7:8      1:2:3::5:6:7:8  1:2:3::8
					(?:[[:xdigit:]]{1,4}:){1,2}(?::[[:xdigit:]]{1,4}){1,5} | # 1::4:5:6:7:8    1:2::4:5:6:7:8  1:2::8
					[[:xdigit:]]{1,4}:(?::[[:xdigit:]]{1,4}){1,6} |          # 1::3:4:5:6:7:8  1::3:4:5:6:7:8  1::8
					:(?::[[:xdigit:]]{1,4}){1,7} |                           # ::2:3:4:5:6:7:8 ::2:3:4:5:6:7:8 ::8
					fe80:(?::[[:xdigit:]]{0,4}){0,4}%[[:alnum:]]+ |          # fe80::7:8%eth0  fe80::7:8%1     (link-local IPv6 addresses with zone index)
					::(?:ffff(?::0{1,4})?:)?
						(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\.){3}
						(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])
						(?<!\b0\.0\.0\.0) |                                  # ::255.255.255.255  ::ffff:255.255.255.255 ::ffff:0:255.255.255.255  (IPv4-mapped IPv6 addresses and IPv4-translated addresses)
					(?:[[:xdigit:]]{1,4}:){1,4}:
						(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\.){3}
						(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])
						(?<!\b0\.0\.0\.0)                                    # 2001:db8:3:4::192.0.2.33  64:ff9b::192.0.2.33 (IPv4-Embedded IPv6 Address)
				)\] |
				# IPv4
				(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\.){3}
					(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])
					(?<!\b0\.0\.0\.0) |                                      # 0.0.0.0 excluded for URLs
				# domain
				[_[:alnum:]](?:[-_[:alnum:]]{0,61}[_[:alnum:]])?
					(?:\.[_[:alnum:]](?:[-_[:alnum:]]{0,61}[_[:alnum:]])?)*
			)                         # host
			(?::(?:[1-9]\d{0,3})?\d)? # port
			(?:/[^\s?\#]*)?           # path
			(?:\?[^\s\#]*)?           # query
			(?:\#\S*)?                # fragment
			$~xi',$tg);}function
is_shortable($m){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$m["type"]??null);}function
count_rows($Q,$Z,$sd,$Qc){global$w;$I=" FROM ".table($Q).($Z?" WHERE ".implode(" AND ",$Z):"");return($sd&&($w=="sql"||count($Qc)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$Qc).")$I":"SELECT COUNT(*)".($sd?" FROM (SELECT 1$I GROUP BY ".implode(", ",$Qc).") x":$I));}function
slow_query($I){global$b,$T,$k;$j=$b->database();$Pg=$b->queryTimeout();$hg=$k->slowQuery($I,$Pg);if(!$hg&&support("kill")&&is_object($g=connect())&&($j==""||$g->select_db($j))){$yd=$g->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$yd,'&token=',$T,'\');
}, ',1000*$Pg,');
</script>
';}else$g=null;ob_flush();flush();$K=@get_key_vals(($hg?$hg:$I),$g,false);if($g){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$K;}function
get_token(){$yf=rand(1,1e6);return($yf^$_SESSION["token"]).":$yf";}function
verify_token(){list($T,$yf)=explode(":",$_POST["token"]);return($yf^$_SESSION["token"])==$T;}function
lzw_decompress($Fa){$Lb=256;$Ga=8;$Va=array();$If=0;$Jf=0;for($r=0;$r<strlen($Fa);$r++){$If=($If<<8)+ord($Fa[$r]);$Jf+=8;if($Jf>=$Ga){$Jf-=$Ga;$Va[]=$If>>$Jf;$If&=(1<<$Jf)-1;$Lb++;if($Lb>>$Ga)$Ga++;}}$Kb=range("\0","\xFF");$K="";foreach($Va
as$r=>$Ua){$Zb=$Kb[$Ua];if(!isset($Zb))$Zb=$Kh.$Kh[0];$K.=$Zb;if($r)$Kb[]=$Kh.$Zb[0];$Kh=$Zb;}return$K;}function
on_help($bb,$fg=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $bb, $fg) }, onmouseout: helpMouseout});","");}function
edit_form($Q,$n,$L,$qh){global$b,$w,$T,$l;$Bg=$b->tableName(table_status1($Q,true));page_header(($qh?lang(10):lang(11)),$l,array("select"=>array($Q,$Bg)),$Bg);$b->editRowPrint($Q,$n,$L,$qh);if($L===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$n)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0' class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($n
as$E=>$m){echo"<tr><th>".$b->fieldName($m);$Bb=$_GET["set"][bracket_escape($E)]??null;if($Bb===null){$Bb=$m["default"];if($m["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$Bb,$Ff))$Bb=$Ff[1];}$Y=($L!==null?($L[$E]!=""&&$w=="sql"&&preg_match("~enum|set~",$m["type"])?(is_array($L[$E])?array_sum($L[$E]):+$L[$E]):(is_bool($L[$E])?+$L[$E]:$L[$E])):(!$qh&&$m["auto_increment"]?"":(isset($_GET["select"])?false:$Bb)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$m);$Dc=null;if(isset($_POST["function"][$E]))$Dc=(string)$_POST["function"][$E];$q=($_POST["save"]?$Dc:($qh&&preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$qh&&$Y==$m["default"]&&preg_match('~^[\w.]+\(~',$Y))$q="SQL";if(preg_match("~time~",$m["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$q="now";}input($m,$Y,$q);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($n){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($qh?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($qh?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}}echo($qh?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$n?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$T,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0X\0Z\0\0C> \r9\09\$M'JeRd]/LfS9m7I[m|:(nNiTe6+y<^e(,EY\$L\$uDK}>o[`*qJs5ͅmrY<+w|9˷M2}_땢\\\"V\n+MtBK*3ypl5I`V)OWs{OIAs۹㉥N&cO}~hH@GzJyGCcNJЪ`귊FC{вU@i>YJEiNR(9A%!CQ^yat:&۝YGH/\ngxs~@%y8ZUEOac@:\n;G>9i}@p,6&c Fő^%aRAQhIZԵ9z\\š`V5ZjoT9!^O)12l.I~^Qt꒦usI;OlB\$Q9q	\\eTsęUq2H֥J'(EvT!ѐ%EQFPv\\o'JtGIID\"e3-	oj&8E@uTICTUPy3ڶ>L^jbK#qD8ʒ\\Mdql\\y^]94hNk_g^GQ1)PQ8eMUsոbRha&]O5VUз-d23\\U@kWg+˷'gZٖE)KJ|qP=ҟO`[%wOgNMPcS	C!pdS#!KL=}ߠtp4!/k6uNdU28XDXHDvOb4IN<+q*?7WM!X,dXN(Ж=0Kvǘ25F #\$a&LSd\r(ЗFHИᖒ߱2:'M>RXcq)xdCp\rah'\0hDȠ`l&&B8Bm.rAeIQ2@). n`|ًF<䤳ZJ[a(KoP\"4D?TRgLJU_#8%u\$ASʆKJA8f17M]J&1=afK<w\$	MITTH&30?6ls\$DU\$ThI[5*MdbDPLsF\0'AJp-\rG3_k]|m%`_,8sE<2r!;|*TTQ-tق`<GlJi9GLKaK{\n=M+1h/:W\\[q\\Kaleݲu)v-~5UL?ED[1\\V66gĽfΪ8Io]h[ݒ R)!Ι˕W[5K'?};ii]3lFccL|^5;*ǸQ博&<Yu/rٗ\n-x8'\r1)#n9Vx%YdI\ntI*ȳs~m7.ǌRjX+^PeRײ:Je9{#';죥u2Rj]MFZVj]ZZk]mƲ");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\nCo6C(\"#Ha1#yd1٘n:#(b.\rDc)a7Elñi1Ύs54f4ngsIhMдi:`,]YtL0hD*B0\rF&3xs'[Ʉtv4S%0XLW5)Yf\r^=~9g0\\@rQNn^yNj{opC%ʋGSZh5Z|>:'b{J)Ɠєt1*uS=^2*8t(0R,8j:x@9\n@1\nJ#4BRJFƋ>#J`HaahbC0\r4Ar&\nB54\$>+QA2DoMEL\"48=s5DLW7JGf**HjEK16ڸ,oLtJA\\\$Q|9-H@0\nxtV(o.+ܮ;1D8e*c\rT䍣B2܍z\n83=Ktƻu(kmׅ.G;+:2)cn<s5:6\nԡ)_\\6YL\"VV`c\$L;k&\$?XAWU48	Bޡڮz*[O24<?{36%;VV:\\A䎈	xnpxF<[xoW.U[Ãsd7rF&	bÒ]t*7ji=dZֹYy4:ie&Pg\\1C0:;;ٹ5Cnà\\܎#ܳ4{^g7u6NJ6OC#{!?fxw!70JJL48dpLàypC[.AltPQ'zl=N7@m\n/cTc]tהxiaD+pPpxׅUJ%Da`@^OEc)Ň@@A')hUb!AƸڠT~P\\*9Gi};`ˠh\r1Zlx9HI)AjRWI9!#̆[ysZb--q؇h7➀LjQʻ\"#lU`ׄ^Ar\rffV.QsnhGgN@e%?\$ᰂI;T\0`]B\r8[r2`\rҢ\rCKeF2ٺ\r'[t(),M)ڸ Se=*N@+9%Pin:܋T}ԎMC\rNtg%VÕ]V6Hʒl?Մ_Vhee,3ھF n%^kaM)_a-NB-v)rJ1NUly\0#YM˵Y`EM֭\"UH-_ #ܹE\"\rv42FL8wZ0]5Sw.!0ʴQ͏3E|%}AC0tLk3Pj/kbN`QQ7x_僧B<A8@%>\nx[&\rfy !SLsVG(¹	B\$a[F\\A8G&r;or>biRZMm,d\"<;\"Q?1uV~G,\0գ0c`IϣEPR^fBhUuɔ3CH(& i:\rt.W&5}UmߗpQNi`\ndi#(1QKҒ\nI,Yf`'(p7`q\rt\0U\rsr:ħ0و;A,v0p\rBPcrR^m.o\n=\\9%F7ZV#0|Yygf?/\"aMܿHnЬDdjl\0nAxsP(3}d#u`'p@[[T*`Z?\\!>˄vl}zf3; !(6/&A\08\0\0r\rp4{TT/!\ruAtH8JU`r9`j\r-H\"ՃATH ? }qA3l~a~2I^`Z\0004 ̓eP&\0p`n8pd%f\0sO`hD0\0p, i\$\\\0mO[ nD&`aP\\p2.0/0P0\nbVDd&&jd\"ioB0\$&\0aGJ& @&O7@i\$%\n0/bdo.\rro<\rP^Q\n	o`/\r^P}O6@nD d@0	^s\0#\0\$zIQjoc0M0OC [0@Q@`pf/P,ANp|PNF:ol@pPo@I`c	\$p/%\0HњpuP!h+\"A\$\"a_'/?U6DّCq fdiP\n%uQ\0e@pp#q\0\$o\npDB\0ϓ\00^P\"oB0ZO1	a*%Vj҄?/-!B,W\"ϑP\nPEFk/p_\rc+/\$S/7+/4_Lq'`D2%ύų#\r nב7p1#p7`O0\$o-!2Pѽ'&02	Nv/1\$io5\nO ip<23QD1</1-W\rCҍSٓ\n	\0\r؄JdrP#(J^nA N4\$(?\"CtH\r*\"1eptox\r|9ӰA \rADtKB@\0OCorsG`/kԍE,@O(KF,R+0A!/P\0%#s}PP;\rETE6\r@*hUK01uI8@^:`pR\0' T@b\"UaUdhi1SR+K	OtmJGTGE\0qq\n/jQ\0RA3s.Na\\@\n*1/\"a[/ϛ0Nك<aR0QUa/-P\\Hoap-%/\nskUѼ	\\#]6M!Tfr^\r*%PIZoKQ\"VE952S\$i+6OHѶZO'Zp2U M0<,Y1[Ui96-PR8p\r3?7O'cҳ`r;ӝ``%31A4%WhYqoG7oa,[Q7o sk_gii,rOij1CqI\0/!ғ]^TPHwM!wmQ01+mR},O?+T5pNK^Sfhssvk71f/5cg\0n@1zҴ\0koPI#\0i'E{GZ\rVxR`0#!/\nqc!1g?2nOj@pД@j\r<9Oq~@e0!3P#?YqلҸ5/?\0/6tIus cDi7nW\$UmA3kR?u\0r}Wt_bctō23p01r;bVv6;%17/)(]1W'QU1 v0\0gtADAWBtWX\"aXu9I<5CCTEEKATE4!W6) RccR\$kcL3:#T4'sOcV/\03\"T4j)PP%r;oLՏJT\$rnt6Ne95+#a2\r'MPo9UUmQX{Y ۛqu\0g&ZO-[IZ::?SA\0ڂ` D\"Bm*ePSj`JX\"ɍKFY>0nz\r:\00043,b,f(hޚLG3ICG.X.,7.j{\$]mrmV.Ξ\0N*vuXH`zON/V^ dɨD\0ƘhI\"˨piERVc9.O-.k\0DϻaE[HL\"b[Cj;EF9Q\"E|[2{M\0D	Fi\0h	\0`[痠E\ns\r0nsidCI@eŶ#eRivŜKn\\-|;7`qH`E܇BɚCӮܢ9||z^'p	c8-	bҕIP!G*@%:@C[	+; \0i(,LC!1[HPV[W`{dK)X\\ik=d.Е{Cכ񛿶<ɿ-I;Խ7\"Q?#ٛ9jE-%ۃ<<-\\)ͣY`\rIN!lHpI8!d]ܽٔ<yẉf	/j‘	gɵ<-DǛ>葱\rN]{юqd2]1tHFi[CcL\$_]Ӯ{kt]Ky՛i{\$Si =of{Ֆ[ݜݠ!]A=4e=#F;׾ĉ¿ܜ+ȓvƜMnsNHqw\\V?E<>	!'=|Rwd6ϊ\rwI?_yɾ!)fw˞3匥w~F#ɅxWt1(ɇRerW!I[ʤp)K1@HfI:Q S	r;5nbkqTʒ;  o*@r&Glq<\0.w6VckBhH(jOC7yC(mpV\n*1#n<[BR92E@&F(\n?J͐[ARWaػv8Wf#P:k{d`a't#tBmCXdr+sP,Adhwb?``b[ʡ\\+HXD90Ö]CY\$/Xk`/\"5|Q`Q\rj\\'CB?Uҏ,F4><agoA,(MNrHkeI,T*}òp8oPi yp\\'?9I&JNه:͏<.c01 3hB*aEzkhLmSԝ8:Ym˩vꗯ{	^^UQI{H[!\"ە^N{x4;!|}|nŵvb9ݎ<9qaY`c8;o\0f1\$o@5`} 7@h +((wq4i6x=ѣq;'9Qd# ſNiyq%>/ãb7ډ\rClFTqTaxˀ/Nt_^e\"6<1SƼ<G_+AWch=xL}GC8{Po,>9[]٘h@PÇ=4H~B\$N&4ѰPD, \0V@rj\$>:D\$	_Z#r;z4'|A HAPI}Dq*J8p\n EQ8\n  \$m`)W0ZI&ji2J²[Q\n~b@xkXrQAzb\$+ 	\"搐D\niC>\nҊ4)T{dQh`{&oBr,B(JjFād!\\jZQAO+2T,Cn|Sbr'@6| m((vú+YvK~]P@.sN_\0\0_aޗ03w0L\"a,yUwL_(ÐyL(08vF`[.Y~L(} oDjP7B^\rL%\nf<2\04)M3sG LMi?_r٘Lj_B-kZmj82͘5R4ڞYBJk3bBe1͖ٙl<f0B9!]/TG+*ʐIq\nܞS0@.B(CIsӛ^.2tRLg;:͘\r<̲eEKjtf:9ξuDg7<IM(<t9rN<ʙtˀ79L _c1yg>OVg:O6z3,x@1bM_\0&0\nb@sgN˚\0eDH+?KPrxnFUcE|ب#3Вp@jg-yuhW?(\0gThe:~t=B6Ȕ1DPaT8uCj)KZXchD#8XFy˼`-\\ Q&h_|ӃNiЖ<sa-f2NE-H>`0k-{8*IpCnt\$h7BV\\5#|(yDMKTE9I٢\rB9\\CS\n%fgJ,кt7 +DuJ6r~a.'`GPznm-7^>o5fཕ|=!PWxT⽐`)QW\np(|Z*?pс\r@kO!.3aq]\n'\nm=Ah)paU9NҝshgڕHa5x/ ");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`v0C98a^M4Ł\r|7zF[\n(7vIĈ2,9Ì#ȨDWR;P'm3샂\n\0u39Cw2fp{и/	o4ax/ \\.=NJG@YE9a߉mg[ӹ=z{4\01CH:>X>~]\0dws!:%9~a\nj0XuS6dIV3̼r`AD@x9'A@\\Ta3((\nP`o{e9=	`\"	[B{!:x?)'|f8C ?Pu|@xR;U\0(.5joN)/97LA#8eACA0&#wKդRGZaH	UݑpRb`WްJ\n!MDxkVnO(#yN#h\"@1\0Ɖ#8L2\\rQ\0r\r`Yvb+1Hl`%z. M 5lNb\$2TxH`XHSWmb)'>'zP!и@?V=8\n+da07;ɹ*~WwܕR*T8CҮ]Xn'I2n\$p4JtX<>yK)qi%Ű4>V\nH{Jj1}6JSPCa2\"}s(ڙ^m*D9ͩɸu:AyT˩L͜:+p^VJGff5%y	ܞY[댝[\$EUYZuJdA6[-CHl)ʃm=GfclRVxU UXR\$ij˻G	2[T'\n5sFYhi\0X%_!\rE44ltm93lS{S*g8\$\"kHO)Jbʵp%\\Ps#)B:ai Z^\nkv2FPJʘnB,ܧfX5pB`ooI!=8)caH㨬b(JGaʏ\"BF T{Rp*e~2^ >v>%^13wCX=!gTe=9p>5;u+hMWZA\rė\\M\\3gМ[YvqX[b)2\rWL+ŊezA|ed9Ae\\ap.@_긳~cp%-ZW[QI7E5uȔ[6%PCio[1A4KD\$i.	?V{/_y]@^q&#\0O</q\"檭\\WUHyWtjV{nVf+μt,Ċ^g:LUiݻe*ǏW/-%嬍\"8C^&(E\\6ZN9ysv^/B0RZO\0;`N &Q;P2Β+=MtZ472hLWoK'& zHܧj?\nRDG*Ӊ-#<I,P,Z;h\0#NM>I`(E4\rT]\"V\0XQj~ bR`MN-RSN,\"0	d~y\r\r@`Q-\\s\n.P)]\0p\r]T*}\rp#-jEmp!ɨf@@W<cmXv	z|KJm\0@WX\0Kl<!N*GECZoBzТ\rxGeHNH(gj񂰯\0xoK@11lD\$Р`Dv V bSгH`2pn.qQJ+*fMp\r /D*\"w\$o2[QF`M|1Rho'&5#%j>jMگt@&rpGdDbtsR\$r!N2qo{*,DɯbrM`.QqD%јG	!J-+EDE`{0䧩0DE#p(7#2ܳbd73M&ysH\"74rL9-f*܋/rRŘRBn*ij@nB茴\\FIX%x f\$9J}9a0qsnFH|@E3};)k7|HKK5SdvR@  ( \r&*Ja@fp+Jk,w _?\"X\rN3'5&t%;A8Lrn?EQ\0%NSka8\0Ю<DUGF8VTDWe7`HtHn GJl;HTjN`@HDs[tΎ((Hexm7vyIҾ#T=>()\$_ԧOOQ-e(*GKdKt`DV!C8sDi<)3BKU;8SZB(.GDc,EuTpdl7J38DK\nbtNSHUt#{VluVZuF\r@`]6Zǌǀ][\\\rf(0SS43D'W:Sc:ǅb)fĢ#w5vs,rw6&\\m0\0ڜ\nJv66Kd)cu&R37NSX5>DUZ:Z'rT7Sk_G[Ĩ\$KU\\x<m5#[E\\ɞ0WJ*.\ro]#C*5kg|<-uSO7TS^hosp f֍8I\\#8_R{pe'2=S@[:e8ҕd35]r֪ֈ&De\$nW[3^vTԖw)vܭX0cmasZ xm׌בPyyz:^2b᎗9Uqo of>\";K|3yVhl	0No.%@OGvJ7M(A,\"[\0/, %Īσ*2x}˦gA!,,ǖ:&\r,3_-ԇlHo8vwSj)V)(NSXHXMXCx'/AXZ^|f҃i,ʸg؎[ڭ@QbLxJ\0jS Z	VB\"Ћc<ТtP5uP\rܬm\"yBCMnw^1 Njx./*ntI\"2\"=r\$:kwba.1>3h(Kom5;2g|B\"iD\rgBX%rV\0n\\FMm\0~\\͞4`.*\0@'9  d	{6瞠\nP놾In˛Y[VXm^oԢ?g<P@N/KsDeP\0xǤg}[sG俥S5u%%E@/OZe{LY))BR`	\nQCLyh783\0˲\06!N\"\$[h@aZZd\"\\\"Vg9[)hN`mL-՟fЍd oXh\"kӸsJ\"m2N2T.uǜyp'c)(ݦ[ɶ[`g;SZJzK&jZOp	ɧ@˪ZJz(Ӯ@{8\0_Ł\n3/|u0K:IV:YņEmRfn4fow1rN2sb0ق<d/eGfZXɌ<I<,b\rǖK\rJ\"H+q-wP,\$߫%U,՘@ӮLiT0K2yiĳ=|\\9wā2B5\n\refJ]ѳWGyb'HQ\\\n@ s#p8P}}j\ro`\rE RMMHJW nt\r*NoCMCB\"_HkRN#]d<.\\Xe&_G_n%9ƛm4\\Veg1'ao\r5p|[\0М@h tPbgӦ|)l{)~|̙קsz1vtFF)XA4y/g!ghNqh_j̏k+`0woSkW~,~P<3h~~DXE	\"ɺkRb\$BI!IYxF%FTg6-X/\"RmdkXQ`FS?V7Uвp&إsx@o|?MW`iHBC9꥚e;3;HP\"L5	#^S,5`#\"NɢB,\$o&n;xZ-]>q1 he:\0\r[\"*bw&6Vr\n>󹑭@SȚ܋>,43Y\r*=|Rڍ09il!SL\$`dN d%252(VBA ]E x*	dF38	{f(^>H&Mf^Mҙ\0]B\r	U*nPt`'?\n|,`:{x=8nHrFƧZpsO\n|	QN,O\\)+\n .)\nhY0,_\\n/\$CۄX\nP(\n`X,͹MpҬ++@ƌ8V5yN@'#dH\0X=	kV 	BAPѝ\r(Ydh~qb	6AR\0Xg|\r`\\8H. NJq2\rԉ2[P CJ	V'K[H@KMtT 	V=!%' \nV@!S~ugDWmɗZR-kbr iƬ=08AdLYRS!\"rxYC\0CF^{xȐŸ\r\"K=;A\0t L\"וEѧX#\nƵ/|<CWt^4v6R\"ted)^f6l.&`G5%RJMIB#9T-D\"FXڍ1~ߪJ.-jb`{hX'QHtzV2G!|K*#Gխ~cH1\n%`d3bYxnIȕ`ǷyILhB\0=l!AzS\rMHb\$E6F~Iȵ^aKOj*a*ϓt0-2\r|2@~NF6Ě('`\"CPE\$ep7R^@&/\$Rz\r\\vL?m\"6-\n`q\$@I!҄C움'	9jKv(6\$?[5ʒ#DC%)7Ŧ܂r5N*A̎2쩘<Bc-IR8^!QV]CFBS/zc&@yI\$35Ոl.HlK1 s\"5\rҶ\$)kQjJ܀E.7v^\" Rn%=\nto8^68@ħɦQ MxK8`0%T3 iqɠ:E\\d2I>p\r8Yi]UEd`ԧ^#2dEb\0cL/Y!OTĸ˦ eh\n`jypxB`ð+@4T؀igo\0^PSRumҏ(gߙܥ;5y̴9,Q4J9q'XݼP#	q8?%4&q.Yͤ:q)v5!!ȅk8ʀ {\$IKخQґٖж't0~KYcH) |+&Z\"@\nB DE{#eHL\"V\"y1 j)9ب6iY>s-hЃϱ\0^md9iz#'EA@)aX Q0:F0⷟CUn[bʳ+iHL9cv-!PF+d(K\"bdƄ@_C %|;PxuoxswD\"GGcoV\"<@2}kp%\r \"\0G	\"\$4CxJ\0ay@\n{CkMt4S# ȰUphxdqcZ\nG(>Æ\0  Lk\$>`@LǓ;6A-Z\$y, @Z~V5rBy `\$+?I[RT ?],;R\re)(.5P%TS 5\n'킦U>[:NrAsJQ03?0T,%CU5D;)QVPŕ&6hB\\HVX0>XA1[I0ؘZDWR4kI,æRzE'Q;`-4xkťbtTx`\$A(ܗM-SLe\"Da1T\"-u164yQqf\$Ɵl|(	/VuQkYX&.U8\"	j%fme`syl%<ڞTARMPK 3τK1`e)QD@7cNHpOVah  PJNpĞ\n3+0gꐫ@QL-SH<fM'%tIc\\-Q2uRjers+DP&{_u*Wt'itaWSOTtD[-Jk\$-%~bZz%6 C E(,awI][VƉBҭv7\nȤqM[b.WҨN_YdV(,\\lb'pLdNtdƢ/13 LFx2Ap~1*(3 T91B\0y\$a\\9?hj5Qؕ4lGo:-`pODbw]qRv=&K@@ԯj\"HAMd;zG@KZ쑔YqTrC䁧lejEZY1tP*8_n[8]\$M8V?.PEjC\0	IX@ \"\0P\nRdvYL3(\0:)mii	94-;PTm8v*DC`\0aaV\\ tANp\0_	\"\0ÛUӡ,IɝH-lm>۪\$e[pڎ*`Q)SkS`:Tb;n+v	w<v\rO2Yۈ,o=ʜDt 8QPavf~}W#eL( )'#r\0'	B1G,)TJ:I`h'Bd9YP*(\0/W\r\0W{0>]F(cK*YT5FZއx0=p[++O.݀V*QFo)Z-AQs\\>?>d=tg1Z2L6\\҈x2X+5ˀΊ2&nI\\;;]i\nƔBBN)@=x)Kpn2]	oǩ`AK^	p+gVA۵WGHs>!اtv4	3\\	`nK],!AS|Bse`1'Db`bd#6p.aym\$=pXweufV݌UH%#̽\rm(]\0LF8rE]\n2u7ifXu&&pJWQ斡 /'6R.cxŅrUsE̎2_UNG\0\\-Qp<W3OEN!Wdb2M,{ty\0g\"ڮF(>e%@K\naVrö)3U&zB,8\0-\$TWrlRYQcpkZ!_f!_ (2ðQB2ٚ*5\".4'=a,*h[]臅mT]J;\"ݳ^P*n>0eNw̵r_WZ\"8+J`RD8b׷ӪX.:U\$jdB\0ApRsqP-./F5`UBVFsz3\"2^`05\0&E*hr4`j`e{C0A\rM/L[s2QBfIMsvA*(!2c\0/ps,' yO\rE؛Ed2q\\Pr>J𣮕i>U}ɾô'_ 'Gꐓüft\nJJyP۠TKU142GL+Wvd?-^A]9CI6Nă!A#/\nhb,a]`: kq`\"d@4c4*I35F[m*aF\n9VXWDX\\A߫L7Ri؊.:mBDB3]ALj?#beЀXSɌYe\"hm4kdc3QL3M<C}鮀'y~Fվ?;B\"Fo_\"ղŮyȭM8L^Zj#Bz.tNBiȯP.Ck\r~þ-(a\"A%cc\0B'4A)#G&=ڣIA\rMe@35x}\rc	&8ScZE_nUJI~g93\\'NKZa\ng\$I<\0%fKkrFgߐ3&mI;RY!@oN!12 &=Θp*{hPv٨fM.	cB;um;p~E߸:DǋM#6674J4Kđv4bQ3Bw+2[V?&-sɞw%gGU^wiuCHZ\0;rգ6#9\rN`Ԟ|aضHM:[X^x	)v1`1e6lu<#;7cHg.nJmǨ^7`/-~MEMngu`p	D	S]gLvqao(o?wvx7p!0J tf!oiOn+e_yْ	Ħw~\$WoQ\$>#un-Fiw-\0.5AK5/dC8fhkZJbؘzQpVq\0R'	M2Jp>(B\0t6I91s~H\"+gPq-8]y2{Sa\rn)k{hf)F2L3SQg|GZL֧J>H>X?U\\		Œ~	%\"5ݖf-8B,v093(\\8 g}P@3NeiUHF֑<	{F'A)q#S=p7r@DN	Ck}E5z03J+\0X^6G|PgĦP8˻\nv|(NGR>i Z//@p>[wfv^N^NX4Lo}IZEyz{S+xA% \\2Te@ݫU־|h7/fgD&Wf^}Y@84Ht7ٝ=fϺzyJcE2dt|:X{kq\\C0*Y)~kk\\m*(9.{򱽋bTw?:MiŬ9-ZE83ɬ\"z=!5.@'\\m0WjFN\\idA8e>j`0>ºUfm ܛ=*f#d,QmA`0:>|BW&\nĶ	Om3#ŻV,dwS*Ob\$;HbYSGOg21%JJI3事\$%aCSL';k\$XO%\$	1qf2!@cXZ!Aw=Yfx}#1ˎcמ1Pٕ?aD@dp&>2rJh']`_*\\@<\0v	c|z#zyq&;|oY4gHB;s|mh?\$	D(\0DMdQY_xJ(!!OCh7S;WkKg=APXmRJW?7~GK\$c\$}7fRg4gQwXch\"O|y&RFUO.BKqCUG/~%QntWX:֐v\"*p{2'2(9ڦH`hqe;#@~	.!:HQBT\$~y\n_-'&@_6&C\"	;4#?l3܍_o'e<Ȳ\"/'X\0fQ#0nn5#6vHS^8'`LM8V/SR~p?D{/ڇh-o-A|\0k	'Id*~C_: '\0M(Y1`+VAS塓4^HǎVY9C҇> p9jCx\0Z\0	:ZZ.Hḡ!J`ʂ:V\$pmȃJx\0V% f	m@̮Jĩ(]# 	{oH2RLz:A|y0\"4RT/?8HRq!X&A`!MA\"lL ?&\0&'h{,\\!AVR)(PYOs'yBÜ!<o>\0\\^Z4Mh~0E5F\0azJ2HAb d4PˏRUv2Jb0-b\rA:pvhs[#Pt@8PAzQ4^R< #;psy\$[FS(9k6p_PVABm{*0h `A6)4\0!Yd	@YHB.24Pln'\n|l)AN(9!U0RD#t|*5poҢJ<T1YB,\n,nAA;!\0\$м\"V|-AVz2Pp\0>vh]0u\$(ZL0kd	,1!D VJ'@̩`5dPͻXEnՆQP1@l\rˉ\r2),.0:pXWk؀VPM\0W2ɝCa:\0P`Cz\rJH-<\na( uga!&\0001/i<%ȸڦhD̩XS-<AH~i:,ȰaTkD\nGb 1!.X:`RL.\0kr H[-SL\$0VH\\ykOIn\0*BV.DXH#X[BLk0N0c&!J5G詰< - 0	S8#!	Ԉ3\$	HH3`NU0p {xr?PATOnr*[%dKadJIV\$yį[DC#	BXTE2\0004\0ua?C-ŅRN\0NLb±,-U8}Cčhf@|	jxx%D||R.[k6Dʀ*'\0de(");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0\0Dbc!Q7Шd8~N)Eг`Ns`S)O/<x9o3n2!r:;+9CȨ\n<`b\\?`4\r#`<BeB#N \r.D`j4par㢺>8\$c1cc{n7ANRLi\r1!(j´+62X8+.\r!xh'6S\0RO\n1(W07q:NE:68n+մ5_(s\r/m6P@EQ9\nV-\".:J8weq|؇X]Y XezW 7Z1hQfuj4Z{p\\AUJ<k@ɍ@}&L7UwuYh2@u P7Ah3ÛXEͅZ]l@Mplv) HWy>Y-Y/hC[*F#~!`\r#0PC˝f\\^%B<\\fޱ&/OL\\jFjZ1\\:ƴ>NXaFAfh{\"s\n64?8^p\"띰ȸ\\e(PNq[gr&}PhW*r_sPh\nom#.\0@pdW \$ҺQ۽Tl0 HdH)ۏ)PHgUBe\rt:\0)\"t,[(DO\nR8!Ƭ֚lAV4hSq<@}gK]]=90'wA<a~WD|A2XU2yŊ=p)\0P	sn3rf\0FvGI@%+_I`\r.NKI[ʖSJaUfSzM%\"Q|9Bcaq\08#<a:z1Uf>Zle5#U@iUGn%Ұs;gxLpP?BQ\\b龒Q=7:ݡQ\r:t:y( \nd)\nX;CaA\rPGH!@9\n\nAl~HV\nsիƯbBr3\rP%ф\r}b/Α\$5PC\"wB_UgAt夅^QUjBvh졄4)+)<j^<L4U*Bg*nʖ-	9O\$طzyM3\\9.oE(i7	tߚ-&\nj!\ryyD1g]yR7\"~)TZ0E9MYZtXe!f@{Ȭyl	8;R{8Įe+UL'F18PE5-	_!7[2J;HRǹ8p痲݇@0,ծpsK0\r4\$sJ4DZI'\$cLRMpY&iz3GzҚJ%P-[/xT{pzCv:V'\\KJaM&Ӿ\"eo^Q+h^iT1ORl,5[ݘ\$)jLƁU`S`Z^|r=n登TU	1Hykt+\0vD\r	<ƙjGt*3%kYܲT*|\"ClhE(\r8r{0D_.6и;rBjO'ۜ>\$`^69#4Xmh8:c0;/ԉ;\\'(t'+̷^]Nv#,vOiϖ><SA\\\\!3*tl`u\0p'7P9bs{v{7\"{ra(^Eg/U9g/`\nL\n)(Aa\" 	&P@O\n師0(M&FJ'! 0<H*|*OZm*n/b/.o\0dn)i:RP2m\0/vOXFʳψ\"000bgj\$n0}	@=MƂ0nP/pot.̽g\0)o\n0\rFbio}\n̯	NQ'xFaJL\r\r0'd	oep4Dʐq(~ \rEprQVFHlKjN&j!H`_bh\r1n!Ɏz\\\r`V_k\"\\ׂ'V\0ʾ`ACV`\r%\rk@NB횙 !\n\0Z6\$d,%%laH\n#S\$!\$@2I\$r{!J2HZM\\hb,'||cj~gr`ļ\$+A1E <L\$Y%-FDdL焳\n@bVf;2_(Lп<%@ڜ,\"dNer\0`Z4'ld9-#`Ŗj6ƣvN͐f@܆&B\$(Z&278I P\rk\\2`\rdLb@E2`P( B'0&{:dB1^؉*\r\0c<K|5sZ`O35=@5C>@W*	=\0N<g6s67Sm7u?	{<&L.3~D\rŚx),rin/O\0o{0k]3>m1\0I@9T34+ԙ@eGFMC\rE3Etm!#1D @H(n <g,V`R]@3Cr7s~GIi@\0v5\rV'P\r\$<b%(DdPWbfO x\0} lb&vj4LSִԶ5&dsF M4\".HM01uL\"/J`{xǐYu*\"U.I53Q3QJg5s&jьu٭ЪGQMTmGBtl-c*\rZ7*hs/RUVBNˈԊiLk.t龩rYi-S3\\TOM^G>ZQj\"iMsSS\$Ib	fu:SB|iY¦8	v#D4`.^HM_ռuUz`ZJ	e@Cea\"mb6ԯJRT?ԣXMZІpQvjjV{C\r7Tʞ 5{P]\r?QAA2񾠓V)Ji-N99fl Jm;u@<FѠejĦI<+CW@Zl1<2iF7`KG~L&+NYtWH飑w	ls'gq+LzbizŢ.ЊzW zdW(y)vE4,\0\"d\$B{!)1U5bp#}m=@w	P\0\r`O|	ɍYJՂEOu_\n`F`}M.#1f*ա  zuc xf8kZRs2ʂ-Z2+ʷ(sUcDѷX!u&-vPر\0'LX Lo	>Վ\r@P\rxFEȭ%=5N֜?7NÅw`hX98 qzd%6̂t/Ll,KaN~,'ǀM\rf9w!xx[ϑG8;xA-I&5\$D\$%xѬ´]&o-39Lzy6;uzZ 8_ɐx\0D?X7yOY.#38ǀeQ=؀*Gwm Y]YOYF)z#\$e)/z?z;^FZg`^e#?eM3u偃0>\"?@חXv\"*Ԣ\r6v~OV~&ר^gđٞ'f6:-Z~O6;zx;&!+{9Mٳd \r,9Wݭ:\rٜ@睂+]-[gۇ[s[iiqyx+|7{7|w}EWWk|J؁xmq xwyj#e(ߞþ {ڏyM@ɂY(g͚-J(@;y#SYp@%so9;+	;ZNٯº kVu[x|qON?	`u6||Xس|Ox!:ϗY]c\rh9n8'\rS.1USȸX+z]ɵ?C\r\\\$`)U|ˤ|Ѩx'՜<̙e|ͳLMy(ۧlкO]{ѾFD}yuĒ,XL\\x;UWtv\\OxWJ9ȒR5WiMi[Kf(\0dĚ迩\rM7;6KʦI\rxv\rV3ɱ.R|^2^0߾\$Q[Dܣ>1'^X~t1\"6L+AeI~@pM>m<SK-HT76SMfg=GPʰP\r>2Sb\$C[()%Q#G`uGwp\rkKezhjzi(rOT=7~4\"ef~dVZU-b'VJZ7)T8.<RM\$'by\n5_wU`ei޿JbguS?`+ Mg7`\0_-_?F\0X[J8&~D#{P4ܗ\"\0@ғ\0F ?*^wО:u3xK^w߯y[Ԟ(#/zr_g?\0?1wMR&M?StT]ݴG:I)B v1<t6:W{x:=ޚ:!!\0xq&0}z\"]ozjw6JP۞[\\ }`S\0qHM/7BP]FT8S5/I\r\n O0aQ\n>2j;=ڬdA=pVL)X\n¦`e\$TƦQJk7*O .ġ\r\$#pWT>!v|}נ.%,;f*?焘\0pD! #:MRcB/06	7@\0VvghZ\nR\"@F	+ʚEI\n8&2bXPĬͤ=h[+ʉ\r:F\0:*\r}#!\"c;hŦ/0ޒEj]Z\0@iW_h;VRbP%!b]SBUl	r\r-\0\"Q=Ih	 FLFxRэ@\0*j5k\00'	@ElOHCx@\"G41`ϼP(G91\0\"f:Qʍ@`'>7ȎdR41>rIHGt\nRH	bҏ71fh)D8B`(V<Q8c? 2E4j\09\r͐@\0'FD,!H=*E(?Ѫ&xd_HǢE6~uG\0RXZ~P'U=@l+A\nhIiƔPGZ`\$P.;E\0} Q%jAWإ\$!3r1 {Ӊ%i=IfK!e\$80!h#\\HF|i8tl\$lli*(GL	 \$x.q\"Wzs{8d`&W\0&E15jWbćVR-#{\0Xig*7VF3`妏p@#7	0[Ү[éh˖\\o{T]Ŧᑀ8l`f@reh\nW2*@\0`K(L̷\0vT\0c'L: 0@L1T0bhW|\\-DN\ns3\"`Ǣ肒2&\rU+^ReSni0u˚b	J2sps^n<♱Fla\0\0mA2`|؟6	nr\0Dټ7&mߧ-)\\݌\n=;*b蓈Ty7c|o/:tP<Y:K&C'G/@Q*8v/&W6p.\0u3Bq:(eOPp	駲\r0(ac>N|	t\n6v_e;y6fgQ;yβ[S	gǰOuddHH=Z\r'qC*)gEO \"!k('`\nkhT*s5REa\n#!1\0;Siȼ@(lI v\rnj~63ΈI:h\n.2pl9Bt0\$bp+ǀ*tJsJQ8;4P(ҧѶ!.Ppk@)65!(\n+{`=H,Ɂ\\Ѵ4\"[C1-luo4[E%\"w] ( ʏTe)KAE={ \n`;?-G5I.%q%EsgFs	KGn4i/,i0ux)73SzgV[hDp'L<TMjP*o≴\nH\n4M-WNA/@8mHRptpV=h*0	1;\0uGT6@s\0)6ƣT\\(\"U,C:5iKlۧE*\"r.@jRJQ/L@SZP)(jjJL*\0\r-Q*Qڜg9~P@H\n-e\0Qw%^ ET< 2H@޴e\0 e#;ITl+A+C*Yh/D\\!鬚8»3AЙEE/}0tJ|1Qmn%(p!\n±U)\rsEX5u%B- w]*E)<+qyV@mFH BN#]YQ1:V#\$<&Xxt@]GԶj)-@qL\ncIY?qC\rv(@X\0Ov<R3XQJ99lxCuīd vTZkl\rJ\\o&?o6Eq\r'3ɪJ6'Y@6FZ50VTyC`\0VS!&66rDf`ꛨJvqzF@ݵ҅Z.\$kXkJ\\\"\"֝i:E\roX\0>PPmi]\0aV=I6jK3ZQmEb0:32V4N6!l^ڦ@hhU>:	E>j0g\\|Sh7yބ\$,5aė7&:[WX4q Jׂc8!HVDĎ+D:9,DUa!X\$ЯڋG܌Bt9-+otL}ĭqKx6&%xtR\"πRIWA`c}l6~*0vkp68z+qXw*EIN*qPKFO\0,(|k *YF5;<6@QU\"\rbOAXÎvv)Ho`STpbj1+ŋe ʀQx8@5\\Q,ĉNޘb#YHp1kB8NoX3,#Uک'\"销eeH#zq^rG[:\rmng5V]-(W0~kh\\Z`lk ojW!.hF[tAweM૫3!nK_SFj-S[r̀w0^hf-?X5/IY V7ad 8bqbn\n1YRvT,+!NT2I߷K`K\"O)\nY4!}K^D@na\$@ \$Aj\\D[=	bHpSOAGho!F@lU`Xn\$\\͈_˘`HB]2\"z0i1\\w.fy޻K) p0XS>1	*,]\r\"<cQ\$tq.	<+t,]L!{gX\$6v %GHEX*0ۊ)qnC)I\"툳`KF@d5Ap{\\pɾNr'S(+5Њ+\"ĀU0iː!nMbrK6úr|a@x|ka9WR4\"?5pۓkrĘߒ7Hp5YpWG#rʶAWD+`=\"}@H\\pЀߋ)C3!sO:)_F/\r4<A\nn/T3f7P16OYлϲq;؁aXtS<9nwsx@1Ξxs?3Ş@54oȃ0pR\0yqL&S^:Q>\\4OInZnv33+PL(.x\$«CCnAkc:L6rwhnrZ==jђ6}MGu~3bg4s6sQ#:3g~v3<+<a}ϧ=e8'n)ӞcCz4L=h{iJ^~wgDjL^=6ΧNӔ\\DNE?h:S*>+uhh҅WE1jxt't[wS9T[,jvtA#T枂9jK-ޠYiQe?4Ӟ_Wz@JkWYhpuj|z4	im	O5\0>|9ז轠gVyu=}gs_Vsծ{k@r^(wH'a=iN4_{6tϨϗe[h-Ul?J0O\0^Hl\0.Zxu\"<	/7 i:\nǠ;!3_0`\0H`2\0H#h[P<עgm@~(\0ߵkYv#>\nz\n@Q\n(G\n'k5n5ۨ@_`Ї_l1wpPw\0coEl{ݾ7o0Ibϝnz﷛ {8w=|/y3a߼#xq@ka!\08dmR[wvǋRGp8v\$Zmtǽuop`2m|;#xmn~;VE3O\r,~ow[N} clyO;?~^j\"Wz:'xW.	u(Ýq<gvhWq\\;ߟ8)M\\5vڷx=hib-|bpyDЕHh\rcey7pxG@D= 1!4Ra\r9!\0'Y@>iS>oofsO 9.\"Fl20E!QːD9dBW4\0y`RoF>Fa00	2<IP'\\I\0\$\n RaU.sЄ\"1ІeY砢Zq1|#G!PP\0|HFnp>W:`YP%ď\na8P>`]4`<r\0Îz484`mh:ΪHDj+p>*8ՠ08A:с]wúz>9\n+:iiPoG01)ZږneR֖gMgsLCr8Ѐ!3R)00sIJVPpK\n|9e[ˑD0z4ϑo,N8ns#{蓷z3>BS\";e5VD0[\$7z0=8	T 3Q'RnLyŋ'\0o,\0:[}(|X>xvqW?tBE1wG;!݋5΀|0JI@#uņI\\p8!']߮l-lSB,ӗ]1ԕHN8%%	/;FGSh\\لct2|W\$t<hO+#BaN1{yw2\\Z&)db',Xxm~H@:d	>=-lK܏J\0́@rϥ@\"(AZ7h>\\#>\0XrYYxŝq=:Թ\rlomgbD_TxC0.yR]_ZǻWIG	Mɪ(|@\0SOs {@k}FXSb8=_l\0=g{HyG s_J\$hkFqd4ω'>vϏ!_7Vq@1zuSejKdyuS.2\"{K?s˦hRd`:yGھ\nQow'hS>LX}eG@9퟈W|Ϲ@_uZ=,!}\0I@#\"'Y`\\?p,Gל_'G	T#oH\r\"o}?O鼔7|'=8MQyaH?߮ \0bUd67I O\"-2_0\r?hO׿t\0\0002~° 4K,oh	Pcz`@\"H; ,='S.bSCc욌R,~X@ '8Z0&(np<pȣ32(.@R3@^\r+@,\$	ϟEtB,⪀ʰh\r><6]#;C.Ҏ8P3;@L,+>p(#-f1z,8ߠƐP:9R۳)e\0ڢR!\nr{eGA@*nD6N\rR8QK0颽>PNIQ=r<;&fNGJ;UAAP&`);!s\0pp\rn(@%&	SdYuC,8O#oRv,#|7\"CpB`jX3~R@v9B#@\n0>T-5/= E\nd\"!;p*nZ\08/jX\r>F	Pϐe>OLO0\0)k㦃[	ϳ'L	1 1\0C1T`RʐzĚp< .>5\0> Bnˊ<\"he>кîs!H{ܐ!\r\r\"|>R1d\"U@D63>o\rvL:K2+0쾁>\0 B{!r*Hy;`8\0دd\r02A?+\0Å\0AwSl\r[ԡ6co=0z/J+ꆌW[~C0e30HQPDPY}4#YDp)	|@&-/F	T	aH5#H.A>0;.Yġ	*D2=3	pBnuDw\n!zCQ \0HQ4D*7\0J%ıpuD(O=!>u,71TM+31:\"PRQ?P+11= M\$ZlT7,Nq%E!S2&U*>GDS&ozh8881\\:Z0hT C+#ʱA%D!\0XDA3\0!\\#h9bT!dYj2S\nA+ͽHwD`(AB*+%EX.ˠB#ȿ&XeEo\"|r8W2@8Da|NhJ8[۳Wz{Z\"L\0\0Ȇ8x۶X@ Eh;af1;nhZ3E0| 옑AtB,~W8^Ǡ׃<2/	8+۔O+%P#ή\n?߉?e˔O\\]7(#D۾(!c)NMFE#DXg)0A\0:rB``  QH>!\rB\0V%ceHFHm2B2I`#D>n\n:L9C0\0x(ޏ(\nL\"G\n@`[\ni'\0)y)&(p\0N	\"N:8.\r!'4|ל~ʀ\"cDlt0c5kQQר+ZGk!Fc4Rx@&>z=\$(?(\n쀨>	ҵCqیt-}G,tGW xqHfb\0\0zT9zwЅDmn'ccbH\0z3! HHz׀Iy\",-\0\"<2'#H`d-#cljĞ`i(_dgȎǂ*j\r\0> 662kj<Cq9ĐI\r\$CAI\$x\rH78 ܀ZpZrR_U\0l\rIRXi\0<r~xS%^%j@^T33ɀGHz&\$(q\0f&8+\rɗ%2hCxIlbɀ(hSY&B`fxvn.L+/\"=I0d\$47rA(42gJ(D=F(-'ĠXG29Z=,r`);x\"8;>&',@2pl:0lI\rrJDhAz22p`O2h8HĄwtBFg`72{,Kl߰%C%om+X41򹸎\n2p	ZB!=VܨȀ+H6*\0k%< K',3rI;8\0Z+Eܭ`+lW+Yҵ-tfbQ_-Ӏޅ+ 95LjJ.Gʩ,\\ԅ.\$2J\\-1-cˇ.lfxBqK,dˀ8AKo-3Kr/|/\\r,HϤ!Y10@.&|+J\00P3J-ZQ	\r&\nL*jĉ|#Ծ\"˺A/8)1#7\$\"6\n>\n7L1h9\0BZd#b:\0+A22'̕\nt̜O2lʳ.LHC\02+L\\rKk+˳.ꌒ;(Dƀ1sds9P4쌜@.AnhJ13K03J\$\02Lk3Q;3n\0\0,sI@u/VA1UM<Le4D2V% Ap\nȬ235A-Tu53۹1+fL~\n	-> ҡM4XLSdٲ͟*\\@ͨYkSDM5 XfDsUs%	̱p+K6/ݒ8Xނ=K6pH%3ͫ7lIK0LDu`P\rSO͙&(;L@ψN>S28(`JErF	2SEMM\$qE\$ã/I\$\\ID\"\n䱺w.tS	ђP#\nW-\0Cҵ:jR^S8;d`5ԪaʖE+(XrM;3;B,*1&2XS)< L9;RSNgIs+ӰK<sLY-Z:A<OO*2vW7+|˻<T9hy\$<#ρ;v\$O\0 ,Hk-Ϛ\rϣ;O>7>3@O{.4pO?Tb..~O4S>1SS*4Pȣ>3\0W>2><P?4@t\nNAxp%=P@C@R˟?x\n0NwO?TJC@#	.dMt&=\\4A:L\$N:\rI'Arግ;\r/CBӮi>L7:9|C\$)z@tl:>C\nBi0G,\0FD%p)o\0\n>`)QZIKG%M\0#\0DQ.H'\$E\n \$ܐ%4ID3o:L\$m 0	B\\(8通hDCsDX4TK{x`\n,\nE:p\n'>o\0tI` -\0D/KP`/H\$\n=>UFP0UG}4B\$?E%TWD} *H0T\0t\"!o\0E7R.tfRFu!ԐD\n\0F-4VQH%40uN\0DQRuE	)I\n&Qm)ǚm #\\D(\$̓x4WFM&ԜR5H%q[F+IF \nTR3DLoy4TQ/E[ў<t^F)Q+4QI#IF'TiѪX!ѱF*nR>5pKm+sIRE+ԩM\0(R?+HҀJ\"TD\$	4wQ}Tz\0G8|xR6R	4XR6\n4ymNQNM&RH&2Q/7#қ{'ҍ,|\n	.\0>{o#1D;?UҕJ9*jFNщJ #~%-?CL3@EP{`>QȔ%O)4R%I@%,\"I<\$ԉTP>\n\0QP5DkOFTY<oQ=T\0x	5D,0?i?x  mE}>|[\0&RLHS9GI1䀖M4VHoT-S)QGF [TQRjN#x]N(U8\nuU\n?5,TmԞ??@U\nu-R9U/S \nU3IEStQYJu.QFo\$&i	KPC6>5G\0uRu)U'R0ЀDuIUJ@	:V8*Rf%&\\RMU9RfUAU[TUQSe[\0KeZUaUhmS<,Rs`&Tj@G!\\x^0>\0&p΂QQ)TUPs@%\0W	`\$(1Q?\$CQp\nOJX#V7Xu;!YBSc+V#MUWHURǅU-+VmY}\\OKM\$SeToVHT!!<{RZA5R!=3U({@*Ratz\0)QP5H؏հN5+P[9V%\"\nGSL9l\rVؤ[ouUIYR_TYp5O֧\\q`U[Bu'Uw\\mRUԭ\\Es5K\\V\\S{AZ%O\$F>5EWVm`Wd]& \$Ό!RZ}ԅ]}v5ZUgQ^y` !^=FR^vUKex@+r5#@?=uΓsץYNsS!^c5\$.u`\0XE~19JUZ@#1_[4J2\n\$VI4n\0?4aR!U~)&B>tRI0_EkTUS|Uk_8&E(‘?@J5JUBQT}HVjQx\neVsU=VN4ղؗ\\xR34GD\":	KQ>[\rY_#!#][j<6خX	c#KL}>`'\05XcU[\0(Wt|tR]p/]H2IQO1SQjZHm)d^SXCY\rtu@Jp%M?UQ\n=Rar:ԿE-G\0\$d]meh*QWtc`AY=S\r	m-=MwH]J\"䴏f\"{#9TeMcNIDU6g2ݝeaLQ&&uTX51Y>S֊Q#Ij\0WP?ub5FULn)V5R@\$!%oP'EUP-Bp\nF\$S4tUF|{qȓ0Umjs\$ڛjcڐ֫aZI5Xj26&>v\n\r)2_kGTJeQ-cZVMֽz>]acc`tHj6+kM\0>##3l='^6\0èvZ9Se\"bΡB>)/T=9\0`P\$\0]/0ڪ䵏k-6{k[F\r|SѿJMQD=/WXVa'atol冶Xj}C@\"KPom3\0#HVv~{?gx	n|[?U[rhG`3#Gk%L\0I`CD	 \"\0ŧ#cN6ڹfzێ;ѤeeF7/N\r:QG9	\$Iռ]TWGsdWMIfBcۤ!#cnu&(S_wSf&TZ:0CSLN`ܳYj=>ŲZ!=rV]g	ӣrXl-.U'uJuJ\0sJ'W%\\>?BVj4J}I/-ҝrRLS3\0,RgqӭTf>1\0_\\V8Ztc耆<^\\llj\0T]CwΓzIZwNpVWjvY>2	o\$|UWL%{toX3_RJ5~6\"Zl}`kceR=^UԎ1ѽw7edvb=\0f,m)Gp-Ӽ)9L>| \"@5`:\0,t@xlJb6aA\0ػAR[A0\$qoAS@<@y\"as.V^讥^\0H[H@bK)z\r=^zB\0No<̇t<x\0ڬ0*RI{^E:{KՐ1E0Y/c\"\04F7'\n0`UT?MPl4r(	Z|&t\"ILw+m}Wi\r>U__u63y[8T-V}x_~%7{jMo_E~]P\$JCaXG9\0007Ń5A#\0.\r˴_%\n\r#<MxJ|2\0;o^a+F笀Lk;_#M\\pr@õOR~zANEYO	(1N׉R8Cn?O)1ADo\0\rǢ?kJ\",OFa-b6]PS)ƙ5xC=@jLL:\"胻Ίl#Bk@N:>|B9	:N\$S CB:j6ΉJkuK_W͢ØI=@Tv\n0^o\\Ӡ?/&u._\rC+c~Jb6e\0yѡ\0wxh8j%SVH@N'\\ۯN`n\runKqUB+f>G\r=@Gd\n)FO hʷÈfCɅX|I]3auyUi^9y\no^rt\r8͇#N	VY;c*%V<#h9r\rxcv(\ra(xja`g0V̼Qx(glհ{gh`sW<Kj';)Gnq\$p+Ɍ_d^& Dx!bv!EjPV'(=b\r\"bL\0bt\n>J1;ۈ4^sQp`fr`7xE<l	8s'PTֺ˃z_T[>:`1.;7@[>6!*\$`\0`,@?m>>\0LCǸRn/+`;C\0*<F+q M;1K\n:b3j1l:c>Yhގ#;3ֺ85:\\\0XHaM1\\L[YCvN\0+\0t#\$!@*l	FdhdF&Ƙf)=04x\0004ED6K䢣\0nN];q4sj-=-8\0sǨDf5p4J^'Ӕ[H^NR FKwz EgF|!codbx\0-6,E_3up /wz(exRaHYce59d\00@2@ҐYfeyYcMוh[ez\rv\\0e\\cʃ[ueNY`ۖ]9h姗~^Yqe]qe_|6!u`fJ{7M{YهjeCS6\0DuasFL}\$ȇ(MbƤ,0Buίт2gxFљ{an:i\rPjerrGBYM+qiYd˙`0,>6fo0o Xf\0VL!fl6 /1e\0>kbf\r!uf<%(r˛a&	Y!mBg=@\r; \r5phI9bm\$BYˋgx#@QEOm90\"!tˉЇO* \0>%\$orN&s9f4g~jMfwygy\\`X1y5x^z_,& k|1xA6 \no蔻&xgg{r?緛-|t3}gHgK9J<CC197gh6!0HcdyfDA;9T0\0p! 6^.S²?E(PΈ .5hEPJv.+\$5>P+?~g6\rhpz(W`\"y:FadŬ6:fi\0A;e^wf >y`-\r\0hr\rr8i\"_	9CIfXˈ2\"ŢhL~\"%V:!%xyizygvx]}qgZi|`+ _g٣譞6PAʀ\$=9h|p!.!i^iˢ8zVCZ\"(9U)!DgU\0j?`4LTo@BNa{r:\n̟E8æ&=E*Z:\n?g̊h.N5(Shi2*cf@7z\"|rP.ǀL8T'k:(q2&ED2~ر9v8@^X=X`qZQ֮`9j5^@竸nqv3(I6jdT\\ 3,hk3(3PuV|\0阮Uk;JQ.	:J\r1nBI\r\0ɬh@?N\nsh\";r~7O\$(5R	ʽjFYFܔ~x޾f\"vۓo˨º#aP<h-3麝/Gxni@\"G?,ZpxX`v4X[I7åXc	!b}j_95qti6fٞ5FƹiѱpX'2r0ƺD,#GU2؏I\rl( 챣=Aa쩳-8dbS4~H;06b{޺Rs3zNބ`ˆ+4<^ay	}ryk&4@?~cE@LS@z^qqN</Hj^sC`sbgGy^\nN\n:GN}c\n +=p1NTB[dЋܹ`noj;jěwhc9p̡[y405͋N+ο`Xda/zn*P#t赸~9W	V~=#n)	2;j:JkC!>x5==2.|'[';v;:SA	&[men˵<6ma=Y.神:g腀;I߻x[IJ\0~zaYwT\\`V\n~P)zJQ@[{rʉDBv|i-EK;^n{:Nh;2ƀpѴ6罘99XhQ~iA@D j}ozLVѳ~	8B?#F}FTdezcFg7Η 6#.E££S.J35KɥJ;n5:ySCvoս.{	d\\0?W\0!)'Eg;+\0YNtbp+c\0B=\"cT:BcPIDV0!ROlON~aF|%ߺ)O	WoQw:ٟl0h@:օ8Q&[nFp,æ@JTw9(<{ƐO\r	ڂ\$m/HnP\$o^U\"{Ė<.nq8\r\0;n硟+޳3n{D\$7,Ez7\0l!{8x҂.s8PAFxrQۮ1̅p+@d9OP5lK/\\msqvQ/	!z7oEǆ:qV5?GHOO\$l+,\r;~Ač錳{`7|Ăr'Ji\rc+|#+<&қ<W,>^P&nJhe%dCizXA'D>ΈEk@Bw(.\n99AhNckNd`p`%2\0");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$p=file_open_lock(get_temp_dir()."/adminer.version");if($p)file_write_unlock($p,serialize(array("version"=>$_POST["version"])));exit;}global$b,$f,$k,$Pb,$Wb,$gc,$l,$Mc,$Tc,$ba,$ld,$w,$ca,$Cd,$ye,$ff,$ug,$Yc,$T,$ch,$ih,$ph,$ga;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Ue=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Ue[]=true;call_user_func_array('session_set_cookie_params',$Ue);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$Ac);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$Cd=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lv'=>'Latviešu','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ca;return$ca;}function
lang($t,$pe=null){if(is_string($t)){$if=array_search($t,get_translations("en"));if($if!==false)$t=$if;}global$ca,$ch;$bh=($ch[$t]?$ch[$t]:$t);if(is_array($bh)){$if=($pe==1?0:($ca=='cs'||$ca=='sk'?($pe&&$pe<5?1:2):($ca=='fr'?(!$pe?0:1):($ca=='pl'?($pe%10>1&&$pe%10<5&&$pe/10%10!=1?1:2):($ca=='sl'?($pe%100==1?0:($pe%100==2?1:($pe%100==3||$pe%100==4?2:3))):($ca=='lt'?($pe%10==1&&$pe%100!=11?0:($pe%10>1&&$pe/10%10!=1?1:2)):($ca=='bs'||$ca=='ru'||$ca=='sr'||$ca=='uk'?($pe%10==1&&$pe%100!=11?0:($pe%10>1&&$pe%10<5&&$pe/10%10!=1?1:2)):1)))))));$bh=$bh[$if];}$va=func_get_args();array_shift($va);$Ic=str_replace("%d","%s",$bh);if($Ic!=$bh)$va[0]=format_number($pe);return
vsprintf($Ic,$va);}function
switch_lang(){global$ca,$Cd;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$Cd,$ca,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$ca="en";if(isset($Cd[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ca=$_COOKIE["adminer_lang"];}elseif(isset($Cd[$_SESSION["lang"]]))$ca=$_SESSION["lang"];else{$la=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$C,PREG_SET_ORDER);foreach($C
as$B)$la[$B[1]]=(isset($B[3])?$B[3]:1);arsort($la);foreach($la
as$x=>$H){if(isset($Cd[$x])){$ca=$x;break;}$x=preg_replace('~-.*~','',$x);if(!isset($la[$x])&&isset($Cd[$x])){$ca=$x;break;}}}$ch=$_SESSION["translations"];if($_SESSION["translations_version"]!=2880760138){$ch=array();$_SESSION["translations_version"]=2880760138;}function
get_translations($Bd){switch($Bd){case"en":$e="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3Q/ӗJ6g2qs_foE2<B6k@ZΦ#ƤnEcЂ>`@\$cB3:x߻8xJ\0|63,bׇx481Dc:CΎA&2,.(N'N78c!ˣC4?%!<HKKS\nM7{*#OD\rKa15R7C\rBӊrè0\r-} :3+),#{PC94/&L.8nRZ\n\0㥮 ؍}[ncP(]T\0CM;NXZ|[2NS\0ވ@\"@)3E(<OkK\"C,0\\\"X-}Y~,r){㨸84E\n%Cr˥z:PA,873B7B\rA XGC3ċ;WCJB<-]0@؎mb*[D)fލ?ua!03V[Ef-sMZс=7QlkEK:o\"vr4R:2ciBTN2;\$*xt\\[1j;Ejg\$ĜKVIe-zWpo\$&`xSU0ru(\0'PwԨӍdtp/I. P*B\"jH3	u 9d~Q\"2уMa#\r[{y\"B'H\nŌA@\$'ʓ3[}\r4KJAVg|Z8u/EHBS\nAFA5\"%I+%5B|SмP@(t>ZՃaFA!A\0A>Oq6p32``4z;*87h9thTaAL-\0ȚF>n*\\3٭\rJe:]\n1HGy!\$ao5I\n*rq#HS67L!CJ%q2'@BD!P\"J E	)BN=J0NR]Ը&%+Hʖji#\"mW2,5\0t	ƇCgv`\"l(+('0S.!|p:˸P%bY~\"F,-	RVI]Q*N;p%^S:|B%a))ZBӨV\r)F^xb8rH^ڨ#*^Srp@ QGC)e\nd<].U`%S9eQ\"	P̒6El@BH([2|\rS]yTAwSD`l{K𖊝/p\\p~Qe?\rpA03bDX\nu2CXc]>B\rdh\0S8ŭ*(M\0#ĢH/m.=C%EE\n1fM\nK\nsPFC;%&C	f+CY(CǔQEt[BI&,U㲸NEc%uWbZIM>~{m-XJV^cքWZ.YiUv U):eZY/sPKl]UچU5<*EMMh\"5wOM;aa^Xu(UkN]|vH\r:om~M	׺s0CVI2&gÍq+!J?\"\n>S5κ\n/k\n9 ܿk\rWGkX		@0'ĺigQq22UzM1[\":ܾ64^V?ЮFMwJut󝂚,!Cne!TU٦n{ќa(IcXߖ::hU\nc}g3zv((2leYO!e	NdJI4[76?[hJ>?3{ްAFD7y@obv?rl`-+.f\$0tN/ʷ\0K\nkK<l`7<0p?/*	[#~@C/%d<CB\rbL\"dg00cpBPHr#\"-0PBlЈOܰP2M\0e\r \rn\$m#P@/.Ґr\nZ59ODʾ%:LBm:!H&iC0/L	\rFPj/0R))r.cA\rgzJ)Ʊ@\\:1@* \nF'!Ղ%\nJJ@5K=^~t^Q#bAwQ`'иkpŰ~т9`@	Z *lf*^ƴ\n-'oKZ|jM%gʟ<\$%>QB<-HI)=,Z?M\"6~ve(N!'";break;case"ar":$e="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\r㒞B+\\cY*+\"	)\"XؐeJT*IPFt\"et~&M# @\07M0:#m1C38CҎKz˭L9H4C(C@:t2tA#8^2x9ΣJ`|6-+3A#kt4px!򞐖&m?2XnjP<+!u11ڂHn\"@P0CtƎcx<@6\r#7ۃ\",2E?]?ijW(:\\kAX!)tU%#P?#,:&\$\"++%\rjlkR<J#X1ZjY<=l<HƖKk/#ach50к@d(@)\"bԇYndFVfy!k]ǛMqhOg PSR\rԛ'0;5\rˈ`<Jpv^t;:g(ucFü2\nd\$Rluk`!XQ|,pL\n7xjg9x(ݍ7{ٝǌLv~qaQh1C3#5L)HM!2NVE`\n	!Óy`1ȥibA̙C=kԚZk͊Koٹ#NCcpAVCV\"_K`)r	r~c`FqU.d\0G#0R:'gL=TP%ErRjT2(	!8Zy7j0kTI`8 eLCptU)RR~\rA hL h4ztA\0b4T9*@!׀aх,p saoM#aCH- lĆd+!T#䔆¶dGm\\\r\"gm6݁|ʉTALK	\r\r:E1aHΠM<:Ih) 6J%(R!NN\nS--5H^ilV(S8ۉ8&lhV\n:lBP)G>G,AE6G:OLI&})ڔ٧X 6Jm5̗\$͍;!NxS\n,lɌk|aO ِRjG!>-l&w<Pt\0=w6S,]\0k)L*KVc8ЪnNCi>1PxNT(@-A\"zGon'EQhS}BؠlPv_V<Ip#:P1K#P[W-TxMIC\$XV2-U ܯ&McCcO(Co?|42}oE\"l.!	i* [wrD<Hmȋhد؆Lwad()WT)S_C*d@f ָ[Ecb\rH-[aXsP\rtDd+NvX9J^.waۗcZIWMA6B&atd[hp@QH%S3:2YzV@u!Aa VtRJ`9iFd@!<(ۍGݩ,̷\\(JOxVP5B*nuaH*.Xɗ!cEPܽȎ\$\\[<`B\"5%N/h>r}BfRzXA܎\"j7It	01PBWPM؞۞%~Hq&\"Y>Xlqp(P C÷(bb\"+ik!'͠Nfr(+NJ-_ז:Asؖqr:\$j=wI_54~MilTD:\n`?E<C`EW8CLBǮִt\\&_p\$6\0P&7\0,XȬxhk4hbBlF}ȠȌvnzW/SnrXtÐlnPttD{\"mbcOVV\\k,1f)hhHK8B\"<ЈB\r\rVvC01lĝPDfR֣ª/P/e0of~\$%k11gh?&&Ԝb5f2?+E\"ja/L?/F!PhGC٣v4p-XY!lA\nk0P=тzpQQ\"qwQYϦXb&\rhBf9X((f6҅hܰ3\n#G5\$(h0\"p x	%gϾ;u+\\bDb'#\"r&(%2<'P)JAm,1!&Dޣ,G*0Bm&w\$κNvF\0#'в:d`{P#:T\nvd:N\rJd>\"r\".O:%01`@e\r \rg@́(@Mfˀ\n*K	d\npx\rl=o䌪{p \0h:^c\$n`c3-9Sn%WR_ C-n\0EAL>(gbf	8BL8Lbh(R6}fb^8̢WXC\r,13DI()Ƌ\n,6cD4\"Eă\$ClcdL+-Bdlo/D>vDԷ\$[OU/\"hXݦy;lkJ}1JAr1dgA(`\nļ\r\0wvC&ƂC'gB+C'ʕq`LLs\0p5cw/h*2#Â?_\0	\0t	@\n`";break;case"bg":$e="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9.(+z>PKƁ>B\"vi>H%(Ypܚ\$*Z@*pBb6#tPx9莎1c300c(@;#7@8P`@O@2D49Ax^;p1̱@]x7IRxDlWCL4V6H7x.1ےГ8S)K;+\"%Ixږ˳{pHKr<Y-b+#=8!\074߀ȆKJ&+h4!JxܥWQ##䃶eX5iphh(JrA%V䖎76tZ%hE0Fvhذ9j+@\"M*6{b䗪r/R>ؿ7*K\\\"⛥\$ZwSx)\"bKn֏ݳW\"c(!rg_j婌|kxQӦB28OV8@73B(\r3`;#HA\r--4ģf'3lH-2MP`I_et	^NxA!;A(bÒ'\rtAW	S`eYcqMS2yD@3@{.\"nrY#L2Ժg\r \n\r92.O3e\$B\\Pji(\$غO^pƦ\"0`0nL9xr\r!PXsA6>WCczff\r)ghrHQ&*)Ӓ|ȡw48#((<%cň2KG]~4M'&1	jQyMeIwr+	N%A[Ɂi.џƽs4-\0s0K8`oRH;) Ko&\nGPDr\"7'\$fI45 l.ReM>UTU\\PehØ>AXSJ˅.Y8,͉\0bɛ]efs\0\07r[FזWѷ*tܫBN(\"a \"f9TC0u\rtʡHhaUcr3}iVj˯b\"xKM2TA@\$0eѶ\nK+,ZB|uH'AaR\rF\"Ó4;:\nT,1+\r|J\r`\\&#jrN*9%*ZxBW;ncQAmE6`?P--}OCi#Ա&	Q)h[2u[e!ԩ5gJֆ,=Z707M^рt[eg\$sf4+v^CI	Q9V֣ZЗVt+>6<`Tg_&e-[e.8zS~՟D:]Np uO9ǁ*Z	\n)VJKB%ܨIT}A1[#MփgXԸpHMA{`:f*IzeKBCc@O_@)^y\nCN-}sQj*nw1Q9AkSK5%\"i[fJfu	n:,aq̼ע	l,c6ky.φ^w.\0T'Ak-sN')q#--UwCq\\f~zmҢb^2~.ϏvkRK47zꅗIuGW3!mՇpuGvhϺj\$98rY<;GJư\"嶡=Mw^gI9YVe#=Sp2\0˚8dH9G4n:׍gdժ1!P*\0q4zpNIDPrf6:\0^,c.8^,%sl,LnAB3͚CJ/(in+2,8pwk@o@ ꢮ9py0Bku\"'*\0meHP,MEqab^,KD,Vs\"Z|ҨfBf&25	=\r0X;jƢ|.!<.Tdj1\0,-n\nz\rFh*3 Kf4wq,dF>;FJ+r'\$&ģz[*j_䉛.1vjjIn1\\.|	X7nV+#j..GbGmN*=.ϱ;xް1Q1dF5),Z8hfGijOt4E@/dܪe#<A͑%\$HphB!c7!-\0*hh'xOq1R,PM\0R\$InJnQd|Z,*1Qf\\ghAdx.N@'ɲ)+.]P,ֆ/ qRP&?/&P+\0|P4+:\$0La00xד1U1Xo2pbf\\,Tq-n)SV/*rQ6:pwstRSzdJdʍ.>|\r.d~#	_*06_,J7ʾ.3&-9s3:,Fy.)U*3}5Y<>.xdx\\m|/H;r<wٍ	>st訝h	p*ʳe*2]78Sa88ѠTNmm4&eF\"ld=C\$Sf:N4i+sxv{FpH.4 ^-Ԏ%ImJ@n\0003&V:arJ&N8dG53416*5o1T51HRp?O@1DEr//lFvkr	tA\"ws=:T*UPF.?EuCSENb*lem͊IScOLc\\4IP%Hhqz/MOXSCKPpĩ*F4KvJTG@H8qBYu3uFO;\\QuE!ܶC~wYN? \0-1\$FɆ/2!SinUV*RG=\0007!unHV čڗ\\7DfSc]2Pad2th\rV/&0_xB.3vd.\"ē<!\08jjj堪\npHɰ-1hkhL	megwv2uK Brq42RO@BK,2)1<rcRM\nq	: ErH@DwRy*\$`=HtGʤOO\"FL-EwY-5S pFn%\nOVG.c}94j?&\\쳑qn͗bkS{w6&G1zh|:Ix2KzW>T]Dem2c2iyQHP6`\$N\0Sen E!qy=lO6S\"'(b~Axg%AM mk\"~r7d4	~yP~!/XYmhp7s\0ϸR\"0c=Q2vh1^#@\rW\rD74IoUtŨ#";break;case"bn":$e="S!\n\0@xJ_:6\0P\\33`\0!(l	MS,S,\$])d5s@qD<6(R\$i撦VI\nxʙ+\rBb\0!e4M*+Vp@%9;e2S'	`ObM^bS%UPH)x2S)zʞ4\0h3QL<We+lqr'PP~9.-Z!NEy@h0q@p9NƓae90X4\r/0OΛ(%\0QN!Ί6	Т'P\n5*\n`9z;{b껥D5đ;h&\r(%\"(@;sݮ<GC#pΩ0ȭjbVҨ1䖣*[;\09Cx]*5ѪDʳ̜j&0TPe\nP*N*l.C.KRE;(L5^C\"6˳@2\r78PVH1o.\0a@9csmc2\0yk3:x}\r`tp^8\\02\r.\0\r#x}BI5h#&EKti\"eS3+[s^ND\n!Qc{ĲʧDY;;<XhKUUC+#j\$b8/1H1\r(Ȏl7HK5B0qr+6S+G02kCN\\G2j嶙?16:ƶ%0e;#`2h~OojEbS/%\r6D LSLjjKK^<|5MU!7f.lFRs;MS(;ʐ<R\n d®<Fu! Ha\r()R|E]R=`{C!5J˚.ԐUv&ˑ'	SQR\\@O`e%Ɓ\0o\$*`C@YHWJOø!ROЛƠ'ʚ)seW:kdNвhehX[qX`(\"'b`qserr~T~\r8D#x@!#g5碜NBQtK\"T b7܍lv%B1@:!l%f\" JCsn-n(%\0c]@C{mA'9̗q>'vt?1L\"d/h!l \$j8IY&s9ED跡⚎גfS\n]A5m.\\d8R]y/E_5?0eLNChp>r=&*o'1pHpO^''Խ{O+FU_8S 5 \$,@z|z\0zPrbʮ7ZH3:A:]yH\r\\3rp:NeVS%ؽ@@P,J2@-W\\ @\n)Oڎխ8u\"l!hؘnִv c\r4uc!n(B [) CM7T[U	4̑2 ΡRos'*9]Jߛ.n%,+셓ג}_^)0{}\npS-d6ѐį\n1	\$<U[\$LC򻃋k\$3(\"c\0pŹi>衃`!`<)B߁Ǥ]t dȍc{	\\N\\=ٕvjD\0fdM22	O./c 0czϚR@VVm̙-_.0@<>USÄNG/03([(\$dc-0D\nLߴo 4QrpTv#S%+\"]9l;)9{|BqW6qhH[aܜ!ME߄50!tQ#(Np	vFøE#%\\!nYDbԮ28.l7*JsjT헀u#L\nA˗niݜЭFZ#~(nN:N7ͦCUū[x{=;Voc\naRb挿:f8J艎0ˋ'*/ߔ3uvg:PRG[ԆЖ5HQ=cyzXܮI\\\r)Lg;=K*i#BC\r:\"k,\"8ߥx49g9N\rGEDirΞ(# \n`%eY Ye20팚O40ib\\¤o~o\0~p.d\r/9M;b碘0*ȉD\0P00EDhgж.L9O.pcc\n`Qj-Ί>#āB\0Gr5\nP\n20Q*;0v0soqF*YL)9pɎ^	XP \$g;چBj.*&LdFs0Ǌ)	NL*dbb,AGq%E`idhij&z.o\n6pwg3l<.h6pBNn|Hk	GJIlg		\$e:Ė{h.xL̇.m1T2^.qjhqQOrY'(PsϔOR6})C&oT/XW2tybHOq\r+Rry-Xih\$)R'0.Jn:3dq}20	#m6d2NR{2&+RqG 'pP/	s\$KRrw+6EFބ)SH>RS8rl-0:;.53&&fǂC/)T7<`l2Q;+.\\膙.\0/8nT'|71*is@Ӆ-C#0Q7'PghA\rA\rB}BSB#ƛCsf'C.QDR?nT-\rhg4BHhG.'%1DtGHH/p={+T1H̹LNIia.\0\"MqNn\"/.T!8eUJQ>tMk7TJ\0VSHhLH,HTP&kNHzBn \nPO.ĖIdII@%D(423-rgt94.nw-@u?Tt;&YGՔ0C>Et<5YKT\"N<~IS,ճ-ea\\J0QxP4#]3+[ӁZ5u^)]~F5R3]IMrT|Pxúђ46>;zbBbHds1@.CHHvU4XY_+V+YJXԩ.fnUfFeT053pguG)9C]/J6u+6w6fvj%vjGjkMaaT ¶]&a]{>~6VGio֝Y}oS?[_u+\0XWUlW&W+q։[9M_k#cH6eo{uus\$}`oIvvw&_7^wJ~}05AXPp|h}c3<-TN^,%G&|FG\rU@\"qS|.*nt}Uar[HLdGUHxT!ab8\\eAk ҥ~4AGpx`@f\r \rhOG^&\"[nY+@\nZ	\$`߅ļ/x#Q1Ft8ߔpQLLv}9'߂TdsH:!X}whqڔfvNUOl|-	j+{`ڍ\"S4	JF{Jdw+\"\"+&7dv9(	\$[Y0_Ũܬ0\"j@.oDU\"c/;#I'Sk('i+yL3sy|Ltx(Ja|9Nyx9ؖ}eqf7ڰ?#=K͆֜ŀL6!Pیrd&FN\"΢\0z[m^]u&ʧܧ&2e`¯1f?9(3E`!Lj*+Id~QC/\nŞ\riNE`zkT(<o;m*b-c\0WO-)e(Y\\ztn'@ވ>\$bJ;6ӌ.6{LFw	\0t	@\n`";break;case"bs":$e="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乷/6f9>(c[Z4P *053*-R 29({T\$((8+#j((0h@4Lw`@ #C&3:x3Zr3p^8J22\r˘ڏ#x|KCHFCpb9X]0\r1+D78Q%L%u7*;B¸C!8C}wU @1&#fiրԐEPp:F4K7/@:kF+~\"0:-o%B0l;F41CZXj3CL֌&(O!\"S<5#p0/x,@lp84scG4踢&4.Cw%2C kMhL\"B)A:®7pz(@\r\rY?*vqLp%S!O*t\n䯺%CC;\$@PF\0pBFwJtXՌ7n]\\*fCh	!2e6W̳u	BgI#Xt\r+Xr1Ѵ;SgG#VmO\rB\\bHe=%\". )% \0@I)YA[p'd&sJIPL.Je-ԾSeL4^pNNٻTK?4:(\r\rb(2FPeYtBBG޺}!d&)Hk3j6APAGѹʹP!,:6G\0003/\n( IfȾ\nLc28>\\^8l'0b<~H\nMH27#QAS?8'aN;0)0gKFVJ#y/YLR%C\$<VNٔIZC.b*.B\"APa,x\\y=9ҙSdI\$̚L)&h8r6P\0ɇjf?7t،%Xd؛3V\rL2e@TT>G,[+}Ê@=&l<<\\4\rzJ\r2jxPr\\)5?,G0ӷ0Tm,ecp&.+I'F3hv#f\0\0U\n @A l2f	 Xp@(L:Y#gVpI7:קBh\neq͎gddpȥk.trŢml(b.sc͹jt3j)k\ri5DxsŰ7(\rw|:ȀEI2M)\"SE'd@߃Jm)L{`̱Dm9_zP\n0e+3m\nb\0F_\riV*QrRIq=_c~kVdfRAs\$(vt53brjnf4HLJ13QK\n\nK6[Pn\\yiQ=4*QPȎ+|1L\nIrLT\$Eg>dZZ\" &%@N@9[UL\r㬳&ϼ(5]`.dݙ6~W-diTDF͛l%Qr68]l=OK+o7ܻsZmoq-zļSwWb¤RyVLLvH\$%L˛az}ߦC/?3ǹKSD],N4*UjIt:A>H|I3eq1tDܫ}?.'ܷOӦ2Qvy_{m>x.[@r9oAֳtqMExAKtÃ\"p20jV4_E\rzߝ4EIv]DF)g\"IмQsu>__T9ڏzS|eZbuIgk,K'_KmGԂg؏ς\0(խ.AP&,¯0\r)oߥi \n'd(d>\$>JZDOje\"!V3P@Ȕe>X{pE`pksplpT&8ȏ@EPUP0	fpM\$(b<8Bl0>C*PɬBqf@& 2@c18>J\",̠peNT,0/`@2t((,Ԑ0Cq.2@TьfKGSx\">ť̓sͰ/0CQqTB1~>.QoD cC'\\A\rpL1*	\r:BXm\ncJԑͶS]Z5P\$\r?rI%@*Sn4%1F,7O(&RҜ#N\$e6\rVa/b+\$v%\\LPGc\0k\np?fHMF}O\0./O/Ve0\$Pd!de@o V'\r|8+#12nk1a	23ehJ,1NV =0P(T@+ng_,\"ڋ^|98BW)f2s\$ӦM9,XE5:S)ҽ;3D0<#I9J%T1&\"\\kh3pDI2b#'R&JO(os)6Ofk%2^B0dD\0#s~t#\0c:·&-9 Ô(91KAyE9EC:^.D IrȠ3TnB1U";break;case"ca":$e="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]f%3M)pȺh@2:H!0pP:\n0ȍ#Қ1h2e1KV#s:BțFI4+cڢÔ|0cX70@;CI!p; XD49Ax^;́r?%r3^8J2\r:˪|B!^0P2ȣL\"&&\r:M2h 5(S1\"hılKGNp?f͍H1\r(Ȇ\0<\0HKf~7ڽBADg#)\\c o`猣0Gò:Z9H`PDP> OXz^I\r8lS`w۴C0ܣ9aVѠ%-4S1Y (c#(\nbLUՅSRt9J&2:;jPި\n\rk^?2P9#0@719_H>\n& \"!EYuR\\<@S<TꣷyӮ\n2n&\"+CۤRc.b܂8qSQ6S@SFҤ3XpeQ2H{Xk')=ԃ\$Xx[\\oސcm!\0Cr2'c	4 abJmu\"!Da @ɈMB'0k%ļdLɡ5&yN):L9(QJ1Pnz'A2\$nԽI	w.H01PAT\ns0MپDQ(@GbhX*')N0'Q#bûqY~0Fdg2G|H(sT\0H7*G`xHJ,\0A5.?\":aPQ[.`F؁Xj&hRNU1A	d@O1O0UĹu\$i%G'e%G7(I1li\r1	 T Ȥ0M*1I§)d+.e-̢\r+VBP\"EDQ}	Y1vъA`+ъ'9ѳЉkv.9H\$b2=p\0U\n @,\0D0\"d)\"[Kq5R(N	\$jA%'\\0[RB7,\\SCӎrx 1|ʅs^C9}[knnRrA.xnAYVQV%YudbSzUAR+eyQ\\0&G}@s +|H*9U,\$/OaB4p5͢źL!LUDb,48V6d\r64ɬEJ\nf{ 6iND>ꥑCt#SC\$TBjՄ-rXPBH'9CNҪ3l	zIfB̖+AuZKkOH6M\$MU~0V!\0!^%N?RI&*WSi}Qävv֒~V]\$Gt޴\$*nl,]SYdOg\"I	ϱW)PDՇPէ~q\nQ*VMb}>rn1I+.W[Hbq{w}Sz%MI?<aLhVMC.A6N`aH٣KfGu\\mpHb&_>9:dt5=QT0K\r2-HP;fGMDR@\nP0vAbZ\n|Caʉ.ANClxL1cFJ1b[|@\n[d1Kd(=}sEWƈ)Bwė^ߑصN1|j]ǵ\\,^3_~O6+?0u/|n)!	zVJFϴr/\0cK\0 b\n{Tw.0\$8ScL>2k,&9Cؙ KdK&83DS//BϜԫP2DId0p<@*\02OBgf='l`#.hDX\$/nP.ȻlL0Έ͍X4N.,-\$\\%rˌ0ABgΝ(J- '/\0\$Jp181>ihpza\0)56&9ȱY	n>dH]GJΑ.ʌ?P.͘1KQP,A#@kqqAΑ\0Q\r\"b	(@h.jIHGI}N!kD.eԎ8%I#Nr*k2F\"bb\n S@jFD\$'u\n5%&GĘ\np\$z\$q2&G@42Kq*o*xp,x 뚉I	P`=c̲1lqiwL*2^نVpEhcnxJ;1e'Bi.Vԭ?\"3cdV3D<3˄{14y5/z>ѐ^1R| 5 &BR8xES-@C(IC<GRq\nvkfV\\ssebLm	!E)Ph[F8n=j/E. B2س  94\r4&z6k@nc5m`.*	.%]Rdh	\0@	t\n`";break;case"cs":$e="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{53T9(5	(持B#Z-((\"H#z9¤0i.6#tC\"\$ɻ.Vc@5f!\02A\0\rX@2D49Ax^;p0\\x99cR2ɨƎF#2Rix!V+2ۏ! P74>:)c[^x6szCmE3Mӭf\rcռ(p5Ѣ9UL	lkZA2\n49	\rl!\$0C:6]go2:(\nMp7 P#BH1C-71b^k%\"cp޿S#p==32<25\";@HFMBb`ȈCj8,(KcOq*U(2}vŰNsQӍ+{FR#?,	%4\r;gx\rd]FCH5\0 ;ǸBHb(=âsjj\"!C9X1P@*Ch=;I-&\$e*	YLH=`!l\$׍@M0ЅCn#r9\r0S	J3<3dqL:Ȣ:&7F}5*P\nlaH\rJ#n>׊FPxZgⴡ@Wh~g:2C\$^~#GՔ3l6kI \rCND+.CDlA4߬>M AC0\"bN#B)EHqq|B@TCdh;.eISA͕jO:\$A)5xQRM4D\"\$OK1i4%RWK)m.bfM	6\"uN.WRP}ܑ2Ty\$~	;I4i Cqp{zI ;.Xd(0\0@p4h@!(5@\"i2I\"]2֊^ȄoLxa|^IF3H\n\0&g(*\0@ĉ^(m.f<MM#I꒒a\\-l#%2\rd04aaDm0K(Jy\r2 q*a%psWiYJԍ#9'F\$XxDzc uTP mi\$\r|P(	EFJTxBO\naQ[Qד:z)7`éH4,\\P5Ԑ	)'*WGDG\"7@#7bI@0&VOSʶ.i\"CJi !_ZCЬ}A80@Iy]U2QRa:L\$&vi6A8>JUTk++zk֡FI[ק\rɖDacZz9!.uR\ni @h60fN_V@wY!tR\nT0e0ߙOUxȅ&	\"VQ,LP!F<dHRb{˭y<bj\n{ܨ	dS,EnhU`xÊjlcYZ5^~içm|i[`3tRc dDk\"m/4z2H_+2f`,BdQCN5@PA((X\"/dT!\${I6~VqoE=*VUif 5X|+ZQJOǱFl)߁^Xmn\r9^UX]s.+s6ܓ{,SttRەK	U4\rռUbF_9Cȭyen ;r\r>;g=TD	'<R.	4_\nT'uArV ~\n`y;[(O( 5TÄ%%g<QLC'߄`rUtt{YDOdL9\$D2=7h#RHՈ߹_:OO<~/ߐBSS~4K4@ɪTgG7^Dp_EM*-.\nE4H(Jw8gPkh\"pX\rT	_ftlz.Z4[|[ \0P.V\0RB,7 Lt*k\0]0ǐsPеo> bt=Ob\n P0C<\0n^pu|p&۰\0qgb+ڽ;m\0:DH8O\rK0`pݢxf\rgB3[	̫J&bHEX}Š#hF㚛qH:F(n 'c̣|q^+Fa8Vo\0\rQ,ы	\rF1cb1O\nr5O,m>mBܭΓ0=8-1d#I#0KCz:a&rT#-s3W\$d[`\"|,S%|&^^ۋ-\nAE+\$8q(2\0u%\rpTHF9i+0ɍ7`l%-rU`>1/żDMFnW!̆%s\0سPm0 \"r\"r/͈ٲ.r-1wǒ\nr2(2*2sF\rnW\$\$5\" ~:.2+2u\"s˚kCЬ*\08ɗ9nSS#S4s*,%`#*=f@#:a23m\0#sb%>5sy@e(\rV;c7]I,@j*?tRd9f\nZ\n1K%#bStZT^S1yg;&p\\X΍@^j\".)8r/UR,B? [2 #d/D%8\r238<13O(\$l>j\"|D`5nb\$bJy?	XBsе`(R5΂(Wh	5%SQQPSsTC>#(OAS4#CPgEb%Bcӆ?\0\rL줈aBzEPhAP\$\$p((\"\$\$\ntQ(/03/(\" T\\<ZsxRu]\"Kf4ϧ^lHŦ)/*E_LX1`S=)_/jy3/";break;case"da":$e="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX')jR(Vñ&oY̘ BcbȢsBO2\rZ2\r(<-掎\r>1p1?4@:#@8?\0y\r	CC.8a^H\\(γzƃl\r:0\"px!N+0cj2?P5d3HH;ϓҎ|	B\"P0Cr3`P7`74@9?a(TpUe]Lcz>P<j6U(1@i(0cB;-s6p#\"2\rY,S\niӸ483I/xؑ05Ș4,0cF3@PhtKTc%v\n\"`Z5D)>PME/PhK\"\nE-V\$1AOxL\"#ɨPx0j\$>.Kl:9&؊0ꌭ%E]r\"S)R08\n(pϺj7g;)K9؈T*b!-l\$׬\nZSس(3r\0ZVYPRbi=7\\iHyUz/:C,V/?Hڌ(Տ,`DV =6\\.Z@M7TtC#,BN2[a׺GQ} HCBJII'\$+z)M,Ջ!I4s\"6ݸ&>hC9:4ЫdJX<Kh H6)_\$P!RYUb&kYeakzY&mhIˁ~sK4q~r.@\$\0Z!>u@R!ğvf*tFA\"nTn\"h\r!4\"fM	v\nhNC8y_eЄ00-,d\$^JUq>TK	qXFx3@ogLؽD.J|\"\\}Uo	qZP3b^ \$)j7	ѡrĮ9:2(S(L6{ hlՔ%ܝa=,4W gOFKAY#xANSc 0T\nڰTM1K,ZTG9S@\0RA<'\0 A\nЈB`Eg[Yk'iܬڙ0rɪ\r8\n]OQ)Q\"{&M9&މK_2ވaO!YJEtJyS-e`t)|s2G^Yr|yyNQl`L2VnW;QEPHzW*m#\nЛa֮ĥGrZPmCT`	+/ F_Y%a!4aRy:\n3m	|a+ؘ_~<(AQ@^4l< #\n4qX%	H*(YΑ@d(5*PpE3\0P1 YmUnBZ9V9#;ڠC	z`'\$Z K\",.XQB8b &/'Fi^ɐ']ya0gN`%2RiHR=&~T죇*xKW3XIm'fؒ!|6з'4.ȮƬ*reE9CiQ6IF~jqC+p(Qb%uqMfMCxr檲\0X:0*Rֹ\"_%n0()BcȲ\n8be{l*˅ut'X tW[&SP\n-q\$@FUُ%fs\r\nPi^&A'wW],D&tm'fCy&W\r9gr\0BceLώO[u\0_ݸv㱁Kݱqnw}Wqh5cwmAy\\G>|%z<l1bҗ;=;Dx܎N- ,OPnyY{o~^[.,./]AwwRk?fw/6_FV1F?Lzy7_z=74\$@MD\r`aFtNMdĈeOnN\$..\$e4OErBÿLwD bzOO,Lhw{=\"..l\$6~/VNЎOk?o_z>0 ;EԱЄ3C\rE\"{~1b`\$PpEc+0(lF\rDByb&V~S-% .댶V1 .Nd\rV\reF\rlЂdnnJr()og8K\n	d;RNn~jl.(Bjtd#~5>W\"&h~/zؐ;oZ7H=0*%q,͇귉<\nvëa\"0J	|#`Z+Bl-ݥ*Xdb8\r~k>lp݋dc5C)!!q Sb2%Fu!C(d2]\"251CDzBfn@lVLP\r.Ra_W'+\$+@'@Cck>-Xخl:\nFzOq\r<anV\"/@-\n	&c\n>\r#f";break;case"de":$e="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$h0H \r;.,(3(#;C&\r:1J j6#zZ@x:fij7b\n;C@IÄcC#Z-3:t#QC8^E.xDl\r4J@}1mIS:Cz::b;Kԥ%NBp:ǌ摏@Pë`cx<c`8C{2!<HKiZk؝\$H8/x6/0r> P:n䧥\nrɲ>\0#<-:2;cUjĢR(<acss&U#(:\r2Yt`ثރp(hq'(S-1<7E#][WD 5Zr5-XtH-!B@\rq9!*>)0(ķ\$\n7\rrH(B	#l{X(cU06b\" ʎ꣜9Lf-;L:;BKrM`}cЄP2C-0-ö \nR#6#ld3#e x7n7zBr@X	12ec*#mH&W0(bVM E7ЬX߻C{qDt#TM ' BO	9\rVprh&@`9nA\$ypA\nڑ>tCJ^3)p\nSPkt _\"t Z3w6`LA2&g`SZmM@䝈wedqԧ\0Co^&\$Aas%b6kMy<t94ʿ9b\0Bdc)'2'T(BJ`67HoL\n^0B`E%݆cAزIDA:&tȃ+uȲQ\$92\0EGHi	N'K(J\0N|D)1:\n[aN`!*s5U!I-\$Gg/	a=#\$tCA^3A9Rfy`0\0T\r\$Ǻ!(2e;V{ĶBjaTy(O|ٓ <fD&] 2JURY\nr%iU_8f>G[<*rhpgHh,94\0 -_,&JT51l=8[\nl^`G(\$J \$~TXcI`曞ARq4H1F\rx3T'<P(.JѤw	>0a2Cm	bfxdj^\"#\0L\r.A8PTPpR{0Ecn3DrKV˚O\n%@M2a8EHBzd/<'i!S*ALu8I9%vOXPA&u,̼8is)s* #Em:tГ,x5:6`ox\0C\nE\"\0N\\ˡIp>G\$SQ p(;%FMop4MFlO|j?8CB5~oّ`늜YtaE*l\"Xuu)2-5)̏a\rf6KPWUV%w#g&4O8\$*\0qFݜ6#rSVyb\\-bќk|Őha\r𶖭?S@\0)G2<l:qH\$3HGYB\rڑWgbூN*Dy;\0豀׻R|j\$S2fduڕbp4\\ǔ&i!Kq5{a_kx3qU\$_\nISa3Uߨ\"*PPy٪}+ɀ)\rW\"pCTϗp罁(3M\0Gj,eenk|oOb09Oz!9F+d|PHptd;\rmr)0lQ}JGXnT[\$( P	@,.jiς-&tit52Bm{A0'\0%\\M~=`nPPnj^?bf[ \rnh+#\rt6wOo	rOe/\n	U\n#rH@Vw(p#:#`Z\$&5~D\$x\rb0Ȫ#`*z֪ƄkjpR0C+	H~0m`UmD\ncjhÖB\r~eBTp^ȅDk\\'qJ\rF\nQmNP\0q(\r1F\0C,0Lb\"6@ƶ(n+\n/PT۰/qȆ@LEP@O#`>g2-\0#gH\nC\"`a^HW(Q͌G\0O}%Q%TG%%-t'tM(ڑWRjbg(;1r?r ȀD\"Z/m\n|2ʇHH#\"XLFb+(¤L|=h'4ɼxЖ~\0S\0`YRD`0ot\$2H\nZJ|HI,\\P2%;5	N߮'Vk	#Ҩ싊:\$\"73&0D:30i&R:#'EkB\n-ǌExi:XTǯP#.	0<&r\$R!L^##XSO@A\0P?AhlF'C'#\rAWঃ%4ht8dD`uIvܢЂ\0Gxkp8H8qBb^.T:GL|tBmC#,RKB`?I?E2\r]vU82cEC@jrg`޸\0()BgHlbY=84B  ";break;case"el":$e="J=Z &r͜gY{=;	E30\ng\$YH9zXňUJfz2'gakxc7C!(@˥jk9sVz8UYzMI!U>PT-N'DS\nΤTH}k-(KTJח4j0b2as ]`株t0sOjC;3TA]ҺaOr4vOxB-wJ`#k4L[_\"h-2_ɡUk]ôu*\"Mn?O3)\\̮(R\nB\\\nhg6ʣp7kZ~A@ٝL&.WB\"@I1H@&tg:0Z'1vgʃCB5x7(9\rQjA\"╷њO9¦sLJ錆M8l(]43\$%ΊOazᗩF,⸓YnRa,# 4@2\r(K<:[#Yu`5x:#9\04@:ׁ\0ec2\0yb3:xw\rUVLAt3(㝳m\r-V(c#x|5pvg)Qz\$PX/;oD;:d4e\\fSV)B@N꼇8RBg%B9\r>!x@1H1\rxȌ\0<(>ҏBbI4*x(_/bbDi~c!d9`bcP*gb^q[k[`IE씔jw<qm͝V})IufgNElo9%H<P%Cfx7lBf\\V5ԧр(=<L3D2\n-\"&r!.PUq&/ @pvLK\0GUJU\"fUa4Œ*V	|66ʴ^/u\"Ӻ5\n#Sl{R	\0Qq&wTDD:q\0PDfHLnYXCi\rВ=q4Z{D/AĒ+\0+9Q<jP5g:AH;Hg#0;<`tDIJbd- \n	:'g=ynی	!ʳ\"1 Ⱦi!9fhc!aHv3VʮtVp a\0dbY!7\"0z2@D9EmSLTAɦ`Kbs\"Xsm=EbQp#p	sSЯЖK\n5~(_U\"g?BMrQ vkQ*QG 0IAnR#?z.^\nXH2})w\$ϻJvSsS&Iu}DOxu҄MRwd&o.Ĺ2]Kw/\n_+2Ǖ4)V<bH\"K)Rܦb\\\\-)0i\nJ!ݑCUUhX8BIZkLev5P9jW#J@гUф>we	As,@cs``=g-\0.74~5G6-Oѕ)(ё	bO\$ pfFR(+,@\$\0@\n)%hH스),8ݹownb5`Z,7M;`uY%(\$CFE|04[nR'B;ƕR)MY\"\\(C-><q!DpddXܻPJRx=q*ѹ-rd1wP=DV5 @Y35\$S֝-(L\\#ϋbf.SRKBO\naR-:`TL7YFԕ#TP,1J'.O@rhhGUHS_p-><' #L]ZQUֈuƺx͕D&|=A7É\$E H\".\$NВ\$p%	!/긑pHP'5u	@ \$l`f7n3㜞-3'iQFW؅zV٠婕}Z1⹬͖vA.>]J{.~]q!\$[DQy>y+|\\CE7B2{̕u}nΎ2	:,'E,IeBGv\$98Ʃϯn|mɧ,OAg؇pHViDIJ|;+r(f~J'2ӯ>p~)3gHgDPpMnCB('g#,\$,<c2j/mܥ-\$;MB<\"~bdMCvp7G<\ndtdSs\nn*)@* TZznid맘 怓Dph<xNQȺptf>@\n 	\0@ L@VEEjVrWíĔ.Ɩ\"CI\$l@A*(lb)}Kb4^%HJ @(O7LBBs|я#WbbW#b\0000V}H(jz<	gjPo	%mYJBc\$+ Ҷr{!)Hm:qPQ*K\rlcOB~/0THb떡%\\4.&+&n(Obt; NN\\)R=Ҥh\$`\0#Ϝ)j-+VFBGm4q\"*F|VƉ\"+puvoJr*M.k/(3ȰOq2g\0	,	2|)+	-Ɛp0 i*jir4\"&P&ѳ53VrSZI\$7c(\"@zY4[U83v=\r6cs>Ӟ;D6?:N>()Iч#R'.@瀑tp`lN%c?g;@H5GsJƂT4]:KA:`.MH8\0nT`P%,S<'/.SHoY5ȷF445kG;ov84!~):/(;},,8Z=!\rc?*GY!gT4GK!y2Sd񲹢0A_F\$4]F(J.tFQ	Pgk?ICwO'P\";N];Iԍ8+}\r08!U#pv)&gKKBQUƭ;34<!̦K~Bk<214#D%UFVmb\$*O&9&:R#5O2Ou?PbsCH\$MpFewVzO0;RBЀDT3TӖ6cB|Q8gQ4bnf4_HGHb3v\rbfOB|~\$Q+93i \"]etaca3fL)ef4dASj/{VqhbmAc\$iaj05k'1*nb5Z%D>.n=ցLrG9s?JcMVe5iFΊPU+/;cTnTOuh	i0[g=i	h=3BdOIqvdM\n[WA1tho7:з.OfrfkBCL-tic5xV6i,!h#qUqEC3?zR)h\\'Ap&0jO8DJ7Q~ԧgwgc7~L?~YTCaP-C!Ao|s&'J6SD\$x@/L1F33vBQ!⑄2)qN,H`S;wwKƺltcQ@Y2OvLF6M7]!K#t퉓DINiT\rVk\rj]>4fYmR˕	a-	0ՐB;\$'iT`\np(ICbu{6jCqO9!y#7Y Q\\J\"Q	c_:?r9,6.C8f!iO~82TԭVbiuW9lCxP;OE\$xWu@Ґ'\$%IR(Mh\$ٮ\"&RԳX'0YromVh\rI.;\n644#oGU9h*sG3pTwˈDf\roWz#KbϢQSFK'/1q\r^h.ESeTZvw0dƙRE)`'z&@Yei_N'+ztSa31T&PQyO6y+A)2KzE1MsGsI\$\nv6PҐDr\$Zk=	7˯TߛX㉰@ޙ@G<WZ2ݶSpS&\rX!&'(";break;case"es":$e="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9`\rKpKD>+ݽ@n 9@IP&\r7SD,Čj?{R;XF1(Ԗx\0\04C7k; X:D49Ax^;́p3^8IҀ2\rrDrr8^0ɠ4m=7:9S7&:c,\nåM*N0L#߶:8++B#8O 1\r2@ c# T\"6hJ9g=NSBH1k#.3(rՔ;	0ou2<<<w0aqHD.'kqT:؏<?LwU6&B\"(TJ7j*{S:UȰ\$;CXp5@P4Մ< 4<z& \"B[yِ)Ϡ`ؒF7\rCv\"!FeȐ9V,DnA6@so6Qs>,e*_+82T)Tp8[8lf[-4%)3<PBRay#Ja2Mc\$pmѢ[oRizh@t\\Ε8 bh,/F2)33>J39d`x%I9di{*%`Ж\\KɁ1&@Iɭ6˦N\$RB*Ph.\$`I9\ri4])c~gIAI#\$*\"Gf\0E`CX3B\$lf\$Ab!q=wl3<I`Q<++F_(A{5hRR!0a̎?#q\$dj'xu\$Q&T0%t&	\"6^S\nAb\nI \nʰ6/4^M)ni6K#mklPk\"(\r@w\0F.88\0Wy2%K\$MI&lA6-4,`m\r6Y\"I-8hxS\n!rG 1s_Cч%eFxIjcN§dq58!@a4xaA*JzH'\$h3RƂPD\09Ì}ꘚBT\n&B' fmR-U@XC.*h2\0*j@\0ƛ	Io@+ sDoC	43y)ld][\rfڝW%xbԆ#懂nM1Q}z)@&\$7MԪA)e9J\$(2o\nU\npbTqh)Y; x)	I<r)C0\nb5戩fB^Wb-'=No:dKt.BpB-{Ge)`N7X;Ώ!pV(6h*-g^@@g\nRAIyy-5>28%xudՁ\r!b9MD4܃K=2kUYU.,#Nj[ԺYKot(a41椎?ÂkQ'*>j۴5q(G*Vu\$h8n6d8W;s1FM xᨙP(?uyQ&WP9y7!<[O*MG CL&߄4LbszX^FU>^c8HV,0\\U	*hC	^)9ӣ9RzT]7Q9u%Ҳyh3U~*|~nEvhb!&XIQ7䛔Hi7I䞐>;ȒL<#EdEi \rݑ[@ShmR/%rZ1SvTog5Kմ?C񘜰}SwZϧkmqX9t|vA}]t}yOz~L)h؆[9z8,`\":ޙO\"Zn@ʂ@@_lȂ0El.(bX8\njK݇96 V0'`E@-iH#v\r4.ƪzLPJ.POtGBBjy	%p\\omɮ%P,\n\0AR[eY1\"X\$-g>\rάEе\rh_ke\" cS	~E<q5RB\$G?%.,(,)dot.7|L1,\"Ur0*k\nq%&/e.E[<J΃vQ3Z(euYH1\rd2C%]刻*\\1!(ϜY&\rVciPJhFB0@nhBZ&8c-BhP@HBf2rvj#>fbīD.N86ʂX/,@ͅD2*D\nO+HHKbLj\nDD.u(2׬=PRCfc:A~4l>38hS1.20oʋ\$#E>0CTBPwI/Y L6HJ(cppt?vd+fdbϓxdfJ\$O;+: I}c.جhG@Z+lBz[J!7e_vķ޸_@Es<bl -1B5j>XO2:`@	\0@	t\n`";break;case"et":$e="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfYb΍~=(L3|7\$80( B`޶\"	Nx AP9 ҳ*ԥc\\0c;A~ծH\nR;CC-H;# X90z\r8a^\\:x\\x7ㄍ\$C ^)(P̴4px!j+\$mPM\nj~\$,\\\nH++߶(j9GB~CP\nd\"8-3<1c7\" \n\n#\rk70d[4+6E3\"J#r:n\$H?E&\r*,6/P}M%Ic\0zų):B9/ʜiP5j29Pw2䂢\n\"`Z(:hS7QŐ(ز,9~+QO%\"[6F*0'x7LB(0Q\$fc,=e[ ; P6).+<,(ْ(\"@VS{sdQ3!B<5v9H4p6jkc;KtB-ZP8lCԿ܏*N3#ikC	qH670yv[JeUܞsrӳKBAM!F+:\$Zc~lhL	'tZsvQ7O׊TIiy[\r  (fSMIlĦi}&\$䠔VK	i.%LɡպԛӋmD]ISI֓.<չLL_Ĩ2H@;|=wG؃kABF3.cA4ݤ`@2gOo̚RSx#)2\0u%lв0iz*((L;\nc%-G&lOia8d\rRH 1ZҬ~5ݛ4Sh1*`!02_,EhR*^\"[1J:GudB))\$@eK6E@ۓ\n(G`Ej4(kSD<͘8FߒUpX}4`=Bt4\0Z`t2ARߣy!6r1^/`-:uqR0\n:Bbԗʂ^rp(E<3ִU	d=R\0U\n @¬@D0\"場\$uDALeLʣ:'LꒅZ\r\$0`oɑ\"/#,Boѫ52`U\$ZS,ݧ#S<?,t5?,#JPS|*dYР%AөIf-	i-)yl/WUB.L%MzHzVjefˣ pf2&8ІP+!ż\$rZy~0Y:0)T5K\0iZ-V{<2\n-\0g4P#~LOa^@B8GIPxNk5[.-?UGa+P2}0屡P 0(4e.T`5,giȘBP@g/R9%XdI~m0Y`KKərfHMVa*uraօUe-3-!%FS\0\$r,S\$=	M0	=xĵ\\%JYu;\\R?X\nK܎1<kKf y!/8@C7WNY0Ɇ\njMp4ģZ\\:VNt6qrptJ]spv8\"ry8QMNE`'hPH\nWӊ8#޼6pu\$=\"{E1~ڞ}l+eHƄ\\	9.t#kbG Z\\QYAFT!;[:N7@/?yw\r\$ϠHJ^XU\nI.U5_.\0wsD402_:\\(2_]j3%J}.r.G}oe}{\0ׂN=1dbx%\0i*%\r\$\0CbĎ7`nfgvH\$u\0\"O//,vZ\0zERRC\"PS)zS>/B髢\$iS<TND	p	/g	BS	0B'#\nmcI	V P.B+\rFm\rpE`%<\0D+b9\"8Q(0JP\\O{\rQ,R.༆_%Y\"r\nSVDLdѠ{o\"R̛p/p50БQlmxȾ}qI\nD0QBEX@\\ɂ̔ P	a̱(^i	/LoizY+1yQ\$j\rŰ-pDiϣ\$`VGhcBr\rV\rbfT!PE!K\np=olgd*B8-L.Tк#nHjo,	@\nLo/O\0Ғ>8 {\$G\$|Ba#4\"b:QLL]+\$ VOD+\nb`(@u4FWe*SX#s\\ero\"3#6D `ObNB66 SXX'BBF9BGMJ4eA܇\$p4OQ\nJFG;SeE?\rJ(k6\nGhPsaS\$vdZzB#nPB,T3hL)j/7F,-57^ 7kB	\0@	t\n`";break;case"fa":$e="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx.*Fɖ(%I&Т:_+k	qBk,`Xk2B\"68@2\r(@C6:##!o`1:#9\04@:Ɂ\0-c2\0y*3:x?wpPp_3sLJ|6R3ACl4px!BSj	,Z;d\$jB̻^ϳM<\$kᐌ	DΈ\"9\rҒ8!x@1H1\rxȋ%~U!-r!̚􈕬:Wuũ!_V\n[_U-N07zV^2ƀޏe6ƔL6 ǐ2vZv\"O-nqU/(\nbI	e9%}TE]Y	Vhr`(Ɣ*[<0%wn ȃ(<Nz5Gt\"!C6K#`6 pܳ1.k|:0H8:].9 LP_#.|\r!^<<N7nRZ^?5W	\\\rH:rN!&Y66\rJQ*ɺioItƨ\n\\p97׆Cr\$:@R\r1SڶpA W*J~I\rŹ{lBg*ǈ<JUu(ĈF%D6MWDIOЄ%fW>'ֳp	B/?\$D2'WR#*&D✽b!]I\"\"+	+ԉa=D\rڤCB+ e^5ޱas؝`QFĴ@\$nK\r87ӪwO)>TPCrQJD9#rnAO4Rb#VK5TJVEN\0CȋU 2C1;A椚bNQP4%ԛ\\_\01%r\r*gØuI@3Pg=y0?Hakn	AH, ð~vI#d\rb&QxWLH\n\"sN) XM]-Isb\nK86x iK2hMArpCG;DYap04 \rj&CLI#DUDFCE2hٚ6SlJ{M\\WYMZLRgYҞU\$i\\ʘajr!!\$`̂Ch pEDn}YZZ6W\r@.i.|u\$dx`֜ctDbv[<v6/Ԗ\$/y+-AD1XMŮ&C*EMG\r1)NM# \n |0FaQ(P*\\k E	w4{-ס9^XZMN*4=`䥸Nb86PWnmh0ڐ[NȄۃ6IXlYv6M͒s~IXאEL.^Ǖd2+CO)z UXEI)\$\"gƂ9b%DbymVPڤhXW8Hv.ɯ5͙ܴWeU,uΧN\n66k^;Vn]1Qb{Yeޚtm~=uP52|PŽG`qğ6n7~Aa \\4RTNP#\nQ4)Z\0FyJ4˟^mnRt265ښ\$*jq@=7aWoS?7 GK\"\\dW+;ˢ^r*OYsyģ'\nW7w>_դy\\_P\r;jׅ\$OeO[eO?QYhV^?\$ZnHН!Ob{D?o^}`|ιy٥3\rXX`m_~\$8<p~#zN2cM\0\n\0e>,f̢37-)Tݰ*)af]!\0PBn, ndVҭWONю@O\$BGcgT	2k~\$tI@Ăg\n茚L(/h.3\n%mPI֩)n`x%pT\\,GOe'>0Pueo	r T2èpFξ.]6N؊|}m5,!cxm/h->dx&^\rݏvu-#\ni<Uonqa܋Du{oGڇBD@0(pÈqm1p~	OȂ.M1mEP< !'!.ˍzb1GO\$#T2Z4R+g>ѐNH-\$;\$)g?(2fʳ'M%͏'zZ%cgFOgq)aV3BJg\"PV,#~5\rC.'d2CA((.8(xcp\rV[\ri\r)>aM<0(ƪ\np쐎FN3WI5(-TńJ?\"|\0&2bW1B)P1s1Ei16*34o\0006\$H\$(\"l4\"l8&ZD6<dD,juQHp<<-@sr#-	AXD\rcA9A1+6{BQ*̓~n6:ك+_cVr\"iJ@N@΢ŞyhDJ	[r8@gj暻Chʦ?p9S\"樽n	!>i8{y;C*4*M&<E};+Mc\rFy6M}a')8SWE";break;case"fi":$e="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҡt2£s1e#Q4p%ɂSɍɈқ%0,{4:BBX'9-p0\r2@29(c\rLP(\n%0@4Ry	Лn0:h*R94lj90z\r\n\09Ax^;́rOap9zc;c ^)ֶ\rXx!j+%;%@a7c(Hܶ\rc魴R׶,@:k/T`(#[:B(h(Ƙ89h׎èM\nh@\"8x7K\\-èx(\0U@74lMp֢\r\03=4 S43ZX	Ӿ\n挨:5Xsp2\$Jӧ&Cu2SVڔ/:loKb*6 BR6EL0Ĉ2Ȟϴ9E;.uj19|9\n\$#(6#;O\rB0boBc	T/</!H <5>c4){7R[\\;Ձ*\nsHԦ`\"pVu-ϱ\"vԧN#1(]c3@(ZIjC>/\$JF.ito9fi`暋3(<H4\rv:#Bv@#k\n;IjbJF\r1STz)\nb\r#G*uZt`nEodPNCD:NAH0#Rpǒ(\0!VdFDYHBSaB'=pBwE)'\\;6aU8Fbs)f\"j` 7sdL{E\n,4`@&!\$(Uٝ.椐\$^L	2&dК`wMл\$nN(\0s̌)]sȍB@uIK&-*x7=Fթ'qgEHsaQd썑#	\nFBtkphô)'M\$a(.b;!n&fma	%#\0P	@><@R;\nCL6Z|.fQԛ!\$(D\\DQhp5S\nAbRH.0u*Q{h	yAId\"LUTg~J	hHuG%3ʚ	5bQ{ ku%_O{dRY8'T\$'0TcPmrh`[Ho#TC99\$L b7LTZNK fڕFPDAӞ!\$|-\\VKIy1%䦝5[<D{\0p \n@\"o@ &[ބ'40%-TA	*UV&\$GNNб\nșCU'BR%ٕ&ss[5+aΪzIMxp&!5u,hMz+bgjUt#%'3<a	l9c_rlfSJ0'i.pDLI\nJNa#nM\r̢b+LQFhx2RR,u#fvҳZwԐˏW\nQxshJ+ޘFYP 01m2PdҒ'%<rwi[H6R\rx XX4ëip<84mt[rB^l4	m74}]FNfnMa:w}ݹE&\"o+59c.\"b\rKIlu-h9vS%@d4	kBus̟`6gQSM.)GV=\r]\rf\\&-S>ݧ֞RԡlҞ#pO7aL:R*wKG#K/i;]ʮIj/ӋvTM~D`/<,0#dWE{őh 5q0k~vzM\r:[iU PJ\n9le{N+Z*(Gy_u)O9Z rJ:Hh.-f(jp\nޯ\n.BKo(om41OzGl \"?Ϫ4F\" \$vi,b-[\"`\">U`+2'ovDJ'V\rbRD=cZА6pI>@XD\nLzS(&R4ό򑏗O?\rKOP mn-r!P2O7-p0B1OpSw,i,n@\"`We\"`Hbl.hr>X-Oϝ\rkolhn#^Q~Gp\"\$-| L#1'\$@bLE4EO\r:NTԱCap1/\0wcH*<2c\\ z\n5JD@>d	p7l<-hIQr;#Z\$Dŧni\"fB\$Cht?ʬ0 Y'W @cnL蚵/8L|0UirR\0\n	f\"2z\$r_/\rHG o\$6Dp hQ~&~BCr8vu2Ŧ\"5\\HJC1&D&EV{D\"(>P\"B-Cl/@4I)5R+Wf\0dJ/|P6Xkev(tvTn\$vG\0-2Rʶ\"LF<?NS`NMx%&>\"&zd%Ăm^ޣE1\0\$L6J7,9C50-4<*=oCRe@8ų>VRRqJs@bФnC.Ah*/dtI\\";break;case"fr":$e="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏\"Lpp\0c˞a\r)Kq@ClRp2B\\D#72h\0:@1>4Lkjv쵈b»Q@2\r`£+^ӌc(#Q[cE9,@6P֤c(XʌD47xA':p|9pJ|8\rBR2\\#px!t *b`%3)SU\nlP1r%^G5ZzäP`@ɍ:0\rJ:!ジ-|!k[o)ȸ\r:!-v6E@<E6h{*lSi7H\08ɿQ/hty13;(3<ǊXf12Y* Wa\\BXSj	ci	ê|2>4I֩f8yUg\"&/Cퟺ11%|Ot֒{l;Y2oz:(g뽢T@酬Hz7%ɬ(\"uC,\n7\n<<gx&ĳ\\6WFBD=vj^xiw걿0ȧB0es\nchryPFvH脿\r?`ጚN\0Q:&M6wA.5E<A\$7T\n8rz/iR\n8s*X\$fR_gƔ&_L}80h^̒'LnJ	2d؃d@@y5K<:RMK5L<HuxjYD2.4 jRACpQsCE\0R6G\r4RJ(M+7z:'~P\n	B(g:NTR\r1>SI F[k%=0M˄%T7\$ޑJ@4LNBDUb'r\$!DbOb[#RWqa&1[96/1vA	T{眱FƌÇ{\nW2P@@PJ)LDAT\"HCq%9\$yg\$d5.).\$֛Z}iMaD<u'3akd 3C\naH#x,^@ \n0ĹAR+*|0*zV#Sa\$<璓&̙թaf֙0*)	iM95p	qYɕl͡Ç\nB\\Ne4o.FOJT'Ŏ-Ra \nG~ĶOiRn\$xm\\%l0Y5קSU:;\$\0S5Bh@P4FVYIWe\"VɃj	`B3ޭBŃ->s!VB&΅aa!ZxNT(@-A\"Sk|2X#Rbx\nzNqCa<8*LpR5Yթ^>65/+7R!\$B\"B\\4o.õpg&jÞ/	@э%QdDdN}k\$Yc#L1ܽ! OCd3QུfXiT؇dvJ3TAJ_7VΌ[3S=!7+sةyJ/\nPRɆևNw@d)!7eBz4Z:!]@/Q7f{0b'\rl2CGH\rkEPk81[O3+e_rMXa,@T\n!&J*0	דڴTuW@`T\$:R[NqSدt:<>|P*'0e`|e.:g7kŎJ:>`d\":]vrYPݿsiᕵdc<a\$CGD#ſmڗ\\2.YYYRMٱ|i#yLHLC/zO'rj)i\\WU֒woK7uuRig_dD!̚'k+.K^T;eO`&F\"t},f\$ۋRc%\nmTgX{b,\n\0ZH&*P5T0\$2\rvOHv_XS[J\0P7\rP}/Lpʬt-\0~˅[oIaopĸ`Аj	΂Je<d	L\$0^-\0FNPnO,khH,ڋ	\rQڱ,氰!P;n)DH#pE/~EǮiET7B}D(Z6@Ph\0&J*!1L_,UȦJCR#8(4և\0\rױ2͚QlƄlV/QE\0o*f\rp̚\"!MO13\"O2r!//#*M!,Z(n4: H2++\$0#\rqC\"R3)C5\rQ\0\$O+\$h'<pQ+	r=ڴ%-rcwo&_ek*ad6-~\"!+\")#ܒ#2.0P\$2G0͵/C3rf`;%Mf}#O3<Lkk11F'@?q-)PZb ʀ!bFCc6m\n2̢S;#ab\0:䥠sR`9)U:@,@kaú5c;-khb0'\"v)O)bc*l\nZP Fn	9Q*&'O\n,͐bV<S:\$(BP@lT^K73!IX0g\"=e2M|`r+G\"h\"1ȴk3A@Y[=2l;?KC/hLbhLMLB;LCCNNM%;d֎X<#bfQJySi0\\e#<Q?KpTPvc:J.e5&~p#æ#BC\nbW61yL#:,`'-@|aIYdhux	\\2\r&>p,J\$i@";break;case"gl":$e="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M\nf\$)MJʽΠh#.Jᎈ+dǊ\nRsjP@1@#\"*L(8\$cph0º9#4\rlG#2\0xC@:t㼼1SxrSJ|6.3/)ʜx?C*@1p:03ޔX!-7+pԷ@U/Lx\"cxC(BP\r]nc`8722ҁ!-a46j\n7crN<ڰy#ZB꼣WB3D\$AШ#u\nal3c<VǈC1誨\r0z\n2BaV\r&Z ЃM7H[ޱ0d&Q(_Ϋ+O4R!B)'D:QC ivE\rCT@XC#D;)H71LV:D9ǃG>c`) ;,Hh7Q0ΰTP\"@R\rxPo)\nR?nGG0S\$s߉VQb%¤2#ь=!;	D-2x~ϲKDʁP^ Հ	Mm}+)\rnӍ-J@37JM?lf\"5R:Zƴ=ViU܌UXp\0\nN`9P&H^0(Wq=	{|2Fov	ITxr*D0rRKV嬃(l~]TG u9(%\$ZKx;ċ(rL%I\$nT3#U:4z\"b!o\$%XYTctlPT0V0GC\0	!)<C19\nM0g~bS\$2o(zDfmh\$,!DXZ0M̹ \n (P\$ XxT'dx@Ls5Di%	\$&ԗ)A.\r4t*e!awBS\nA{b \nֳT&keLg4TlWJ'Hۤ)e4@f0Ue\0pGڎLb\$I\\saBJrct\nʷ9(p=(Trc2Ec\nO:zC5+4Fv΃7)6zJ4MIRIe(䭟m[ a'\$\n:.zU	[䧦T!FT&aJ/,<EF\"H\0T0)Q 0BL	!h )p \n@\"nA&' sn}&[pffG( jF>u(d8XuF9.	)LAz.^#LBNT֝H'1l2vQtkVSYJim6!D,㝞+xEuM\nGYsB'\\`uR\":bMg[U\nۛY?Gʕ3cŶyoe\"*9\",:'\\:PeWz̷(uL*z;Fۜ<sk87F\\g02\$\\VpMKxcS-0)潶ѓd&n=\r/b`Z\n\nI	\\[B<ZRT 53iD\rΣGL^+>o/`ndsNnbO2FL!&\"[QCg\0gb&~A%&r@Ӗ᭐MgeM!s}8|༄i¸fHwѕ=Ltoa)+vM8M]Mu !(9 \"5+ 9M%Ck,_paJ,\$<^#L.ǠʘJd!`\$OCVT\"QdT2&MoϞcw''`fm}Tf&d^J2eN^bxːRe\$ĹΒKQwjMQTǴNϔ=jtczZMٍD,f,\n\n)2އ_Mi\\FaI@X,XLPhv'+Yo `@M/X|.\$\r\r\$~.@oFBuR1M\"i/MMcNyPiP/h'YkښP0Zr:+(,2jHc8NnZFlx#ȚHbgU\nJL̋	i0,b?\$/\\YVPZjF?b\r81^H|\0TS4\nAa\0rSmO:*%1OF20rEQOQLlcO\"2b^.;f(ypCeH4ޥ0p~сOq11R^{D7Q^z^Q#jl|%N3ϱ~1Ղ%d_16@qpsn\0A QUB6eW@O\"jS1#&B\"`c~C2Tr3J\r.(b4-%nZ,d#H2BNAM#2A`er%ɼI⳥^9o²\"i%\$HLz\np.\$i1ML.#\"6#N9G8LѤT2PPCb;}.Cܯtp* 6qQ1I\$1\"Ph'N2{*at3C8fHDrU(	@R,,>7T33Nϳw8n7@	)C:cQs|,1`'4h.!#% qluF2dBo>dJ?o B ޝgOlxb(:Ӱ6\$BKXfB.c+7\"d1THQD4/9|/C-4:'h%cJpEB\r";break;case"he":$e="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9Blwq-m^|_|mzS;Iʡn,c0N(fLקJ# 4@2\r(;C2:#\rp0:#9\04@:ā\0c2\0y3:x+%\n;s3(㜃!\rk\n#x|@kzHJס[H2	Ѩl#n↠jjTB9\rR4!x@1H1\rȊ[AZkEt(\nfL947\ri\"k?S/s-p}'Un[T:ZNZ{0#k8,!<\$ҵ;Gd=&\nbn\rsxRP/0LͭyM\\)6*ki Ã(S;z1p\"p\r#42Ȱø6Vq;a\n6plWRElds\")X^z\rۺ\r[<~7sq?\$=ŵ4' [(oMkdzMÐ60)V WLZSBHݧV5h9g1C\$:\r#āU@\n~@ձ4ڀ3ECz^\rv2O?	j0oΥwCij_Ȩ:V\$ Urג#i=9,NNA '@@\"*7rtFI	)&\$䠔VK	iԾSep:4[!@F&Ƽ#H5\$&Zy9.88Zׁ}	CvKݨT\r( H8kE·Q2(6Т6GVG22d\nx伴]q&Ƹ5 \n (\0PRL\\q9@hsG[rppG \$ Ch\r!J!0Γ50ThSl(ح[p숶 t	~hH \$^Z .WD0i dcPQ	Po+AkDK:OIkA\$왶uF4.5QDA9&4BhP	L*O8IHqt\$F:d\0#Sʆ#AyV\$1`\$K _Qz ZyN3MuH	-U:\$0Eb<[SkzMq#\$	ç_D.pDT\n\"86i0'us{1W\$e喑M:2>NLZqr-%H[{FmzsdPaF->{a%R\"ԧ2VThVV[EEusmiGbgY \$Fr*dEx\"^ XT-j9ls5񝙫d%JSd啃X't	,IiYe)c2W1[uLISb C	*?`e']X~ϴ\0f,^?q 2Ai\$\"iRH峌TЃNY{ӆZ^ayCn!&0QM!WhAvꥰZAK1kY*'J70Jt!(Z?LbY.ty0!Mֲ+śbSk64l0!13J\r.G0M@19\r_8,Ǩ-sXm=K@.d\"ș-v,gĉap(X7\nV=jBʆ{MP(DWiC[pdVspy6\\{wL\$LOSYEM9/f.df簯r9zdH/r4RQdZ	 6Ekl&4B_8	Δȁ5[3gO<+r}%s6Op(%ቨdvSǞ]G^Jʙ=IsC҇tSR򔶡<w>.ߨ\rR-\\J-1dpQo\0/6eMCV9X\rŎDhH[nͬDN-lX#h.܏]!np}#:1n%0mW	BBva#\\%@vEP\"LCύ,%^䑠VA*\\\n0DA%:6FZ)?\$xZ ԛpm0Ì7B%ֈ,6,@*A, 3O<1,8:xzZ|0P΄P\\ߍ\r#ŧbN\rB(PcN[1슾#]p~^LWKfE@I@ΑFp`ID̈K-CmNtl[!g,\\B -d`#ͼ!\"J\nMA4J[J@L@x z\n#b+\$JBr @";break;case"hu":$e="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737J{z:H(XCTf	IC\r'|\"PlBP\"=A\0\r(ڻAH@Pݎb0c\n9Ʉ|8Z;,O#; XФD49Ax^;pǐl3@^8KR2\rcZ`\r#x|퍉()5Lk'*i /n/QUUaCRB0\0K\rr!܄8C},2!\"HKiDUkj 	528Uh:*3,[ :+B\"0:!\00	m N#4Zp3@zRkkVSp`Ęrw-V5s:\rpbP\rɵ(#\0ḡ\01#u6(媯 S\$3rĭO	Ph,!	8Y=\n\rhHB;ǰGz\" ΈP\"!Ռ-K\$L|r\$-/-([:2lZ*{6}Yh\"(<Zp>7xJZyL1eXEr\"\"@#&v&(.#*;K5[/Z}BHn`ei4,^`c)ɺ!!1@A6fۭ'PANA&L\0M\\d5TXtN;\ramS|ʛcѩ<55\nO-לLɁ1&D̚RlM;'FrwO!<\ntCP2IYi2taѰ#J,D4!\$2I\nD47ˑW;%hBP8͓+#T=%!\$ RXf`75x,r`pl<ĪF959u]jozi@\$	fK\r9r HT)8SAiCR\\MO0DHgMz,!;sFH@ aL)b`qV)\"<n|\nEE|PZ3k˔STX-&gpDCɧGτ\$\"N	)Ń2Y qK!3G	>I(cy\ri8(	4IUfprCFSrr+{@!?YZVAJ\r@A\0Sk0(0TUiQj%jP\$@k`\rvgsY2AUmJ:6p.%T)nZ+zBPHhp&XCCj;dj\r\0fkt4T,+g((9\"OCxb`wѷbhkM_VC'`<Ił f,Ya a%)\$4r!LKp(bb_=[We)((ł`Я̴.Lx#oKHPGU+Lƥϳ \$.U.aᴪ5cUpFAݎ9\$xV_w&d&-޼&0FL櫂A7\rZfbuKobsۘza抍3dP*T&T\\E9?Al3:\$-pϮ\n>i0#{˰+i+w+)\0Jٌg}ja	mRi^ސ5(UF;L:mR!G[1w[F6&[H`Ԫ1oѧK[*Nuf~6`aFu_Pt*-<0Y,IΚZ\\g{H`(!֘7mVpNT6U}-p(WwYr11Vw|9Df6L >wX#\05X:aȶۊՓ*Oʅ f8 NaT*ł\"(,t\0 lM·/|+rS>#R;_\$7 WrWWktF=((Ak*s`^d	)&g6+vUO\$8&\r0?-΢Pͮݮ0.Z \rmk5Ce̓n+f\\Y0\"l_ %o:; ƒG\nĊ@2/C0\\VP6ؐ`Kc	!RiEIZp>pIÂ`kHyйI,Ͱa	O;*\"~nĸ,;*ćq&%L,Bux)Iog`F4Io*.qh#-B)m,\\m|uΆJE) <!T\$*f}:B=01\r AKb\$bFU\rr,2,\0/\ntC(%Z*\$,q8o\"G86\n/#\$GR;gq޼7\$:lrs*\r4C:Hc6ZDE.0>h5otcQ#n#+eu'死+,++2*f@%nZ,HU|&	,S0W֎0p'1NSe*pbfY\nŎJn:\r)H\0\npx\"&\"qBHrسlus,3jp'\n#@\$BH\$\0aij^&/{6S@V/N)2p'-;c<prʀ2&q(v\"n	I>D=;z@;VC㦙N^.U(ZReE..ln{6`,*{|\"B*RwB T%^v0HNmCL&J-:KC^jI4`,zSl(昀,hmƥB\$e	F #c?*qѻ*`5s\0CJ4&[.4<tB+@e4*L\"DcB6B-a8+ *cg|A\"ׂl@\0t\r";break;case"id":$e="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9jNznQ9<)LdBjV:p	@ڜP2\rBP l#c1tVKFCV9@4C(C@:t㼌(pܔ@z29^)1@Aj|ҒĠP5H9@J5l<˂t4ɐ\nޢ\"8,@1#7C\"2\$S%`HT/sW%t@:TV\"GC6#c6+5\r\0P3):?hrh:s;)r4IԜx5(MDPC(3T8>IB\$&Cm=Q/)c,h2c,x;ozI@;2-+01{S(aTA\$oE	xCo:7ل֩\"@PdB\"ӱFR⎛@2\rݓk :T](#\r;k#WE#8CVñ)Lw֙X\rPcȏ*XRCt1mpc22H蛴6T ȖCx.ŌKi^2(8ҖO\\')ʣAj]w\"L\$Ҁ(m(+: U\$و+TV|FHrAi-CЈac(nHf%P4<ɗ_dBoMB\rZ2Ha#:@hE^\r\n\0[;mj (N	@\nJyl00n}ȁD4E\0i%B!Hnccl7RRdXi2+!8mW(RILM6RJ\ntar(.OI9|gH93Y@ld\$b	ڠwL|sJC=r@XASBnFL\\(pr(Zw]!\"b`I'CnJ(R4%3@` `2H; @eF\n<3?	cQ\nԳ\"xNT(@(\n \"Pi@\n	OL..j)RA-AR1>hḑEkOqHbOxJջCjK46`ؕdW	DB.+\\	DHMёbT< gEL#\r 鱞FSMj25fc5]c:'LcBe=&YDmV.x B-.鼟ծb(7QB!EKxQMQlmmXKa:Oe&4!\nƚրZqA\$ C	\0`#6CHqЎӉD@0 I\"3@̺4ੳzxu1v@uBKpXSa\nI'A+\0Љ<܈QA6`\$}f3Pr	N?iJx%4&ƘU!\rY47kta3K[0]T1HUj;1u}B(lXr1q;*)U״F?gc*\\VuL;\r]AWXQ%͋GQ2O 8pld((\"]4@X5E[;jkd8 uSNZ%hujX?IOBrT%| nM#ީұjN\$[xK+%!7aEaqhܵ{tQ1q'qj3ya}9EKPͼBmbӡ7#Dp@YȎ_#	61dϭ擕:ie[<I2;Q\0nuN7u-˻n};os;͚ɭe{hy{~y#jm0e8\$dqjyJ;j#[gt}^/cgAf,vddSi]z`Aci}-'zt'Ob~;@D%J1ϩtx>ۯ~;Oj.즲o\n,/RWi0 {_P`N`e0,esERĶ?`RT%\$hH\npl\r#P,)N&xMcLP`2+_EjD2\";cC&\nZ6,D\"r\$ Q혌	8T\r:(KN H>/6\\Jb,ξf^l\rMbbrMJo'e&*\r,hOuL\\)Z)l\02dB\r\"@'^ԑ9zt# @%\\J⹉818Xb R89\"c#T_ϨHH\r m^Z?'\$@>\02BboFעڛ&ov";break;case"it":$e="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9[p&P;PmB@a3ڭÔu܄+َkٴrC\$6ӄbsächf)ek-f}(sNPM,3w#l\ns]X\n(Ng{A\"-bt/R*ޯl7>`޵\$ j\$i+8CT0c&\$b*=&C XҌD49Ax^;pc\\zVIh2I]2p̴'0RH4x%ߺ`,,-L*c: k/2K5k	 #ot7_.(&8Cz  @1*V\rbHBjf@10+-BBˌ<7%tJ,(дmI\$lcsN/IJ*B4%H4V\r浪`Q7(P˰oDДdU8ǀ'5o\$C(>Cj\\1\rAI>#A⣸]Il\n6#z!}R^XŖ\"8>\n0A[{USMJ+ډhx:+C߂(ފp9>ޖ#9ftT\$%`Wl=8ϳ\$TáT(	2޳3?H+\"j!v\",<ZWgWFϣξ<{_e\n)2>IU7TC0ferQ*'pN蛞dz\n7(&ltd3gn%HȦx<!\0.G#䀐\"FI%\$zÒQJa<W\0RIja\0ʚSYEhF0^H\$ؚ*RveRdH[qzqrb:Sʟ#)]%);:ˤ=8;`TP9	ĢH[L(\"x``RLZgn٬9BbHY)C8~zWL'N)E:C(y5P@Ry+e-fdFb\"Iy=.&aP303(nO#):J5a	'5l9}vLd2:o:Be`O\naRtNbi)E!QiRi7Hã?j{NrI(gaPBe\"d`+։jtf!	erA(ݪFp \n@\"@Up\"]{\$5]1910^CBIBsV!F ٣TZdYhZ-#g\\@PZ)lL[ehΡ Q\"ha&`|Hj)7redH^ (:k|VrW|C@u	U,:װbY/BXR+^_ء0\rE^QJX&PN6)\$t<ϝ\r6V@n\rq\n`beɒ z>P.r^\nP 0y*2x9Ie]*NVu\\ZC\n1:P@dզ`L,4â\\s6hwy,sno}f-|2'g*.!I ,4ZfA!qO1eg}+RH}9dԆdM}FYE\0k%toN\n|OWOt4և.T2E>rF9yަu:Λ	(\0TRYJfx]\$TR|=nwYnGʆ;ȖkLjPemapAp}b\"2}iWq]Ãg?@.\$g(&f	d%+C\ncX\n06Zj׶/\0uuwe'cn5:90p	&cйϷ\rgaP@EDg^3u,C6\$ƣrF1'MXOt*ի(nǔwPzÞN	Pwxs`߃ʓd̢6_\$᰾p卅P{o;W?}¿<+ܸ9)r݌\0O E#g~Pd6+\$akb`ŸP@\0Dp#FpV|PP0\"b\$#:L3\n=.xg`\"9g4#^\" :o,0(W\n=M	\0	t`yL0ReV`Dʭ](b*WExV\"-\0ab#Mx\"V*YL)C<iB%2i9eL ,V1\njY	@WB)m#OdN7nv&\0\npҎ&dkLM^8fMZ`kN0f5%ü<*#Ohn<*b0vEĺKb!\"o?*DQ&B#\",bxgj\$.(rb\n\"if7e@2	\"2ʏ FIf,zCD_\r#BBP] F)D*%:\\%sNfFS)NDz{.\\\nB沫	s&`a<\"lFK\nrj\"9k0Rْ,W@laRe%gn*eBF";break;case"ja":$e="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\t\\mtTBЪOsW:QP\npp@2C99E8i\\A\\t/>B ЁlrjH8WA#	ʨEYp\$r?( h7A\07-h:|8Ar1m)\0+8.H94a7c2\0y53:xG)t3(9xDlJc46#H7xAkNE\$ЎhKJ	se*WXEt)M1\\rDDb9\r@cx<mx6\r#7c\"\$2D/\$A.Z6AhBA^g9*U'DG)\0\$	psOKG1*XL\raoK'!8s]g1Gec(r`B'\rJ\$Y+nP:cv0P(OIɖJKh6p;BD)ERXMu^WPT1֌ՎS=^\r贡)J;54;-2ϲ\n6^-a\$watCY}ZqŠP8;8Ap8*<Ä7qshFzF\"RQj9~_Rix>\\#ia@PldԠf*+Tx	HD\$8pN1\0Ơ\"0sHnJo\r6/sF15!Gi,&%D}2Vy> ALiqhu\n%\"<\nA MM	SP!E(R]LTJ\$ml\"V*I!\rj.n6\$ıby&'\$\"IH9mі3ALpǧ&U)\"ft:D t)q\rܹKHA\$&{,PQx-G0 B\r:aIf'@\$9\$tN\"\n&sġJTE3ye-!TeT*S;PR`9êp9FaZ(0aL)gބ1rfz 	\$201	W	/H~TOB#xASnV;#\$à[hj`oTQDBG2Tjh\n	\$X<`W<KjLStu7)p3 zu.ޜ&˚S\0£WQM	\"8ĐȲ)]WQa_j}!	@R+_S|F4@SN1tI5L\0Қ[Lښh0T\n	7:ihݔ.\rR)nėR!E;(gÔ]3\0U\n @8 &\\ZJ)/\"<A2!`Pi<\\f!=Ep6+r>4-S|IL,ڬnyO%6SRh̒I*D.zϰ޴A\"l\"rN!k6ԀA=tαz=eD?< dds(>w\$ASm.rrTl!=UmITX\"\ra8_\$.s5`RZ\ri3sѰnhW~<gGH'l-LV~HML<yy'n Rs%[6X[`ШBHEeK(ݙ`g4*I\n^<!\0 D0d2\r\\h%_nؿ\\ؑa4w\"Y<,R.<말@JRK(;zQJT#.#gʳdA +胜BNQ+pHGgU(+Pn}*\n<ao\\rq8є Vf^[n ER,_@YC[#W ə*ZblyZbU,q\"Aj|9'[%OK뒱\"yI{J;@H	\0t\nab,>`A@y~܇n/ʉ8Ґ	O#Y\"?IPI\0-v\nonln_z[G`FDiʢBE\"0doGRԢn\nȭlu	lʧvZP/!\"*ҍO'\"nf吪Ob>,\n.ٮnX\rv#tv&B͔Z 01R&r XJom^N\n\nX+,\n}#	&WGP,ئlRڥXNR01/mfְԯ֑\0e\n[̵Nu0?QDf>aWbt26?\"\0~|0Vnc-wxM\"mfBE*IP&8m<ŵ#FGB%:[P\0}1MGM\rQ)/3\$R'ş&cx*(ߎ\0Fm'+-+YB8r	ޗ%#B9\"p2%a0=a.ghEXxhQ(Ε0nHP!*h!1&ZO\n`e\r \rg @ւ\$]R\rNcʥ*bKd\nZslM0hoHglғqqf4ɱ,te#Ü1&Яva%=#\"2b4&B^W#?oS?=9>'3/OV <j;Gx`\rƾ8R;-*0ajT>Ӷl8)Dw,(st5#V4r\0dծ/BBY5CFe>kD޻\\hPHUpxW[̓K췫^3B\n\r2!e)\"B%m<r\".IT㰒ĆHjBQJjTtXq6C`f'2Ҩ(Ua\0";break;case"ka":$e="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]'I.%ڳ:Bă UM@TzƕduS*wyyOd(OƐNo<ht2>\\r֥;7HP<6%Imswi\\:\rP3ZH>{A:P\"9 jt>Ms<.ΚJl*-:%/(iZdbMR#3\njsZ=1hAM܇\$ˬ:N[pD6D̓j*SS.# 4(\rI0)('r<J3Z\$Ԣ,\0x0@2D49Ax^;ցpAP0\\7C8^2x0c^xD\n?)^0\n=tjǮT/\r1R?-9Dd;*Űe]sy5ףO7Q+v#v8cx<c`8Cx9Ȓ%OŴ8Sd̨L2̿N2\no;88W=\\,:! *\$ٝ\"5*[WP@18'i7x_9q\"J=NaВ/^xFqzfPM:<K\nL4*uqAj~ȀmJrȷ;<^J󼽽r\nbDp߁j)ێrm钧χ-'y\\˾>;pJ!\n;\0CcH7z-@t(\"ظ90#``eQ7p#\r!@PBPILQm#vRC3'l:Qcj 'kB\rߧ&Ĺ^4Y	_vɡY43QQ(sK#=fa\na%|NR=!:&tKa])LxbG(eLl5\$7?4Ú|@Ʃ\"0i\"SoyʟHi%eU,3ؚI*)䓝vdm4CDʨ?}8\"rjJAd%<K)23tBq2y:ExZriN.e \n# (b^j%=[#I;ID2a<YrYۋz:/RD^yIPz6@JTTZՊVx`>ֲd6e؏3vzZ3[\n8/қ7iLfx,Υsp-5{tj/\"7s5\"U]Md2fJq):%mNKqۓҽ+i-VA%5MRfn`Rҫ8l&o'i;̢9s\0(+HP\\kњ͞PamUKX-ZJ5\$iμجS\0Fw՘12aX.8R=Y80()9ƞF\ntPR\"BK-\rF;Z!olt鬈ƚ\nN\$1+ZHqAEﲔ޵GFQ!W*pڅ857ry,Y'@'0[*Z6YX%u)Vcv43蠝01clp/G&M`gN')gnJGu<`fiZS\$݆ТA,Ue+q	}2s\$*7BKD8I [4M]	V/,\\uznuΛҴmfRW&J6Ќ+L/XSdt]^fkBhJa	xBΓ=Wo˘\nK{fr/&Po+\04kv-7\$N\$ZX߅~<t/نy:C\"ɝ/VnI96}^<5ةٶܸݐxE=Ug[z,_Am1^HQXN!ke&<iVïr0j{9cV!dOؙGWmM6KtJ)^g Tl%*k{w]uqS\0:u|P*ؼ	t;bRDrzGOiY:a Mjd@K49>=?grSpa4+WaF%19XqƸ>(VF_.ީK&x8\"p(Ԥ,b-A\$,mV`ɴmHti\00h\$n\nv6dof\\/yD( GN*BF(Je.Ʀ)O>7n@O`im470-<5.-lVB8փ>ﮛ\$nwϯr4<p.j)i&],)ne0L+\"̡\rO|L=\\;!2\rZ쐔xP\\:cN謄r'ʵ+G:1TM@Qy┠\$͸ڐ)QH\n.\rr+ԨܢA w&/2Ĉb8gM	&Qm\"UǙ!q#7\"\${Q\$q\"N2Ff\$7nJ&(fAIH&BK+w\"0X\$/'ܨ\$o(d'񊸑)GdgO*R%\$=\"{&*/*c{ZzdF^qN+B^R|\$Q`&\rQY.\r32/1322]Ђfj3#	#QgB62O#st3x#4F4bkfl5a7re7%QldӼ/f	4dL1. G\r6^)S=.N!S)%*?>%;N(R;tݤ> 3BkqBBS]FaBNi:S4qV\$q:3ѱ'53p4u93'?S+GDGEqҍEChFCTf	.:;pD1D4w#1C7*j	}LI^SSM/dkCLAQN\n8f7Zmf8c\0NR	Df4\n\$Sed\ns/StR&-I%\npĨhNfj3LV\rVN?,Aoe6,LVbA4P6t-\nNH#(K*!(.,{h\n,e=0^U(,	[4C4cS;O(a,VeT%<@FS\$kQ{\"s\r5SFacntpPYeuB,Xȹ/%WIC2h8ay\0Ydvgf'X;gEdb8:\nfdrjI/]',f14TbvBHXNNX\rՅ7	lr,x)FG,؛<u7g4GoHΜZ'm(ʋp(.ֺШ`DXttPp1N77\nuEaٓ\"s\$1&-\r/k{ސ`HL7F7(:fQޠObAnMƜ";break;case"ko":$e="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\$-ah\\%+SLAv:G\n^в(&Mؗ-V*vֲ\$O-F+NR6u-tQ}K槔'Rπlq#Ԩ9NӤ#d`'cIϟV	*[6aM P7\rcp;\09Cx䠝mvBZ!\"L:dB@0R\rM/d!DAL1pt45E6Nga0@EP'a8^%ɜ\"X2\rx9Pc8BS81s\00#1#H4\r;C X90z\r8a^\\0˒'	x7HEѡxDl%?4\$6#H7xBy<BiNHEIBj/Eh*LI\0cټŝY](9ZuEKSIr[PB8!\0740C\"22<ŃhZ7I.Z\$Q\nQ\$Gdy2:80YzDJbp³<\n!ea~EBc?DP).戳]'YX͓n6'* ـكOcd9c\"cU%smcX}\r\$T=s]\$wC<Bm3(;9\0ގr4̏4G0`ه6~dqy7]l|wBɔPel̐7|L9}p:U} 9XAV*=zFE:(\\PCZôJ#\"\r9I]#b&\n	!(~1@ȪàifါV` 8 }gQ6 Mݺ\0PRV2Rŉ,	\$=1(Ȑ!\"^.ӒP1!G\"AԐDZZ\\&rb/8\\RYL)8TP`e~o_*fI\r`V7FkW	8 xpt(1vF2<Y2-6xA \$AJ\n4 hOU\0bO9+)a4T303U\0CI0f2\rvBt1ư(APa)`5Wd#ŜɢñM\n%8	ܠn\nD( øh\r!xΦf%v'tP014@<Kb<Qv;!I*0\nBQ4GLJ2RaFDț5Grw\n	H)uu&)ykX:T*`\r,Q3&W+dRś4mSO%V]~Q%D\"xS\n£`0-b׈{3ꕭC4`/u4gN_sz+`c\\346A)*R4Ⱅ^LDb%j%'4P1{	050	p:ŵiOu6m<7	Sghx8<kZ//B}`GiIrq0aD2%*L.7U8\\㊃5E=E%zܔ|x6\"w\\Z_K\nc#!۔^8P5͈L(+8>4_E**>y?+/Q\$KRK9>u`-z!PrړT]FȒ\"}B4wD/&iQG>^sGzpJgIKJw!+\$B\rwñL-\${Y\"7dm*[_qJ)M*|S(&tB\"pE0,ˮADY!P*A1e)*kM]`#ڢ`13LK{ndG)і੆NSsWry\"k[okBQs@oAY`9qG\$ښ_)#rf̗fīz-_5Β/q齼ìQ7.waeNͷSKZFʼGA.F2!FCcN'̙:ךuSX\\W=Ā,-mLL<hj9ZG=/ZM?ȟ1\"Pi̔	[\$p}`1nWߟ~_/qĂ>?9?(mPģ\\/(\$`LZr{B˚b6p=,%ezC0G\r?mn3mj J-\r CPP_c	ڋpJ.ޘ#\n<!%bd2(ǧDC,ɖņ[lk#̈́Ik\\\"+\nڍ6zC!N\$0\\#0\nPe[0HzLNan\\J_IT5]pqQ+<D%gBC	b 66:BMhI\nWnͰ= z1.c؇LBу0rDĸͭ	&-2	=OO!-C-!\r\"1^!Q]Q!a`tc.\nEf		iEFI\n1ci\$>ZObQߧ28j<r\rzLD##ъ!!09rBf0#:NxRҳhEio[@\rVaJf\rgLAli`\nPBhO,*LA\np}`0N)o.'<#%+h6̰ZcNP'[h\\\$C&G6J,F!R5r-fKA萴M\r0(\0mr/L;\n苂32,63^cK^ay4gEQb4ϩ5'%61 Ę>O629@v\rO鴳\$hA>@<Ǖ\r̼rdi&O(`b	R^0b\0GV@A8`R0d?2ԟzDlHs	?, ' *pCrddMCA&B\\k^<\$0A*ɀa\$`";break;case"lv":$e="V0DCse1Mг~\nfaN2OFC)sC͐#&t&)2ӓFD	m 2!&r8	A\0BP\r&AeNgIt@\nFC1l7AGCF\"%I7C,.'ab:'#)D,<obٸu22Q@ S0MMө_i2|9R?0&[w0DL:N\n\rC(Ģ\rf!xbo|)K!&7vϻ!cR<(#6[: r̡B7\r186I2c®1^A\06\0x\r3:x-gAr3(\r;C ^*쀎HX֔2(d.|	#LIi|Z>/!V,c:@6=(.K&(F2	%.R(Ȩ!N+FP7hpC#\"02HH\n*dt4MiYшXP4P72Ȇ#\\rհ7i̡a9,\\uOtmP?6q8'^)2КQC5#<H]/KGE4ƕ,jl2ϨMZلRVUm&Gx96tx0w49ÑS4aH4b02	toutm{7B(,Z,歱2\rKKĄ,8/Ur=DcOUD:H!I`\"P PvAh 3np\nH5ZӖ\r6끨VpQ#@P:U| 鄆=k07Nhu9ѷhq\$^!0Biᥑj>r>`1;Ɖ9C%]\naHd\0M%|KUY7 G~L\$%ٔ]W!t0BN#\rĜ9Z%C	p@q'	\"T&T:'!ZJD1p+=R}\nPJ1HpД CQ\r6l9\r)JabCs\$4QT|)>U؞I\$囂䔓rPJIQ+%<')9&D̙]\r-7AA(EPЙvI%\$S-)gq2\nL\$! \nc!C<'93tc^mSC DGz\"C)Q'ƈ&R%A<\0@@P1&w#ƼfH\\0јҍ)P(*XS`ldHHX`٩\r)\$G(K,TpQ3+B9(aL)cp/9lm }ARq\"\r(i)G)%.JXCIb1Иb|]by	ď{QQ7IYElB`l@oO\naRlNd'+Rg-8bpȢ02`Q8ڮHӭH|MNIK|Ƀ;@_y\nm,2jM:'Hݬ`PS\rb<)%q/̤li\0{p\"[\nEk =ٝ\rB?;8<80.C&j:w7V!\\JC19&дA,Գ7R}҆Y1(乚g8Kt?*\"F!A\r\"	ʵ#ʡQCD:r#XUӹԂQj0(h*nj9`#Xu[9@K9a=T>Cl*j\r٦fDTL\$(tmӨ,JS5+1dĺ_pT/aksnبbGMBHDJ)bBTʩֈv3Ajwrk6\\\\BT!\$JdRe/Z*@2r\$[-S&6|CbM4T(u긑XKSHp9Axg~ʸ!Zd\0׆Z-E期Ea-r\n͸]R_Z}OkjAKTRWHuł:I?rŽؖ6{9\$^d5~L(w^VI0&EowJ>xUoT4BDuyrf}ew7!V}6t{ZMp֩>\nd3(\\|!\\'GBU~DZy]X\nT숹>G`ǄWhc<om~T!B(OB%\0Pf45Rb,l\$Dv-olz\n]lL4e4ʀE@\0`KNېzl(\$PED.FPyЙ0 PoKRDp60ƿHf._	о0\r\\O[j~\"LFXI2)e)B_)2\rQ(ꊃ~m\$n`Bo7J)ӯsQ_ps쌳eLo,o4zz.?	ܫfuP^-J\nG\n,QNNtSѴ*k\$C0S\n	BNq	%5`Q `&̸}Co5R\0SPabG@\\<K̅OD!P\"'#1n#I͈/c=.B#\\-v'\$ݩnBs8	H\rem-D4DDr1tNۀ0㐸Yi\$0+R\0>B&%XZ& inȁ+)䮻.O.f2lk\0e^#tg\r@d|^>1:)Pi\nZ\0>mx5cQ&r2z)S\"4!5N\"^VHϤ<6#Z(˪#:/FBƍ> H~NbSRDQ^RhՌ:[dH>%\r\r1XO7M&)!>F1hr*S7ϺXF3@6F&.^2hC\"\$ha Bd,C趋lf#pRL,N>6(Ô\$C#\nLG@#6!,^'Rb @\"4RlJ,b3T\0:@Pj[c,\\*zIPX+JfVCj";break;case"lt":$e="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9X:9V>B94-\nc`8	_\r\")#jHBȔC\nB;%2\r1+-B6@l4c:1K\"c\"l0\0;c XD49Ax^;p#\\z#.t\r*Vpx!H \nPR.bckx 2T=T.6͜kP8Άcx<6\r#7\"2C\$\"9!-%m˳\r膠7K@\$vP29V%R#DXh3<1J,ʮ\"69) #Jp5%HVCZ&%N*E,h2#V`յ1#s(\0	pr\\J9:RܶnT/<wM\r=\\Cd6Yڰ.cCL≆a̰;Pѡ\0ޅ9,\"I/E9|;.h!APtQd5⹍3m;KB'`(5roѤ3~>7pbIgKP\r*Iå >^P2+<#u+HDǲ0;+ÌbI\$L3uZQN	^Y`\r̒,PPIk:^rC%˥v\0d\$(%*B^-7T,@\$\nR4%p3R\"Ffe#\$'eLdLɡ5&ܜrN-;\$yA>\\R/\r*A+#Ne\".`Jr?f}\"Xyhfĩ!FO<`ipM!+L33~:I}R4\\!q\$	%Ö԰h#hGqqq,ȅ؇H\n`\"A:2XxNCHs'(pYOr(\0jCh%4IfeZa.4`w\0 aL)eFD	8Ҧ#҆w`j fH @o\"׏\$ZK˃ZBe6Æ2CahI5>'dʓ^BɐGmi\$D5G8#Gm%:siDH{6'0EiL:|Y}hmh40CK4S4C1eT\rkNNG-ߘrQ,\"ZځoJ\0&\rs.}!ʠb>漮7A)'|*C_ t-ՖsJ)Jc&ʭV8~nJs|zCr(\"Ȭ&;'n37\$E}Eqq^R4G?Oրrv-ĶFZ]anUqC\\m_()ڰԑ_/\$:\\А-A-pY`\nP aO?D5!YgD7pI{)KwoKLLVۙ\r!遬W>XS#aCXre812CUm0NmHg&ɱ&Y(%(bY5CAA5+3ѵ5.ve@wwDcNY|6eI/w\0P*\$S!L\0\"gbPcA!vT\n!ASP=~U K3/mI5`RWl-J0Yl͑drO}1[p\0ھ\"DQ:4]/Kcu]HGKŘي[\\n\rOmn-	<3}7%5n~QKYD?!ݢb̺!1B-~I{X(mL@atMb<pS+sz&HNl!v>R'	kWuNSN@h-A'NB]Э`<};XlL2q2(anu,w@Wx3\n@cL	ra\rffhFmf0Yg9~A8j~øv܂#\r/\$s9\\^\\3l\nrз4Z*?\0\$\\n__	Du/< \"0ZkXI\0ȰnݢrZb	\0*0K\"߮(Mp0%+n\n󮞵ł%B\"JCqJJ%M|iOϬ|7:%5J^\\)C #(k\$z#KpƔ@'ƑV8v=ln7.@(db<pzRnLtjgh\nin\0-\njb#lo@-+^/\0dl*`,;ccUEB)\"IqgGUnYLpSDNjVbX \$<ZdZk=M+JM[gB\$\n&a+\n;q&.#3+0#c#1TLV/]M\"1i܆R@p.!\$GNp\"R4	\rd;|ףl)NPrLABdm\rq\nD\$w\0/:trbD/(% r2n#ZRgNZ*Q\$HZ=ͼ>ꀝ)Ej0(p-2|_ȁ*\rVY``pK`HPjŐ;\"z`ڻ),@\nZd*XBI/J)D#Dn#3F#	\0]w#	;1F\"z=,b/dp8UcBA2\0=8\$3e\nB:%Z\n8ĚB3#\n\\AȨ!\0@yELf@q2&(\$4/#?F#hZ\"DO@@\\4yzG&@I<.'BjʈEAc~U6<caBc,r\$b%@3\$F@j	\0F^q@@&%@\n`ꭠ	DG=-K	&ƺ\n@m>޽\n;A\nPWܼ	eF&N,G.` 	H{--D0\"\0</Ö";break;case"ms":$e="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7rf\0633Pj0؊;IΠ::`ޜ+	B6AP2\rK\r(拍賔8z,0cL'\nu/CH4\r^ Ø`@ c@2D49Ax^;ˁr΀\\z|\$\r|vԌzZ-!^0(4Dh* KÇ\"Pɽ\rb	.zhP0MRpcx<kh1\r\0ȅ(!-j1V47蔟18i22	2@@\r. &I P@uܝL2`U:,@C+j'\nz\$vêK#d<9<\rئ(S~Ip4k.< 3	lA3dI:ϰ\"\n.c-!\0އ\"[1\r,2=CpXֱP;4#B*_CԮk\"dylB [ izjGjV|9n\n:'\r޷C]<)5-ÁB8ƹ\n7I~3-\nK2)F#vֱp'68\n0Eɬנ=T*trJ*:0¦6CZ#orrR`U=2+{uXl}Fa\nt66HR9i>2	-MB?j)H\"rKI=(4[K}șrfpd&xOIV*	X2\0u\ro,ݣ`A'dg[B;F	ݣGXI9jC1p)0HS#␏s7߆WlxǑ	17P\0r5(rɍ*EP=ނ6dw %tH#%j@ie!tLaH2O\0C\naH#=G D)6o4t Fb+A	eli_s'	@C,\"0PF71TD\" 3L@naAB\n#D(Wځ\$O\naR'\$1{CsЁn)Ue\"`=ę'\$e0T׵Su2x8diCF1\0PO	*\0BE5\"PkЄe`צT\\sM\r,P*H*I%)<Qr:GQΝ!sQ\rg!۟H5Do&AMωˡ\r~-V-\"ldbtܺ+-P,!&BfveP:p&r'9\$n]!R6!\r7H9bBIz-PZ@PJlHK-@87EXuR&xsXeԡ%C_Zݫ`\$DB3'4ҕ%	)bjW<'b1aҵPݡ}M,@(#'b*B5+xý=G;0Ndi!LNi)2R,AL q<@@f0'I'e\0kD5R\"bD7t5{3f,݆Κ(hWp\n_ju&EH˨KO=DGj9;H(E*)sdF әB:D\0gJq.\\i2:dBHp@(NI6r7̠l0ћorwa'ۜT\"J~SbDg7)nV~2v\n>eFEhPr68z 17=pDG+AP	j+kܸ4m:F	j~,~Ez3ZqؖA=Wp 4E?Xq:5}+dn:̈aGU\$aqdǙ&eT2*Gf'3pu<LFm}vtJ*]bZŊ0q8)Ӕm^z_EރO]kwN-Hz,^s6}]ݩ>}H|Zݟϫ(i[Åu9Mz̤E(N(я.\"8[,_eFs/QE5DN\nC_p>寰详ьp0HKLacHh	*o\0P?\n_`%g\0msB\$0Dπ؂jcthv\$t@㢠4xB|ۭό Jg\rVUt|i5B2,\"%c8z\$nlު\np\$ӯ6\\O n\"L#m 	m48G0+Hƍ\nQ30ZmֻZֶtBBe\$%rQHCyDLvPRMb/^&HmNLޯG[-菌qL3bgqju%\$]* &-dN edf\r\0'-\\dE `@	 ĞӠ\n`f:qc\"[0-`\"0xβ\"#B#(2Env+z/&0;RX'Z@w0,nL";break;case"nl":$e="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n*э:|m0KĤ=BF'K.O8RxwEّʍ9C\rֿE#9oEhi?ȕ5u4>T@f7N%Ydh(c\$=`9{+-C#O j:9b<5\"r9\r\r2\r,N+:a8Γ2B¦=EXz2\0x0Ð3F:7!^\\+.8^k!xDV>@^0ɪ&jli\\屫*:<:B;<Pb;Hԛ\"'+í 4p[_T	cxEpH ֹ\r%#!-s]UR8PLGCx@7'7.U\$n\"Zхqp»n뾆\"~.\r.\" }0-䱈ZJ0:W\r5c䊌m(`2R\"5S>LSN^JآB(2940ފD\"*0ҡbC,2\rܗ*9 P6刣ƺ9_TZ4y6Ϡ\rw@(`ت*oBeۭ.2\n&xob(,0>kL29*xF&#:iRtd8cr,dC0oc5&IkCv%-\0Ŏ0'C%91/C%N288.㶖Ue(5 q ɯ8tg6g\$zGL</Kڋ_p	|e[B},7?3SAU	K()P s:&3\"46MB6ԯ=  /x\$_6/\rrn~2Cf	JI'%SҪWK!-T\nc\rɍ{XslfJjvO\084@o=Ɯh%˟X8\$pКGC02C Ӊd 9A{w(#Hf=qvG2G8\",)AyDp\0]tK3DzP\0jN3(nP3fLu q	!E&c]uhԌKS\nA\\1%Qj'w\r p~PtsgR4z`!čb̧5퐇WŹ\\4}&ړ%pT&(vRmx2NAq| ᤔ\r9L1 ^aC+Р`dN\\&F	A-jf\0&V%E5pM0h\0P](g(0\0a*b\"8PT,@-XRӪxa69rfINX+J{2!<6.MtlxM5ew (dHfPl%S\$\$mWדdVCY ,a86fD^C2+.'C00q&\nJ^8;j>7jL	%SL9LeD2m\n>U_U13>+(a\r,*(`*@bh2yqƺȅ@@ !ԆI0,,h%_ϔd4<@~2S\"s`r\rJDy\0\0\$tѨGGR>pQ҉ɪ8zy<˿\$Fi-r&j'Xg(tΛBY4:jÖ\r`F(ȕJC.&g-Sc^)wH\0Ÿ]g[wj35\n|PEo#BdpTCKr,b\\S\$g!zC&8-DIxq{F{T]E`, W)RxxFJV9obCdT}%\nlZT^#Q\0J:᳄0V\n@PNAWEEr8d'<[yD(X\\v`>[,9k>`ŃCg`|8Wmg!(QZ\r}mf~ZIEV\$(6J|}!2)\$@̛*G=\n~Z9(x4TI4'\":7୵6j?q6<hHw?Txc\"db90]cSi)t\"a\0p,k\$%TkO^HjA#\$j\rT쨻ι\"jok0^bs&d\\ɱjaQ#\\ܣЎf\"Q,ǤWn\nxOFм\$W_RP0C,t\ntY0p0ԉZ@,H \$\nH!bfGjQ^~)>sJUM+0ar(,M#@!j\$[ET_FRT>hr꠆Q\0ef=&4(5	Pnك		L\nZ^T\rBUB89&\$sl180`1ƍ#4(\">\$/nkPfBQ`B=̔\$ EDYUX*1&/Bv\\F+8.#^;iB.Iv2HS\$nT0\"JR.n>;&:%Fb2n8)>eW_80rl1q,'E*R)a)\"B~BǇTXG\0zB[hefNœ.\02b+e?U*<6D\$\r,E32w'cw\$4Osm'\"S(^v4C*t/X b%G,/bf";break;case"no":$e="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+DyٰG#[NQB<ΎC#0<2.[z?Ȣs69k` jءx<p:kC0c>.A\0@2H4\rN`@EB|3Лt㼤1p.9@a|z9qJ(|63-f7^0H\$b\nʂ\n:<#X:+RՎH;T3T@'.#\n7-8i*4M@A(C@Յec|(A8AZ6p+Cz5\$\$0:pD6PT\ncgZC8[Sn;-̨0! P#BC\$2TeصZ9l(haxtmOT5̋+!.;oN\0ވ\"ވD0:P\n1h˜\n6\n-'lH\0V[A >*r\n.{4<\$v=Brab:\$7g	@KaS78ʲkHPZhН-P3b*3kz(m أJ95\rx1qmH9ʹ+g|NؽR\n)S؏(CdGCbv89o&z<8aYBRJʈr}\0*_Hi#jOJ)M*nKtșK`/+9ͧ\$j,07jp8j'f~:1pNɱ\r;9Vd{&C2ihՊtxBd@/39\nQJ+P!RQ2s_^K%%ĹtLa@A5XA @\$\0[L(&PRSH.,fMZ~EPn#䀍@iavZePCa~E) z٨a0dfM2TK	q0EHJOSP)E_n|ҋ.п*BAJZF;1&-&Jz3f2im9\n)}7-1!dA<'QXp\$B>POU̑#ܑBDHScM0T\nTd)V d\r\0\0g	*\0BE@\"PkWhFq5\\?1Ű[wȓ>Hl&E7R䙉M+Na\$>':{h;f6`PY	EjXrS@\rOM6FH!\$ʟ	*i\nYnIEAwrG@J`6*&!= Bڱ\"*JAnDB00(X:,i~A)XFk\rc\$B\nzVo(t@2K\n_@y60umoCgP*!J))|Kx2o.'^b\",fg8's\$9s3GYfQ3 49Od!Lc띐sOۺV=f3h.@JM!tK%!.rP=O(H:qZb:\\2'ЪeZp+U*hڄТ1;&3B:_AK2jm=ݔLY@HUnwӟoI.xDYi65\n?ej+j  	h0(ԪƄ_\$M~T)A/>Ru139dTQ.8I&g;a_t\$\n1@\ne !Ӣ+UOz}.Hc	:ǭp#mgY@*|mG7@V7z<rΙMw\$7»t\n[Aw\r`/ip	KwNۼN~Pn\r!LkCfU̱,DX\rViL-9zaJXQ%qR'Ɖ{SKk~Jl6&3l%_=!m(smE?ڳhm1,_,O펀%/BO<m/eE)vl0SE\n`GE	ZϊVFbZ\"ް\0Lq/\0oA\\f?\$G( v\$F\$p!}0eEz *Pᐬ#\0000v@:Є?\n\"a'p>;c2_PPA\0zw\r*tX\nVDE04}7dj	evd{_@p2;,k-q-/oP\0`T쮌#J45Țt\n,\npug<ޘ@%1\\ޭP{MQ\\\"ĵMt}bbFW	b8	Î#|8qexnpæ ǀ\$ ä	:bc`NlDc%\"KK\"w\nr\"5&8\$Ns#Nn(6RY#Ü\$Bf2+y2!#o7Sথ#1̬<Eϐ:odC	Na M\\&mjGBڲR\ne!G0_@C%+le急rr,ҲH#*R.";break;case"pl":$e="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7,I()h9<	3\$#R7\n7#ݍxcK+5\n5DbȺ+D7`:#13¾Pʡ\r#7c2\0xC@:t1xOx*J̘^*^7p7^0ʘ5)D-9[`-.CBCM;@Ϣ2C\"40Hcx)\0Ƒ\\V(\0\rCeYe6k*;BX6j\nlj =P(bH13[JrcjPM\nG%#N(3#<L`P2Hz6(oH0Rz6a\n1`Һ:R:=L 8oCIcorH>n>\r{X(Tn;K=]E\0N]'b4H90ت0j ykIb,CDz/F(;%j̊;#HؾFCk}i!\$EYp/Ƕգy\n)%(Hx/ϐ97p~l*2(3	\nQ#-H#9RS}q-26R*\n<(3\$QlCw9DPrp/\r/J˰ldbsIfŮL!̐5B<H*7_4MؕE2@(LʦP#KKAZ(\\M3&0ԇxOL;zhEb!ezQ1>(Hi\ndQ-`F#FT\\L\0ƔJ!\$dQA!!RH	;j&,ЄIIAk2W\$䬩i.%\"fM	˦Cs:< S}6LaaTR(R9.1N%@a|!A&0\nH3RYNtVjC \n (=0Вp6dr\\,0b?H!:XbN5S\"T\$'LNz-,QvQsꔴe[>u%ęfLB;%0]1'i4\0PTL+ѝa2v'XTNt\rIiҪW(A4ÒK0{p!	3TȀ aL)ifƒrX0h.Q6㌓`G5,=16 eK SLT	J!)&I)!(Ց.rq	ɈOi5G;-la.dF,[9	)]9[I\\\\n\0`҇@\rWJJXk5-L&Mam.w#4N!. #JsY.lEI3,nc(\r@Sd\$mer;mӳaqANvl\\ 2g<80sbO\\\rekxɢ2WDONŵpfmA7΂S8D\0TL<*'/7\0RऋO.\$^PC2rޢ	M2bq<Fdآfv{ƴf`6*ӝVBpJa̎_/HIѺkʵ7wKEM&O:w .N#\$\\t'zBqQD,ɥȁ(t\0001ME)cvo5H4\0A\nP 0F&-C1PB*DX/+AZ%uc̊W== lڄHgJi#,9#gP/\"z-D<پLkZRL{DX&12zKQ)~u/ٮk}FFc:Ǉ=w@i\$؏y&_\r2ΐ[#\"a4G5*|O',1DauU	દ^Ԓ.@I鬟0J)#QI_G, S}H`'9_%j.ln򓣄?o\0L\0S@'͞P\0JΐFfzmt(05\0ƌ>\\?D(<۰T0FuCNviD@\riRr^/(._\"@W4-a	ÒapP4`\n(ns˃\0nԫ%P-[( Plg`R̬t_B©CPƤOmP)Sd\$+l@q\$ \rE9q6I\"j\"CFLK6TLaeIm0[O\0Z.ެ7p71m\071O-#*hL7fH:f6Nff%`ƈ8BK\$v!Z\r|+B_\rz\"zY\$@)-´/%CK\n\"1|q`4qԄl\nDy\rɬ9PqEqO&%Jڍi*rdR|J1-u'(eR94J&W6h\"W&*ҠjQ	l2MugZr%|h.f%=C8P̢@RR+GlN~\nFzH(+-'#1'(!m,@9C492@DgS-4SI-m\nѓ553JԱC߃m2)2A&8S{:>T%ZvSW63' \"=R;A@AҨ+;;*Ӊ+A3<8>)NdiB1q@_3~MU7@.V(R21\\4.kAYt&C3bd%#T.!B0#.C/^Jtg2F.FnR`*>Pgi\$)ú),.1,*\"KSb&\nZl=g\"t,(iNLNLNj鑒2+tLb@&L;\"*.PtS.߆IfC<5\$DIff;GPIHX@SXc[>=L-ۂ E|G+EV0Zz*Um|P}&XbX	`8FGuW5%HTͲ;\\&Rc;کtG6B\$>rg3D/?nWZ. t%%B\r@ÆT|dGO[ -~ɕF&0(EcJPMv0̼GF#X͖e>e6B\r6Ě- Hq:	f\r|[PT\\@";break;case"pt":$e="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stL@% L4\r\nh:T8s㫞pȔ4TX.pǉ\n4n' P2\rT:\"m< c<ܰpP@;#\rIC9430z\r8a^h]#r.8^A,C ^*΄̺'{|B-xƸ0,NLJ\r]21+ѫűU<9T,;#\"<̶P\r:(!٣#8C{\0< HKfM~7(`\r@.\"109\"0:l%J15ec:V2H\n	P㋆6b7؟>|\rt6(3~bi6jr \r3157[z&LYRUlGIq@9)KIdLb#K\\wt\\F\"֔+d#Hߌcq= ?CB\rǈkPŮ@!L>\"#3)蓯9%oY%k:it2cYMRKȸ,.%`U4m*Y0I\09N.S&;4ٮ֠%cgi`\rӐ=afMz~zcm2>	{êGd.W5D.\$0@EMP+CaQJfjur]K1TΚSZm#SnN%(Iq&uE( \\)H?rx:Q#'#N	{䅅RH@7-=fTQJg pA;:3B s1h7huvXˆ_,.A9Vn\r2L\0\0\0RI1ȁ+H#q-܉bOR!8%DO7)ddY^MBS\nA`bzD1>,.&DN}9QH\"1\$Ÿsy~ -^ғDɤA0ܳR3dAl@>gcFMV\0¢K0H6.:++`HY.7u*<<5MElԌED 6f@]+Ghj~\$H3L<3NI%\n'\rEcYA<'\0 A\nPB`EdUV0(('U[&,\0,!FTo+\">-;y_Ħo@Nk^P(%L末rCq]05r@:\$3'T<t(W7M:qؗM*\n\ne!\"}0A]9j,0#&++R7L@C{S&,ISig#\$FŃJci\"iZV@R+cfj u_^ʲ5\n\"(]%03Z[	␥5L +M7Q1bjnLKܑ-CMC	\0T|*FK2K\0gZK5+0 wM\rAß#!3S8@NҚ8StW\\q'	ՒiPLW5&9^]0L8`ٲ^[Pmcӷe( `E\"S%4=]Tk{ЫO}jd'g]U)Ã!DCygT' F:	x{]xBy`\"mOI,뢷sdVڪ)5M8yuttuΟ8/&3Ug?W, Q/yz.Is6k0{4s7)q>(DPUG:1dWAFeu\$?0g?K\"'17~uora<8Qn5>皳^iLTuy['WI?J2Xr/r0mGWq1(9{p0\\!̣5բLhuĩ-[̸%<ȃ#-:4\r0կDRjn@ϺTN#UN|[`Wo^VU/K*f/`*\$n'\\H)ch.@O9P.K	|W#\"\$K,h6BHX^qpΐ\"p0TZ`B:mp,ic\n+ZbC\rr\nketsbrʄvpʯ(q:Gpq%DˢR\0z΃Clt5\rQjτ:tp\nm[(	\r>@ch ܠqV18Ph\$#.\rM6Qof6R.?E0B3ox-2׏}\rVXc*!D|`P3+ZN@6*j\r꣣\npu1g'\rQ	m#\$,)8#Đf_Z :묌.jon\"хcb_\"%p	YD+)DN<Z(IFE(Vʹh\rM\\.Rfe?1(6R6H'nzBhC^6O0^H2ѯ덷.(K.}/ E9rM-U\"6&,te,\"-Μ<%:q*RFFkR'#AZ+Jì#&R:/&&18/\$81.Vv8̦[PL1'<+l:VX.fe`j/*\0004-\\F";break;case"pt-br":$e="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM83@ij;êBVB¤+92`޿x䞍Z#\"\nKn؎v\01I\r1B\0(j0p; X`ьD49Ax^;́t7ar3X^8IҀ2(7z^031,c\r@P<nCA\r4@%\"7LSTMJpޯM\$\n\nx8-6\r#7\"\"2!-a Ո6\nu\\UA*7m裂jƽ=0:!fCkD:fe9Zc%zRؠӌt(0I\r	VC6n:7h*Wjw( ߔ6%2jii'ʨ(SO4E ѐ'>CPH؏/htJbų@\"^0 )/\r;,=P<oH43jB K(\"3p@&)&1e˷\",{!ui踈IKk3\n#T65{75qc0J-|-)pVCtR1C=l86zm`oÄIyc2ΒB9S\$\nYCa)@0a:PZяv[eG4IrX\0?\0\\XKIq/&ęfE4k%%m'T[ٵj	B:\0@á@Xw *cv_\rL3|2l52NBh;@JItG9eH I{L:b2gCAC0Ύ0ëM7unH\n0@\n\n)%EE HK	&%1'E\nOq=zQH1~_i'yS1|G?) ñCW|!ZuHl\r\$)9\n'QP!FI-ESCCP}s3V	I\"դ8Ѱ9lL3kF'	8yxS\n 2\"zT` @C u!9AgHHѕ2|/\0!	'ݷ5\"f2eK\0F\nm܎bHf/L90rq't&QE,7%@BD!P\"P@(L;sbTŅ^0@<| U_Ax(@(G*vU`(\"^{GӼMC4	[3pCJ:\rC.\$L-QQ\\oZH\nvžBhV%ᤡs>ߝ\n-OTd \"+;+ygĚtIҕQ!+fՐl5EiKiKdVyWᙰok\0b3\0#N͜_-PKQ/x6&`;BSvnΝZkE)pr\"\\r[Sh\0ߘ7(#'|^o:Nݴ\"ڕ:5\"C	\0f񑤜oy 8`Ny](+D0oX\0њSr΃S72SoR8ܣp	{JM*њ#G'!:HJq/ҚX5Pu\$R\$Skڇ_c0ڟK\rOI2j\"8M8w\"fW\r{lV6..[taH\$p\nMuۤnӚ8y}l&1\0@PH@;Q~:1\n_4dFK\\t\r_90\rc3` 'x&s\"P=,~wRk}SukIwRhhQ1L4ћ-8:!c=&o2{OvByyY䅣\$BY0l\nl*7%NdnZw>[hӸz_]'yAԱ=3y1=:{`5ި'M߫8d%#,0fAysmۭ?{?9>oy9%cC\"D\$<.Z`(\nZ0\":%D>oC:BƦ`Q\nR-Dfo暯,κn?iQ\$8h.YƶtA\nR0#:OS/@N[.mlА0rx\r0|f\"afLfp\rZJ^(fdX#h:6h\n^O	O0/\ns\n&,-,Z2H&Z0lN`(n*]Cs1ΑO	1zQ\rNXhba\0,xљ BoлṕBBv	/-r	\r\0{-c6KG84E@qAL/o@a7#0n24c`c.@!槸<j0\r&\"D#sv# Zarʬj1f\nZ0\\c\$ȍ|PH調\"5m6:I#<\$D\$T%#0Εv\rz11\"Vo*kx?C2nH,44`rDFO\$4В(#\nDatS\"n.hdp덠Ef)&+s'+Ҙ\0*7^1\0\\hπ333lF6L\0f*bsI5	4Il,\r2.ѥRG\0lK,KN#6G,nr\"`\"bx6#WC3\r(U2Z3l3#(QW%bID@gT%dV` /V*<;\$kgfc*\n@ @";break;case"ro":$e="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)9j6If\rBpK\n@P0`L#1P+>:L7\"p8&j(2L肥i@2\r1À+CƫhKHlS\$0!\0\r\r`@%C3:x;RAr3^8L32\rp:\r.x!6C)<Dh̥C <o-UV\r5sɍ\rbANJ+ăr3`P7ˀc`8C|H2\"c @7(MCs:*Z\\2DHg<ѣI 3);/\n)ӗ# #u#;˺[ա3O3<\$U) \r\"12BV7:B8P<YHdMZl, n22<\rx2昢2v9!.律f\"Òڽ62\$6[V4ێ<6cΈ*:_CVp(!M+T\"\nG/@ m*'Қ/:@W2\rH\"JZJr/q #ցCd`6(mִv(\"cEo>;g㼌;_C=Y喴i7ho9rR9h(,A2;%h1tV	zАH9,,Aᘤ̃9:띸\nd`0+԰~QPz8*JkM84úyH	?8G,(K2:)u2Up VrGJMeQeAԙC#KxYDpzKm#rfc# >C1Cqp\$1#h`=#N;,+,ʀod;ȷRK'r S!M)İ9BL	QḐG\nje&(%#40) q)	,p\0R|l*dЛRGQ%X&♙wL78\0 0T&!Mn[F,j# `V\r'(C}Ja\rE(%aV+IL]r@QۥDn}0iKhFEh%1\nm(SvK0T\nrA( ZԨ&\01IFȜ&B2L>Ur#`/d}gƣ\nνU(&u@@uY[L(E't[4,Vqd9R49}9ƀ#fk]Ix%ed+VxAYz&t~ tw\$\0^ʔo	/QZ*ϲ1dCgVY[ΠX|~BVkxݷ@<^{c>a]Me2!΅3-kJnSc-wVCn&)m1myx3́ μqh/\\?RF) 2%E#y\\<f	^P|bY@BHi8LmAspU﯑2hejh\\z2NZEN\0虗.&2W0p	\$adv9Q׆a≔j-UI8ؐwlݓ61[Gw [w^Ɣy(}<;Հ.;%\\J[g;I[	ɂ\"oa[>+1#@:(1gi2]\\ePI+%T,C+<XaiŀВ핫8=èCJAFjhl85G\0VWa2~qǽ҆P훸C!dۺG^z<1:z΀RҷZ2K1}`(=\"%'SC	ͳڴ`bMҵ+\\e0:^2s^6B4mܻs+U+ꢫ=}i}ϺaSCQ6޹>0N7+D\rۧYHp\"Bfˤ-C\n]kJ\$H8ȏbb80**>zoxLBqBOx5F:㲭ԤB]( [	p4m\rlExlI(j]3pVEh//tVYn0pR>PFVd\n%+o.'q\"V&\r\rQ fs8)F>FȌ=@Ds\$%~\$#@nDSB:c:Vc&\0Qq=qE9Nя3\r-TK̹2\$1b4(c\$P(hP,Գ71䑬>0U02Ba!BL(@(dA4C>/=\0#d<rK!bz	Ź03G#4E(M*#Ol+߯Q9('1rgGcX/2q0:װ2Ҏۊ5F\0eW p~ʑ&7'~hڸB2i\0\npwbNCżJqrn2-i2L#<FuE:2*Evt,j	q<#4d/).>[I 'ԧr:&8\"g@@AV\"Av'f㊲YdD)8D)N\n+Ed`WSi)\n u;+</OW]<H8Z	Pl3=C*)h6&G`zFڵ0VR]@`v@J.&^fVv;_l4:R>t|bBb:Ef\$.X\r/+I 	@EfL0]r.~H3#J	BC/vkyI3>C\rm`1j)(sV	\0@	t\n`";break;case"ru":$e="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEk!S<9DzT\nkX]\$(!y&h02XE4\$n)56d+RC<%NE3# 4(<\$5BϤ>Bnrb_EV֖S MV<*\$xX@4C(C@:t㽜41Mx3(9K|h5ihʵj)*D2\\x.#ӴֹN	a\$̙,dO!iDEdnG&γ!6]C L(IcH9?3Ά7:L.ù^&\"rJy.#(\"C%VHKdsjf3k⌮~KʟJĹ8h>|]ټ:0Bhn&tAR&){>3%zDz2Q6.3GNdvKK=	<؎?qƁ63-pq_4D[҃Ӱ?.{veX)\"`ZpLJrBD\$\\KUPI\nt'V%n@CM0p \rYJu2(v\r40@Ca\r!0 Ud\r7޴a`tD 26M=ÚX YTHE(w[#ȕCxxQѤ'\"IҪgiJ6\\/)a\rN`y?E<@\r\0HGBA4nFD\rn('@DS(&|4hI~Gq@PI\r6SkX5t\r!62XQª(S^/M	8/˶%.&D%1FLRð'Gep咞\0Mnr1CA\"VMخM.,.Ser>3A\$h+?w\$CԢEŪ<R:ITpOHK#Ԗ|82¬]2~'̩x-Vp`)ӞtT	j@Q+n~HJ,JaNRF53ȵ4\\QMr&|]+ޅu7CLSSx}Ď[;*ݯ WW`5JY=he[!:-=\"\0VR;_+H\\Cnބ%ΤKC;*pJ#T2Ո4c,)i=\$pj2=jTI)A>\$v&\$H C\$-I\"-WgM13}Eu:#ǃ祃l:jm}ϛI4%z=jIsf꒟`myͻadp]ܣ(0gC\$@\";\r^VL*Rp00-Ux͕Na-K`W!Y◢P)\"y^Wq,JQ.ɨ`=j*zmo;d:!E6dJ+%\\H\$刿D-%k	Vr̺&'A2y`yGj4])=ƒT@'0𲁪\nQB%\rh'&ٟq<v-K)t1`VCXMq)ux*sA,##\$侓0T\nYH%_NniEek(i/K|q!q8cm\"gD̛Vς9TC{DerI=Z\0u8!Xy%\rw`c>g]*2oG4HdD\$sG_b.wfT`V72qi\0DR\\L((5S8UwZ|s/DuNPeŕr\n	C5be'.R%IbωW!C2ZpͼӠz'MgMk	:jgtno3-f2P-@hbΆ\n<b\0Ot.ZN\$'ˠya@gl> y|F<Q\$D(0,f\$2F<-al/JF9(F؍/BЁ@+6DJCbؖd4밠#!H@%B2o'^aƑ6r\n\$(ooB%βMNN \n`|x֍V%<bl\$.dJL\0^1(T\$gp?#';<gB+zėyJ(}T%\n)MyAQf4yoT&qrqSq}`bFˣW+\"FΌ(C֬K(#cܣQ(,\n*g1ܿǷF1RCѿ1kHbD|xo@@L%:&\"X6-av=Jb\"C\"% /-#d!i¶0d#\\(rr8(HLrpct3nfFReo.@1 ͆nJ:gnrO8N\nZ2D*%/(D.fPp褳-n\ri.RO|0w/Ri0J*ohF#11Jrd8ys?8l\$575R*kǲw*'bGtb\"+v5PMOb45LӅrrN8\$-&8L2;\$Qc2*sZ4@.4d`<Պr	1ONP30*C2#I.b3?dJ34O?S?AR1=\$OA#2*4IÂa@Wq-E)2ѢpJCD\$=mij@tQ -f	wUB*7FT45'sDDѬܓ<sEPp\\.v#*1\\ԶDL4KQuMtLTU鞳Ԝ*,.Q:gsP+&.*cf\n+d3hp0'\$5?ǈHA(J\$ohCL)ҍg8%iQBvcedH4lXG̓<	D/SONIJoIf0JUYZ.5ռ3B@|Ñ]2\0ZPܰ\\<U֊0֓[]Z_bϵ^]O_f=O._5dv#`ph|l\0!A\rcBg0O,6@MrFguD;C?[6eIL)a1b@6gIkFvTn.R.;GiDp\0\re&{aPC	jq(OhxaaLr5zcNyfpn!tLq~.E(`\"Moni5!֙hDC|>6iHqm\$.i%^D&U]n'2+trop7sRMWtTYtЁb-cgv@w=D'Y2&.CIb]J4caeUzPzq{yV1kzpClF9LFOB()꧒OvmMJ{ϟu|eR4z{4Sq@\0a7DnX'+j&SdAM@p\n;#H-!2\r|KZ\n qqh\nVhiH`jdψe刦V6ұ;w/	tUEi*,\"t\$,Eu~ӕjf,=<n{\07WPG݅ei.-j8>`\$ixX~r\"a\$#Q6Jp,ae		M44g\$Q\rQr&5&Ns=H0>&&4u=H1`ʅ_R)}b!ggmdϪ}#'pw3Yo5Ɏ)*3\n\0C-Na(i]Axj357\rѓm͠.DDf<GP|K# x9G\$z:D`9'Apy3ՒNǇÔ\rzinf&9&cGSCs#U?1W4pdlƅ>鰝lȥq\0";break;case"sk":$e="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0q^:S\r0n4&b	a6OS5\$7\n\n*8	!#F+o;ICv8.DXܢ1*͗\n-L0<a+y5O&).3:=.ϐ@1¨*ɆTp9'(\r -\n~	(B -x\rb`9p*B\rEQB9-H jȍ)\n\\h#\ra9#Ҙ1@4CXXH2D49Ax^;́r#\\x99c&21C.2&϶8x!R+#Iɂ\r<\"\nC6*\"44'OTmP'hӄ5:-C%o8`(\"B9aB708H ܏6ŵk:pbC1bUpBBH1Lr:Bwț'}7JRkíڌ|	U<Ra|:@P2\n~\"#\$J8.b\\4߂%WB<7Cv55#pʜ\rYY\"&Hmx=.#l1ɾ5mj)\\'첈4M\n;X7\0ޅǓ\"@:(\0KvP7\$:\"xBH\"_(?ZVLkQ,B!C+KZ2\r\nö*\$:zXcG*b'ڜC*NxFI\\CMkOt\0000x2EE3b%8SzCzy萖ҊSbT]¸CI)f\$bgX9EIJ)ԛJQ96'>XugA#HKa5_\n\0X\0զu&V(aj@Tj,;ND\"dDabal.(ؤrvxC\"]^\n0XȜt~:ØBZeE\$9\$B!QCyMaKq;c܍\n{Q7JӁBRL\\L)2tҚjoG:'dUnAq[4*=HPn!I)l!&j	\$K|F@\n*ްN)'+C1`v+bt+Ha:}\rD3:!Q)/2<˼+WVЅ#,21+\$\$@)jA	@()I\"9@ҺY)TDIRٮ\"d엋C 4T*g̧1x5@R݌bb\nbA/%(B&;	%|M4s`♫-p((\rᬽJ#TdFB=f\"0btAHЉKFȢPP	L*)@a\rǖ[\0zV1RJn:YrTYh jMRRFN\\3THohT`I.DJ舲\n:hBгJQ'ƴכf(Mi:l4++83#kTBw16\$G	\r}~D/b(tI3͸b,))DI@=M%iYYƞ{F6tQVR՜*{!Ñl\\F& <Jp:v)+\0~(60A	^\raAZ'(ТǕ10e:#O91=rձeЙ-LU	<.d72@.`EPC5(o`n6t##Qyb=ۈH( i[#m\\N2SK6EJ©\$g\rE4Ce[k]GxD`@BH2ǋxiѝ!UuQJKH\rkxH	9IAhQ5δ+aԑh:	Έ_5ľh|r4sŨMz]wt2LF\\Ds~9IgՒX:hʗ֪uGJ{|X5n2r\$vd&2~xJc֟~f!IB͑+M*QJ8,CJ<4B^6 A휣Gj&i{\"<C2ڡ'dVLIȀ1TD\r<}J\nfdU]qǖkjȶWXw%:y8TS61x(Lrj&,+`Y%00pN\"M0/KW,@J(htm ;x\rz_\\Fi\\c\0/L(  FHk[F\\if4B7 V`m؏.ʞRעl\\\0Q̎ S/&D&u\$pˏfڈ̥K#̩NRvF\0d\$NޥKt\$p	.ΈCbaA\r0mCIC&9ͩ1fZ^ڭ]cm\rW	\" 'Hz)E,>BJdWKbfZqF\\LرƥL\nJb9->j`\"&:QsQvd\rp8Wm\$=2m(\\Bn[Q	azR?\r\$gkq̆MlcM8:o\$c\r6o0zb%0J1B|'C&2&ҠvJDk&]f5%	bLCB-Mi2ޑ;0'P8e.E-?RP\"@hlUPUR.rZtc0F0a1A/OD4Jh*M.m\$m'rS3H}\$PSLs10Ð}sJBS&k3G{&j0,+%8CA}5)92YF>F\$C1L\\B\0ed1\0,-looꥧ=hC> ,=sBR	b@\rA=^t#RIo`nqND\rV=@\rcPvVʨ#t-@v2B:h䇡fYQ\0\npB' n=-HYR'?/Q7H`@V##faf]^\nǄFm)m _067)_wJ\"N3v<C(C6l\"r\$#D>e&kRTE&gb/KA\0f^baMt0+&N5]\0R42U=U>M_mWi&f>cfS;ƝUCZ\$&(B@ܛ\$	B'\\0o\nG<7@\nN]Yφu%`2`&`/&d %DvncDJ\"Nl\$\$~m{UL1Ve2iLF1.X#!(";break;case"sl":$e="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(֫K (a֘y2B;4B0B(0\0*5R<ɍ0d j\${4ȧ>'1C&\n0h\r\\J`@&`3:x'ʹ4Ar43(v9xD\nڔ#x|k(\n[X\$֌)+<;.28M.'\r&2#(\n\r:*!2Ct8P \0ĘMi[W\ruZRK_ז2%C`2`P4\0P7k## 	2OfB\$0bq\r:K:+\0C :	\"|دKZ9'ӈ\$&#}	L4ܣx@Bibrwyc82ƅz)\"b2 P5Ԋ7-\$ոCRo@SB\n:2fͮ@މ\"̓K\\CHٖ7	l٧8Bk=n/}qN=,hP@!CKxܭ.)4K\\?#(T9bſ%#8!1\nTHd2ڔU13Ҡ0bM\nKHϬX2zZ\\Ur1-Y\n29<C7.SS|9n<d*%\\AI4-ش (	/	\$p<q8 #\$rPJHm*tܓrm10|Chp2U8''ftFΦIMe@7B^&蛣3G\$jńk%QǰA3e*!@Hf] Ӑѣ A0@Z\$} R\no[:zX`ejx\r!ȥ5H\n\0RGI2k7ŶMKǣ?KA/PiCA#I\\{\"TKN@C\naH#?u\$ Q6DKAb`L];(1(Q\"KRTF`\n*PDɋ\$ZT3d8|1#fGM}.AI;[䔓.MO\naQr9,2ޟk㔿7)&2gTjVŰ3@D0#I6BիDQ\$[7D5\0QԂ̘'s!8涴)u:Q1TQ7<@M\$/4V:J\r>Q я1&^d˄x=	^{2Q0O'~ӳA,Ť*uEl,ɆQ\\ghd@+`V=GpCpu\r4%҉5\rZ1sC\0d@\0]YT˜GD1(\0)e@TZ1ɹ@HV'T \$Ѓkԓ@8h5CVClA(cɉ7@Ϭ[b>\"RCvb\r\" n>N	Kɨ^,\$݃x\$|v T!\$\nPD8\"GL~'	5\n_~0Cavf23jV'(`.c=eOWy:`4VF/?\0tS0a ˛Y4.MCisv.tڭTN3(cQ(]e56{]ji\$.g)%3Pv^nPOl7nt_\rcRnIطtmnE)ap	:u<He:lRX>mT'RP	Q,R|0vM\nkӉEdZ	y`z}uSJOF\\:9ϡ;1ZLhy\r9N(1\\_\"B~PR>\"=WWl\0'aPE/oYu:O{:7Q9toO%Jvnbxv/]`r[boZ=wn-ri?7ڣSu֤E8Z:D=kCz>zDI	|\0ט7\n\"nϋkC	@+̓`w֋贁P?i jy'\$ƅ>/|;I'U%/C*enzWW~SBCbOrMMX/\rׯo\0L/OU0힒\$cCvĪ8+]HӐ4KPQPVLTI06Ch^p6JYO#SL=rd\$`*b&J*6iyJ^(6*\$Ȣ\rC\$cKGiTn~hå&^Y%YjQJpOgF0:B\"O1'L[NEPi˄~l)fN%%䅚@Oh0`1g\\ϝQQyя}SFRj ^^%B0\"5	%dyȞO&dLRbw5B	MLxq;M0>þʱqFyq/ѓ\"#\"qq,Bx/cb-1Zb`/&QBZm!CzhR#ط-&GK~3MZ2&&2%MÀd7ei2f&1SnѦO\0002<-.)2rQ.*'y`jD+\07L%(	|6\npqd:k,-(3\n3KM}4}4G2#4QM:en@/` \nN\0ɳʩ7J&kYiT#bܮj4S\0000^	md D\\c/eJYc8\$bB*beSk<ר|'*6'>}M?cPC2y%R\$4 @6Q\n`O~%@D`E|3	\$V\"Bt'\nJXXJ-jЌz\nLD`\0A*-bK.jnU#Z0b,8j6E4_@x41c?@( #TcKln#JDR.E";break;case"sr":$e="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9<12?b0QȧsֲσT\$R&ˋ`Ϊ\n|%8	!?/,nLS L l% 8Cx:cg;#p3#;.w>8H;c X(90z\r8a^H\\0ͳ|ix7%JC ^-07^0γʋjh#,!]\\(\0Tl]-򽢂)w¸9\rF!84߁Ȃ3:<%9c)GrL{! j{.#\n=%:0d;#`2¶~?i5HW!;r=JBɕp笜JYrEǮ쫓\"rHII3do2Jor>Y :34?%!gJj)*}w~C`P('9#ԪǦ*0'ۧezcYn̪n+1rqT&M*۽2%T C(88dzC6Mt`\"#BiSZ6bx:ĩ)jC1iOJ/jF B\$I(f8%\$^ n{𨵊\"da1DĬyE*+lX%`\$ɓ)	.9FɻPq`1k.Cb(9=::\rϘ1&)9',t}g\r>!B]\$D6W^ܵd4H\".M~c࿡y'\n]x\nK\ny\n\"RTI׃95*p\r1)4TJS*T*0Y+HO\naZW\$6cbYMΌ!`p+\rеJ)Qr\$Cmp@y&(AP4_1r\\0id?@΄;'B 6#Dj6G`d\rtoIH\"Tp-ZM( \n (SL[/%گOmQP歓 e`g207CHgT40RPQk(ۭBS\nAIza<]TU+J	^RֶI(CdX\$ݗ ƹX^*ʠ@zJzƥIh(A\$KYsqia;ddAUԑYƇ袩#V6xI\n	\n<)Jv-弯 ,OE#i\raJYC[W})ř)蘜dzC=gV\\tߢP2NC18'%B`QCn~U=իqeG8;+u\n}IQw\r'@BD!P\"\0Q)HH˯Oq*\0c@(L#dD\\9B\0Ӿ\"B|\n\"Po\$pǵ2KyHT`mC} s\"A\$pDcFD*It#IKBZP%7|F*.fRl-VtZ)rT\"E%&f*;MD犙lW\rib3i[rqr:sID	tM͐iIx\r,+-\rS&&kۗyLF,m8leYA=45kL\naPF։\ra,g佤𛆈e\$fN]t/'DQeMnHYH)wKBS\$SN/\\ċrIɡoem:gwQ8h&nQBiIQ-DP3(:p+X+pQ9#{_jk\nP 0.0\r)сv{uOˡ'v7~6SHftDZFSu;\\L^v;WzHP\\Fc}eW1~m^CC>xḡ_9yion7T򉳼Y妞PU-O\\\$fO~&0x.I.\n^P\":@\r\$NdFَ\\sJ-&֋bH'dBP?, DjGpbxb.j )T1DxLNN(x	g bHPF>͠[l&l.҄0[~\"Ύ\r/,,	@D8JΞHm<&&BVpDGX_dLЅ\n./Ђc<0K4p^]c>Iq?.qV621,C7.\$:|d\nlN@F@8ne奦Jq%iVՑ[%\"b \\?LZečNtmdH\$σ(qnMRm)k! h [ \rb1!'\"1%G,&Qo?#-HgY*_\"\"*Ϛh|Do'o'4ϯP6N܈IFrxxOR&ֈ0uKNQHn1p.,-1+%-Ŧr#m-rzB0Vlj3\n>0%'\$.-\n1zwi7.¯1Ҧn*8Jz-B0Mo.p>2~\$tqDg,g1llRwr}6!Ml\\d2^RC-t6s^nmOz<-b2-n%:q\0S=\$k3@b\n5Ds?05q\0bbk*!K>[Cq%r-nD>ӳH-njr\r1T\0H&\r\r<sGj-GHH1\\P*O-9)^D=ȵKE1-;LF4h\"\$nI͈4@I5s>H\\&tPtPuL\$9PM?<cDҐ*(WM%&H/m>/ATr@X,/UV0c1[,LKB%OcW'+:Ҿ\$u`t/w)H.'Q[P@`@fRn`.549+@IE\np\rpBoWtl=Evwr*\\,eB&.X[5E`M+.9%Ge-k3-!hfoFѡ3&ՍLxkhJpx64mn,d_\rq@Vq@LStU4qmVq776v!4Imvv1,4(pvڇR\rl31\"6e\\uQ,&ShP\rHYJp E0vt^2rq\$V37i,\n\rE)fHjڭ21mm>m\"9K!n)5gEJC1q)Kv7Ξ44{8P'=O]He~Tz\\";break;case"sv":$e="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6&<b2&')Hd7#qu]D).hD1ˤr46\\o0\"򳄢?ԍzM\nggfuRh<#mw\r7B'[m0\n*JL[N^4kMhA\n's5dymE8Ye*	(8Ю\0000R:\nX0ɒ.h܎6z(감4((9v֧A*]\n\$9p@%#C3t㼜\$Q*(8^9(^)0,&px!h+!`ԁ\0P4j9X:AC\\\"p/\0l!4& <MJT%k#X\rl,ɼ1r\nCH9!]+iQ\$x2ӈè?\r3K ;V;n&K|ZLZo<蟔a3g<֮`5ئ(hִo0Cb9	A1\"FO-o(3b:A\n9#sr0B9ޫ0b cx7C)ڐB\rƼ94 aze Y:<:B;\ndd N8#[ʭF3G[b`+'kr8<-Wh2(0\r(x3Sh&AL\\itIWSrn(\r+<Qd]c[.̳cKv5?觳\0ڍ2#!C83>C-;I)Ep%_Y }uc<-~?V\r9u9T\\V\"6A-@d?чFZ\$ԫM@u2BVy|!:CH:\$RzQh`*pܕ2g/I#	5-AEdY\$(7=H> \0)I`).EѴ80iA%\rZwaW\$Npit1&:8rLI)iF\0l%7Nd*;.|KqUFG	]VIih^LQbB&_;	Ԗ@R7fk\r/`C\08^\n2jM/\rE])\\JclYxo|'3\rQ7Ne0,A! ~=B%2՟S\nR3R	@,q͟8	E\n<)@Z񬒄ΣGX|s\"mHÝO\r'lg8\$č2Qb6HG0T\n\\ֿVu2ԅ`%f v/5	C\$@@BP*PBpGX!A:Z%`?:=Wue>ƞrP\r:nntԀ抶`rQdfIAV 6[li'Kam]#uNM\"uAm靳u+]\\Ra!uwepIIiVēY0]\ro̢pb0jL6uv \n	\"\n춣\"d+tIQ.* \\F	/P7@xC{g\0JZVRQG<T:&u1AI40PlתsC,a \nd-T%YU6hP@^4i\$JǆuTMRH^u@Rm=ALi݂b{7>IkN@}=cjbh^0-n*jIZ%¢ޡ0-,\\;]>qd,OiqNVM\\l0ej泍\rB0a^Ow*آ R\"1)ɴepxFri9,a|̃a?7YGCB'[NB+բ	7_sbh\\tVN\0P)VYDjj(<LUv-~OtÅιz4=yne~Vkͽ1!֒\$̅	>_W;+]<C=ϕl_e.Gabə;Cױ\rHKY2\n%!(1V@!u5\r=ȥ:\"sXe=Q#O B\0Rd]2%)&OʩvfnMN.)\\F&P>S02B6% EU ER`\rE\r\"5o4wph\"\$.\\p #B˰pR%Ŭ[\0	/\09.k\n\\0·PP&\n>V bAiF 8l'pM\n0Pdonʐ]e\n<H]z.\"qQ&?Q*q.3B.z?)Q@SDlAC\$<\\B|( #.ƔyBv)xw|р\0C&>-vJ\$.HW;11P1hd\rV\re>@dR) Hi\0\n*&`ү0Q .z}&\rBmN.¦z>8z#\08Eʞ׮\"Ȃvm@ ݑ0fx'Bj/-0U&bH\\vQ.nB.+n\\S\"z,P\\-cABB Π+_.ά	z(\0ηϿ/4j\nMbnb%Ѕ^.^^:Ҕ+*\"xF\"|6'+&b)*/-/.q\"z`qQEj";break;case"ta":$e="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx\0O2~)#6nzZ*ʜӜSU-I\\BF@92/\n)IJ6l\"D,mEȌM%YVAC&E\"lUB/N l3 cx(#g#r@6K4@;/˹j<;C X90z\r8a^\\tMC8^2xu]L\0|6O3MCk4px!\"4\"T)Ju6)M4[5Kcq`GU\\'\rwŐQjSQwM6ʚA8b,62h7[I7c`8J&\$W6dh9}MTbCb\"A=*-})Fݪ Ny:x0ʯI h*s\"07c@7\$.]by#8zCCIt.>ar?|ƺO3SX!J啺v\$AѨf\0RUfO5%a a7\$P\nCrLޑgi2 7pU\\e-#Ә4-9\"?Fr4U4֓&ɊJm8E	h	DO{4-70<F`\0x(wY\nl@`\"c~=p`2\nEfpBWɴ\\|oe\nIZjödp60TZKU)tV!F8fb!Ua!>bcxE~>	3`#xrI<wÚVȟBIPϨW46B&͜_2՝sF&<(\$-EVݒy UAF #PC,5@)܇ vv<Q38&pmRBL@נda9Msyiczaq+H9C\"\r5Bg;iEQΎUHtU|b6AnKRDOSeI%Ƣ\"sAsS o9_XU\0WM?Wj>)5ֻf`p\r4_K0:ka,-Y#k\rbIi[#d..g|\rligǘ0ntUBQ\00044_J.%M#B4@x΍˒\0xrcʄ8Z`3;@P:H\\k4H\r[F|`9\\YВv\$Lop\n\n (Sp@	L\r:\0u;>t9 )cA8[j,@w?A`ξnl:BR ٘iT\\-afCoݰDkƵԓyI~gv\"Bs\n*&D!33r蛆0|R+?eI\rqJᬦs<25@KB+\$CK\$Z|qwdAr7نRrxa Bʑv԰FOxS\nRV\"ct0D0B\"nojmam oE/l\"941C8uOy2KiNKSUpy\0NxRS\nd=k?_P}iI=H6ַB|BJlBxNT(@(\n \"PzC4ojbu+B4\$kUKL~hJqRFY\\J2=7!Q4Ioɿ3Q&\\Q|*\nE%\\!vpx~I%+<Au7SgĆ2!ko8E2wT\"ѳN?[+7X-2q+K'=CJ_vO|gEiXM6P&ϊD+7k{-Wt?\"vA1 tcM @l*@y8(tz\0\0l9A\0^`RĨ7l\"ki\\\")BHG~ocN~\n`=sGD+=HҖƘ!P`t	zol\0ܥ@(6b~мgo(&*F7H}+\r.mNC\rt0\0pO)thzA`0n4,BbƇO`cP Bڄg%`DBvShp\0QEhmnƔ 	\0@D\r%EYZ%\0+OO>氌RcG/Mq\"'>:nq^K)<HA]!Ɨc&ƹd5*\\1(F)*ґn\ro\"/vnP\\%iRM1\$0Pq\"x	!j/)	o/V;1\$/}& }&7%#j#'+\$q+S(,R{!c-o~rʒ,-28	M z'ϭ\"`+(ϒҥ'SxNB(S\"#FGR^~蠁(H 4&1@/d4`7`D%1~S\r7*p*p2fAz)	*R8P,M,NF#eetl:Z\0=PqrGƾf^8iV mr6SK#sNC?u%rY@\r%M,,\"&A/A NEQ<;\"kP+QBS4-A1E*\n2^S#4%TCJGRC;FRH/Hp)Er <.F5*Rjnw.2M B56-SӖFtnN(Ӓ\0M\nP.;#\r<4xlF#HEIVa(-R\0+lH\"C@TP%^/d~dlC9!n.G<3JRѕJU<SXp\$IOsSRE=ZAWk[5敡FS\nz+o]cgt+MMCm&uGR\r\rt}VKE')>@mp?`_%FtFc{_!`f1+O'jYV6GU(2s4aW.ANef)/fq˶L[s]aY'PR-Iht_4OZV18ng;,25dUaҜ1H\"q<]UADH'BRy|鎎,DQ%QFIdxRZĞO06m_iu\"0l欔ȉDqOkRoө\$Jsed.d38ѯU\0\n\0L-pvFJVwi}]pj4m8)GH	fDsjW#sC ݐiv]cU,Y| 4cj.HPS5?ѣ[v~|~ԓirq&lDW\\U%:x<+u\rT{'Kz 7֘\nb+gNީ\r;\\+5߇@U\"?xOh|d&D@Q9e\rv\"xOCmO}	\0005\$vU}8Vb{^QR6m}jX*vq#3>j_/{_oq~fCh*yGD|x{/Uu-hgfiQ)JO)*y.\r8IiLuv|aWf@gh!/{7\$ڗhxamdY8g9wgS͛z{\r1Xw2sI[8}OK!\nF!}{)Q8y*S\nQ'qSWrx'Tn	ºݐpY\n诞7lہY\$O-6-rK߀8aepidKѥ276E-83d P`Bݲ'=yt٩Rer؏tN-a(oEQ=qby~UTz\rVp `֍[@wjc\\>,Y\npĒ+ڃsé	s7&08-%.W:d2mR2sWZ_oPi+5?T\\7AW\r-\$%\n勊pĠ	߱C{wvPؖpaDo7PsvAD,tKqtT\$T)D¼	\"&2[\\(WCfrxPWt\r17x2HqMӚlyh6>⍹857o}|dx{Ome\0+9~	~4Y\\qF36\n><,ئyō	m.d,,7XHH*/b|\\%w0F4ԷB'I%vn|Us5M5g<[@wqO`C%oZ/P	Q0PiUthhKOL,X\"U\"\\W'L\nCӺۚEl(UD ZtLܐ\r>lVC6OZ'\0	\0@	t\n`";break;case"th":$e="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\rĐZԻb8+q1a80¿/\nzL)5''Q  Si'qyJS{J7(\\1圔m<W;CN* l7 >xp813\rALگ94C(C@:t6-9N#8^2xuݣL@|6/|3N#l4px!,,Xy\"mӷJ!riJR\n4`\\;.8/iLƎޣ2<R[Oe=#\$Vr=p+#m`P7c`8C~2\$#\"LCIu\0&qd'q@iJi{\$υ&'rdͶoWd8+jwӥ\0P{#g:R\nt\"\nzqIP\r²6*&-ˤLN'q<_UjzXITVJc%CގXTO5VNTvՠ\n6~Vc!>J#L(ƠJ\nZB%ux>+S}MY6p-T\n % +\$y5^+EW PPpr[LJ0nM;\$]x,~\\4;W`T?y<ݭ#P\\SJpD%BB BwDv;D9N)7ICM'yC5pB)	#I#Ou,Cp<#r.C_Tf^\0S@({fniVWhh܄[~\\a(ɀ@רda4`VxnAv%f|ϩ?'-0_>+T6F\nY(֤oܫ}鞝(v+Ml	5ELb)ڤc*U:UD: N,{muVj@e5ػp\r3/W_kbn%'dbX\$~CldlMVߏ c,Z\rP7, I-1!+R-G堠1r-0j[!ҭ\\XkL3vu\r9h&k<O09.-鏷Lrv@ \n (\0PbL;B?S@\ncLJ5NUUMh (kCzC: ;H\r,ܘ aL)fuKMEl)Y^AHrn=<pdg@]w\"3VnX,.9,W\nl.bcsN8,R\0Α;H^HICY!P5+?82p\r,0{Z'<h\\v//TOVcLCK3/{Τ\\L.r&৭1ޏY8uj\"̞lnZ:.YŘ9ϖl@1) 0TN5Ve|FjAW3U\$EGR.ySa\n)\0U\n @ &]0e9P|BNΉ8){VO;z\\PHޒJmwvh%e3&1[NCMapÐQּWЃ8ᤔ]k%a6犌QX@:G-l+	9ޚxRN4\0!?0	uԱp'L>Ԓ1ᦡiqɞM 'i'mHWa)[}f[\"75_-ҾcDB*\0TD\\T9	{2lS,}BtaYhoo'v^L~MNVP?q#\$8&s2</Avs*~7Kυú5E8ɸx^\"h.n \n.^h.L<%fȆ\0ܠ 	\0@̤\r%Y	@Jx,2nGo;d^i&pb0fJNc0n;h\n.n80/\0	#1hEv'p +\0K	'ưM\nhNkC'AȦDP@\r%Y;9\0oB*\rm>2q!\n6GfEţAD	HlG\nIƜxz>%wa%&hRBj'me*j\"#fj56ђOc'sv&oh9,9BBVk	qP6hn*VGPz<b;	/OB|p\0Ks	Qy8/`f Q¦+r) Q\"f\"m *NAK#\n@Nw'S\0K<Gu	\"qzPD8Ff!\0xD))(FEh9ң)\r*SjQjig+\$h@Xq_+/}-jI*+eS*pn&hK2JM\"/G*j\np#120鯔lS*Jpڑ2*0,p3&;;-nR95P9\0/BSf@	_	w\n0@2BP>*e4	\n!5Ә\r1:r9HhL-\$-3RRڬC:iLH02U1Cp+SFQⲲpDugxL:;;M6\nj'~\r;N'GA+.'bN3#I.@>/rGA9=h\$Zr22Q\$PsO'thtVi\"i8m?<F>s/Bo[SB<ԵI=-iIrz ӳ8΁LMN/=4 O-43MO-SNO'\$s:4P3PƳQQRED,s5'th&:5J-Q~ h+>1Lp*i\"\nEXQKWXOT,PWX03]#蕗,ov@`ܱC,3wRui\r^7ZZ+]5]rEVrBtNՎ?0DGȽ/u:aeY5#Oti.QXbI3bS!JU%Y)[\"]dMƁyUST1\r\nefȁcUPP-g\"6y4MP.U6u+7g	\r\r6M,l'*|rr80pNg3DD}\0OCbpu`&S}ECnFrvh r3&UrlU!l\$\rVn`Ҳ,P85ת垲M\np\r[p	<\0Vp<*k@v\0g>9 pw9H:L6`RD:E1+W4;|+\\Ish	ҮF2[H[g }F|yuuVggr╞!^H\$@R\$n6\0Lg?#7AEwxXS[+Ҍc=ln	X/NksNxsU/+A\\Ml^vFҩ%=&4o52TBy!08G.ACs\$eV<\nŬ\rH_dV6)_zX-{1\"wz|;d:nU򦰶E(}2C0s9A{M	qU86\r@%&+S0Kdsj 	\0t	@\n`";break;case"tr":$e="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78K')NgI,n:]gn|c7+%1>ň#(Ħ.80 ܏*#x9\n9Ɏh03.H4\r.8FC`@\"@2D49Ax^;ʁp\nH\\zbǑL~9xDjJ C2J6K| 2`P0	X֏@ȯj*cJ:A+s'IҢ\rlbb8!\0蹌c`8&ȅ:!-s-H7N਼:bJ:PW0 PbQT OSB35#d5Tk(9OJj P#떠=`.4-Hϥ0Rlc8oȦ(\06C0ϵN.>/%5I\0@Qm ã(%Òz\nB;.oTZ;)2IƹJ\n\"\"׍\"I({VZh:cюb@Tg>VC+t7p.9q\r\r_*!=nU>45	8`SؐiKCY@.FϣP::fhɷ:O'_x	#vYW1\0#u(i8<⍊x\rMW_#8&BY\rv8@3#IrYͧla.\0v,ArW!Bp=m\r'YFީgE\0`sYl8Rl/3\\`#%@O,3\$s@ᐼH*@|\"(E\n%\$dbNJ	I*t&Kx7%&L\\fM88|vTјBHnHR&ȾŌ\$E\$`ѡ\r/Ɂ&	,aI\rܲO`{ᑂ<J#ɶI«|\$7\n a@\$2T OT\nc*_Ia'\n&8EÚ<2fdtPL( \0 !&c];a̓uG1) 6Q81\\.`!Arv|qo\nDEX!= n9Mqj(\$7sfdQT\rA, O5#\\fqb'l<C^x3@'0kHHM<w[&Ș(XHsHP{v?#@ӷ\$\n:WWau}BLU*G\$Io)輁\\qp:\r*bYQkIΪK()g@BD!P\"PsD8\0ThۜB`EkV^D[*-ii\\=5I1DqoB33PYءpo*x0z-aoRKʨ(dYҞP\rr2(oսIA>ePc]>ڈȢmN!!83=GcpĠAB~ªx\\р?ۥo]8Á\\Fl[Bj%射@R*\$[d\0ܣTb\$r 7QK}3cx\\et3cU6TDw07!NPTaj<\0o\"]}g!.QfnO>vM0BH8ae1\0n~L)]yW\0u}V\\Gva<T7\$2\"aYU3#,	ih޷rbaw0sx3Zv^\rlRO^RpQOVK!g&_y\r_ֹ˫K\\0vH4\"'B2Mz%Ka+U'	[\\>4\rL'JUW󔀠+oKlӘGg^}Ey'9AzBsѯ/8G94@^#)2w;hD-ՙ(|Ő\n%/zjUam9ŽMC^N _EY\"5ڈF\rsʝ6QBh1tĻ?0X0P|éSU\natpߙ8<P߯₇衇llf'l,-lErM(5	>07\r.)ߏ4K^ʃӦ4:0DJ0)\r7NHCL'B(dEUZ`#NHPxI|lE jnBi)\nPFӍ<˺AzRi@ό\0>4CsHp.؅pPEF;1\nQ3X9c\r tn-cp\"6H@.71\01oD\r\\\">xS4zD#\\þ]&cO@bOE/5-/\rM/I	`Qb;D#0R-~|/1:.;hZ?1nO\"#	j:mf`*Z-5D\$H1\$ņUE^00WP]b8(-#Q0>O\"h<.3, c`%.\0ve/帧&\npd@>j	\$sLOKPk(.Z-}2^0Ol6lhF\"VB߃0\\u)&S6mV|w3!\"&b&#\$t&OȔg\$6G z'6hre\$.P/@RAB8tt*xQЭÆd٨r	W5LLCd!>dϩ<~C\r`e\$s\re?(\\Rv4E/B/\\_t?fvqK0D`QL?\"b\"\r>=,\r`aXeE5";break;case"uk":$e="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZk7*M)4/55CBhഹ	  HT6\\htvclVYj׶ԮpNUf@;If\r:bibﾦj i%lh%.\n{;y\$CCI,#DĖ\r5X?jвPp`ͶJbDbd*5\"=[ލLZ\r>ɿΩ2\\Jhq\\V^0..P2\rH2K9Ţ^媊yJ:D%rcd-6k2xX@4C(C@:t|4%\rDx3(90K8}1h['B/|\$i\r͈Ħ0'6\nVTM#eijLXtWr4k\0BbK@JRD`7@:\r\06\r#7#ȉė!.sgl{ӓR;I)\$=4HC醫{l]ʏn!scQ;̌'ʤPjE#V1/0f:/L5wA4qhL-QL0鲄%sbFMA{Y'@)RKN:LpƺީwE;3?@P(Hӛ[hHt\$`4	&8t)ͶA(T4AC@@@s\r!7\0EP\"fZC !0Cl2c4g!:?<HІ8}/׎heӺ4	4 ˉ1bz\rr驹:]H! f+,bQ%*負fܹ*:E4\"޶x.}<Hb:2iy\r&C_e&9UhI\rQ3 XEHa\r*QtqdYΒrӑܑz9nlJ4J/cxu\$W4W%qq!h*\"JhB\\A\$\$a\$v4ieHARl!X9.A0:a!E\r3FiΉ 8slէIhre[<Ğ-ϙbf):MMQt!#\$PfӢN{#Ы42'EzIDK ⋄}%\$ސ\$T\"5B1U҃vQ%QUNqt_1\n#`G_E,uƷY]<\$jܩ	 XV\\+xXP-bu,^\reP1\n(8[SU{>x*\"gLBtH\\tU*:~R݃,ԓGD%[pJ!˱>eDPI6*=li֡u\"YiR[v\$QТUrZѹ6un4FcѾ?\0mmՀPYM)`W\nwR9ZT-b~ҒkK7)JNI]7Q9\"@.P`@NoەpF<ĀʝG&tvyɵ.H\\ ӋxbT] 74Y0ziQ=2A|+i5nj&J9ineJYX{6>\\=l-QEgywDA+9h~)V[4b9LElDqi'@xS\nr#&kUbhBA\\Mm%1S~8LQ9H{:WRQ.6.\rb:V,E\0F\nA8W\r08Vlwr4/\n|ueH^T}Vt3qSLCOQώB&kn^DfSR_ԶF㲂OMS)vnYe\rJ	l[ ןPBJR\rmŻyTKZiS^YP<j#7piC}:.a\\ 4m|^J9T]R[mRl;Țm[E@Q=7ekkrO7WqKM8	sZ|R}<fFX;U&ƃQQBsa1`K~Cv.9'2D Цe~'Co!om	Nb\"j qd|i\0%bKπ,+lm vCML+ꏢڇȆHfD_bx*.\"Zrאַ{Ltc\$\n 	8\r08Q*l1L6~\$.zgpaEhpJä%m0\"\rX;+#<\$\r)Zi'\r@pۊ*껌~P7&6zF\$(|q\rO\$nPƐSF@;xлZ))Q6:e0|m1#xg|!eT4q6Zg`1\"{&A/-awb0[QƑiv4	z8lD>1.o-vgp(NCbO5f8}Ko|h^:_\"p#RpwbJzdD-O̎*wRbHhi5I~0HxCorԒ!&-o)I.I\"+*y5jbLBT.F\"e*\rNf2j^fzB<\$oO,P@\"Oz\$R/\"B>#CM0jEna-#ns,mV/)|Q*j*e28/\$@&@b lS2.t.|o'rrnIn7m4z|ucӆS,QpIS7s7C'piN\$6#:\rR\"1U\"oW*K'*i<,qk=i=`!k><SI3<@i>q>0R;;#\0-.#AR~AE\0ʾP24+qA<4C\0DaA>:5b({RBkH*n2E2L諣LIHf(|\$6SPIH;2lgH:plº(JtctqDt^bL!R:*(qrN%P\"5X>FLHg4I42a+K9ES8/St}:̯EhpPzݰ+TObQ81;5l+CFAWUu`\\uL*GW%H}\"unbǂ)iı\\jdIw3&>W\"*Uy]+]S^o^5G[F=Apg\\-YR\"US`w,!pUxaJ \$D^Ja¿TS85\\PIFG;6ae6e_YYK[\n&J1bQ4*UnqĳcL@5^H!it6+CՅ;6bp.A5gr̘4[[_vF\0J)\n`c?k\\r[Bg=₢v(\\epskqM0q9Cad-diOD[D,(⚶1qBM)At?3(\$q_f>)SvvX6kvG&QJ@u\09+\0;lWK\rAׁot-Nm4\nq*p9<3}9l셤_9}xq~Ӝܩԇq\nΗ-ra6%CD7BRBTA5Pv<Qzv_ޛrgD!33Vib/p¢,F3_)rKt1\n,<2#AS[;jس,X(wmO+wH8VZ!+-:cat5Gth,}e@@V .Q+\"bY)1%.!rԤT9DRmLmO\n5)<`b==\n`Ô>sE#8B|ՌWD|BDjLCOPUx%%4[1\n~8ߛ޷O}c(N1}<gR5I(\$Ј8\n&P4";break;case"vi":$e="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7ĊlԶ	;l# \\	Z:\nzT\"Pi>2AQtV\0P<0P6( 4#p k=cx9c|(91cc :#9\04x*94C(C@:t2,?#8^2|9^)̮7^0p2oc,6F;r\$V( ƀaHk(jxed_3C+#-8@cނ7#\"2/#2Rq\r	B4݈t&	\r*Ic1\"OC6B6(UBIR<QŮRRvTDܰE^[UjSQzpMRz4	 YK܄\$(rfV`:eLv\"]:evfLئ\0(PVCcqf0] )]W(^'{kmQvpJHl;-T\0މH04Ɏ42΃#7\r4IBQd+Cx\\]bm+`\rå?WDI3r\"[\"utʤsÐAH{J<^sҗcG]~H/A:\nfؘhHQ\0ڀ2 LRjE2̬K\rxPR\\99y@:\$\0btaeCi;N3UȔÐtI&P\\d%ƀ-H#_\r;\\CY~kd\nR s`d(a%ȔaTwРxT\0PADLvPc EB:Fބ3n6KjBX]!cdZhĵ:tP*\rBu菰.Q=HWΤRS&aBLmTʢ.3Egj*\$mE	4jLZeO f\\y(%t9)\r&r:M,jB]Y. 8\" --AlB\n\0	(3DxKbqI)h)RDrXn|RZmM9.@Fp\$,3Z\n\nA(6`fa\r2)%VꃇI\$tLH.\0:@PأBH-NbP\n	[tC]dBUVI.	\$H< W!IAr؈MBKB7B¶vIpDD*̒I	Q,@'0Ng'2Ux^2&dvxJ \"J(m?l3ށU' 9EZ9/>٫%/2ڲ4u1d&X L*H\\9/3!T]ԄaΑ8HA/cAyk#aG*kb`.^bl+oD*YìhF'-&|\r,l\n(ϡf␺±=x)EaE:v%^6ɂE\0'o%fM.i\r¢/Rq|i|BAr-a2.RYq@WX_yUDBqLV\$kH[&hr@i4GUB^ԋ\$]L̦dAI5CTD\$\n#h<4 T\n!R\\O1Sh!\rB˻3BJd̭XQNRnX8Yrq51ɊH)Z\\	W!\\35q#\"XTbVE#!Cȣƽ%6J=Xg\$\\;L\" +c5Rc&1LX5w^G6W=V]~/1mi.^3oL+t#Y&^܉b9ATz+DրHIݫ%;A4o3}U\rpwQy+`\n(Z.sdD;T\"PR\n[G`@Elb]9E`U~;Z\"C5lحf`]ܭfl\r%%fjBo ~p0@I c\\.^6.MH#wbH>\"\\\"؈pzm/y			P	x鞱H.C7.B&\"f.BNȶ\$pz\rVOt:bdM\r*+#\n-.R:dU\n0nFp]HX\0	LP0'bbEoFyVKNo_mkCqxœvmqe(!_r#Ge!2\"\rm:%zv'\$WaY0/DHj\r#zC2oo.qJ[q1Qm*l9WQc\rh0o.(r\" CR5\"i\"͠GĀXtQތ>K\"m&._QR[d&&H0<hJ,XWP55()HZ:N#:¿.\$Z)\nr\\ps%EAK\r(VG oVr\$/O4B\nZJ*c&3\"@nf|C\nkd)!R&6exIdonq%hUEX_\rBD6eEyLr^lѵm\n)U(s9;5\nȣ,K\nLёC|QO;'@7.>*dv8S>Up Y`Lh&@Z'R]!~x%򐹎NxDmBLhf(#?jtɖŘݬ!rE=FbנʎC\nmf\n3'gqP\$kD@FiH(',\"\rLr\\j#:nGJom4QD";break;case"zh":$e="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*-Y(eȗB+΅FZI9PYj^FX9P2s&֒E~yc~#}Krsk|i-r̀)c(Cݦ#*J!AR\nkP/WtZU9WJQ3W5.\".T{D-(Js\nZ1H)tIvrs	Ap2\rH2GIvL&\"s| K̂N'+\0BI1g,\r3:x'1\rCp9x79c2:e1AANI|GI\0DYS,ZZL9H]6\$O\\ZJ3qreR+ZK)v]P+V)\"EB8!\0740C\"2\n.tIaD)cyYPtQE)DOND|')\0^O3T\$9{@O\$&H)N]	i NDeB(esrZG0%մ*3FtiMqXsP1tlڇ!zN-\$)PќIVB&Tv䤙^;\rSKst\rES@L*ˁBA\r@;C7\0މ69`4a\0;#H0C` ;eo^\r#/xG)Xd<]4yApϓˢ>6sW*8Aܗ6D')bJVe)J1.[Ex}_G!tF3<J҅{䖠'9LEtC=P	#vY׃9Z1C\$:\r#9\n{<s-XIsY^9Dxz-b:LD<:bܣ+ņ!H-@G'\"6+!xrdE	&W\$\"h隁n,sB[9	Ь*-ሜ)\$2HII1'%֒WK)m-ړTL	WBux?f%Isp9ȅ0K:Q~!GHAbAWQ\"&B&4VA\$kIXF;gtspBDa9VXq`%F\"\"Aȸ\"TO&\0P	A#! cH	|fFM##NYs8*@/ .q0xZ(-jPP@ aL)`@I#	e9\0z&rBK@M ɱ8'Js\njJkXO-1@+AQbpX	8k)P9OEgB4W'd,yN\"xS\nmQH Pѿ\$\\S9-z,H_	e'<P@\$\"UʂaL'ƾ|Ϫ2of\rҊA,yXWp \n@\"k&[ZEh \"T_L#~8gR`DT]ڑk)):X^xڗSgFxG8n0K(79l!j^;ABT7\$` >P[ݲsE%WPJ\n&sŕ9g6ܝcxHS5*tLe.p%HQ6E\0gst\"%v1R\"}SZDغ ht1|\$oŢ7x7-;J2J R#d\n'P 09ӦЋ0&(W`)	neRRa9<:.\"˅ LD1C<f{sbtg,#.t7F0ƭ)b6-FJ5(B!#cDZ,`eZָJSo9_]\nI+P4#uc\\Gt^K}0K4Ans0is4g7V+>@<,7bh9m\\)vbXxGB@q\"U?Y'4fB*,98v[Յ-?wIYrԸ8gd~h^B7`Rc]ĦT_~^:wPn9DAIY.\$\$6dxU.܏xP8XoHȔSt_iUnG0>yA)J^/yp_:^F'T%)OR^:9C32`[(QBt+c0pȓN9Įj{dZ̘POR\\Djopp](3Ta<8.ƉNưL30J>HoTv0Lx\r?0NLPX?!n*KtξaGc(-!tCBcbm-!H*~d(BEH\0Sz-A&<y@7x_A>B'z1O^i\$>\np6,FL8(t#b::mdw0a!(4!^p;)& Cn/za^~žtPz\\4cUJh^\\&8%Q*6-.XP\r\0\$\"1Ҡ	/-\"4i^l%dl@@H@| \0HDj`-.Xl8\\nX\$qIEgV.Fh v\n`܎a,áq<e&#:A{e~Hu'[&4:AL?7%au r@Y ";break;case"zh-tw":$e="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%NNd%гCɗBQ+B_MK,\$uowfT9WKʏW2mizX:P	*_/g*eSLKۈι^9H\r7Zz>0)ȿN\nr!U=R\n^JTO](I^ܫ[f]b*\\gA2yOX#vi`\\\nsP h7P	ZģBGTr{4Ǒ0&Q8),ha!\090z\r8a^\\01\\Z\rp^8#;̣ ^)AT\nt[Tex!\\\$	psd<-D%yRP	 s-~WFJQO:(\\1|FMZScx<c`8Cx9xC2R\"\0FO.	vtCdY+DLeFMjDtj\\C)xGrB0SoHreB^'1I?wzP@]1pMi~B<JL\\8\"xs(j^	DgI,6KsRӲ<1?/LI}`Z9#x\rQE;WH#46`@2\r6XXӔB>1Ɛ\\]ҥ[_kB_6sEFL@eBA-OVugFy\nsB6i.Ji*\\*dK>s\$ITr8mQek|P:LPteM{3-C|\$۵eqn9mƔ\"i0ʉ/&\$\n6\$)G(DF9D}hB,G0戍u#\0ICD0T_!jwY֓Q+2L2(PB-\ri~p6IbG<\0rPJIQ+%`m2tҚBil9XX\"\"UAWn%IfvqZ!XE t\n!VL<FdP9V3\"\"	\0z`o HBl90QiA\r`2G\n1qQ&\0w2;j!`)D0D0a^@-!!B>+f Er9\0IIϟQ/G0GQ2&,#JS\nA^֚LwHLTLK¸i% Q2&a\\-aWPWur4r@͠CO	fY.O6%ab r~q&x\"tQ`T	R#`(bE;Q \$QD*i!o\nP#@N(	n3N\rLT?\"\n(Xrb#EM\0U\n @x &[l*B@FrfK{;xvVE/^\nUӞtN'dT]aq;X9#9Đ~/1PDBjMʹw@H!1P\"جzjAGFXW(\"!j	lϚ3N`MiR&D85 +UkU.jɔ5LpyQixNs{O2-Pa,SERʋ9T9Š^υ*|TØ]	0SJ\\Z)-%6\nqqTl\nr.GsDc/C{/{@]g>lot:qw6gڅ@@>)޲ЭD)u%Q=b|QTxA*eVKzR\0V0ωq/ET\$Z \\˻Ez\\H\\Ѝv:]nȠ2\$H,)@š-NID/u ox(\r@8S70rZߕ|Q@էؙAa򀀃4\\I+Flt2:k}^)1*URM,bt}!Neu8Et\n7-֙!5#Z1VPG/svB\\ZItJ_)v.ٳst%ݎKoqĴ;<ѷ~=:GbW=۴`)vF--Z?GfQr]CIL*\r`FIng%T[ĭE8\n}Aѝ,>%2ipCh/2,SH4{Se:SBToBOp<ɎܰD02ƈHfωOoG`N\r\"rxiL\0S0^_	D \$n؃v*y^0b̂l(Ar^S^'0zаq\rJ[BFA0j,pK\n/GLuЄ\rq.0zcM<	NҪf҃жQ/2@M\rF\$FraD`M@i*֒aZaz#p^\n-0|b5ΈV\r#-\"\0|9q:#B~5{C(x\$B\0\np8)gM:%a`8#LjσZyL%ń8)m	#Bj<DboBz+%ΪBN1	@}aGaTRm.FUIDj`Dn@J\0N%̲/ \"0,^BF\"BK  \r\$.\0 %(⨌SNin.Y%%&d`%l1˸<Q<ALobm%®\",z";break;}$ch=array();foreach(explode("\n",lzw_decompress($e))as$X)$ch[]=(strpos($X,"\t")?explode("\t",$X):$X);return$ch;}if(!$ch){$ch=get_translations($ca);$_SESSION["translations"]=$ch;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$b;$if=array_search("SQL",$b->operators);if($if!==false)unset($b->operators[$if]);}function
dsn($Tb,$V,$G,$Ee=array()){$Ee[PDO::ATTR_ERRMODE]=PDO::ERRMODE_SILENT;$Ee[PDO::ATTR_STATEMENT_CLASS]=array('Min_PDOStatement');try{$this->pdo=new
PDO($Tb,$V,$G,$Ee);}catch(Exception$mc){auth_error(h($mc->getMessage()));}$this->server_info=@$this->pdo->getAttribute(PDO::ATTR_SERVER_VERSION);}function
quote($tg){return$this->pdo->quote($tg);}function
query($I,$jh=false){$J=$this->pdo->query($I);$this->error="";if(!$J){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($J);return$J;}function
multi_query($I){return$this->_result=$this->query($I);}function
store_result($J=null){if(!$J){$J=$this->_result;if(!$J)return
false;}if($J->columnCount()){$J->num_rows=$J->rowCount();return$J;}$this->affected_rows=$J->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($I,$m=0){$J=$this->query($I);if(!$J)return
false;$L=$J->fetch();return$L[$m];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(PDO::FETCH_NUM);}function
fetch_field(){$L=(object)$this->getColumnMeta($this->_offset++);$L->orgtable=$L->table;$L->orgname=$L->name;$L->charsetnr=(in_array("blob",(array)$L->flags)?63:0);return$L;}}}$Pb=array();function
add_driver($s,$E){global$Pb;$Pb[$s]=$E;}function
get_driver($s){global$Pb;return$Pb[$s];}class
Min_SQL{var$_conn;function
__construct($f){$this->_conn=$f;}function
select($Q,$N,$Z,$Qc,$Ge=array(),$y=1,$F=0,$pf=false){global$b,$w;$sd=(count($Qc)<count($N));$I=$b->selectQueryBuild($N,$Z,$Qc,$Ge,$y,$F);if(!$I)$I="SELECT".limit(($_GET["page"]!="last"&&$y!=""&&$Qc&&$sd&&$w=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$N)."\nFROM ".table($Q),($Z?"\nWHERE ".implode(" AND ",$Z):"").($Qc&&$sd?"\nGROUP BY ".implode(", ",$Qc):"").($Ge?"\nORDER BY ".implode(", ",$Ge):""),($y!=""?+$y:null),($F?$y*$F:0),"\n");$pg=microtime(true);$K=$this->_conn->query($I);if($pf)echo$b->selectQuery($I,$pg,!$K);return$K;}function
delete($Q,$wf,$y=0){$I="FROM ".table($Q);return
queries("DELETE".($y?limit1($Q,$I,$wf):" $I$wf"));}function
update($Q,$P,$wf,$y=0,$Zf="\n"){$zh=array();foreach($P
as$x=>$X)$zh[]="$x = $X";$I=table($Q)." SET$Zf".implode(",$Zf",$zh);return
queries("UPDATE".($y?limit1($Q,$I,$wf,$Zf):" $I$wf"));}function
insert($Q,$P){return
queries("INSERT INTO ".table($Q).($P?" (".implode(", ",array_keys($P)).")\nVALUES (".implode(", ",$P).")":" DEFAULT VALUES"));}function
insertUpdate($Q,$M,$of){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($I,$Pg){}function
convertSearch($t,$X,$m){return$t;}function
value($X,$m){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$m):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($Qf){return
q($Qf);}function
warnings(){return'';}function
tableHelp($E){}}class
Adminer{var$operators;function
name(){return"<a href='https://www.adminerevo.org/'".target_blank()." id='h1'>AdminerEvo</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($h=false){return
password_file($h);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($O){return
h($O);}function
database(){return
DB;}function
databases($Cc=true){return
get_databases($Cc);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$K=array();$_c="adminer.css";if(file_exists($_c))$K[]="$_c?v=".crc32(file_get_contents($_c));return$K;}function
loginForm(){global$Pb;echo"<table cellspacing='0' class='layout'>\n",$this->loginFormField('driver','<tr><th>'.lang(22).'<td>',html_select("auth[driver]",$Pb,DRIVER,"loginDriver(this);")."\n"),$this->loginFormField('server','<tr><th>'.lang(23).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'."\n"),$this->loginFormField('username','<tr><th>'.lang(24).'<td>','<input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("focus(qs('#username')); qs('#username').form['auth[driver]'].onchange();")),$this->loginFormField('password','<tr><th>'.lang(25).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),$this->loginFormField('db','<tr><th>'.lang(26).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'."\n"),"</table>\n","<p><input type='submit' value='".lang(27)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(28))."\n";}function
loginFormField($E,$ad,$Y){return$ad.$Y;}function
login($Nd,$G){if($G=="")return
lang(29,target_blank());return
true;}function
tableName($Ag){return
h($Ag["Name"]);}function
fieldName($m,$Ge=0){return'<span title="'.h($m["full_type"]).'">'.h($m["field"]).'</span>';}function
selectLinks($Ag,$P=""){global$w,$k;echo'<p class="links">';$ma=array("select"=>lang(30));if(support("table")||support("indexes"))$ma["table"]=lang(31);if(support("table")){if(is_view($Ag))$ma["view"]=lang(32);else$ma["create"]=lang(33);}if($P!==null)$ma["edit"]=lang(34);$E=$Ag["Name"];$_=[];foreach($ma
as$x=>$X)$_[]="<a href='".h(ME)."$x=".urlencode($E).($x=="edit"?$P:"")."'".bold(isset($_GET[$x])).">$X</a>";echo
generate_linksbar($_),doc_link(array($w=>$k->tableHelp($E)),"?"),"\n";}function
foreignKeys($Q){return
foreign_keys($Q);}function
backwardKeys($Q,$_g){return
array();}function
backwardKeysPrint($Ca,$L){}function
selectQuery($I,$pg,$vc=false){global$w,$k;if(!$vc&&($Gh=$k->warnings())){$s="warnings";$K=", <a href='#$s'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$s');","")."<div id='$s' class='hidden'>\n$Gh</div>\n";}$_=[(support("sql")?"<a href='".h(ME)."sql=".urlencode($I)."'>".lang(10)."</a>":""),"<a href='#' class='copy-to-clipboard'>".lang(36)."</a>",];return"<code class='jush-$w copy-to-clipboard'>".h(str_replace("\n"," ",$I))."</code> <span class='time'>(".format_time($pg).")</span>".generate_linksbar($_);}function
sqlCommandQuery($I){return
shorten_utf8(trim($I),1000);}function
rowDescription($Q){return"";}function
rowDescriptions($M,$Gc){return$M;}function
selectLink($X,$m){}function
selectVal($X,$z,$m,$Oe){$K=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$m["type"]??null)&&!preg_match("~var~",$m["type"]??null)?"<code>$X</code>":$X));if(preg_match('~blob|bytea|raw|file~',$m["type"]??null)&&!is_utf8($X))$K="<i>".lang(37,strlen($Oe))."</i>";if(preg_match('~json~',$m["type"]??null))$K="<code class='jush-js'>$K</code>";return($z?"<a href='".h($z)."'".(is_url($z)?target_blank():"").">$K</a>":$K);}function
editVal($X,$m){return$X;}function
tableStructurePrint($n){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr><th>".lang(38)."<td>".lang(39).(support("comment")?"<td>".lang(40):"")."</thead>\n";foreach($n
as$m){echo"<tr".odd()."><th>".h($m["field"]),"<td><span title='".h($m["collation"])."'>".h($m["full_type"])."</span>",($m["null"]?" <i>NULL</i>":""),($m["auto_increment"]?" <i>".lang(41)."</i>":""),(isset($m["default"])?" <span title='".lang(42)."'>[<b>".h($m["default"])."</b>]</span>":""),(support("comment")?"<td>".h($m["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($v){echo"<table cellspacing='0'>\n";foreach($v
as$E=>$u){ksort($u["columns"]);$pf=array();foreach($u["columns"]as$x=>$X)$pf[]="<i>".h($X)."</i>".($u["lengths"][$x]?"(".$u["lengths"][$x].")":"").($u["descs"][$x]?" DESC":"");echo"<tr title='".h($E)."'><th>$u[type]<td>".implode(", ",$pf)."\n";}echo"</table>\n";}function
selectColumnsPrint($N,$d){global$Mc,$Tc;print_fieldset("select",lang(43),$N);$r=0;$N[""]=array();foreach($N
as$x=>$X){$X=$_GET["columns"][$x]??null;$c=select_input(" name='columns[$r][col]'",$d,$X["col"]??null,($x!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($Mc||$Tc?"<select name='columns[$r][fun]'>".optionlist(array(-1=>"")+array_filter(array(lang(44)=>$Mc,lang(45)=>$Tc)),$X["fun"]??null)."</select>".on_help("getTarget(event).value && getTarget(event).value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($x!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($c)":$c)." <input type='image' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' class='jsonly icon' title='",h(lang(46)),"' alt='x'>".script('qsl(".icon").onclick = selectRemoveRow;',"")."</div>\n";$r++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$d,$v){print_fieldset("search",lang(47),$Z);foreach($v
as$r=>$u){if($u["type"]=="FULLTEXT"){echo"<div>(<i>".implode("</i>, <i>",array_map('h',$u["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$r]' value='".h($_GET["fulltext"][$r])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$r]",1,isset($_GET["boolean"][$r]),"BOOL"),"</div>\n";}}$Ma="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$r=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators))){echo"<div>".select_input(" name='where[$r][col]'",$d,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(48).")"),html_select("where[$r][op]",$this->operators,$X["op"],$Ma),"<input type='search' name='where[$r][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Ma }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"<input type='image' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' class='jsonly icon' title='",h(lang(46)),"' alt='x'>",script('qsl(".icon").onclick = selectRemoveRow;',""),"</div>\n";}}echo"</div></fieldset>\n";}function
selectOrderPrint($Ge,$d,$v){print_fieldset("sort",lang(49),$Ge);$r=0;foreach((array)$_GET["order"]as$x=>$X){if($X!=""){echo"<div>".select_input(" name='order[$r]'",$d,$X,"selectFieldChange"),checkbox("desc[$r]",1,isset($_GET["desc"][$x]),lang(50))," <input type='image' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' class='jsonly icon' title='",h(lang(46)),"' alt='x'>",script('qsl(".icon").onclick = selectRemoveRow;',""),"</div>\n";$r++;}}echo"<div>".select_input(" name='order[$r]'",$d,"","selectAddRow"),checkbox("desc[$r]",1,false,lang(50))," <input type='image' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' class='jsonly icon' title='",h(lang(46)),"' alt='x'>",script('qsl(".icon").onclick = selectRemoveRow;',""),"</div>\n","</div></fieldset>\n";}function
selectLimitPrint($y){echo"<fieldset><legend>".lang(51)."</legend><div>";echo"<input type='number' name='limit' class='size' value='".h($y)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Ng){if($Ng!==null){echo"<fieldset><legend>".lang(52)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Ng)."'>","</div></fieldset>\n";}}function
selectActionPrint($v){echo"<fieldset><legend>".lang(53)."</legend><div>","<input type='submit' value='".lang(43)."'>"," <span id='noindex' title='".lang(54)."'></span>","<script".nonce().">\n","var indexColumns = ";$d=array();foreach($v
as$u){$ub=reset($u["columns"]);if($u["type"]!="FULLTEXT"&&$ub)$d[$ub]=1;}$d[""]=1;foreach($d
as$x=>$X)json_row($x);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($bc,$d){}function
selectColumnsProcess($d,$v){global$Mc,$Tc;$N=array();$Qc=array();foreach((array)$_GET["columns"]as$x=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$Mc)||in_array($X["fun"],$Tc)))){$N[$x]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$Tc))$Qc[]=$N[$x];}}return
array($N,$Qc);}function
selectSearchProcess($n,$v){global$f,$k;$K=array();foreach($v
as$r=>$u){if($u["type"]=="FULLTEXT"&&$_GET["fulltext"][$r]!="")$K[]="MATCH (".implode(", ",array_map('idf_escape',$u["columns"])).") AGAINST (".q($_GET["fulltext"][$r]).(isset($_GET["boolean"][$r])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$x=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$mf="";$gb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$id=process_length($X["val"]);$gb.=" ".($id!=""?$id:"(NULL)");}elseif($X["op"]=="SQL")$gb=" $X[val]";elseif($X["op"]=="LIKE %%")$gb=" LIKE ".$this->processInput($n[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$gb=" ILIKE ".$this->processInput($n[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$mf="$X[op](".q($X["val"]).", ";$gb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$gb.=" ".$this->processInput($n[$X["col"]],$X["val"]);if($X["col"]!="")$K[]=$mf.$k->convertSearch(idf_escape($X["col"]),$X,$n[$X["col"]]).$gb;else{$ab=array();foreach($n
as$E=>$m){if((preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$m["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$m["type"]))&&(!preg_match('~date|timestamp~',$m["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$ab[]=$mf.$k->convertSearch(idf_escape($E),$X,$m).$gb;}$K[]=($ab?"(".implode(" OR ",$ab).")":"1 = 0");}}}return$K;}function
selectOrderProcess($n,$v){$K=array();foreach((array)$_GET["order"]as$x=>$X){if($X!="")$K[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$x])?" DESC":"");}return$K;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$Gc){return
false;}function
selectQueryBuild($N,$Z,$Qc,$Ge,$y,$F){return"";}function
messageQuery($I,$Og,$vc=false){global$w,$k;restart_session();$bd=&get_session("queries");if(isset($bd[$_GET["db"]])===false)$bd[$_GET["db"]]=array();if(strlen($I)>1e6)$I=preg_replace('~[\x80-\xFF]+$~','',substr($I,0,1e6))."\n…";$bd[$_GET["db"]][]=array($I,time(),$Og);$ng="sql-".count($bd[$_GET["db"]]);$K="<a href='#$ng' class='toggle'>".lang(55)."</a> <a href='#' class='copy-to-clipboard icon expand' data-expand-id='$ng'></a>\n";if(!$vc&&($Gh=$k->warnings())){$s="warnings-".count($bd[$_GET["db"]]);$K="<a href='#$s' class='toggle'>".lang(35)."</a>, $K<div id='$s' class='hidden'>\n$Gh</div>\n";}$_=[];if(support("sql")){$_[]='<a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($bd[$_GET["db"]])-1)).'">'.lang(10).'</a>';$_[]='<a href="#" class="copy-to-clipboard">'.lang(36).'</a>';}return" <span class='time'>".@date("H:i:s")."</span>"." $K<div id='$ng' class='hidden'><pre><code class='jush-$w copy-to-clipboard'>".shorten_utf8($I,1000)."</code></pre>".($Og?" <span class='time'>($Og)</span>":'').generate_linksbar($_).'</div>';}function
editRowPrint($Q,$n,$L,$qh){}function
editFunctions($m){global$Wb;$K=($m["null"]?"NULL/":"");$qh=isset($_GET["select"])||where($_GET);foreach($Wb
as$x=>$Mc){if(!$x||(!isset($_GET["call"])&&$qh)){foreach($Mc
as$df=>$X){if(!$df||preg_match("~$df~",$m["type"]))$K.="/$X";}}if($x&&!preg_match('~set|blob|bytea|raw|file|bool~',$m["type"]))$K.="/SQL";}if($m["auto_increment"]&&!$qh)$K=lang(41);return
explode("/",$K);}function
editInput($Q,$m,$ya,$Y){if($m["type"]=="enum"){$Ee=array();$Vf=$Y;if(isset($_GET["select"])){$Ee[-1]=lang(8);if($Vf===null)$Vf=-1;}if($m["null"]){$Ee[""]="NULL";if($Y===null&&!isset($_GET["select"]))$Vf="";}$Ee[0]=lang(7);preg_match_all("~'((?:[^']|'')*)'~",$m["length"],$C);foreach($C[1]as$r=>$X){$X=stripcslashes(str_replace("''","'",$X));$Ee[$r+1]=$X;if($Y===$X)$Vf=$r+1;}return"<select$ya>".optionlist($Ee,(string)$Vf,1)."</select>";}return"";}function
editHint($Q,$m,$Y){return"";}function
processInput($m,$Y,$q=""){if($q=="SQL")return$Y;$E=$m["field"];$K=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$q))$K="$q()";elseif(preg_match('~^current_(date|timestamp)$~',$q))$K=$q;elseif(preg_match('~^([+-]|\|\|)$~',$q))$K=idf_escape($E)." $q $K";elseif(preg_match('~^[+-] interval$~',$q))$K=idf_escape($E)." $q ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$K);elseif(preg_match('~^(addtime|subtime|concat)$~',$q))$K="$q(".idf_escape($E).", $K)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$q))$K="$q($K)";return
unconvert_field($m,$K);}function
dumpOutput(){$K=array('text'=>lang(56),'file'=>lang(57));if(function_exists('gzencode'))$K['gz']='gzip';return$K;}function
dumpFormat(){return
array('sql'=>'SQL','csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($j){}function
dumpTable($Q,$vg,$ud=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($vg)dump_csv(array_keys(fields($Q)));}else{if($ud==2){$n=array();foreach(fields($Q)as$E=>$m)$n[]=idf_escape($E)." $m[full_type]";$h="CREATE TABLE ".table($Q)." (".implode(", ",$n).")";}else$h=create_sql($Q,$_POST["auto_increment"],$vg);set_utf8mb4($h);if($vg&&$h){if($vg=="DROP+CREATE"||$ud==1)echo"DROP ".($ud==2?"VIEW":"TABLE")." IF EXISTS ".table($Q).";\n";if($ud==1)$h=remove_definer($h);echo"$h;\n\n";}}}function
dumpData($Q,$vg,$I){global$f,$w;$Sd=($w=="sqlite"?0:1048576);if($vg){if($_POST["format"]=="sql"){if($vg=="TRUNCATE+INSERT")echo
truncate_sql($Q).";\n";$n=fields($Q);}$J=$f->query($I,1);if($J){$nd="";$Ka="";$xd=array();$Nc=array();$xg="";$yc=($Q!=''?'fetch_assoc':'fetch_row');while($L=$J->$yc()){if(!$xd){$zh=array();foreach($L
as$X){$m=$J->fetch_field();if(!empty($n[$m->name]['generated'])){$Nc[$m->name]=true;continue;}$xd[]=$m->name;$x=idf_escape($m->name);$zh[]="$x = VALUES($x)";}$xg=($vg=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$zh):"").";\n";}if($_POST["format"]!="sql"){if($vg=="table"){dump_csv($xd);$vg="INSERT";}dump_csv($L);}else{if(!$nd)$nd="INSERT INTO ".table($Q)." (".implode(", ",array_map('idf_escape',$xd)).") VALUES";foreach($L
as$x=>$X){if(isset($Nc[$x])){unset($L[$x]);continue;}$m=$n[$x];$L[$x]=($X!==null?unconvert_field($m,preg_match(number_type(),$m["type"])&&!preg_match('~\[~',$m["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Qf=($Sd?"\n":" ")."(".implode(",\t",$L).")";if(!$Ka)$Ka=$nd.$Qf;elseif(strlen($Ka)+4+strlen($Qf)+strlen($xg)<$Sd)$Ka.=",$Qf";else{echo$Ka.$xg;$Ka=$nd.$Qf;}}}if($Ka)echo$Ka.$xg;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$f->error)."\n";}}function
dumpFilename($fd){return
friendly_url($fd!=""?$fd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($fd,$ee=false){$Qe=$_POST["output"];$sc=(preg_match('~sql~',$_POST["format"])?"sql":($ee?"tar":"csv"));header("Content-Type: ".($Qe=="gz"?"application/x-gzip":($sc=="tar"?"application/x-tar":($sc=="sql"||$Qe!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Qe=="gz")ob_start('ob_gzencode',1e6);return$sc;}function
importServerPath(){return"adminer.sql";}function
homepage(){$_=[];if($_GET["ns"]==""&&support("database"))$_[]='<a href="'.h(ME).'database=">'.lang(58).'</a>';if($_GET["ns"]!=="")$_[]='<a href="'.h(ME).'schema=">'.lang(59).'</a>';if(support("privileges"))$_[]="<a href='".h(ME)."privileges='>".lang(60)."</a>";echo
generate_linksbar($_);return
true;}function
navigation($de){global$ga,$w,$Pb,$f;echo'<h1>
',$this->name(),' <span class="version">',$ga,'</span>
<a href="https://download.adminerevo.org/latest/adminer/"',target_blank(),' id="version" title="',lang(61),'">',(version_compare($ga,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</h1>
';if($de=="auth"){$Qe="";foreach((array)$_SESSION["pwds"]as$Ah=>$bg){foreach($bg
as$O=>$xh){foreach($xh
as$V=>$G){if($G!==null){$_b=$_SESSION["db"][$Ah][$O][$V];foreach(($_b?array_keys($_b):array(""))as$j)$Qe.="<li><a href='".h(auth_url($Ah,$O,$V,$j))."'>($Pb[$Ah]) ".h($V.($O!=""?"@".$this->serverName($O):"").($j!=""?" - $j":""))."</a>\n";}}}}if($Qe)echo"<ul id='logins'>\n$Qe</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$S=array();if($_GET["ns"]!==""&&!$de&&DB!=""){$f->select_db(DB);$S=table_status('',true);}echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=4.8.4");if(support("sql")){echo'<script',nonce(),'>
';if($S){$_=array();foreach($S
as$Q=>$U)$_[]=preg_quote($Q,'/');echo"var jushLinks = { $w: [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$_).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.$w;\n";}$ag=$f->server_info;echo'bodyLoad(\'',(is_object($f)?preg_replace('~^(\d\.?\d).*~s','\1',$ag):""),'\'',(preg_match('~MariaDB~',$ag)?", true":""),');
</script>
';}$this->databasesPrint($de);$_=[];if(DB==""||!$de){if(support("sql")){$_[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(55)."</a>";$_[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(62)."</a>";}if(support("dump"))$_[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(63)."</a>";}echo
generate_linksbar($_);if($_GET["ns"]!==""&&!$de&&DB!=""){echo
generate_linksbar(['<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(64)."</a>"]);if(!$S)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($S);}}}function
databasesPrint($de){global$b,$f;$i=$this->databases();if(DB&&$i&&!in_array(DB,$i))array_unshift($i,DB);echo'<form action="">
',"<table id='dbs'><tr><td width=1>";hidden_fields_get();$yb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(65)."' for='menu_db'>".lang(66)."</label>:</td><td>".($i?"<select name='db' id='menu_db'>".optionlist(array(""=>"")+$i,DB)."</select>$yb":"<input name='db' id='menu_db' value='".h(DB)."' autocapitalize='off'>\n"),"</td></tr>","<tr".($i?" class='hidden'":"")."><td colspan=2><input type='submit' value='".lang(20)."'></td></tr>\n","</table>";foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo"<input type='hidden' name='$X' value=''>";break;}}}function
tablesPrint($S){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($S
as$Q=>$qg){$E=$this->tableName($qg);if($E!=""){echo'<li><a href="'.h(ME).'select='.urlencode($Q).'"'.bold($_GET["select"]==$Q||$_GET["edit"]==$Q,"select")." title='".lang(30)."'>".lang(67)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($Q).'"'.bold(in_array($Q,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["select"])),(is_view($qg)?"view":"structure"))." title='".lang(31)."'>$E</a>":"<span>$E</span>")."\n";}}echo"</ul>\n";}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);$Pb=array("server"=>"MySQL")+$Pb;if(!defined("DRIVER")){define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($O="",$V="",$G="",$xb=null,$hf=null,$ig=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($dd,$hf)=explode(":",$O,2);$og=$b->connectSsl();if($og)$this->ssl_set($og['key'],$og['cert'],$og['ca'],'','');$K=@$this->real_connect(($O!=""?$dd:ini_get("mysqli.default_host")),($O.$V!=""?$V:ini_get("mysqli.default_user")),($O.$V.$G!=""?$G:ini_get("mysqli.default_pw")),$xb,(is_numeric($hf)?$hf:ini_get("mysqli.default_port")),(!is_numeric($hf)?$hf:$ig),($og?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$K;}function
set_charset($Na){if(parent::set_charset($Na))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Na");}function
result($I,$m=0){$J=$this->query($I);if(!$J)return
false;$L=$J->fetch_array();return$L[$m];}function
quote($tg){return"'".$this->escape_string($tg)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($O,$V,$G){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(68,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($O!=""?$O:ini_get("mysql.default_host")),("$O$V"!=""?$V:ini_get("mysql.default_user")),("$O$V$G"!=""?$G:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($Na){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Na,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $Na");}function
quote($tg){return"'".mysql_real_escape_string($tg,$this->_link)."'";}function
select_db($xb){return
mysql_select_db($xb,$this->_link);}function
query($I,$jh=false){$J=@($jh?mysql_unbuffered_query($I,$this->_link):mysql_query($I,$this->_link));$this->error="";if(!$J){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($J===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($J);}function
multi_query($I){return$this->_result=$this->query($I);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($I,$m=0){$J=$this->query($I);if(!$J||!$J->num_rows)return
false;return
mysql_result($J->_result,0,$m);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($J){$this->_result=$J;$this->num_rows=mysql_num_rows($J);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$K=mysql_fetch_field($this->_result,$this->_offset++);$K->orgtable=$K->table;$K->orgname=$K->name;$K->charsetnr=($K->blob?63:0);return$K;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($O,$V,$G){global$b;$Ee=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$og=$b->connectSsl();if($og){if(!empty($og['key']))$Ee[PDO::MYSQL_ATTR_SSL_KEY]=$og['key'];if(!empty($og['cert']))$Ee[PDO::MYSQL_ATTR_SSL_CERT]=$og['cert'];if(!empty($og['ca']))$Ee[PDO::MYSQL_ATTR_SSL_CA]=$og['ca'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$O)),$V,$G,$Ee);return
true;}function
set_charset($Na){$this->query("SET NAMES $Na");}function
select_db($xb){return$this->query("USE ".idf_escape($xb));}function
query($I,$jh=false){$this->pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$jh);return
parent::query($I,$jh);}}}class
Min_Driver
extends
Min_SQL{function
insert($Q,$P){return($P?parent::insert($Q,$P):queries("INSERT INTO ".table($Q)." ()\nVALUES ()"));}function
insertUpdate($Q,$M,$of){$d=array_keys(reset($M));$mf="INSERT INTO ".table($Q)." (".implode(", ",$d).") VALUES\n";$zh=array();foreach($d
as$x)$zh[$x]="$x = VALUES($x)";$xg="\nON DUPLICATE KEY UPDATE ".implode(", ",$zh);$zh=array();$Jd=0;foreach($M
as$P){$Y="(".implode(", ",$P).")";if($zh&&(strlen($mf)+$Jd+strlen($Y)+strlen($xg)>1e6)){if(!queries($mf.implode(",\n",$zh).$xg))return
false;$zh=array();$Jd=0;}$zh[]=$Y;$Jd+=strlen($Y)+2;}return
queries($mf.implode(",\n",$zh).$xg);}function
slowQuery($I,$Pg){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$Pg FOR $I";elseif(preg_match('~^(SELECT\b)(.+)~is',$I,$B))return"$B[1] /*+ MAX_EXECUTION_TIME(".($Pg*1000).") */ $B[2]";}}function
convertSearch($t,$X,$m){return(preg_match('~char|text|enum|set~',$m["type"])&&!preg_match("~^utf8~",$m["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($t USING ".charset($this->_conn).")":$t);}function
warnings(){$J=$this->_conn->query("SHOW WARNINGS");if($J&&$J->num_rows){ob_start();select($J);return
ob_get_clean();}}function
tableHelp($E){$Pd=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($Pd?"information-schema-$E-table/":str_replace("_","-",$E)."-table.html"));if(DB=="mysql")return($Pd?"mysql$E-table/":"system-database.html");}}function
idf_escape($t){return"`".str_replace("`","``",$t)."`";}function
table($t){return
idf_escape($t);}function
connect(){global$b,$ih,$ug;$f=new
Min_DB;$qb=$b->credentials();if($f->connect($qb[0],$qb[1],$qb[2])){$f->set_charset(charset($f));$f->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$f)){$ug[lang(69)][]="json";$ih["json"]=4294967295;}return$f;}$K=$f->error;if(function_exists('iconv')&&!is_utf8($K)&&strlen($Qf=iconv("windows-1250","utf-8",$K))>strlen($K))$K=$Qf;return$K;}function
get_databases($Cc){$K=get_session("dbs");if($K===null){$I=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$K=($Cc?slow_query($I):get_vals($I));restart_session();set_session("dbs",$K);stop_session();}return$K;}function
limit($I,$Z,$y,$re=0,$Zf=" "){return" $I$Z".($y!==null?$Zf."LIMIT $y".($re?" OFFSET $re":""):"");}function
limit1($Q,$I,$Z,$Zf="\n"){return
limit($I,$Z,1,0,$Zf);}function
db_collation($j,$Za){global$f;$K=null;$h=$f->result("SHOW CREATE DATABASE ".idf_escape($j),1);if(preg_match('~ COLLATE ([^ ]+)~',$h,$B))$K=$B[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$h,$B))$K=$Za[$B[1]][-1];return$K;}function
engines(){$K=array();foreach(get_rows("SHOW ENGINES")as$L){if(preg_match("~YES|DEFAULT~",$L["Support"]))$K[]=$L["Engine"];}return$K;}function
logged_user(){global$f;return$f->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($i){$K=array();foreach($i
as$j)$K[$j]=count(get_vals("SHOW TABLES IN ".idf_escape($j)));return$K;}function
table_status($E="",$wc=false){$K=array();foreach(get_rows($wc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($E!=""?"AND TABLE_NAME = ".q($E):"ORDER BY Name"):"SHOW TABLE STATUS".($E!=""?" LIKE ".q(addcslashes($E,"%_\\")):""))as$L){if($L["Engine"]=="InnoDB")$L["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$L["Comment"]);if(!isset($L["Engine"]))$L["Comment"]="";if($E!="")return$L;$K[$L["Name"]]=$L;}return$K;}function
is_view($R){return$R["Engine"]===null;}function
fk_support($R){return
preg_match('~InnoDB|IBMDB2I~i',$R["Engine"])||(preg_match('~NDB~i',$R["Engine"])&&min_version(5.6));}function
fields($Q){$K=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($Q))as$L){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$L["Type"],$B);$K[$L["Field"]]=array("field"=>$L["Field"],"full_type"=>$L["Type"],"type"=>$B[1],"length"=>$B[2],"unsigned"=>ltrim($B[3].$B[4]),"default"=>($L["Default"]!=""||preg_match("~char|set~",$B[1])?(preg_match('~text~',$B[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$L["Default"])):$L["Default"]):null),"null"=>($L["Null"]=="YES"),"auto_increment"=>($L["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$L["Extra"],$B)?$B[1]:""),"collation"=>$L["Collation"],"privileges"=>array_flip(preg_split('~, *~',$L["Privileges"])),"comment"=>$L["Comment"],"primary"=>($L["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$L["Extra"]),);}return$K;}function
indexes($Q,$g=null){$K=array();foreach(get_rows("SHOW INDEX FROM ".table($Q),$g)as$L){$E=$L["Key_name"];$K[$E]["type"]=($E=="PRIMARY"?"PRIMARY":($L["Index_type"]=="FULLTEXT"?"FULLTEXT":($L["Non_unique"]?($L["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$K[$E]["columns"][]=$L["Column_name"];$K[$E]["lengths"][]=($L["Index_type"]=="SPATIAL"?null:$L["Sub_part"]);$K[$E]["descs"][]=null;}return$K;}function
foreign_keys($Q){global$f,$ye;static$df='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$K=array();$ob=$f->result("SHOW CREATE TABLE ".table($Q),1);if($ob){preg_match_all("~CONSTRAINT ($df) FOREIGN KEY ?\\(((?:$df,? ?)+)\\) REFERENCES ($df)(?:\\.($df))? \\(((?:$df,? ?)+)\\)(?: ON DELETE ($ye))?(?: ON UPDATE ($ye))?~",$ob,$C,PREG_SET_ORDER);foreach($C
as$B){preg_match_all("~$df~",$B[2],$jg);preg_match_all("~$df~",$B[5],$Ig);$K[idf_unescape($B[1])]=array("db"=>idf_unescape($B[4]!=""?$B[3]:$B[4]),"table"=>idf_unescape($B[4]!=""?$B[4]:$B[3]),"source"=>array_map('idf_unescape',$jg[0]),"target"=>array_map('idf_unescape',$Ig[0]),"on_delete"=>($B[6]?$B[6]:"RESTRICT"),"on_update"=>($B[7]?$B[7]:"RESTRICT"),);}}return$K;}function
view($E){global$f;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$f->result("SHOW CREATE VIEW ".table($E),1)));}function
collations(){$K=array();foreach(get_rows("SHOW COLLATION")as$L){if($L["Default"])$K[$L["Charset"]][-1]=$L["Collation"];else$K[$L["Charset"]][]=$L["Collation"];}ksort($K);foreach($K
as$x=>$X)asort($K[$x]);return$K;}function
information_schema($j){return(min_version(5)&&$j=="information_schema")||(min_version(5.5)&&$j=="performance_schema");}function
error(){global$f;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$f->error));}function
create_database($j,$Ya){return
queries("CREATE DATABASE ".idf_escape($j).($Ya?" COLLATE ".q($Ya):""));}function
drop_databases($i){$K=apply_queries("DROP DATABASE",$i,'idf_escape');restart_session();set_session("dbs",null);return$K;}function
rename_database($E,$Ya){$K=false;if(create_database($E,$Ya)){$S=array();$Dh=array();foreach(tables_list()as$Q=>$U){if($U=='VIEW')$Dh[]=$Q;else$S[]=$Q;}$K=(!$S&&!$Dh)||move_tables($S,$Dh,$E);drop_databases($K?array(DB):array());}return$K;}function
auto_increment(){$Aa=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$u){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$u["columns"],true)){$Aa="";break;}if($u["type"]=="PRIMARY")$Aa=" UNIQUE";}}return" AUTO_INCREMENT$Aa";}function
alter_table($Q,$E,$n,$Fc,$db,$ec,$Ya,$_a,$Ye){$ua=array();foreach($n
as$m)$ua[]=($m[1]?($Q!=""?($m[0]!=""?"CHANGE ".idf_escape($m[0]):"ADD"):" ")." ".implode($m[1]).($Q!=""?$m[2]:""):"DROP ".idf_escape($m[0]));$ua=array_merge($ua,$Fc);$qg=($db!==null?" COMMENT=".q($db):"").($ec?" ENGINE=".q($ec):"").($Ya?" COLLATE ".q($Ya):"").($_a!=""?" AUTO_INCREMENT=$_a":"");if($Q=="")return
queries("CREATE TABLE ".table($E)." (\n".implode(",\n",$ua)."\n)$qg$Ye");if($Q!=$E)$ua[]="RENAME TO ".table($E);if($qg)$ua[]=ltrim($qg);return($ua||$Ye?queries("ALTER TABLE ".table($Q)."\n".implode(",\n",$ua).$Ye):true);}function
alter_indexes($Q,$ua){foreach($ua
as$x=>$X)$ua[$x]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($Q).implode(",",$ua));}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($Dh){return
queries("DROP VIEW ".implode(", ",array_map('table',$Dh)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$Dh,$Ig){global$f;$Gf=array();foreach($S
as$Q)$Gf[]=table($Q)." TO ".idf_escape($Ig).".".table($Q);if(!$Gf||queries("RENAME TABLE ".implode(", ",$Gf))){$Gb=array();foreach($Dh
as$Q)$Gb[table($Q)]=view($Q);$f->select_db($Ig);$j=idf_escape(DB);foreach($Gb
as$E=>$Ch){if(!queries("CREATE VIEW $E AS ".str_replace(" $j."," ",$Ch["select"]))||!queries("DROP VIEW $j.$E"))return
false;}return
true;}return
false;}function
copy_tables($S,$Dh,$Ig){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($S
as$Q){$E=($Ig==DB?table("copy_$Q"):idf_escape($Ig).".".table($Q));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $E"))||!queries("CREATE TABLE $E LIKE ".table($Q))||!queries("INSERT INTO $E SELECT * FROM ".table($Q)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$L){$dh=$L["Trigger"];if(!queries("CREATE TRIGGER ".($Ig==DB?idf_escape("copy_$dh"):idf_escape($Ig).".".idf_escape($dh))." $L[Timing] $L[Event] ON $E FOR EACH ROW\n$L[Statement];"))return
false;}}foreach($Dh
as$Q){$E=($Ig==DB?table("copy_$Q"):idf_escape($Ig).".".table($Q));$Ch=view($Q);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $E"))||!queries("CREATE VIEW $E AS $Ch[select]"))return
false;}return
true;}function
trigger($E){if($E=="")return
array();$M=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($E));return
reset($M);}function
triggers($Q){$K=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$L)$K[$L["Trigger"]]=array($L["Timing"],$L["Event"]);return$K;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($E,$U){global$f,$gc,$ld,$ih;$sa=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$kg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$hh="((".implode("|",array_merge(array_keys($ih),$sa)).")\\b(?:\\s*\\(((?:[^'\")]|$gc)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$df="$kg*(".($U=="FUNCTION"?"":$ld).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$hh";$h=$f->result("SHOW CREATE $U ".idf_escape($E),2);preg_match("~\\(((?:$df\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$hh\\s+":"")."(.*)~is",$h,$B);$n=array();preg_match_all("~$df\\s*,?~is",$B[1],$C,PREG_SET_ORDER);foreach($C
as$Te)$n[]=array("field"=>str_replace("``","`",$Te[2]).$Te[3],"type"=>strtolower($Te[5]),"length"=>preg_replace_callback("~$gc~s",'normalize_enum',$Te[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Te[8] $Te[7]"))),"null"=>1,"full_type"=>$Te[4],"inout"=>strtoupper($Te[1]),"collation"=>strtolower($Te[9]),);if($U!="FUNCTION")return
array("fields"=>$n,"definition"=>$B[11]);return
array("fields"=>$n,"returns"=>array("type"=>$B[12],"length"=>$B[13],"unsigned"=>$B[15],"collation"=>$B[16]),"definition"=>$B[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($E,$L){return
idf_escape($E);}function
last_id(){global$f;return$f->result("SELECT LAST_INSERT_ID()");}function
explain($f,$I){return$f->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$I);}function
found_rows($R,$Z){return($Z||$R["Engine"]!="InnoDB"?null:$R["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Sf,$g=null){return
true;}function
create_sql($Q,$_a,$vg){global$f;$K=$f->result("SHOW CREATE TABLE ".table($Q),1);if(!$_a)$K=preg_replace('~ AUTO_INCREMENT=\d+~','',$K);return$K;}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
use_sql($xb){return"USE ".idf_escape($xb);}function
trigger_sql($Q){$K="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")),null,"-- ")as$L)$K.="\nCREATE TRIGGER ".idf_escape($L["Trigger"])." $L[Timing] $L[Event] ON ".table($L["Table"])." FOR EACH ROW\n$L[Statement];;\n";return$K;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($m){if(preg_match("~binary~",$m["type"]))return"HEX(".idf_escape($m["field"]).")";if($m["type"]=="bit")return"BIN(".idf_escape($m["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$m["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($m["field"]).")";}function
unconvert_field($m,$K){if(preg_match("~binary~",$m["type"]??null))$K="UNHEX($K)";if(isset($m["type"])&&$m["type"]=="bit")$K="CONV($K, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$m["type"]??null)){$mf=(min_version(8)?"ST_":"");$K=$mf."GeomFromText($K, $mf"."SRID($m[field]))";}return$K;}function
support($xc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view")))."~",$xc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$f;return$f->result("SELECT @@max_connections");}function
driver_config(){$ih=array();$ug=array();foreach(array(lang(70)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(71)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(69)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(72)=>array("enum"=>65535,"set"=>64),lang(73)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(74)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$x=>$X){$ih+=$X;$ug[$x]=array_keys($X);}return
array('possible_drivers'=>array("MySQLi","MySQL","PDO_MySQL"),'jush'=>"sql",'types'=>$ih,'structured_types'=>$ug,'unsigned'=>array("unsigned","zerofill","unsigned zerofill"),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("char_length","date","distinct","from_unixtime","unix_timestamp","lower","round","floor","ceil","sec_to_time","time_to_sec","upper"),'operator_regexp'=>'REGEXP','grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",)),);}}$hb=driver_config();$lf=$hb['possible_drivers'];$w=$hb['jush'];$ih=$hb['types'];$ug=$hb['structured_types'];$ph=$hb['unsigned'];$Ce=$hb['operators'];$Be=isset($hb['operator_regexp'])&&in_array($hb['operator_regexp'],$Ce)?$hb['operator_regexp']:null;$Mc=$hb['functions'];$Tc=$hb['grouping'];$Wb=$hb['edit_functions'];if($b->operators===null){$b->operators=$Ce;$b->operator_regexp=$Be;}define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$ga="4.8.4";function
page_header($Rg,$l="",$Ja=array(),$Sg=""){global$ca,$ga,$b,$Pb,$w;page_headers();if(is_ajax()&&$l){page_messages($l);exit;}$Tg=$Rg.($Sg!=""?": $Sg":"");$Ug=strip_tags($Tg.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ca,'" dir="',lang(75),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$Ug,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.8.4"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.8.4");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.4"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.4"),'">
';foreach($b->css()as$sb){echo'<link rel="stylesheet" type="text/css" href="',h($sb),'">
';}}echo'
<body class="',lang(75),' nojs adminer">
';$_c=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&file_exists($_c)&&filemtime($_c)+86400>time()){$Bh=unserialize(file_get_contents($_c));$_COOKIE["adminer_version"]=$Bh["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ga', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(76)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$w,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Ja!==null){$z=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($z?$z:".").'">'.$Pb[DRIVER].'</a> &raquo; ';$z=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$O=$b->serverName(SERVER);$O=($O!=""?$O:lang(23));if($Ja===false)echo"$O\n";else{echo"<a href='".h($z)."' accesskey='1' title='Alt+Shift+1'>$O</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Ja)))echo'<a href="'.h($z."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Ja)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Ja
as$x=>$X){$Ib=(is_array($X)?$X[1]:h($X));if($Ib!="")echo"<a href='".h(ME."$x=").urlencode(is_array($X)?$X[0]:$X)."'>$Ib</a> &raquo; ";}}echo"$Rg\n";}}echo"<h2>$Tg</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($l);$i=&get_session("dbs");if(DB!=""&&$i&&!in_array(DB,$i,true))$i=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$rb){$Zc=array();foreach($rb
as$x=>$X)$Zc[]="$x $X";header("Content-Security-Policy: ".implode("; ",$Zc));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self' https://api.github.com/repos/adminerevo/adminerevo/releases/latest","frame-src"=>"'self'","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$me;if(!$me)$me=base64_encode(rand_string());return$me;}function
page_messages($l){$rh=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$be=[];if(isset($_SESSION["messages"][$rh]))$be=$_SESSION["messages"][$rh];if(count($be)>0){echo"<div class='message'>".implode("</div>\n<div class='message'>",$be)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$rh]);}if($l)echo"<div class='error'>$l</div>\n";}function
page_footer($de=""){global$b,$T;echo'</div>

';switch_lang();if($de!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(77),'" id="logout">
<input type="hidden" name="token" value="',$T,'">
</p>
</form>
';}echo'<div id="menu">
';$b->navigation($de);echo'</div>
',script("setupSubmitHighlight(document);"),script("setupCopyToClipboard(document);"),"</body>\n</html>";}function
int32($ge){while($ge>=2147483648)$ge-=4294967296;while($ge<=-2147483649)$ge+=4294967296;return(int)$ge;}function
long2str($W,$Fh){$Qf='';foreach($W
as$X)$Qf.=pack('V',$X);if($Fh)return
substr($Qf,0,end($W));return$Qf;}function
str2long($Qf,$Fh){$W=array_values(unpack('V*',str_pad($Qf,4*ceil(strlen($Qf)/4),"\0")));if($Fh)$W[]=strlen($Qf);return$W;}function
xxtea_mx($Mh,$Lh,$yg,$wd){return
int32((($Mh>>5&0x7FFFFFF)^$Lh<<2)+(($Lh>>3&0x1FFFFFFF)^$Mh<<4))^int32(($yg^$Lh)+($wd^$Mh));}function
encrypt_string($sg,$x){if($sg=="")return"";$x=array_values(unpack("V*",pack("H*",md5($x))));$W=str2long($sg,true);$ge=count($W)-1;$Mh=$W[$ge];$Lh=$W[0];$H=floor(6+52/($ge+1));$yg=0;while($H-->0){$yg=int32($yg+0x9E3779B9);$Vb=$yg>>2&3;for($Re=0;$Re<$ge;$Re++){$Lh=$W[$Re+1];$fe=xxtea_mx($Mh,$Lh,$yg,$x[$Re&3^$Vb]);$Mh=int32($W[$Re]+$fe);$W[$Re]=$Mh;}$Lh=$W[0];$fe=xxtea_mx($Mh,$Lh,$yg,$x[$Re&3^$Vb]);$Mh=int32($W[$ge]+$fe);$W[$ge]=$Mh;}return
long2str($W,false);}function
decrypt_string($sg,$x){if($sg=="")return"";if(!$x)return
false;$x=array_values(unpack("V*",pack("H*",md5($x))));$W=str2long($sg,false);$ge=count($W)-1;$Mh=$W[$ge];$Lh=$W[0];$H=floor(6+52/($ge+1));$yg=int32($H*0x9E3779B9);while($yg){$Vb=$yg>>2&3;for($Re=$ge;$Re>0;$Re--){$Mh=$W[$Re-1];$fe=xxtea_mx($Mh,$Lh,$yg,$x[$Re&3^$Vb]);$Lh=int32($W[$Re]-$fe);$W[$Re]=$Lh;}$Mh=$W[$ge];$fe=xxtea_mx($Mh,$Lh,$yg,$x[$Re&3^$Vb]);$Lh=int32($W[0]-$fe);$W[0]=$Lh;$yg=int32($yg-0x9E3779B9);}return
long2str($W,true);}$f='';$Yc=$_SESSION["token"];if(!$Yc)$_SESSION["token"]=rand(1,1e6);$T=get_token();$ff=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($x)=explode(":",$X);$ff[$x]=$X;}}function
validate_server_input(){if(SERVER=="")return;$af=parse_url(SERVER);if(!$af)auth_error(lang(78));if(isset($af['user'])||isset($af['pass'])||isset($af['query'])||isset($af['fragment']))auth_error(lang(78));if(isset($af['scheme'])&&!preg_match('~^(https?)$~i',$af['scheme']))auth_error(lang(78));$dd=(isset($af['host'])?$af['host']:'').(isset($af['path'])?$af['path']:'');if(strpos(rtrim($dd,'/'),'/')!==false)auth_error(lang(78));if(isset($af['port'])&&($af['port']<1024||$af['port']>65535))auth_error(lang(79));}function
build_http_url($O,$V,$G,$Db,$Cb=null){if(!preg_match('~^(https?://)?([^:]*)(:\d+)?$~',rtrim($O,'/'),$C)){$this->error=lang(78);return
false;}return($C[1]?:"http://").($V!==""||$G!==""?"$V:$G@":"").($C[2]!==""?$C[2]:$Db).(isset($C[3])?$C[3]:($Cb?":$Cb":""));}function
add_invalid_login(){global$b;$p=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$p)return;$qd=unserialize(stream_get_contents($p));$Og=time();if($qd){foreach($qd
as$rd=>$X){if($X[0]<$Og)unset($qd[$rd]);}}$pd=&$qd[$b->bruteForceKey()];if(!$pd)$pd=array($Og+30*60,0);$pd[1]++;file_write_unlock($p,serialize($qd));}function
check_invalid_login(){global$b;$qd=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$pd=($qd?$qd[$b->bruteForceKey()]:array());if($pd===null)return;$le=($pd[1]>29?$pd[0]-time():0);if($le>0)auth_error(lang(80,ceil($le/60)));}$za=$_POST["auth"];if($za){session_regenerate_id();$Ah=$za["driver"];$O=trim($za["server"]);$V=$za["username"];$G=(string)$za["password"];$j=$za["db"];set_password($Ah,$O,$V,$G);$_SESSION["db"][$Ah][$O][$V][$j]=true;if($za["permanent"]){$x=base64_encode($Ah)."-".base64_encode($O)."-".base64_encode($V)."-".base64_encode($j);$qf=$b->permanentLogin(true);$ff[$x]="$x:".base64_encode($qf?encrypt_string($G,$qf):"");cookie("adminer_permanent",implode(" ",$ff));}if(count($_POST)==1||DRIVER!=$Ah||SERVER!=$O||$_GET["username"]!==$V||DB!=$j)redirect(auth_url($Ah,$O,$V,$j));}elseif($_POST["logout"]&&(!$Yc||verify_token())){foreach(array("pwds","db","dbs","queries")as$x)set_session($x,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(81));}elseif($ff&&!$_SESSION["pwds"]){session_regenerate_id();$qf=$b->permanentLogin();foreach($ff
as$x=>$X){list(,$Sa)=explode(":",$X);list($Ah,$O,$V,$j)=array_map('base64_decode',explode("-",$x));set_password($Ah,$O,$V,decrypt_string(base64_decode($Sa),$qf));$_SESSION["db"][$Ah][$O][$V][$j]=true;}}function
unset_permanent(){global$ff;foreach($ff
as$x=>$X){list($Ah,$O,$V,$j)=array_map('base64_decode',explode("-",$x));if($Ah==DRIVER&&$O==SERVER&&$V==$_GET["username"]&&$j==DB)unset($ff[$x]);}cookie("adminer_permanent",implode(" ",$ff));}function
auth_error($l){global$b,$Yc;$cg=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$cg]||$_GET[$cg])&&!$Yc)$l=lang(82);else{restart_session();add_invalid_login();$G=get_password();if($G!==null){if($G===false)$l.=($l?'<br>':'').lang(83,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$cg]&&$_GET[$cg]&&ini_bool("session.use_only_cookies"))$l=lang(84);$Ue=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Ue["lifetime"]);page_header(lang(27),$l,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(85)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(86),lang(87,implode(", ",$lf)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){validate_server_input();check_invalid_login();$f=connect();$k=new
Min_Driver($f);}$Nd=null;if(!is_object($f)||($Nd=$b->login($_GET["username"],get_password()))!==true){$l=(is_string($f)?h($f):(is_string($Nd)?$Nd:lang(78)));auth_error($l.(preg_match('~^ | $~',get_password())?'<br>'.lang(88):''));}if($_POST["logout"]&&$Yc&&!verify_token()){page_header(lang(77),lang(89));page_footer("db");exit;}if($za&&$_POST["token"])$_POST["token"]=$T;$l='';if($_POST){if(!verify_token()){$kd="max_input_vars";$Wd=ini_get($kd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$x){$X=ini_get($x);if($X&&(!$Wd||$X<$Wd)){$kd=$x;$Wd=$X;}}}$l=(!$_POST["token"]&&$Wd?lang(90,"'$kd'"):lang(89).' '.lang(91));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$l=lang(92,"'post_max_size'");if(isset($_GET["sql"]))$l.=' '.lang(93);}function
select($J,$g=null,$Je=array(),$y=0){global$w;$_=array();$v=array();$d=array();$Ha=array();$ih=array();$K=array();odd('');for($r=0;(!$y||$r<$y)&&($L=$J->fetch_row());$r++){if(!$r){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr>";for($vd=0;$vd<count($L);$vd++){$m=$J->fetch_field();$E=$m->name;$Ie=$m->orgtable;$He=$m->orgname;$K[$m->table]=$Ie;if($Je&&$w=="sql")$_[$vd]=($E=="table"?"table=":($E=="possible_keys"?"indexes=":null));elseif($Ie!=""){if(!isset($v[$Ie])){$v[$Ie]=array();foreach(indexes($Ie,$g)as$u){if($u["type"]=="PRIMARY"){$v[$Ie]=array_flip($u["columns"]);break;}}$d[$Ie]=$v[$Ie];}if(isset($d[$Ie][$He])){unset($d[$Ie][$He]);$v[$Ie][$He]=$vd;$_[$vd]=$Ie;}}if($m->charsetnr==63)$Ha[$vd]=true;$ih[$vd]=$m->type;echo"<th".($Ie!=""||$m->name!=$He?" title='".h(($Ie!=""?"$Ie.":"").$He)."'":"").">".h($E).($Je?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($E),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr".odd().">";foreach($L
as$x=>$X){$z="";if(isset($_[$x])&&!$d[$_[$x]]){if($Je&&$w=="sql"){$Q=$L[array_search("table=",$_)];$z=ME.$_[$x].urlencode($Je[$Q]!=""?$Je[$Q]:$Q);}else{$z=ME."edit=".urlencode($_[$x]);foreach($v[$_[$x]]as$Wa=>$vd)$z.="&where".urlencode("[".bracket_escape($Wa)."]")."=".urlencode($L[$vd]);}}elseif(is_url($X))$z=$X;if($X===null)$X="<i>NULL</i>";elseif($Ha[$x]&&!is_utf8($X))$X="<i>".lang(37,strlen($X))."</i>";else{$X=h($X);if($ih[$x]==254)$X="<code>$X</code>";}if($z)$X="<a href='".h($z)."'".(is_url($z)?target_blank():'').">$X</a>";echo"<td>$X";}}echo($r?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$K;}function
referencable_primary($Xf){$K=array();foreach(table_status('',true)as$Bg=>$Q){if($Bg!=$Xf&&fk_support($Q)){foreach(fields($Bg)as$m){if($m["primary"]){if($K[$Bg]){unset($K[$Bg]);break;}$K[$Bg]=$m;}}}}return$K;}function
adminer_settings(){parse_str($_COOKIE["adminer_settings"],$eg);return$eg;}function
adminer_setting($x){$eg=adminer_settings();return$eg[$x];}function
set_adminer_settings($eg){return
cookie("adminer_settings",http_build_query($eg+adminer_settings()));}function
textarea($E,$Y,$M=10,$ab=80){global$w;echo"<textarea name='".h($E)."' rows='$M' cols='$ab' class='sqlarea jush-$w' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
edit_type($x,$m,$Za,$Hc=array(),$uc=array()){global$ug,$ih,$ph,$ye;$U=$m["type"];echo'<td><select name="',h($x),'[type]" class="type" aria-labelledby="label-type">';if($U&&!isset($ih[$U])&&!isset($Hc[$U])&&!in_array($U,$uc))$uc[]=$U;if($Hc)$ug[lang(94)]=$Hc;echo
optionlist(array_merge($uc,$ug),$U),'</select><td><input name="',h($x),'[length]" value="',h($m["length"]),'" size="3"',(!$m["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"");echo' aria-labelledby="label-length"><td class="options">',"<select name='".h($x)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'").'><option value="">('.lang(95).')'.optionlist($Za,$m["collation"]).'</select>',($ph?"<select name='".h($x)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist($ph,$m["unsigned"]).'</select>':''),(isset($m['on_update'])?"<select name='".h($x)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(96).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$m["on_update"])?"CURRENT_TIMESTAMP":$m["on_update"])).'</select>':''),($Hc?"<select name='".h($x)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(97).")".optionlist(explode("|",$ye),$m["on_delete"])."</select> ":" ");}function
process_length($Jd){global$gc;return(preg_match("~^\\s*\\(?\\s*$gc(?:\\s*,\\s*$gc)*+\\s*\\)?\\s*\$~",$Jd)&&preg_match_all("~$gc~",$Jd,$C)?"(".implode(",",$C[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Jd)));}function
process_type($m,$Xa="COLLATE"){global$ph;if(DRIVER==='server'&&($m['unsigned']==='unsigned'||stripos((string)$m['type'],'int')!==false)&&min_version(8))$m["length"]='';return" $m[type]".process_length($m["length"]).(preg_match(number_type(),$m["type"])&&in_array($m["unsigned"],$ph)?" $m[unsigned]":"").(preg_match('~char|text|enum|set~',$m["type"])&&$m["collation"]?" $Xa ".q($m["collation"]):"");}function
process_field($m,$gh){return
array(idf_escape(trim($m["field"])),process_type($gh),($m["null"]?" NULL":" NOT NULL"),default_value($m),(preg_match('~timestamp|datetime~',$m["type"])&&$m["on_update"]?" ON UPDATE $m[on_update]":""),(support("comment")&&$m["comment"]!=""?" COMMENT ".q($m["comment"]):""),($m["auto_increment"]?auto_increment():null),);}function
default_value($m){$Bb=$m["default"];return($Bb===null?"":" DEFAULT ".(preg_match('~char|binary|text|enum|set~',$m["type"])||preg_match('~^(?![a-z])~i',$Bb)?q($Bb):$Bb));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$x=>$X){if(preg_match("~$x|$X~",$U))return" class='$x'";}}function
edit_fields($n,$Za,$U="TABLE",$Hc=array()){global$ld;$n=array_values($n);$Eb=(($_POST?$_POST["defaults"]:adminer_setting("defaults"))?"":" class='hidden'");$eb=(($_POST?$_POST["comments"]:adminer_setting("comments"))?"":" class='hidden'");echo'<thead><tr>
';if($U=="PROCEDURE"){echo'<td>';}echo'<th id="label-name">',($U=="TABLE"?lang(98):lang(99)),'<td id="label-type">',lang(39),'<textarea id="enum-edit" rows="4" cols="12" wrap="off" style="display: none;"></textarea>',script("qs('#enum-edit').onblur = editingLengthBlur;"),'<td id="label-length">',lang(100),'<td>',lang(101);if($U=="TABLE"){echo'<td id="label-null">NULL
<td><input type="radio" name="auto_increment_col" value=""><acronym id="label-ai" title="',lang(41),'">AI</acronym>',doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",)),'<td id="label-default"',$Eb,'>',lang(42),(support("comment")?"<td id='label-comment'$eb>".lang(40):"");}echo'<td>',"<input type='image' class='icon' name='add[".(support("move_col")?0:count($n))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.4")."' alt='+' title='".lang(102)."'>".script("row_count = ".count($n).";"),'</thead>
<tbody>
',script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($n
as$r=>$m){$r++;$Ke=$m[($_POST?"orig":"field")];$Mb=(isset($_POST["add"][$r-1])||(isset($m["field"])&&isset($_POST["drop_col"][$r])===false))&&(support("drop_col")||$Ke=="");echo'<tr',($Mb?"":" style='display: none;'"),'>
',($U=="PROCEDURE"?"<td>".html_select("fields[$r][inout]",explode("|",$ld),$m["inout"]):""),'<th>';if($Mb){echo'<input name="fields[',$r,'][field]" value="',h($m["field"]),'" data-maxlength="64" autocapitalize="off" aria-labelledby="label-name">';}echo'<input type="hidden" name="fields[',$r,'][orig]" value="',h($Ke),'">';edit_type("fields[$r]",$m,$Za,$Hc);if($U=="TABLE"){echo'<td>',checkbox("fields[$r][null]",1,$m["null"],"","","block","label-null"),'<td><label class="block"><input type="radio" name="auto_increment_col" value="',$r,'"';if($m["auto_increment"]){echo' checked';}echo' aria-labelledby="label-ai"></label><td',$Eb,'>',checkbox("fields[$r][has_default]",1,$m["has_default"],"","","","label-default"),'<input name="fields[',$r,'][default]" value="',h($m["default"]),'" aria-labelledby="label-default">',(support("comment")?"<td$eb><input name='fields[$r][comment]' value='".h($m["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");}echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$r]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.4")."' alt='+' title='".lang(102)."'> "."<input type='image' class='icon' name='up[$r]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=4.8.4")."' alt='↑' title='".lang(103)."'> "."<input type='image' class='icon' name='down[$r]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=4.8.4")."' alt='↓' title='".lang(104)."'> ":""),($Ke==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$r]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' alt='x' title='".lang(46)."'>":"");}}function
process_fields(&$n){$re=0;if($_POST["up"]){$Dd=0;foreach($n
as$x=>$m){if(key($_POST["up"])==$x){unset($n[$x]);array_splice($n,$Dd,0,array($m));break;}if(isset($m["field"]))$Dd=$re;$re++;}}elseif($_POST["down"]){$Jc=false;foreach($n
as$x=>$m){if(isset($m["field"])&&$Jc){unset($n[key($_POST["down"])]);array_splice($n,$re,0,array($Jc));break;}if(key($_POST["down"])==$x)$Jc=$m;$re++;}}elseif($_POST["add"]){$n=array_values($n);array_splice($n,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($B){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($B[0][0].$B[0][0],$B[0][0],substr($B[0],1,-1))),'\\'))."'";}function
grant($Oc,$sf,$d,$xe){if(!$sf)return
true;if($sf==array("ALL PRIVILEGES","GRANT OPTION"))return($Oc=="GRANT"?queries("$Oc ALL PRIVILEGES$xe WITH GRANT OPTION"):queries("$Oc ALL PRIVILEGES$xe")&&queries("$Oc GRANT OPTION$xe"));return
queries("$Oc ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$d, ",$sf).$d).$xe);}function
drop_create($Qb,$h,$Rb,$Lg,$Sb,$A,$ae,$Yd,$Zd,$ue,$je){if($_POST["drop"])query_redirect($Qb,$A,$ae);elseif($ue=="")query_redirect($h,$A,$Zd);elseif($ue!=$je){$pb=queries($h);queries_redirect($A,$Yd,$pb&&queries($Qb));if($pb)queries($Rb);}else
queries_redirect($A,$Yd,queries($Lg)&&queries($Sb)&&queries($Qb)&&queries($h));}function
create_trigger($xe,$L){global$w;$Qg=" $L[Timing] $L[Event]".(preg_match('~ OF~',$L["Event"])?" $L[Of]":"");return"CREATE TRIGGER ".idf_escape($L["Trigger"]).($w=="mssql"?$xe.$Qg:$Qg.$xe).rtrim(" $L[Type]\n$L[Statement]",";").";";}function
create_routine($Nf,$L){global$ld,$w;$P=array();$n=(array)$L["fields"];ksort($n);foreach($n
as$m){if($m["field"]!="")$P[]=(preg_match("~^($ld)\$~",$m["inout"])?"$m[inout] ":"").idf_escape($m["field"]).process_type($m,"CHARACTER SET");}$Fb=rtrim("\n$L[definition]",";");return"CREATE $Nf ".idf_escape(trim($L["name"]))." (".implode(", ",$P).")".(isset($_GET["function"])?" RETURNS".process_type($L["returns"],"CHARACTER SET"):"").($L["language"]?" LANGUAGE $L[language]":"").($w=="pgsql"?" AS ".q($Fb):"$Fb;");}function
remove_definer($I){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$I);}function
format_foreign_key($o){global$ye;$j=$o["db"];$ne=$o["ns"];return" FOREIGN KEY (".implode(", ",array_map('idf_escape',$o["source"])).") REFERENCES ".($j!=""&&$j!=$_GET["db"]?idf_escape($j).".":"").($ne!=""&&$ne!=$_GET["ns"]?idf_escape($ne).".":"").table($o["table"])." (".implode(", ",array_map('idf_escape',$o["target"])).")".(preg_match("~^($ye)\$~",$o["on_delete"])?" ON DELETE $o[on_delete]":"").(preg_match("~^($ye)\$~",$o["on_update"])?" ON UPDATE $o[on_update]":"");}function
tar_file($_c,$Vg){$K=pack("a100a8a8a8a12a12",$_c,644,0,0,decoct($Vg->size),decoct(time()));$Ra=8*32;for($r=0;$r<strlen($K);$r++)$Ra+=ord($K[$r]);$K.=sprintf("%06o",$Ra)."\0 ";echo$K,str_repeat("\0",512-strlen($K));$Vg->send();echo
str_repeat("\0",511-($Vg->size+511)%512);}function
ini_bytes($kd){$X=ini_get($kd);switch(strtolower(substr($X,-1))){case'g':$X*=1024;case'm':$X*=1024;case'k':$X*=1024;}return$X;}function
doc_link($cf,$Mg="<sup>?</sup>"){global$w,$f;$ag=$f->server_info;$Bh=preg_replace('~^(\d\.?\d).*~s','\1',$ag);$th=array('sql'=>"https://dev.mysql.com/doc/refman/$Bh/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/$Bh/",'mssql'=>"https://msdn.microsoft.com/library/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$ag)."&id=",);if(preg_match('~MariaDB~',$ag)){$th['sql']="https://mariadb.com/kb/en/library/";$cf['sql']=(isset($cf['mariadb'])?$cf['mariadb']:str_replace(".html","/",$cf['sql']));}return($cf[$w]?"<a href='".h($th[$w].$cf[$w])."'".target_blank().">$Mg</a>":"");}function
ob_gzencode($tg){return
gzencode($tg);}function
db_size($j){global$f;if(!$f->select_db($j))return"?";$K=0;foreach(table_status()as$R)$K+=$R["Data_length"]+$R["Index_length"];return
format_number($K);}function
set_utf8mb4($h){global$f;static$P=false;if(!$P&&preg_match('~\butf8mb4~i',$h)){$P=true;echo"SET NAMES ".charset($f).";\n\n";}}function
connect_error(){global$b,$f,$T,$l,$Pb;if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(26).": ".h(DB),lang(105),true);}else{if($_POST["db"]&&!$l)queries_redirect(substr(ME,0,-1),lang(106),drop_databases($_POST["db"]));page_header(lang(107),$l,false);$ma=['database'=>lang(108),'privileges'=>lang(60),'processlist'=>lang(109),'variables'=>lang(110),'status'=>lang(111),];$_=[];foreach($ma
as$x=>$X){if(support($x))$_[]="<a href='".h(ME)."$x='>$X</a>";}echo
generate_linksbar($_),"<p>".lang(112,$Pb[DRIVER],"<b>".h($f->server_info)."</b>","<b>$f->extension</b>")."\n","<p>".lang(113,"<b>".h(logged_user())."</b>")."\n";$i=$b->databases();if($i){$Tf=support("scheme");$Za=collations();echo"<form action='' method='post'>\n","<table cellspacing='0' class='checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(26)." - <a href='".h(ME)."refresh=1'>".lang(114)."</a>"."<td>".lang(115)."<td>".lang(116)."<td>".lang(117)." - <a href='".h(ME)."dbsize=1'>".lang(118)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$i=($_GET["dbsize"]?count_tables($i):array_flip($i));foreach($i
as$j=>$S){$Mf=h(ME)."db=".urlencode($j);$s=h("Db-".$j);echo"<tr".odd().">".(support("database")?"<td>".checkbox("db[]",$j,in_array($j,(array)$_POST["db"]),"","","",$s):""),"<th><a href='$Mf' id='$s'>".h($j)."</a>";$Ya=h(db_collation($j,$Za));echo"<td>".(support("database")?"<a href='$Mf".($Tf?"&amp;ns=":"")."&amp;database=' title='".lang(58)."'>$Ya</a>":$Ya),"<td align='right'><a href='$Mf&amp;schema=' id='tables-".h($j)."' title='".lang(59)."'>".($_GET["dbsize"]?$S:"?")."</a>","<td align='right' id='size-".h($j)."'>".($_GET["dbsize"]?db_size($j):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(119)." <span id='selected'></span></legend><div>\n"."<input type='hidden' name='all' value=''>".script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(120)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),"<input type='hidden' name='token' value='$T'>\n","</form>\n",script("tableCheck();");}}page_footer("db");}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$f->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}connect_error();exit;}$ye="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";class
TmpFile{var$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($kb){$this->size+=strlen($kb);fwrite($this->handler,$kb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}$gc="'(?:''|[^'\\\\]|\\\\.)*'";$ld="IN|OUT|INOUT";if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$n=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$N=array(idf_escape($_GET["field"]));$J=$k->select($a,$N,array(where($_GET,$n)),$N);$L=($J?$J->fetch_row():array());echo$k->value($L[0],$n[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$n=fields($a);if(!$n)$l=error();$R=table_status1($a,true);$E=$b->tableName($R);page_header(($n&&is_view($R)?$R['Engine']=='materialized view'?lang(121):lang(122):lang(123)).": ".($E!=""?$E:h($a)),$l);$b->selectLinks($R);$db=$R["Comment"];if($db!="")echo"<p class='nowrap'>".lang(40).": ".h($db)."\n";if($n)$b->tableStructurePrint($n);if(!is_view($R)){if(support("indexes")){echo"<h3 id='indexes'>".lang(124)."</h3>\n";$v=indexes($a);if($v)$b->tableIndexesPrint($v);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(125)."</a>\n";}if(fk_support($R)){echo"<h3 id='foreign-keys'>".lang(94)."</h3>\n";$Hc=foreign_keys($a);if($Hc){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(126)."<td>".lang(127)."<td>".lang(97)."<td>".lang(96)."<td></thead>\n";foreach($Hc
as$E=>$o){echo"<tr title='".h($E)."'>","<th><i>".implode("</i>, <i>",array_map('h',$o["source"]))."</i>","<td><a href='".h($o["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($o["db"]),ME):($o["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($o["ns"]),ME):ME))."table=".urlencode($o["table"])."'>".($o["db"]!=""?"<b>".h($o["db"])."</b>.":"").($o["ns"]!=""?"<b>".h($o["ns"])."</b>.":"").h($o["table"])."</a>","(<i>".implode("</i>, <i>",array_map('h',$o["target"]))."</i>)","<td>".h($o["on_delete"])."\n","<td>".h($o["on_update"])."\n",'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($E)).'">'.lang(128).'</a>';}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(129)."</a>\n";}}if(support(is_view($R)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(130)."</h3>\n";$fh=triggers($a);if($fh){echo"<table cellspacing='0'>\n";foreach($fh
as$x=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($x)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($x))."'>".lang(128)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(131)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(59),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Cg=array();$Dg=array();$ea=($_GET["schema"]?$_GET["schema"]:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$C,PREG_SET_ORDER);foreach($C
as$r=>$B){$Cg[$B[1]]=array($B[2],$B[3]);$Dg[]="\n\t'".js_escape($B[1])."': [ $B[2], $B[3] ]";}$Xg=0;$Ea=-1;$Sf=array();$Df=array();$Hd=array();foreach(table_status('',true)as$Q=>$R){if(is_view($R))continue;$if=0;$Sf[$Q]["fields"]=array();foreach(fields($Q)as$E=>$m){$if+=1.25;$m["pos"]=$if;$Sf[$Q]["fields"][$E]=$m;}$Sf[$Q]["pos"]=($Cg[$Q]?$Cg[$Q]:array($Xg,0));foreach($b->foreignKeys($Q)as$X){if(!$X["db"]){$Fd=$Ea;if($Cg[$Q][1]||$Cg[$X["table"]][1])$Fd=min(floatval($Cg[$Q][1]),floatval($Cg[$X["table"]][1]))-1;else$Ea-=.1;while($Hd[(string)$Fd])$Fd-=.0001;$Sf[$Q]["references"][$X["table"]][(string)$Fd]=array($X["source"],$X["target"]);$Df[$X["table"]][$Q][(string)$Fd]=$X["target"];$Hd[(string)$Fd]=true;}}$Xg=max($Xg,$Sf[$Q]["pos"][0]+2.5+$if);}echo'<div id="schema" style="height: ',$Xg,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = function () { return false; };
var tablePos = {',implode(",",$Dg)."\n",'};
var em = qs(\'#schema\').offsetHeight / ',$Xg,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Sf
as$E=>$Q){echo"<div class='table' style='top: ".$Q["pos"][0]."em; left: ".$Q["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($E).'"><b>'.h($E)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($Q["fields"]as$m){$X='<span'.type_class($m["type"]).' title="'.h($m["full_type"].($m["null"]?" NULL":'')).'">'.h($m["field"]).'</span>';echo"<br>".($m["primary"]?"<i>$X</i>":$X);}foreach((array)$Q["references"]as$Jg=>$Ef){foreach($Ef
as$Fd=>$Af){$Gd=$Fd-$Cg[$E][1];$r=0;foreach($Af[0]as$jg)echo"\n<div class='references' title='".h($Jg)."' id='refs$Fd-".($r++)."' style='left: $Gd"."em; top: ".$Q["fields"][$jg]["pos"]."em; padding-top: .5em;'><div style='border-top: 1px solid Gray; width: ".(-$Gd)."em;'></div></div>";}}foreach((array)$Df[$E]as$Jg=>$Ef){foreach($Ef
as$Fd=>$d){$Gd=$Fd-$Cg[$E][1];$r=0;foreach($d
as$Ig)echo"\n<div class='references' title='".h($Jg)."' id='refd$Fd-".($r++)."' style='left: $Gd"."em; top: ".$Q["fields"][$Ig]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=4.8.4")."'><div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$Gd)."em;'></div></div>";}}echo"\n</div>\n";}foreach($Sf
as$E=>$Q){foreach((array)$Q["references"]as$Jg=>$Ef){foreach($Ef
as$Fd=>$Af){$ce=$Xg;$Ud=-10;foreach($Af[0]as$x=>$jg){$jf=$Q["pos"][0]+$Q["fields"][$jg]["pos"];$kf=$Sf[$Jg]["pos"][0]+$Sf[$Jg]["fields"][$Af[1][$x]]["pos"];$ce=min($ce,$jf,$kf);$Ud=max($Ud,$jf,$kf);}echo"<div class='references' id='refl$Fd' style='left: $Fd"."em; top: $ce"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($Ud-$ce)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">',lang(132),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$l){$nb="";foreach(array("output","format","db_style","routines","events","table_style","auto_increment","triggers","data_style")as$x)$nb.="&$x=".urlencode($_POST[$x]);cookie("adminer_export",substr($nb,1));$S=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$sc=dump_headers((count($S)==1?key($S):DB),(DB==""||count($S)>1));$td=preg_match('~sql~',$_POST["format"]);if($td){echo"-- Adminer $ga ".$Pb[DRIVER]." ".str_replace("\n"," ",$f->server_info)." dump\n\n";if($w=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$f->query("SET time_zone = '+00:00'");$f->query("SET sql_mode = ''");}}$vg=$_POST["db_style"];$i=array(DB);if(DB==""){$i=$_POST["databases"];if(is_string($i))$i=explode("\n",rtrim(str_replace("\r","",$i),"\n"));}foreach((array)$i
as$j){$b->dumpDatabase($j);if($f->select_db($j)){if($td&&preg_match('~CREATE~',$vg)&&($h=$f->result("SHOW CREATE DATABASE ".idf_escape($j),1))){set_utf8mb4($h);if($vg=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($j).";\n";echo"$h;\n";}if($td){if($vg)echo
use_sql($j).";\n\n";$Pe="";if($_POST["routines"]){foreach(array("FUNCTION","PROCEDURE")as$Nf){foreach(get_rows("SHOW $Nf STATUS WHERE Db = ".q($j),null,"-- ")as$L){$h=remove_definer($f->result("SHOW CREATE $Nf ".idf_escape($L["Name"]),2));set_utf8mb4($h);$Pe.=($vg!='DROP+CREATE'?"DROP $Nf IF EXISTS ".idf_escape($L["Name"]).";;\n":"")."$h;;\n\n";}}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$L){$h=remove_definer($f->result("SHOW CREATE EVENT ".idf_escape($L["Name"]),3));set_utf8mb4($h);$Pe.=($vg!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($L["Name"]).";;\n":"")."$h;;\n\n";}}if($Pe)echo"DELIMITER ;;\n\n$Pe"."DELIMITER ;\n\n";}if($_POST["table_style"]||$_POST["data_style"]){$Dh=array();foreach(table_status('',true)as$E=>$R){$Q=(DB==""||in_array($E,(array)$_POST["tables"]));$vb=(DB==""||in_array($E,(array)$_POST["data"]));if($Q||$vb){if($sc=="tar"){$Vg=new
TmpFile;ob_start(array($Vg,'write'),1e5);}$b->dumpTable($E,($Q?$_POST["table_style"]:""),(is_view($R)?2:0));if(is_view($R))$Dh[]=$E;elseif($vb){$n=fields($E);$b->dumpData($E,$_POST["data_style"],"SELECT *".convert_fields($n,$n)." FROM ".table($E));}if($td&&$_POST["triggers"]&&$Q&&($fh=trigger_sql($E)))echo"\nDELIMITER ;;\n$fh\nDELIMITER ;\n";if($sc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$j/")."$E.csv",$Vg);}elseif($td)echo"\n";}}if(function_exists('foreign_keys_sql')){foreach(table_status('',true)as$E=>$R){$Q=(DB==""||in_array($E,(array)$_POST["tables"]));if($Q&&!is_view($R))echo
foreign_keys_sql($E);}}foreach($Dh
as$Ch)$b->dumpTable($Ch,$_POST["table_style"],1);if($sc=="tar")echo
pack("x512");}}}if($td)echo"-- ".$f->result("SELECT NOW()")."\n";exit;}page_header(lang(63),$l,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
';$zb=array('','USE','DROP+CREATE','CREATE');$Eg=array('','DROP+CREATE','CREATE');$wb=array('','TRUNCATE+INSERT','INSERT');if($w=="sql")$wb[]='INSERT+UPDATE';parse_str($_COOKIE["adminer_export"],$L);if(!$L)$L=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($L["events"])){$L["routines"]=$L["events"]=($_GET["dump"]=="");$L["triggers"]=$L["table_style"];}echo"<tr><th>".lang(133)."<td>".html_select("output",$b->dumpOutput(),$L["output"],0)."\n";echo"<tr><th>".lang(134)."<td>".html_select("format",$b->dumpFormat(),$L["format"],0)."\n";echo($w=="sqlite"?"":"<tr><th>".lang(26)."<td>".html_select('db_style',$zb,$L["db_style"]).(support("routine")?checkbox("routines",1,$L["routines"],lang(135)):"").(support("event")?checkbox("events",1,$L["events"],lang(136)):"")),"<tr><th>".lang(116)."<td>".html_select('table_style',$Eg,$L["table_style"]).checkbox("auto_increment",1,$L["auto_increment"],lang(41)).(support("trigger")?checkbox("triggers",1,$L["triggers"],lang(130)):""),"<tr><th>".lang(137)."<td>".html_select('data_style',$wb,$L["data_style"]),'</table>
<p><input type="submit" value="',lang(63),'">
<input type="hidden" name="token" value="',$T,'">

<table cellspacing="0">
',script("qsl('table').onclick = dumpClick;");$nf=array();if(DB!=""){$Pa=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$Pa>".lang(116)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(137)."<input type='checkbox' id='check-data'$Pa></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$Dh="";$Fg=tables_list();foreach($Fg
as$E=>$U){$mf=preg_replace('~_.*~','',$E);$Pa=($a==""||$a==(substr($a,-1)=="%"?"$mf%":$E));$pf="<tr><td>".checkbox("tables[]",$E,$Pa,$E,"","block");if($U!==null&&!preg_match('~table~i',$U))$Dh.="$pf\n";else
echo"$pf<td align='right'><label class='block'><span id='Rows-".h($E)."'></span>".checkbox("data[]",$E,$Pa)."</label>\n";$nf[$mf]++;}echo$Dh;if($Fg)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(26)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$i=$b->databases();if($i){foreach($i
as$j){if(!information_schema($j)){$mf=preg_replace('~_.*~','',$j);echo"<tr><td>".checkbox("databases[]",$j,$a==""||$a=="$mf%",$j,"","block")."\n";$nf[$mf]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$Bc=true;foreach($nf
as$x=>$X){if($x!=""&&$X>1){echo($Bc?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$x%")."'>".h($x)."</a>";$Bc=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(60));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(138)."</a>";$J=$f->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$Oc=$J;if(!$J)$J=$f->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo"<input type='hidden' name='db' value='".h(DB)."'>\n",($Oc?"":"<input type='hidden' name='grant' value=''>\n"),"<table cellspacing='0'>\n","<thead><tr><th>".lang(24)."<th>".lang(23)."<th></thead>\n";while($L=$J->fetch_assoc())echo'<tr'.odd().'><td>'.h($L["User"])."<td>".h($L["Host"]).'<td><a href="'.h(ME.'user='.urlencode($L["User"]).'&host='.urlencode($L["Host"])).'">'.lang(10)."</a>\n";if(!$Oc||DB!="")echo"<tr".odd()."><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$l&&$_POST["export"]){dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);exit;}restart_session();$cd=&get_session("queries");$bd=&$cd[DB];if(!$l&&$_POST["clear"]){$bd=array();redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(62):lang(55)),$l);if(!$l&&$_POST){$p=false;if(!isset($_GET["import"]))$I=$_POST["query"];elseif($_POST["webfile"]){$mg=$b->importServerPath();$p=@fopen((file_exists($mg)?$mg:"compress.zlib://$mg.gz"),"rb");$I=($p?fread($p,1e6):false);}else$I=get_file("sql_file",true);if(is_string($I)){if(function_exists('memory_get_usage'))@ini_set("memory_limit",max(ini_bytes("memory_limit"),2*strlen($I)+memory_get_usage()+8e6));if($I!=""&&strlen($I)<1e6){$H=$I.(preg_match("~;[ \t\r\n]*\$~",$I)?"":";");if(!$bd||reset(end($bd))!=$H){restart_session();$bd[]=array($H,time());set_session("queries",$cd);stop_session();}}$kg="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Hb=";";$re=0;$dc=true;$g=connect();if(is_object($g)&&DB!=""){$g->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$g);}$cb=0;$ic=array();$Ve='[\'"'.($w=="sql"?'`#':($w=="sqlite"?'`[':($w=="mssql"?'[':''))).']|/\*|-- |$'.($w=="pgsql"?'|\$[^$]*\$':'');$Yg=microtime(true);parse_str($_COOKIE["adminer_export"],$na);$Ub=$b->dumpFormat();unset($Ub["sql"]);while($I!=""){if(!$re&&preg_match("~^$kg*+DELIMITER\\s+(\\S+)~i",$I,$B)){$Hb=$B[1];$I=substr($I,strlen($B[0]));}else{preg_match('('.preg_quote($Hb)."\\s*|$Ve)",$I,$B,PREG_OFFSET_CAPTURE,$re);list($Jc,$if)=$B[0];if(!$Jc&&$p&&!feof($p))$I.=fread($p,1e5);else{if(!$Jc&&rtrim($I)=="")break;$re=$if+strlen($Jc);if($Jc&&rtrim($Jc)!=$Hb){while(preg_match('('.($Jc=='/*'?'\*/':($Jc=='['?']':(preg_match('~^-- |^#~',$Jc)?"\n":preg_quote($Jc)."|\\\\."))).'|$)s',$I,$B,PREG_OFFSET_CAPTURE,$re)){$Qf=$B[0][0];if(!$Qf&&$p&&!feof($p))$I.=fread($p,1e5);else{$re=$B[0][1]+strlen($Qf);if($Qf[0]!="\\")break;}}}else{$dc=false;$H=substr($I,0,$if);$cb++;$pf="<pre id='sql-$cb'><code class='jush-$w copy-to-clipboard'>".$b->sqlCommandQuery($H)."</code></pre>\n";$pf.=generate_linksbar(["<a href='#' class='copy-to-clipboard'>".lang(36)."</a>"]);if($w=="sqlite"&&preg_match("~^$kg*+ATTACH\\b~i",$H,$B)){echo$pf,"<p class='error'>".lang(139)."\n";$ic[]=" <a href='#sql-$cb'>$cb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$pf;ob_flush();flush();}$pg=microtime(true);if($f->multi_query($H)&&is_object($g)&&preg_match("~^$kg*+USE\\b~i",$H))$g->query($H);do{$J=$f->store_result();if($f->error){echo($_POST["only_errors"]?$pf:""),"<p class='error'>".lang(140).($f->errno?" ($f->errno)":"").": ".error()."\n";$ic[]=" <a href='#sql-$cb'>$cb</a>";if($_POST["error_stops"])break
2;}else{$Og=" <span class='time'>(".format_time($pg).")</span>".(strlen($H)<1000?" <a href='".h(ME)."sql=".urlencode(trim($H))."'>".lang(10)."</a>":"");$pa=$f->affected_rows;$Gh=($_POST["only_errors"]?"":$k->warnings());$Hh="warnings-$cb";if($Gh)$Og.=", <a href='#$Hh'>".lang(35)."</a>".script("qsl('a').onclick = partial(toggle, '$Hh');","");$qc=null;$rc="explain-$cb";if(is_object($J)){$y=$_POST["limit"];$Je=select($J,$g,array(),$y);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$oe=$J->num_rows;echo"<p>".($oe?($y&&$oe>$y?lang(141,$y):"").lang(142,$oe):""),$Og;if($g&&preg_match("~^($kg|\\()*+SELECT\\b~i",$H)&&($qc=explain($g,$H)))echo", <a href='#$rc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$rc');","");$s="export-$cb";echo", <a href='#$s'>".lang(63)."</a>".script("qsl('a').onclick = partial(toggle, '$s');","")."<span id='$s' class='hidden'>: ".html_select("output",$b->dumpOutput(),$na["output"])." ".html_select("format",$Ub,$na["format"])."<input type='hidden' name='query' value='".h($H)."'>"." <input type='submit' name='export' value='".lang(63)."'><input type='hidden' name='token' value='$T'></span>\n"."</form>\n";}}else{if(preg_match("~^$kg*+(CREATE|DROP|ALTER)$kg++(DATABASE|SCHEMA)\\b~i",$H)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h($f->info)."'>".lang(143,$pa)."$Og\n";}echo($Gh?"<div id='$Hh' class='hidden'>\n$Gh</div>\n":"");if($qc){echo"<div id='$rc' class='hidden'>\n";select($qc,$g,$Je);echo"</div>\n";}}$pg=microtime(true);}while($f->next_result());}$I=substr($I,$re);$re=0;}}}}if($dc)echo"<p class='message'>".lang(144)."\n";elseif($_POST["only_errors"]){echo"<p class='message'>".lang(145,$cb-count($ic))," <span class='time'>(".format_time($Yg).")</span>\n";}elseif($ic&&$cb>1)echo"<p class='error'>".lang(140).": ".implode("",$ic)."\n";}else
echo"<p class='error'>".upload_error($I)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$oc="<input type='submit' value='".lang(146)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$H=$_GET["sql"];if($_POST)$H=$_POST["query"];elseif($_GET["history"]=="all")$H=$bd;elseif($_GET["history"]!="")$H=$bd[$_GET["history"]][0];echo"<p>";textarea("query",$H,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>$oc\n",lang(147).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(148)."</legend><div>";$Uc=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$Uc (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$oc":lang(149)),"</div></fieldset>\n";$hd=$b->importServerPath();if($hd){echo"<fieldset><legend>".lang(150)."</legend><div>",lang(151,"<code>".h($hd)."$Uc</code>"),' <input type="submit" name="webfile" value="'.lang(152).'">',"</div></fieldset>\n";}echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(153))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(154))."\n","<input type='hidden' name='token' value='$T'>\n";if(!isset($_GET["import"])&&$bd){print_fieldset("history",lang(155),$_GET["history"]!="");for($X=end($bd);$X;$X=prev($bd)){$x=key($bd);list($H,$Og,$Yb)=$X;echo'<a href="'.h(ME."sql=&history=$x").'" class="edit" title="'.lang(10).'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$Og)."'>".@date("H:i:s",$Og)."</span>"." <code class='jush-$w'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$H)))),80,"</code>").($Yb?" <span class='time'>($Yb)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(156)."'>\n","<a href='".h(ME."sql=&history=all")."' class='edit-all' title='".lang(157)."'>".lang(157)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$n=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$n):""):where($_GET,$n));$qh=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($n
as$E=>$m){if(!isset($m["privileges"][$qh?"update":"insert"])||$b->fieldName($m)==""||$m["generated"])unset($n[$E]);}if($_POST&&!$l&&!isset($_GET["select"])){$A=$_POST["referer"];if($_POST["insert"])$A=($qh?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$A))$A=ME."select=".urlencode($a);$v=indexes($a);$lh=unique_array($_GET["where"],$v);$xf="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($A,lang(158),$k->delete($a,$xf,!$lh));else{$P=array();foreach($n
as$E=>$m){$X=process_input($m);if($X!==false&&$X!==null)$P[idf_escape($E)]=$X;}if($qh){if(!$P)redirect($A);queries_redirect($A,lang(159),$k->update($a,$P,$xf,!$lh));if(is_ajax()){page_headers();page_messages($l);exit;}}else{$J=$k->insert($a,$P);$Ed=($J?last_id():0);queries_redirect($A,lang(160,($Ed?" $Ed":"")),$J);}}}$L=null;if($_POST["save"])$L=(array)$_POST["fields"];elseif($Z){$N=array();foreach($n
as$E=>$m){if(isset($m["privileges"]["select"])){$wa=convert_field($m);if($_POST["clone"]&&$m["auto_increment"])$wa="''";if($w=="sql"&&preg_match("~enum|set~",$m["type"]))$wa="1*".idf_escape($E);$N[]=($wa?"$wa AS ":"").idf_escape($E);}}$L=array();if(!support("table"))$N=array("*");if($N){$J=$k->select($a,$N,array($Z),$N,array(),(isset($_GET["select"])?2:1));if(!$J)$l=error();else{$L=$J->fetch_assoc();if(!$L)$L=false;}if(isset($_GET["select"])&&(!$L||$J->fetch_assoc()))$L=null;}}if(!support("table")&&!$n){if(!$Z){$J=$k->select($a,array("*"),$Z,array("*"));$L=($J?$J->fetch_assoc():false);if(!$L)$L=array($k->primary=>"");}if($L){foreach($L
as$x=>$X){if(!$Z)$L[$x]=null;$n[$x]=array("field"=>$x,"null"=>($x!=$k->primary),"auto_increment"=>($x==$k->primary));}}}edit_form($a,$n,$L,$qh);}elseif(isset($_GET["create"])){$a=$_GET["create"];$We=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$x)$We[$x]=$x;$Cf=referencable_primary($a);$Hc=array();foreach($Cf
as$Bg=>$m)$Hc[str_replace("`","``",$Bg)."`".str_replace("`","``",$m["field"])]=$Bg;$Me=array();$R=array();if($a!=""){$Me=fields($a);$R=table_status($a);if(!$R)$l=lang(9);}$L=$_POST;$L["fields"]=(array)$L["fields"];if($L["auto_increment_col"])$L["fields"][$L["auto_increment_col"]]["auto_increment"]=true;if($_POST)set_adminer_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($L["fields"])&&!$l){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(161),drop_tables(array($a)));else{$n=array();$ta=array();$uh=false;$Fc=array();$Le=reset($Me);$ra=" FIRST";foreach($L["fields"]as$x=>$m){$o=$Hc[$m["type"]];$gh=($o!==null?$Cf[$o]:$m);if($m["field"]!=""){if(!$m["has_default"])$m["default"]=null;if($x==$L["auto_increment_col"])$m["auto_increment"]=true;$uf=process_field($m,$gh);$ta[]=array($m["orig"],$uf,$ra);if(!$Le||$uf!=process_field($Le,$Le)){$n[]=array($m["orig"],$uf,$ra);if($m["orig"]!=""||$ra)$uh=true;}if($o!==null)$Fc[idf_escape($m["field"])]=($a!=""&&$w!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$Hc[$m["type"]],'source'=>array($m["field"]),'target'=>array($gh["field"]),'on_delete'=>$m["on_delete"],));$ra=" AFTER ".idf_escape($m["field"]);}elseif($m["orig"]!=""){$uh=true;$n[]=array($m["orig"]);}if($m["orig"]!=""){$Le=next($Me);if(!$Le)$ra="";}}$Ye="";if($We[$L["partition_by"]]){$Ze=array();if($L["partition_by"]=='RANGE'||$L["partition_by"]=='LIST'){foreach(array_filter($L["partition_names"])as$x=>$X){$Y=$L["partition_values"][$x];$Ze[]="\n  PARTITION ".idf_escape($X)." VALUES ".($L["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$Ye.="\nPARTITION BY $L[partition_by]($L[partition])".($Ze?" (".implode(",",$Ze)."\n)":($L["partitions"]?" PARTITIONS ".(+$L["partitions"]):""));}elseif(support("partitioning")&&preg_match("~partitioned~",$R["Create_options"]))$Ye.="\nREMOVE PARTITIONING";$D=lang(162);if($a==""){cookie("adminer_engine",$L["Engine"]);$D=lang(163);}$E=trim($L["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($E),$D,alter_table($a,$E,($w=="sqlite"&&($uh||$Fc)?$ta:$n),$Fc,($L["Comment"]!=$R["Comment"]?$L["Comment"]:null),($L["Engine"]&&$L["Engine"]!=$R["Engine"]?$L["Engine"]:""),($L["Collation"]&&$L["Collation"]!=$R["Collation"]?$L["Collation"]:""),($L["Auto_increment"]!=""?number($L["Auto_increment"]):""),$Ye));}}page_header(($a!=""?lang(33):lang(64)),$l,array("table"=>$a),h($a));if(!$_POST){$L=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($ih["int"])?"int":(isset($ih["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$L=$R;$L["name"]=$a;$L["fields"]=array();if(!$_GET["auto_increment"])$L["Auto_increment"]="";foreach($Me
as$m){$m["has_default"]=isset($m["default"]);$L["fields"][]=$m;}if(support("partitioning")){$Lc="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($a);$J=$f->query("SELECT PARTITION_METHOD, PARTITION_ORDINAL_POSITION, PARTITION_EXPRESSION $Lc ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");list($L["partition_by"],$L["partitions"],$L["partition"])=$J->fetch_row();$Ze=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $Lc AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$Ze[""]="";$L["partition_names"]=array_keys($Ze);$L["partition_values"]=array_values($Ze);}}}$Za=collations();$fc=engines();foreach($fc
as$ec){if(!strcasecmp($ec,$L["Engine"])){$L["Engine"]=$ec;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(164),': <input name="name" data-maxlength="64" value="',h($L["name"]),'" autocapitalize="off">
';if($a==""&&!$_POST)echo
script("focus(qs('#form')['name']);");echo($fc?"<select name='Engine'>".optionlist(array(""=>"(".lang(165).")")+$fc,$L["Engine"])."</select>".on_help("getTarget(event).value",1).script("qsl('select').onchange = helpClose;"):""),' ',($Za&&!preg_match("~sqlite|mssql~",$w)?html_select("Collation",array(""=>"(".lang(95).")")+$Za,$L["Collation"]):""),' <input type="submit" value="',lang(14),'">
';}echo'
';if(support("columns")){echo'<div class="scrollable">
<table cellspacing="0" id="edit-fields" class="nowrap">
';edit_fields($L["fields"],$Za,"TABLE",$Hc);echo'</table>
',script("editFields();"),'</div>
<p>
',lang(41),': <input type="number" name="Auto_increment" size="6" value="',h($L["Auto_increment"]),'">
',checkbox("defaults",1,($_POST?$_POST["defaults"]:adminer_setting("defaults")),lang(166),"columnShow(this.checked, 5)","jsonly");$fb=($_POST?$_POST["comments"]:adminer_setting("comments"));echo(support("comment")?checkbox("comments",1,$fb,lang(40),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$L["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($fb?"":" class='hidden'").">".h($L["Comment"])."</textarea>":'<input name="Comment" value="'.h($L["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($fb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(120),'">',confirm(lang(167,$a));}if(support("partitioning")){$Xe=preg_match('~RANGE|LIST~',$L["partition_by"]);print_fieldset("partition",lang(168),$L["partition_by"]);echo'<p>
',"<select name='partition_by'>".optionlist(array(""=>"")+$We,$L["partition_by"])."</select>".on_help("getTarget(event).value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),'(<input name="partition" value="',h($L["partition"]),'">)
',lang(169),': <input type="number" name="partitions" class="size',($Xe||!$L["partition_by"]?" hidden":""),'" value="',h($L["partitions"]),'">
<table cellspacing="0" id="partition-table"',($Xe?"":" class='hidden'"),'>
<thead><tr><th>',lang(170),'<th>',lang(171),'</thead>
';foreach($L["partition_names"]as$x=>$X){echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($x==count($L["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($L["partition_values"][$x]).'">';}echo'</table>
</div></fieldset>
';}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$jd=array("PRIMARY","UNIQUE","INDEX");$R=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$R["Engine"]))$jd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$R["Engine"]))$jd[]="SPATIAL";$v=indexes($a);$of=array();if($w=="mongo"){$of=$v["_id_"];unset($jd[0]);unset($v["_id_"]);}$L=$_POST;if($_POST&&!$l&&!$_POST["add"]&&!$_POST["drop_col"]){$ua=array();foreach($L["indexes"]as$u){$E=$u["name"];if(in_array($u["type"],$jd)){$d=array();$Kd=array();$Jb=array();$P=array();ksort($u["columns"]);foreach($u["columns"]as$x=>$c){if($c!=""){$Jd=$u["lengths"][$x];$Ib=$u["descs"][$x];$P[]=idf_escape($c).($Jd?"(".(+$Jd).")":"").($Ib?" DESC":"");$d[]=$c;$Kd[]=($Jd?$Jd:null);$Jb[]=$Ib;}}if($d){$pc=$v[$E];if($pc){ksort($pc["columns"]);ksort($pc["lengths"]);ksort($pc["descs"]);if($u["type"]==$pc["type"]&&array_values($pc["columns"])===$d&&(!$pc["lengths"]||array_values($pc["lengths"])===$Kd)&&array_values($pc["descs"])===$Jb){unset($v[$E]);continue;}}$ua[]=array($u["type"],$E,$P);}}}foreach($v
as$E=>$pc)$ua[]=array($pc["type"],$E,"DROP");if(!$ua)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(172),alter_indexes($a,$ua));}page_header(lang(124),$l,array("table"=>$a),h($a));$n=array_keys(fields($a));if($_POST["add"]){foreach($L["indexes"]as$x=>$u){if($u["columns"][count($u["columns"])]!="")$L["indexes"][$x]["columns"][]="";}$u=end($L["indexes"]);if($u["type"]||array_filter($u["columns"],'strlen'))$L["indexes"][]=array("columns"=>array(1=>""));}if(!$L){foreach($v
as$x=>$u){$v[$x]["name"]=$x;$v[$x]["columns"][]="";}$v[]=array("columns"=>array(1=>""));$L["indexes"]=$v;}echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
<thead><tr>
<th id="label-type">',lang(173),'<th><input type="submit" class="wayoff">',lang(174),'<th id="label-name">',lang(175),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.4")."' alt='+' title='".lang(102)."'>",'</noscript>
</thead>
';if($of){echo"<tr><td>PRIMARY<td>";foreach($of["columns"]as$x=>$c){echo
select_input(" disabled",$n,$c),"<label><input disabled type='checkbox'>".lang(50)."</label> ";}echo"<td><td>\n";}$vd=1;foreach($L["indexes"]as$u){if(!$_POST["drop_col"]||$vd!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$vd][type]",array(-1=>"")+$jd,$u["type"],($vd==count($L["indexes"])?"indexesAddRow.call(this);":1),"label-type"),"<td>";ksort($u["columns"]);$r=1;foreach($u["columns"]as$x=>$c){echo"<span>".select_input(" name='indexes[$vd][columns][$r]' title='".lang(38)."'",($n?array_combine($n,$n):$n),$c,"partial(".($r==count($u["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape($w=="sql"?"":$_GET["indexes"]."_")."')"),($w=="sql"||$w=="mssql"?"<input type='number' name='indexes[$vd][lengths][$r]' class='size' value='".h($u["lengths"][$x])."' title='".lang(100)."'>":""),(support("descidx")?checkbox("indexes[$vd][descs][$r]",1,$u["descs"][$x],lang(50)):"")," </span>";$r++;}echo"<td><input name='indexes[$vd][name]' value='".h($u["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$vd]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.4")."' alt='x' title='".lang(46)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$vd++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["database"])){$L=$_POST;if($_POST&&!$l&&!isset($_POST["add_x"])){$E=trim($L["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(176),drop_databases(array(DB)));}elseif(DB!==$E){if(DB!=""){$_GET["db"]=$E;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($E),lang(177),rename_database($E,$L["collation"]));}else{$i=explode("\n",str_replace("\r","",$E));$wg=true;$Dd="";foreach($i
as$j){if(count($i)==1||$j!=""){if(!create_database($j,$L["collation"]))$wg=false;$Dd=$j;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($Dd),lang(178),$wg);}}else{if(!$L["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($E).(preg_match('~^[a-z0-9_]+$~i',$L["collation"])?" COLLATE $L[collation]":""),substr(ME,0,-1),lang(179));}}page_header(DB!=""?lang(58):lang(108),$l,array(),h(DB));$Za=collations();$E=DB;if($_POST)$E=$L["name"];elseif(DB!="")$L["collation"]=db_collation(DB,$Za);elseif($w=="sql"){foreach(get_vals("SHOW GRANTS")as$Oc){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$Oc,$B)&&$B[1]){$E=stripcslashes(idf_unescape("`$B[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($E,"\n")?'<textarea id="name" name="name" rows="10" cols="40">'.h($E).'</textarea><br>':'<input name="name" id="name" value="'.h($E).'" data-maxlength="64" autocapitalize="off">')."\n".($Za?html_select("collation",array(""=>"(".lang(95).")")+$Za,$L["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",)):""),script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(120)."'>".confirm(lang(167,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.4")."' alt='+' title='".lang(102)."'>\n";echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?$_GET["name"]:$_GET["call"]);page_header(lang(180).": ".h($da),$l);$Nf=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$id=array();$Pe=array();foreach($Nf["fields"]as$r=>$m){if(substr($m["inout"],-3)=="OUT")$Pe[$r]="@".idf_escape($m["field"])." AS ".idf_escape($m["field"]);if(!$m["inout"]||substr($m["inout"],0,2)=="IN")$id[]=$r;}if(!$l&&$_POST){$La=array();foreach($Nf["fields"]as$x=>$m){if(in_array($x,$id)){$X=process_input($m);if($X===false)$X="''";if(isset($Pe[$x]))$f->query("SET @".idf_escape($m["field"])." = $X");}$La[]=(isset($Pe[$x])?"@".idf_escape($m["field"]):$X);}$I=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$La).")";$pg=microtime(true);$J=$f->multi_query($I);$pa=$f->affected_rows;echo$b->selectQuery($I,$pg,!$J);if(!$J)echo"<p class='error'>".error()."\n";else{$g=connect();if(is_object($g))$g->select_db(DB);do{$J=$f->store_result();if(is_object($J))select($J,$g);else
echo"<p class='message'>".lang(181,$pa)." <span class='time'>".@date("H:i:s")."</span>\n";}while($f->next_result());if($Pe)select($f->query("SELECT ".implode(", ",$Pe)));}}echo'
<form action="" method="post">
';if($id){echo"<table cellspacing='0' class='layout'>\n";foreach($id
as$x){$m=$Nf["fields"][$x];$E=$m["field"];echo"<tr><th>".$b->fieldName($m);$Y=$_POST["fields"][$E];if($Y!=""){if($m["type"]=="enum")$Y=+$Y;if($m["type"]=="set")$Y=array_sum($Y);}input($m,$Y,(string)$_POST["function"][$E]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(180),'">
<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$E=$_GET["name"];$L=$_POST;if($_POST&&!$l&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){$D=($_POST["drop"]?lang(182):($E!=""?lang(183):lang(184)));$A=ME."table=".urlencode($a);if(!$_POST["drop"]){$L["source"]=array_filter($L["source"],'strlen');ksort($L["source"]);$Ig=array();foreach($L["source"]as$x=>$X)$Ig[$x]=$L["target"][$x];$L["target"]=$Ig;}if($w=="sqlite")queries_redirect($A,$D,recreate_table($a,$a,array(),array(),array(" $E"=>($_POST["drop"]?"":" ".format_foreign_key($L)))));else{$ua="ALTER TABLE ".table($a);$Qb="\nDROP ".($w=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($E);if($_POST["drop"])query_redirect($ua.$Qb,$A,$D);else{query_redirect($ua.($E!=""?"$Qb,":"")."\nADD".format_foreign_key($L),$A,$D);$l=lang(185)."<br>$l";}}}page_header(lang(186),$l,array("table"=>$a),h($a));if($_POST){ksort($L["source"]);if($_POST["add"])$L["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$L["target"]=array();}elseif($E!=""){$Hc=foreign_keys($a);$L=$Hc[$E];$L["source"][]="";}else{$L["table"]=$a;$L["source"]=array("");}echo'
<form action="" method="post">
';$jg=array_keys(fields($a));if($L["db"]!="")$f->select_db($L["db"]);if($L["ns"]!="")set_schema($L["ns"]);$Bf=array_keys(array_filter(table_status('',true),'fk_support'));$Ig=array_keys(fields(in_array($L["table"],$Bf)?$L["table"]:reset($Bf)));$ze="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(187).": ".html_select("table",$Bf,$L["table"],$ze)."\n";if($w=="pgsql")echo
lang(188).": ".html_select("ns",$b->schemas(),$L["ns"]!=""?$L["ns"]:$_GET["ns"],$ze);elseif($w!="sqlite"){$_b=array();foreach($b->databases()as$j){if(!information_schema($j))$_b[]=$j;}echo
lang(66).": ".html_select("db",$_b,$L["db"]!=""?$L["db"]:$_GET["db"],$ze);}echo'<input type="hidden" name="change-js" value="">
<noscript><p><input type="submit" name="change" value="',lang(189),'"></noscript>
<table cellspacing="0">
<thead><tr><th id="label-source">',lang(126),'<th id="label-target">',lang(127),'</thead>
';$vd=0;foreach($L["source"]as$x=>$X){echo"<tr>","<td>".html_select("source[".(+$x)."]",array(-1=>"")+$jg,$X,($vd==count($L["source"])-1?"foreignAddRow.call(this);":1),"label-source"),"<td>".html_select("target[".(+$x)."]",$Ig,isset($L["target"][$x])?$L["target"][$x]:null,1,"label-target");$vd++;}echo'</table>
<p>
',lang(97),': ',html_select("on_delete",array(-1=>"")+explode("|",$ye),$L["on_delete"]),' ',lang(96),': ',html_select("on_update",array(-1=>"")+explode("|",$ye),$L["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(190),'"></noscript>
';if($E!=""){echo'<input type="submit" name="drop" value="',lang(120),'">',confirm(lang(167,$E));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$L=$_POST;$Ne="VIEW";if($w=="pgsql"&&$a!=""){$qg=table_status($a);$Ne=strtoupper($qg["Engine"]);}if($_POST&&!$l){$E=trim($L["name"]);$wa=" AS\n$L[select]";$A=ME."table=".urlencode($E);$D=lang(191);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$E&&$w!="sqlite"&&$U=="VIEW"&&$Ne=="VIEW")query_redirect(($w=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($E).$wa,$A,$D);else{$Kg=$E."_adminer_".uniqid();drop_create("DROP $Ne ".table($a),"CREATE $U ".table($E).$wa,"DROP $U ".table($E),"CREATE $U ".table($Kg).$wa,"DROP $U ".table($Kg),($_POST["drop"]?substr(ME,0,-1):$A),lang(192),$D,lang(193),$a,$E);}}if(!$_POST&&$a!=""){$L=view($a);$L["name"]=$a;$L["materialized"]=($Ne!="VIEW");if(!$l)$l=error();}page_header(($a!=""?lang(32):lang(194)),$l,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(175),': <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$L["materialized"],lang(121)):""),'<p>';textarea("select",$L["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(120),'">',confirm(lang(167,$a));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$od=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$rg=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$L=$_POST;if($_POST&&!$l){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(195));elseif(in_array($L["INTERVAL_FIELD"],$od)&&isset($rg[$L["STATUS"]])){$Rf="\nON SCHEDULE ".($L["INTERVAL_VALUE"]?"EVERY ".q($L["INTERVAL_VALUE"])." $L[INTERVAL_FIELD]".($L["STARTS"]?" STARTS ".q($L["STARTS"]):"").($L["ENDS"]?" ENDS ".q($L["ENDS"]):""):"AT ".q($L["STARTS"]))." ON COMPLETION".($L["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(196):lang(197)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Rf.($aa!=$L["EVENT_NAME"]?"\nRENAME TO ".idf_escape($L["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($L["EVENT_NAME"]).$Rf)."\n".$rg[$L["STATUS"]]." COMMENT ".q($L["EVENT_COMMENT"]).rtrim(" DO\n$L[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(198).": ".h($aa):lang(199)),$l);if(!$L&&$aa!=""){$M=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$L=reset($M);}echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(175),'<td><input name="EVENT_NAME" value="',h($L["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(200),'<td><input name="STARTS" value="',h("$L[EXECUTE_AT]$L[STARTS]"),'">
<tr><th title="datetime">',lang(201),'<td><input name="ENDS" value="',h($L["ENDS"]),'">
<tr><th>',lang(202),'<td><input type="number" name="INTERVAL_VALUE" value="',h($L["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$od,$L["INTERVAL_FIELD"]),'<tr><th>',lang(111),'<td>',html_select("STATUS",$rg,$L["STATUS"]),'<tr><th>',lang(40),'<td><input name="EVENT_COMMENT" value="',h($L["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$L["ON_COMPLETION"]=="PRESERVE",lang(203)),'</table>
<p>';textarea("EVENT_DEFINITION",$L["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!=""){echo'<input type="submit" name="drop" value="',lang(120),'">',confirm(lang(167,$aa));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?$_GET["name"]:$_GET["procedure"]);$Nf=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$L=$_POST;$L["fields"]=(array)$L["fields"];if($_POST&&!process_fields($L["fields"])&&!$l){$Ke=routine($_GET["procedure"],$Nf);$Kg="$L[name]_adminer_".uniqid();drop_create("DROP $Nf ".routine_id($da,$Ke),create_routine($Nf,$L),"DROP $Nf ".routine_id($L["name"],$L),create_routine($Nf,array("name"=>$Kg)+$L),"DROP $Nf ".routine_id($Kg,$L),substr(ME,0,-1),lang(204),lang(205),lang(206),$da,$L["name"]);}page_header(($da!=""?(isset($_GET["function"])?lang(207):lang(208)).": ".h($da):(isset($_GET["function"])?lang(209):lang(210))),$l);if(!$_POST&&$da!=""){$L=routine($_GET["procedure"],$Nf);$L["name"]=$da;}$Za=get_vals("SHOW CHARACTER SET");sort($Za);$Of=routine_languages();echo'
<form action="" method="post" id="form">
<p>',lang(175),': <input name="name" value="',h($L["name"]),'" data-maxlength="64" autocapitalize="off">
',($Of?lang(19).": ".html_select("language",$Of,$L["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
';edit_fields($L["fields"],$Za,$Nf);if(isset($_GET["function"])){echo"<tr><td>".lang(211);edit_type("returns",$L["returns"],$Za,array(),($w=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$L["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($da!=""){echo'<input type="submit" name="drop" value="',lang(120),'">',confirm(lang(167,$da));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$E=$_GET["name"];$eh=trigger_options();$L=(array)trigger($E,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$l&&in_array($_POST["Timing"],$eh["Timing"])&&in_array($_POST["Event"],$eh["Event"])&&in_array($_POST["Type"],$eh["Type"])){$xe=" ON ".table($a);$Qb="DROP TRIGGER ".idf_escape($E).($w=="pgsql"?$xe:"");$A=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($Qb,$A,lang(212));else{if($E!="")queries($Qb);queries_redirect($A,($E!=""?lang(213):lang(214)),queries(create_trigger($xe,$_POST)));if($E!="")queries(create_trigger($xe,$L+array("Type"=>reset($eh["Type"]))));}}$L=$_POST;}page_header(($E!=""?lang(215).": ".h($E):lang(216)),$l,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table cellspacing="0" class="layout">
<tr><th>',lang(217),'<td>',html_select("Timing",$eh["Timing"],$L["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(218),'<td>',html_select("Event",$eh["Event"],$L["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$eh["Event"])?" <input name='Of' value='".h($L["Of"])."' class='hidden'>":""),'<tr><th>',lang(39),'<td>',html_select("Type",$eh["Type"],$L["Type"]),'</table>
<p>',lang(175),': <input name="Trigger" value="',h($L["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$L["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($E!=""){echo'<input type="submit" name="drop" value="',lang(120),'">',confirm(lang(167,$E));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["user"])){$fa=$_GET["user"];$sf=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$L){foreach(explode(",",($L["Privilege"]=="Grant option"?"":$L["Context"]))as$lb)$sf[$lb][$L["Privilege"]]=$L["Comment"];}$sf["Server Admin"]+=$sf["File access on server"];$sf["Databases"]["Create routine"]=$sf["Procedures"]["Create routine"];unset($sf["Procedures"]["Create routine"]);$sf["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$sf["Columns"][$X]=$sf["Tables"][$X];unset($sf["Server Admin"]["Usage"]);foreach($sf["Tables"]as$x=>$X)unset($sf["Databases"][$x]);$ie=array();if($_POST){foreach($_POST["objects"]as$x=>$X)$ie[$X]=(array)$ie[$X]+(array)$_POST["grants"][$x];}$Pc=array();$ve="";if(isset($_GET["host"])&&($J=$f->query("SHOW GRANTS FOR ".q($fa)."@".q($_GET["host"])))){while($L=$J->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$L[0],$B)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$B[1],$C,PREG_SET_ORDER)){foreach($C
as$X){if($X[1]!="USAGE")$Pc["$B[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$L[0]))$Pc["$B[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$L[0],$B))$ve=$B[1];}}if($_POST&&!$l){$we=(isset($_GET["host"])?q($fa)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $we",ME."privileges=",lang(219));else{$ke=q($_POST["user"])."@".q($_POST["host"]);$bf=$_POST["pass"];if($bf!=''&&!$_POST["hashed"]&&!min_version(8)){$bf=$f->result("SELECT PASSWORD(".q($bf).")");$l=!$bf;}$pb=false;if(!$l){if($we!=$ke){$pb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $ke IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($bf));$l=!$pb;}elseif($bf!=$ve)queries("SET PASSWORD FOR $ke = ".q($bf));}if(!$l){$Kf=array();foreach($ie
as$qe=>$Oc){if(isset($_GET["grant"]))$Oc=array_filter($Oc);$Oc=array_keys($Oc);if(isset($_GET["grant"]))$Kf=array_diff(array_keys(array_filter($ie[$qe],'strlen')),$Oc);elseif($we==$ke){$te=array_keys((array)$Pc[$qe]);$Kf=array_diff($te,$Oc);$Oc=array_diff($Oc,$te);unset($Pc[$qe]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$qe,$B)&&(!grant("REVOKE",$Kf,$B[2]," ON $B[1] FROM $ke")||!grant("GRANT",$Oc,$B[2]," ON $B[1] TO $ke"))){$l=true;break;}}}if(!$l&&isset($_GET["host"])){if($we!=$ke)queries("DROP USER $we");elseif(!isset($_GET["grant"])){foreach($Pc
as$qe=>$Kf){if(preg_match('~^(.+)(\(.*\))?$~U',$qe,$B))grant("REVOKE",array_keys($Kf),$B[2]," ON $B[1] FROM $ke");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(220):lang(221)),!$l);if($pb)$f->query("DROP USER $ke");}}page_header((isset($_GET["host"])?lang(24).": ".h("$fa@$_GET[host]"):lang(138)),$l,array("privileges"=>array('',lang(60))));if($_POST){$L=$_POST;$Pc=$ie;}else{$L=$_GET+array("host"=>$f->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$L["pass"]=$ve;if($ve!="")$L["hashed"]=true;$Pc[(DB==""||$Pc?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(23),'<td><input name="host" data-maxlength="60" value="',h($L["host"]),'" autocapitalize="off">
<tr><th>',lang(24),'<td><input name="user" data-maxlength="80" value="',h($L["user"]),'" autocapitalize="off">
<tr><th>',lang(25),'<td><input name="pass" id="pass" value="',h($L["pass"]),'" autocomplete="new-password">
';if(!$L["hashed"])echo
script("typePassword(qs('#pass'));");echo(min_version(8)?"":checkbox("hashed",1,$L["hashed"],lang(222),"typePassword(this.form['pass'], this.checked);")),'</table>

';echo"<table cellspacing='0'>\n","<thead><tr><th colspan='2'>".lang(60).doc_link(array('sql'=>"grant.html#priv_level"));$r=0;foreach($Pc
as$qe=>$Oc){echo'<th>'.($qe!="*.*"?"<input name='objects[$r]' value='".h($qe)."' size='10' autocapitalize='off'>":"<input type='hidden' name='objects[$r]' value='*.*' size='10'>*.*");$r++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(23),"Databases"=>lang(26),"Tables"=>lang(123),"Columns"=>lang(38),"Procedures"=>lang(223),)as$lb=>$Ib){foreach((array)$sf[$lb]as$rf=>$db){echo"<tr".odd()."><td".($Ib?">$Ib<td":" colspan='2'").' lang="en" title="'.h($db).'">'.h($rf);$r=0;foreach($Pc
as$qe=>$Oc){$E="'grants[$r][".h(strtoupper($rf))."]'";$Y=$Oc[strtoupper($rf)];if($lb=="Server Admin"&&$qe!=(isset($Pc["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$E><option><option value='1'".($Y?" selected":"").">".lang(224)."<option value='0'".($Y=="0"?" selected":"").">".lang(225)."</select>";else{echo"<td align='center'><label class='block'>","<input type='checkbox' name=$E value='1'".($Y?" checked":"").($rf=="All privileges"?" id='grants-$r-all'>":">".($rf=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$r-all'); };"))),"</label>";}$r++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"])){echo'<input type="submit" name="drop" value="',lang(120),'">',confirm(lang(167,"$fa@$_GET[host]"));}echo'<input type="hidden" name="token" value="',$T,'">
</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$l){$zd=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$zd++;}queries_redirect(ME."processlist=",lang(226,$zd),$zd||!$_POST["kill"]);}}page_header(lang(109),$l);echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap checkable">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$r=-1;foreach(process_list()as$r=>$L){if(!$r){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($L
as$x=>$X)echo"<th>$x".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($x),));echo"</thead>\n";}echo"<tr".odd().">".(support("kill")?"<td>".checkbox("kill[]",$L[$w=="sql"?"Id":"pid"],0):"");foreach($L
as$x=>$X)echo"<td>".(($w=="sql"&&$x=="Info"&&preg_match("~Query|Killed~",$L["Command"])&&$X!="")||($w=="pgsql"&&$x=="current_query"&&$X!="<IDLE>")||($w=="oracle"&&$x=="sql_text"&&$X!="")?"<code class='jush-$w'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($L["db"]!=""?"db=".urlencode($L["db"])."&":"")."sql=".urlencode($X)).'">'.lang(227).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill")){echo($r+1)."/".lang(228,max_connections()),"<p><input type='submit' value='".lang(229)."'>\n";}echo'<input type="hidden" name="token" value="',$T,'">
</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$R=table_status1($a);$v=indexes($a);$n=fields($a);$Hc=column_foreign_keys($a);$se=$R["Oid"];parse_str($_COOKIE["adminer_import"],$oa);$Lf=array();$d=array();$Ng=null;foreach($n
as$x=>$m){$E=$b->fieldName($m);if(isset($m["privileges"]["select"])&&$E!=""){$d[$x]=html_entity_decode(strip_tags($E),ENT_QUOTES);if(is_shortable($m))$Ng=$b->selectLengthProcess();}$Lf+=$m["privileges"];}list($N,$Qc)=$b->selectColumnsProcess($d,$v);$sd=count($Qc)<count($N)||strstr($N[0],"DISTINCT");$Z=$b->selectSearchProcess($n,$v);$Ge=$b->selectOrderProcess($n,$v);$y=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$mh=>$L){$wa=convert_field($n[key($L)]);$N=array($wa?$wa:idf_escape(key($L)));$Z[]=where_check($mh,$n);$K=$k->select($a,$N,$Z,$N);if($K)echo
reset($K->fetch_row());}exit;}$of=$oh=null;foreach($v
as$u){if($u["type"]=="PRIMARY"){$of=array_flip($u["columns"]);$oh=($N?$of:array());foreach($oh
as$x=>$X){if(in_array(idf_escape($x),$N))unset($oh[$x]);}break;}}if($se&&!$of){$of=$oh=array($se=>0);$v[]=array("type"=>"PRIMARY","columns"=>array($se));}if($_POST&&!$l){$Jh=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Qa=array();foreach($_POST["check"]as$Oa)$Qa[]=where_check($Oa,$n);$Jh[]="((".implode(") OR (",$Qa)."))";}$Jh=($Jh?"\nWHERE ".implode(" AND ",$Jh):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$Lc=($N?implode(", ",$N):"*").convert_fields($d,$n,$N)."\nFROM ".table($a);$Sc=($Qc&&$sd?"\nGROUP BY ".implode(", ",$Qc):"").($Ge?"\nORDER BY ".implode(", ",$Ge):"");if(!is_array($_POST["check"])||$of)$I="SELECT $Lc$Jh$Sc";else{$kh=array();foreach($_POST["check"]as$X)$kh[]="(SELECT".limit($Lc,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n).$Sc,1).")";$I=implode(" UNION ALL ",$kh);}$b->dumpData($a,"table",$I);exit;}if(!$b->selectEmailProcess($Z,$Hc)){if($_POST["save"]||$_POST["delete"]){$J=true;$pa=0;$P=array();if(!$_POST["delete"]){foreach($d
as$E=>$X){$X=process_input($n[$E]);if($X!==null&&($_POST["clone"]||$X!==false))$P[idf_escape($E)]=($X!==false?$X:idf_escape($E));}}if($_POST["delete"]||$P){if($_POST["clone"])$I="INTO ".table($a)." (".implode(", ",array_keys($P)).")\nSELECT ".implode(", ",$P)."\nFROM ".table($a);if($_POST["all"]||($of&&is_array($_POST["check"]))||$sd){$J=($_POST["delete"]?$k->delete($a,$Jh):($_POST["clone"]?queries("INSERT $I$Jh"):$k->update($a,$P,$Jh)));$pa=$f->affected_rows;}else{foreach((array)$_POST["check"]as$X){$Ih="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$n);$J=($_POST["delete"]?$k->delete($a,$Ih,1):($_POST["clone"]?queries("INSERT".limit1($a,$I,$Ih)):$k->update($a,$P,$Ih,1)));if(!$J)break;$pa+=$f->affected_rows;}}}$D=lang(230,$pa);if($_POST["clone"]&&$J&&$pa==1){$Ed=last_id();if($Ed)$D=lang(160," $Ed");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$D,$J);if(!$_POST["delete"]){edit_form($a,$n,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$l=lang(231);else{$J=true;$pa=0;foreach($_POST["val"]as$mh=>$L){$P=array();foreach($L
as$x=>$X){$x=bracket_escape($x,1);$P[idf_escape($x)]=(preg_match('~char|text~',$n[$x]["type"])||$X!=""?$b->processInput($n[$x],$X):"NULL");}$J=$k->update($a,$P," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($mh,$n),!$sd&&!$of," ");if(!$J)break;$pa+=$f->affected_rows;}queries_redirect(remove_from_uri(),lang(230,$pa),$J);}}elseif(!is_string($zc=get_file("csv_file",true)))$l=upload_error($zc);elseif(!preg_match('~~u',$zc))$l=lang(232);else{cookie("adminer_import","output=".urlencode($oa["output"])."&format=".urlencode($_POST["separator"]));$J=true;$ab=array_keys($n);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$zc,$C);$pa=count($C[0]);$k->begin();$Zf=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$M=array();foreach($C[0]as$x=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$Zf]*)$Zf~",$X.$Zf,$Rd);if(!$x&&!array_diff($Rd[1],$ab)){$ab=$Rd[1];$pa--;}else{$P=array();foreach($Rd[1]as$r=>$Wa)$P[idf_escape($ab[$r])]=($Wa==""&&$n[$ab[$r]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$Wa))));$M[]=$P;}}$J=(!$M||$k->insertUpdate($a,$M,$of));if($J)$J=$k->commit();queries_redirect(remove_from_uri("page"),lang(233,$pa),$J);$k->rollback();}}}$Bg=$b->tableName($R);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(43).": $Bg",$l);$P=null;if(isset($Lf["insert"])||!support("table")){$P="";foreach((array)$_GET["where"]as$X){if($Hc[$X["col"]]&&count($Hc[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$P.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$b->selectLinks($R,$P);if(!$d&&support("table"))echo"<p class='error'>".lang(234).($n?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">','<input type="submit" value="'.h(lang(43)).'">';echo"</div>\n";$b->selectColumnsPrint($N,$d);$b->selectSearchPrint($Z,$d,$v);$b->selectOrderPrint($Ge,$d,$v);$b->selectLimitPrint($y);$b->selectLengthPrint($Ng);$b->selectActionPrint($v);echo"</form>\n";$F=$_GET["page"];if($F=="last"){$Kc=$f->result(count_rows($a,$Z,$sd,$Qc));$F=floor(max(0,$Kc-1)/$y);}$Uf=$N;$Rc=$Qc;if(!$Uf){$Uf[]="*";$mb=convert_fields($d,$n,$N);if($mb)$Uf[]=substr($mb,2);}foreach($N
as$x=>$X){$m=$n[idf_unescape($X)];if($m&&($wa=convert_field($m)))$Uf[$x]="$wa AS $X";}if(!$sd&&$oh){foreach($oh
as$x=>$X){$Uf[]=idf_escape($x);if($Rc)$Rc[]=idf_escape($x);}}$J=$k->select($a,$Uf,$Z,$Rc,$Ge,$y,$F,true);if(!$J)echo"<p class='error'>".error()."\n";else{if($w=="mssql"&&$F)$J->seek($y*$F);$cc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$M=array();while($L=$J->fetch_assoc()){if($F&&$w=="oracle")unset($L["RNUM"]);$M[]=$L;}if($_GET["page"]!="last"&&$y!=""&&$Qc&&$sd&&$w=="sql")$Kc=$f->result(" SELECT FOUND_ROWS()");if(!$M)echo"<p class='message'>".lang(12)."\n";else{$Da=$b->backwardKeys($a,$Bg);echo"<div class='scrollable'>","<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$Qc&&$N?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."' title='".lang(235)."' class='edit-all'>".lang(235)."</a>");$he=array();$Mc=array();reset($N);$zf=1;foreach($M[0]as$x=>$X){if(!isset($oh[$x])){$X=$_GET["columns"][key($N)]??null;$m=$n[$N?($X?$X["col"]:current($N)):$x];$E=($m?$b->fieldName($m,$zf):($X["fun"]?"*":$x));if($E!=""){$zf++;$he[$x]=$E;$c=idf_escape($x);$ed=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($x);$Ib="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($x))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($ed.($Ge[0]==$c||$Ge[0]==$x||(!$Ge&&$sd&&$Qc[0]==$c)?$Ib:'')).'">';echo
apply_sql_function($X["fun"]??null,$E)."</a>";echo"<span class='column hidden'>","<a href='".h($ed.$Ib)."' title='".lang(50)."' class='text'> ↓</a>";if(isset($X["fun"])===false){echo'<a href="#fieldset-search" title="'.lang(47).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($x)."');");}echo"</span>";}$Mc[$x]=$X["fun"]??null;next($N);}}$Kd=array();if($_GET["modify"]){foreach($M
as$L){foreach($L
as$x=>$X)$Kd[$x]=max($Kd[$x],min(40,strlen(utf8_decode($X))));}}echo($Da?"<th>".lang(236):"")."</thead>\n";if(is_ajax()){if($y%2==1&&$F%2==1)odd();ob_end_clean();}foreach($b->rowDescriptions($M,$Hc)as$ge=>$L){$lh=unique_array($M[$ge],$v);if(!$lh){$lh=array();foreach($M[$ge]as$x=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$x))$lh[$x]=$X;}}$mh="";foreach($lh
as$x=>$X){if(($w=="sql"||$w=="pgsql")&&preg_match('~char|text|enum|set~',$n[$x]["type"])&&strlen($X)>64){$x=(strpos($x,'(')?$x:idf_escape($x));$x="MD5(".($w!='sql'||preg_match("~^utf8~",$n[$x]["collation"])?$x:"CONVERT($x USING ".charset($f).")").")";$X=md5($X);}$mh.="&".($X!==null?urlencode("where[".bracket_escape($x)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($x));}echo"<tr".odd().">".(!$Qc&&$N?"":"<td>".checkbox("check[]",substr($mh,1),in_array(substr($mh,1),(array)$_POST["check"])).($sd||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$mh)."' class='edit' title='".lang(237)."'>".lang(237)."</a>"));foreach($L
as$x=>$X){if(isset($he[$x])){$m=$n[$x];$X=$k->value($X,$m);if($X!=""&&(!isset($cc[$x])||$cc[$x]!=""))$cc[$x]=(is_mail($X)?$he[$x]:"");$z="";if(preg_match('~blob|bytea|raw|file~',$m["type"]??null)&&$X!="")$z=ME.'download='.urlencode($a).'&field='.urlencode($x).$mh;if(!$z&&$X!==null){foreach((array)$Hc[$x]as$o){if(count($Hc[$x])==1||end($o["source"])==$x){$z="";foreach($o["source"]as$r=>$jg)$z.=where_link($r,$o["target"][$r],$M[$ge][$jg]);$z=($o["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($o["db"]),ME):ME).'select='.urlencode($o["table"]).$z;if($o["ns"])$z=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($o["ns"]),$z);if(count($o["source"])==1)break;}}}if($x=="COUNT(*)"){$z=ME."select=".urlencode($a);$r=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$lh))$z.=where_link($r++,$W["col"],$W["val"],$W["op"]);}foreach($lh
as$wd=>$W)$z.=where_link($r++,$wd,$W);}$X=select_value($X,$z,$m,$Ng);$s=h("val[$mh][".bracket_escape($x)."]");$Y=null;if(isset($_POST["val"][$mh][bracket_escape($x)]))$_POST["val"][$mh][bracket_escape($x)];$Xb=!is_array($L[$x])&&is_utf8($X)&&$M[$ge][$x]==$L[$x]&&!$Mc[$x];$Mg=preg_match('~text|lob~',$m["type"]??null);echo"<td id='$s'";if(($_GET["modify"]&&$Xb)||$Y!==null){$Vc=h($Y!==null?$Y:$L[$x]);echo">".($Mg?"<textarea name='$s' cols='30' rows='".(substr_count($L[$x],"\n")+1)."'>$Vc</textarea>":"<input name='$s' value='$Vc' size='$Kd[$x]'>");}else{$Od=strpos($X,"<i>…</i>");echo" data-text='".($Od?2:($Mg?1:0))."'".($Xb?"":" data-warning='".h(lang(238))."'").">$X</td>";}}}if($Da)echo"<td>";$b->backwardKeysPrint($Da,$M[$ge]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($M||$F){$nc=true;if($_GET["page"]!="last"){if($y==""||(count($M)<$y&&($M||!$F)))$Kc=($F?$F*$y:0)+count($M);elseif($w!="sql"||!$sd){$Kc=($sd?false:found_rows($R,$Z));if($Kc<max(1e4,2*($F+1)*$y))$Kc=reset(slow_query(count_rows($a,$Z,$sd,$Qc)));else$nc=false;}}$Se=($y!=""&&($Kc===false||$Kc>$y||$F));if($Se){echo(($Kc===false?count($M)+1:$Kc-$F*$y)>$y?'<p><a href="'.h(remove_from_uri("page")."&page=".($F+1)).'" class="loadmore">'.lang(239).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$y).", '".lang(240)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($M||$F){if($Se){$Td=($Kc===false?$F+(count($M)>=$y?2:1):floor(($Kc-1)/$y));echo"<fieldset>";if($w!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(241)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(241)."', '".($F+1)."')); return false; };"),pagination(0,$F).($F>5?" …":"");for($r=max(1,$F-4);$r<min($Td,$F+5);$r++)echo
pagination($r,$F);if($Td>0){echo($F+5<$Td?" …":""),($nc&&$Kc!==false?pagination($Td,$F):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Td'>".lang(242)."</a>");}}else{echo"<legend>".lang(241)."</legend>",pagination(0,$F).($F>1?" …":""),($F?pagination($F,$F):""),($Td>$F?pagination($F+1,$F).($Td>$F+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(243)."</legend>";$Nb=($nc?"":"~ ").$Kc;echo
checkbox("all",1,0,($Kc!==false?($nc?"":"~ ").lang(142,$Kc):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Nb' : checked); selectCount('selected2', this.checked || !checked ? '$Nb' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(235),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(231).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(119),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(227),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$Ic=$b->dumpFormat();foreach((array)$_GET["columns"]as$c){if($c["fun"]){unset($Ic['sql']);break;}}if($Ic){print_fieldset("export",lang(63)." <span id='selected2'></span>");$Qe=$b->dumpOutput();echo($Qe?html_select("output",$Qe,$oa["output"])." ":""),html_select("format",$Ic,$oa["format"])," <input type='submit' name='export' value='".lang(63)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($cc,'strlen'),$d);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(62)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$oa["format"],1);echo" <input type='submit' name='import' value='".lang(62)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$T'>\n","</form>\n",(!$Qc&&$N?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$qg=isset($_GET["status"]);page_header($qg?lang(111):lang(110));$_h=($qg?show_status():show_variables());if(!$_h)echo"<p class='message'>".lang(12)."\n";else{echo"<table cellspacing='0'>\n";foreach($_h
as$x=>$X){echo"<tr>","<th><code class='jush-".$w.($qg?"status":"set")."'>".h($x)."</code>","<td>".h($X);}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$zg=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$E=>$R){json_row("Comment-$E",h($R["Comment"]));if(!is_view($R)){foreach(array("Engine","Collation")as$x)json_row("$x-$E",h($R[$x]));foreach($zg+array("Auto_increment"=>0,"Rows"=>0)as$x=>$X){if($R[$x]!=""){$X=format_number($R[$x]);json_row("$x-$E",($x=="Rows"&&$X&&$R["Engine"]==($w=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($zg[$x]))$zg[$x]+=($R["Engine"]!="InnoDB"||$x!="Data_free"?$R[$x]:0);}elseif(array_key_exists($x,$R))json_row("$x-$E");}}}foreach($zg
as$x=>$X)json_row("sum-$x",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$f->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$j=>$X){json_row("tables-$j",$X);json_row("size-$j",db_size($j));}json_row("");}exit;}else{$Gg=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Gg&&!$l&&!$_POST["search"]){$J=true;$D="";if($w=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$J=truncate_tables($_POST["tables"]);$D=lang(244);}elseif($_POST["move"]){$J=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$D=lang(245);}elseif($_POST["copy"]){$J=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$D=lang(246);}elseif($_POST["drop"]){if($_POST["views"])$J=drop_views($_POST["views"]);if($J&&$_POST["tables"])$J=drop_tables($_POST["tables"]);$D=lang(247);}elseif($w!="sql"){$J=($w=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$D=lang(248);}elseif(!$_POST["tables"])$D=lang(9);elseif($J=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('idf_escape',$_POST["tables"])))){while($L=$J->fetch_assoc())$D.="<b>".h($L["Table"])."</b>: ".h($L["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$D,$J);}page_header(($_GET["ns"]==""?lang(26).": ".h(DB):lang(188).": ".h($_GET["ns"])),$l,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(249)."</h3>\n";$Fg=tables_list();if(!$Fg)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(250)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(47)."'>\n";if($b->operator_regexp!==null){echo"<p><label><input type='checkbox' name='regexp' value='1'".(empty($_POST['regexp'])?'':' checked').'>'.lang(251).'</label>',doc_link(array('sql'=>'regexp.html',))."</p>\n";}echo"</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$b->operator_regexp===null||empty($_POST['regexp'])?"LIKE %%":$b->operator_regexp;search_tables();}}echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(123),'<td>'.lang(252).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(115).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(253).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(254).doc_link(array('sql'=>'show-table-status.html',)),'<td>'.lang(255).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(41).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(256).doc_link(array('sql'=>'show-table-status.html',)),(support("comment")?'<td>'.lang(40).doc_link(array('sql'=>'show-table-status.html',)):''),"</thead>\n";$S=0;foreach($Fg
as$E=>$U){$Ch=($U!==null&&!preg_match('~table|sequence~i',$U));$s=h("Table-".$E);echo'<tr'.odd().'><td>'.checkbox(($Ch?"views[]":"tables[]"),$E,in_array($E,$Gg,true),"","","",$s),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($E)."' title='".lang(31)."' id='$s'>".h($E).'</a>':h($E));if($Ch){echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($E).'" title="'.lang(32).'">'.(preg_match('~materialized~i',$U)?lang(121):lang(122)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($E).'" title="'.lang(30).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(33)),"Index_length"=>array("indexes",lang(125)),"Data_free"=>array("edit",lang(34)),"Auto_increment"=>array("auto_increment=1&create",lang(33)),"Rows"=>array("select",lang(30)),)as$x=>$z){$s=" id='$x-".h($E)."'";echo($z?"<td align='right'>".(support("table")||$x=="Rows"||(support("indexes")&&$x!="Data_length")?"<a href='".h(ME."$z[0]=").urlencode($E)."'$s title='$z[1]'>?</a>":"<span$s>?</span>"):"<td id='$x-".h($E)."'>");}$S++;}echo(support("comment")?"<td id='Comment-".h($E)."'>":"");}echo"<tr><td><th>".lang(228,count($Fg)),"<td>".h($w=="sql"?$f->result("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$x)echo"<td align='right' id='sum-$x'>";echo"</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$yh="<input type='submit' value='".lang(257)."'> ".on_help("'VACUUM'");$De="<input type='submit' name='optimize' value='".lang(258)."'> ".on_help($w=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(119)." <span id='selected'></span></legend><div>".($w=="sqlite"?$yh:($w=="pgsql"?$yh.$De:($w=="sql"?"<input type='submit' value='".lang(259)."'> ".on_help("'ANALYZE TABLE'").$De."<input type='submit' name='check' value='".lang(260)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(261)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(262)."'> ".on_help($w=="sqlite"?"'DELETE'":"'TRUNCATE".($w=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(120)."'>".on_help("'DROP TABLE'").confirm()."\n";$i=(support("scheme")?$b->schemas():$b->databases());if(count($i)!=1&&$w!="sqlite"){$j=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(263).": ",($i?html_select("target",$i,$j):'<input name="target" value="'.h($j).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(264)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(265)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(266)):""),"\n";}echo"<input type='hidden' name='all' value=''>";echo
script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $S);":"")." }"),"<input type='hidden' name='token' value='$T'>\n","</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}$_=[];$_[]="<a href='".h(ME)."create='>".lang(64)."</a>";if(support("view"))$_[]="<a href='".h(ME)."view='>".lang(194)."</a>";echo
generate_linksbar($_);if(support("routine")){echo"<h3 id='routines'>".lang(135)."</h3>\n";$Pf=routines();if($Pf){echo"<table cellspacing='0'>\n",'<thead><tr><th>'.lang(175).'<td>'.lang(39).'<td>'.lang(211)."<td></thead>\n";odd('');foreach($Pf
as$L){$E=($L["SPECIFIC_NAME"]==$L["ROUTINE_NAME"]?"":"&name=".urlencode($L["ROUTINE_NAME"]));echo'<tr'.odd().'>','<th><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($L["SPECIFIC_NAME"]).$E).'">'.h($L["ROUTINE_NAME"]).'</a>','<td>'.h($L["ROUTINE_TYPE"]),'<td>'.h($L["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($L["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($L["SPECIFIC_NAME"]).$E).'">'.lang(128)."</a>";}echo"</table>\n";}$_=[];if(support('procedure'))$_[]="<a href='".h(ME)."procedure='>".lang(210)."</a>";$_[]="<a href='".h(ME)."function='>".lang(209)."</a>";echo
generate_linksbar($_);}if(support("event")){echo"<h3 id='events'>".lang(136)."</h3>\n";$M=get_rows("SHOW EVENTS");if($M){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(175)."<td>".lang(267)."<td>".lang(200)."<td>".lang(201)."<td></thead>\n";foreach($M
as$L){echo"<tr>","<th>".h($L["Name"]),"<td>".($L["Execute at"]?lang(268)."<td>".$L["Execute at"]:lang(202)." ".$L["Interval value"]." ".$L["Interval field"]."<td>$L[Starts]"),"<td>$L[Ends]",'<td><a href="'.h(ME).'event='.urlencode($L["Name"]).'">'.lang(128).'</a>';}echo"</table>\n";$lc=$f->result("SELECT @@event_scheduler");if($lc&&$lc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($lc)."\n";}echo
generate_linksbar(["<a href='".h(ME)."event='>".lang(199)."</a>"]);}if($Fg)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();